#q02b_implantacion_75874.sh
#
#Esta versin accede mediante LDAP.
#****************************************
#

echo "****************************************"
echo "* MODIFICACION DE LA BASE DE DATOS q02b *"
echo "****************************************"

#************************************************************
# OBTENER USUARIO Y PASSWORD DE CONEXION A LA BASE DE DATOS
#************************************************************

. n38bd 32307 01 STRING
salida=$?
if [ "salida" -gt 0 ]; then
echo "Error al obtener los parametros de conexion"
exit 1
fi

USUARIO=`echo $STRING |cut -d '#' -f2`
PASSWORD=`echo $STRING |cut -d '#' -f3` 


#**************************************
#Localizacion de ficheros 
#
DIR_CADE=/aplic/q02b/cade
DIR_SCRIPTS=/aplic/q02b/scripts
DIR_LOG=/datos/q02b/log
#
#******************************************
# VERIFICACION DE LA EXISTENCIA DE FICHEROS
#******************************************
#
#
FICHERO=${DIR_SCRIPTS}/fichero_funciones_75874.sql
test -f ${FICHERO}
if [ "${?}" -ne 0 ]; then
echo"No existe el fichero ${FICHERO}"
echo"Operacion Cancelada"
echo "Falta fichero necesario para el lanzamiento de la implantacion. Reponer fichero."
echo "*******************************************"
echo "NO ES NECESARIO RESTAURAR LA COPIA DE BBDD."
echo "*******************************************"
exit 1
fi
#
FICHERO=${DIR_SCRIPTS}/fichero_procesos_75874.sql
test -f ${FICHERO}
if [ "${?}" -ne 0 ]; then
echo"No existe el fichero ${FICHERO}"
echo"Operacion Cancelada"
echo "Falta fichero necesario para el lanzamiento de la implantacion. Reponer fichero."
echo "*******************************************"
echo "NO ES NECESARIO RESTAURAR LA COPIA DE BBDD."
echo "*******************************************"
exit 1
fi
#
FICHERO=${DIR_SCRIPTS}/fichero_packages_75874.sql
test -f ${FICHERO}
if [ "${?}" -ne 0 ]; then
echo"No existe el fichero ${FICHERO}"
echo"Operacion Cancelada"
echo "Falta fichero necesario para el lanzamiento de la implantacion. Reponer fichero."
echo "*******************************************"
echo "NO ES NECESARIO RESTAURAR LA COPIA DE BBDD."
echo "*******************************************"
exit 1
fi
#
FICHERO=${DIR_SCRIPTS}/fichero_scripts_75874.sql
test -f ${FICHERO}
if [ "${?}" -ne 0 ]; then
echo"No existe el fichero ${FICHERO}"
echo"Operacion Cancelada"
echo "Falta fichero necesario para el lanzamiento de la implantacion. Reponer fichero."
echo "*******************************************"
echo "NO ES NECESARIO RESTAURAR LA COPIA DE BBDD."
echo "*******************************************"
exit 1
fi
#
#************************************************
# BORRAMOS EL FICHERO LOG EN CASO DE QUE EXISTA
#************************************************
#
LOG=${DIR_LOG}/q02b_implantacion_75874.log
#
test -f ${LOG}
if [ ${?} -ne 0 ]; then
ls *.* > /dev/null
else
rm $LOG > /dev/null
fi
#
#****************************************************
# EJECUTAMOS LOS SCRIPtS
#****************************************************
#
set SQLSTATUS = 0

#Verificamos la existencia de los ficheros correspondientes a funciones

FICHERO=${DIR_SCRIPTS}/fichero_funciones_75874.sql
cat ${FICHERO} | while read linea
do
test -f ${DIR_SCRIPTS}/${linea}.sql
if [ "${?}" -ne 0 ]; then
		echo "NO EXISTE EL FICHERO ${DIR_SCRIPTS}/${linea}.sql"
		echo "NO EXISTE EL FICHERO ${DIR_SCRIPTS}/${linea}.sql" >>$DIR_SCRIPTS/ficheros_con_errores.err
		echo "No se comprobaron los demas ficheros de funciones"
		#si quisieramos que nos sealara todos los que no existen habria que quitar el exit
		echo "Falta fichero necesario para el lanzamiento de la implantacion. Reponer fichero."
		echo "*******************************************"
		echo "NO ES NECESARIO RESTAURAR LA COPIA DE BBDD."
		echo "*******************************************"
		exit 1
	fi
done

#Verificamos la existencia de los ficheros correspondientes a procesos

FICHERO=${DIR_SCRIPTS}/fichero_procesos_75874.sql
cat ${FICHERO} | while read linea
do
	test -f ${DIR_SCRIPTS}/${linea}.sql
	if [ "${?}" -ne 0 ]; then
		echo "NO EXISTE EL FICHERO ${DIR_SCRIPTS}/${linea}.sql"
		echo "NO EXISTE EL FICHERO ${DIR_SCRIPTS}/${linea}.sql" >>$DIR_SCRIPTS/ficheros_con_errores.err
		echo "No se comprobaron los demas ficheros de procesos"

		#si quisieramos que nos sealara todos los que no existen habria que quitar el exit
		echo "Falta fichero necesario para el lanzamiento de la implantacion. Reponer fichero."
		echo "*******************************************"
		echo "NO ES NECESARIO RESTAURAR LA COPIA DE BBDD."
		echo "*******************************************"
		exit 1
	fi
done

#Verificamos la existencia de los ficheros correspondientes a packages

FICHERO=${DIR_SCRIPTS}/fichero_packages_75874.sql
cat ${FICHERO} | while read linea
do
	test -f ${DIR_SCRIPTS}/${linea}.sql
	if [ "${?}" -ne 0 ]; then
		echo "NO EXISTE EL FICHERO ${DIR_SCRIPTS}/${linea}.sql"
		echo "NO EXISTE EL FICHERO ${DIR_SCRIPTS}/${linea}.sql" >>$DIR_SCRIPTS/ficheros_con_errores.err
		echo "No se comprobaron los demas ficheros de packages"

		#si quisieramos que nos sealara todos los que no existen habria que quitar el exit
		echo "Falta fichero necesario para el lanzamiento de la implantacion. Reponer fichero."
		echo "*******************************************"
		echo "NO ES NECESARIO RESTAURAR LA COPIA DE BBDD."
		echo "*******************************************"
		exit 1
	fi
done



#Verificamos la existencia de los ficheros de scripts y ejecutamos


FICHERO=${DIR_SCRIPTS}/fichero_scripts_75874.sql


cat ${FICHERO} | while read linea
do
	test -f ${DIR_SCRIPTS}/${linea}.sql
	if [ "${?}" -ne 0 ]; then
		echo "NO EXISTE EL FICHERO ${DIR_SCRIPTS}/${linea}.sql"
		echo "Operacion cancelada"
		echo "Falta fichero necesario para el lanzamiento de la implantacion. Reponer fichero."
		echo "*******************************************"
		echo "NO ES NECESARIO RESTAURAR LA COPIA DE BBDD."
		echo "*******************************************"
		exit 1
	fi
	sqlplus $USUARIO/$PASSWORD @${DIR_SCRIPTS}/${linea}.sql >/dev/null
	if [ "${?}" -ne 0 ]; then
		SQLSTATUS=98
		echo "Error en el fichero:${DIR_SCRIPTS}/${linea}.sql\n"
		echo "Error en el fichero:${DIR_SCRIPTS}/${linea}.sql\n" >>$DIR_SCRIPTS/ficheros_con_errores.err
	fi
	FICHEROLST=${DIR_SCRIPTS}/${linea}.lst
	grep "Procedure created with compilation errors" $FICHEROLST
	if [ "${?}" = 0 ]; then
		SQLSTATUS=98
		echo "Error en el fichero:${DIR_SCRIPTS}/${linea}.sql\n"
		echo "Error en el fichero:${DIR_SCRIPTS}/${linea}.sql\n" >>$DIR_SCRIPTS/ficheros_con_errores.err
	fi
	grep "Function created with compilation errors" $FICHEROLST
	if [ "${?}" = 0 ]; then
		SQLSTATUS=98
		echo "Error en el fichero:${DIR_SCRIPTS}/${linea}.sql\n"
		echo "Error en el fichero:${DIR_SCRIPTS}/${linea}.sql\n" >>$DIR_SCRIPTS/ficheros_con_errores.err
	fi
	grep "unable to open file" $FICHEROLST
	if [ "${?}" = 0 ]; then
		SQLSTATUS=98
		echo "Error en el fichero:${DIR_SCRIPTS}/${linea}.sql\n"
		echo "Error en el fichero:${DIR_SCRIPTS}/${linea}.sql\n" >>$DIR_SCRIPTS/ficheros_con_errores.err
	fi

done


#****************************************************************************
# UNIFICAMOS LOS ".LST" EN ".LOG" al cual se le aade el contenido del ".err"
#****************************************************************************
#

FICHERO_ERR=${DIR_SCRIPTS}/ficheros_con_errores.err
	echo "************ Inicio ficheros con errores*************" >>$LOG
	test -f ${FICHERO_ERR}
	if [ ${?} -ne 0 ]; then
		ls *.* > /dev/null
	else
		more $FICHERO_ERR >>$LOG
		rm $FICHERO_ERR 
	fi
	echo "************* Fin ficheros con errores***************" >>$LOG
#
FICHERO=${DIR_SCRIPTS}/fichero_scripts_75874.sql
cat ${FICHERO} | while read linea1
do
	LST=${DIR_SCRIPTS}/${linea1}.lst
	test -f ${LST}
	if [ ${?} -ne 0 ]; then
		ls *.* > /dev/null
	else
		more $LST >>$LOG
		rm $LST 
	fi
done
if [ "${SQLSTATUS}" -ne 0 ]; then

	echo "**************************"
	echo "*    CREACION ERRONEA    *"
	echo "**************************"
	cat $LOG
	exit 1	
else
	echo "**************************"
	echo "*    CREACION CORRECTA   *"
	echo "**************************"
	cat $LOG	
fi
