APP=q02b
APPU=Q02B
LDAP1=32307
LDAP2=01
PROMO=0009
#*****************
# PANTALLA INICIAL
#*****************
echo "*******************************************"
echo "BASE DE DATOS ${APPU} - PROMOCION ${PROMO} "
echo "*******************************************"
# 
#***************************************************************
# OBTENCION DE USUARIO Y PASSWORD DE CONEXION A LA BASE DE DATOS
#***************************************************************
. n38bd ${LDAP1} ${LDAP2} STRING
SALIDA=$?
if [ $SALIDA -gt 0 ]
then
  echo "ERROR obtenido parmetros de conexin"
   exit 1
fi
USUARIO=`echo $STRING |cut -d '#' -f2`
PASSWORD=`echo $STRING |cut -d '#' -f3`
#ORACLE_SID=$ORACLE_SID
export ORACLE_SID
#ORACLE_HOME=$ORACLE_HOME
export ORACLE_HOME

# 
#******************************************
# VERIFICACION DE LA EXISTENCIA DE FICHEROS
#******************************************
#
DIR_CADE=/aplic/${APP}/cade
DIR_SCRIPTS=/aplic/${APP}/scripts/${PROMO}
DIR_LOG=/datos/${APP}/log
FICH_LOG=${DIR_LOG}/${APPU}_BBDD.log
FICH_SQL=${DIR_SCRIPTS}/${APP}_pre_${PROMO}.sql
#############################################  CHEQUEO FICHERO  ######################################################
test -f ${FICH_SQL}
if [ "${?}" -ne 0 ]; then
	echo "NO EXISTE EL FICHERO ${FICH_SQL}"
	echo "SE CANCELA LA OPERACION"
	exit
fi
#############################################   LANZAMIENTO   ######################################################
#
cd ${DIR_SCRIPTS}
{ echo ${PASSWORD};} | $ORACLE_HOME/bin/sqlplus $USUARIO @${FICH_SQL} | tee -a ${FICH_LOG} >/dev/null

if [ "${?}" -ne 0 ]; then 
    echo " *************************************************"
	echo "ERROR AL EJECUTAR ${FICH_SQL\n"
	echo "LA BASE DE DATOS NO ESTA PROMOCIONADA CORRECTAMENTE\n"
	echo "REVISAR FICHERO LOG ${FICH_LOG}\n"
	echo " *************************************************"
	exit
else
    echo " **************************************************"
	echo "BASE DE DATOS PROMOCIONADA CORRECTAMENTE \n"
	echo "REVISAR FICHERO LOG ${FICH_LOG}\n"
    echo " **************************************************"
fi
echo "FIN"