package q02a.validator;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.GenericValidator;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorUtil;
import org.apache.struts.action.ActionErrors;

import q02a.exe.arquitectura.dataobjects.Q02aDAOException;
import q02a.exe.utils.Q02aConstantes;
import q02a.exe.utils.Q02aFormatData;
import q02a.exe.utils.Q02aNILocator;
import es.ejie.frmk.infraestructura.logs.incidencias.Q70LogIncidencias;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.infraestructura.traza.Q70Traza;
import es.ejie.frmk.presentacion.validacion.Q70ValidacionGenericaException;
import es.ejie.frmk.presentacion.validacion.Q70ValidacionesCampo;

/**
 * 
 * @author GADIMAAR
 *
 */
public class Q02aValidacionesCampo extends Q70ValidacionesCampo{
	
	private static final long serialVersionUID = -7517191608276475271L;
	private static final String COMPONENTE = "VALIDACIONES_GEN";
    private static Q70Traza tr = Q70Traza.getSingleton();
    private static Q70LogIncidencias logInc = Q70LogIncidencias.getSingleton();
	
    /**
     * 
     *
     */
    public Q02aValidacionesCampo(){
    }

    /**
     * Compara que los elementos de la la listaComparable estn en la listaComparar
     * @param obj obj
     * @param validatorAction validatorAction
     * @param field field
     * @param actionErrors actionErrors
     * @param validator validator
     * @param httpServletRequest httpServletRequest
     * @return boolean
     */
	public static boolean validateCheckLists(Object obj, ValidatorAction validatorAction, Field field, ActionErrors actionErrors, Validator validator, HttpServletRequest httpServletRequest) {
		boolean result = true;
		/** Lista que queremos comparar */
		ArrayList listaComparable = null;
		/** Lista con la que vamos a comparar */
		ArrayList listaComparar = null;
    	
		String property = field.getVarValue("listaComparar");
		
		try{
			
			listaComparable = new ArrayList(Arrays.asList((String[])PropertyUtils.getProperty(obj,field.getProperty())));
			listaComparar = new ArrayList(Arrays.asList((String[])PropertyUtils.getProperty(obj,property)));
				
		}catch(IllegalAccessException iae){
			if(tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Excepci\363n al acceder a la propiedad");
            }
            if(logInc.isEnabled()){
                Q70ValidacionGenericaException q70validaciongenericaexception = new Q70ValidacionGenericaException((es.ejie.frmk.presentacion.validacion.Q70ValidacionesCampo.class).toString(), "getArgs", "Excepci\363n al recuperar mensajes del Gestor de Mensajes e Internacionalizaci\363n", iae);
                logInc.log(q70validaciongenericaexception, COMPONENTE, "ERROR");
            }
        }catch(InvocationTargetException ite){
        	if(tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Excepci\363n al llamar al mtodo");
            }
            if(logInc.isEnabled()){
                Q70ValidacionGenericaException q70validaciongenericaexception = new Q70ValidacionGenericaException((es.ejie.frmk.presentacion.validacion.Q70ValidacionesCampo.class).toString(), "getArgs", "Excepci\363n al recuperar mensajes del Gestor de Mensajes e Internacionalizaci\363n", ite);
                logInc.log(q70validaciongenericaexception, COMPONENTE, "ERROR");
            }
        }catch(NoSuchMethodException nsme){
        	if(tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Excepci\363n al obtener el valor de la propiedad: no existe el mtodo");
            }
            if(logInc.isEnabled()){
                Q70ValidacionGenericaException q70validaciongenericaexception = new Q70ValidacionGenericaException((es.ejie.frmk.presentacion.validacion.Q70ValidacionesCampo.class).toString(), "getArgs", "Excepci\363n al recuperar mensajes del Gestor de Mensajes e Internacionalizaci\363n", nsme);
                logInc.log(q70validaciongenericaexception, COMPONENTE, "ERROR");
            }
        }
        
        for (int i=0; i< listaComparable.size();i++){
        	if (!listaComparar.contains(listaComparable.get(i))){
        		actionErrors.add(field.getKey(), getActionError(httpServletRequest, validatorAction, field));
        		result = false;
        		break;
        	}
        }

    	return result;
	}
	
    /**
     * Compara que la fecha desde sea menor o igual a la fecha hasta
     * 
     * @param obj obj
     * @param validatorAction validatorAction
     * @param field field
     * @param actionErrors actionErrors
     * @param validator validator
     * @param httpServletRequest httpServletRequest
     * @return boolean
     */
	public static boolean compareDates(Object obj, ValidatorAction validatorAction, Field field, ActionErrors actionErrors, Validator validator, HttpServletRequest httpServletRequest) {
		//Variables que no se van a modificar
		final String FECHA_HASTA 	= "fechaHasta";
		final String PATRON_FECHA	= "patronFecha";
		//Variable que se devuelve
		boolean result = true;
		//Se obtienen los valores del validators-config
		String property = field.getVarValue(FECHA_HASTA);
		String patron 	= field.getVarValue(PATRON_FECHA);
		
		try{
			//Se comparan las fechas se previamente no hay errores. Es decir,
			//se ha comprobado anteriormente que las fechas son correctas
			if(actionErrors.isEmpty())
			{
				//Se obtienen ambas fechas
				String fechaDesde = (String)PropertyUtils.getProperty(obj,field.getProperty());
				String fechaHasta = (String)PropertyUtils.getProperty(obj,property);
				//Se comprueban que tengan valor
				if(!Q02aFormatData.esVacio(fechaDesde) && !Q02aFormatData.esVacio(fechaHasta)){
					//Se convierten las fechas a formato Date
					Date fechaDesdeDate  = Q02aFormatData.parseDate(fechaDesde,patron);
					Date fechaDesdeHasta = Q02aFormatData.parseDate(fechaHasta,patron);				
					//Se comprueba que tengan valor			
					if(fechaDesdeDate!=null && fechaDesdeHasta!=null){					
						//Devuelve el resultado de la comparacin
						int comparacion = fechaDesdeDate.compareTo(fechaDesdeHasta);
						//Si es >0 quiere decir que la fecha desde es > que la fecha hasta
						if(comparacion > 0){
							actionErrors.add(field.getKey(), getActionError(httpServletRequest, validatorAction, field));
							result = false;
						}
					}				
				}
			}

		}catch(IllegalAccessException iae){
			if(tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Excepci\363n al acceder a la propiedad");
            }
	        if(logInc.isEnabled()){
	            Q70ValidacionGenericaException q70validaciongenericaexception = new Q70ValidacionGenericaException((es.ejie.frmk.presentacion.validacion.Q70ValidacionesCampo.class).toString(), "getArgs", "Excepci\363n al recuperar mensajes del Gestor de Mensajes e Internacionalizaci\363n", iae);
	            logInc.log(q70validaciongenericaexception, COMPONENTE, "ERROR");
	        }
	    }catch(InvocationTargetException ite){
	    	if(tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Excepci\363n al llamar al mtodo");
            }
	        if(logInc.isEnabled()){
	            Q70ValidacionGenericaException q70validaciongenericaexception = new Q70ValidacionGenericaException((es.ejie.frmk.presentacion.validacion.Q70ValidacionesCampo.class).toString(), "getArgs", "Excepci\363n al recuperar mensajes del Gestor de Mensajes e Internacionalizaci\363n", ite);
	            logInc.log(q70validaciongenericaexception, COMPONENTE, "ERROR");
	        }
	    }catch(NoSuchMethodException nsme){
	    	if(tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Excepci\363n al obtener el valor de la propiedad: no existe el mtodo");
            }
	        if(logInc.isEnabled()){
	            Q70ValidacionGenericaException q70validaciongenericaexception = new Q70ValidacionGenericaException((es.ejie.frmk.presentacion.validacion.Q70ValidacionesCampo.class).toString(), "getArgs", "Excepci\363n al recuperar mensajes del Gestor de Mensajes e Internacionalizaci\363n", nsme);
	            logInc.log(q70validaciongenericaexception, COMPONENTE, "ERROR");
	        }
	    }catch(Exception ex){
	    	if(tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Excepci\363n general");
            }
	        if(logInc.isEnabled()){
	            Q70ValidacionGenericaException q70validaciongenericaexception = new Q70ValidacionGenericaException((es.ejie.frmk.presentacion.validacion.Q70ValidacionesCampo.class).toString(), "getArgs", "Excepci\363n al recuperar mensajes del Gestor de Mensajes e Internacionalizaci\363n", ex);
	            logInc.log(q70validaciongenericaexception, COMPONENTE, "ERROR");
	        }
	    }
		return result;
	}
	
	/**
     * Realiza la validacin del CIF en funcin del Tipo de CIF que obtenga
     * 
     * @param obj obj
     * @param validatorAction validatorAction
     * @param field field
     * @param actionErrors actionErrors
     * @param validator validator
     * @param httpServletRequest httpServletRequest
     * @return boolean
     */
	public static boolean validateCIFDependsTipoCIF(Object obj, ValidatorAction validatorAction, Field field, ActionErrors actionErrors, Validator validator, HttpServletRequest httpServletRequest)
	{
		//Variables que no se van a modificar
		final String TIPO_CIF				= "tipoCif";
		final String TIPO_PERSONA			= "tipoPersona";
		final String TIPO_PERSONA_FISICA 	= "COD_PERSONA_FISICA";
		final String TIPO_PERSONA_JURIDICA	= "COD_PERSONA_JURIDICA"; 
		final String TIPO_CIF_NACIONAL		= "COD_CIF_NACIONAL";
		//Variable que se devuelve
		boolean result 	= true;
		//Se obtienen los valores del validators-config
		String propertyTipoCif 		= field.getVarValue(TIPO_CIF);
		String propertyTipoPersona	= field.getVarValue(TIPO_PERSONA);
		try{
			//Se obtiene el valor del cif
			String cif 	   = ValidatorUtil.getValueAsString(obj, field.getProperty());
			//Se obtiene el valor del tipo de CIF
			String tipoCif = (String)PropertyUtils.getProperty(obj,propertyTipoCif);
			//Se obtiene el valor del tipo de persona
			String tipoPersona = (String)PropertyUtils.getProperty(obj,propertyTipoPersona);
			//Se compruena que todos los campos necesarios tengan valor
			if(!GenericValidator.isBlankOrNull(cif) && !GenericValidator.isBlankOrNull(tipoCif) && !GenericValidator.isBlankOrNull(tipoPersona))
			{
				//Se comprueba el tipo de CIF que tiene
				if(Q02aNILocator.getNI("TT_TIPO_CIF",TIPO_CIF_NACIONAL).equals(tipoCif)){
					//Si el tipo de persona es jurdica se valida el CIF
					if(Q02aNILocator.getNI("TT_TIPO_PERSONA",TIPO_PERSONA_JURIDICA).equals(tipoPersona)){
						result=validateCIF(obj,validatorAction,field,actionErrors,validator,httpServletRequest);
					}//Si el tipo de persona es fsica se valida el DNI
					else if(Q02aNILocator.getNI("TT_TIPO_PERSONA",TIPO_PERSONA_FISICA).equals(tipoPersona)){
						result=validateDNI_NIF(obj,validatorAction,field,actionErrors,validator,httpServletRequest);
					}
				}	
			}
		}catch(IllegalAccessException iae){
			if(tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Excepci\363n al acceder a la propiedad");
            }
	        if(logInc.isEnabled()){
	            Q70ValidacionGenericaException q70validaciongenericaexception = new Q70ValidacionGenericaException((es.ejie.frmk.presentacion.validacion.Q70ValidacionesCampo.class).toString(), "getArgs", "Excepci\363n al recuperar mensajes del Gestor de Mensajes e Internacionalizaci\363n", iae);
	            logInc.log(q70validaciongenericaexception, COMPONENTE, "ERROR");
	        }
	    }catch(InvocationTargetException ite){
	    	if(tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Excepci\363n al llamar al mtodo");
            }
	        if(logInc.isEnabled()){
	            Q70ValidacionGenericaException q70validaciongenericaexception = new Q70ValidacionGenericaException((es.ejie.frmk.presentacion.validacion.Q70ValidacionesCampo.class).toString(), "getArgs", "Excepci\363n al recuperar mensajes del Gestor de Mensajes e Internacionalizaci\363n", ite);
	            logInc.log(q70validaciongenericaexception, COMPONENTE, "ERROR");
	        }
	    }catch(NoSuchMethodException nsme){
	    	if(tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Excepci\363n al obtener el valor de la propiedad: no existe el mtodo");
            }
	        if(logInc.isEnabled()){
	            Q70ValidacionGenericaException q70validaciongenericaexception = new Q70ValidacionGenericaException((es.ejie.frmk.presentacion.validacion.Q70ValidacionesCampo.class).toString(), "getArgs", "Excepci\363n al recuperar mensajes del Gestor de Mensajes e Internacionalizaci\363n", nsme);
	            logInc.log(q70validaciongenericaexception, COMPONENTE, "ERROR");
	        }
	    }catch(Exception ex){
	    	if(tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Excepci\363n general");
            }
	        if(logInc.isEnabled()){
	            Q70ValidacionGenericaException q70validaciongenericaexception = new Q70ValidacionGenericaException((es.ejie.frmk.presentacion.validacion.Q70ValidacionesCampo.class).toString(), "getArgs", "Excepci\363n al recuperar mensajes del Gestor de Mensajes e Internacionalizaci\363n", ex);
	            logInc.log(q70validaciongenericaexception, COMPONENTE, "ERROR");
	        }
	    }
		return result;		
	}
	
	
	/**
	 * Comprueba que dos campos sean iguales
	 * @param bean bean
	 * @param va va
	 * @param field field
	 * @param errors errors
	 * @param validator validator
	 * @param request request
	 * @return boolean
	 */
	public static boolean isEqual(Object bean, ValidatorAction va, Field field, ActionErrors errors, Validator validator, HttpServletRequest request){
		String value = ValidatorUtil.getValueAsString(bean, field.getProperty());
		String sProperty2 = field.getVarValue("secondProperty");
		String value2 = ValidatorUtil.getValueAsString(bean, sProperty2);
    
		try{
			if(!GenericValidator.isBlankOrNull(value) && !value.equals(value2)){
				errors.add(field.getKey(), getActionError(request, va, field));
				return false;
			}
		}catch(Exception ex){
			if(tr.isTraceActive()){
				tr.trace("VALIDACIONES_GEN", Q70TraceLevel.ERROR, "Excepci\363n general");
			}
			if(logInc.isEnabled()){
				Q70ValidacionGenericaException q70validaciongenericaexception = new Q70ValidacionGenericaException(es.ejie.frmk.presentacion.validacion.Q70ValidacionesCampo.class.toString(), "getArgs", "Excepci\363n al recuperar mensajes del Gestor de Mensajes e Internacionalizaci\363n", ex);
				logInc.log(q70validaciongenericaexception, "VALIDACIONES_GEN", "ERROR");
			}
		}
		return true;
    }
	
	/**
	 * Comprueba que dos campos sean distintos
	 * @param bean bean
     * @param va va
     * @param field field
     * @param errors errors
     * @param validator validator
     * @param request request
     * @return boolean
	 */
    public static boolean isNotEqual(Object bean, ValidatorAction va, Field field, ActionErrors errors, Validator validator, HttpServletRequest request){
        String value = ValidatorUtil.getValueAsString(bean, field.getProperty());
        String sProperty2 = field.getVarValue("secondProperty");
        String value2 = ValidatorUtil.getValueAsString(bean, sProperty2);
        try
        {
            if(!GenericValidator.isBlankOrNull(value) && value.equals(value2)){
                errors.add(field.getKey(), getActionError(request, va, field));
                return false;
            }
        }catch(Exception ex){
            if(tr.isTraceActive()){
                tr.trace("VALIDACIONES_GEN", Q70TraceLevel.ERROR, "Excepci\363n general");
            }
            if(logInc.isEnabled()){
                Q70ValidacionGenericaException q70validaciongenericaexception = new Q70ValidacionGenericaException(es.ejie.frmk.presentacion.validacion.Q70ValidacionesCampo.class.toString(), "getArgs", "Excepci\363n al recuperar mensajes del Gestor de Mensajes e Internacionalizaci\363n", ex);
                logInc.log(q70validaciongenericaexception, "VALIDACIONES_GEN", "ERROR");
            }
        }
        return true;
    }
    
/**
 * Comprueba un DNI/NIF
 * @param obj obj
 * @param validatorAction validatorAction
 * @param field field
 * @param actionErrors actionErrors
 * @param validator validator
 * @param httpServletRequest httpServletRequest
 * @return result
 */
public static boolean validateDNI_NIF(Object obj, ValidatorAction validatorAction, Field field, ActionErrors actionErrors, Validator validator, HttpServletRequest httpServletRequest) {
	boolean result = true;
	String value = ValidatorUtil.getValueAsString(obj, field.getProperty());
	
	try{
		if(!GenericValidator.isBlankOrNull(value)){			
			/* Si la longitud de NIF es menor que 9 devuelve falso */
    		if (value.length() != 9){
    			actionErrors.add(field.getKey(), getActionError(httpServletRequest, validatorAction, field));
    			result = false; 
    		}else{
    			/* Si los ocho primeros dgitos no forman un nmero entero sin signo vlido devuelve falso */
    			if (!GenericValidator.isInt(value.substring(0, 8))){
    				actionErrors.add(field.getKey(), getActionError(httpServletRequest, validatorAction, field));
    				result = false;  
    			}else{ 
    				/* Si el ltimo dgito no es una letra vlida devuelve falso */
    				if (!GenericValidator.matchRegexp(value.substring(8, 9),"^[a-zA-Z]$")){ 
    					actionErrors.add(field.getKey(), getActionError(httpServletRequest, validatorAction, field));
    					result = false;  
    				}else{
    					/* Control de clculos segn el criterio de correccin */
    					Double controlValue = new Double(0);
    					/* Almacena la posicin de la letra correpondiente a la parte numrica del DNI con respecto al array NIFChars */
    					int NIFCharIndex = 0;
    					/* Contiene las letras de DNI ordenadas segun el criterio de correccin */
    					String[] NIFChars = {"T","R","W","A","G","M","Y","F","P","D","X","B","N","J",
    						"Z","S","Q","V","H","L","C","K","E"};
    		
    					/* Almacena la parte numrica del DNI */
    					int NIFNumber = Integer.parseInt(value.substring(0, 8));
    					/* Almacenamos la letra del DNI */
    					String NIFChar = value.substring(8, 9); 
    		  
    					/* Pasamos la letra del DNI a maysculas por si acaso estaba en minsculas */
    					NIFChar = NIFChar.toUpperCase();
    		  
    					/* Los siguientes 4 clculos sirven para calcular la posicin de la letra correspondiente 
    					 a la parte numrica del DNI en el array */
    					controlValue = new Double(NIFNumber / NIFChars.length);
    					controlValue = new Double(Math.floor(controlValue.doubleValue()));
    					NIFCharIndex = NIFNumber - (controlValue.intValue() * NIFChars.length);
    					/* Si la letra coincide con la letra dada devuelve verdadero si no devuelve falso */
    					if (!NIFChar.equals(NIFChars[NIFCharIndex])){
    						actionErrors.add(field.getKey(), getActionError(httpServletRequest, validatorAction, field));
    						result = false; 
    					}
    				}
    			}
    		}
		}
	}catch(Exception ex){
		if(tr.isTraceActive()){
            tr.trace("VALIDACIONES_GEN", Q70TraceLevel.ERROR, "Excepci\363n general");
        }
        if(logInc.isEnabled()){
            Q70ValidacionGenericaException q70validaciongenericaexception = new Q70ValidacionGenericaException(es.ejie.frmk.presentacion.validacion.Q70ValidacionesCampo.class.toString(), "getArgs", "Excepci\363n al recuperar mensajes del Gestor de Mensajes e Internacionalizaci\363n", ex);
            logInc.log(q70validaciongenericaexception, "VALIDACIONES_GEN", "ERROR");
        }
	}
	return result;
}

/**
 * Comprueba un CIF
 * @param obj obj
 * @param validatorAction validatorAction
 * @param field field
 * @param actionErrors actionErrors
 * @param validator validator
 * @param httpServletRequest httpServletRequest
 * @return result
 */
public static boolean validateCIF(Object obj, ValidatorAction validatorAction, Field field, ActionErrors actionErrors, Validator validator, HttpServletRequest httpServletRequest) {
	boolean result = true;
	String value = ValidatorUtil.getValueAsString(obj, field.getProperty());
	
	try{
		if(!GenericValidator.isBlankOrNull(value)){			
			/* Si la longitud de CIF es menor que 9 devuelve falso */
    		if (value.length() != 9){
    			actionErrors.add(field.getKey(), getActionError(httpServletRequest, validatorAction, field));
    			result = false; 
    		}else{
    			/* Si los dgitos desde la 2 posicin a la septima  forman un nmero entero sin signo vlido devuelve falso */
    			if (!GenericValidator.isInt(value.substring(1, 8))){
    				actionErrors.add(field.getKey(), getActionError(httpServletRequest, validatorAction, field));
    				result = false;  
    			}else{ 
    				/* Si el primer valor dgito no es una letra vlida devuelve falso */
    				if (!GenericValidator.matchRegexp(value.substring(0,1),"^[a-zA-Z]$")){ 
    					actionErrors.add(field.getKey(), getActionError(httpServletRequest, validatorAction, field));
    					result = false;  
    				}else{
    					//si el ultimo digito no es una letra o un numero se devuelve falso
    					if(!(
    						(GenericValidator.matchRegexp(value.substring(8, 9),"^[a-zA-Z]$"))
    						||
    						(GenericValidator.isInt(value.substring(8, 9)))
    						))
    					{
    						actionErrors.add(field.getKey(), getActionError(httpServletRequest, validatorAction, field));
	    					result = false;  
    					}
    					else
    					{	//se ddfinen las letras validas para la primera posicin del CIF
    						String[] CIFChars = {"A","B","C","D","E","F","G","H","K","L","M","N","P","Q","S"};
    					/*	
    						A - Sociedad Annima. 
    						B - Sociedad de responsabilidad limitada. 
    						C - Sociedad colectiva. 
    						D - Sociedad comanditaria. 
    						E - Comunidad de bienes. 
    						F - Sociedad cooperativa. 
    						G - Asociaciones y otros tipos no definidos. 
    						H - Comunidad de propietarios en rgimen de propiedad horizontal. 
    						K - Formato antiguo. 
    						L - Formato antiguo. 
    						M - Formato antiguo. 
    						N - Entidades no residentes. 
    						P - Corporacin local. 
    						Q - Organismo autnomo estatal o no, y asimilados, congregaciones e instituciones religiosas. 
    						S - Organos de la Administracin 
    					*/	
    						/* Almacenamos la primera letra del CIF */
	    					String CIFChar_1 = value.substring(0, 1).toUpperCase();
	    					boolean primeraLetra = false;
	    					//Recorremos el array para ver si alguana de las letras permitidas corresponden
	    					for ( int i=0; i < CIFChars.length ; i++){
	    						if(CIFChar_1.equals(CIFChars[i]) )
	    						{
	    							//la letra esta permitida
	    							primeraLetra = true;
	    							break;
	    						}
	    						
	    					}
    						//se comprueba que la letra es de las permitidas
	    					if (primeraLetra==false)
	    					{
	    						actionErrors.add(field.getKey(), getActionError(httpServletRequest, validatorAction, field));
		    					result = false;  
	    					}
	    					else{
	    						//ahora comprobaremos que el digito de control esta correctamente calculado.
								/* Almacena la parte numrica del CIF */
		    					//int CIFNumber = Integer.parseInt(value.substring(1, 8));
		    					String[] CIFControlChars = {"J","A","B","C","D","E","F","G","H","I","J"};
		    					//sumaremos los valores pares de la parte numerica
		    					int sumaPares = 0;
		    					int sumaImpares = 0;
		    					Integer sumaTotal =null;
		    					sumaPares = Integer.parseInt(value.substring(2, 3)) + Integer.parseInt(value.substring(4, 5)) + Integer.parseInt(value.substring(6, 7));
		    					//los valores impares se sumaran multiplicados por dos
		    						
		    					int a = ((Integer.parseInt(value.substring(1, 2))*2));
		    					int b =	(Integer.parseInt(value.substring(3, 4))*2);
		    					int c = (Integer.parseInt(value.substring(5, 6))*2);
		    					int d =  (Integer.parseInt(value.substring(7, 8))*2);
		    					
		    					sumaImpares = sumarDigitos(a) + sumarDigitos(b) + sumarDigitos(c)+ sumarDigitos(d);
		    					//sumaImpares = a + b + c + d;
		    					
		    					/*	sumaImpares = (Integer.parseInt(value.substring(1, 2))*2)+
		    									(Integer.parseInt(value.substring(3, 4))*2)+
		    									(Integer.parseInt(value.substring(5, 6))*2)+
		    									(Integer.parseInt(value.substring(7, 8))*2);
		    					*/				
		    						sumaTotal = new Integer( sumaPares + sumaImpares);
		    						//ultima carcater de la suma
		    						String control = sumaTotal.toString().substring(sumaTotal.toString().length()-1, sumaTotal.toString().length());
		    						int digitoControl = 10 - Integer.parseInt(control);
	    						
	    						/* Almacenamos el ltimo valor del CIF */
	    						String CIFChar_2 = value.substring(8, 9).toUpperCase();
	    						//si la primera posicin es K,P,Q o S, el ltimo caracter debe ser una letra
	    								if (CIFChar_1.equals( "K") || CIFChar_1.equals("P") || CIFChar_1.equals("Q") || CIFChar_1.equals("S"))
	    								{
	    									if(!GenericValidator.matchRegexp(CIFChar_2,"^[a-zA-Z]$"))
	    									{
	    										actionErrors.add(field.getKey(), getActionError(httpServletRequest, validatorAction, field));
	    				    					result = false; 
	    									}
	    									//se comprueba que el digito de control  corresponde con la letra adecuada
	    									else if(!CIFControlChars[digitoControl].equals(CIFChar_2))
	    									{
	    										actionErrors.add(field.getKey(), getActionError(httpServletRequest, validatorAction, field));
	    				    					result = false; 		    										
	    									}
	    									
	    								}
	    								else{//si la primera posicion es A,B,C,o H el ltimo valor debe ser un numero
	    									if (CIFChar_1.equals("A") || CIFChar_1.equals("B") || CIFChar_1.equals("C") || CIFChar_1 .equals("H"))
	    									{
	    										if(!GenericValidator.isInt(CIFChar_2))
	    										{
	    											actionErrors.add(field.getKey(), getActionError(httpServletRequest, validatorAction, field));
		    				    					result = false; 
	    										}
	    										//se comprueba que el digito de control corresponde con en digito adecuado.
	    										else if (!CIFChar_2.equals(new Integer(digitoControl).toString()))
	    										{
	    											actionErrors.add(field.getKey(), getActionError(httpServletRequest, validatorAction, field));
		    				    					result = false; 
	    										}
	    									}
	    									else{//el valor puede ser un numero o una letra	
	    										//si el valor no corresponde con el digitol calculado
	    										//TODO ESTE CRITERIO PERMITE DOS POSIBLES VALORES PTE DE MEJORAR
	    										if (!(CIFChar_2 .equals(new Integer(digitoControl).toString())||CIFControlChars[digitoControl].equals(CIFChar_2)))
	    										{
	    											actionErrors.add(field.getKey(), getActionError(httpServletRequest, validatorAction, field));
		    				    					result = false; 
	    										}
	    									}
	    								}
	    							}
    							}
    						}	    
    					}
    				}
    		}
	}catch(Exception ex){
		if(tr.isTraceActive()){
            tr.trace("VALIDACIONES_GEN", Q70TraceLevel.ERROR, "Excepci\363n general");
        }
        if(logInc.isEnabled()){
            Q70ValidacionGenericaException q70validaciongenericaexception = new Q70ValidacionGenericaException(es.ejie.frmk.presentacion.validacion.Q70ValidacionesCampo.class.toString(), "getArgs", "Excepci\363n al recuperar mensajes del Gestor de Mensajes e Internacionalizaci\363n", ex);
            logInc.log(q70validaciongenericaexception, "VALIDACIONES_GEN", "ERROR");
        }
	}
	return result;
}
/**
 * 
 * @param digito digito
 * @return valorCalculado
 */
	private static int sumarDigitos (int digito){
//		pasar a string para poder sumar digito a digito
		String cadena = (new Integer(digito)).toString();
		int valorCalculado = 0;
		if (digito != 0)
		{	
			for ( int i=0; i < cadena.length() ; i++)
			{				
				valorCalculado = valorCalculado + Integer.parseInt(cadena.substring(i,i+1));
			}
		}
	return valorCalculado;
	}
	
	
	 /** Mtodo que validara si un campo es requerido en funcin del valor de otro campo
	 * @param obj obj
	 * @param validatorAction validatorAction
	 * @param field field
	 * @param actionErrors actionErrors
	 * @param validator validator
	 * @param httpServletrequest httpServletrequest
	 * @return result
	 */
	public static boolean Q02avalidateRequiredIf(Object obj, ValidatorAction validatorAction, Field field, ActionErrors actionErrors, Validator validator, HttpServletRequest httpServletrequest){
		 	boolean result = true;
		 	boolean flag = false;

		 	try{
		 		
		 		Object obj1 = validator.getResource(Validator.BEAN_KEY);
		        
		 		String valorCampoRequerido = ValidatorUtil.getValueAsString(obj, field.getProperty());	   

		 		String fieldJoinValue = "AND";
		        
		 		if(!GenericValidator.isBlankOrNull(field.getVarValue("fieldJoin"))){
		            fieldJoinValue = field.getVarValue("fieldJoin");
		 		}
		        if(fieldJoinValue.equalsIgnoreCase("AND")){
		            flag = true;
		        }
		        for(int i=0; !GenericValidator.isBlankOrNull(field.getVarValue("field[" + i + "]")); i++){
		            String fieldName = field.getVarValue("field[" + i + "]");
		            String fieldTest = field.getVarValue("fieldTest[" + i + "]");
		            String fieldValueName = field.getVarValue("fieldValue[" + i + "]");
		            String fieldIndexed = field.getVarValue("fieldIndexed[" + i + "]");
		            if(null == fieldIndexed){
		                fieldIndexed = "false";
		            }
		            String fieldAux = null;
		            boolean flag1 = false;
		            if(field.isIndexed() && fieldIndexed.equalsIgnoreCase("true")){
		                String fieldKey = field.getKey();
		                if(fieldKey.indexOf("[") > -1 && fieldKey.indexOf("]") > -1){
		                    fieldName = fieldKey.substring(0, fieldKey.indexOf(".") + 1) + fieldName;
		                }
		            }
		            fieldAux = ValidatorUtil.getValueAsString(obj1, fieldName);
		            if(fieldTest.equals("NULL")){
		                if(fieldAux != null && fieldTest.length() > 0){
		                    flag1 = false;
		                }else{
		                    flag1 = true;
		                }
		            }
		            if(fieldTest.equals("NOTNULL")){
		                if(fieldAux != null && fieldAux.length() > 0){
		                    flag1 = true;
		                }else{
		                    flag1 = false;
		                }
		            }
		            String fieldValue = ValidatorUtil.getValueAsString(obj1,fieldValueName);
		            if(fieldTest.equals("EQUAL")){
		                flag1 = fieldValue.equalsIgnoreCase(fieldAux);
		            }
		            if(fieldTest.equals("NOTEQUAL")){
		            	flag1 = !fieldValue.equalsIgnoreCase(fieldAux);
		            }
		            if(fieldJoinValue.equalsIgnoreCase("AND")){
		                flag = flag && flag1;
		        	}else{
		                flag = flag || flag1;
		            }
		        }

		        if(flag){
		        	if(GenericValidator.isBlankOrNull(valorCampoRequerido)){
        				actionErrors.add(field.getKey(), getActionError(httpServletrequest, validatorAction, field));
            			result = false; 
        			}	  
		        } 
		 	}catch(Exception ex){
		    	if(tr.isTraceActive()){
					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Excepci\363n general");
                }
		        if(logInc.isEnabled()){
		            Q70ValidacionGenericaException q70validaciongenericaexception = new Q70ValidacionGenericaException((es.ejie.frmk.presentacion.validacion.Q70ValidacionesCampo.class).toString(), "getArgs", "Excepci\363n al recuperar mensajes del Gestor de Mensajes e Internacionalizaci\363n", ex);
		            logInc.log(q70validaciongenericaexception, COMPONENTE, "ERROR");
		        }
		    }
	        return result;
	       
	    }

	 /** Mtodo que comprobara si la letra del Cif corresponde con el tipo de sociedad seleccionado. 
	 * @param obj obj
     * @param validatorAction validatorAction
     * @param field field
     * @param actionErrors actionErrors
     * @param validator validator
     * @param httpServletrequest httpServletrequest
	 * @return result
	 */
	public static boolean Q02avalidateTipoSociedad(Object obj, ValidatorAction validatorAction, Field field, 
            ActionErrors actionErrors, Validator validator, HttpServletRequest httpServletrequest)
	    {
		 	//constantes que no va a variar
		 	final String CIF				= "Cif";
			final String TIPO_CIF				= "tipoCif";
			final String TIPO_PERSONA			= "tipoPersona";			
			final String TIPO_PERSONA_JURIDICA	= "COD_PERSONA_JURIDICA"; 
			final String TIPO_CIF_NACIONAL		= "COD_CIF_NACIONAL";			
			//se obtiene el nombre del campo que contiene el CIF
			String propertyTipoCif 		= field.getVarValue(TIPO_CIF);
			String propertyTipoPersona	= field.getVarValue(TIPO_PERSONA);		 	
		 	String propertyCif 		= field.getVarValue(CIF);
		 	boolean result = true;
		 	try {		 		
		 		//se recuperar los valores adicionales para realizar la validacin
		 		String tipoCif 	   = 	(String)PropertyUtils.getProperty(obj, propertyTipoCif);
		 		String tipoPersona =	(String)PropertyUtils.getProperty(obj, propertyTipoPersona);		 						
				String cif 		   = 	(String)PropertyUtils.getProperty(obj,propertyCif);
				//se recupera el campo a validar
				String tipoSociedad= 	ValidatorUtil.getValueAsString(obj, field.getProperty());
				//se comprueba que tenemos todos los campos necesarios.
				if(!GenericValidator.isBlankOrNull(tipoSociedad) && !GenericValidator.isBlankOrNull(tipoCif) && !GenericValidator.isBlankOrNull(tipoPersona)&& !GenericValidator.isBlankOrNull(cif))				
				{	//Se comprueba si el tipoCif es nacional
					
						if(Q02aNILocator.getNI("TT_TIPO_CIF",TIPO_CIF_NACIONAL).equals(tipoCif))
						{	
							//se comprueba que el tipo de persona sea juridica.
							if(Q02aNILocator.getNI("TT_TIPO_PERSONA",TIPO_PERSONA_JURIDICA).equals(tipoPersona))
							{									
								//se recupera la letra del CIF
								String letraCif = cif.substring(0, 1).toUpperCase();
								//se obtiene el codigo que corresponde a esa letra (todos los codigos deben estar creados en 
								//q02aCosntantes.properties
								String correspondenciaCodigoLetra = Q02aConstantes.getString(letraCif);
								//si no hay correspondecia dara error (excepcion?)
								if(correspondenciaCodigoLetra == null)
								{
									//no se realizara comprobacion y se dara por correcto (hasta que se tengan todas las correspondencias)
								}
								else{//se buscara el ni de tipo de empresa que corresponde con el codigo recuperado.
									String niTipoEmpresa = Q02aNILocator.getNI("TT_TIPO_SOC",correspondenciaCodigoLetra);
									//se compara el ni recuperado con el valor del campo a validar
									if(!tipoSociedad.equals(niTipoEmpresa))
									{
										actionErrors.add(field.getKey(), getActionError(httpServletrequest, validatorAction, field));
										result = false; 
									}
								}
							}
						}
				}	
			} catch (Q02aDAOException de) {
				if(tr.isTraceActive()){
					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Excepci\363n al recuperar NI");
                }
		        if(logInc.isEnabled()){
		            Q70ValidacionGenericaException q70validaciongenericaexception = new Q70ValidacionGenericaException((es.ejie.frmk.presentacion.validacion.Q70ValidacionesCampo.class).toString(), "getArgs", "Excepci\363n al recuperar mensajes del Gestor de Mensajes e Internacionalizaci\363n", de);
		            logInc.log(q70validaciongenericaexception, COMPONENTE, "ERROR");
		        }
			} catch (IllegalAccessException iae) {
				if(tr.isTraceActive()){
					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Excepci\363n al acceder a la propiedad");
                }
                if(logInc.isEnabled()){
		            Q70ValidacionGenericaException q70validaciongenericaexception = new Q70ValidacionGenericaException((es.ejie.frmk.presentacion.validacion.Q70ValidacionesCampo.class).toString(), "getArgs", "Excepci\363n al recuperar mensajes del Gestor de Mensajes e Internacionalizaci\363n", iae);
		            logInc.log(q70validaciongenericaexception, COMPONENTE, "ERROR");
		        }
			} catch (InvocationTargetException ite) {
				if(tr.isTraceActive()){
					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Excepci\363n al llamar al mtodo");
                }
                if(logInc.isEnabled()){
		            Q70ValidacionGenericaException q70validaciongenericaexception = new Q70ValidacionGenericaException((es.ejie.frmk.presentacion.validacion.Q70ValidacionesCampo.class).toString(), "getArgs", "Excepci\363n al recuperar mensajes del Gestor de Mensajes e Internacionalizaci\363n", ite);
		            logInc.log(q70validaciongenericaexception, COMPONENTE, "ERROR");
		        }
			} catch (NoSuchMethodException nsme) {
				if(tr.isTraceActive()){
					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Excepci\363n al obtener el valor de la propiedad: no existe el mtodo");
                }
                if(logInc.isEnabled()){
		            Q70ValidacionGenericaException q70validaciongenericaexception = new Q70ValidacionGenericaException((es.ejie.frmk.presentacion.validacion.Q70ValidacionesCampo.class).toString(), "getArgs", "Excepci\363n al recuperar mensajes del Gestor de Mensajes e Internacionalizaci\363n", nsme);
		            logInc.log(q70validaciongenericaexception, COMPONENTE, "ERROR");
		        }
			}catch(Exception ex){
				  if(tr.isTraceActive()){
					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Excepci\363n general");
                  }
                  if(logInc.isEnabled()){
				      Q70ValidacionGenericaException q70validaciongenericaexception = new Q70ValidacionGenericaException((es.ejie.frmk.presentacion.validacion.Q70ValidacionesCampo.class).toString(), "getArgs", "Excepci\363n al recuperar mensajes del Gestor de Mensajes e Internacionalizaci\363n", ex);
				      logInc.log(q70validaciongenericaexception, COMPONENTE, "ERROR");
				  }
			}
				
		 	return result;
	    }
	/** Mtodo que comprobara el cdigo CAS es vlido. 
	 * @param obj obj
     * @param validatorAction validatorAction
     * @param field field
     * @param actionErrors actionErrors
     * @param validator validator
     * @param httpServletrequest httpServletrequest
     * @return result
	 */
	public static boolean Q02avalidateCodigoCas(Object obj, ValidatorAction validatorAction, Field field, 
            ActionErrors actionErrors, Validator validator, HttpServletRequest httpServletrequest)
	{
		/*Se suman la valoracin de los dgitos de categora y clase, se divide entre 10 y
		se coge el resto. La valoracin de un digito es su valor multiplicado por su
		posicin contando de derecha a izquierda, sin tener en cuenta ni los guiones ni
		el propio digito de control.*/
		boolean result = true;
		try {		 		
			//se recupera el campo a validar
			String codCas= 	ValidatorUtil.getValueAsString(obj, field.getProperty());
			//se comprueba que tenemos todos los campos necesarios.
			if(!GenericValidator.isBlankOrNull(codCas))				
			{	//Se comprueba si el cdigo CAS cumple la expresin regular
				if(GenericValidator.matchRegexp(codCas,"\\b[1-9]{1}[0-9]{1,5}-\\d{2}-\\d\\b"))
				{
					//Utilizamos una variable auxiliar para eliminar los guiones y el dgito de control
					String casAux = codCas.replaceAll("-","");
					int digControl = Integer.parseInt(casAux.substring(casAux.length()-1));
					int sumaAux=0;
					casAux = casAux.substring(0,casAux.length()-1);
					//recorremos el aux
					char arrCas[] = casAux.toCharArray();
					for (int i=arrCas.length;i>0;i--)
					{
						//Acumulamos en sumaAux las valoraciones 
						int valoracion = Integer.parseInt(String.valueOf(arrCas[arrCas.length-i]));
						sumaAux = sumaAux+ ((valoracion)*i); 
					}
					sumaAux = sumaAux % 10;
					if (sumaAux != digControl)
					{
						actionErrors.add(field.getKey(), getActionError(httpServletrequest, validatorAction, field));
						result = false;
					}
				}else
				{
					actionErrors.add(field.getKey(), getActionError(httpServletrequest, validatorAction, field));
					result = false; 
				}
			}	
		}catch(Exception ex){
			if(tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Excepci\363n general");
            }
			if(logInc.isEnabled()){
				Q70ValidacionGenericaException q70validaciongenericaexception = new Q70ValidacionGenericaException((es.ejie.frmk.presentacion.validacion.Q70ValidacionesCampo.class).toString(), "getArgs", "Excepci\363n al recuperar mensajes del Gestor de Mensajes e Internacionalizaci\363n", ex);
				logInc.log(q70validaciongenericaexception, COMPONENTE, "ERROR");
			}
		}
		
		return result;
	}
	/** Mtodo que comprobara si el valor de un campo es menor o igual que un nmero. 
	 * @param obj obj
     * @param validatorAction validatorAction
     * @param field field
     * @param actionErrors actionErrors
     * @param validator validator
     * @param httpServletrequest httpServletrequest
     * @return result
	 */
	public static boolean Q02avalidateCampoMenorIgualCampoIf(Object obj, ValidatorAction validatorAction, 
            Field field, ActionErrors actionErrors, Validator validator, HttpServletRequest httpServletrequest)
	{
		
//		Variables que no se van a modificar
		final String NOM_CAMPO	= "campoMayor";
		final String CONDICION	= "validarIf";
		
		boolean result = true;
		try {		 		

			//se recupera el campo a validar
			String campo= 	ValidatorUtil.getValueAsString(obj, field.getProperty());
			//se recupera el valor del campo mayor
			String nomCampoMayor = field.getVarValue(NOM_CAMPO);
			Object form = validator.getResource(Validator.BEAN_KEY);
			String campoMayor = ValidatorUtil.getValueAsString(form, nomCampoMayor);
			
			String nomCampoComparar = field.getVarValue(CONDICION);
			boolean comparar =(ValidatorUtil.getValueAsString(form, nomCampoComparar)).equalsIgnoreCase("true");
			//se comprueba que tenemos todos los campos necesarios.
			if(!GenericValidator.isBlankOrNull(campo) && !GenericValidator.isBlankOrNull(campoMayor) && comparar )				
			{	//Se comprueba si el cdigo CAS cumple la expresin regular
				if (!GenericValidator.isInt(campo) || !GenericValidator.isInt(campoMayor))
				{
					actionErrors.add(field.getKey(), getActionError(httpServletrequest, validatorAction, field));
					result = false;  
				}
				else if (Integer.parseInt(campo)>Integer.parseInt(campoMayor))
				{
					actionErrors.add(field.getKey(), getActionError(httpServletrequest, validatorAction, field));
					result = false;  
				}
			}
				
		}catch(Exception ex){
			if(tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Excepci\363n general");
            }
            if(logInc.isEnabled()){
				Q70ValidacionGenericaException q70validaciongenericaexception = new Q70ValidacionGenericaException((es.ejie.frmk.presentacion.validacion.Q70ValidacionesCampo.class).toString(), "getArgs", "Excepci\363n al recuperar mensajes del Gestor de Mensajes e Internacionalizaci\363n", ex);
				logInc.log(q70validaciongenericaexception, COMPONENTE, "ERROR");
			}
		}
		
		return result;
	}
	/** Mtodo que comprobara si el valor de un campo es menor o igual que otro campo.
	 * @param obj obj
     * @param validatorAction validatorAction
     * @param field field
     * @param actionErrors actionErrors
     * @param validator validator
     * @param httpServletrequest httpServletrequest
     * @return result
	 */
	public static boolean Q02avalidateCampoMenorIgualNumIf(Object obj, ValidatorAction validatorAction, 
            Field field, ActionErrors actionErrors, Validator validator, HttpServletRequest httpServletrequest)
	{
		
//		Variables que no se van a modificar
		final String NUM	= "numMayor";
		final String CONDICION	= "validarIf";
		
		boolean result = true;
		try {		 		
			
			
			/*else if(fncValidarNumeros(max)&&fncValidarNumeros(num)&&(Integer.parseInt(max)>=Integer.parseInt(num)))
			 esValido= true;
			 else
			 errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));*/
			
			//se recupera el campo a validar
			String campo= 	ValidatorUtil.getValueAsString(obj, field.getProperty());
			//se recupera el num
			int num =Integer.parseInt(field.getVarValue(NUM));
			
//			se recupera el valor del campo mayor
			String nomCampoComparar = field.getVarValue(CONDICION);
			Object form = validator.getResource(Validator.BEAN_KEY);
			//String campoMayor = ValidatorUtil.getValueAsString(form, nomCampoMayor);
			
			boolean comparar =(ValidatorUtil.getValueAsString(form, nomCampoComparar)).equalsIgnoreCase("true");
			//se comprueba que tenemos todos los campos necesarios.
			if(!GenericValidator.isBlankOrNull(campo) && comparar )				
			{	//Se comprueba si el cdigo CAS cumple la expresin regular
				if (Integer.parseInt(campo)>num)
				{
					actionErrors.add(field.getKey(), getActionError(httpServletrequest, validatorAction, field));
					result = false;  
				}
			}
			
		}catch(Exception ex){
			if(tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Excepci\363n general");
            }
            if(logInc.isEnabled()){
				Q70ValidacionGenericaException q70validaciongenericaexception = new Q70ValidacionGenericaException((es.ejie.frmk.presentacion.validacion.Q70ValidacionesCampo.class).toString(), "getArgs", "Excepci\363n al recuperar mensajes del Gestor de Mensajes e Internacionalizaci\363n", ex);
				logInc.log(q70validaciongenericaexception, COMPONENTE, "ERROR");
			}
		}
		
		return result;
	}
	
	/** Mtodo que comprueba que los correos electrnicos concatenados segn un patrn sean
	 *  correctos
	 * @param obj obj
     * @param validatorAction validatorAction
     * @param field field
     * @param actionErrors actionErrors
     * @param validator validator
     * @param httpServletrequest httpServletrequest
     * @return result
	 */
	public static boolean Q02avalidateEmailsConcatenados(Object obj, ValidatorAction validatorAction, 
            Field field, ActionErrors actionErrors, Validator validator, HttpServletRequest httpServletrequest)
	{
		boolean result = true;
		try {		 		
			//Se recupera el campo a validar
			String correos = ValidatorUtil.getValueAsString(obj, field.getProperty());
			//Se comprueba si tiene datos
			if(!Q02aFormatData.esVacio(correos)){
				//Se obtiene el array con los valores
				String[] correosArray = correos.split(Q02aConstantes.SEPARADOR_LISTA);
				//Se recorren todos los correos
				for(int i=0;i<correosArray.length;i++){
					//Si alguno no tiene el formato correcto se muestra el error
					if(!GenericValidator.isEmail(correosArray[i])){
						actionErrors.add(field.getKey(), getActionError(httpServletrequest, validatorAction, field));
						result = false;
						break;
					}
				}
			}			
		}catch(Exception ex){
				if(tr.isTraceActive()){
					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Excepci\363n general");
                }
                if(logInc.isEnabled()){
					Q70ValidacionGenericaException q70validaciongenericaexception = new Q70ValidacionGenericaException((es.ejie.frmk.presentacion.validacion.Q70ValidacionesCampo.class).toString(), "getArgs", "Excepci\363n al recuperar mensajes del Gestor de Mensajes e Internacionalizaci\363n", ex);
					logInc.log(q70validaciongenericaexception, COMPONENTE, "ERROR");
				}
		}
			
		return result;
	}
}