/*
 * Fecha: 15-junio-2011
 */
package q02a.encuestas;

import java.io.File;
import java.io.StringReader;
import java.util.HashMap;

import javax.ejb.EJBException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import q02a.exe.comun.Q02aDocumento;
import q02a.exe.listados.Q02AUtils;

import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.datos.Q70OPValidatorForm;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

/**
 * @version 1.0
 * Fecha: 15-junio-2011
 * @author GADIMAAR
 */ 
public class Q02aActionEncuestasPDF extends Q70ActionPasoOP {

	/**
	 * @see es.ejie.frmk.presentacion.operacion.paso.ActionPasoOP#processOP(es.ejie.frmk.presentacion.sesiondatos.ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected void processOP( Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
		ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
        Q70OPValidatorForm formulario = (Q70OPValidatorForm)form;
        HashMap filtro = (HashMap) formulario.get("filtro");
        
        String territorio = "";
        if (filtro.get("codigoProvincia") != null){
                territorio = (String)filtro.get("codigoProvincia");}
        String municipio = "";
        if (filtro.get("codigoMunicipio") != null){
                municipio = (String)filtro.get("codigoMunicipio");}
        String descMuni = "";
        if (filtro.get("descMuni") != null){
            descMuni = (String)filtro.get("descMuni");}
        
        String mes = ""; 
        if ( filtro.get("mes") != null ){
                mes = (String)filtro.get("mes");}
        String anyo = ""; 
        if ( filtro.get("anos") != null ){
                anyo = (String)filtro.get("anos");}
        
        String tipoCuestionarioOM = "";
        if ( filtro.get("tipoCuestionarioOM") != null ){
                tipoCuestionarioOM = (String)filtro.get("tipoCuestionarioOM");
        }
        String numCuestionariosOM = "";
        if ( filtro.get("numCuestionariosOM") != null ){
            numCuestionariosOM = (String)filtro.get("numCuestionariosOM");}
        String tipoCuestionarioSM = "";
        if ( filtro.get("tipoCuestionarioSM") != null ){
            tipoCuestionarioSM = (String)filtro.get("tipoCuestionarioSM");}
        String numCuestionariosSM = "";
        if ( filtro.get("numCuestionariosSM") != null ){
            numCuestionariosSM = (String)filtro.get("numCuestionariosSM");}
        String tipoCuestionarioVA = "";
        if ( filtro.get("tipoCuestionarioVA") != null ){
            tipoCuestionarioVA = (String)filtro.get("tipoCuestionarioVA");}
        String numCuestionariosVA = "";
        if ( filtro.get("numCuestionariosVA") != null ){
            numCuestionariosVA = (String)filtro.get("numCuestionariosVA");}
        if ( !"1".equals(mes)){ numCuestionariosVA = "2"; }
        
		String idioma = contexto.get("idioma").toString();
                
        //////////////////// PDF /////////////
        String rutaXsl;
        if ( idioma.equals("es") ){
            rutaXsl = "/html/datos/xsl/q02acuestionario_ES.xsl";
        }else{
            rutaXsl = "/html/datos/xsl/q02acuestionario_EU.xsl";
        }
//      images
        final String imgName = "/html/datos/xsl/images/logoPDF.jpg";
        
        final String logoEstadistica = "/html/datos/xsl/images/logoEstadistica.gif";
        final String imgCasa = "/html/datos/xsl/images/casa.gif";
        final String uno = "/html/datos/xsl/images/uno.jpg";
        final String dos = "/html/datos/xsl/images/dos.jpg";
        final String tres = "/html/datos/xsl/images/tres.jpg";
                
        File pdfFile=null;
        String charset = "UTF-8";
        String CONFIG_LISTADOS_PATH_TMP = "/datos/q02a/tmp";
        try{
            
            final File tempPath = new File(CONFIG_LISTADOS_PATH_TMP);
            pdfFile=File.createTempFile("Encuestas_Cuestionario", ".pdf", tempPath);
            //System.out.println(pdfFile);
        }catch(Exception e){
            //System.out.println("Excepcion al crear pdf temporal en encuestas en curso");
            throw new EJBException("Excepcion al crear pdf temporal en encuestas en curso", e);
        }
        
        try{
            //Formamos el xml.
            
            //XML
            final String textoDirServiciosEs = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.dirServicios",  "es");
            final String textoDirServiciosEus = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.dirServicios",  "eu");
            
            StringBuffer xml= new StringBuffer("");
            xml.append("<?xml version=\"1.0\" encoding='ISO-8859-1'?>\n");
            xml.append("\t<cuestionario>\n");
                    
                    //textos
                    xml.append("\t<dirServiciosEus>").append( textoDirServiciosEus ).append("</dirServiciosEus>\n");
                    xml.append("\t<dirServiciosEs>").append( textoDirServiciosEs ).append("</dirServiciosEs>\n");
                    xml.append("\t<territorio>").append( territorio ).append("</territorio>\n");
                    xml.append("\t<municipio>").append( municipio ).append("</municipio>\n");
                    xml.append("\t<descMuni>").append( descMuni ).append("</descMuni>\n");
                    xml.append("\t<mes>").append( mes ).append("</mes>\n");
                    xml.append("\t<anyo>").append( anyo ).append("</anyo>\n");
                    xml.append("\t<tipoCuestionarioOM>").append( tipoCuestionarioOM ).append("</tipoCuestionarioOM>\n");
                    xml.append("\t<numCuestionariosOM>").append( numCuestionariosOM ).append("</numCuestionariosOM>\n");
                    xml.append("\t<tipoCuestionarioSM>").append( tipoCuestionarioSM ).append("</tipoCuestionarioSM>\n");
                    xml.append("\t<numCuestionariosSM>").append( numCuestionariosSM ).append("</numCuestionariosSM>\n");
                    xml.append("\t<tipoCuestionarioVA>").append( tipoCuestionarioVA ).append("</tipoCuestionarioVA>\n");
                    xml.append("\t<numCuestionariosVA>").append( numCuestionariosVA ).append("</numCuestionariosVA>\n");
                    //images
                    xml.append("\t<imgName>").append( getClass().getResource(imgName).toString() ).append("</imgName>\n");
                    xml.append("\t<logoPDF>").append( getClass().getResource(logoEstadistica).toString() ).append("</logoPDF>\n");
                    xml.append("\t<imgCasa>").append( getClass().getResource(imgCasa).toString() ).append("</imgCasa>\n");
                    xml.append("\t<uno>").append(getClass().getResource(uno).toString()).append("</uno>\n");
                    xml.append("\t<dos>").append(getClass().getResource(dos).toString()).append("</dos>\n");
                    xml.append("\t<tres>").append(getClass().getResource(tres).toString()).append("</tres>\n");
                    
            xml.append("\t</cuestionario>");
            
            final String xmlString = xml.toString();
            //System.out.println(xmlString);
            StringReader stream = new StringReader(xmlString); 
            
            try{
                //System.out.println("--- Antes de la llamada a pdf ---");
                Q02AUtils.convertXML2PDF( stream, pdfFile, getClass().getResourceAsStream(rutaXsl));
                //System.out.println("--- Despues de la llamada a pdf ---");
                
            }catch (Exception e){
                pdfFile.delete();
                //System.out.println("Error al generar pdf encuestas en curso" );
                throw new EJBException("Error al generar pdf encuestas en curso",e  );
            }
            pdfFile.deleteOnExit();
        }catch(Exception exp){
            pdfFile.delete();
            //System.out.println("Error al imprimir encuestas en curso" );
            throw new EJBException("Error al imprimir encuestas en curso",exp  );
        }
        //System.out.println("--- FIN ---");
        
        ///////////////////////////////////////////////////////////////////////////////
        
        contexto.set("q02a_documento", new Q02aDocumento("Cuestionario Estadstica sobre edificacion y vivienda.pdf","application/pdf",charset,pdfFile) );
        
	}
	/**
	 * @see es.ejie.frmk.presentacion.operacion.paso.ActionPasoOP#processForward(es.ejie.frmk.presentacion.sesiondatos.ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected ActionForward processForward(
		Q70ContextoEJIE contexto,
		ActionErrors errores,
		ActionMapping mapping,
		ActionForm form,
		HttpServletRequest request,
		HttpServletResponse response)
		throws Exception {
		
		return mapping.findForward("ok");
	}

}
