package q02a.cuestionariosVTMAnu.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import q02a.exe.cuestionariosVTMAnu.valueobjects.Q02aCuestionarioVTMAnu;

import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.presentacion.operacion.datos.Q70OPForm;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;

/**
 * @author GADIMAAR
 * 
 * Se dejan en contexto los datos para la hoja excel
 * y los valores que llevaran las cabeceras
 * 
 */
public class Q02aPrepararTablaExcelExpd extends Q70ActionPasoOP{
		
	/**
	 * 
	 * @param contexto		: Q70ContextoEJIE
	 * @param errors		: ActionErrors
	 * @param mapping		: ActionMapping
	 * @param form			: ActionForm
	 * @param request		: HttpServletRequest
	 * @param response		: HttpServletResponse
	 * @throws Exception	: Exception
	 */
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception{
		System.out.println( " LLEGA Q02aPrepararTablaExcelExpd " );
		
		contexto.set("tablaExportar", new HashMap());	
				
		ArrayList criterios = new ArrayList();
        criterios = (ArrayList) this.cargarArrayCriterios ( (HashMap)contexto.get("filtro") );
		
        
		ArrayList cabecera = new ArrayList();
		cabecera.add("archivoExcel.cabecera0.anyo");
		cabecera.add("archivoExcel.cabecera1.mes");
        cabecera.add("archivoExcel.cabecera2.codExpediente");
        cabecera.add("archivoExcel.cabecera3.claveLicenc");
        cabecera.add("archivoExcel.cabecera4.localizObra");
        cabecera.add("archivoExcel.cabecera5.nombreRazSocialPromotor");
        
		HashMap hashMap = new HashMap();
		hashMap.put("titulo", "comun.listadoExpedientes.OM");
		hashMap.put("i18nkey", "q02arecursosCuestionarios");
		hashMap.put("cabecera", cabecera);
		hashMap.put("criteriosBusqueda", criterios);
		hashMap.put("datosTabla", this.crearListaExportar((ArrayList) contexto.get("listaCuestionariosVTM")) );
        //hashMap.put("datosTabla", contexto.get("listaCuestionariosVTM") );//ya es un Array
        
		contexto.set("tablaExportar", hashMap);		
		
	}
	
	/**
	 * 
	 * @param contexto		: Q70ContextoEJIE
	 * @param errors		: ActionErrors
	 * @param mapping		: ActionMapping
	 * @param form			: ActionForm
	 * @param request		: HttpServletRequest
	 * @param response		: HttpServletResponse
	 * @throws Exception	: Exception
	 * @return				: ActionForward
	 */
	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception{
		System.out.println("// Q02aPrepararTablaExcelExpd -- PROCESSFORWARD //");
        
		if ( errors.isEmpty() ){
            return mapping.findForward("ok");
        }
        return mapping.findForward("errores");
        
	}
	
	/**
	 * Metodo que instancia un objeto HashMap. 
     * Est pensado para usarlo dentro de un bucle.
	 * @return HashMap
	 */
	private Map creaMapa() {
		return new HashMap();
	}
	
	/**
	 * Metodo que cargar el array con los criterios usados en la busqueda
	 * @return Una lista de criterios de busqueda
	 */
	private List cargarArrayCriterios(HashMap filtro){
		
        ArrayList criterios = new ArrayList();
        
		HashMap criterioHash = new HashMap();
    	criterioHash.put("crit", "archivoExcel.criterio.descMunicipio");
    	criterioHash.put("critValor", filtro.get("descMuni"));
    	criterios.add(criterioHash);
        
        criterioHash = new HashMap();
        criterioHash.put("crit", "archivoExcel.criterio.anyo");
        criterioHash.put("critValor", filtro.get("anos"));
        criterios.add(criterioHash);
        
        return criterios;
	}
    
    /**
     * Metodo que crea una lista de ascensores para exportar a excel
     * @param viejo List
     * @return Una lista con los datos de los ascensores que se muestran en el resultado
     */
    private ArrayList crearListaExportar(ArrayList lista) {
        
        ArrayList nuevo = new ArrayList();
        
        try{
            Q02aCuestionarioVTMAnu miCuestVTM = new Q02aCuestionarioVTMAnu();
            for(int i=0; i < lista.size(); i++){
                
                HashMap tmp = (HashMap)this.creaMapa();
                miCuestVTM = new Q02aCuestionarioVTMAnu();
                miCuestVTM = (Q02aCuestionarioVTMAnu)lista.get(i);
                                
                tmp.put("elemento0", miCuestVTM.getAnyo());
                tmp.put("elemento1", miCuestVTM.getMes());
                tmp.put("elemento2", miCuestVTM.getCodigoLicencia());
                tmp.put("elemento3", miCuestVTM.getIdenLicen());
                tmp.put("elemento4", miCuestVTM.getLocalizacionObra());
                tmp.put("elemento5", miCuestVTM.getRsPromo());
                nuevo.add(tmp);         
            }
        }catch(Exception e){}
        return nuevo;
    }

}