package q02a.cuestionariosVTMAnu.action;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.exception.NestableException;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.usermodel.contrib.HSSFRegionUtil;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesException;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.infraestructura.traza.Q70Traza;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

/**
 * Action especifico para estadisticas, que descarga un excel con los resultados actuales de la bsqueda de estadsticas.
 * 
 * @author JHIDALGO
 */

public class Q02aEstadisticasExcel extends Q70ActionPasoOP {

	private static Q70Traza tr = Q70Traza.getSingleton();
	private static String COMPONENTE = "EXCEL_ESTADISTICAS";

	private static final Map MES = new HashMap();
	private static final Map AGRUPACION = new HashMap();
	private static final Map TIPOOBRA = new HashMap();
	private static final Map DATO = new HashMap();

	static {// Inicializa mapas de constantes
		Q02aEstadisticasExcel.MES.put("0", "enero");
		Q02aEstadisticasExcel.MES.put("1", "febrero");
		Q02aEstadisticasExcel.MES.put("2", "marzo");
		Q02aEstadisticasExcel.MES.put("3", "abril");
		Q02aEstadisticasExcel.MES.put("4", "mayo");
		Q02aEstadisticasExcel.MES.put("5", "junio");
		Q02aEstadisticasExcel.MES.put("6", "julio");
		Q02aEstadisticasExcel.MES.put("7", "agosto");
		Q02aEstadisticasExcel.MES.put("8", "septiembre");
		Q02aEstadisticasExcel.MES.put("9", "octubre");
		Q02aEstadisticasExcel.MES.put("10", "noviembre");
		Q02aEstadisticasExcel.MES.put("11", "diciembre");

		Q02aEstadisticasExcel.AGRUPACION.put("0", "comarca");
		Q02aEstadisticasExcel.AGRUPACION.put("1", "area");
		Q02aEstadisticasExcel.AGRUPACION.put("2", "tamanyo");

		Q02aEstadisticasExcel.TIPOOBRA.put(null, "cualquiera");
		Q02aEstadisticasExcel.TIPOOBRA.put("0", "nueva");
		Q02aEstadisticasExcel.TIPOOBRA.put("1", "rehabilitacion");
		Q02aEstadisticasExcel.TIPOOBRA.put("2", "demolicion");

		Q02aEstadisticasExcel.DATO.put("0", "licencias");
		Q02aEstadisticasExcel.DATO.put("1", "NVN");
		Q02aEstadisticasExcel.DATO.put("2", "NVR");

	}

	// ESTILOS PERSONALIZADOS:
	private HSSFCellStyle STYLE_TITULO;
	private HSSFCellStyle STYLE_FILTRO;
	private HSSFCellStyle STYLE_FILTRO_VALOR;
	private HSSFCellStyle STYLE_COLUMNA;
	private HSSFCellStyle STYLE_FILA_PAR;
	private HSSFCellStyle STYLE_FILA_IMPAR;
	private HSSFCellStyle STYLE_FILA_TOTAL;

	/*
	 * (non-Javadoc)
	 * 
	 * @see es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP#processOP(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE,
	 * org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm,
	 * javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors actionErrors, ActionMapping mapping, ActionForm actionForm, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, "processOP: entrando.");
		// Datos a utilizar
		List datos = (List) contexto.get("listaEstadisticasVTM");
		Map filtroEst = (Map) contexto.get("filtroEst");
		Map filtro = (Map) contexto.get("filtro");

		HSSFWorkbook workbook = new HSSFWorkbook();// Reinicia libro

		this.createExcel((String) contexto.get("idioma"), workbook, datos, filtroEst, filtro);

		response.setContentType("application/vnd.ms-excel;charset=iso-8859-1");
		response.setHeader("Content-disposition", "attachment;filename=Estadistica.xls");

		workbook.write(response.getOutputStream());
		response.getOutputStream().flush();
		response.getOutputStream().close();
		tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, "processOP: saliendo.");

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP#processForward(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE,
	 * org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm,
	 * javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		if (errors.isEmpty()) {
			return mapping.findForward("ok");
		}
		return mapping.findForward("errores");

	}

	/**
	 * Crea el excel y alimenta sus datos
	 * 
	 * @param workbook
	 * @param datos
	 * @param filtroEst
	 * @param filtro
	 * @throws Q70GestorMensajesException
	 */
	private void createExcel(String idioma, HSSFWorkbook workbook, List datos, Map filtroEst, Map filtro) throws Q70GestorMensajesException {
		Properties i18n = Q70GestorMensajesi18n.getSingleton().getProperties("q02arecursosCuestionarios", idioma);
		this.preparaEstilos(workbook);// Prepara los estilos del excel;
		HSSFSheet sMun = workbook.createSheet(i18n.getProperty("gral.municipio"));
		HSSFSheet sAgrup = workbook.createSheet(i18n.getProperty("cuestionarios.estadisticas."
				+ Q02aEstadisticasExcel.AGRUPACION.get(filtroEst.get("agrupado"))));
		HSSFRow rMun, rAgrup;
		int rowMun = 0, rowAgrup = 0;
		short auxCol = 0;
		String auxMes;
		HSSFCellStyle styleAux;
		HSSFCell cellAux;

		tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, "createExcel: CREA TITULO");
		// CREA TITULO (en cada pestaa)
		rMun = sMun.createRow(rowMun++);
		rAgrup = sAgrup.createRow(rowAgrup++);
		sMun.addMergedRegion(new Region(rMun.getRowNum(), (short) 0, rMun.getRowNum(), (short) 13));
		sAgrup.addMergedRegion(new Region(rAgrup.getRowNum(), (short) 0, rAgrup.getRowNum(), (short) 13));
		Q02aEstadisticasExcel.celda(rMun, (short) 0, i18n.getProperty("cuestionarios.estadisticas.estadisticasmes"), HSSFCell.CELL_TYPE_STRING,
				this.STYLE_TITULO);
		Q02aEstadisticasExcel.celda(rAgrup, (short) 0, i18n.getProperty("cuestionarios.estadisticas.estadisticasapartado"), HSSFCell.CELL_TYPE_STRING,
				this.STYLE_TITULO);

		tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, "createExcel: CREA FILTRO");
		// CREA FILTRO (en cada pestaa)
		rowMun = rowMun + 2;
		rowAgrup = rowAgrup + 2;
		try {
			HSSFRegionUtil.setBorderBottom(HSSFCellStyle.BORDER_THIN, new Region(rowMun - 1, (short) 0, rowMun - 1, (short) 6), sMun, workbook);
			HSSFRegionUtil.setBorderBottom(HSSFCellStyle.BORDER_THIN, new Region(rowAgrup - 1, (short) 0, rowAgrup - 1, (short) 6), sAgrup, workbook);
		} catch (NestableException e) {// Continue
		}
		String valorAgrupado;
		if ("2".equalsIgnoreCase(String.valueOf(filtroEst.get("agrupado")))) {
			// Si se ha seleccionado tamao de municipio, se adjunta la descripcin del tamao seleccionado.
			valorAgrupado = i18n.getProperty("cuestionarios.estadisticas." + Q02aEstadisticasExcel.AGRUPACION.get(filtroEst.get("agrupado"))) + " ("
					+ filtroEst.get("descTamanyoMunicipio") + ")";
		} else {
			valorAgrupado = i18n.getProperty("cuestionarios.estadisticas." + Q02aEstadisticasExcel.AGRUPACION.get(filtroEst.get("agrupado")));
		}
		this.creaFiltro(sMun, sMun.createRow(rowMun++), i18n.getProperty("cuestionarios.estadisticas.municipio") + " :", String.valueOf(filtro.get("descMuni")));
		this.creaFiltro(sAgrup, sAgrup.createRow(rowAgrup++), i18n.getProperty("cuestionarios.estadisticas.agrupado") + " :", valorAgrupado);
		this.creaFiltro(sMun, sMun.createRow(rowMun++), i18n.getProperty("cuestionarios.estadisticas.tipoobra") + " :",
				i18n.getProperty("cuestionarios.estadisticas." + Q02aEstadisticasExcel.TIPOOBRA.get(filtroEst.get("tipoobra"))));
		this.creaFiltro(sAgrup, sAgrup.createRow(rowAgrup++), i18n.getProperty("cuestionarios.estadisticas.tipoobra") + " :",
				i18n.getProperty("cuestionarios.estadisticas." + Q02aEstadisticasExcel.TIPOOBRA.get(filtroEst.get("tipoobra"))));
		this.creaFiltro(sMun, sMun.createRow(rowMun++), i18n.getProperty("cuestionarios.estadisticas.anyodesde") + " :",
				String.valueOf(filtroEst.get("anyodesde")));
		this.creaFiltro(sAgrup, sAgrup.createRow(rowAgrup++), i18n.getProperty("cuestionarios.estadisticas.anyodesde") + " :",
				String.valueOf(filtroEst.get("anyodesde")));
		this.creaFiltro(sMun, sMun.createRow(rowMun++), i18n.getProperty("cuestionarios.estadisticas.anyohasta") + " :",
				String.valueOf(filtroEst.get("anyohasta")));
		this.creaFiltro(sAgrup, sAgrup.createRow(rowAgrup++), i18n.getProperty("cuestionarios.estadisticas.anyohasta") + " :",
				String.valueOf(filtroEst.get("anyohasta")));
		this.creaFiltro(sMun, sMun.createRow(rowMun++), i18n.getProperty("cuestionarios.estadisticas.dato") + " :",
				i18n.getProperty("cuestionarios.estadisticas." + Q02aEstadisticasExcel.DATO.get(filtroEst.get("dato"))));
		this.creaFiltro(sAgrup, sAgrup.createRow(rowAgrup++), i18n.getProperty("cuestionarios.estadisticas.dato") + " :",
				i18n.getProperty("cuestionarios.estadisticas." + Q02aEstadisticasExcel.DATO.get(filtroEst.get("dato"))));
		try {
			HSSFRegionUtil.setBorderTop(HSSFCellStyle.BORDER_THIN, new Region(rowMun, (short) 0, rowMun, (short) 6), sMun, workbook);
			HSSFRegionUtil.setBorderTop(HSSFCellStyle.BORDER_THIN, new Region(rowAgrup, (short) 0, rowAgrup, (short) 6), sAgrup, workbook);
		} catch (NestableException e) {// Continue
		}
		tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, "createExcel: CREA CABECERA DE DATOS");
		// CREA CABECERA DE DATOS (en cada pestaa)
		rowMun = rowMun + 2;
		rowAgrup = rowAgrup + 2;
		rMun = sMun.createRow(rowMun++);
		rAgrup = sAgrup.createRow(rowAgrup++);
		Q02aEstadisticasExcel.celda(rMun, auxCol, i18n.getProperty("cuestionariosVTM.estadisticas.anyo"), HSSFCell.CELL_TYPE_STRING, this.STYLE_COLUMNA);
		Q02aEstadisticasExcel.celda(rAgrup, auxCol++, i18n.getProperty("cuestionariosVTM.estadisticas.anyo"), HSSFCell.CELL_TYPE_STRING, this.STYLE_COLUMNA);
		for (int i = 0; i < 12; i++) {
			auxMes = (String) Q02aEstadisticasExcel.MES.get(String.valueOf(i));
			Q02aEstadisticasExcel.celda(rMun, auxCol, i18n.getProperty("cuestionariosVTM.estadisticas." + auxMes), HSSFCell.CELL_TYPE_STRING,
					this.STYLE_COLUMNA);
			Q02aEstadisticasExcel.celda(rAgrup, auxCol++, i18n.getProperty("cuestionariosVTM.estadisticas." + auxMes), HSSFCell.CELL_TYPE_STRING,
					this.STYLE_COLUMNA);
		}
		Q02aEstadisticasExcel.celda(rMun, auxCol, i18n.getProperty("cuestionariosVTM.estadisticas.total"), HSSFCell.CELL_TYPE_STRING, this.STYLE_COLUMNA);
		Q02aEstadisticasExcel.celda(rAgrup, auxCol++, i18n.getProperty("cuestionariosVTM.estadisticas.total"), HSSFCell.CELL_TYPE_STRING, this.STYLE_COLUMNA);

		tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, "createExcel: CREA DATOS");
		// CREA DATOS (en cada pestaa)
		for (int i = 0; i < datos.size(); i++) {
			if (i + 1 == datos.size()) {// Fila totales
				styleAux = this.STYLE_FILA_TOTAL;
			} else if (i % 2 == 0) {
				styleAux = this.STYLE_FILA_PAR;
			} else {
				styleAux = this.STYLE_FILA_IMPAR;
			}
			auxCol = 0;
			rMun = sMun.createRow(rowMun++);
			rAgrup = sAgrup.createRow(rowAgrup++);
			cellAux = Q02aEstadisticasExcel.celda(rMun, auxCol, ((Map) datos.get(i)).get("anyo"), HSSFCell.CELL_TYPE_STRING, styleAux);
			cellAux.getCellStyle().setAlignment(HSSFCellStyle.ALIGN_CENTER);
			cellAux = Q02aEstadisticasExcel.celda(rAgrup, auxCol++, ((Map) datos.get(i)).get("anyo1"), HSSFCell.CELL_TYPE_STRING, styleAux);
			cellAux.getCellStyle().setAlignment(HSSFCellStyle.ALIGN_CENTER);
			for (int j = 0; j < 12; j++) {
				auxMes = (String) Q02aEstadisticasExcel.MES.get(String.valueOf(j));
				Q02aEstadisticasExcel.celda(rMun, auxCol, ((Map) datos.get(i)).get(auxMes), HSSFCell.CELL_TYPE_NUMERIC, styleAux);
				Q02aEstadisticasExcel.celda(rAgrup, auxCol++, ((Map) datos.get(i)).get(auxMes + "1"), HSSFCell.CELL_TYPE_NUMERIC, styleAux);
			}
			Q02aEstadisticasExcel.celda(rMun, auxCol, ((Map) datos.get(i)).get("total"), HSSFCell.CELL_TYPE_NUMERIC, styleAux);
			Q02aEstadisticasExcel.celda(rAgrup, auxCol++, ((Map) datos.get(i)).get("total1"), HSSFCell.CELL_TYPE_NUMERIC, styleAux);
		}

		// Expande la anchura de las columnas
		for (short t = 0; t < 14; t++) {
			sMun.setColumnWidth(t, (short) 3000);
			sAgrup.setColumnWidth(t, (short) 3000);
		}
	}

	/**
	 * Crea las celdas para un filtro
	 * 
	 * @param sheet
	 * @param row
	 * @param nombre
	 * @param valor
	 */
	private void creaFiltro(HSSFSheet sheet, HSSFRow row, String nombre, String valor) {
		sheet.addMergedRegion(new Region(row.getRowNum(), (short) 0, row.getRowNum(), (short) 1));
		sheet.addMergedRegion(new Region(row.getRowNum(), (short) 2, row.getRowNum(), (short) 6));
		Q02aEstadisticasExcel.celda(row, (short) 0, nombre, HSSFCell.CELL_TYPE_STRING, this.STYLE_FILTRO);
		Q02aEstadisticasExcel.celda(row, (short) 2, valor, HSSFCell.CELL_TYPE_STRING, this.STYLE_FILTRO_VALOR);

	}

	/**
	 * Prepara los colores personalizados en la paleta de colores
	 * 
	 * @param workbook
	 */
	private void preparaEstilos(HSSFWorkbook workbook) {
		this.STYLE_TITULO = workbook.createCellStyle();
		this.STYLE_FILTRO = workbook.createCellStyle();
		this.STYLE_FILTRO_VALOR = workbook.createCellStyle();
		this.STYLE_COLUMNA = workbook.createCellStyle();
		this.STYLE_FILA_IMPAR = workbook.createCellStyle();
		this.STYLE_FILA_PAR = workbook.createCellStyle();
		this.STYLE_FILA_TOTAL = workbook.createCellStyle();

		// se pueden sobrescribir: TEAL, VIOLET, PINK, ROSE
		HSSFPalette palette = workbook.getCustomPalette();
		palette.setColorAtIndex(HSSFColor.ROSE.index, (byte) 242, // RGB red (0-255)
				(byte) 242, // RGB green
				(byte) 242 // RGB blue
		);
		palette.setColorAtIndex(HSSFColor.PINK.index, (byte) 202, // RGB red (0-255)
				(byte) 202, // RGB green
				(byte) 202 // RGB blue
		);
		HSSFFont fontAux = workbook.createFont();
		fontAux.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
		fontAux.setUnderline(HSSFFont.U_SINGLE);
		fontAux.setFontHeightInPoints((short) 16);
		fontAux.setColor(new HSSFColor.ROYAL_BLUE().getIndex());
		this.STYLE_TITULO.setFont(fontAux);

		this.STYLE_FILTRO.setAlignment(HSSFCellStyle.ALIGN_RIGHT);
		this.STYLE_FILTRO.setIndention((short) 1);
		fontAux = workbook.createFont();
		fontAux.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
		fontAux.setColor(new HSSFColor.SEA_GREEN().getIndex());
		this.STYLE_FILTRO.setFont(fontAux);

		this.STYLE_FILTRO_VALOR.setAlignment(HSSFCellStyle.ALIGN_LEFT);
		fontAux = workbook.createFont();
		fontAux.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
		fontAux.setColor(new HSSFColor.SEA_GREEN().getIndex());
		fontAux.setFontHeightInPoints((short) 11);
		this.STYLE_FILTRO_VALOR.setFont(fontAux);

		this.STYLE_COLUMNA.setFillBackgroundColor(new HSSFColor.ROYAL_BLUE().getIndex());
		this.STYLE_COLUMNA.setFillForegroundColor(new HSSFColor.ROYAL_BLUE().getIndex());
		this.STYLE_COLUMNA.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
		this.STYLE_COLUMNA.setAlignment(HSSFCellStyle.ALIGN_CENTER);
		this.setBordes(this.STYLE_COLUMNA, new HSSFColor.INDIGO(), HSSFCellStyle.BORDER_THIN);
		fontAux = workbook.createFont();
		fontAux.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
		fontAux.setColor(new HSSFColor.WHITE().getIndex());
		this.STYLE_COLUMNA.setFont(fontAux);

		this.STYLE_FILA_IMPAR.setFillBackgroundColor(new HSSFColor.ROSE().getIndex());
		this.STYLE_FILA_IMPAR.setFillForegroundColor(new HSSFColor.ROSE().getIndex());
		this.STYLE_FILA_IMPAR.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
		this.setBordes(this.STYLE_FILA_IMPAR, new HSSFColor.PINK(), HSSFCellStyle.BORDER_THIN);
		fontAux = workbook.createFont();
		this.STYLE_FILA_IMPAR.setFont(fontAux);

		this.STYLE_FILA_PAR.setFillBackgroundColor(new HSSFColor.WHITE().getIndex());
		this.STYLE_FILA_PAR.setFillForegroundColor(new HSSFColor.WHITE().getIndex());
		this.STYLE_FILA_PAR.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
		this.setBordes(this.STYLE_FILA_PAR, new HSSFColor.PINK(), HSSFCellStyle.BORDER_THIN);
		fontAux = workbook.createFont();
		this.STYLE_FILA_PAR.setFont(fontAux);

		this.STYLE_FILA_TOTAL.setFillBackgroundColor(new HSSFColor.GREY_25_PERCENT().getIndex());
		this.STYLE_FILA_TOTAL.setFillForegroundColor(new HSSFColor.GREY_25_PERCENT().getIndex());
		this.STYLE_FILA_TOTAL.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
		this.setBordes(this.STYLE_FILA_TOTAL, new HSSFColor.PINK(), HSSFCellStyle.BORDER_THIN);
		fontAux = workbook.createFont();
		fontAux.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
		this.STYLE_FILA_TOTAL.setFont(fontAux);

	}

	/**
	 * Encapsula la definicion de los bordes para un estilo
	 * 
	 * @param style
	 * @param color
	 * @param tipoBorde
	 */
	private void setBordes(HSSFCellStyle style, HSSFColor color, short tipoBorde) {
		style.setBorderBottom(tipoBorde);
		style.setBorderTop(tipoBorde);
		style.setBorderRight(tipoBorde);
		style.setBorderLeft(tipoBorde);
		style.setBottomBorderColor(color.getIndex());
		style.setTopBorderColor(color.getIndex());
		style.setRightBorderColor(color.getIndex());
		style.setLeftBorderColor(color.getIndex());
	}

	/**
	 * Crea una celda en la fila y columna especificadas. Las columnas de tipo fecha deben marcarse con el tipo HSSFCell.NUMERIC.
	 * 
	 * @param fila
	 * @param col
	 * @param val
	 * @param tipo
	 * @param estilo
	 * @return
	 */
	private static HSSFCell celda(HSSFRow fila, short col, Object val, int tipo, HSSFCellStyle estilo) {
		HSSFCell celda = fila.createCell(col);
		celda.setCellType(tipo);
		switch (tipo) {
		case HSSFCell.CELL_TYPE_NUMERIC:
			if (val instanceof Date) {
				celda.setCellValue(HSSFDateUtil.getExcelDate((Date) val));
			} else {
				celda.setCellValue(Double.parseDouble(String.valueOf(val)));
			}
			break;
		case HSSFCell.CELL_TYPE_BOOLEAN:
			celda.setCellValue(Boolean.valueOf(String.valueOf(val)).booleanValue());
			break;
		case HSSFCell.CELL_TYPE_FORMULA:
			celda.setCellValue(String.valueOf(val));
			celda.setCellFormula(String.valueOf(val));
			break;
		case HSSFCell.CELL_TYPE_STRING:
		default:
			celda.setCellValue(String.valueOf(val));
			break;
		}
		if (estilo != null) {
			celda.setCellStyle(estilo);
		}
		return celda;
	}

}
