package q02aCuestionariosVTMAnuSesionEJB;

import java.io.File;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;

import org.w3c.dom.Document;

import q02a.exe.comun.Q02aAplicException;
import q02a.exe.comun.Q02aAutenticador;
import q02a.exe.comun.Q02aDocumento;
import q02a.exe.cuestionariosVTMAnu.beans.Q02aCuestionariosVTMAnuBean;
import q02a.exe.cuestionariosVTMAnu.valueobjects.Q02aCuestionarioVTMAnu;
import q02a.exe.cuestionariosVTMAnu.valueobjects.Q02aCuestionarioVTMAnuFiltro;
import q02a.exe.cuestionariosVTMAnu.valueobjects.Q02aCuestionarioVTMFiltro;
import q02a.exe.listados.Q02AUtils;
import q02a.exe.utils.Q02aFormatData;
import q02a.exe.utils.Q02aVoUtils;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.infraestructura.traza.Q70Traza;

 
/**
 * XDoclet-based session bean.  The class must be declared
 * public according to the EJB specification.
 *
 * To generate the EJB related files to this EJB:
 *		- Add Standard EJB module to XDoclet project properties
 *		- Customize XDoclet configuration for your appserver
 *		- Run XDoclet
 *
 * Below are the xdoclet-related tags needed for this EJB.
 * 
 * @ejb.bean name="Q02aCuestionariosVTMAnuSesion"
 *           display-name="Name for Q02aCuestionariosVTMAnuSesion"
 *           description="Description for Q02aCuestionariosVTMAnuSesion"
 *           jndi-name="ejb/Q02aCuestionariosVTMAnuSesion"
 *           type="Stateless"
 *           view-type="remote"
 */
public class Q02aCuestionariosVTMAnuSesionBean implements SessionBean {
	
	private static final long serialVersionUID = 4131248384461301469L;
	private static Q70Traza tr = Q70Traza.getSingleton();
	private static final String COMPONENTE = "EJB_SESION_DATOS";
	protected Q02aCuestionariosVTMAnuBean beanCuestionarioVTMAnu= null;
	/** The session context */
	private javax.ejb.SessionContext mySessionCtx;
    /**
     * 
     *
     */
	public Q02aCuestionariosVTMAnuSesionBean() {
		super();
		// TODO Auto-generated constructor stub
	}
	/**
	 * Set the associated session context. The container calls this method 
	 * after the instance creation.
	 * 
	 * The enterprise bean instance should store the reference to the context 
	 * object in an instance variable.
	 * 
	 * This method is called with no transaction context. 
	 * 
	 * @throws EJBException Thrown if method fails due to system-level error.
	 */

    /**
	 * getSessionContext
     * @return mySessionCtx
	 */
	public javax.ejb.SessionContext getSessionContext() {
		return mySessionCtx;
	}
	/**
	 * setSessionContext
     * @param ctx ctx
	 */
	public void setSessionContext(javax.ejb.SessionContext ctx) {
		mySessionCtx = ctx;
	}
    /**
     * @throws EJBException EJBException
     * @throws RemoteException RemoteException
     */
	public void ejbRemove() throws EJBException, RemoteException {
		// TODO Auto-generated method stub
	}
    /**
     * @throws EJBException EJBException
     * @throws RemoteException RemoteException
     */
	public void ejbActivate() throws EJBException, RemoteException {
		// TODO Auto-generated method stub
	}
    /**
     * @throws EJBException EJBException
     * @throws RemoteException RemoteException
     * 
     */
	public void ejbPassivate() throws EJBException, RemoteException {
		// TODO Auto-generated method stub
	}
	/**
	 * An ejbCreate method as required by the EJB specification.
	 * 
	 * The container calls the instance?s <code>ejbCreate</code> method whose
	 * signature matches the signature of the <code>create</code> method invoked
	 * by the client. The input parameters sent from the client are passed to
	 * the <code>ejbCreate</code> method. Each session bean class must have at
	 * least one <code>ejbCreate</code> method. The number and signatures
	 * of a session bean?s <code>create</code> methods are specific to each 
	 * session bean class.
	 * 
	 * @throws CreateException Thrown if method fails due to system-level error.
	 * 
	 * @ejb.create-method
	 * 
	 */
	public void ejbCreate() throws CreateException {
		// TODO Add ejbCreate method implementation
	}  
	// -------------------------------------------------------------------------------------------------
	// ---------- CUESTIONARIOS VIVIENDA TASADA MUNICIPAL  ----------
	// -------------------------------------------------------------------------------------------------
	/**
	 * Insertar en bbdd un  nuevo cuestionario con los datos pasados como parametro en la HashMap
     * 
     * @param mapaCuestionarioVTMAnu mapaCuestionarioVTMAnu
     * @param mapaFiltroPortadaCuestionarioVTM mapaFiltroPortadaCuestionarioVTM
     * @param autenticador autenticador
     * @return niCuestionarioVTMAnu
	 * @throws Exception Exception
     */
	public String insertarCuestionarioVTMAnu(HashMap mapaCuestionarioVTMAnu, HashMap mapaFiltroPortadaCuestionarioVTM, Q02aAutenticador autenticador) throws Exception 
	{
		String niCuestionarioVTMAnu = "";
		Q02aCuestionarioVTMAnu cuestionarioVTMAnu = null;
		Q02aCuestionarioVTMAnuFiltro cuestionarioVTMFiltroPortada = null;
		String niGrupoCuesVTMAnu = null;
		try {
			
			if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarCuestionarioVTMAnu: entrando");
				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaCuestionarioVTMAnu : " + mapaCuestionarioVTMAnu.toString());
			}
			//se pasa el hashmap de entrada a un objeto de tipo Q02aCuestionarioVTMAnu	
			
			cuestionarioVTMAnu = (Q02aCuestionarioVTMAnu) Q02aVoUtils.getValueObject(mapaCuestionarioVTMAnu,"q02a.exe.cuestionariosVTMAnu.valueobjects.Q02aCuestionarioVTMAnu");
			//se instancia el bean de negocio
	  		beanCuestionarioVTMAnu= new Q02aCuestionariosVTMAnuBean();
	  		//se pasa el autenticador
	  		beanCuestionarioVTMAnu.setAutenticador(autenticador);
	  		//En caso de que vengamos de la portada, el campo niGrupoVTMAnu del mapa no va a tener ning?n valor
	  		//Puede que est? en el contexto (en caso de que estemos haciendo altas para los mismo parametros de portada)
	  		//o  no, en cuyo caso lo tendremos que obtener
	  		if(Q02aFormatData.esNullSinCero(cuestionarioVTMAnu.getNiGrupoCuesVTMAnu()).equals("")){ 
	  			cuestionarioVTMFiltroPortada = (Q02aCuestionarioVTMAnuFiltro) Q02aVoUtils.getValueObject(mapaFiltroPortadaCuestionarioVTM,"q02a.exe.cuestionariosVTMAnu.valueobjects.Q02aCuestionarioVTMAnuFiltro");
	  			niGrupoCuesVTMAnu = beanCuestionarioVTMAnu.altaModifGrupoCuestionariosVTMAnu(cuestionarioVTMFiltroPortada);
	  			cuestionarioVTMAnu.setNiGrupoCuesVTMAnu(niGrupoCuesVTMAnu);
	  		}
	  		else {niGrupoCuesVTMAnu = cuestionarioVTMAnu.getNiGrupoCuesVTMAnu();}
	  		
	  		//Miramos si hay que modificar el campo indicativo de si se han concedido licencias
	  		//Si el campo tiene valor 1, habr? que modificar el campo de la BD con el valor que tenga el campo realizaActuacion
	  		//Si el campo tiene valor 0, habr? que borrar los cuestionarios rellenados anteriormente y modificar el campo de la BD con el valor que tenga el campo realizaActuacion 
	
            if(cuestionarioVTMFiltroPortada!= null && Q02aFormatData.esNullSinCero(cuestionarioVTMFiltroPortada.getModificarConcedidoLicen()).equals("1")){
	  			beanCuestionarioVTMAnu.modificarGrupoCuestionariosVTM(niGrupoCuesVTMAnu,cuestionarioVTMFiltroPortada.getRealizaActuacion(),cuestionarioVTMFiltroPortada.getMes(), cuestionarioVTMFiltroPortada.getObsVTM());
	  		}
	  		
            //Poner el usuario de alta
            if ( cuestionarioVTMFiltroPortada.getUsuAlta() != null && !"".equals(cuestionarioVTMFiltroPortada.getUsuAlta()) )
            cuestionarioVTMAnu.setUsuAlta(cuestionarioVTMFiltroPortada.getUsuAlta());
            
            /////////////////////////////////////////////////////////////////////////
            //COMPLETAR CODIGOLICENCIA
            //Traer el id cuestionario ultimo
            
            String idSiguiente = "";
            StringBuffer codLic_StringBuf = new StringBuffer();
            StringBuffer cerosStringBuf = new StringBuffer();
            
            idSiguiente = beanCuestionarioVTMAnu.getIDCuestionarioMayorVTM(cuestionarioVTMFiltroPortada);
            
            if ( idSiguiente != null && !"".equals(idSiguiente)){
                    int numeroCodMax=Integer.parseInt(idSiguiente.trim());
                    numeroCodMax =(numeroCodMax + 1);
                    idSiguiente = String.valueOf(numeroCodMax);
                    
//                  Deben ser 4 cifras
                    if ( idSiguiente.length() < 4 ){
                        for ( int i=0; i < ( 4 -(idSiguiente.length()) ); i++){
                            cerosStringBuf.append("0");
                        }
                    }
                    
                    codLic_StringBuf.append( cuestionarioVTMAnu.getCodigoLicencia() );
                    if ( (cerosStringBuf.toString()).length() != 0){
                        codLic_StringBuf.append( cerosStringBuf.toString() );
                    }
                    codLic_StringBuf.append( idSiguiente );
                    cuestionarioVTMAnu.setCodigoLicencia( codLic_StringBuf.toString() );
            }else{
                    codLic_StringBuf.append( cuestionarioVTMAnu.getCodigoLicencia() )
                            .append("0001");
                    cuestionarioVTMAnu.setCodigoLicencia( codLic_StringBuf.toString() );
            }
            
            if ( cuestionarioVTMAnu.getIdenLicen() == null || "".equals(cuestionarioVTMAnu.getIdenLicen()) ){
                    cuestionarioVTMAnu.setIdenLicen( cuestionarioVTMAnu.getCodigoLicencia());                
            }
            
            ////////////////////////////////////////////////////////////////////////////
            
	  		//se llama al metodo del bean necesario 
            //INSERTAR
	  		niCuestionarioVTMAnu= beanCuestionarioVTMAnu.insertarCuestionarioVTMAnu(cuestionarioVTMAnu);
	  		beanCuestionarioVTMAnu.insertarContactoVTM(cuestionarioVTMFiltroPortada.getAno());
			return niCuestionarioVTMAnu;	
            
	     }catch(Exception ex){
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw); 
            if (tr.isTraceActive()){  
				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarCuestionarioVTMAnu: " + sw.getBuffer ().toString());
			}
            
            throw ex;
		 }finally{
			 if (tr.isTraceActive()){
					tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarCuestionarioVTMAnu: saliendo");
			}			
		}
	} // fin insertarCuestionarioVTMAnu
	/**
	 * Borrar de bbdd un cuestionario
	 * 
	 * @param niCuestionarioVTMAnu - Numero interno del cuestionario a borrar
	 * @param niGrupoCuestionarioVTMAnu niGrupoCuestionarioVTMAnu
     * @param autenticador autenticador
     * @throws Exception Exception
     */
	public void borrarCuestionarioVTMAnu(String niCuestionarioVTMAnu,String niGrupoCuestionarioVTMAnu, Q02aAutenticador autenticador) throws Exception
	{
		try {
			if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarCuestionarioVTMAnu: entrando con cuestionario: " + niCuestionarioVTMAnu);
			}
			beanCuestionarioVTMAnu= new Q02aCuestionariosVTMAnuBean();
			//se pasa el autenticador
	  		beanCuestionarioVTMAnu.setAutenticador(autenticador);
	  		//se llama al m?todo del bean necesario
			beanCuestionarioVTMAnu.borrarCuestionarioVTMAnu(niCuestionarioVTMAnu,niGrupoCuestionarioVTMAnu);			
	     }catch(Exception ex){
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarCuestionarioVTMAnu: " + sw.getBuffer ().toString());
			}
            throw ex;
		 }finally{
			 if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarCuestionarioVTMAnu: saliendo");
			 }	
		 }			 
		 
	} // fin borrarCuestionarioVTMAnu
	/**
	 * Modificar en bbdd un cuestionario con los datos pasados como par?metro en la HashMap
     * @param mapaCuestionarioVTMAnu mapaCuestionarioVTMAnu
     * @param autenticador autenticador
     * @throws Exception Exception
     * 
	 */
	public void modificarCuestionarioVTMAnu(HashMap mapaCuestionarioVTMAnu, Q02aAutenticador autenticador) throws Exception
	{
		Q02aCuestionarioVTMAnu cuestionarioVTMAnu = null;	  	
		try {
			if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarCuestionarioVTMAnu: entrando");
				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaCuestionarioVTMAnu : " + mapaCuestionarioVTMAnu.toString());
			}			
			//se pasa el hashmap de entrada a un objeto de tipo Q02aCuestionarioVTMAnu
			cuestionarioVTMAnu = (Q02aCuestionarioVTMAnu) Q02aVoUtils.getValueObject(mapaCuestionarioVTMAnu,"q02a.exe.cuestionariosVTMAnu.valueobjects.Q02aCuestionarioVTMAnu");
			
			beanCuestionarioVTMAnu= new Q02aCuestionariosVTMAnuBean();
			//se pasa el autenticador
	  		beanCuestionarioVTMAnu.setAutenticador(autenticador);
            
                         
			//se llama al metodo del bean para modificar el contacto
			beanCuestionarioVTMAnu.modificarCuestionarioVTMAnu(cuestionarioVTMAnu);			
		}catch(Exception ex){
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarCuestionarioVTMAnu: " + sw.getBuffer ().toString());
			}
            throw ex;
		 }finally{
			 if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarCuestionarioVTMAnu: saliendo");
			 }
		 }		
	} // fin modificarCuestionarioVTMAnu
	/**
	/**
     * Metodo que dado el numero interno del cuestionario recuperara de la BBDD
     * los datos de dicho cuestionario
     * @param niCuestionarioVTMAnu niCuestionarioVTMAnu
     * @param niGrupoCuestionarioVTMAnu niGrupoCuestionarioVTMAnu
     * @param autenticador autenticador
     * @return cuestionarioVTMAnu
     * @throws Exception Exception
     */
	public HashMap obtenerCuestionarioVTMAnu(String niCuestionarioVTMAnu,String niGrupoCuestionarioVTMAnu, Q02aAutenticador autenticador) throws Exception 
	{		
		//Definicion de variables
		HashMap cuestionarioVTMAnu =  new HashMap(); 
		Q02aCuestionarioVTMAnu cuestionarioVTMAnuVO = new Q02aCuestionarioVTMAnu();
		try{
			if (tr.isTraceActive())
			{
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioVTMAnu ejb-> ** niCuestionarioVTMAnu=:" + niCuestionarioVTMAnu + "  , niGrupoCuestionarioVTMAnu = " + niGrupoCuestionarioVTMAnu+ " ** entrando.");	   			
	   		}			
			beanCuestionarioVTMAnu= new Q02aCuestionariosVTMAnuBean();
			//se pasa el autenticador
	  		beanCuestionarioVTMAnu.setAutenticador(autenticador);
	  		//se llama al metodo del bean necesario			
	  		cuestionarioVTMAnuVO = beanCuestionarioVTMAnu.obtenerCuestionarioVTMAnu(niCuestionarioVTMAnu,niGrupoCuestionarioVTMAnu);
	  		//se pasa el resultado a un hashMap
	  		cuestionarioVTMAnu = (HashMap)Q02aVoUtils.getHashMap(cuestionarioVTMAnuVO);
			return cuestionarioVTMAnu;
		} catch(Q02aAplicException ex1){	 		  
	          java.io.StringWriter sw = new java.io.StringWriter();
	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	          ex1.printStackTrace(pw);
	          tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioVTMAnu: " + sw.getBuffer ().toString());
	          throw ex1;       	
		}catch(Exception ex){	 	
			java.io.StringWriter sw = new java.io.StringWriter();
			java.io.PrintWriter pw = new java.io.PrintWriter(sw);
			ex.printStackTrace(pw);
			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCuestionarioVTMAnu: " + sw.getBuffer ().toString());
			throw ex;                     
	 	}finally{    	
	        if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioVTMAnu: saliendo.");
	   		}
	 	}
	}//fin obtenerCuestionarioVTMAnu
    
    /**
     * Generar pdf de un cuestionario que dado el numero interno del cuestionario recuperara de la BBDD
     * los datos de dicho cuestionario
     * @param niCuestionarioVTMAnu niCuestionarioVTMAnu
     * @param niGrupoCuestionarioVTMAnu niGrupoCuestionarioVTMAnu
     * @param autenticador autenticador
     * @param filtro filtro
     * @return cuestionarioVAPM
     * @throws Exception Exception
     */
    public Q02aDocumento generarPdfCuestionarioVATMAnu(String niCuestionarioVTMAnu,String niGrupoCuestionarioVTMAnu, Q02aAutenticador autenticador, HashMap filtro) throws Exception 
    {
//      Definicion de variables
        Q02aCuestionarioVTMAnu cuestionarioVTMAnuVO = new Q02aCuestionarioVTMAnu();
        
        String idioma = autenticador.getIdioma();
        
        try{
            if (tr.isTraceActive())
            {
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":generarPdfCuestionarioVATMAnu ejb-> ** niCuestionarioVTMAnu=:" + niCuestionarioVTMAnu + "  , niGrupoCuestionarioVTMAnu = " + niGrupoCuestionarioVTMAnu+ " ** entrando.");                
            }           
            beanCuestionarioVTMAnu= new Q02aCuestionariosVTMAnuBean();
            //se pasa el autenticador
            beanCuestionarioVTMAnu.setAutenticador(autenticador);
            //se llama al metodo del bean necesario         
            cuestionarioVTMAnuVO = beanCuestionarioVTMAnu.obtenerCuestionarioVTMAnu(niCuestionarioVTMAnu,niGrupoCuestionarioVTMAnu);
            
          //////////////////////////////////////////////////////////////////////////////
            
            File pdfFile=null;
            String charset = "UTF-8";
            String CONFIG_LISTADOS_PATH_TMP = "/datos/q02a/tmp";
            try{
                final File tempPath = new File(CONFIG_LISTADOS_PATH_TMP);
                pdfFile=File.createTempFile("CuestionarioVTMA", ".pdf", tempPath);
                //System.out.println(pdfFile);
            }catch(Exception e){
                //System.out.println("Excepcion al crear pdf temporal en estadistica obra mayor");
                throw new EJBException("Excepcion al crear pdf temporal en estadistica obra mayor", e);
            }
            
            try{
                //Descripciones provincia, municipio, localidad, tipoVia
                String desc_Entidad = ""; String desc_TipoVia = ""; String desc_Calle = ""; String portal = ""; 
                //Promotor
                String promo_descProv = ""; String promo_descMuni = ""; String promo_descEntidad = ""; 
                String promo_descTipoVia = ""; String promo_descCalle = ""; String promo_portal = ""; 
                
                desc_Entidad = cuestionarioVTMAnuVO.getEnti() == null?"":( q02a.exe.ejbs.noraConsultas.Q02AUtilsEjbs.getLocalidad( cuestionarioVTMAnuVO.getEnti().toString() ) ) ;
                desc_TipoVia = cuestionarioVTMAnuVO.getTvia() == null?"":( q02a.exe.ejbs.noraConsultas.Q02AUtilsEjbs.getTipo_Via( cuestionarioVTMAnuVO.getTvia().toString(), idioma ) ) ;
                desc_Calle = cuestionarioVTMAnuVO.getCalle() == null?"":( q02a.exe.ejbs.noraConsultas.Q02AUtilsEjbs.getCalle( cuestionarioVTMAnuVO.getCalle().toString(), idioma )  );
                portal = cuestionarioVTMAnuVO.getPorClPor()== null?"":( q02a.exe.ejbs.noraConsultas.Q02AUtilsEjbs.getPortal( cuestionarioVTMAnuVO.getPorClPor().toString() )  );
                promo_descProv = cuestionarioVTMAnuVO.getMunProv() == null?"":( q02a.exe.ejbs.noraConsultas.Q02AUtilsEjbs.getProvincia( cuestionarioVTMAnuVO.getMunProv().toString() )  );
                promo_descMuni = cuestionarioVTMAnuVO.getMunMuni() == null?"":( q02a.exe.ejbs.noraConsultas.Q02AUtilsEjbs.getMunicipio( cuestionarioVTMAnuVO.getMunProv().toString(), cuestionarioVTMAnuVO.getMunMuni().toString() )  );
                promo_descEntidad = cuestionarioVTMAnuVO.getEntiPro() == null?"":( q02a.exe.ejbs.noraConsultas.Q02AUtilsEjbs.getLocalidad( cuestionarioVTMAnuVO.getEntiPro().toString() ) ) ;
                promo_descTipoVia = cuestionarioVTMAnuVO.getTviaPro() == null?"":( q02a.exe.ejbs.noraConsultas.Q02AUtilsEjbs.getTipo_Via( cuestionarioVTMAnuVO.getTviaPro().toString(), idioma ) ) ;
                promo_descCalle = cuestionarioVTMAnuVO.getCallePro() == null?"":( q02a.exe.ejbs.noraConsultas.Q02AUtilsEjbs.getCalle( cuestionarioVTMAnuVO.getCallePro().toString(), idioma )  );
                promo_portal = cuestionarioVTMAnuVO.getPorClPorPro()== null?"":( q02a.exe.ejbs.noraConsultas.Q02AUtilsEjbs.getPortal( cuestionarioVTMAnuVO.getPorClPorPro().toString() )  );
                
                //Num Cuestionario
                String numCuestionario = ("".equals(niCuestionarioVTMAnu.toString()) ) ?"":( niCuestionarioVTMAnu.toString() );
                //Formamos el xml.
                String rutaXsl = "/html/datos/xsl/q02acuestionarioVTMA.xsl";
                
                //final String imgName = "/html/datos/xsl/images/escudo.gif";
                final String imgName = "/html/datos/xsl/images/logoPDF.jpg";
                final String uno = "/html/datos/xsl/images/uno.jpg";
                final String dos = "/html/datos/xsl/images/dos.jpg";
                final String tres = "/html/datos/xsl/images/tres.jpg";
                final String cuatro = "/html/datos/xsl/images/cuatro.jpg";
                final String cinco = "/html/datos/xsl/images/cinco.jpg";
                final String seis = "/html/datos/xsl/images/seis.jpg";
                final String siete = "/html/datos/xsl/images/siete.jpg";
                final String ocho = "/html/datos/xsl/images/ocho.jpg";
                final String nueve = "/html/datos/xsl/images/nueve.jpg";
                final String nueve1 = "/html/datos/xsl/images/nueve1.jpg";
                final String nueve2 = "/html/datos/xsl/images/nueve2.jpg";
                final String diez = "/html/datos/xsl/images/diez.jpg";
                final String once = "/html/datos/xsl/images/once.jpg";
                final String doce = "/html/datos/xsl/images/doce.jpg";
                final String trece = "/html/datos/xsl/images/trece.jpg";
                final String catorce = "/html/datos/xsl/images/catorce.jpg";
                
                final String flechaV = "/html/datos/xsl/images/flechaV.gif";
                final String flechaV2 = "/html/datos/xsl/images/flechaV2.jpg";
                final String flechaH = "/html/datos/xsl/images/flechaH.gif";
                final String flechaH2 = "/html/datos/xsl/images/flechaH2.jpg";
                String fin = ""; String finFlecha = ""; 
                if ( idioma.equals("es") ){
                        fin = "/html/datos/xsl/images/fin.jpg";
                        finFlecha = "/html/datos/xsl/images/finFlecha.jpg";
                }else{
                        fin = "/html/datos/xsl/images/amaiera.jpg";
                        finFlecha = "/html/datos/xsl/images/amaieraFlecha.jpg";
                        rutaXsl = "/html/datos/xsl/q02acuestionarioVTMA_EU.xsl";
                }
                
                final String mes = filtro.get("mes").toString();
                String anyo = filtro.get("ano").toString();
                if (filtro.get("ano").toString() != null && 
                        !"".equals(filtro.get("ano").toString()) && anyo.length() == 4){
                    anyo = anyo.substring(2, 4);
                }
               
                
                
                //TEXTOS
                
                final String textoDirServiciosEs = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.dirServicios",  "es");
                final String textoDirServiciosEus = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.dirServicios",  "eu");
                final String textoTituloVATM = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.titulo",  idioma);
                final String textoPie = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.pie",  idioma);
                final String textoAnyo = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.anyo",  idioma);
                final String textoMes = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.mes",  idioma);
                final String textoNumCuestionario =  Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.numCuestionario",  idioma);
                
                final String titulo1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.titulo1",  idioma);
                final String titulo2 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.titulo2",  idioma);
                final String titulo3 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.titulo3",  idioma);
                final String titulo4 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.titulo4",  idioma);
                final String titulo5 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.titulo5",  idioma);
                final String titulo6 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.titulo6",  idioma);
                final String titulo7 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.titulo7",  idioma);
                final String titulo8 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.titulo8",  idioma);
                final String titulo8_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.titulo8_1",  idioma);
                final String titulo9 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.titulo9",  idioma);
                final String titulo9_2 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.titulo9_2",  idioma);
                final String titulo10 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.titulo10",  idioma);
                final String titulo11 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.titulo11",  idioma);
                final String titulo12 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.titulo12",  idioma);
                final String titulo13 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.titulo13",  idioma);
                final String titulo14 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.titulo14",  idioma);
                //
                final String texto1_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto1_1",  idioma);
                final String texto1_2 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto1_2",  idioma);
                final String texto2_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto2_1",  idioma);
                final String texto2_2 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto2_2",  idioma);
                final String texto2_3 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto2_3",  idioma);
                final String texto3_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto3_1",  idioma);
                final String texto3_2 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto3_2",  idioma);
                final String texto4_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto4_1",  idioma);
                final String texto4_2 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto4_2",  idioma);
                final String texto4_3 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto4_3",  idioma);
                final String texto4_4 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto4_4",  idioma);
                final String texto4_5 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto4_5",  idioma);
                final String texto4_6 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto4_6",  idioma);
                final String texto4_7 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto4_7",  idioma);
                final String texto5_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto5_1",  idioma);
                final String texto5_2 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto5_2",  idioma);
                final String texto5_3 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto5_3",  idioma);
                final String texto5_3_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto5_3_1",  idioma);
                final String texto5_3_2 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto5_3_2",  idioma);
                final String texto5_3_3 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto5_3_3",  idioma);
                final String texto5_3_4 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto5_3_4",  idioma);
                final String texto5_3_5 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto5_3_5",  idioma);
                final String texto5_3_6 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto5_3_6",  idioma);
                final String texto5_3_7 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto5_3_7",  idioma);
                final String texto5_3_8 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto5_3_8",  idioma);
                final String texto5_3_9 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto5_3_9",  idioma);
                
                final String texto5_4 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto5_4",  idioma);
                final String texto5_4_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto5_4_1",  idioma);
                final String texto5_4_2 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto5_4_2",  idioma);
                final String texto5_4_3 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto5_4_3",  idioma);
                final String texto5_4_4 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto5_4_4",  idioma);
                final String texto6_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto6_1",  idioma);
                final String texto6_2 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto6_2",  idioma);
                final String texto6_2_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto6_2_1",  idioma);
                final String texto6_2_2 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto6_2_2",  idioma);
                final String texto7_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto7_1",  idioma);
                final String texto7_1_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto7_1_1",  idioma);
                final String texto7_1_2 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto7_1_2",  idioma);
                final String texto7_2 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto7_2",  idioma);
                final String texto7_2_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto7_2_1",  idioma);
                final String texto7_2_2 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto7_2_2",  idioma);
                final String texto7_3 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto7_3",  idioma);
                final String texto7_3_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto7_3_1",  idioma);
                final String texto8_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto8_1",  idioma);
                final String texto8_1_A_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto8_1_A_1",  idioma);
                final String texto8_1_A_2 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto8_1_A_2",  idioma);
                final String texto8_2 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto8_2",  idioma);
                final String texto8_2_A = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto8_2_A",  idioma);
                final String texto8_2_B = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto8_2_B",  idioma);
                final String texto8_2_C = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto8_2_C",  idioma);
                final String texto8_2_D = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto8_2_D",  idioma);
                final String texto8_2_E = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto8_2_E",  idioma);
                final String texto8_2_F = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto8_2_F",  idioma);
                final String texto8_2_G = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto8_2_G",  idioma);
                final String texto8_2_H = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto8_2_H",  idioma);
                final String texto8_2_I = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto8_2_I",  idioma);
                final String texto8_2_J = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto8_2_J",  idioma);
                final String texto9_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto9_1",  idioma);
                final String texto9_2 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto9_2",  idioma);
                final String texto9_2_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto9_2_1",  idioma);
                final String texto9_2_2 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto9_2_2",  idioma);
                final String texto9_2_3 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto9_2_3",  idioma);
                final String texto9_2_4 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto9_2_4",  idioma);
                final String texto10_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto10_1",  idioma);
                final String texto10_2_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto10_2_1",  idioma);
                final String texto10_2_2 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto10_2_2",  idioma);
                final String texto10_3_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto10_3_1",  idioma);
                final String texto10_3_2 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto10_3_2",  idioma);
                final String texto10_4_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto10_4_1",  idioma);
                final String texto10_4_2 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto10_4_2",  idioma);
                final String texto10_5 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto10_5",  idioma);
                final String texto10_6 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto10_6",  idioma);
                final String texto10_7_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto10_7_1",  idioma);
                final String texto10_7_2 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto10_7_2",  idioma);
                final String texto10_8_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto10_8_1",  idioma);
                final String texto10_8_2 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto10_8_2",  idioma);
                final String texto10_9 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto10_9",  idioma);
                final String texto11_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto11_1",  idioma);
                final String texto11_2 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto11_2",  idioma);
                final String texto11_3 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto11_3",  idioma);
                final String texto11_4 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto11_4",  idioma);
                final String texto11_5 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto11_5",  idioma);
                final String texto12_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto12_1",  idioma);
                final String texto12_2 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto12_2",  idioma);
                final String texto12_3 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto12_3",  idioma);
                final String texto13_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.texto13_1",  idioma);
                
                
                final String textoSi = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.texto.SI",  idioma);
                final String textoNo = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.texto.NO",  idioma);
                final String textoEspecificar = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.texto.especificar",  idioma);
                
                //XML
                StringBuffer xml= new StringBuffer("");
                xml.append("<?xml version=\"1.0\" encoding='ISO-8859-1'?>\n");
                xml.append("\t<cuestionario>\n");
                            
                       // xml.append("\t<url>").append(imgName.toString()).append("</url>\n");
                        xml.append("\t<url>").append(getClass().getResource(imgName).toString()).append("</url>\n");
                        //imagenes
                        xml.append("\t<uno>").append(getClass().getResource(uno).toString()).append("</uno>\n");
                        xml.append("\t<dos>").append(getClass().getResource(dos).toString()).append("</dos>\n");
                        xml.append("\t<tres>").append(getClass().getResource(tres).toString()).append("</tres>\n");
                        xml.append("\t<cuatro>").append(getClass().getResource(cuatro).toString()).append("</cuatro>\n");
                        xml.append("\t<cinco>").append(getClass().getResource(cinco).toString()).append("</cinco>\n");
                        xml.append("\t<seis>").append(getClass().getResource(seis).toString()).append("</seis>\n");
                        xml.append("\t<siete>").append(getClass().getResource(siete).toString()).append("</siete>\n");
                        xml.append("\t<ocho>").append(getClass().getResource(ocho).toString()).append("</ocho>\n");
                        xml.append("\t<nueve>").append(getClass().getResource(nueve).toString()).append("</nueve>\n");
                        xml.append("\t<nueve1>").append(getClass().getResource(nueve1).toString()).append("</nueve1>\n");
                        xml.append("\t<nueve2>").append(getClass().getResource(nueve2).toString()).append("</nueve2>\n");
                        xml.append("\t<diez>").append(getClass().getResource(diez).toString()).append("</diez>\n");
                        xml.append("\t<once>").append(getClass().getResource(once).toString()).append("</once>\n");
                        xml.append("\t<doce>").append(getClass().getResource(doce).toString()).append("</doce>\n");
                        xml.append("\t<trece>").append(getClass().getResource(trece).toString()).append("</trece>\n");
                        xml.append("\t<catorce>").append(getClass().getResource(catorce).toString()).append("</catorce>\n");
                        
                        xml.append("\t<fin>").append(getClass().getResource(fin).toString()).append("</fin>\n");
                        xml.append("\t<finFlecha>").append(getClass().getResource(finFlecha).toString()).append("</finFlecha>\n");
                        xml.append("\t<flechaV>").append(getClass().getResource(flechaV).toString()).append("</flechaV>\n");
                        xml.append("\t<flechaV2>").append(getClass().getResource(flechaV2).toString()).append("</flechaV2>\n");
                        xml.append("\t<flechaH>").append(getClass().getResource(flechaH).toString()).append("</flechaH>\n");
                        xml.append("\t<flechaH2>").append(getClass().getResource(flechaH2).toString()).append("</flechaH2>\n");
                        //textos
                        xml.append("\t<tituloVATM>").append( textoTituloVATM ).append("</tituloVATM>\n");
                        xml.append("\t<dirServiciosEus>").append( textoDirServiciosEus ).append("</dirServiciosEus>\n");
                        xml.append("\t<dirServiciosEs>").append( textoDirServiciosEs ).append("</dirServiciosEs>\n");
                        xml.append("\t<textoPie>").append( textoPie ).append("</textoPie>\n");
                        xml.append("\t<textoAnyo>").append( textoAnyo ).append("</textoAnyo>\n");
                        xml.append("\t<textoMes>").append( textoMes ).append("</textoMes>\n");
                        xml.append("\t<textoNumCuestionario>").append( textoNumCuestionario ).append("</textoNumCuestionario>\n");
                        //
                        xml.append("\t<titulo1>").append( titulo1 ).append("</titulo1>\n");
                        xml.append("\t<titulo2>").append( titulo2 ).append("</titulo2>\n");
                        xml.append("\t<titulo3>").append( titulo3 ).append("</titulo3>\n");
                        xml.append("\t<titulo4>").append( titulo4 ).append("</titulo4>\n");
                        xml.append("\t<titulo5>").append( titulo5 ).append("</titulo5>\n");
                        xml.append("\t<titulo6>").append( titulo6 ).append("</titulo6>\n");
                        xml.append("\t<titulo7>").append( titulo7 ).append("</titulo7>\n");
                        xml.append("\t<titulo8>").append( titulo8 ).append("</titulo8>\n");
                        xml.append("\t<titulo8_1>").append( titulo8_1 ).append("</titulo8_1>\n");
                        xml.append("\t<titulo9>").append( titulo9 ).append("</titulo9>\n");
                        xml.append("\t<titulo9_2>").append( titulo9_2 ).append("</titulo9_2>\n");
                        xml.append("\t<titulo10>").append( titulo10 ).append("</titulo10>\n");
                        xml.append("\t<titulo11>").append( titulo11 ).append("</titulo11>\n");
                        xml.append("\t<titulo12>").append( titulo12 ).append("</titulo12>\n");
                        xml.append("\t<titulo13>").append( titulo13 ).append("</titulo13>\n");
                        xml.append("\t<titulo14>").append( titulo14 ).append("</titulo14>\n");
                        
                        xml.append("\t<textoSi>").append( textoSi ).append("</textoSi>\n");
                        xml.append("\t<textoNo>").append( textoNo ).append("</textoNo>\n");
                        xml.append("\t<textoEspecificar>").append( textoEspecificar ).append("</textoEspecificar>\n");
                        
                        //
                        xml.append("\t<texto1_1>").append( texto1_1 ).append("</texto1_1>\n");
                        xml.append("\t<texto1_2>").append( texto1_2 ).append("</texto1_2>\n");
                        xml.append("\t<texto2_1>").append( texto2_1 ).append("</texto2_1>\n");
                        xml.append("\t<texto2_2>").append( texto2_2 ).append("</texto2_2>\n");
                        xml.append("\t<texto2_3>").append( texto2_3 ).append("</texto2_3>\n");
                        xml.append("\t<texto3_1>").append( texto3_1 ).append("</texto3_1>\n");
                        xml.append("\t<texto3_2>").append( texto3_2 ).append("</texto3_2>\n");
                        xml.append("\t<texto4_1>").append( texto4_1 ).append("</texto4_1>\n");
                        xml.append("\t<texto4_2>").append( texto4_2 ).append("</texto4_2>\n");
                        xml.append("\t<texto4_3>").append( texto4_3 ).append("</texto4_3>\n");
                        xml.append("\t<texto4_4>").append( texto4_4 ).append("</texto4_4>\n");
                        xml.append("\t<texto4_5>").append( texto4_5 ).append("</texto4_5>\n");
                        xml.append("\t<texto4_6>").append( texto4_6 ).append("</texto4_6>\n");
                        xml.append("\t<texto4_7>").append( texto4_7 ).append("</texto4_7>\n");
                        xml.append("\t<texto5_1>").append( texto5_1 ).append("</texto5_1>\n");
                        xml.append("\t<texto5_2>").append( texto5_2 ).append("</texto5_2>\n");
                        xml.append("\t<texto5_3>").append( texto5_3 ).append("</texto5_3>\n");
                        xml.append("\t<texto5_3_1>").append( texto5_3_1 ).append("</texto5_3_1>\n");
                        xml.append("\t<texto5_3_2>").append( texto5_3_2 ).append("</texto5_3_2>\n");
                        xml.append("\t<texto5_3_3>").append( texto5_3_3 ).append("</texto5_3_3>\n");
                        xml.append("\t<texto5_3_4>").append( texto5_3_4 ).append("</texto5_3_4>\n");
                        xml.append("\t<texto5_3_5>").append( texto5_3_5 ).append("</texto5_3_5>\n");
                        xml.append("\t<texto5_3_6>").append( texto5_3_6 ).append("</texto5_3_6>\n");
                        xml.append("\t<texto5_3_7>").append( texto5_3_7 ).append("</texto5_3_7>\n");
                        xml.append("\t<texto5_3_8>").append( texto5_3_8 ).append("</texto5_3_8>\n");
                        xml.append("\t<texto5_3_9>").append( texto5_3_9 ).append("</texto5_3_9>\n");
                        xml.append("\t<texto5_4>").append( texto5_4 ).append("</texto5_4>\n");
                        xml.append("\t<texto5_4_1>").append( texto5_4_1 ).append("</texto5_4_1>\n");
                        xml.append("\t<texto5_4_2>").append( texto5_4_2 ).append("</texto5_4_2>\n");
                        xml.append("\t<texto5_4_3>").append( texto5_4_3 ).append("</texto5_4_3>\n");
                        xml.append("\t<texto5_4_4>").append( texto5_4_4 ).append("</texto5_4_4>\n");
                        xml.append("\t<texto6_1>").append( texto6_1 ).append("</texto6_1>\n");
                        xml.append("\t<texto6_2>").append( texto6_2 ).append("</texto6_2>\n");
                        xml.append("\t<texto6_2_1>").append( texto6_2_1 ).append("</texto6_2_1>\n");
                        xml.append("\t<texto6_2_2>").append( texto6_2_2 ).append("</texto6_2_2>\n");
                        xml.append("\t<texto7_1>").append( texto7_1 ).append("</texto7_1>\n");
                        xml.append("\t<texto7_1_1>").append( texto7_1_1 ).append("</texto7_1_1>\n");
                        xml.append("\t<texto7_1_2>").append( texto7_1_2 ).append("</texto7_1_2>\n");
                        xml.append("\t<texto7_2>").append( texto7_2 ).append("</texto7_2>\n");
                        xml.append("\t<texto7_2_1>").append( texto7_2_1 ).append("</texto7_2_1>\n");
                        xml.append("\t<texto7_2_2>").append( texto7_2_2 ).append("</texto7_2_2>\n");
                        xml.append("\t<texto7_3>").append( texto7_3 ).append("</texto7_3>\n");
                        xml.append("\t<texto7_3_1>").append( texto7_3_1 ).append("</texto7_3_1>\n");
                        xml.append("\t<texto8_1>").append( texto8_1 ).append("</texto8_1>\n");
                        xml.append("\t<texto8_1_A_1>").append( texto8_1_A_1 ).append("</texto8_1_A_1>\n");
                        xml.append("\t<texto8_1_A_2>").append( texto8_1_A_2 ).append("</texto8_1_A_2>\n");
                        xml.append("\t<texto8_2>").append( texto8_2 ).append("</texto8_2>\n");
                        xml.append("\t<texto8_2_A>").append( texto8_2_A ).append("</texto8_2_A>\n");
                        xml.append("\t<texto8_2_B>").append( texto8_2_B ).append("</texto8_2_B>\n");
                        xml.append("\t<texto8_2_C>").append( texto8_2_C ).append("</texto8_2_C>\n");
                        xml.append("\t<texto8_2_D>").append( texto8_2_D ).append("</texto8_2_D>\n");
                        xml.append("\t<texto8_2_E>").append( texto8_2_E ).append("</texto8_2_E>\n");
                        xml.append("\t<texto8_2_F>").append( texto8_2_F ).append("</texto8_2_F>\n");
                        xml.append("\t<texto8_2_G>").append( texto8_2_G ).append("</texto8_2_G>\n");
                        xml.append("\t<texto8_2_H>").append( texto8_2_H ).append("</texto8_2_H>\n");
                        xml.append("\t<texto8_2_I>").append( texto8_2_I ).append("</texto8_2_I>\n");
                        xml.append("\t<texto8_2_J>").append( texto8_2_J ).append("</texto8_2_J>\n");
                        xml.append("\t<texto9_1>").append( texto9_1 ).append("</texto9_1>\n");
                        xml.append("\t<texto9_2>").append( texto9_2 ).append("</texto9_2>\n");
                        xml.append("\t<texto9_2_1>").append( texto9_2_1 ).append("</texto9_2_1>\n");
                        xml.append("\t<texto9_2_2>").append( texto9_2_2 ).append("</texto9_2_2>\n");
                        xml.append("\t<texto9_2_3>").append( texto9_2_3 ).append("</texto9_2_3>\n");
                        xml.append("\t<texto9_2_4>").append( texto9_2_4 ).append("</texto9_2_4>\n");
                        
                        xml.append("\t<texto10_1>").append( texto10_1 ).append("</texto10_1>\n");
                        xml.append("\t<texto10_2_1>").append( texto10_2_1 ).append("</texto10_2_1>\n");
                        xml.append("\t<texto10_2_2>").append( texto10_2_2 ).append("</texto10_2_2>\n");
                        xml.append("\t<texto10_3_1>").append( texto10_3_1 ).append("</texto10_3_1>\n");
                        xml.append("\t<texto10_3_2>").append( texto10_3_2 ).append("</texto10_3_2>\n");
                        xml.append("\t<texto10_4_1>").append( texto10_4_1 ).append("</texto10_4_1>\n");
                        xml.append("\t<texto10_4_2>").append( texto10_4_2 ).append("</texto10_4_2>\n");
                        xml.append("\t<texto10_5>").append( texto10_5 ).append("</texto10_5>\n");
                        xml.append("\t<texto10_6>").append( texto10_6 ).append("</texto10_6>\n"); 
                        xml.append("\t<texto10_7_1>").append( texto10_7_1 ).append("</texto10_7_1>\n");
                        xml.append("\t<texto10_7_2>").append( texto10_7_2 ).append("</texto10_7_2>\n");
                        xml.append("\t<texto10_8_1>").append( texto10_8_1 ).append("</texto10_8_1>\n");
                        xml.append("\t<texto10_8_2>").append( texto10_8_2 ).append("</texto10_8_2>\n");
                        xml.append("\t<texto10_9>").append( texto10_9 ).append("</texto10_9>\n");
                        xml.append("\t<texto11_1>").append( texto11_1 ).append("</texto11_1>\n");
                        xml.append("\t<texto11_2>").append( texto11_2 ).append("</texto11_2>\n");
                        xml.append("\t<texto11_3>").append( texto11_3 ).append("</texto11_3>\n");
                        xml.append("\t<texto11_4>").append( texto11_4 ).append("</texto11_4>\n");
                        xml.append("\t<texto11_5>").append( texto11_5 ).append("</texto11_5>\n");
                        xml.append("\t<texto12_1>").append( texto12_1 ).append("</texto12_1>\n");
                        xml.append("\t<texto12_2>").append( texto12_2 ).append("</texto12_2>\n");
                        xml.append("\t<texto12_3>").append( texto12_3 ).append("</texto12_3>\n");
                        xml.append("\t<texto13_1>").append( texto13_1 ).append("</texto13_1>\n");
                        //
                        xml.append("\t<mes>").append( mes.toString() ).append("</mes>\n");
                        xml.append("\t<anyo>").append( anyo.toString() ).append("</anyo>\n");
                        xml.append("\t<numCuestionario>").append( numCuestionario ).append("</numCuestionario>\n");
                            //
                            xml.append("\t<idenLicen>").append( cuestionarioVTMAnuVO.getIdenLicen() == null?"":(cuestionarioVTMAnuVO.getIdenLicen()) ).append("</idenLicen>\n");
                            xml.append("\t<fecEnt>").append( cuestionarioVTMAnuVO.getFecEnt() == null?"":(cuestionarioVTMAnuVO.getFecEnt()) ).append("</fecEnt>\n");
                            xml.append("\t<estadoLicen>").append( cuestionarioVTMAnuVO.getEstadoLicen() == null?"":(cuestionarioVTMAnuVO.getEstadoLicen()) ).append("</estadoLicen>\n");
                            xml.append("\t<causaBaja>").append( cuestionarioVTMAnuVO.getCausaBaja() == null?"":(cuestionarioVTMAnuVO.getCausaBaja()) ).append("</causaBaja>\n");
                            
                            xml.append("\t<entidad>").append( desc_Entidad ).append("</entidad>\n");
                            xml.append("\t<tipoVia>").append( desc_TipoVia ).append("</tipoVia>\n");                            
                            xml.append("\t<denominacionVia>").append( desc_Calle ).append("</denominacionVia>\n");
                            xml.append("\t<portal>").append( portal ).append("</portal>\n");
                            xml.append("\t<bloque>").append( cuestionarioVTMAnuVO.getBloq() == null?"":(cuestionarioVTMAnuVO.getBloq()) ).append("</bloque>\n");
                            xml.append("\t<bis>").append( cuestionarioVTMAnuVO.getBis() == null?"":(cuestionarioVTMAnuVO.getBis()) ).append("</bis>\n");
                            
                            
                            if ( cuestionarioVTMAnuVO.getDirNueva() != null){
                                xml.append("\t<complementoDir>").append( cuestionarioVTMAnuVO.getDirNueva() ).append("</complementoDir>\n");
                            }else{
                                xml.append("\t<complementoDir>").append( cuestionarioVTMAnuVO.getCdir() == null?"":(cuestionarioVTMAnuVO.getCdir()) ).append("</complementoDir>\n");
                            }
                            
                            
                            xml.append("\t<razonSocial>").append( cuestionarioVTMAnuVO.getRsPromo() == null?"":(cuestionarioVTMAnuVO.getRsPromo()) ).append("</razonSocial>\n");
                            xml.append("\t<cifDni>").append( cuestionarioVTMAnuVO.getCifDni() == null?"":(cuestionarioVTMAnuVO.getCifDni()) ).append("</cifDni>\n");
                            xml.append("\t<promotorProv>").append( promo_descProv ).append("</promotorProv>\n");
                            xml.append("\t<promotorMuni>").append( promo_descMuni ).append("</promotorMuni>\n");
                            
                            xml.append("\t<promotorEntidad>").append( promo_descEntidad ).append("</promotorEntidad>\n");
                            xml.append("\t<promotorTipoVia>").append( promo_descTipoVia ).append("</promotorTipoVia>\n");                            
                            xml.append("\t<promotorCalle>").append( promo_descCalle ).append("</promotorCalle>\n");
                            xml.append("\t<promotorBloque>").append( cuestionarioVTMAnuVO.getBloqPro() == null?"":(cuestionarioVTMAnuVO.getBloqPro()) ).append("</promotorBloque>\n");
                            xml.append("\t<promotorPortal>").append( promo_portal ).append("</promotorPortal>\n");
                            xml.append("\t<promotorBis>").append( cuestionarioVTMAnuVO.getBisPro() == null?"":(cuestionarioVTMAnuVO.getBisPro()) ).append("</promotorBis>\n");
                            if ( cuestionarioVTMAnuVO.getDirExternaPro() != null){
                                xml.append("\t<promotorComplementoDir>").append( cuestionarioVTMAnuVO.getDirExternaPro() ).append("</promotorComplementoDir>\n");
                            }else{
                                xml.append("\t<promotorComplementoDir>").append( cuestionarioVTMAnuVO.getCdirPro() == null?"":(cuestionarioVTMAnuVO.getCdirPro()) ).append("</promotorComplementoDir>\n");
                            }
                            xml.append("\t<promotorTlf>").append( cuestionarioVTMAnuVO.getTlf() == null?"":(cuestionarioVTMAnuVO.getTlf()) ).append("</promotorTlf>\n");
                            xml.append("\t<promotorFax>").append( cuestionarioVTMAnuVO.getFax() == null?"":(cuestionarioVTMAnuVO.getFax()) ).append("</promotorFax>\n");
                            xml.append("\t<promotorMail>").append( cuestionarioVTMAnuVO.getMail() == null?"":(q02a.exe.ejbs.noraConsultas.Q02AUtilsEjbs.getMailWebCortado( cuestionarioVTMAnuVO.getMail()) ) ).append("</promotorMail>\n");
                            xml.append("\t<promotorWeb>").append( cuestionarioVTMAnuVO.getWeb() == null?"":(q02a.exe.ejbs.noraConsultas.Q02AUtilsEjbs.getMailWebCortado(cuestionarioVTMAnuVO.getWeb()) ) ).append("</promotorWeb>\n");
                            
                            //xml.append("\t<presupuesto>").append( cuestionarioVTMAnuVO.getPresupuesto() == null?"":(cuestionarioVTMAnuVO.getPresupuesto()) ).append("</presupuesto>\n");
                            xml.append("\t<presupuesto>").append( cuestionarioVTMAnuVO.getPresupuesto() == null?"":( q02a.exe.ejbs.utils.Q02AUtils.getPuntosMiles(cuestionarioVTMAnuVO.getPresupuesto().toString()) ) ).append("</presupuesto>\n");
                            xml.append("\t<fechaInicio>").append( cuestionarioVTMAnuVO.getFIni() == null?"":(cuestionarioVTMAnuVO.getFIni()) ).append("</fechaInicio>\n");
                            xml.append("\t<fechaFin>").append( cuestionarioVTMAnuVO.getFFin() == null?"":(cuestionarioVTMAnuVO.getFFin()) ).append("</fechaFin>\n");
                            
                            xml.append("\t<tipoObra>").append( cuestionarioVTMAnuVO.getTipoObra() == null?"":(cuestionarioVTMAnuVO.getTipoObra()) ).append("</tipoObra>\n");
                            xml.append("\t<usoResidencial>").append( cuestionarioVTMAnuVO.getUsoRes() == null?"":(cuestionarioVTMAnuVO.getUsoRes()) ).append("</usoResidencial>\n");
                            xml.append("\t<actividad>").append( cuestionarioVTMAnuVO.getActividad() == null?"":(cuestionarioVTMAnuVO.getActividad()) ).append("</actividad>\n");
                            
                            //
                            xml.append("\t<numViviendasNuevas>").append( cuestionarioVTMAnuVO.getNvn() == null?"":(cuestionarioVTMAnuVO.getNvn()) ).append("</numViviendasNuevas>\n");
                            xml.append("\t<numViviendasPrevias>").append( cuestionarioVTMAnuVO.getNvr() == null?"":(cuestionarioVTMAnuVO.getNvr()) ).append("</numViviendasPrevias>\n");
                            
                            xml.append("\t<indNuePlRehab>").append( cuestionarioVTMAnuVO.getIndNuePlRehab() == null?"":(cuestionarioVTMAnuVO.getIndNuePlRehab()) ).append("</indNuePlRehab>\n");
                            xml.append("\t<indRehabNumViv>").append( cuestionarioVTMAnuVO.getIndRehabNumViv() == null?"":(cuestionarioVTMAnuVO.getIndRehabNumViv()) ).append("</indRehabNumViv>\n");
                            xml.append("\t<numVivFinales>").append( cuestionarioVTMAnuVO.getNumVivFinales() == null?"":(cuestionarioVTMAnuVO.getNumVivFinales()) ).append("</numVivFinales>\n");
                            //
                            
                            xml.append("\t<numViviendasLibres>").append( cuestionarioVTMAnuVO.getNvl() == null?"":(cuestionarioVTMAnuVO.getNvl()) ).append("</numViviendasLibres>\n");
                            xml.append("\t<numViviendasVPO>").append( cuestionarioVTMAnuVO.getNvvpo() == null?"":(cuestionarioVTMAnuVO.getNvvpo()) ).append("</numViviendasVPO>\n");
                            xml.append("\t<numViviendasVS>").append( cuestionarioVTMAnuVO.getNvvs() == null?"":(cuestionarioVTMAnuVO.getNvvs()) ).append("</numViviendasVS>\n");
                            xml.append("\t<numViviendasVPOT>").append( cuestionarioVTMAnuVO.getNvpot() == null?"":(cuestionarioVTMAnuVO.getNvpot()) ).append("</numViviendasVPOT>\n");
                            xml.append("\t<numViviendasAlojDotac>").append( cuestionarioVTMAnuVO.getNvaldot() == null?"":(cuestionarioVTMAnuVO.getNvaldot()) ).append("</numViviendasAlojDotac>\n");
                            xml.append("\t<numViviendasRealojo>").append( cuestionarioVTMAnuVO.getNvreal() == null?"":(cuestionarioVTMAnuVO.getNvreal()) ).append("</numViviendasRealojo>\n");
                            xml.append("\t<numViviendasVTMG>").append( cuestionarioVTMAnuVO.getNvvtmg() == null?"":(cuestionarioVTMAnuVO.getNvvtmg()) ).append("</numViviendasVTMG>\n");
                            xml.append("\t<numViviendasVTME>").append( cuestionarioVTMAnuVO.getNvvtme() == null?"":(cuestionarioVTMAnuVO.getNvvtme()) ).append("</numViviendasVTME>\n");
                            xml.append("\t<numViviendasTotal>").append( cuestionarioVTMAnuVO.getNtot() == null?"":(cuestionarioVTMAnuVO.getNtot()) ).append("</numViviendasTotal>\n");
                            
                            xml.append("\t<menos45>").append( cuestionarioVTMAnuVO.getNsp45() == null?"":(cuestionarioVTMAnuVO.getNsp45()) ).append("</menos45>\n");
                            xml.append("\t<de45a75>").append( cuestionarioVTMAnuVO.getNsp75() == null?"":(cuestionarioVTMAnuVO.getNsp75()) ).append("</de45a75>\n");
                            xml.append("\t<de76a90>").append( cuestionarioVTMAnuVO.getNsp90() == null?"":(cuestionarioVTMAnuVO.getNsp90()) ).append("</de76a90>\n");
                            xml.append("\t<de91a120>").append( cuestionarioVTMAnuVO.getNsp120() == null?"":(cuestionarioVTMAnuVO.getNsp120()) ).append("</de91a120>\n");
                            xml.append("\t<totalMetros>").append( cuestionarioVTMAnuVO.getNspt() == null?"":(cuestionarioVTMAnuVO.getNspt()) ).append("</totalMetros>\n");
                            
                            xml.append("\t<princUso>").append( cuestionarioVTMAnuVO.getPrincUso() == null?"":(cuestionarioVTMAnuVO.getPrincUso()) ).append("</princUso>\n");
                            xml.append("\t<especificar>").append( cuestionarioVTMAnuVO.getPuEspecif() == null?"":(cuestionarioVTMAnuVO.getPuEspecif()) ).append("</especificar>\n");
                            //xml.append("\t<precioMed>").append( cuestionarioVTMAnuVO.getPrecioMed() == null?"":(cuestionarioVTMAnuVO.getPrecioMed()) ).append("</precioMed>\n");
                            xml.append("\t<precioMed>").append( cuestionarioVTMAnuVO.getPrecioMed() == null?"":( q02a.exe.ejbs.utils.Q02AUtils.getPuntosMiles(cuestionarioVTMAnuVO.getPrecioMed().toString()) ) ).append("</precioMed>\n");
                            //
                            xml.append("\t<observaciones>").append( cuestionarioVTMAnuVO.getObs() == null?"":(cuestionarioVTMAnuVO.getObs().toString()) ).append("</observaciones>\n");
                                
                xml.append("\t</cuestionario>");
                
                final String xmlString = xml.toString();
                //System.out.println(xmlString);
                StringReader stream = new StringReader(xmlString); 
                
                try{
                    //System.out.println("--- Antes de la llamada a pdf ---");
                    Q02AUtils.convertXML2PDF( stream, pdfFile, getClass().getResourceAsStream(rutaXsl));
                    //System.out.println("--- Despues de la llamada a pdf ---");
                    
                }catch (Exception e){
                    pdfFile.delete();
                    //System.out.println("Error al generar pdf imprimir CuestionarioSM" );
                    throw new EJBException("Error al generar pdf imprimir CuestionarioVTM",e  );
                }
                pdfFile.deleteOnExit();
            }catch(Exception exp){
                pdfFile.delete();
                //System.out.println("Error al imprimir CuestionarioSM" );
                throw new EJBException("Error al imprimir CuestionarioVTM",exp  );
            }
            //System.out.println("--- FIN ---");
            
            ///////////////////////////////////////////////////////////////////////////////
            
            
            
            return new Q02aDocumento("CuestionarioVTMA.pdf","application/pdf",charset,pdfFile);
            
            
        } catch(Q02aAplicException ex1){              
              java.io.StringWriter sw = new java.io.StringWriter();
              java.io.PrintWriter pw = new java.io.PrintWriter(sw);
              ex1.printStackTrace(pw);
              tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":generarPdfCuestionarioVATMAnu: " + sw.getBuffer ().toString());
              throw ex1;        
        }catch(Exception ex){       
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":generarPdfCuestionarioVATMAnu: " + sw.getBuffer ().toString());
            throw ex;                     
        }finally{       
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":generarPdfCuestionarioVATMAnu: saliendo.");
            }
        }
    }
    
	/**
	 * Obtener la lista de cuestionarios
	 * @param mapaFiltroPortadaCuestionarioVTM mapaFiltroPortadaCuestionarioVTM
     * @param autenticador autenticador
     * 
	 * @return listaCuestionariosVTM Devuelve la lista de cuestionarios
	 * 
	 * @throws Exception
	 */
	public ArrayList obtenerCuestionariosVTM(HashMap mapaFiltroPortadaCuestionarioVTM, Q02aAutenticador autenticador) 
    throws Exception {		
		//Definicion de variables			 
		ArrayList listaCuestionariosVTM= new ArrayList(); 
		Q02aCuestionarioVTMFiltro cuestionariosVTMFiltro = null;
		try{
			if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionariosVTM: entrando.");
	   			//tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaFiltroEntidad : " + mapaFiltroEntidad.toString());
	   		}			
			beanCuestionarioVTMAnu= new Q02aCuestionariosVTMAnuBean();
			//se pasa el autenticador
	  		beanCuestionarioVTMAnu.setAutenticador(autenticador);
			cuestionariosVTMFiltro = (Q02aCuestionarioVTMFiltro)Q02aVoUtils.getValueObject(mapaFiltroPortadaCuestionarioVTM,"q02a.exe.cuestionariosVTMAnu.valueobjects.Q02aCuestionarioVTMFiltro");
			
			//se llama al metodo del bean necesario
			listaCuestionariosVTM = beanCuestionarioVTMAnu.getCuestionariosVTM(cuestionariosVTMFiltro);
			return listaCuestionariosVTM;
		} catch(Q02aAplicException ex1){	 		  
	          java.io.StringWriter sw = new java.io.StringWriter();
	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	          ex1.printStackTrace(pw);
	          tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionariosVTM: " + sw.getBuffer ().toString());
	          throw ex1;       	
		}catch(Exception ex){	 	
			java.io.StringWriter sw = new java.io.StringWriter();
			java.io.PrintWriter pw = new java.io.PrintWriter(sw);
			ex.printStackTrace(pw);
			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCuestionariosVTM: " + sw.getBuffer ().toString());
			throw ex;                     
	 	}finally{    	
	        if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionariosVTMAnu: saliendo.");
	   		}
	 	}
	}//fin obtenerEntidades
	
	public ArrayList obtenerEstadisticas(HashMap mapaEstadisticas,Q02aAutenticador autenticador)
	throws Exception{
		ArrayList listaEstadisticas= new ArrayList(); 
	try{
		if (tr.isTraceActive()){
   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerEstadisticas: entrando.");
   		}			
		beanCuestionarioVTMAnu= new Q02aCuestionariosVTMAnuBean();
		//se pasa el autenticador
  		beanCuestionarioVTMAnu.setAutenticador(autenticador);
		
		//se llama al metodo del bean necesario
  		listaEstadisticas = beanCuestionarioVTMAnu.getEstadisticas(mapaEstadisticas);
	 	
		return listaEstadisticas;
	} catch(Q02aAplicException ex1){	 		  
        java.io.StringWriter sw = new java.io.StringWriter();
        java.io.PrintWriter pw = new java.io.PrintWriter(sw);
        ex1.printStackTrace(pw);
        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionariosVTM: " + sw.getBuffer ().toString());
        throw ex1;       	
	}catch(Exception ex){	 	
		java.io.StringWriter sw = new java.io.StringWriter();
		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
		ex.printStackTrace(pw);
		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCuestionariosVTM: " + sw.getBuffer ().toString());
		throw ex;                     
	}finally{    	
      if (tr.isTraceActive()){
 			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionariosVTMAnu: saliendo.");
 		}
	}
	}
    
    /**
     * Obtener la lista de Cuestionarios - Expedientes
     * @param mapaFiltroPortadaCuestionarioVTM mapaFiltroPortadaCuestionarioVTM
     * @param autenticador autenticador
     * 
     * @return listaCuestionariosVTM Devuelve la lista de cuestionarios
     * 
     * @throws Exception
     */
    public ArrayList obtenerExpedientesVTM(HashMap mapaFiltroPortadaCuestionarioVTM, Q02aAutenticador autenticador) throws Exception 
    {       
        //Definicion de variables
        ArrayList listaCuestionariosVTM= new ArrayList(); 
        Q02aCuestionarioVTMFiltro cuestionariosVTMFiltro = null;
        
        try{
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerExpedientesVTM: entrando1111111");
                tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaFiltroEntidad : ----------- obtenerExpedientesVTM entrando--------------");
            }
            
            beanCuestionarioVTMAnu= new Q02aCuestionariosVTMAnuBean();
            //se pasa el autenticador
            beanCuestionarioVTMAnu.setAutenticador(autenticador);
            cuestionariosVTMFiltro = (Q02aCuestionarioVTMFiltro)Q02aVoUtils.getValueObject(mapaFiltroPortadaCuestionarioVTM,"q02a.exe.cuestionariosVTMAnu.valueobjects.Q02aCuestionarioVTMFiltro");
            
            //se llama al metodo del bean necesario
            listaCuestionariosVTM = beanCuestionarioVTMAnu.getExpedientesVTM(cuestionariosVTMFiltro);
            
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerExpedientesVTM: saliendo 111111111");
                tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaFiltroEntidad : ----------- obtenerExpedientesVTM entrando--------------");
            }
            
            return listaCuestionariosVTM;
            
        } catch(Q02aAplicException ex1){              
              java.io.StringWriter sw = new java.io.StringWriter();
              java.io.PrintWriter pw = new java.io.PrintWriter(sw);
              ex1.printStackTrace(pw);
              tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getExpedientesVTM: " + sw.getBuffer ().toString());
              throw ex1;        
        }catch(Exception ex){       
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getExpedientesVTM: " + sw.getBuffer ().toString());
            throw ex;
        }finally{       
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getExpedientesVTM: saliendo.");
            }
        }
    }//fin getExpedientesVTM
	
    /**
     * Borrar todos los cuestionarios de un mes de una localidad en las dos tablas
     * @param mapaFiltroPortadaCuestionarioVTM mapaFiltroPortadaCuestionarioVTM
     * @param autenticador autenticador
     * 
     * @throws Exception
     */
    public void resetearCuestionariosMesVTM(HashMap mapaFiltroPortadaCuestionarioVTM, Q02aAutenticador autenticador) 
    throws Exception {
        
        Q02aCuestionarioVTMFiltro cuestionariosVTMFiltro = null;
        try{
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":resetearCuestionariosMesVTM: entrando.");
                //tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaFiltroEntidad : " + mapaFiltroEntidad.toString());
            }           
            beanCuestionarioVTMAnu= new Q02aCuestionariosVTMAnuBean();
            //se pasa el autenticador
            beanCuestionarioVTMAnu.setAutenticador(autenticador);
            cuestionariosVTMFiltro = (Q02aCuestionarioVTMFiltro)Q02aVoUtils.getValueObject(mapaFiltroPortadaCuestionarioVTM,"q02a.exe.cuestionariosVTMAnu.valueobjects.Q02aCuestionarioVTMFiltro");
            
            //se llama al metodo del bean necesario
            beanCuestionarioVTMAnu.getResetearCuestionariosVTM(cuestionariosVTMFiltro);
            
        } catch(Q02aAplicException ex1){              
              java.io.StringWriter sw = new java.io.StringWriter();
              java.io.PrintWriter pw = new java.io.PrintWriter(sw);
              ex1.printStackTrace(pw);
              tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":resetearCuestionariosMesVTM: " + sw.getBuffer ().toString());
              throw ex1;        
        }catch(Exception ex){       
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":resetearCuestionariosMesVTM: " + sw.getBuffer ().toString());
            throw ex;                     
        }finally{       
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":resetearCuestionariosMesVTM: saliendo.");
            }
        }
    }//fin resetearCuestionariosMesVTM
    
    
    /**
     * CuestSinGrabarVTM Obtener la lista de cuestionarios
     * @param mapaFiltroPortadaCuestionarioVTM mapaFiltroPortadaCuestionarioVTM
     * @param autenticador autenticador
     * @return Devuelve la lista de cuestionarios que faltan de grabars de un municipio en el ao
     * 
     * @throws Exception Exception
     */

    public ArrayList cuestSinGrabarVTM(HashMap mapaFiltroPortadaCuestionarioVTM, Q02aAutenticador autenticador) throws Exception 
    {       
        ArrayList listaCuestionariosVTM= new ArrayList(); 
        Q02aCuestionarioVTMFiltro cuestionariosVTMFiltro = null;
        try{
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":cuestSinGrabarVTM: entrando.");
                //tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaFiltroEntidad : " + mapaFiltroEntidad.toString());
            }
            
            
            beanCuestionarioVTMAnu= new Q02aCuestionariosVTMAnuBean();
            //se pasa el autenticador
            beanCuestionarioVTMAnu.setAutenticador(autenticador);
            cuestionariosVTMFiltro = (Q02aCuestionarioVTMFiltro)Q02aVoUtils.getValueObject(mapaFiltroPortadaCuestionarioVTM,"q02a.exe.cuestionariosVTMAnu.valueobjects.Q02aCuestionarioVTMFiltro");
            
            //se llama al metodo del bean necesario para obtener la lista
            listaCuestionariosVTM = beanCuestionarioVTMAnu.getCuestionariosSinGrabarVTM(cuestionariosVTMFiltro);
            
            return listaCuestionariosVTM;
        } catch(Q02aAplicException ex1){              
              java.io.StringWriter sw = new java.io.StringWriter();
              java.io.PrintWriter pw = new java.io.PrintWriter(sw);
              ex1.printStackTrace(pw);
              tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":cuestSinGrabarVTM: " + sw.getBuffer ().toString());
              throw ex1;        
        }catch(Exception ex){       
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":cuestSinGrabarVTM: " + sw.getBuffer ().toString());
            throw ex;                     
        }finally{       
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":cuestSinGrabarVTM: saliendo.");
            }
        }
    }//fin cuestSinGrabarVTM
    
	/**
	 * Insertar/Modifica en bbdd un  nuevo grupo de cuestionarios con los datos pasados como par?metro en la HashMap de filtro
	 * @param mapaCuestionarioVTMAnuFiltro mapaCuestionarioVTMAnuFiltro
     * @param autenticador autenticador
     * @return niGrupoCuesVTMAnu
     * 
     * @throws Exception Exception
     */
	public String altaModifGrupoCuestionariosVTMAnu(HashMap mapaCuestionarioVTMAnuFiltro, Q02aAutenticador autenticador) 
      throws Exception {
        
		Q02aCuestionarioVTMAnuFiltro cuestionarioVTMAnuFiltro = null;
		String niGrupoCuesVTMAnu=null;	  		
		try {
			if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":altaModifGrupoCuestionariosVTMAnu: entrando");
			}
			//se pasa el hashmap de entrada a un objeto de tipo Q02aCuestionarioVTMAnu	  		
			cuestionarioVTMAnuFiltro = (Q02aCuestionarioVTMAnuFiltro) Q02aVoUtils.getValueObject(mapaCuestionarioVTMAnuFiltro,"q02a.exe.cuestionariosVTMAnu.valueobjects.Q02aCuestionarioVTMAnuFiltro");
			//se instancia el bean de negocio
            beanCuestionarioVTMAnu= new Q02aCuestionariosVTMAnuBean();
	  		//se pasa el autenticador
	  		beanCuestionarioVTMAnu.setAutenticador(autenticador);
	  		//se llama al metodo del bean necesario
	  		
	  		niGrupoCuesVTMAnu=beanCuestionarioVTMAnu.altaModifGrupoCuestionariosVTMAnu(cuestionarioVTMAnuFiltro);
	  		
	  		if(cuestionarioVTMAnuFiltro!= null && Q02aFormatData.esNullSinCero(cuestionarioVTMAnuFiltro.getModificarConcedidoLicen()).equals("1")){
	  			beanCuestionarioVTMAnu.modificarGrupoCuestionariosVTM(niGrupoCuesVTMAnu,cuestionarioVTMAnuFiltro.getRealizaActuacion(),cuestionarioVTMAnuFiltro.getMes(), cuestionarioVTMAnuFiltro.getObsVTM());
	  		}
	  		
	  		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":altaModifGrupoCuestionariosVTMAnu: niGrupoCuestionarioVTMAnu="+ niGrupoCuesVTMAnu);
			return niGrupoCuesVTMAnu;			
	     }catch(Exception ex){
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw); 

            if (tr.isTraceActive()){  
				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":altaModifGrupoCuestionariosVTMAnu: " + sw.getBuffer ().toString());
			}
            throw ex;
		 }finally{
			 if (tr.isTraceActive()){
					tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":altaModifGrupoCuestionariosVTMAnu: saliendo");
			}			
		}
	} // fin altaModifGrupoCuestionariosVTMAnu
	
	/**
	     * Metodo que se encarga de devolver un XML con los datos principales de los cuestionarios a firmar que no est?n ya firmados.
	     * @param arrCuestionariosVTMAnuFirma ArrayList arrCuestionariosVTMAnuFirma
	     * @param autenticador autenticador
         * 
         * @throws Exception Exception
	     * @return document
     */
	    public Document obtenerXmlFirmaCuestionariosVTMAnu(ArrayList arrCuestionariosVTMAnuFirma, Q02aAutenticador autenticador) throws Exception{
	        final String TRACE_METODO = "Q02aCuestionariosVTMAnuSesionBean:obtenerXmlFirmaCuestionariosVTMAnu";
	        
	        //Variable que se va a devolver
	        Document document = null;
	        
	        if (tr.isTraceActive())
	        {
	            	tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO +": entrando");
	        }
	        try{
		            //Se instancia el bean de negocio
		            beanCuestionarioVTMAnu= new Q02aCuestionariosVTMAnuBean();
		            // se pasa el autenticador
			  		beanCuestionarioVTMAnu.setAutenticador(autenticador);
		            //Se obtiene la lista con los resultados
		            
		            tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO +": ArrayList ="+ (arrCuestionariosVTMAnuFirma==null?"Es nulo":Integer.toString(arrCuestionariosVTMAnuFirma.size())));
		            document=beanCuestionarioVTMAnu.obtenerXmlFirmaCuestionariosVTMAnu(arrCuestionariosVTMAnuFirma);
		            //Se devuelve el objeto
		            return document;
	        }catch (Exception ex) 
	        {
		            java.io.StringWriter sw = new java.io.StringWriter();
		            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
		            ex.printStackTrace(pw);
		            tr.trace(COMPONENTE, Q70TraceLevel.ERROR,
		            TRACE_METODO + sw.getBuffer().toString());
	            throw ex;
	        } finally {
	            if (tr.isTraceActive()) {
	                tr.trace(COMPONENTE, Q70TraceLevel.INFO,
	                		TRACE_METODO + " saliendo.");
	            }
	        }
	    }
        
        /**
         * 
         * @param niGrupoCuesVTMAnu niGrupoCuesVTMAnu
         * @param xmlFirmaGrupoCuestionariosVTMAnu xmlFirmaGrupoCuestionariosVTMAnu
         * @param autenticador autenticador
         * 
         * @throws Exception Exception
         * 
     */
	    public void guardarFirmaGrupoCuestionariosVTMAnu(String niGrupoCuesVTMAnu,String xmlFirmaGrupoCuestionariosVTMAnu, Q02aAutenticador autenticador) throws Exception
	    {  	
		try {
			if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":guardarFirmaGrupoCuestionariosVTMAnu: entrando");
			}			
			beanCuestionarioVTMAnu= new Q02aCuestionariosVTMAnuBean();

            //se pasa el autenticador
	  		beanCuestionarioVTMAnu.setAutenticador(autenticador);
			//se llama al metodo del bean para modificar el contacto
			beanCuestionarioVTMAnu.guardarFirmaGrupoCuestionariosVTMAnu(niGrupoCuesVTMAnu,xmlFirmaGrupoCuestionariosVTMAnu);
		}
		catch(Exception ex)
		{
            			java.io.StringWriter sw = new java.io.StringWriter();
            			java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            			ex.printStackTrace(pw);
   			if (tr.isTraceActive())
   			{
				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":guardarFirmaGrupoCuestionariosVTMAnu: " + sw.getBuffer ().toString());
			}
   			throw ex;
		 }finally
		 {
			 if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":guardarFirmaGrupoCuestionariosVTMAnu: saliendo");
			 }
		 }		
	} // fin guardarFirmaGrupoCuestionariosVTMAnu
    
    /**
     * 
     * @param niGrupoCuestionarioVTMAnu niGrupoCuestionarioVTMAnu
     * @param autenticador autenticador
     * @throws Exception Exception
     */
    public void borrarTodosCuestionarioVTMAnu(String niGrupoCuestionarioVTMAnu, Q02aAutenticador autenticador) throws Exception
	{
		try {
			if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarTodosCuestionarioVTMAnu: entrando con cuestionario: " + niGrupoCuestionarioVTMAnu);
			}
			beanCuestionarioVTMAnu= new Q02aCuestionariosVTMAnuBean();
			//se pasa el autenticador
	  		beanCuestionarioVTMAnu.setAutenticador(autenticador);

            //se llama al m?todo del bean necesario
			beanCuestionarioVTMAnu.borrarTodosCuestionarioVTMAnu(niGrupoCuestionarioVTMAnu);			
	     }catch(Exception ex){
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarTodosCuestionarioVTMAnu: " + sw.getBuffer ().toString());
			}
            throw ex;
		 }finally{
			 if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarTodosCuestionarioVTMAnu: saliendo");
			 }	
		 }			 
		 
	} // fin borrarTodosCuestionarioVTMAnu
    
    /**
	 * Borrar de bbdd un cuestionario
	 * 
	 * @param mapaCuestionarioVTMAnu mapaCuestionarioVTMAnu
     * @param mapaFiltroPortadaCuestionarioVTM mapaFiltroPortadaCuestionarioVTM
     * @param autenticador autenticador
     * @throws Exception Exception
     * @return resul
     */
	public String obtenerClavelicencia(HashMap mapaCuestionarioVTMAnu,HashMap mapaFiltroPortadaCuestionarioVTM, Q02aAutenticador autenticador) throws Exception
	{
		//String niCuestionarioVTMAnu = "";
		Q02aCuestionarioVTMAnu cuestionarioVTMAnu = null;
		Q02aCuestionarioVTMAnuFiltro cuestionarioVTMFiltroPortada = null;
		try {
			if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerClavelicencia: entrando con cuestionario " );
			}

            String resul="";
			beanCuestionarioVTMAnu= new Q02aCuestionariosVTMAnuBean();
			
            //se pasa el autenticador
	  		beanCuestionarioVTMAnu.setAutenticador(autenticador);
	  		
            //se pasa el hashmap de entrada a un objeto de tipo Q02aCuestionarioVTMAnu			
			cuestionarioVTMAnu = (Q02aCuestionarioVTMAnu) Q02aVoUtils.getValueObject(mapaCuestionarioVTMAnu,"q02a.exe.cuestionariosVTMAnu.valueobjects.Q02aCuestionarioVTMAnu");
			cuestionarioVTMFiltroPortada = (Q02aCuestionarioVTMAnuFiltro) Q02aVoUtils.getValueObject(mapaFiltroPortadaCuestionarioVTM,"q02a.exe.cuestionariosVTMAnu.valueobjects.Q02aCuestionarioVTMAnuFiltro");
	  		//se llama al metodo del bean necesario
            resul = beanCuestionarioVTMAnu.obtenerClavelicencia(cuestionarioVTMAnu.getIdenLicen(),cuestionarioVTMFiltroPortada.getCodMuni(),cuestionarioVTMFiltroPortada.getCodProv());
			return  resul ;			
	     }catch(Exception ex){
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerClavelicencia: " + sw.getBuffer ().toString());
			}
            throw ex;
		 }finally{
			 if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerClavelicencia: saliendo");
			 }	
		 }			 
		 
	} // fin obtenerClavelicencia
   
	// --------------------------------------------------------------------------
	// ---------- FIN CUESTIONARIOS VIVIENDA TASADA MUNICIPAL -----------
	// ---------------------------------------------------------------------------
} // fin clase
