package q02aCuestionarioVAPMSesionEJB;

import java.io.File;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;

import q02a.exe.comun.Q02aAplicException;
import q02a.exe.comun.Q02aAutenticador;
import q02a.exe.comun.Q02aDocumento;
import q02a.exe.cuestionarioVAPM.beans.Q02aCuestionarioVAPMBean;
import q02a.exe.cuestionarioVAPM.valueobjects.Q02aCuestionarioVAPM;
import q02a.exe.cuestionarioVAPM.valueobjects.Q02aCuestionarioVAPMFiltro;
import q02a.exe.listados.Q02AUtils;
import q02a.exe.utils.Q02aFormatData;
import q02a.exe.utils.Q02aVoUtils;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.infraestructura.traza.Q70Traza;
 
/**
 * XDoclet-based session bean.  The class must be declared
 * public according to the EJB specification.
 *
 * To generate the EJB related files to this EJB:
 *		- Add Standard EJB module to XDoclet project properties
 *		- Customize XDoclet configuration for your appserver
 *		- Run XDoclet
 *
 * Below are the xdoclet-related tags needed for this EJB.
 * 
 * @ejb.bean name="Q02aCuestionariosSMAnuSesion"
 *           display-name="Name for Q02aCuestionariosSMAnuSesion"
 *           description="Description for Q02aCuestionariosSMAnuSesion"
 *           jndi-name="ejb/Q02aCuestionariosSMAnuSesion"
 *           type="Stateless"
 *           view-type="remote"
 */
 
public class Q02aCuestionarioVAPMSesionBean implements SessionBean {
	
	private static final long serialVersionUID = 4131248384461301469L;
	private static Q70Traza tr = Q70Traza.getSingleton();
	private static final String COMPONENTE = "EJB_SESION_DATOS";
	protected Q02aCuestionarioVAPMBean beanCuestionarioVAPM= null;
	private static final String Aitziber = "Aitziber";
	
	/** The session context */
	private javax.ejb.SessionContext mySessionCtx;
    /**
     * 
     *
     */
	public Q02aCuestionarioVAPMSesionBean() {
		super();
		// TODO Auto-generated constructor stub
	}

    /**
	 * Set the associated session context. The container calls this method 
	 * after the instance creation.
	 * 
	 * The enterprise bean instance should store the reference to the context 
	 * object in an instance variable.
	 * 
	 * This method is called with no transaction context. 
	 * 
	 * @throws EJBException Thrown if method fails due to system-level error.
	 */

    /**
	 * @return mySessionCtx
	 */
	public javax.ejb.SessionContext getSessionContext() {
		return mySessionCtx;
	}

    /**
	 * @param ctx ctx
	 */
	public void setSessionContext(javax.ejb.SessionContext ctx) {
		mySessionCtx = ctx;
	}

    /**
     * @throws EJBException EJBException
     * @throws RemoteException RemoteException
     */
	public void ejbRemove() throws EJBException, RemoteException {
		// TODO Auto-generated method stub
	}
    /**
     * @throws EJBException EJBException
     * @throws RemoteException RemoteException
     */
	public void ejbActivate() throws EJBException, RemoteException {
		// TODO Auto-generated method stub
	}
    /**
     * @throws EJBException EJBException
     * @throws RemoteException RemoteException
     */
	public void ejbPassivate() throws EJBException, RemoteException {
		// TODO Auto-generated method stub
	}

	/**
	 * An ejbCreate method as required by the EJB specification.
	 * 
	 * The container calls the instance?s <code>ejbCreate</code> method whose
	 * signature matches the signature of the <code>create</code> method invoked
	 * by the client. The input parameters sent from the client are passed to
	 * the <code>ejbCreate</code> method. Each session bean class must have at
	 * least one <code>ejbCreate</code> method. The number and signatures
	 * of a session bean?s <code>create</code> methods are specific to each 
	 * session bean class.
	 * 
	 * @throws CreateException Thrown if method fails due to system-level error.
	 * 
	 * @ejb.create-method
	 * 
	 */
	public void ejbCreate() throws CreateException {
		// TODO Add ejbCreate method implementation
	}  
	// -------------------------------------------------------------------------------------------------
	// ---------- CUESTIONARIOS VAPM  ----------
	// -------------------------------------------------------------------------------------------------
	/**
	 * Obtener la lista de cuestionarios
	 * 
     * @param niCuesVAPM niCuesVAPM
	 * @param mapaFiltroCuesVAPM mapaFiltroCuesVAPM
     * @param autenticador autenticador
     * @return Devuelve la lista de cuestionarios
	 * 
	 * @throws Exception Exception
	 */
	public HashMap obtenerCuestionarioVAPM(String niCuesVAPM, HashMap mapaFiltroCuesVAPM, Q02aAutenticador autenticador) throws Exception 
	{		
		//Definicion de variables			 
		Q02aCuestionarioVAPM cuestionarioVAPM= new Q02aCuestionarioVAPM();
		Q02aCuestionarioVAPMFiltro cuestionarioFiltroVAPM = null;
		HashMap mapaCuestionarioVAPM = new HashMap();
		try{
			if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioVAPM: entrando.");
	   			
	   		}
			cuestionarioFiltroVAPM = (Q02aCuestionarioVAPMFiltro) Q02aVoUtils.getValueObject(mapaFiltroCuesVAPM,"q02a.exe.cuestionarioVAPM.valueobjects.Q02aCuestionarioVAPMFiltro");
			beanCuestionarioVAPM= new Q02aCuestionarioVAPMBean();
			beanCuestionarioVAPM.setAutenticador(autenticador);
			cuestionarioVAPM = beanCuestionarioVAPM.altaModifCuestionarioVAPM(niCuesVAPM,cuestionarioFiltroVAPM);			
			mapaCuestionarioVAPM = (HashMap)Q02aVoUtils.getHashMap(cuestionarioVAPM);
			return mapaCuestionarioVAPM;
		} catch(Q02aAplicException ex1){	 		  
	          java.io.StringWriter sw = new java.io.StringWriter();
	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	          ex1.printStackTrace(pw);
	          tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioVAPM: " + sw.getBuffer ().toString());
	          throw ex1;       	
		}catch(Exception ex){	 	
			java.io.StringWriter sw = new java.io.StringWriter();
			java.io.PrintWriter pw = new java.io.PrintWriter(sw);
			ex.printStackTrace(pw);
			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCuestionarioVAPM: " + sw.getBuffer ().toString());
			throw ex;                     
	 	}finally{    	
	        if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioVAPM: saliendo.");
	   		}
	 	}
	}//fin obtenerCuestionario*/
	
	/**
	 * Modificar en bbdd un cuestionario con los datos pasados como parametro en la HashMap
	 * @param mapaFiltroPortadaCuestionarioVAPM mapaFiltroPortadaCuestionarioVAPM
     * @param mapaCuestionarioVAPM mapaCuestionarioVAPM
     * @param autenticador autenticador
     * @return Devuelve la lista de cuestionarios
     * 
     * @throws Exception Exception
     */
	public String guardarCuestionarioVAPM(HashMap mapaFiltroPortadaCuestionarioVAPM, HashMap mapaCuestionarioVAPM, Q02aAutenticador autenticador) throws Exception
	{
		String niCuestionarioVAPM = "";
		Q02aCuestionarioVAPM cuestionarioVAPM = null;
		Q02aCuestionarioVAPMFiltro cuestionarioVAPMFiltroPortada = null;		
		try {
		    if (tr.isTraceActive()) {
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":guardarCuestionarioVAPM: entrando");
                tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaCuestionarioVAPM : " + mapaCuestionarioVAPM.toString());
            }
			//se pasa el hashmap de entrada a un objeto de tipo Q02aCuestionarioVTMAnu	
			
			cuestionarioVAPM = (Q02aCuestionarioVAPM) Q02aVoUtils.getValueObject(mapaCuestionarioVAPM,"q02a.exe.cuestionarioVAPM.valueobjects.Q02aCuestionarioVAPM");
			if (tr.isTraceActive()) {
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":cuestionarioVAPM.getNprop: " + cuestionarioVAPM.getNprop() );
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":cuestionarioVAPM.getNtotal3a: " + cuestionarioVAPM.getNtotal3a() );
                 }
			//if (cuestionarioVAPM.getNprop() != cuestionarioVAPM.getNtotal3a()){
			//	Exception e =null ;
			//	 throw new EJBException("Las viviendas de la pregunta 3 deben coincidir con el total de la pregunta 3A", e);	
			//}
			//se instancia el bean de negocio
	  		beanCuestionarioVAPM= new Q02aCuestionarioVAPMBean();
	  		//se pasa el autenticador
	  		beanCuestionarioVAPM.setAutenticador(autenticador);
	  		
	  		//En caso de que vengamos de la portada, el campo niGrupoVTMAnu del mapa no va a tener ningun valor
	  		//Puede que este en el contexto (en caso de que estemos haciendo altas para los mismo parametros de portada)
	  		//o  no, en cuyo caso lo tendremos que obtener
	  		cuestionarioVAPMFiltroPortada = (Q02aCuestionarioVAPMFiltro) Q02aVoUtils.getValueObject(mapaFiltroPortadaCuestionarioVAPM,"q02a.exe.cuestionarioVAPM.valueobjects.Q02aCuestionarioVAPMFiltro");
	  		String ano = cuestionarioVAPMFiltroPortada.getAno();
			String codMunicip = cuestionarioVAPMFiltroPortada.getCodMuni();
			String concedeLicen = cuestionarioVAPMFiltroPortada.getConcedidoLicen();
			String codProv = cuestionarioVAPMFiltroPortada.getCodProv();
			
	  		if(Q02aFormatData.esNullSinCero(cuestionarioVAPM.getNiCuesVAPM()).equals("")){ 	  			
	  			niCuestionarioVAPM = beanCuestionarioVAPM.altaModifGrupoCuestionariosVAPM(cuestionarioVAPMFiltroPortada);
	  			cuestionarioVAPM.setNiCuesVAPM(niCuestionarioVAPM);
	  		}else{
	  			niCuestionarioVAPM = cuestionarioVAPM.getNiCuesVAPM();
	  		}
	  			//se llama al metodo del bean necesario
	  		beanCuestionarioVAPM.modificarCuestionarioVAPM(cuestionarioVAPM,ano,codMunicip,concedeLicen,codProv,niCuestionarioVAPM);
	  		beanCuestionarioVAPM.insertarContactoVAPM(ano);
	  		
			return niCuestionarioVAPM;			
	     }catch(Exception ex){
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw); 
            if (tr.isTraceActive()){  
				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarCuestionarioVTMAnu: " + sw.getBuffer ().toString());
			}
            
            throw ex;
		 }finally{
			 if (tr.isTraceActive()){
					tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarCuestionarioVTMAnu: saliendo");
			}			
		}
	} // fin modificarCuestionarioVAPM
	
	/**
	 * Obtener la lista de cuestionarios
	 * 
	 * @param mapaFiltroCuestionarioVAPM mapaFiltroCuestionarioVAPM
     * @param autenticador autenticador
     * @return niCuesVAPM
     * 
     * @throws Exception Exception
     * 
	 */
	public String obtenerNiCuesVAPM(HashMap mapaFiltroCuestionarioVAPM, Q02aAutenticador autenticador) throws Exception 
	{		
		//Definicion de variables			 
		
		String niCuesVAPM = null;
		Q02aCuestionarioVAPMFiltro cuestionarioVAPMFiltro = null;
		try{
			if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerNiCuesVAPM: entrando.");
	   			//tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaFiltroEntidad : " + mapaFiltroEntidad.toString());
	   		}			
			beanCuestionarioVAPM= new Q02aCuestionarioVAPMBean();
			//se pasa el autenticador
	  		beanCuestionarioVAPM.setAutenticador(autenticador);
			cuestionarioVAPMFiltro = (Q02aCuestionarioVAPMFiltro) Q02aVoUtils.getValueObject(mapaFiltroCuestionarioVAPM,"q02a.exe.cuestionarioVAPM.valueobjects.Q02aCuestionarioVAPMFiltro");
			
			String ano = cuestionarioVAPMFiltro.getAno();
			String concedeLicen = cuestionarioVAPMFiltro.getConcedidoLicen();			
			String codMunicipio = cuestionarioVAPMFiltro.getCodMuni();
			String municipio = cuestionarioVAPMFiltro.getMunicipio();
			String codProv = cuestionarioVAPMFiltro.getCodProv();
			niCuesVAPM = beanCuestionarioVAPM.obtenerNiCuesVAPM(cuestionarioVAPMFiltro);
			return niCuesVAPM;
		} catch(Q02aAplicException ex1){	 		  
	          java.io.StringWriter sw = new java.io.StringWriter();
	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	          ex1.printStackTrace(pw);
	          tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerNiCuesVAPM: " + sw.getBuffer ().toString());
	          throw ex1;       	
		}catch(Exception ex){	 	
			java.io.StringWriter sw = new java.io.StringWriter();
			java.io.PrintWriter pw = new java.io.PrintWriter(sw);
			ex.printStackTrace(pw);
			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerNiCuesVAPM: " + sw.getBuffer ().toString());
			throw ex;                     
	 	}finally{    	
	        if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerNiCuesVAPM: saliendo.");
	   		}
	 	}
	}//fin obtenerNiCuesVAPM*/
	
	/**
	 * Insertar/Modifica en bbdd un  nuevo grupo de cuestionarios con los datos pasados como parametro en la HashMap de filtro
     * @param mapaFiltroCuestionarioVAPM mapaFiltroCuestionarioVAPM
     * @param autenticador autenticador
     * @return niCuesVAPM
     * 
     * @throws Exception Exception
     * 
	 */
	public String altaModifGrupoCuestionariosVAPM(HashMap mapaFiltroCuestionarioVAPM, Q02aAutenticador autenticador) throws Exception 
	{
		Q02aCuestionarioVAPMFiltro cuestionarioVAPMFiltro = null;
		String niCuesVAPM=null;	  		
		try {
			if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":altaModifGrupoCuestionariosVAPM: entrando");
			}
			//se pasa el hashmap de entrada a un objeto de tipo Q02aCuestionarioVTMAnu	  		
			cuestionarioVAPMFiltro = (Q02aCuestionarioVAPMFiltro) Q02aVoUtils.getValueObject(mapaFiltroCuestionarioVAPM,"q02a.exe.cuestionarioVAPM.valueobjects.Q02aCuestionarioVAPMFiltro");
			//se instancia el bean de negocio
			beanCuestionarioVAPM= new Q02aCuestionarioVAPMBean();
	  		//se pasa el autenticador
	  		beanCuestionarioVAPM.setAutenticador(autenticador);
	  		//se llama al metodo del bean necesario
			niCuesVAPM=beanCuestionarioVAPM.altaModifGrupoCuestionariosVAPM(cuestionarioVAPMFiltro);
	  		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":altaModifGrupoCuestionariosVAPM: niGrupoCuestionarioVTMAnu="+ niCuesVAPM);
			return niCuesVAPM;			
	     }catch(Exception ex){
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw); 
            if (tr.isTraceActive()){  
				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":altaModifGrupoCuestionariosVAPM: " + sw.getBuffer ().toString());
			}
         
            throw ex;
		 }finally{
			 if (tr.isTraceActive()){
					tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":altaModifGrupoCuestionariosVAPM: saliendo");
			}			
		}
	} // fin altaModifGrupoCuestionariosVTMAnu

	/**
	 * Obtener la lista de cuestionarios
	 * @param mapaFiltroPortadaCuestionarioVAPM mapaFiltroPortadaCuestionarioVAPM
     * @param autenticador autenticador
     * @return listaCuestionariosVAPM
     * 
     * @throws Exception Exception
     */
	public ArrayList obtenerCuestionariosVAPM(HashMap mapaFiltroPortadaCuestionarioVAPM, Q02aAutenticador autenticador) throws Exception 
	{		
		ArrayList listaCuestionariosVAPM= new ArrayList(); 
		try{
			if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionariosVAPM: entrando.");
	   		}		
			beanCuestionarioVAPM= new Q02aCuestionarioVAPMBean();
			beanCuestionarioVAPM.setAutenticador(autenticador);
			listaCuestionariosVAPM = beanCuestionarioVAPM.getCuestionariosVAPM(mapaFiltroPortadaCuestionarioVAPM);
			return listaCuestionariosVAPM;
		} catch(Q02aAplicException ex1){	 		  
	          java.io.StringWriter sw = new java.io.StringWriter();
	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	          ex1.printStackTrace(pw);
	          tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionariosVAPM: " + sw.getBuffer ().toString());
	          throw ex1;       	
		}catch(Exception ex){	 	
			java.io.StringWriter sw = new java.io.StringWriter();
			java.io.PrintWriter pw = new java.io.PrintWriter(sw);
			ex.printStackTrace(pw);
			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCuestionariosVAPM: " + sw.getBuffer ().toString());
			throw ex;                     
	 	}finally{    	
	        if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionariosVAPM: saliendo.");
	   		}
	 	}
	}//fin obtenerCuestionariosVAPM*/
    
    /**
     * Borra todos los cuestionarios de un mes (ahora solo hay 1 cuest, en el mes de enero)
     * @param mapaFiltroPortadaCuestionarioVAPM mapaFiltroPortadaCuestionarioVAPM
     * @param autenticador autenticador
     * 
     * @throws Exception Exception
     */
    public void resetearCuestionariosMesVAPM(HashMap mapaFiltroPortadaCuestionarioVAPM, Q02aAutenticador autenticador) 
        throws Exception {       
        ArrayList listaCuestionariosVAPM= new ArrayList(); 
        try{
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":resetearCuestionariosMesVAPM: entrando.");
            }       
            beanCuestionarioVAPM= new Q02aCuestionarioVAPMBean();
            
            
            
            beanCuestionarioVAPM.setAutenticador(autenticador);
            beanCuestionarioVAPM.resetearCuestionarioVAPM(mapaFiltroPortadaCuestionarioVAPM);
            
        } catch(Q02aAplicException ex1){              
              java.io.StringWriter sw = new java.io.StringWriter();
              java.io.PrintWriter pw = new java.io.PrintWriter(sw);
              ex1.printStackTrace(pw);
              tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":resetearCuestionariosMesVAPM: " + sw.getBuffer ().toString());
              throw ex1;        
        }catch(Exception ex){       
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":resetearCuestionariosMesVAPM: " + sw.getBuffer ().toString());
            throw ex;                     
        }finally{       
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":resetearCuestionariosMesVAPM: saliendo.");
            }
        }
    }//fin resetearCuestionariosMesVAPM */
	
    /**
     * Obtener la lista de cuestionarios
     * @param mapaFiltroPortadaCuestionarioVAPM mapaFiltroPortadaCuestionarioVAPM
     * @param autenticador autenticador
     * @return listaCuestionariosVAPM
     * 
     * @throws Exception Exception
     */

    public ArrayList cuestSinGrabarVAPM(HashMap mapaFiltroPortadaCuestionarioVAPM, Q02aAutenticador autenticador) throws Exception 
    {       
        ArrayList listaCuestionariosVAPM= new ArrayList(); 
        Q02aCuestionarioVAPMFiltro cuestionariosVAPMFiltro = null;
        try{
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":cuestSinGrabarVAPM: entrando.");
            }       
            beanCuestionarioVAPM= new Q02aCuestionarioVAPMBean();
            beanCuestionarioVAPM.setAutenticador(autenticador);
            
            cuestionariosVAPMFiltro = (Q02aCuestionarioVAPMFiltro) Q02aVoUtils.getValueObject(mapaFiltroPortadaCuestionarioVAPM,"q02a.exe.cuestionarioVAPM.valueobjects.Q02aCuestionarioVAPMFiltro");
            
            listaCuestionariosVAPM = beanCuestionarioVAPM.getCuestionariosSinGrabarVAPM(cuestionariosVAPMFiltro);
            return listaCuestionariosVAPM;
        } catch(Q02aAplicException ex1){              
              java.io.StringWriter sw = new java.io.StringWriter();
              java.io.PrintWriter pw = new java.io.PrintWriter(sw);
              ex1.printStackTrace(pw);
              tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":cuestSinGrabarVAPM: " + sw.getBuffer ().toString());
              throw ex1;        
        }catch(Exception ex){       
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":cuestSinGrabarVAPM: " + sw.getBuffer ().toString());
            throw ex;                     
        }finally{       
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":cuestSinGrabarVAPM: saliendo.");
            }
        }
    }//fin cuestSinGrabarVAPM*/
    
	/**
	 * Modificar en bbdd un cuestionario con los datos pasados como parametro en la HashMap
     * 
	 * @param niCuesVAPM niCuesVAPM
     * @param mapaCuestionarioVAPM mapaCuestionarioVAPM
     * @param autenticador autenticador
     * 
     * @throws Exception Exception
     */
	public void modificarCuestionarioVAPM(String niCuesVAPM, HashMap mapaCuestionarioVAPM, Q02aAutenticador autenticador) 
	throws Exception {
	    
		Q02aCuestionarioVAPM cuestionarioVAPM = null;	  	
		try {
			if (tr.isTraceActive()) {
			    
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarCuestionarioVAPM: entrando");
				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaCuestionarioSMAnu : " + mapaCuestionarioVAPM.toString());
			}			
			//se pasa el hashmap de entrada a un objeto de tipo Q02aCuestionarioVAPM
			cuestionarioVAPM = (Q02aCuestionarioVAPM) Q02aVoUtils.getValueObject(mapaCuestionarioVAPM,"q02a.exe.cuestionarioVAPM.valueobjects.Q02aCuestionarioVAPM");
			
			beanCuestionarioVAPM= new Q02aCuestionarioVAPMBean();
			//se pasa el autenticador
	  		beanCuestionarioVAPM.setAutenticador(autenticador);
			//se llama al metodo del bean para modificar el contacto
			beanCuestionarioVAPM.modificarCuestionarioVAPM(niCuesVAPM, cuestionarioVAPM);			
		}catch(Exception ex){
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarCuestionarioVAPM: " + sw.getBuffer ().toString());
			}
            throw ex;
		 }finally{
			 if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarCuestionarioVAPM: saliendo");
			 }
		 }		
	} // fin modificarCuestionarioVAPM
	
	/**
     * Metodo que dado el numero interno del cuestionario recuperara de la BBDD
     * los datos de dicho cuestionario
     * @param niCuestionarioVAPM niCuestionarioVAPM
     * @param autenticador autenticador
     * @return cuestionarioVAPM
     * @throws Exception Exception
     */
	 
	public HashMap obtenerCuestionarioSeleccionadoVAPM(String niCuestionarioVAPM, Q02aAutenticador autenticador) throws Exception 
	{		
		//Definicion de variables
		HashMap cuestionarioVAPM =  new HashMap(); 
		Q02aCuestionarioVAPM cuestionarioVAPMVO = new Q02aCuestionarioVAPM();
		try{
			if (tr.isTraceActive())
			{
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioVAPM ejb-> ** niCuestionarioVTMAnu=:" + niCuestionarioVAPM );	   			
	   		}			
			beanCuestionarioVAPM= new Q02aCuestionarioVAPMBean();
			//se pasa el autenticador
	  		beanCuestionarioVAPM.setAutenticador(autenticador);
	  		//se llama al metodo del bean necesario			
	  		cuestionarioVAPMVO = beanCuestionarioVAPM.obtenerCuestionarioSeleccionadoVAPM(niCuestionarioVAPM);
	  		//se pasa el resultado a un hashMap
	  		cuestionarioVAPM = (HashMap)Q02aVoUtils.getHashMap(cuestionarioVAPMVO);
			return cuestionarioVAPM;
		} catch(Q02aAplicException ex1){	 		  
	          java.io.StringWriter sw = new java.io.StringWriter();
	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	          ex1.printStackTrace(pw);
	          tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioVAPM: " + sw.getBuffer ().toString());
	          throw ex1;       	
		}catch(Exception ex){	 	
			java.io.StringWriter sw = new java.io.StringWriter();
			java.io.PrintWriter pw = new java.io.PrintWriter(sw);
			ex.printStackTrace(pw);
			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCuestionarioVAPM: " + sw.getBuffer ().toString());
			throw ex;                     
	 	}finally{    	
	        if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioVAPM: saliendo.");
	   		}
	 	}
	}//fin obtenerCuestionarioVAPM
	
	/**
	 * Borrar de bbdd un cuestionario
	 * 
	 * @param niCuestionarioVAPM - Numero interno del cuestionario a borrar
	 * @param autenticador autenticador
     * @throws Exception Exception
     *
	 */
	public void borrarCuestionarioVAPM(String niCuestionarioVAPM, Q02aAutenticador autenticador) throws Exception
	{
		try {
			if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarCuestionarioVAPM: entrando con cuestionario: " + niCuestionarioVAPM);
			}
			beanCuestionarioVAPM= new Q02aCuestionarioVAPMBean();
			//se pasa el autenticador
	  		beanCuestionarioVAPM.setAutenticador(autenticador);
	  		//se llama al metodo del bean necesario
			beanCuestionarioVAPM.borrarCuestionarioVAPM(niCuestionarioVAPM);			
	     }catch(Exception ex){
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarCuestionarioVAPM: " + sw.getBuffer ().toString());
			}
            throw ex;
		 }finally{
			 if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarCuestionarioVAPM: saliendo");
			 }	
		 }			 
	} // fin borrarCuestionarioVAPM
    
    /**
     * Generar pdf de un cuestionario que dado el numero interno del cuestionario recuperara de la BBDD
     * los datos de dicho cuestionario
     * @param niCuestionarioVAPM niCuestionarioVAPM
     * @param autenticador autenticador
     * @param filtro filtro
     * @return cuestionarioVAPM
     * @throws Exception Exception
     */
    public Q02aDocumento generarPdfCuestionarioVAPMAnu(String niCuestionarioVAPM, Q02aAutenticador autenticador, HashMap filtro) throws Exception 
    {       
        // Definicion de variables
        Q02aCuestionarioVAPM cuestionarioVAPMVO = new Q02aCuestionarioVAPM();
        
        String idioma = autenticador.getIdioma();
        
        try{
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":generarPdfCuestionarioVAPMAnu: entrando.");
            }
            
            

            //se pasa el autenticador
            beanCuestionarioVAPM.setAutenticador(autenticador);
            
            
            //se llama al metodo del bean necesario         
            cuestionarioVAPMVO = beanCuestionarioVAPM.obtenerCuestionarioSeleccionadoVAPM(niCuestionarioVAPM);
            tr.trace(COMPONENTE, Q70TraceLevel.INFO,"CUESTIONARIO ANIO --> " + cuestionarioVAPMVO.getAno());
            
            Integer anio=null;
            int anioVal=0;
            if (cuestionarioVAPMVO.getAno()!=null){
            	anioVal=Integer.parseInt(cuestionarioVAPMVO.getAno());
            }
            int anioF=anioVal+3;
            tr.trace(COMPONENTE, Q70TraceLevel.INFO,"CUESTIONARIO ANIOFIN --> " + anioF);
            Integer anioFin=new Integer(anioF);
            anio=new Integer(anioVal);
            Integer anioAnt=new Integer(anioVal-1);
            Integer anioDesde=new Integer(anioVal+1);
            Integer anioHasta=new Integer(anioVal+4);
            Object[] params={anioDesde,anioHasta};
            Object[] paramAnio={anio};
            Object[] paramFechaFinAnio={(idioma.equals("es")?("31/12/" + anioAnt.toString()):(anioAnt.toString() + "/12/31"))};
          
            ////////////////////////////////////////////////////////////////////////////////
            
            File pdfFile=null;
            String charset = "UTF-8";
            String CONFIG_LISTADOS_PATH_TMP = "/datos/q02a/tmp";
            //String CONFIG_LISTADOS_PATH_TMP = "c:/datos/q02a/tmp";
            try{
                //final W08BConfiguration config = W08BConfiguration.getInstance();
                //final File tempPath = new File(config.get(CONFIG_LISTADOS_PATH_TMP));
                final File tempPath = new File(CONFIG_LISTADOS_PATH_TMP);
                pdfFile=File.createTempFile("CuestionarioVAPM", ".pdf", tempPath);
                //System.out.println(pdfFile);
            }catch(Exception e){
                //System.out.println("Excepcion al crear pdf temporal en listado solicitud deposito");
                throw new EJBException("Excepcion al crear pdf temporal en listado solicitud deposito", e);
            }
            
            try{
                //Formamos el xml.
                String rutaXsl = "/html/datos/xsl/q02acuestionarioVAPM.xsl";
                
                final String imgName = "/html/datos/xsl/images/logoPDF.jpg";
                final String uno = "/html/datos/xsl/images/uno.jpg";
                final String dos = "/html/datos/xsl/images/dos.jpg";
                final String tres = "/html/datos/xsl/images/tres.jpg";
                final String tresa = "/html/datos/xsl/images/tresa.jpg";
                final String cuatro = "/html/datos/xsl/images/cuatro.jpg";
                final String cinco = "/html/datos/xsl/images/cinco.jpg";
                final String seis = "/html/datos/xsl/images/seis.jpg";
                final String siete = "/html/datos/xsl/images/siete.jpg";
                final String ocho = "/html/datos/xsl/images/ocho.jpg";
                final String flechaV = "/html/datos/xsl/images/flechaV.gif";
                final String flechaE = "/html/datos/xsl/images/flechaE.gif";
                final String flechaH = "/html/datos/xsl/images/flechaH.gif";
                String fin = "";
                if ( idioma.equals("es") ){
                        fin = "/html/datos/xsl/images/fin.jpg";
                }else{
                        fin = "/html/datos/xsl/images/amaiera.jpg";
                        rutaXsl = "/html/datos/xsl/q02acuestionarioVAPM_EU.xsl";
                }
            	
//            	 String rutaXsl = "D:/aplic/q02aWorkspace/q02aClasses/html/datos/xsl/q02acuestionarioVAPM.xsl";
//               
//               final String imgName = "D:/aplic/q02aWorkspace/q02aClasses/html/datos/xsl/images/logoPDF.jpg";
//               final String uno = "D:/aplic/q02aWorkspace/q02aClasses/html/datos/xsl/images/uno.jpg";
//               final String dos = "D:/aplic/q02aWorkspace/q02aClasses/html/datos/xsl/images/dos.jpg";
//               final String tres = "D:/aplic/q02aWorkspace/q02aClasses/html/datos/xsl/images/tres.jpg";
//               final String cuatro = "D:/aplic/q02aWorkspace/q02aClasses/html/datos/xsl/images/cuatro.jpg";
//               final String cinco = "D:/aplic/q02aWorkspace/q02aClasses/html/datos/xsl/images/cinco.jpg";
//               final String seis = "D:/aplic/q02aWorkspace/q02aClasses/html/datos/xsl/images/seis.jpg";
//               final String siete = "D:/aplic/q02aWorkspace/q02aClasses/html/datos/xsl/images/siete.jpg";
//               final String ocho = "D:/aplic/q02aWorkspace/q02aClasses/html/datos/xsl/images/ocho.jpg";
//               final String flechaV = "D:/aplic/q02aWorkspace/q02aClasses/html/datos/xsl/images/flechaV.gif";
//               final String flechaE = "D:/aplic/q02aWorkspace/q02aClasses/html/datos/xsl/images/flechaE.gif";
//               final String flechaH = "D:/aplic/q02aWorkspace/q02aClasses/html/datos/xsl/images/flechaH.gif";
//               String fin = "";
//               if ( idioma.equals("es") ){
//                       fin = "D:/aplic/q02aWorkspace/q02aClasses/html/datos/xsl/images/fin.jpg";
//               }else{
//                       fin = "D:/aplic/q02aWorkspace/q02aClasses/html/datos/xsl/images/amaiera.jpg";
//                       rutaXsl = "D:/aplic/q02aWorkspace/q02aClasses/html/datos/xsl/q02acuestionarioVAPM_EU.xsl";
//               }
                
                //final String mes = filtro.get("mes").toString();
                //final String anyo = filtro.get("ano").toString();
                //TEXTOS
                final String textoTituloVAPM = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.titulo",  idioma);
                final String textoPie = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.pie",  idioma);
                final String textoAnyo = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.anyo",  idioma);
                
                final String textoDirServiciosEs = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.dirServicios",  "es");
                final String textoDirServiciosEus = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.dirServicios",  "eu");
                final String titulo1 = Q02AUtils.getI18nPropertyParams( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.titulo1",  idioma,paramAnio);
                final String titulo1_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.titulo1_1",  idioma);
                final String titulo2 = Q02AUtils.getI18nPropertyParams( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.titulo2",  idioma,params);
                final String titulo2_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.titulo2_1",  idioma);
                final String titulo3 = Q02AUtils.getI18nPropertyParams( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.titulo3",  idioma,paramFechaFinAnio);
                final String titulo3A= Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.titulo3A",  idioma);
                
                final String titulo4 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.titulo4",  idioma);
                final String titulo4_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.titulo4_1",  idioma);
                final String titulo5 = Q02AUtils.getI18nPropertyParams( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.titulo5",  idioma,paramFechaFinAnio);
                final String titulo5_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.titulo5_1",  idioma);
                final String titulo6 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.titulo6",  idioma);
                final String titulo6_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.titulo6_1",  idioma);
                final String titulo7 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.titulo7",  idioma);
                final String titulo7_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.titulo7_1",  idioma);
                final String titulo8 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.titulo8",  idioma);
                
                final String texto1_2_0_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto1_2_0_1",  idioma);
                final String texto1_2_0_2 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto1_2_0_2",  idioma);
                final String texto1_1 = Q02AUtils.getI18nPropertyParams( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto1_1",  idioma,paramAnio);
                final String texto1_2 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto1_2",  idioma);
                final String texto1_2_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto1_2_1",  idioma);
                final String texto1_2_2 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto1_2_2",  idioma);
                final String texto1_2_3 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto1_2_3",  idioma);
                final String texto1_2_9 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto1_2_9",  idioma);
                final String texto2_1 = Q02AUtils.getI18nPropertyParams("q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto2_1",  idioma,params);
                final String texto2_2 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto2_2",  idioma);
                final String texto2_2_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto2_2_1",  idioma);
                final String texto2_2_2 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto2_2_2",  idioma);
                final String texto2_2_3 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto2_2_3",  idioma);
                final String texto2_2_9 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto2_2_9",  idioma);
                final String texto3_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto3_1",  idioma);
                final String texto3_2 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto3_2",  idioma);
                
                final String texto3A_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto3A_1",  idioma);
                final String texto3A_2 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto3A_2",  idioma);
                final String texto3A_3 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto3A_3",  idioma);
                final String texto3A_4 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto3A_4",  idioma);
                final String texto3A_5 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto3A_5",  idioma);
                final String texto3A_6 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto3A_6",  idioma);
                final String texto3A_7 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto3A_7",  idioma);
                final String texto3A_8 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto3A_8",  idioma);
                
                final String texto4_0_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto4_0_1",  idioma);
                final String texto4_0_2 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto4_0_2",  idioma);
                final String texto4_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto4_1",  idioma);
                final String texto4_2 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto4_2",  idioma);
                final String texto4_3 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto4_3",  idioma);
                final String texto4_4 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto4_4",  idioma);
                final String texto4_9 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto4_9",  idioma);
                final String texto5_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto5_1",  idioma);
                final String texto5_2 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto5_2",  idioma);
                final String texto5_3 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto5_3",  idioma);
                final String texto5_4 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto5_4",  idioma);
                final String texto5_9 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto5_9",  idioma);
                final String texto6_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto6_1",  idioma);
                final String texto6_2 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto6_2",  idioma);
                final String texto6_2_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto6_2_1",  idioma);
                final String texto6_3 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto6_3",  idioma);
                final String texto6_3_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto6_3_1",  idioma);
                
                final String texto6_4 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto6_4",  idioma);
                final String texto6_4_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto6_4_1",  idioma);
                final String texto6_5 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto6_5",  idioma);
                final String texto6_6 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto6_6",  idioma);
                final String texto6_7 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto6_7",  idioma);
                final String texto6_7_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto6_7_1",  idioma);
                final String texto6_8 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto6_8",  idioma);
                final String texto6_8_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto6_8_1",  idioma);
                final String texto6_9 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto6_9",  idioma);
                final String texto7_1_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto7_1_1",  idioma);
                Integer anio1desde=new Integer(anioVal-60);
                Object[] params1={anio1desde};
                final String texto7_1_2 = Q02AUtils.getI18nPropertyParams( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto7_1_2",  idioma,params1);
                final String texto7_2_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto7_2_1",  idioma);
                Integer anio2desde=new Integer(anioVal-59);
                Integer anio2hasta=new Integer(anioVal-30);
                Object[] params2={anio2desde,anio2hasta};
                final String texto7_2_2 = Q02AUtils.getI18nPropertyParams( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto7_2_2",  idioma,params2);
                final String texto7_3_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto7_3_1",  idioma);
                Integer anio3desde=new Integer(anioVal-29);
                Integer anio3hasta=new Integer(anioVal-10);
                Object[] params3={anio3desde,anio3hasta};
                final String texto7_3_2 = Q02AUtils.getI18nPropertyParams( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto7_3_2",  idioma,params3);
                final String texto7_4_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto7_4_1",  idioma);
                Integer anio4desde=new Integer(anioVal-10);
                Object[] params4={anio4desde};
                final String texto7_4_2 = Q02AUtils.getI18nPropertyParams( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto7_4_2",  idioma,params4);
                final String texto7_9 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVAPM.texto7_9",  idioma);
                final String textoSi = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.texto.SI",  idioma);
                final String textoNo = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.texto.NO",  idioma);
                final String textoEspecificar = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.texto.especificar",  idioma);
                
                //XML
                StringBuffer xml= new StringBuffer("");
                xml.append("<?xml version=\"1.0\" encoding='ISO-8859-1'?>\n");
                xml.append("\t<cuestionario>\n");
                            
                        xml.append("\t<url>").append(getClass().getResource(imgName).toString()).append("</url>\n");
                        //imagenes
                        xml.append("\t<uno>").append(getClass().getResource(uno).toString()).append("</uno>\n");
                        xml.append("\t<dos>").append(getClass().getResource(dos).toString()).append("</dos>\n");
                        xml.append("\t<tres>").append(getClass().getResource(tres).toString()).append("</tres>\n");
                        xml.append("\t<tresa>").append(getClass().getResource(tresa).toString()).append("</tresa>\n");
                        xml.append("\t<cuatro>").append(getClass().getResource(cuatro).toString()).append("</cuatro>\n");
                        xml.append("\t<cinco>").append(getClass().getResource(cinco).toString()).append("</cinco>\n");
                        xml.append("\t<seis>").append(getClass().getResource(seis).toString()).append("</seis>\n");
                        xml.append("\t<siete>").append(getClass().getResource(siete).toString()).append("</siete>\n");
                        xml.append("\t<ocho>").append(getClass().getResource(ocho).toString()).append("</ocho>\n");
                        xml.append("\t<fin>").append(getClass().getResource(fin).toString()).append("</fin>\n");
                        xml.append("\t<flechaV>").append(getClass().getResource(flechaV).toString()).append("</flechaV>\n");
                        xml.append("\t<flechaE>").append(getClass().getResource(flechaE).toString()).append("</flechaE>\n");
                        xml.append("\t<flechaH>").append(getClass().getResource(flechaH).toString()).append("</flechaH>\n");
                        //textos
                        xml.append("\t<tituloSM>").append( textoTituloVAPM ).append("</tituloSM>\n");
                        xml.append("\t<dirServiciosEus>").append( textoDirServiciosEus ).append("</dirServiciosEus>\n");
                        xml.append("\t<dirServiciosEs>").append( textoDirServiciosEs ).append("</dirServiciosEs>\n");
                        xml.append("\t<textoPie>").append( textoPie ).append("</textoPie>\n");
                        xml.append("\t<textoAnyo>").append( textoAnyo ).append("</textoAnyo>\n");
                        
                        xml.append("\t<titulo1>").append( titulo1 ).append("</titulo1>\n");
                        xml.append("\t<titulo1_1>").append( titulo1_1 ).append("</titulo1_1>\n");
                        xml.append("\t<titulo2>").append( titulo2 ).append("</titulo2>\n");
                        xml.append("\t<titulo2_1>").append( titulo2_1 ).append("</titulo2_1>\n");
                        xml.append("\t<titulo3>").append( titulo3 ).append("</titulo3>\n");
                        
                        xml.append("\t<titulo3A>").append( titulo3A ).append("</titulo3A>\n");
                        
                        xml.append("\t<titulo4>").append( titulo4 ).append("</titulo4>\n");
                        xml.append("\t<titulo4_1>").append( titulo4_1 ).append("</titulo4_1>\n");
                        xml.append("\t<titulo5>").append( titulo5 ).append("</titulo5>\n");
                        xml.append("\t<titulo5_1>").append( titulo5_1 ).append("</titulo5_1>\n");
                        xml.append("\t<titulo6>").append( titulo6 ).append("</titulo6>\n");
                        xml.append("\t<titulo6_1>").append( titulo6_1 ).append("</titulo6_1>\n");
                        xml.append("\t<titulo7>").append( titulo7 ).append("</titulo7>\n");
                        xml.append("\t<titulo7_1>").append( titulo7_1 ).append("</titulo7_1>\n");
                        xml.append("\t<titulo8>").append( titulo8 ).append("</titulo8>\n");
                        
                        xml.append("\t<texto1_2_0_1>").append( texto1_2_0_1 ).append("</texto1_2_0_1>\n");
                        xml.append("\t<texto1_2_0_2>").append( texto1_2_0_2 ).append("</texto1_2_0_2>\n");
                        xml.append("\t<texto1_1>").append( texto1_1 ).append("</texto1_1>\n");
                        xml.append("\t<texto1_2>").append( texto1_2 ).append("</texto1_2>\n");
                        xml.append("\t<texto1_2_1>").append( texto1_2_1 ).append("</texto1_2_1>\n");
                        xml.append("\t<texto1_2_2>").append( texto1_2_2 ).append("</texto1_2_2>\n");
                        xml.append("\t<texto1_2_3>").append( texto1_2_3 ).append("</texto1_2_3>\n");
                        xml.append("\t<texto1_2_9>").append( texto1_2_9 ).append("</texto1_2_9>\n");
                        xml.append("\t<texto2_1>").append( texto2_1 ).append("</texto2_1>\n");
                        xml.append("\t<texto2_2>").append( texto2_2 ).append("</texto2_2>\n");
                        xml.append("\t<texto2_2_1>").append( texto2_2_1 ).append("</texto2_2_1>\n");
                        xml.append("\t<texto2_2_2>").append( texto2_2_2 ).append("</texto2_2_2>\n");
                        xml.append("\t<texto2_2_3>").append( texto2_2_3 ).append("</texto2_2_3>\n");
                        xml.append("\t<texto2_2_9>").append( texto2_2_9 ).append("</texto2_2_9>\n");
                        xml.append("\t<texto3_1>").append( texto3_1 ).append("</texto3_1>\n");
                        xml.append("\t<texto3_2>").append( texto3_2 ).append("</texto3_2>\n");
                        
                        xml.append("\t<texto3A_1>").append( texto3A_1 ).append("</texto3A_1>\n");
                        xml.append("\t<texto3A_2>").append( texto3A_2 ).append("</texto3A_2>\n");
                        xml.append("\t<texto3A_3>").append( texto3A_3 ).append("</texto3A_3>\n");
                        xml.append("\t<texto3A_4>").append( texto3A_4 ).append("</texto3A_4>\n");
                        xml.append("\t<texto3A_5>").append( texto3A_5 ).append("</texto3A_5>\n");
                        xml.append("\t<texto3A_6>").append( texto3A_6 ).append("</texto3A_6>\n");
                        xml.append("\t<texto3A_7>").append( texto3A_7 ).append("</texto3A_7>\n");
                        xml.append("\t<texto3A_8>").append( texto3A_8 ).append("</texto3A_8>\n");                       
                        
                        xml.append("\t<texto4_0_1>").append( texto4_0_1 ).append("</texto4_0_1>\n");
                        xml.append("\t<texto4_0_2>").append( texto4_0_2 ).append("</texto4_0_2>\n");
                        xml.append("\t<texto4_1>").append( texto4_1 ).append("</texto4_1>\n");
                        xml.append("\t<texto4_2>").append( texto4_2 ).append("</texto4_2>\n");
                        xml.append("\t<texto4_3>").append( texto4_3 ).append("</texto4_3>\n");
                        xml.append("\t<texto4_4>").append( texto4_4 ).append("</texto4_4>\n");
                        xml.append("\t<texto4_9>").append( texto4_9 ).append("</texto4_9>\n");
                        xml.append("\t<texto5_1>").append( texto5_1 ).append("</texto5_1>\n");
                        xml.append("\t<texto5_2>").append( texto5_2 ).append("</texto5_2>\n");
                        xml.append("\t<texto5_3>").append( texto5_3 ).append("</texto5_3>\n");
                        xml.append("\t<texto5_4>").append( texto5_4 ).append("</texto5_4>\n");
                        xml.append("\t<texto5_9>").append( texto5_9 ).append("</texto5_9>\n");
                        xml.append("\t<texto6_1>").append( texto6_1 ).append("</texto6_1>\n");
                        xml.append("\t<texto6_2>").append( texto6_2 ).append("</texto6_2>\n");
                        xml.append("\t<texto6_2_1>").append( texto6_2_1 ).append("</texto6_2_1>\n");
                        xml.append("\t<texto6_3>").append( texto6_3 ).append("</texto6_3>\n");
                        xml.append("\t<texto6_3_1>").append( texto6_3_1 ).append("</texto6_3_1>\n");
                        
                        xml.append("\t<texto6_4>").append( texto6_4 ).append("</texto6_4>\n");
                        xml.append("\t<texto6_4_1>").append( texto6_4_1 ).append("</texto6_4_1>\n");
                        xml.append("\t<texto6_5>").append( texto6_5 ).append("</texto6_5>\n");
                        xml.append("\t<texto6_6>").append( texto6_6 ).append("</texto6_6>\n");
                        xml.append("\t<texto6_7>").append( texto6_7 ).append("</texto6_7>\n");
                        xml.append("\t<texto6_7_1>").append( texto6_7_1 ).append("</texto6_7_1>\n");
                        xml.append("\t<texto6_8>").append( texto6_8 ).append("</texto6_8>\n");
                        xml.append("\t<texto6_8_1>").append( texto6_8_1 ).append("</texto6_8_1>\n");
                        xml.append("\t<texto6_9>").append( texto6_9 ).append("</texto6_9>\n");
                        xml.append("\t<texto7_1_1>").append( texto7_1_1 ).append("</texto7_1_1>\n");
                        xml.append("\t<texto7_1_2>").append( texto7_1_2 ).append("</texto7_1_2>\n");
                        xml.append("\t<texto7_2_1>").append( texto7_2_1 ).append("</texto7_2_1>\n");
                        xml.append("\t<texto7_2_2>").append( texto7_2_2 ).append("</texto7_2_2>\n");
                        xml.append("\t<texto7_3_1>").append( texto7_3_1 ).append("</texto7_3_1>\n");
                        xml.append("\t<texto7_3_2>").append( texto7_3_2 ).append("</texto7_3_2>\n");
                        xml.append("\t<texto7_4_1>").append( texto7_4_1 ).append("</texto7_4_1>\n");
                        xml.append("\t<texto7_4_2>").append( texto7_4_2 ).append("</texto7_4_2>\n");
                        xml.append("\t<texto7_9>").append( texto7_9 ).append("</texto7_9>\n");
                        xml.append("\t<textoSi>").append( textoSi ).append("</textoSi>\n");
                        xml.append("\t<textoNo>").append( textoNo ).append("</textoNo>\n");
                        xml.append("\t<textoEspecificar>").append( textoEspecificar ).append("</textoEspecificar>\n");
                        
                        //
                        xml.append("\t<anyo>").append( "".equals(cuestionarioVAPMVO.getAno().toString()) ?"":(cuestionarioVAPMVO.getAno().toString()) ).append("</anyo>\n");
                        
                        
                            xml.append("\t<prv1a>").append( cuestionarioVAPMVO.getPrv1a() == null?"":(cuestionarioVAPMVO.getPrv1a()) ).append("</prv1a>\n");
                            xml.append("\t<adqvi1>").append( cuestionarioVAPMVO.getAdqvi1() == null?"":(cuestionarioVAPMVO.getAdqvi1()) ).append("</adqvi1>\n");
                            //xml.append("\t<nadqvi1>").append( cuestionarioVAPMVO.getNadq1() == null?"":(cuestionarioVAPMVO.getNadq1()) ).append("</nadqvi1>\n");
                            xml.append("\t<nadqvi1>").append( cuestionarioVAPMVO.getNadq1() == null?"":( q02a.exe.ejbs.utils.Q02AUtils.getPuntosMiles(cuestionarioVAPMVO.getNadq1())) ).append("</nadqvi1>\n");
                            xml.append("\t<provi1>").append( cuestionarioVAPMVO.getProvi1() == null?"":(cuestionarioVAPMVO.getProvi1()) ).append("</provi1>\n");
                            xml.append("\t<nprovi1>").append( cuestionarioVAPMVO.getNpro1() == null?"":( q02a.exe.ejbs.utils.Q02AUtils.getPuntosMiles(cuestionarioVAPMVO.getNpro1())) ).append("</nprovi1>\n");
                            xml.append("\t<otrvi1>").append( cuestionarioVAPMVO.getOtrvi1() == null?"":(cuestionarioVAPMVO.getOtrvi1()) ).append("</otrvi1>\n");
                            xml.append("\t<notrvi1>").append( cuestionarioVAPMVO.getNotr1() == null?"":( q02a.exe.ejbs.utils.Q02AUtils.getPuntosMiles(cuestionarioVAPMVO.getNotr1())) ).append("</notrvi1>\n");
                            xml.append("\t<otrlt1>").append( cuestionarioVAPMVO.getOtrlt1() == null?"":(cuestionarioVAPMVO.getOtrlt1()) ).append("</otrlt1>\n");
                            xml.append("\t<ntot1>").append( cuestionarioVAPMVO.getNtot1() == null?"":( q02a.exe.ejbs.utils.Q02AUtils.getPuntosMiles(cuestionarioVAPMVO.getNtot1())) ).append("</ntot1>\n");
                            //
                            xml.append("\t<prv4a>").append( cuestionarioVAPMVO.getPrv4a() == null?"":(cuestionarioVAPMVO.getPrv4a()) ).append("</prv4a>\n");
                            xml.append("\t<adqvi4>").append( cuestionarioVAPMVO.getAdqvi4() == null?"":(cuestionarioVAPMVO.getAdqvi4()) ).append("</adqvi4>\n");
                            xml.append("\t<nadq4>").append( cuestionarioVAPMVO.getNadq4() == null?"":( q02a.exe.ejbs.utils.Q02AUtils.getPuntosMiles(cuestionarioVAPMVO.getNadq4())) ).append("</nadq4>\n");
                            xml.append("\t<provi4>").append( cuestionarioVAPMVO.getProvi4() == null?"":(cuestionarioVAPMVO.getProvi4()) ).append("</provi4>\n");
                            xml.append("\t<npro4>").append( cuestionarioVAPMVO.getNpro4() == null?"":( q02a.exe.ejbs.utils.Q02AUtils.getPuntosMiles(cuestionarioVAPMVO.getNpro4())) ).append("</npro4>\n");
                            xml.append("\t<otrvi4>").append( cuestionarioVAPMVO.getOtrvi4() == null?"":(cuestionarioVAPMVO.getOtrvi4()) ).append("</otrvi4>\n");
                            xml.append("\t<notr4>").append( cuestionarioVAPMVO.getNotr4() == null?"":( q02a.exe.ejbs.utils.Q02AUtils.getPuntosMiles(cuestionarioVAPMVO.getNotr4())) ).append("</notr4>\n");
                            xml.append("\t<otrlt4>").append( cuestionarioVAPMVO.getOtrlt4() == null?"":(cuestionarioVAPMVO.getOtrlt4()) ).append("</otrlt4>\n");
                            xml.append("\t<ntot4>").append( cuestionarioVAPMVO.getNtot4() == null?"":( q02a.exe.ejbs.utils.Q02AUtils.getPuntosMiles(cuestionarioVAPMVO.getNtot4())) ).append("</ntot4>\n");
                            //
                            xml.append("\t<talq>").append( cuestionarioVAPMVO.getTalq() == null?"":(cuestionarioVAPMVO.getTalq()) ).append("</talq>\n");
                            xml.append("\t<nalq>").append( cuestionarioVAPMVO.getNalq() == null?"":( q02a.exe.ejbs.utils.Q02AUtils.getPuntosMiles(cuestionarioVAPMVO.getNalq())) ).append("</nalq>\n");
                            //
                            xml.append("\t<nexcl>").append( cuestionarioVAPMVO.getNexcl() == null?"":( q02a.exe.ejbs.utils.Q02AUtils.getPuntosMiles(cuestionarioVAPMVO.getNexcl())) ).append("</nexcl>\n");
                            xml.append("\t<nemer>").append( cuestionarioVAPMVO.getNemer() == null?"":( q02a.exe.ejbs.utils.Q02AUtils.getPuntosMiles(cuestionarioVAPMVO.getNemer())) ).append("</nemer>\n");
                            xml.append("\t<notro>").append( cuestionarioVAPMVO.getNotro() == null?"":( q02a.exe.ejbs.utils.Q02AUtils.getPuntosMiles(cuestionarioVAPMVO.getNotro())) ).append("</notro>\n");
                            xml.append("\t<desvotr>").append( cuestionarioVAPMVO.getDesvotr() == null?"":(cuestionarioVAPMVO.getDesvotr()) ).append("</desvotr>\n");
                            xml.append("\t<nprop>").append( cuestionarioVAPMVO.getNprop() == null?"":( q02a.exe.ejbs.utils.Q02AUtils.getPuntosMiles(cuestionarioVAPMVO.getNprop())) ).append("</nprop>\n");
                          
                            xml.append("\t<nsp45>").append( cuestionarioVAPMVO.getNsp45() == null?"":( q02a.exe.ejbs.utils.Q02AUtils.getPuntosMiles(cuestionarioVAPMVO.getNsp45())) ).append("</nsp45>\n");
                            xml.append("\t<nrsp45>").append( cuestionarioVAPMVO.getNrsp45() == null?"":( q02a.exe.ejbs.utils.Q02AUtils.getPuntosMiles(cuestionarioVAPMVO.getNrsp45())) ).append("</nrsp45>\n");
                            xml.append("\t<nsp75>").append( cuestionarioVAPMVO.getNsp75() == null?"":( q02a.exe.ejbs.utils.Q02AUtils.getPuntosMiles(cuestionarioVAPMVO.getNsp75())) ).append("</nsp75>\n");
                            xml.append("\t<nrsp75>").append( cuestionarioVAPMVO.getNrsp75() == null?"":( q02a.exe.ejbs.utils.Q02AUtils.getPuntosMiles(cuestionarioVAPMVO.getNrsp75())) ).append("</nrsp75>\n");
                            xml.append("\t<nsp90>").append( cuestionarioVAPMVO.getNsp90() == null?"":( q02a.exe.ejbs.utils.Q02AUtils.getPuntosMiles(cuestionarioVAPMVO.getNsp90())) ).append("</nsp90>\n");
                            xml.append("\t<nrsp90>").append( cuestionarioVAPMVO.getNrsp90() == null?"":( q02a.exe.ejbs.utils.Q02AUtils.getPuntosMiles(cuestionarioVAPMVO.getNrsp90())) ).append("</nrsp90>\n");
                            xml.append("\t<nsp90m>").append( cuestionarioVAPMVO.getNsp90m() == null?"":( q02a.exe.ejbs.utils.Q02AUtils.getPuntosMiles(cuestionarioVAPMVO.getNsp90m())) ).append("</nsp90m>\n");
                            xml.append("\t<nrsp90m>").append( cuestionarioVAPMVO.getNrsp90m() == null?"":( q02a.exe.ejbs.utils.Q02AUtils.getPuntosMiles(cuestionarioVAPMVO.getNrsp90m())) ).append("</nrsp90m>\n");
                            xml.append("\t<nspt>").append( cuestionarioVAPMVO.getNspt() == null?"":( q02a.exe.ejbs.utils.Q02AUtils.getPuntosMiles(cuestionarioVAPMVO.getNspt())) ).append("</nspt>\n");
                            //
                            xml.append("\t<nocup>").append( cuestionarioVAPMVO.getNocup() == null?"":( q02a.exe.ejbs.utils.Q02AUtils.getPuntosMiles(cuestionarioVAPMVO.getNocup())) ).append("</nocup>\n");
                            xml.append("\t<ndesa>").append( cuestionarioVAPMVO.getNdesa() == null?"":( q02a.exe.ejbs.utils.Q02AUtils.getPuntosMiles(cuestionarioVAPMVO.getNdesa())) ).append("</ndesa>\n");
                            xml.append("\t<ndeso>").append( cuestionarioVAPMVO.getNdeso() == null?"":( q02a.exe.ejbs.utils.Q02AUtils.getPuntosMiles(cuestionarioVAPMVO.getNdeso())) ).append("</ndeso>\n");
                            xml.append("\t<ndesot>").append( cuestionarioVAPMVO.getNdesot() == null?"":( q02a.exe.ejbs.utils.Q02AUtils.getPuntosMiles(cuestionarioVAPMVO.getNdesot())) ).append("</ndesot>\n");
                            xml.append("\t<desotr>").append( cuestionarioVAPMVO.getDesotr() == null?"":(cuestionarioVAPMVO.getDesotr()) ).append("</desotr>\n");
                            xml.append("\t<nocut>").append( cuestionarioVAPMVO.getNocut() == null?"":( q02a.exe.ejbs.utils.Q02AUtils.getPuntosMiles(cuestionarioVAPMVO.getNocut())) ).append("</nocut>\n");
                            //
                            xml.append("\t<nlibre>").append( cuestionarioVAPMVO.getNlibre() == null?"":( q02a.exe.ejbs.utils.Q02AUtils.getPuntosMiles(cuestionarioVAPMVO.getNlibre())) ).append("</nlibre>\n");
                            xml.append("\t<nvpog>").append( cuestionarioVAPMVO.getNvpog() == null?"":( q02a.exe.ejbs.utils.Q02AUtils.getPuntosMiles(cuestionarioVAPMVO.getNvpog())) ).append("</nvpog>\n");
                            xml.append("\t<nvpoe>").append( cuestionarioVAPMVO.getNvpoe() == null?"":( q02a.exe.ejbs.utils.Q02AUtils.getPuntosMiles(cuestionarioVAPMVO.getNvpoe())) ).append("</nvpoe>\n");
                            xml.append("\t<nvpot>").append( cuestionarioVAPMVO.getNvpot() == null?"":( q02a.exe.ejbs.utils.Q02AUtils.getPuntosMiles(cuestionarioVAPMVO.getNvpot())) ).append("</nvpot>\n");
                            xml.append("\t<nalod>").append( cuestionarioVAPMVO.getNalod() == null?"":( q02a.exe.ejbs.utils.Q02AUtils.getPuntosMiles(cuestionarioVAPMVO.getNalod())) ).append("</nalod>\n");
                            xml.append("\t<nreal>").append( cuestionarioVAPMVO.getNreal() == null?"":( q02a.exe.ejbs.utils.Q02AUtils.getPuntosMiles(cuestionarioVAPMVO.getNreal())) ).append("</nreal>\n");
                            xml.append("\t<nvtmg>").append( cuestionarioVAPMVO.getNvtmg() == null?"":( q02a.exe.ejbs.utils.Q02AUtils.getPuntosMiles(cuestionarioVAPMVO.getNvtmg())) ).append("</nvtmg>\n");
                            xml.append("\t<nvtme>").append( cuestionarioVAPMVO.getNvtme() == null?"":( q02a.exe.ejbs.utils.Q02AUtils.getPuntosMiles(cuestionarioVAPMVO.getNvtme())) ).append("</nvtme>\n");
                            xml.append("\t<nvtot>").append( cuestionarioVAPMVO.getNvtot() == null?"":( q02a.exe.ejbs.utils.Q02AUtils.getPuntosMiles(cuestionarioVAPMVO.getNvtot())) ).append("</nvtot>\n");
                            //
                            xml.append("\t<nant60m>").append( cuestionarioVAPMVO.getNant60m() == null?"":( q02a.exe.ejbs.utils.Q02AUtils.getPuntosMiles(cuestionarioVAPMVO.getNant60m())) ).append("</nant60m>\n");
                            xml.append("\t<nant30>").append( cuestionarioVAPMVO.getNant30() == null?"":( q02a.exe.ejbs.utils.Q02AUtils.getPuntosMiles(cuestionarioVAPMVO.getNant30())) ).append("</nant30>\n");
                            xml.append("\t<nant10>").append( cuestionarioVAPMVO.getNant10() == null?"":( q02a.exe.ejbs.utils.Q02AUtils.getPuntosMiles(cuestionarioVAPMVO.getNant10())) ).append("</nant10>\n");
                            xml.append("\t<nant10m>").append( cuestionarioVAPMVO.getNant10m() == null?"":( q02a.exe.ejbs.utils.Q02AUtils.getPuntosMiles(cuestionarioVAPMVO.getNant10m())) ).append("</nant10m>\n");
                            xml.append("\t<nantt>").append( cuestionarioVAPMVO.getNantt() == null?"":( q02a.exe.ejbs.utils.Q02AUtils.getPuntosMiles(cuestionarioVAPMVO.getNantt())) ).append("</nantt>\n");
                            //
                            xml.append("\t<observaciones>").append( cuestionarioVAPMVO.getObsal() == null?"":(cuestionarioVAPMVO.getObsal().toString()) ).append("</observaciones>\n");
                            
                xml.append("\t</cuestionario>");
                
                final String xmlString = xml.toString();
                //System.out.println(xmlString);
                StringReader stream = new StringReader(xmlString); 
                
                try{
                    //System.out.println("--- Antes de la llamada a pdf ---");
                    Q02AUtils.convertXML2PDF( stream, pdfFile, getClass().getResourceAsStream(rutaXsl));
                    //System.out.println("--- Despues de la llamada a pdf ---");
                    
                }catch (Exception e){
                    pdfFile.delete();
                    //System.out.println("Error al generar pdf imprimir CuestionarioSM" );
                    throw new EJBException("Error al generar pdf imprimir CuestionarioSM",e  );
                }
                pdfFile.deleteOnExit();
            }catch(Exception exp){
                pdfFile.delete();
                //System.out.println("Error al imprimir CuestionarioSM" );
                throw new EJBException("Error al imprimir CuestionarioVAPM",exp  );
            }
            //System.out.println("--- FIN ---");
            
            ///////////////////////////////////////////////////////////////////////////////
            
            return new Q02aDocumento("Cuestionario.pdf","application/pdf",charset,pdfFile);
            
            
            //return mapaCuestionarioVAPM;
        } catch(Q02aAplicException ex1){              
              java.io.StringWriter sw = new java.io.StringWriter();
              java.io.PrintWriter pw = new java.io.PrintWriter(sw);
              ex1.printStackTrace(pw);
              tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioVAPM: " + sw.getBuffer ().toString());
              throw ex1;        
        }catch(Exception ex){       
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCuestionarioVAPM: " + sw.getBuffer ().toString());
            throw ex;                     
        }finally{       
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioVAPM: saliendo.");
            }
        }
    }//fin generarPdfCuestionarioVAPMAnu*/
        
} // fin clase
