package q02aComunSesionEJB;

import java.rmi.RemoteException;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;

import q02a.exe.comun.Q02aAutenticador;
import q02a.exe.comun.beans.Q02aContactoBean;
import q02a.exe.comun.beans.Q02aMailToBean;
import q02a.exe.comun.valueobjects.Q02aContacto;
import q02a.exe.comun.valueobjects.Q02aMailTo;
import q02a.exe.utils.Q02aVoUtils;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.infraestructura.traza.Q70Traza;
 
/**
 * XDoclet-based session bean.  The class must be declared
 * public according to the EJB specification.
 *
 * To generate the EJB related files to this EJB:
 *		- Add Standard EJB module to XDoclet project properties
 *		- Customize XDoclet configuration for your appserver
 *		- Run XDoclet
 *
 * Below are the xdoclet-related tags needed for this EJB.
 * 
 * @ejb.bean name="Q02aCuestionariosAyunMenSesion"
 *           display-name="Name for Q02aCuestionariosAyunMenSesion"
 *           description="Description for Q02aCuestionariosAyunMenSesion"
 *           jndi-name="ejb/Q02aCuestionariosAyunMenSesion"
 *           type="Stateless"
 *           view-type="remote"
 */
  
public class Q02aComunSesionBean implements SessionBean {

	private static final long serialVersionUID = 4131248384461301469L;
	private static Q70Traza tr = Q70Traza.getSingleton();
	private static final String COMPONENTE = "EJB_SESION_COMUN";
	//protected Q02aComunBean beanComun= null;
	
	/** The session context */
	private javax.ejb.SessionContext mySessionCtx;

	public Q02aComunSesionBean() {
		super();
		// TODO Auto-generated constructor stub
	}

    /**
	 * Set the associated session context. The container calls this method 
	 * after the instance creation.
	 * 
	 * The enterprise bean instance should store the reference to the context 
	 * object in an instance variable.
	 * 
	 * This method is called with no transaction context. 
	 * 
	 * @throws EJBException Thrown if method fails due to system-level error.
	 */

	public javax.ejb.SessionContext getSessionContext() {
		return mySessionCtx;
	}
	/**
	 * setSessionContext
	 */
	public void setSessionContext(javax.ejb.SessionContext ctx) {
		mySessionCtx = ctx;
	}

	public void ejbRemove() throws EJBException, RemoteException {
		// TODO Auto-generated method stub
	}

	public void ejbActivate() throws EJBException, RemoteException {
		// TODO Auto-generated method stub

	}

	public void ejbPassivate() throws EJBException, RemoteException {
		// TODO Auto-generated method stub
	}

	/**
	 * An ejbCreate method as required by the EJB specification.
	 * 
	 * The container calls the instance?s <code>ejbCreate</code> method whose
	 * signature matches the signature of the <code>create</code> method invoked
	 * by the client. The input parameters sent from the client are passed to
	 * the <code>ejbCreate</code> method. Each session bean class must have at
	 * least one <code>ejbCreate</code> method. The number and signatures
	 * of a session bean?s <code>create</code> methods are specific to each 
	 * session bean class.
	 * 
	 * @throws CreateException Thrown if method fails due to system-level error.
	 * 
	 * @ejb.create-method
	 * 
	 */
	public void ejbCreate() throws CreateException {
		// TODO Add ejbCreate method implementation
	}   

    /**
	 * Enviar Correo Electronico al responsable de la aplicacion
	 * 
	 * 
	 *  
	 * @throws Exception
	 */

	 public void enviarEmailContacto (java.util.HashMap mailMapa) throws Exception {
        // Definicin de variables que no se van a modificar
		final String TRACE_METODO 	= ":enviarEmailContacto:";
		
		final String RUTA_CLASE_EMAIL_TO 		= "q02a.exe.comun.valueobjects.Q02aMailTo";

		try{
	        if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + "entrando.");
	   		}

	        Q02aMailToBean bean = new Q02aMailToBean();
	  		//se pasa el autenticador
	  		//bean.setAutenticador(autenticador);
	  		//se llama al mtodo del bean necesario
	  		Q02aMailTo mail = new Q02aMailTo();
	  		mail = (Q02aMailTo) Q02aVoUtils.getValueObject(mailMapa,RUTA_CLASE_EMAIL_TO);
	  		mail.setDestinatario("");
	  		bean.enviarEmailContacto(mail); 
	        
		}catch(Exception ex){	 	
			java.io.StringWriter sw = new java.io.StringWriter();
			java.io.PrintWriter pw = new java.io.PrintWriter(sw);
			ex.printStackTrace(pw);
			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerContactos: " + sw.getBuffer ().toString());
			throw ex;		
	 	}finally{    	
	        if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + "saliendo.");
	   		}
	 	}
	}// fin enviarEmailContacto
	 
	 public void contactar (java.util.HashMap datosContacto, Q02aAutenticador autenticador) throws Exception {
	        // Definicin de variables que no se van a modificar
			final String TRACE_METODO 	= ":contactar:";
			
			final String RUTA_CLASE_CONTACTO = "q02a.exe.comun.valueobjects.Q02aContacto";

			try{
		        if (tr.isTraceActive()){
		   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + "entrando.");
		   		}
				
		        Q02aContactoBean bean = new Q02aContactoBean();
		  		//se pasa el autenticador
		  		bean.setAutenticador(autenticador);
		  		//se llama al mtodo del bean necesario
		  		Q02aContacto mail = new Q02aContacto();
		  		mail = (Q02aContacto) Q02aVoUtils.getValueObject(datosContacto,RUTA_CLASE_CONTACTO);
		  		mail.setDestinatario("");
		  		bean.contactar(mail); 
			}catch(Exception ex){	 	
				java.io.StringWriter sw = new java.io.StringWriter();
				java.io.PrintWriter pw = new java.io.PrintWriter(sw);
				ex.printStackTrace(pw);
				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":contactar: " + sw.getBuffer ().toString());
				throw ex;		
		 	}finally{    	
		        if (tr.isTraceActive()){
		   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + "saliendo.");
		   		}
		 	}
		}// fin contactar
} // fin clase
