package q02a.exe.ejbs.noraConsultas;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.naming.NamingException;

import es.ejie.frmk.conectores.conectorJDBC.Q70ConectorJDBC;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;

/**
 * 
 * @author GADIMAAR
 *
 */
public class Q02AUtilsEjbs {
       
    public static String Q02_JNDI_DATASOURCE = Q70ListenerUtils.getApplicationProperty("Q02aCentrosBean",null,"Q02_JNDI_DATASOURCE");
    
    /**
     * 
     * @param idProvincia idProvincia
     * @return provincia
     * @throws SQLException SQLException
     * @throws NamingException NamingException
     */
    public static String getProvincia(String idProvincia) throws SQLException, NamingException{
        
        String provincia = "";
        final StringBuffer sql = new StringBuffer();        
        
        final Connection connection = Q70ConectorJDBC.getSingleton().getConnection(Q02_JNDI_DATASOURCE);
        
            //SACAR LA Provincia
            sql.append("SELECT DS_O ");            
            sql.append("FROM NORA_T17_PROVINCIA ");
            sql.append("WHERE ID = ? ");           
            
            //Preparamos la llamada a BBDD
            final PreparedStatement ps = connection.prepareStatement(sql.toString());
            try{
                ps.setString(1, idProvincia.toString());
                ps.execute();
                                
                //Leemos los registros buscados
                final ResultSet rs = ps.getResultSet();
                try{
                    if (rs.next()){
                        provincia = rs.getString("DS_O");
                    }
    
                }finally{
                    try {rs.close();
                    } catch(SQLException e) {}
                }
            }finally{
                try {ps.close();
                } catch(SQLException e) {}
            }
        
        return provincia;
    }
    
    /**
     * 
     * @param idProvincia idProvincia
     * @param idMunicipio idMunicipio
     * @return municipio
     * @throws SQLException SQLException
     * @throws NamingException NamingException
     */
    public static String getMunicipio(String idProvincia, String idMunicipio) throws SQLException, NamingException{
        
        String municipio = "";
        final StringBuffer sql = new StringBuffer();        
        
        final Connection connection = Q70ConectorJDBC.getSingleton().getConnection(Q02_JNDI_DATASOURCE);
        
            //SACAR Municipio
            sql.append("SELECT DS_O ");            
            sql.append("FROM NORA_T17_MUNICIPIO ");
            sql.append("WHERE ID = ? ");  
            sql.append(" and PROVINCIA_ID = ? ");
            
            //Preparamos la llamada a BBDD
            final PreparedStatement ps = connection.prepareStatement(sql.toString());
            try{
                ps.setString(1, idMunicipio.toString());
                ps.setString(2, idProvincia.toString());
                ps.execute();
                                
                //Leemos los registros buscados
                final ResultSet rs = ps.getResultSet();
                try{
                    if (rs.next()){
                        municipio = rs.getString("DS_O");
                    }
    
                }finally{
                    try {rs.close();
                    } catch(SQLException e) {}
                }
            }finally{
                try {ps.close();
                } catch(SQLException e) {}
            }
        
        return municipio;
    }
    
    //Entidad
    /**
     * @param idLocalidad idLocalidad
     * @return localidad
     * @throws SQLException SQLException
     * @throws NamingException NamingException
     */
    public static String getLocalidad(String idLocalidad) throws SQLException, NamingException{
        
        String localidad = "";
        final StringBuffer sql = new StringBuffer();        
        
        final Connection connection = Q70ConectorJDBC.getSingleton().getConnection(Q02_JNDI_DATASOURCE);
        
            //SACAR Municipio
            sql.append("SELECT DS_O ");            
            sql.append("FROM NORA_T17_LOCALIDAD ");
            sql.append("WHERE ID = ? ");           
            
            //Preparamos la llamada a BBDD
            final PreparedStatement ps = connection.prepareStatement(sql.toString());
            try{
                ps.setString(1, idLocalidad.toString());
                ps.execute();
                                
                //Leemos los registros buscados
                final ResultSet rs = ps.getResultSet();
                try{
                    if (rs.next()){
                        localidad = rs.getString("DS_O");
                    }
    
                }finally{
                    try {rs.close();
                    } catch(SQLException e) {}
                }
            }finally{
                try {ps.close();
                } catch(SQLException e) {}
            }
        
        return localidad;
    }
    
    /**
     * 
     * @param idTipo_Via idTipo_Via
     * @param idioma idioma
     * @return tipo_Via
     * @throws SQLException SQLException
     * @throws NamingException NamingException
     */
    public static String getTipo_Via(String idTipo_Via, String idioma) throws SQLException, NamingException{
        
        String  tipo_Via = "";
        final StringBuffer sql = new StringBuffer();        
        
        final Connection connection = Q70ConectorJDBC.getSingleton().getConnection(Q02_JNDI_DATASOURCE);
        
            //SACAR LA DELEGACION DEL USUARIO
            sql.append("SELECT DS_E, DS_C ");            
            sql.append("FROM NORA_T17_TIPO_VIA ");
            sql.append("WHERE ID = ? ");          
            
            //Preparamos la llamada a BBDD
            final PreparedStatement ps = connection.prepareStatement(sql.toString());
            try{
                ps.setString(1, idTipo_Via);
                ps.execute();
                                
                //Leemos los registros buscados
                final ResultSet rs = ps.getResultSet();
                try{
                    if (rs.next()){
                        if ("es".equalsIgnoreCase(idioma)){
                            if (rs.getString("DS_C") == null) {tipo_Via = "";}
                            else {tipo_Via = rs.getString("DS_C");}
                        }else{
                            if (rs.getString("DS_E") == null) {tipo_Via = "";}
                            else {tipo_Via = rs.getString("DS_E");}
                        }
                    }
    
                }finally{
                    try {rs.close();
                    } catch(SQLException e) {}
                }
            }finally{
                try {ps.close();
                } catch(SQLException e) {}
            }
        
        return tipo_Via;
    }
    
    /**
     * 
     * @param id_Via id_Via
     * @param idioma idioma
     * @return calle
     * @throws SQLException SQLException
     * @throws NamingException NamingException
     */
        public static String getCalle(String id_Via, String idioma) throws SQLException, NamingException{
        
        String calle = "";
        final StringBuffer sql = new StringBuffer();        
        

        final Connection connection = Q70ConectorJDBC.getSingleton().getConnection(Q02_JNDI_DATASOURCE);
        
            //SACAR LA DELEGACION DEL USUARIO
            sql.append("SELECT DS_O, DS_E ");            
            sql.append("FROM NORA_T17_CALLE ");
            sql.append("WHERE ID = ? ");          
            
            //Preparamos la llamada a BBDD
            final PreparedStatement ps = connection.prepareStatement(sql.toString());
            try{
                ps.setString(1, id_Via);
                ps.execute();
                                
                //Leemos los registros buscados
                final ResultSet rs = ps.getResultSet();
                try{
                    if (rs.next()){
                        if ("es".equalsIgnoreCase(idioma)){
                            calle = rs.getString("DS_O");
                        }else{
                            if (rs.getString("DS_E") != null){
                                calle = rs.getString("DS_E");
                            }else{
                                calle = rs.getString("DS_O");
                            }
                        }
                    }
    
                }finally{
                    try {rs.close();
                    } catch(SQLException e) {}
                }
            }finally{
                try {ps.close();
                } catch(SQLException e) {}
            }
        
        return calle;
    }

//      Portal
        /**
         * @param idPortal idPortal
         * @throws SQLException SQLException
         * @throws NamingException NamingException
         * @return portal
     */
        public static String getPortal(String idPortal) throws SQLException, NamingException{
            
            String portal = "";
            final StringBuffer sql = new StringBuffer();        
            
            final Connection connection = Q70ConectorJDBC.getSingleton().getConnection(Q02_JNDI_DATASOURCE);
            
                //SACAR Municipio
                sql.append("SELECT NUMERO ");            
                sql.append("FROM NORA_T17_PORTAL ");
                sql.append("WHERE ID = ? ");           
                
                //Preparamos la llamada a BBDD
                final PreparedStatement ps = connection.prepareStatement(sql.toString());
                try{
                    ps.setString(1, idPortal.toString());
                    ps.execute();
                                    
                    //Leemos los registros buscados
                    final ResultSet rs = ps.getResultSet();
                    try{
                        if (rs.next()){
                            portal = rs.getString("NUMERO");
                        }
        
                    }finally{
                        try {rs.close();
                        } catch(SQLException e) {}
                    }
                }finally{
                    try {ps.close();
                    } catch(SQLException e) {}
                }
            
            return portal;
        }
        
        /**
         * @param idPortal idPortal
         * @throws SQLException SQLException
         * @throws NamingException NamingException
         * @return portal
     */
        public static String getMailWebCortado(String mailWeb) throws SQLException, NamingException{
            
            StringBuffer textoBuf = new StringBuffer();
            String texto = mailWeb;
            if (mailWeb.length() > 40){
                textoBuf.append(texto.substring(0, 39)).append(" ").append(texto.substring(39,mailWeb.length()));
                texto = textoBuf.toString();
            }
            
                
            
            return texto;
        }
        
}