package q02a.exe.utils.oracle;

import java.util.ListResourceBundle;

/**
 * Message Bundle for custom error messages used by the framework
 * extension functionality for the Pet Store demo.
 *@author asesdf
 */

public class Q02aErrorMessages extends ListResourceBundle {

  private static final Object[][] sMessageStrings = new String[][] {

    /*
     * The following two error messages are keyed by their Oracle database
     * constraint name, and together with the framework extension code will be
     * automatically thrown if a database constraint violation occurs
     * for one of these constraint names.
     */

    // TWOCOL_UNIQUE is the name of the unique primary key constraint
	{"UK_Q022AT00","error.oi.existePlazo"}
    /*
     * {"Q02GNT05_Q02GNT04_FK","error.oi.existenDetallesEnContador"},
    {"Q02GNT05_PK","error.oi.existeDetalleContador"},
    {"Q02SGT10_Q02GNT04_02_FK","error.oi.existenContadoresEnDelegacion"},
    {"Q02PRT06_Q02GNT04_FK","error.oi.existenExpedientesContador"},
    {"Q02VIT01_Q02ECT02_FK","error.oi.existenVisitasParaCentro"},
    {"Q02ANT01_Q02ECT02_01_FK","error.oi.existenOrdenDeMuestra"},
    {"S93ECT03_Q02ECT08_FK","error.oi.existenContactos"},
    {"Q02ECT06_Q02ECT11_FK ","error.oi.existenHistoricoCentrosParaCiudadEx"},
    {"Q02ECT07_Q02ECT08_FK","error.oi.existenHistoricoContactosParaCargo"},
    {"Q02GNT09_Q02GNT07_FK","error.oi.existeDocumento"},
    {"Q02GNT10_PK","error.oi.existeRestriccionSeccion"},
    {"Q02ECT04_Q02ECT03_FK","error.oi.existeRelaccionesContacto"},
    {"Q02SGT06_Q02SGT11_FK","error.oi.existeDependenciasModulo"},
    {"Q02DTT13_PK","error.oi.existeDependenciasModulo"},
    {"Q02ECT01_UK","error.oi.CIFExiste"},
    {"Q02DTT68_PK","error.oi.existeBolsaActivGenRes"},
    {"Q02DTT45_PK","error.oi.existeBolsaActivEprtr"},
    {"Q02DTT47_PK","error.oi.existeBolsaActivGei"},
    {"Q02DTT54_PK","error.oi.existeBolsaActivIppc"},
    {"Q02DTT60_PK","error.oi.existeBolsaActivIpcc"},
    {"Q02DTT81_Q02DTT86_FK","error.oi.existeTipoInstalacion"},
    {"TG_Q02DTT68_BD","error.oi.borrarBolsaActivGenResPrincipal"},
    {"TG_Q02DTT45_BD","error.oi.borrarBolsaActivEprtrPrincipal"},
    {"TG_Q02DTT47_BD","error.oi.borrarBolsaActivGeiPrincipal"},
    {"TG_Q02DTT54_BD","error.oi.borrarBolsaActivIppcPrincipal"},
    {"TG_Q02DTT60_BD","error.oi.borrarBolsaActivIpccPrincipal"},
    {"TG_Q02DTT43_BD","error.oi.borrarBolsaActivCnae2002Principal"},
    {"Q02DTT56_PK","error.oi.existeBolsaActivIppcCodNosep"},
    {"Q02DTT57_Q02DTT56_FK","error.oi.borrarBolsaActivIppcCodNosep"},
    {"Q02DTT56_Q02DTT54_FK","error.oi.existeCodigoNosepBolsaActivIppc"},
    {"Q02DTT57_PK","error.oi.existeBolsaActivIppcCodSnap"},
    {"Q02DTT61_PK","error.oi.existeBolsaActivIpccCodNosep"},
    {"Q02DTT62_Q02DTT61_FK","error.oi.borrarBolsaActivIpccCodNosep"},
    {"Q02DTT61_Q02DTT60_FK","error.oi.existeCodigoNosepBolsaActivIpcc"},
    {"Q02DTT62_PK","error.oi.existeBolsaActivIpccCodSnap"},
    {"Q02DTT43_PK","error.oi.asociarBolsaActivCnae2002"},
    {"Q02SGT05_Q02SGT02_FK","error.oi.GrupoRoles"},
    {"Q02ECT10_PK","error.oi.existeRelacionVerificadorCentro"},
    {"Q02DTT93_PK","error.oi.existeBolsaTransportista"},
    {"Q02SGT07_Q02SGT02_FK","error.oi.RolesProcesos"}*/
  };

  /**
   * Return String Identifiers and corresponding Messages in a two-dimensional array.
   * @return sMessageStrings
   */

  protected Object[][] getContents() {
    return sMessageStrings;
  }
  
  /**
   * Return String Identifiers and corresponding Messages in a two-dimensional array.
   * @param clave clave
   * @return msg
   */
  public String getMessage(String clave) {	
	  String msg = "";
	  for(int i = 0; i < sMessageStrings.length; i++ ) {
		  String[] a = (String[])sMessageStrings[i];
	      String key =  a[0];
	      if (key!= null && key.equals(clave)){
	    	  msg = a[1];
	    	  break;
	      }
	  }
	  return msg;
  }

}