package q02a.exe.utils;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

import q02a.exe.arquitectura.valueobjects.Q02aValueObject;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.infraestructura.traza.Q70Traza;

/**
 * 
 * @author *
 *
 */
public class Q02aVoUtils {
	
		private static Q70Traza tr = Q70Traza.getSingleton();
		private static final String COMPONENTE = "CLASE_UTILIDAD";
		
        /**
         * 
         * @param vo vo
         * @return mapa
         * @throws Exception Exception
         */
		public static HashMap getHashMap( Q02aValueObject vo)throws Exception {
			HashMap mapa = new HashMap();			
			try{
				if (tr.isTraceActive()){
					tr.trace(COMPONENTE, Q70TraceLevel.INFO, "" + ":getHashMap: entrando:" + vo.toString());
				}   
				Method[] listaMetodos = Class.forName(vo.getClass().getName()).getMethods();
				for ( int i=0; i < listaMetodos.length ; i++){
					Method metodo = listaMetodos[i];
					String nomMetodo = metodo.getName();
					if ( nomMetodo.indexOf("get")!= -1 ){
						String nomCampoCapitalizado = nomMetodo.substring(3,4).toUpperCase() +  nomMetodo.substring(4);
						Class [] listaParametros = new Class[0];
						Object [] listaValores = new Object[0];						
						String nomCampoMinusculas = nomCampoCapitalizado.substring(0,1).toLowerCase() +  nomCampoCapitalizado.substring(1);
						mapa.put(nomCampoMinusculas, Class.forName(vo.getClass().getName()).getMethod("get" + nomCampoCapitalizado,listaParametros).invoke(vo,listaValores));
					}
				}				
				return mapa;
			}catch(Exception ex){
				java.io.StringWriter sw = new java.io.StringWriter();
		        java.io.PrintWriter pw = new java.io.PrintWriter(sw);
		        ex.printStackTrace(pw);
		        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "" + ":getHashMap: " + sw.getBuffer ().toString());
		        throw ex;      
			}finally{
				if (tr.isTraceActive()){
					tr.trace(COMPONENTE, Q70TraceLevel.INFO, "" + ":getHashMap: saliendo con:" + mapa.toString());
				}        		         
		    } 	
			
		}
		
		/**
         * 
         * @param mapa mapa
         * @param nombreVO nombreVO
         * @return vo
         * @throws Exception Exception
		 */
		public static Q02aValueObject getValueObject(  HashMap  mapa, String nombreVO )throws Exception {		
			Q02aValueObject vo = null;			
			try{
				if (tr.isTraceActive()){
					tr.trace(COMPONENTE, Q70TraceLevel.INFO, "" + ":getValueObject: entrando:" + mapa.toString());
				}   
				Set claves = mapa.keySet();
				Iterator itClaves = claves.iterator();
				while ( itClaves.hasNext()){
					
					String nombrePropiedad = (String) itClaves.next();
					String nombrePropiedadCapitalizado = nombrePropiedad.substring(0,1).toUpperCase() +  nombrePropiedad.substring(1);				
					
					Class [] listaParametros = new Class[1];
	    		    Object [] listaValores = new Object[1]; 
					
	    		    try{
						listaValores[0] = mapa.get(nombrePropiedad);
						listaParametros[0] = Class.forName(mapa.get(nombrePropiedad).getClass().getName());
									
	    		    
						if ( vo == null ){
							vo = (Q02aValueObject) Class.forName(nombreVO).newInstance();
						}
	    		    
	    		    	Class.forName(nombreVO).getMethod("set" + nombrePropiedadCapitalizado, listaParametros).invoke(vo, listaValores);
	    		    }catch(Exception ex){
	    		    	tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "" + ":getValueObject: Error mapeando la propiedad: " + nombrePropiedadCapitalizado);
	    		    }
				}			
				return vo; 
			}catch(Exception ex){
				java.io.StringWriter sw = new java.io.StringWriter();
		        java.io.PrintWriter pw = new java.io.PrintWriter(sw);
		        ex.printStackTrace(pw);
		        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "" + ":getValueObject: " + sw.getBuffer ().toString());
		        throw ex;      
			}finally{
				if (tr.isTraceActive()){
					tr.trace(COMPONENTE, Q70TraceLevel.INFO, "" + ":getValueObject: saliendo con:" + vo.toString());
				}        		         
		    } 			
		}
		
        /**
         * 
         * @param mapa mapa
         * @param nombreVO nombreVO
         * @param vo vo
         * @return vo
         * @throws Exception Exception
         */
		public static Q02aValueObject getValueObjectValueExists(  HashMap  mapa, String nombreVO, Q02aValueObject vo)throws Exception {					
			try{
				if (tr.isTraceActive()){
					tr.trace(COMPONENTE, Q70TraceLevel.INFO, "" + ":getValueObjectValueExists: entrando:" + mapa.toString());
				}   
				Set claves = mapa.keySet();
				Iterator itClaves = claves.iterator();
				while ( itClaves.hasNext()){
					
					String nombrePropiedad = (String) itClaves.next();
					String nombrePropiedadCapitalizado = nombrePropiedad.substring(0,1).toUpperCase() +  nombrePropiedad.substring(1);				
					
					Class [] listaParametros = new Class[1];
	    		    Object [] listaValores = new Object[1]; 
					
	    		    try{
						listaValores[0] 	= ((String) mapa.get(nombrePropiedad)).trim() ;
						listaParametros[0] 	= Class.forName(mapa.get(nombrePropiedad).getClass().getName());									    		    
	    		    	Class.forName(nombreVO).getMethod("set" + nombrePropiedadCapitalizado, listaParametros).invoke(vo, listaValores);
	    		    }catch(Exception ex){
	    		    	tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "" + ":getValueObjectValueExists: Error mapeando la propiedad: " + nombrePropiedadCapitalizado);
	    		    }
				}			
				return vo; 
			}catch(Exception ex){
				java.io.StringWriter sw = new java.io.StringWriter();
		        java.io.PrintWriter pw = new java.io.PrintWriter(sw);
		        ex.printStackTrace(pw);
		        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "" + ":getValueObjectValueExists: " + sw.getBuffer ().toString());
		        throw ex;      
			}finally{
				if (tr.isTraceActive()){
					tr.trace(COMPONENTE, Q70TraceLevel.INFO, "" + ":getValueObjectValueExists: saliendo con:" + vo.toString());
				}        		         
		    } 			
		}
		
		/**
         * 
         * @param mapa mapa
         * @param nombreVO nombreVO
         * @return vo
         * @throws Exception Exception
		 */
		public static Q02aValueObject getValueObjectWithException(  HashMap  mapa, String nombreVO )throws Exception {		
			Q02aValueObject vo = null;			
			
			if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, "" + ":getValueObject: entrando:" + mapa.toString());
			}   
			Set claves = mapa.keySet();
			Iterator itClaves = claves.iterator();
			while ( itClaves.hasNext()){
				try{	
					String nombrePropiedad = (String) itClaves.next();
					String nombrePropiedadCapitalizado = nombrePropiedad.substring(0,1).toUpperCase() +  nombrePropiedad.substring(1);				
					
					Class [] listaParametros = new Class[1];
	    		    Object [] listaValores = new Object[1]; 
					
					listaValores[0] = mapa.get(nombrePropiedad);
					listaParametros[0] = Class.forName(mapa.get(nombrePropiedad).getClass().getName());
									 		   
	    		    if ( vo == null ){
	    		    	vo = (Q02aValueObject) Class.forName(nombreVO).newInstance();
	    		    }
	    		    Class.forName(nombreVO).getMethod("set" + nombrePropiedadCapitalizado, listaParametros).invoke(vo, listaValores);	    		    
				}catch(Exception ex){
					java.io.StringWriter sw = new java.io.StringWriter();
			        java.io.PrintWriter pw = new java.io.PrintWriter(sw);
			        ex.printStackTrace(pw);
			        tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,  ":getValueObject: " + sw.getBuffer ().toString());

				}finally{
					if (tr.isTraceActive()){
						tr.trace(COMPONENTE, Q70TraceLevel.INFO, "" + ":getValueObject: saliendo con:" + vo.toString());
					}        		         
			    } 			

			}  // while			
		return vo; 
	}

}
