/*
 * Created on 10-ago-2004
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package q02a.exe.utils;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import java.sql.SQLException;

import q02a.exe.arquitectura.dataobjects.Q02aDataBaseDAO;

import q02a.exe.utils.Q02aConstantes;

/**
 * @author laura.cantero
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class Q02aSecuencesDataBaseDAO extends Q02aDataBaseDAO{
	
	private static final long serialVersionUID = -48975983475987L;
	
    /**
     * 
     *
     */
	public Q02aSecuencesDataBaseDAO() {
        super();                
    }

    /** Creates new Q02ECT01 
     * @param conn conn
     * */
    public Q02aSecuencesDataBaseDAO(Connection conn) {
    	super(conn);     
    }

    /**
     * 
     * @param secuenceName secuenceName
     * @return resul
     * @throws Exception Exception
     */
	public long getNextVal(String secuenceName)throws Exception {	 
        ResultSet 			rs 			= null;
        PreparedStatement 	prepStmt 	= null;
        try {
            // Creacin de la query
            StringBuffer sql = new StringBuffer();
            long resul=0;
            sql.append("SELECT ");
            sql.append(secuenceName);
            sql.append(".NEXTVAL from DUAL");
            prepStmt = this.getConnection().prepareStatement(sql.toString());
            rs = prepStmt.executeQuery();
            if ( rs.next() ) {
                resul= rs.getLong(1); 
            }else{
                throw new Exception("Error al recuperar secuencia en: " + secuenceName);
            }	  
            return resul;
        }catch(SQLException sqlException) {
             throw new Exception("Error al recuperar secuencia en: " + secuenceName);
        }finally {
            this.addResultSet(rs);
            this.addStatement(prepStmt);
            this.freeResourcesNotConnection();
        }
	}
	
	/**
     * Devuelve un nmero correlativo 
     * 
     * @param nomColumn - Nombre de la columna de la cual se obtiene el correlativo
     * @param nomTable  - Nombre de la tabla
     * @param datos		- Array donde cada posicin es de la forma: Campo,Valor,TipoDato(obtenido del Q02aConstantes.java)
     * 
     * @see Q02aConstantes.java
     * 
     * @return El nmero correlativo
     * 
     * @throws Exception Exception
     */
	public long getValorCorrelativo(String nomColumn, String nomTable, String[] datos) throws Exception {
		ResultSet 			rs 			= null;
        PreparedStatement 	prepStmt 	= null;
        long	 			resul		= 1;
        try {
            //Cadena de la select
        	StringBuffer sql 	   = new StringBuffer();
            StringBuffer sqlSelect = new StringBuffer();
            StringBuffer sqlWhere  = new StringBuffer(" WHERE (1=1) ");
            StringBuffer sqlGroup  = new StringBuffer();
            //Se crea la select de la query
            sqlSelect.append("SELECT MAX(").append(nomColumn).append(")+1 FROM ").append(nomTable);
	        //Se comprueba que el array tenga datos
            if(datos!=null){
            	//Se genera la parte where
	            for(int i=0;i<datos.length;i++){
	            	//La primera vez que se entra se incluye el  group by
	            	if(i==0){
	            		sqlGroup.append(" GROUP BY ");
	            	}
	            	//Se obtiene el valor de la forma Campo,Valor,Tipo
	            	String 		valores 	= datos[i];
	            	//Se realiza el split de los valores
	            	String[] 	valorSplit	= valores.split(",");
	            	//Se aade el valor de la columna para realizar el group by
	            	sqlGroup.append(valorSplit[0]);
	            	//En la ltima posicin no se aade una coma
	            	if(i!=(datos.length-1)){
	            		sqlGroup.append(",");
	            	}
	            	//Se aade a la where el campo de la columna
	            	sqlWhere.append(" AND ").append(valorSplit[0]);
	            	//En funcin del tipo de dato se aade una u otra opcin
	            	if(Q02aConstantes.CORRELATIVO_NUMERICO.equals(valorSplit[2])){
	            		sqlWhere.append(" = ").append(valorSplit[1]);
	            	} else if(Q02aConstantes.CORRELATIVO_VARCHAR.equals(valorSplit[2])){
	            		sqlWhere.append(" = '").append(valorSplit[1]).append("'");
	            	} else if(Q02aConstantes.CORRELATIVO_DATE.equals(valorSplit[2])){
	            		sqlWhere.append(" = to_date('").append(valorSplit[1]).append("','").append(Q02aConstantes.CORRELATIVO_PATRON_DATE).append("')");
	            	}
	            }       
	        }
            //Se crea la query
            sql.append(sqlSelect).append(sqlWhere).append(sqlGroup);
            prepStmt = this.getConnection().prepareStatement(sql.toString());
            rs = prepStmt.executeQuery();
            if ( rs.next() ) {
                resul= rs.getLong(1); 
                //Si el resultado es 0 quiere decir que no existe ningn registro 
                //por este motivo, te devuelve 1
                if(resul==0){
                	resul = 1;
                }
            } else{ 
            		resul = 1;
            }
            return resul;
        }catch(SQLException sqlException) {
             throw new Exception("Error en el mtodo getValorCorrelativo()");
        }finally {
            this.addResultSet(rs);
            this.addStatement(prepStmt);
            this.freeResourcesNotConnection();
        }
	}
	
	/**
     * Devuelve un nmero correlativo 
     * 
     * @param nomColumn - Nombre de la columna de la cual se obtiene el correlativo actual
     * @param nomTable  - Nombre de la tabla
     * @param datos		- Array donde cada posicin es de la forma: Campo,Valor,TipoDato(obtenido del Q02aConstantes.java)
     * 
     * @see Q02aConstantes.java
     * 
     * @return El nmero correlativo actual
     * 
     * @throws Exception Exception
     */
	public String getActualCorrelativo(String nomColumn, String nomTable, String[] datos) throws Exception {
		ResultSet 			rs 			= null;
        PreparedStatement 	prepStmt 	= null;
        String	 			resul		= "";
        try { 
            //Cadena de la select
        	StringBuffer sql 	   = new StringBuffer();
            StringBuffer sqlSelect = new StringBuffer();
            StringBuffer sqlWhere  = new StringBuffer(" WHERE (1=1) ");
            StringBuffer sqlGroup  = new StringBuffer();
            //Se crea la select de la query
            sqlSelect.append("SELECT MAX(").append(nomColumn).append(") FROM ").append(nomTable);
	        //Se comprueba que el array tenga datos
            if(datos!=null){
            	//Se genera la parte where
	            for(int i=0;i<datos.length;i++){
	            	//La primera vez que se entra se incluye el  group by
	            	if(i==0){
	            		sqlGroup.append(" GROUP BY ");
	            	}
	            	//Se obtiene el valor de la forma Campo,Valor,Tipo
	            	String 		valores 	= datos[i];
	            	//Se realiza el split de los valores
	            	String[] 	valorSplit	= valores.split(",");
	            	//Se aade el valor de la columna para realizar el group by
	            	sqlGroup.append(valorSplit[0]);
	            	//En la ltima posicin no se aade una coma
	            	if(i!=(datos.length-1)){
	            		sqlGroup.append(",");
	            	}
	            	//Se aade a la where el campo de la columna
	            	sqlWhere.append(" AND ").append(valorSplit[0]);
	            	//En funcin del tipo de dato se aade una u otra opcin
	            	if(Q02aConstantes.CORRELATIVO_NUMERICO.equals(valorSplit[2])){
	            		sqlWhere.append(" = ").append(valorSplit[1]);
	            	} else if(Q02aConstantes.CORRELATIVO_VARCHAR.equals(valorSplit[2])){
	            		sqlWhere.append(" = '").append(valorSplit[1]).append("'");
	            	} else if(Q02aConstantes.CORRELATIVO_DATE.equals(valorSplit[2])){
	            		sqlWhere.append(" = to_date('").append(valorSplit[1]).append("','").append(Q02aConstantes.CORRELATIVO_PATRON_DATE).append("')");
	            	}
	            }       
	        }
            //Se crea la query
            sql.append(sqlSelect).append(sqlWhere).append(sqlGroup);
            prepStmt = this.getConnection().prepareStatement(sql.toString());
            rs = prepStmt.executeQuery();
            if ( rs.next() ) {
                resul= rs.getString(1); 
                //Si el resultado es 0 quiere decir que no existe ningn registro 
                //por este motivo, te devuelve 1
                if(resul.equals("")){
                	resul = "";
                }
            } else{ 
            		resul = "";
            }
            return resul;
        }catch(SQLException sqlException) {
             throw new Exception("Error en el mtodo getCorrelativoActual()");
        }finally {
            this.addResultSet(rs);
            this.addStatement(prepStmt);
            this.freeResourcesNotConnection();
        }
	}
}
