package q02a.exe.utils;

import java.util.HashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

/**
 * 
 * @author GADIMAAR
 *
 */
public class Q02aRestriccionesUtils {

    /**
     * Mtodo estatico que carga valores de las restricciones encadenadas 
     * en el HashMap de restricciones 
     * 
     * @param  hashRestricciones de Harraylist de forma  {niE1=[niE1C1, ..., niE1C2], niE2=[niE2C1, ..., niE2C2] }
     * @return  String cadenaRestricciones de forma  niE1, niE1C1, ..., niE1C2 ; niE2 ,  niE2C1, ..., niE2C2 
     * 
     * ejemplo : 
     * cadena	2,5,6;1,3,4; 
     * hashmap  {2=[5, 6], 1=[3, 4]}  
     *  
     */
	
	 public static String getCadenaRestricciones (HashMap hashRestricciones ) { 
	 
			Set claves = hashRestricciones.keySet();
			Iterator itClaves = claves.iterator();
			String cadenaRestricciones = "" ; 
			
			while ( itClaves.hasNext()){
					String niEntidad = (String) itClaves.next() ; 
					cadenaRestricciones += niEntidad;
					
					ArrayList listaCentros = (ArrayList) hashRestricciones.get(niEntidad) ; 
		
					for (int i  = 0 ; i < listaCentros.size()  ; i++  ){
						cadenaRestricciones += "," + listaCentros.get(i); 
					}
		
					cadenaRestricciones += ";" ; 	
			} 
			
			return cadenaRestricciones; 
	}
	
	    /**
	     * Mtodo estatico que carga valores de las restricciones encadenadas 
	     * en el HashMap de restricciones 
	     * 
	     * @param cadenaRestricciones String cadenaRestricciones de forma  niE1, niE1C1, ..., niE1C2 ; niE2 ,  niE2C1, ..., niE2C2 
	     * @return HashMap de Harraylist de forma  {niE1=[niE1C1, ..., niE1C2], niE2=[niE2C1, ..., niE2C2] }
	     * 
	     * ejemplo : 
	     * cadena	2,5,6;1,3,4; 
	     * hashmap  {2=[5, 6], 1=[3, 4]}  
	     *  
	     */
	 public static HashMap getMapaRestricciones(String cadenaRestricciones){
	    	
	    	HashMap hash = new HashMap () ; 
	    	if (Q02aFormatData.esVacio(cadenaRestricciones) ){
	    		return null ; 
            }
            
	    	// Separador de entidades 
			String[] cadenaREC =    cadenaRestricciones.split(";"); 
			for (int i = 0 ; i< cadenaREC.length  ; i++  ){
				ArrayList listaCentros = new ArrayList() ; 
				
		    	// Separador de centros 
				String[] cadenaRC = cadenaREC[i].split(","); 
				
				// no nos interesa el primero siendo el NI de la entidad 
				for (int j=1 ; j < cadenaRC.length  ; j++  ){
					listaCentros.add(j-1,cadenaRC[j]);
				}
				
				hash.put( cadenaRC[0] , listaCentros )  ;
			}
	    	return hash; 	
	    }
	 
}
