package q02a.exe.utils;

import java.sql.ResultSet;
import java.sql.Connection;
import java.sql.PreparedStatement;

import q02a.exe.arquitectura.dataobjects.Q02aDAOException;
import es.ejie.frmk.conectores.conectorJDBC.Q70ConectorJDBC;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.infraestructura.traza.Q70Traza;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;

/**
 * Clase que obtiene el nmero interno de un elemento a partir de si cdigo
 * 
 * @author leire.uriarte
 * @author Javier.cruz
 *
 */

public class Q02aNILocator{
	 protected static final String COMPONENTE = "NILOCATOR";
	 private static Q70Traza tr = Q70Traza.getSingleton();
	 protected static String Q02_JNDI_DATASOURCE = Q70ListenerUtils.getApplicationProperty("Q02aNILocator",null,"Q02_JNDI_DATASOURCE");
   
    /**
     *  Constructor vaco
     */
    public Q02aNILocator() {
        super();
    }
    /**
     * 
     * @param id id
     * @param claveCodigo claveCodigo
     * @param esClave esClave
     * @return Q02aDAOException 
     * @throws Q02aDAOException Q02aDAOException
     */
    public static String getNI(String id, String claveCodigo, boolean esClave) throws Q02aDAOException {
    	
        // recuperamos la vista del TT sobre la que realizaremos las consultas
    	String tabla = Q02aConstantes.getString("TT_TABLA");
    	//recuperamos el identificador de la tabla de la que queremos recurerar el ni
    	String idTabla = Q02aConstantes.getString(id);
    	// Si esClave es verdadero entonces recuperamos el valor del properties
    	String codigo = claveCodigo;
    	if (esClave){
    		codigo = Q02aConstantes.getString(claveCodigo);
    	}
    	//se definen las columnas que corresponde con el ni y el codigo
    	String colSelect = Q02aConstantes.getString("TT_COLUM_NI");
    	String colWhere = Q02aConstantes.getString("TT_COLUM_COD");
    	
    	//se define el ni retorno
    	String niRetorno = null;
    	try
    	{
    		if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, "Q02aNILocator :getNI: entrando.");
	   		}
    		niRetorno = getNIGenerico(tabla,idTabla,colWhere, colSelect, codigo,true);
    		return niRetorno;    	
    	}catch (Exception ex) {    		
    		java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Q02aNILocator::getNI Error. " + sw.getBuffer ().toString());
                }			    		
    		throw new Q02aDAOException(ex);
    	}
    	finally
    	{
    		if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, "Q02aNILocator:getNI: saliendo.");
	   		}
    	}
    	
    }
    
    /**
     * Mtodo que dado el id y el codigo de una tabla de tablas devolvera el ni
     * @param id id
     * @param claveCodigo claveCodigo
     * @return getNI
     * @throws Q02aDAOException Q02aDAOException
     */
    public static String getNI(String id, String claveCodigo) throws Q02aDAOException {
    	try{
    		if (tr.isTraceActive()){
    			tr.trace(COMPONENTE, Q70TraceLevel.INFO, "Q02aNILocator :getNI: entrando.");
    		}
    		return getNI(id,claveCodigo,true);
   		}catch(Exception ex) {  
   			java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Q02aNILocator::getNI Error. " + sw.getBuffer ().toString());
            }			    		
    		throw new Q02aDAOException(ex);
   		}finally{
    		if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, "Q02aNILocator:getNI: saliendo.");
	   		}
    	}
    	
    	
    }
     
    /**
     * Mtodo que dado el id y el codigo de una tabla de tablas devolvera el ni
     * @param id id
     * @param claveCodigo claveCodigo
     * @param connection connection
     * 
     * @return getNIWithConnection
     * @throws Q02aDAOException Q02aDAOException
     */
    public static String getNIWithConnection(String id, String claveCodigo, Connection connection) throws Q02aDAOException {
    	try{
    		if (tr.isTraceActive()){
    			tr.trace(COMPONENTE, Q70TraceLevel.INFO, "Q02aNILocator :getNIWithConnection: entrando.");
    		}
    		return getNIWithConnection(id,claveCodigo,true,connection);
   		}catch(Exception ex) {  
   			java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Q02aNILocator::getNIWithConnection Error. " + sw.getBuffer ().toString());
            }			    		
    		throw new Q02aDAOException(ex);
   		}finally{
    		if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, "Q02aNILocator:getNIWithConnection: saliendo.");
	   		}
    	}    		
    }
    
    /**
     * 
     * @param id id
     * @param claveCodigo claveCodigo
     * @param esClave esClave
     * @param connection connection
     * @return niRetorno
     * @throws Q02aDAOException Q02aDAOException
     */
    public static String getNIWithConnection(String id, String claveCodigo, boolean esClave, Connection connection) 
    throws Q02aDAOException {
    	
        // recuperamos la vista del TT sobre la que realizaremos las consultas
    	String tabla = Q02aConstantes.getString("TT_TABLA");
    	//recuperamos el identificador de la tabla de la que queremos recurerar el ni
    	String idTabla = Q02aConstantes.getString(id);
    	// Si esClave es verdadero entonces recuperamos el valor del properties
    	String codigo = claveCodigo;
    	if (esClave){
    		codigo = Q02aConstantes.getString(claveCodigo);
    	}
    	//se definen las columnas que corresponde con el ni y el codigo
    	String colSelect = Q02aConstantes.getString("TT_COLUM_NI");
    	String colWhere = Q02aConstantes.getString("TT_COLUM_COD");
    	
    	//se define el ni retorno
    	String niRetorno = null;
    	try
    	{
    		if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, "Q02aNILocator :getNIWithConnection: entrando.");
	   		}
    		niRetorno = getNIGenericoWithConnection(tabla,idTabla,colWhere, colSelect, codigo,true,connection);
    		return niRetorno;    	
    	}catch (Exception ex) {    		
    		java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Q02aNILocator::getNIWithConnection Error. " + sw.getBuffer ().toString());
                }			    		
    		throw new Q02aDAOException(ex);
    	}
    	finally
    	{
    		if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, "Q02aNILocator:getNIWithConnection: saliendo.");
	   		}
    	}
    	
    }
    
    /**
     * Mtodo que recuperara el ni de tabla de tablas pasados los parametros adecuados.
     * @param tabla tabla
     * @param idTabla idTabla
     * @param colWhere colWhere
     * @param colSelect colSelect
     * @param codigo codigo
     * @param tablaDeTablas si es true indica que el ni a recuperar es de tabla de tablas, false en caso contrario
     * @param connection connection
     * 
     * @return ni
     * @throws Q02aDAOException Q02aDAOException
     */
    public static String getNIGenericoWithConnection(String tabla, String idTabla,String colWhere,String colSelect,String codigo,boolean tablaDeTablas, Connection connection) throws Q02aDAOException {    	
    	
    	//se recupera la descripcion de la columna en la que se difinen la diferentes tablas
    	String colId = "";
    	if (tablaDeTablas){
    		colId = Q02aConstantes.getString("TT_COLUM_ID");
    	}
    	//objetos necesarios para la consulta
		StringBuffer selectStatement = null;
	    PreparedStatement prepStmt = null;
	    ResultSet rs = null;
	    String ni = null;
	    
	    try {	
	    	if(tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, "Q02aNILocator::getNIGenericoWithConnection beginning.");
	    	}
	    	selectStatement = new StringBuffer( "SELECT ").append(colSelect);
	    	selectStatement.append(" FROM ").append(tabla);
			selectStatement.append(" WHERE trim(").append(colWhere).append(") = ?");
			if (tablaDeTablas){
				selectStatement.append(" AND trim(").append(colId).append(") = ? ");
			}
	    	prepStmt = connection.prepareStatement(selectStatement.toString());
	    	//se carga el parametro del cdigo del que se busca el ni correspondiente
	    	try{
	    		prepStmt.setInt(1,Integer.parseInt(codigo));
	    	}catch(Exception e){
	    		//si el codigo esta entre comillas se eliminaran estas comillas	    		
	    		if (codigo.startsWith("'")&& codigo.endsWith("'"))
	    		{
	    			//se eliminan las comillas
	    			codigo = codigo.substring(1,(codigo.length()-1));
	    		}
	    		prepStmt.setString(1,codigo);	
	    	}
	    	if (tablaDeTablas){
	    		//se carga el parametro de identificador de tabla
	    		try{
	    			prepStmt.setInt(2,Integer.parseInt(idTabla));
	    		}catch(Exception e){
	    			prepStmt.setString(2,idTabla);	
	    		}
	    	}
	    	rs = prepStmt.executeQuery();
	    	
	    	if (rs.next()){
            	ni = rs.getString(colSelect);
            }
	    	if(tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, "Q02aNILocator::getNIGenericoWithConnection ending.");
	    	}			
			if(ni!=null && !ni.equals("") && !ni.equals("")) {
	            return ni;
			}else{
				if(tr.isTraceActive()){
					tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, "::getNIGenericoWithConnection error :: " + tabla + " :: " + colWhere + " :: " + colSelect + " :: " + codigo);
		    	}							
	            return ni;
			}

    }catch (Exception ex) {    	
    	if(tr.isTraceActive()){
    		java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Q02aNILocator::getNIGenericoWithConnection Error. " + sw.getBuffer ().toString());
                }			
    	}		
		throw new Q02aDAOException(ex);
    } finally {        
	    	try{//se liberan todos los recursos
	    		if (rs!=null){rs.close();}
	    		if (prepStmt!=null){prepStmt.close(); }  		
	    	}catch (Exception ex) {   
	    		java.io.StringWriter sw = new java.io.StringWriter();
	            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	            ex.printStackTrace(pw);
	            if (tr.isTraceActive()){
	            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Q02aNILocator::getNIGenericoWithConnection Error cerrando. " + sw.getBuffer ().toString());
	            }
	            throw new Q02aDAOException(ex);
	        } 
	    	if(tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, "Q02aNILocator::getNIGenericoWithConnection saliendo.");
	    	}
    	}
    }
    
    /**
     * Mtodo que recuperara el ni de tabla de tablas pasados los parametros adecuados.
     * @param tabla tabla
     * @param idTabla idTabla
     * @param colWhere colWhere
     * @param colSelect colSelect
     * @param codigo codigo
     * @param tablaDeTablas si es true indica que el ni a recuperar es de tabla de tablas, false en caso contrario
     * 
     * @return ni
     * @throws Q02aDAOException Q02aDAOException
     */
    public static String getNIGenerico(String tabla, String idTabla,String colWhere,String colSelect,String codigo,boolean tablaDeTablas) throws Q02aDAOException {    	
    	
    	//se recupera la descripcion de la columna en la que se difinen la diferentes tablas
    	String colId = "";
    	if (tablaDeTablas){
    		colId = Q02aConstantes.getString("TT_COLUM_ID");
    	}
    	//objetos necesarios para la consulta
		StringBuffer selectStatement = null;
	    PreparedStatement prepStmt = null;
	    ResultSet rs = null;
	    Connection connection = null;
	    String ni = null;
	    
	    try {	
	    	if(tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, "Q02aNILocator::getNIGenerico beginning.");
	    	}
	    	//connection = Q02aDatabaseConnectionLocator.getConnection();
	    	connection = Q70ConectorJDBC.getSingleton().getConnection(Q02_JNDI_DATASOURCE);
	    	selectStatement = new StringBuffer( "SELECT ").append(colSelect);
	    	selectStatement.append(" FROM ").append(tabla);
			selectStatement.append(" WHERE trim(").append(colWhere).append(") = ?");
			if (tablaDeTablas){
				selectStatement.append(" AND trim(").append(colId).append(") = ? ");
			}
	    	prepStmt = connection.prepareStatement(selectStatement.toString());
	    	//se carga el parametro del cdigo del que se busca el ni correspondiente
	    	try{
	    		prepStmt.setInt(1,Integer.parseInt(codigo));
	    	}catch(Exception e){
	    		//si el codigo esta entre comillas se eliminaran estas comillas	    		
	    		if (codigo.startsWith("'")&& codigo.endsWith("'"))
	    		{
	    			//se eliminan las comillas
	    			codigo = codigo.substring(1,(codigo.length()-1));
	    		}
	    		prepStmt.setString(1,codigo);	
	    	}
	    	if (tablaDeTablas){
	    		//se carga el parametro de identificador de tabla
	    		try{
	    			prepStmt.setInt(2,Integer.parseInt(idTabla));
	    		}catch(Exception e){
	    			prepStmt.setString(2,idTabla);	
	    		}
	    	}
	    	rs = prepStmt.executeQuery();
	    	
	    	if (rs.next()){
            	ni = rs.getString(colSelect);
            }
	    	if(tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, "Q02aNILocator::getNIGenerico ending.");
	    	}			
			if(ni!=null && !ni.equals("") && !ni.equals("")) {
	            return ni;
			}else{
				if(tr.isTraceActive()){
					tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, "::getNIGenerico error :: " + tabla + " :: " + colWhere + " :: " + colSelect + " :: " + codigo);
		    	}							
	            return ni;
			}

    }catch (Exception ex) {    	
    	if(tr.isTraceActive()){
    		java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Q02aNILocator::getNIGenerico Error. " + sw.getBuffer ().toString());
                }			
    	}		
		throw new Q02aDAOException(ex);
    } finally {        
    	try{//se liberan todos los recursos
    		if (rs!=null){rs.close();}
    		if (prepStmt!=null){prepStmt.close();}
    		if (connection!=null){connection.close();}    		
    	}catch (Exception ex) {   
    		java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            if (tr.isTraceActive()){
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Q02aNILocator::getNIGenerico Error cerrando. " + sw.getBuffer ().toString());
            }
            throw new Q02aDAOException(ex);
        } 
    	if(tr.isTraceActive()){
			tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, "Q02aNILocator::getNIGenerico saliendo.");
    	}
    }
    }
}
