/*
 * Copyright 2001 by IENET, Inc.
 *
 * Private and Confidential
 * Code contained in this document is the property of IENET.
 * It is for the exclusive use of designated employees
 * and not for distribution without prior written
 * authorization.
 */
/*
 * DataBaseDAO.java
 *
 * Created on 31 de mayo de 2001, 10:21
 */

package q02a.exe.test;


// Java classes import
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

import q02a.exe.arquitectura.dataobjects.Q02aBaseDAO;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
/**
 *
 * Un Data Access Object encargado de obtener objetos de una base de datos. Contiene un objeto connection <b>que no es 
 * serializable</b> y por tanto, se ha definido como transient.<p>
 * Debido a esto, el objeto connection se pierde al serializar este objeto ( lo cual no debera ser un problema, 
 * ya que la conexin debera de cerrarse entre jsps.
 * <p>
 * Implementa el interface OperacionesLoggable, por lo tanto, es susceptible de escribir en el log de operaciones.
 * @author  Antonio.Vieiro
 * @version 2.0
 */
public abstract class Q02aDataBaseDAOTest extends Q02aBaseDAO {
    
    protected java.util.ArrayList resultSets = new java.util.ArrayList();
    protected java.util.ArrayList statements = new java.util.ArrayList();
    protected static final String COMPONENTE = "DAO_ACCESO_DATOS";
    protected static Traza tr = new Traza();
    /** La conexin a BBDD que utilizar este DAO. No se serializa. */
    protected transient Connection connection;
    
  
    /** Crea un DAO que se utilizar para la obtencin de informacin
     *  de una base de datos.
     *  Este DAO <B>NO</B> cerrar nunca la conexin.
     *  @param connection La conexin a la base de datos a utilizar.
     */
    public Q02aDataBaseDAOTest(Connection connection) {
        this.connection = connection;
    }

    /**
     * Constructor vaco utilizado por BaseDAO
     */
    public Q02aDataBaseDAOTest() {
    }
    
    /** Devuelve la conexin que utilizar este DAO.
     *  @return La conexin a BBDD que utiliza este DAO.
     */
    protected Connection getConnection() {
        return this.connection;
    }
    
    /**
     * 
     * @param connection connection
     */
    public void setConnection(Connection connection) {
    	this.connection = connection;
    }
    /** Cierra un ResultSet si se puede cerrar.
     *  @param resultSet El ResultSet a cerrar.
     */
    protected void freeResource( ResultSet resultSet ) {
        if ( resultSet != null ) {
            try {
                resultSet.close();
            }catch( java.sql.SQLException sqlE ) {
            	 if (tr.isTraceActive()){
                     tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + "DataBaseDAO  Failed: " + sqlE.getMessage() + ". freeResource.");
                 }               
            }
        }
    }
    /** Cierra un Statement si se puede cerrar.
     *  @param statement El Statement a cerrar.
     */
    protected void freeResource(java.sql.Statement statement) {
        if ( statement != null ) {
            try {
                statement.close();
            }
            catch( java.sql.SQLException sqlE ) {
                if (tr.isTraceActive()){
                    tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + "DataBaseDAO  Failed: " + sqlE.getMessage() + ". freeResource");
                }         
            }
        }
    }
    
    /** Cierra una conexin si se puede cerrar.
     * @param con  Conexin a cerrar
     */
    protected void freeResource( Connection con ) {
        if ( con != null ) {
            try {
               if (!con.isClosed()) {
                   con.close();
               }
            }
            catch( java.sql.SQLException sqlE ) {
            	if (tr.isTraceActive()){
                    tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + "DataBaseDAO  Failed: " + sqlE.getMessage() + ". freeResource");
                }                    
            }
        }
    }
    
    /** Mtodo de utilidad para convertir un String a un nmero.
     * @return El nmero cuya representacin se encuentra en texto o
     * el valor por defecto si la representacin es null.
     * @param text text
     * @param defecto Valor por defecto del nmero. Si el texto es null
     *        entonces se tomar este valor por defecto. */
    protected static final int str2int( String text, int defecto ) {
        try {
            return text == null ? defecto : Integer.parseInt(text.trim() );
        }
        catch( NumberFormatException nfe ) {
            return defecto;
        }
    }
    
    /** Devuelve true si el texto contiene la cadena "SI" en maysculas o
     * minsculas. False en caso contrario.
     * @return true si el texto contiene la palabra "SI", "Si", "sI" o "si",
     * false en caso contrario.
     * @param text  */
    protected static final boolean isSI( String text ) {
        return text != null && text.equalsIgnoreCase("SI");
    }
    
    /**
     * Se encarga de cerrar la conexin, llamando a freeResource(conexion), los resultset y los statements
     */
    public void freeResources(){
        
        java.sql.Statement st=null;
        for (int i = 0;i < statements.size();i ++ ) {
            try{
                st = (Statement)statements.get(i);
                freeResource(st);
            }catch(Exception ex){}
        }
        
        statements.clear();
        
        
        ResultSet rs=null;
        for (int i = 0;i < resultSets.size();i ++ ) {
            try{
                rs = (ResultSet)resultSets.get(i);
                freeResource(rs);
            }catch(Exception ex){}
        }
        
        resultSets.clear();
        
        
        freeResource(connection);
    }
    
    
     /**
     * Se encarga de cerrar la conexin, llamando a freeResource(conexion), los resultset y los statements
     */
    public void freeResourcesNotConnection(){
        
        java.sql.Statement st=null;
        for (int i = 0;i < statements.size();i ++ ) {
            try{
                st = (Statement)statements.get(i);
                freeResource(st);
            }catch(Exception ex){}
        }
        
        statements.clear();
        
        
        ResultSet rs=null;
        for (int i = 0;i < resultSets.size();i ++ ) {
            try{
                rs = (ResultSet)resultSets.get(i);
                freeResource(rs);
            }catch(Exception ex){}
        }
        
        resultSets.clear();
       }
    
    /**
     * Aade un ResultSet a la lista de resultSets. 
     *@param rs   rs
     */
    public void addResultSet(ResultSet rs) {
        resultSets.add(rs);
    }
    
    /**
     * Borra un ResultSet de la lista de resultSets
     * @param rs ResultSet a borrar
     */
    public void removeResultSet(ResultSet rs) {
        resultSets.remove(rs);
    }
    
    /**
     * Aade un Statement a la lista de Statements. 
     *@param st st  
     */
    public void addStatement(Statement st) {
        statements.add(st);
    }
    
    /**
     * Borra un Statement de la lista de Statements
     * @param st Statements a borrar
     */
    public void removeStatement(Statement st) {
        statements.remove(st);
    }
    
    
}
