/*
* Copyright 2009 by GRUPO IE, Inc.
* 
* Private and Confidential
* Code contained in this document is the property of GRUPO IE. 
* It is for the exclusive use of designated employees 
* and not for distribution without prior written
* authorization.
*/
/*
* Q02aQ022ET00.java
*
* Created on 13/08/09 01:18:59
*/

package q02a.exe.tablasBD.jdbc.oracle;

import java.sql.SQLException;
import java.sql.ResultSet;
import java.sql.Connection;
import java.sql.PreparedStatement;
import q02a.exe.arquitectura.dataobjects.Q02aDAOException;
import q02a.exe.arquitectura.utils.tablasBD.*;
import q02a.exe.arquitectura.utils.tablasBD.helpers.*;
import javax.naming.NamingException;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.infraestructura.traza.Q70Traza;
import es.ejie.frmk.conectores.conectorJDBC.Q70ConectorJDBC;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;

/**
*
* @author automatic generated
* @version 1.0
*/

public class Q02aTablaBDQ022ES00 extends q02a.exe.tablasBD.Q02aTablaBDQ022ES00 {

    private static final long serialVersionUID =1L;

    /** Obtenemos una referencia del componente gestor de trazas de Geremua */
    private static Q70Traza tr = Q70Traza.getSingleton();

    /** Obtenemos el nombre del DataSource de nuestra aplicacin */
    private String Q02A_JNDI_DATASOURCE = Q70ListenerUtils.getApplicationProperty(this.getClass().getName(),null,"Q02A_JNDI_DATASOURCE");

    /** Nombre del componente */
    private String COMPONENTE = "TABLAS_BD";

    /** Creates new Q022ES00 */
    /** Est declarado como private para que se utilice el constructor con argumentos */

    private Q02aTablaBDQ022ES00() {
        super();
        this.idConexion="oracle";
    }



    /** Creates new Q022ES00 
     * @param con con
     * */

    public Q02aTablaBDQ022ES00(Connection con) {
        this();
        connection=con;
    }

    /** Method select(where) 
    * @param where New value of property WHERE.
    * @return Value of the resultSet.
    * @throws SQLException SQLException
    * @throws Q02aDAOException Q02aDAOException
    */

    public ResultSet select(String where)throws SQLException,Q02aDAOException  {

        Connection con=null;

        String[] aliasNom={"A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"};

        con=this.getConnection();

        StringBuffer query = new StringBuffer();

        ResultSet rs = null;

        String name = (this.getClass()).getName();

        StringBuffer mensaje = new StringBuffer();

        long user = 0;

        if (tr.isTraceActive()) {
            mensaje.append(name);
            mensaje.append(" Beginning:");
            mensaje.append(" select ");
            tr.trace(COMPONENTE,Q70TraceLevel.DEBUG,mensaje.toString());
        }

        String tablesdb2 = this.getTableFrom();

        String[] artablesdb2 = q02a.exe.arquitectura.webCommon.utils.Q02aCommonUtils.split(tablesdb2,",");

        String columnsdb2= this.getColumnsSelectTotal();

        StringBuffer text2Buf = new StringBuffer();

        for (int i=0;i<artablesdb2.length ;i++ ) {
        	String tableReplace = artablesdb2[i];
        	if (tableReplace.indexOf(" ")!=-1)
        	{
        		tableReplace=tableReplace.substring(0,tableReplace.indexOf(" "));
        	}

        	text2Buf.append(tableReplace).append(".");

            StringBuffer aliasNomBuff = new StringBuffer();
            aliasNomBuff.append( aliasNom[i] ).append(".");
            columnsdb2=q02a.exe.arquitectura.webCommon.utils.Q02aCommonUtils.replaceAll(columnsdb2,text2Buf.toString(),aliasNomBuff.toString());
            
        	if (i==0)   	{
        		tablesdb2 = artablesdb2[i]+ " " + aliasNom[i];
        	}else{
        		tablesdb2 = tablesdb2 + "," + artablesdb2[i] + " " + aliasNom[i];
        	}
        }

        query.append("SELECT ");
        query.append(columnsdb2);
        query.append(" from " ).append( tablesdb2);

        if ((this.getInitialWhere() != null) && (!this.getInitialWhere().equals(""))) {
             query.append( this.getInitialWhere());
             queryLog.append( this.getInitialWhere());
        }

        if ((this.getFixedWhere() != null) && (!this.getFixedWhere().equals(""))) {
             query.append( this.getFixedWhere());
             queryLog.append( this.getFixedWhere());
        }

        if ((where != null) && (!where.equals(""))) {
            if ((this.getInitialWhere() == null || this.getInitialWhere().equals("")) && (this.getFixedWhere() == null || this.getFixedWhere().equals("")) )
            {
                query.append(" where ");
            }else{
                query.append(" and ");
            }
            query.append( where );
        }

        if ((where.indexOf("group by")==-1) &&(where.indexOf("GROUP BY")==-1)){

            if ((this.getGroupBy() != null) && (!this.getGroupBy().equals(""))) {
                query.append(" GROUP BY ");
                query.append( this.getGroupBy());
            }
        }

        if ((where.indexOf("order by")==-1) &&(where.indexOf("ORDER BY")==-1)){

        if ((this.getOrderBy() != null) && (!this.getOrderBy().equals("")) && (!this.getOrderBy().equals("null"))) {

            query.append(" ORDER BY ");

            query.append( this.getOrderBy());

        }

        }

        if (this.getNumMaxRegistros()>0){
           if (this.getLimitRows()){
                this.setLimitRows(false);
                this.setNumInicio(0);
                this.setNumFinal(this.getNumMaxRegistros());
           }

            StringBuffer queryAux = new StringBuffer(query.toString());

            queryAux.insert(0," (");
            queryAux.append(") ");
            queryAux.append(") ");

                 if (this.getNumMaxRegistros()>0){
                     queryAux.insert(0," FROM ");
                 }
                 if (this.getNumMaxRegistros()>0){
                     queryAux.insert(0," ,rownum num ");
                 }
            queryAux.insert(0,this.getColumnsSelectComitas());

            queryAux.insert(0,"SELECT ");
            queryAux.insert(0," (");
            queryAux.insert(0," FROM ");
            queryAux.insert(0,this.getColumnsSelectComitas());
            queryAux.insert(0,"SELECT ");
            queryAux.append(" WHERE NUM>");
            queryAux.append(this.getNumInicio());
            queryAux.append(" AND NUM<=");
            queryAux.append(this.getNumFinal());
            query = queryAux;
        }

            if (this.getForUpdate()==true){
            	query.append(" FOR UPDATE ");
            }
            String queryAux=query.toString();

            for (int i=0;i<artablesdb2.length ;i++ )
            {
            	String tableReplace = artablesdb2[i];
            	if (tableReplace.indexOf(" ")!=-1)
            	{
            		tableReplace=tableReplace.substring(0,tableReplace.indexOf(" "));
            	}
            	String aux1=tableReplace+".";
            	String aux2=aliasNom[i]+".";
            	queryAux=q02a.exe.arquitectura.webCommon.utils.Q02aCommonUtils.replaceAll(queryAux,aux1,aux2);
            }
            query = new StringBuffer(queryAux);

            tr.trace(COMPONENTE,Q70TraceLevel.INFO,"0:" + query.toString());

        PreparedStatement prepStmt = con.prepareStatement(query.toString());
        Q02aSpacePreparedStatement spaPrepStmt = new Q02aSpacePreparedStatement(tipos,longitudes,prepStmt);
        addStatement(prepStmt);

        rs = spaPrepStmt.executeQuery();
        addResultSet(rs);

        if (tr.isTraceActive()) {
            mensaje.append(name);
            mensaje.append(" Ending:");
            mensaje.append(" select");
            tr.trace(COMPONENTE,Q70TraceLevel.DEBUG,mensaje.toString());
        }
        return rs;
    }



    /** Method selectCount(where) 
    * @param where New value of property WHERE.
    * @return Value of the resultSet.
    * @throws SQLException SQLException
    */

    public ResultSet selectCount(String where)throws SQLException  {

        String[] aliasNom={"A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"};

        Connection con=this.getConnection();

        StringBuffer query = new StringBuffer();

        ResultSet rs = null;

        String name = (this.getClass()).getName();

        StringBuffer mensaje = new StringBuffer();

        long user = 0;

        if (tr.isTraceActive()) {
            mensaje.append(name);
            mensaje.append(" Beginning:");
            mensaje.append(" selectCount ");
            tr.trace(COMPONENTE,Q70TraceLevel.DEBUG,mensaje.toString());
        }

        String tablesdb2 = this.getTableFrom();

        String[] artablesdb2 = q02a.exe.arquitectura.webCommon.utils.Q02aCommonUtils.split(tablesdb2,",");

        String columnsdb2= this.getColumnsSelectTotal();

        StringBuffer text2Buf = new StringBuffer();

        for (int i=0;i<artablesdb2.length ;i++ )
        {
        	String tableReplace = artablesdb2[i];
        	if (tableReplace.indexOf(" ")!=-1)
        	{
        		tableReplace=tableReplace.substring(0,tableReplace.indexOf(" "));
        	}
        	text2Buf.append(tableReplace).append(".");

            StringBuffer aliasNomBuff = new StringBuffer();
            aliasNomBuff.append( aliasNom[i] ).append(".");
            columnsdb2=q02a.exe.arquitectura.webCommon.utils.Q02aCommonUtils.replaceAll(columnsdb2,text2Buf.toString(),aliasNomBuff.toString());
            
        	if (i==0)
        	{
        		tablesdb2 = artablesdb2[i]+ " " + aliasNom[i];
        	}else{
        		tablesdb2 = tablesdb2 + "," + artablesdb2[i] + " " + aliasNom[i];
        	}

       	}

        query.append("SELECT COUNT(");

        if  ((this.getDistinct()!=null) && (!this.getDistinct().equals(""))) {
             query.append("DISTINCT (").append(this.getDistinct()).append(")");
        }else {
              query.append("*");
        }

        query.append(") from " ).append( tablesdb2);

        if ((this.getInitialWhere() != null) && (!this.getInitialWhere().equals(""))) {
             query.append( this.getInitialWhere());
             queryLog.append( this.getInitialWhere());
        }

        if ((this.getFixedWhere() != null) && (!this.getFixedWhere().equals(""))) {
             query.append( this.getFixedWhere());
             queryLog.append( this.getFixedWhere());
        }

        if ((where != null) && (!where.equals(""))) {

        if (where.indexOf("order by")!=-1) {
            where= where.substring(0,where.indexOf("order by"));
        }
        if (where.indexOf("ORDER BY")!=-1) {
            where= where.substring(0,where.indexOf("ORDER BY"));
        }

            if ((this.getInitialWhere() == null || this.getInitialWhere().equals("")) && (this.getFixedWhere() == null || this.getFixedWhere().equals("")) )
            {
                query.append(" where ");
            }else{
                query.append(" and ");
            }
            query.append("(");
            query.append( where);
            query.append(")");

        if ((where.indexOf("group by")==-1) &&(where.indexOf("GROUP BY")==-1)){
            if ((this.getGroupBy() != null) && (!this.getGroupBy().equals(""))) {
                query.append(" GROUP BY ");
                query.append( this.getGroupBy());
            }
        }

        if ((where.indexOf("order by")==-1) &&(where.indexOf("ORDER BY")==-1)){
            if ((this.getOrderBy() != null) && (!this.getOrderBy().equals("")) && (!this.getOrderBy().equals("null"))) {
                query.append(" ORDER BY ");
                query.append( this.getOrderBy());
            }
        }

            if (this.getForUpdate()==true){
            	query.append(" FOR UPDATE ");
            }
            String queryAux=query.toString();

            for (int i=0;i<artablesdb2.length ;i++ )
            {
            	String tableReplace = artablesdb2[i];
            	if (tableReplace.indexOf(" ")!=-1)
            	{
            		tableReplace=tableReplace.substring(0,tableReplace.indexOf(" "));
            	}
            	String aux1=tableReplace+".";
            	String aux2=aliasNom[i]+".";

            	queryAux=q02a.exe.arquitectura.webCommon.utils.Q02aCommonUtils.replaceAll(queryAux,aux1,aux2);
            }

            query = new StringBuffer(queryAux);

            tr.trace(COMPONENTE,Q70TraceLevel.INFO,"0:" + query.toString());

        }

        PreparedStatement prepStmt = con.prepareStatement(query.toString());
        Q02aSpacePreparedStatement spaPrepStmt = new Q02aSpacePreparedStatement(tipos,longitudes,prepStmt);

        addStatement(prepStmt);

        rs = spaPrepStmt.executeQuery();
        addResultSet(rs);

        if (tr.isTraceActive()) {
            mensaje.append(name);
            mensaje.append(" Ending:");
            mensaje.append(" selectCount");
            tr.trace(COMPONENTE,Q70TraceLevel.DEBUG,mensaje.toString());
        }

        return rs;
    }


    /** Method selectDistinct(where) 
    * @param where New value of property WHERE.
    * @return Value of the resultSet.
    * @throws SQLException SQLException
    */

    public ResultSet selectDistinct(String where)throws SQLException  {

        Connection con=this.getConnection();

        StringBuffer query = new StringBuffer();

        ResultSet rs = null;

        String name = (this.getClass()).getName();

        StringBuffer mensaje = new StringBuffer();

        long user = 0;

        if (tr.isTraceActive()) {
            mensaje.append(name);
            mensaje.append(" Beginning:");
            mensaje.append(" selectDistinct ");
            tr.trace(COMPONENTE,Q70TraceLevel.DEBUG,mensaje.toString());
        }

        query.append("SELECT DISTINCT ");

        if ((this.getDistinct() != null) && (!this.getDistinct().equals(""))){
            query.append(this.getDistinct()).append( " from " ).append( this.getTableFrom() ) ;
        }else{
            query.append("Q022CT00_ID_GRUPO, Q022ET00_ID_CUES, Q022ET00_CLASU, Q022ET00_SUPSU, Q022ET00_SUPTE, Q022ET00_VALSU, Q022ET00_NVPOG, Q022ET00_NVPOE, Q022ET00_NVTMG, Q022ET00_NVTME, Q022ET00_NALOD, Q022ET00_NREAL, Q022ET00_NVTOT, Q022ET00_FEC_ALTA, Q022ET00_FEC_MOD, Q022ET00_FEC_BAJA, Q022ET00_FIRMADO, Q022ET00_CDEXP, Q022ET00_NVPOT, Q022ET00_NLIBRE, Q022ET00_OBSSU, Q022ET00_FADQ, Q022ET00_ENTI, Q022ET00_TVIA, Q022ET00_CALLE, Q022ET00_POR_CL_POR, Q022ET00_BLOQ, Q022ET00_NUME, Q022ET00_BIS, Q022ET00_CDIR, Q022ET00_TIPADQ, Q022ET00_DX, Q022ET00_DY, Q022ET00_DIR_NUEVA, Q022ET00_FUERA_PLAZO, Q022ET00_USU_ALTA, Q022ET00_USU_MODIF from " ).append( this.getTableFrom() );
        }
        if ((where != null) && (!where.equals(""))) {
            query.append(" where ");
            query.append( where);
        }

        if ((where.indexOf("group by")==-1) &&(where.indexOf("GROUP BY")==-1)){
            if ((this.getGroupBy() != null) && (!this.getGroupBy().equals(""))) {
                query.append(" GROUP BY ");
                query.append( this.getGroupBy());
            }
        }

        if ((where.indexOf("order by")==-1) &&(where.indexOf("ORDER BY")==-1)){
            if ((this.getOrderBy() != null) && (!this.getOrderBy().equals("")) && (!this.getOrderBy().equals("null"))) {
                query.append(" ORDER BY ");
                query.append( this.getOrderBy());
            }
        }

        if (this.getNumMaxRegistros()>0){
           if (this.getLimitRows()){
                this.setLimitRows(false);
                this.setNumInicio(0);
                this.setNumFinal(this.getNumMaxRegistros());
           }

            StringBuffer queryAux = new StringBuffer(query.toString());
            queryAux.insert(0,",rownum num FROM (");
            queryAux.insert(0,this.getDistinct());
            queryAux.insert(0," FROM ( SELECT ");
            queryAux.insert(0,this.getDistinct());
            queryAux.insert(0,"SELECT ");

            queryAux.append(")) WHERE NUM>");
            queryAux.append(this.getNumInicio());
            queryAux.append("AND NUM<=");
            queryAux.append(this.getNumFinal());
            query = queryAux;
        }

            if (this.getForUpdate()==true){

            	query.append(" FOR UPDATE ");
            }
            tr.trace(COMPONENTE,Q70TraceLevel.INFO,"0:" + query.toString());

        PreparedStatement prepStmt = con.prepareStatement(query.toString());

        Q02aSpacePreparedStatement spaPrepStmt = new Q02aSpacePreparedStatement(tipos,longitudes,prepStmt);

        addStatement(prepStmt);

        rs = spaPrepStmt.executeQuery();

        addResultSet(rs);

        if (tr.isTraceActive()) {
            mensaje.append(name);
            mensaje.append(" Ending:");
            mensaje.append(" select");
            tr.trace(COMPONENTE,Q70TraceLevel.DEBUG,mensaje.toString());
        }
        return rs;
    }

    /** Method selectMax(where) 
    * @param where New value of property WHERE.
    * @return Value of the resultSet.
    * @throws SQLException SQLException
    */

    public ResultSet selectMax(String where)throws SQLException  {

        Connection con=this.getConnection();

        StringBuffer query = new StringBuffer();

        ResultSet rs = null;

        String name = (this.getClass()).getName();

        StringBuffer mensaje = new StringBuffer();

        long user = 0;

        if (tr.isTraceActive()) {
            mensaje.append(name);
            mensaje.append(" Beginning:");
            mensaje.append(" selectMax ");
            tr.trace(COMPONENTE,Q70TraceLevel.DEBUG,mensaje.toString());
        }

        query.append("SELECT MAX (");

        if (this.getMax() != null){
            query.append(this.getMax() ).append( ") from " ).append( this.getTableFrom() );
        }else{
            throw new NullPointerException();
        }

        if ((where != null) && (!where.equals(""))) {
            query.append(" where ");
            query.append( where);
        }

        if ((where.indexOf("group by")==-1) &&(where.indexOf("GROUP BY")==-1)){
            if ((this.getGroupBy() != null) && (!this.getGroupBy().equals(""))) {
                query.append(" GROUP BY ");
                query.append( this.getGroupBy());
            }
        }

        if ((where.indexOf("order by")==-1) &&(where.indexOf("ORDER BY")==-1)){
            if ((this.getOrderBy() != null) && (!this.getOrderBy().equals("")) && (!this.getOrderBy().equals("null"))) {
                query.append(" ORDER BY ");
                query.append( this.getOrderBy());
            }
        }

        if (this.getNumMaxRegistros()>0){
           if (this.getLimitRows()){
                this.setLimitRows(false);
                this.setNumInicio(0);
                this.setNumFinal(this.getNumMaxRegistros());
           }

           StringBuffer queryAux = new StringBuffer(query.toString());
           
           queryAux.insert(0,",rownum num FROM (");
            queryAux.insert(0,this.getMax());
            queryAux.insert(0," FROM ( SELECT ");
            queryAux.insert(0,this.getMax());
            queryAux.insert(0,"SELECT ");
            queryAux.append(")) WHERE NUM>");
            queryAux.append(this.getNumInicio());
            queryAux.append("AND NUM<=");
            queryAux.append(this.getNumFinal());
            query = queryAux;
        }

            if (this.getForUpdate()==true){
            	query.append(" FOR UPDATE ");
            }

            tr.trace(COMPONENTE,Q70TraceLevel.INFO, "0:" + query.toString());

        PreparedStatement prepStmt = con.prepareStatement(query.toString());
        Q02aSpacePreparedStatement spaPrepStmt = new Q02aSpacePreparedStatement(tipos,longitudes,prepStmt);

        addStatement(prepStmt);

        rs = spaPrepStmt.executeQuery();

        addResultSet(rs);

        if (tr.isTraceActive()) {
            mensaje.append(name);
            mensaje.append(" Ending:");
            mensaje.append(" select");
            tr.trace(COMPONENTE,Q70TraceLevel.DEBUG,mensaje.toString());
        }
        return rs;
    }

    /** Method select() 
    * @return Value of the resultSet.
    * @throws SQLException SQLException
    * @throws Q02aDAOException Q02aDAOException
    */

    public ResultSet select()throws SQLException,Q02aDAOException  {

        String name = (this.getClass()).getName();

        StringBuffer mensaje = new StringBuffer();

        long user = 0;

        if (tr.isTraceActive()) {
            mensaje.append(name);
            mensaje.append(" Beginning:");
            mensaje.append(" select");
            tr.trace(COMPONENTE,Q70TraceLevel.DEBUG,mensaje.toString());
        }

        String[] aliasNom={"A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"};

        Connection con=null;

        con=this.getConnection();

        StringBuffer query = new StringBuffer();
        StringBuffer subquery2 = new StringBuffer();
        StringBuffer queryLog = new StringBuffer();
        StringBuffer queryLog2 = new StringBuffer();

        ResultSet rs = null;

        String tablesdb2 = this.getTableFrom();
        String[] artablesdb2 = q02a.exe.arquitectura.webCommon.utils.Q02aCommonUtils.split(tablesdb2,",");
        String columnsdb2= this.getColumnsSelectTotal();

        StringBuffer text2Buf = new StringBuffer();

        for (int i=0;i<artablesdb2.length ;i++ ){
        	String tableReplace = artablesdb2[i];
        	if (tableReplace.indexOf(" ")!=-1)
        	{
        		tableReplace=tableReplace.substring(0,tableReplace.indexOf(" "));
        	}

        	text2Buf.append(tableReplace).append(".");

            StringBuffer aliasNomBuff = new StringBuffer();
            aliasNomBuff.append( aliasNom[i] ).append(".");
            columnsdb2=q02a.exe.arquitectura.webCommon.utils.Q02aCommonUtils.replaceAll(columnsdb2,text2Buf.toString(),aliasNomBuff.toString());
            
        	if (i==0){
        		tablesdb2 = artablesdb2[i]+ " " + aliasNom[i];
        	}else{
        		tablesdb2 = tablesdb2 + "," + artablesdb2[i] + " " + aliasNom[i];
        	}
        }

        query.append("SELECT ");
        query.append(columnsdb2);
        query.append(" from " ).append( tablesdb2);

        queryLog=new StringBuffer(query.toString());

        boolean and = false;

        if (Q022CT00_ID_GRUPO_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
                queryLog2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022CT00_ID_GRUPO=?");
            queryLog2.append("Q022ES00.Q022CT00_ID_GRUPO=" ).append( Q022CT00_ID_GRUPO_WHERE);
            and = true;
        }

        if (Q022ET00_ID_CUES_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
                queryLog2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022ET00_ID_CUES=?");
            queryLog2.append("Q022ES00.Q022ET00_ID_CUES=" ).append( Q022ET00_ID_CUES_WHERE);
            and = true;
        }

        if (Q022ET00_CLASU_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
                queryLog2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022ET00_CLASU=?");
            queryLog2.append("Q022ES00.Q022ET00_CLASU='" ).append( Q022ET00_CLASU_WHERE).append("'");
            and = true;
        }

        if (Q022ET00_SUPSU_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
                queryLog2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022ET00_SUPSU=?");
            queryLog2.append("Q022ES00.Q022ET00_SUPSU=" ).append( Q022ET00_SUPSU_WHERE);
            and = true;
        }

        if (Q022ET00_SUPTE_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
                queryLog2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022ET00_SUPTE=?");
            queryLog2.append("Q022ES00.Q022ET00_SUPTE=" ).append( Q022ET00_SUPTE_WHERE);
            and = true;
        }

        if (Q022ET00_VALSU_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
                queryLog2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022ET00_VALSU=?");
            queryLog2.append("Q022ES00.Q022ET00_VALSU=" ).append( Q022ET00_VALSU_WHERE);
            and = true;
        }

        if (Q022ET00_NVPOG_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
                queryLog2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022ET00_NVPOG=?");
            queryLog2.append("Q022ES00.Q022ET00_NVPOG=" ).append( Q022ET00_NVPOG_WHERE);
            and = true;
        }

        if (Q022ET00_NVPOE_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
                queryLog2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022ET00_NVPOE=?");
            queryLog2.append("Q022ES00.Q022ET00_NVPOE=" ).append( Q022ET00_NVPOE_WHERE);
            and = true;
        }

        if (Q022ET00_NVTMG_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
                queryLog2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022ET00_NVTMG=?");
            queryLog2.append("Q022ES00.Q022ET00_NVTMG=" ).append( Q022ET00_NVTMG_WHERE);
            and = true;
        }

        if (Q022ET00_NVTME_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
                queryLog2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022ET00_NVTME=?");
            queryLog2.append("Q022ES00.Q022ET00_NVTME=" ).append( Q022ET00_NVTME_WHERE);
            and = true;
        }

        if (Q022ET00_NALOD_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
                queryLog2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022ET00_NALOD=?");
            queryLog2.append("Q022ES00.Q022ET00_NALOD=" ).append( Q022ET00_NALOD_WHERE);
            and = true;
        }

        if (Q022ET00_NREAL_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
                queryLog2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022ET00_NREAL=?");
            queryLog2.append("Q022ES00.Q022ET00_NREAL=" ).append( Q022ET00_NREAL_WHERE);
            and = true;
        }

        if (Q022ET00_NVTOT_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
                queryLog2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022ET00_NVTOT=?");
            queryLog2.append("Q022ES00.Q022ET00_NVTOT=" ).append( Q022ET00_NVTOT_WHERE);
            and = true;
        }

        if (Q022ET00_FEC_ALTA_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
                queryLog2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022ET00_FEC_ALTA=?");
            queryLog2.append("Q022ES00.Q022ET00_FEC_ALTA='" ).append( Q022ET00_FEC_ALTA_WHERE).append("'");
            and = true;
        }

        if (Q022ET00_FEC_MOD_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
                queryLog2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022ET00_FEC_MOD=?");
            queryLog2.append("Q022ES00.Q022ET00_FEC_MOD='" ).append( Q022ET00_FEC_MOD_WHERE).append("'");
            and = true;
        }

        if (Q022ET00_FEC_BAJA_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
                queryLog2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022ET00_FEC_BAJA=?");
            queryLog2.append("Q022ES00.Q022ET00_FEC_BAJA='" ).append( Q022ET00_FEC_BAJA_WHERE).append("'");
            and = true;
        }

        if (Q022ET00_FIRMADO_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
                queryLog2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022ET00_FIRMADO=?");
            queryLog2.append("Q022ES00.Q022ET00_FIRMADO=" ).append( Q022ET00_FIRMADO_WHERE);
            and = true;
        }

        if (Q022ET00_CDEXP_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
                queryLog2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022ET00_CDEXP=?");
            queryLog2.append("Q022ES00.Q022ET00_CDEXP='" ).append( Q022ET00_CDEXP_WHERE).append("'");
            and = true;
        }

        if (Q022ET00_NVPOT_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
                queryLog2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022ET00_NVPOT=?");
            queryLog2.append("Q022ES00.Q022ET00_NVPOT=" ).append( Q022ET00_NVPOT_WHERE);
            and = true;
        }

        if (Q022ET00_NLIBRE_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
                queryLog2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022ET00_NLIBRE=?");
            queryLog2.append("Q022ES00.Q022ET00_NLIBRE=" ).append( Q022ET00_NLIBRE_WHERE);
            and = true;
        }

        if (Q022ET00_OBSSU_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
                queryLog2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022ET00_OBSSU=?");
            queryLog2.append("Q022ES00.Q022ET00_OBSSU='" ).append( Q022ET00_OBSSU_WHERE).append("'");
            and = true;
        }

        if (Q022ET00_FADQ_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
                queryLog2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022ET00_FADQ=?");
            queryLog2.append("Q022ES00.Q022ET00_FADQ='" ).append( Q022ET00_FADQ_WHERE).append("'");
            and = true;
        }

        if (Q022ET00_ENTI_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
                queryLog2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022ET00_ENTI=?");
            queryLog2.append("Q022ES00.Q022ET00_ENTI=" ).append( Q022ET00_ENTI_WHERE);
            and = true;
        }

        if (Q022ET00_TVIA_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
                queryLog2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022ET00_TVIA=?");
            queryLog2.append("Q022ES00.Q022ET00_TVIA='" ).append( Q022ET00_TVIA_WHERE).append("'");
            and = true;
        }

        if (Q022ET00_CALLE_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
                queryLog2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022ET00_CALLE=?");
            queryLog2.append("Q022ES00.Q022ET00_CALLE=" ).append( Q022ET00_CALLE_WHERE);
            and = true;
        }

        if (Q022ET00_POR_CL_POR_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
                queryLog2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022ET00_POR_CL_POR=?");
            queryLog2.append("Q022ES00.Q022ET00_POR_CL_POR=" ).append( Q022ET00_POR_CL_POR_WHERE);
            and = true;
        }

        if (Q022ET00_BLOQ_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
                queryLog2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022ET00_BLOQ=?");
            queryLog2.append("Q022ES00.Q022ET00_BLOQ='" ).append( Q022ET00_BLOQ_WHERE).append("'");
            and = true;
        }

        if (Q022ET00_NUME_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
                queryLog2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022ET00_NUME=?");
            queryLog2.append("Q022ES00.Q022ET00_NUME=" ).append( Q022ET00_NUME_WHERE);
            and = true;
        }

        if (Q022ET00_BIS_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
                queryLog2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022ET00_BIS=?");
            queryLog2.append("Q022ES00.Q022ET00_BIS='" ).append( Q022ET00_BIS_WHERE).append("'");
            and = true;
        }

        if (Q022ET00_CDIR_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
                queryLog2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022ET00_CDIR=?");
            queryLog2.append("Q022ES00.Q022ET00_CDIR='" ).append( Q022ET00_CDIR_WHERE).append("'");
            and = true;
        }

        if (Q022ET00_TIPADQ_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
                queryLog2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022ET00_TIPADQ=?");
            queryLog2.append("Q022ES00.Q022ET00_TIPADQ='" ).append( Q022ET00_TIPADQ_WHERE).append("'");
            and = true;
        }

        if (Q022ET00_DX_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
                queryLog2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022ET00_DX=?");
            queryLog2.append("Q022ES00.Q022ET00_DX=" ).append( Q022ET00_DX_WHERE);
            and = true;
        }

        if (Q022ET00_DY_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
                queryLog2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022ET00_DY=?");
            queryLog2.append("Q022ES00.Q022ET00_DY=" ).append( Q022ET00_DY_WHERE);
            and = true;
        }

        if (Q022ET00_DIR_NUEVA_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
                queryLog2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022ET00_DIR_NUEVA=?");
            queryLog2.append("Q022ES00.Q022ET00_DIR_NUEVA='" ).append( Q022ET00_DIR_NUEVA_WHERE).append("'");
            and = true;
        }
        
        if (Q022ET00_FUERA_PLAZO_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
                queryLog2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022ET00_FUERA_PLAZO=?");
            queryLog2.append("Q022ES00.Q022ET00_FUERA_PLAZO='" ).append( Q022ET00_FUERA_PLAZO_WHERE).append("'");
            and = true;
        }
        
        if (Q022ET00_USU_ALTA_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
                queryLog2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022ET00_USU_ALTA=?");
            queryLog2.append("Q022ES00.Q022ET00_USU_ALTA='" ).append( Q022ET00_USU_ALTA_WHERE).append("'");
            and = true;
        }
        
        if (Q022ET00_USU_MODIF_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
                queryLog2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022ET00_USU_MODIF=?");
            queryLog2.append("Q022ES00.Q022ET00_USU_MODIF='" ).append( Q022ET00_USU_MODIF_WHERE).append("'");
            and = true;
        }
        

        if ((this.getInitialWhere() != null) && (!this.getInitialWhere().equals(""))) {
             query.append( this.getInitialWhere());
             queryLog.append( this.getInitialWhere());
        }

        if ((this.getFixedWhere() != null) && (!this.getFixedWhere().equals(""))) {
             query.append( this.getFixedWhere());
             queryLog.append( this.getFixedWhere());
        }

            if (subquery2 == null || (subquery2 != null && subquery2.toString().equals("") )) {
        		subquery2 = new StringBuffer(" 1=1 ");
        }

        if (subquery2 != null && !subquery2.toString().equals("") ) {
            if ((this.getInitialWhere() == null || this.getInitialWhere().equals("")) && (this.getFixedWhere() == null || this.getFixedWhere().equals("")) )
        	{
        		query.append(" where ");
        		queryLog.append(" where ");
        	}else{
        		query.append(" and ");
        		queryLog.append(" and ");
   			}

            query.append("(");

            queryLog.append("(");
            queryLog.append(queryLog2.toString());

            query.append(subquery2.toString());
            query.append(") ");

            queryLog.append(") ");

        }

        if ((this.getAditionalWhere() != null) && (!this.getAditionalWhere().equals(""))) {
            query.append( this.getAditionalWhere());
            queryLog.append( this.getAditionalWhere());
        }

        if ((this.getGroupBy() != null) && (!this.getGroupBy().equals(""))) {
            query.append(" GROUP BY ");
            queryLog.append(" GROUP BY ");
            query.append( this.getGroupBy());
            queryLog.append( this.getGroupBy());
        }

        if ((this.getOrderBy() != null) && (!this.getOrderBy().equals("")) && (!this.getOrderBy().equals("null"))) {
            query.append(" ORDER BY ");
            queryLog.append(" ORDER BY ");
            query.append( this.getOrderBy());
            queryLog.append( this.getOrderBy());
        }

        if (this.getNumMaxRegistros()>0){
           if (this.getLimitRows()){
                this.setLimitRows(false);
                this.setNumInicio(0);
                this.setNumFinal(this.getNumMaxRegistros());
           }

            //prepStmt.setMaxRows(this.getNumMaxRegistros());

            StringBuffer queryAux = new StringBuffer(query.toString());
            StringBuffer queryAuxLog = new StringBuffer(queryLog.toString());

            queryAux.insert(0," (");
            queryAux.append(") ");
            queryAux.append(") ");
            queryAuxLog.insert(0," (");
            queryAuxLog.append(") ");
            queryAuxLog.append(") ");

            queryAux.insert(0," FROM ");
            queryAuxLog.insert(0," FROM ");

        if (this.getNumMaxRegistros()>0){
            queryAux.insert(0," ,rownum num ");
        }
            queryAux.insert(0,this.getColumnsSelectComitas());
            queryAux.insert(0,"SELECT ");
            queryAuxLog.insert(0," ,rownum num ");
            queryAuxLog.insert(0,this.getColumnsSelectComitas());
            queryAuxLog.insert(0,"SELECT ");
            queryAux.insert(0," (");
            queryAux.insert(0," FROM ");
            queryAux.insert(0,this.getColumnsSelectComitas());
            queryAux.insert(0,"SELECT ");
            queryAuxLog.insert(0," (");
            queryAuxLog.insert(0," FROM ");
            queryAuxLog.insert(0,this.getColumnsSelectComitas());
            queryAuxLog.insert(0,"SELECT ");
            queryAux.append(" WHERE NUM>");
            queryAux.append(this.getNumInicio());
            queryAux.append(" AND NUM<=");
            queryAux.append(this.getNumFinal());
            query = queryAux;
            queryAuxLog.append(" WHERE NUM>");
            queryAuxLog.append(this.getNumInicio());
            queryAuxLog.append(" AND NUM<=");
            queryAuxLog.append(this.getNumFinal());
            queryLog = queryAuxLog;
        }

            if (this.getForUpdate()==true){
            	query.append(" FOR UPDATE ");
            	queryLog.append(" FOR UPDATE ");
        }

            String queryAux=query.toString();
            String queryLogAux=queryLog.toString();

            for (int i=0;i<artablesdb2.length ;i++ )
            {
            	String tableReplace = artablesdb2[i];
            	if (tableReplace.indexOf(" ")!=-1)
            	{
            		tableReplace=tableReplace.substring(0,tableReplace.indexOf(" "));
            	}

                StringBuffer strBAux1 = new StringBuffer();
                    strBAux1.append(tableReplace).append(".");
                StringBuffer strBAux2 = new StringBuffer();
                    strBAux2.append(aliasNom[i]).append(".");    
                String aux1 = strBAux1.toString();
                String aux2 = strBAux2.toString();
                queryAux=q02a.exe.arquitectura.webCommon.utils.Q02aCommonUtils.replaceAll(queryAux,aux1,aux2);

            	queryLogAux=q02a.exe.arquitectura.webCommon.utils.Q02aCommonUtils.replaceAll(queryLogAux,aux1,aux2);

            }

            query = new StringBuffer(queryAux);
            queryLog = new StringBuffer(queryLogAux);

            tr.trace(COMPONENTE,Q70TraceLevel.INFO, "0:" + queryLog.toString());

        PreparedStatement prepStmt1 = con.prepareStatement(query.toString());

        Q02aSpacePreparedStatement prepStmt = new Q02aSpacePreparedStatement(tipos,longitudes,prepStmt1);

        int index=1;

        int pos=1;
            pos=1;
        if (Q022CT00_ID_GRUPO_WHERE != null) {
            try{
            prepStmt.setInt(index,Q022CT00_ID_GRUPO_WHERE.intValue());
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }

            pos=2;
        if (Q022ET00_ID_CUES_WHERE != null) {
            try{
            prepStmt.setLong(index,Q022ET00_ID_CUES_WHERE.longValue());
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }

            pos=3;

        if (Q022ET00_CLASU_WHERE != null) {

            try{

            prepStmt.setString(index,Q022ET00_CLASU_WHERE,pos);

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=4;

        if (Q022ET00_SUPSU_WHERE != null) {

            try{

            prepStmt.setInt(index,Q022ET00_SUPSU_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=5;

        if (Q022ET00_SUPTE_WHERE != null) {

            try{

            prepStmt.setInt(index,Q022ET00_SUPTE_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=6;

        if (Q022ET00_VALSU_WHERE != null) {

            try{

            prepStmt.setDouble(index,Q022ET00_VALSU_WHERE.doubleValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=7;

        if (Q022ET00_NVPOG_WHERE != null) {

            try{

            prepStmt.setInt(index,Q022ET00_NVPOG_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=8;

        if (Q022ET00_NVPOE_WHERE != null) {

            try{

            prepStmt.setInt(index,Q022ET00_NVPOE_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=9;

        if (Q022ET00_NVTMG_WHERE != null) {

            try{

            prepStmt.setInt(index,Q022ET00_NVTMG_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=10;

        if (Q022ET00_NVTME_WHERE != null) {

            try{

            prepStmt.setInt(index,Q022ET00_NVTME_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=11;

        if (Q022ET00_NALOD_WHERE != null) {

            try{

            prepStmt.setInt(index,Q022ET00_NALOD_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=12;

        if (Q022ET00_NREAL_WHERE != null) {

            try{

            prepStmt.setInt(index,Q022ET00_NREAL_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=13;

        if (Q022ET00_NVTOT_WHERE != null) {

            try{

            prepStmt.setInt(index,Q022ET00_NVTOT_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=14;

        if (Q022ET00_FEC_ALTA_WHERE != null) {

            try{

            prepStmt.setTimestamp(index,new java.sql.Timestamp(Q022ET00_FEC_ALTA_WHERE.getTime()));

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=15;

        if (Q022ET00_FEC_MOD_WHERE != null) {

            try{

            prepStmt.setTimestamp(index,new java.sql.Timestamp(Q022ET00_FEC_MOD_WHERE.getTime()));

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=16;

        if (Q022ET00_FEC_BAJA_WHERE != null) {

            try{

            prepStmt.setTimestamp(index,new java.sql.Timestamp(Q022ET00_FEC_BAJA_WHERE.getTime()));

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=17;

        if (Q022ET00_FIRMADO_WHERE != null) {

            try{

            prepStmt.setInt(index,Q022ET00_FIRMADO_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=18;

        if (Q022ET00_CDEXP_WHERE != null) {

            try{

            prepStmt.setString(index,Q022ET00_CDEXP_WHERE,pos);

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=19;

        if (Q022ET00_NVPOT_WHERE != null) {

            try{

            prepStmt.setInt(index,Q022ET00_NVPOT_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=20;

        if (Q022ET00_NLIBRE_WHERE != null) {

            try{

            prepStmt.setInt(index,Q022ET00_NLIBRE_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=21;

        if (Q022ET00_OBSSU_WHERE != null) {

            try{

            prepStmt.setString(index,Q022ET00_OBSSU_WHERE,pos);

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=22;

        if (Q022ET00_FADQ_WHERE != null) {

            try{

            prepStmt.setTimestamp(index,new java.sql.Timestamp(Q022ET00_FADQ_WHERE.getTime()));

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=23;

        if (Q022ET00_ENTI_WHERE != null) {

            try{

            prepStmt.setLong(index,Q022ET00_ENTI_WHERE.longValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=24;

        if (Q022ET00_TVIA_WHERE != null) {

            try{

            prepStmt.setString(index,Q022ET00_TVIA_WHERE,pos);

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=25;

        if (Q022ET00_CALLE_WHERE != null) {

            try{

            prepStmt.setLong(index,Q022ET00_CALLE_WHERE.longValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=26;

        if (Q022ET00_POR_CL_POR_WHERE != null) {

            try{

            prepStmt.setLong(index,Q022ET00_POR_CL_POR_WHERE.longValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=27;

        if (Q022ET00_BLOQ_WHERE != null) {

            try{

            prepStmt.setString(index,Q022ET00_BLOQ_WHERE,pos);

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=28;

        if (Q022ET00_NUME_WHERE != null) {

            try{

            prepStmt.setInt(index,Q022ET00_NUME_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=29;

        if (Q022ET00_BIS_WHERE != null) {

            try{

            prepStmt.setString(index,Q022ET00_BIS_WHERE,pos);

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=30;

        if (Q022ET00_CDIR_WHERE != null) {

            try{

            prepStmt.setString(index,Q022ET00_CDIR_WHERE,pos);

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=31;

        if (Q022ET00_TIPADQ_WHERE != null) {

            try{

            prepStmt.setString(index,Q022ET00_TIPADQ_WHERE,pos);

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=32;

        if (Q022ET00_DX_WHERE != null) {

            try{

            prepStmt.setDouble(index,Q022ET00_DX_WHERE.doubleValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=33;

        if (Q022ET00_DY_WHERE != null) {

            try{

            prepStmt.setDouble(index,Q022ET00_DY_WHERE.doubleValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=34;
        if (Q022ET00_DIR_NUEVA_WHERE != null) {
            try{
            prepStmt.setString(index,Q022ET00_DIR_NUEVA_WHERE,pos);
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }

        pos=35;
        if (Q022ET00_FUERA_PLAZO_WHERE != null) {
            try{
            prepStmt.setString(index,Q022ET00_FUERA_PLAZO_WHERE,pos);
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }
        
        pos=36;
        if (Q022ET00_USU_ALTA_WHERE != null) {
            try{
            prepStmt.setString(index,Q022ET00_USU_ALTA_WHERE,pos);
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }

        pos=37;
        if (Q022ET00_USU_MODIF_WHERE != null) {
            try{
            prepStmt.setString(index,Q022ET00_USU_MODIF_WHERE,pos);
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }
        
        addStatement(prepStmt);
        addStatement(prepStmt1);

        rs = prepStmt.executeQuery();
        addResultSet(rs);

        if (tr.isTraceActive()) {
            mensaje = new StringBuffer();
            mensaje.append(name);
            mensaje.append(" Ending:");
            mensaje.append(" select");
            tr.trace(COMPONENTE,Q70TraceLevel.DEBUG,mensaje.toString());
        }
        return rs;
    }



    /** Method selectCount() 
    * @return Value of the resultSet.
    * @throws SQLException SQLException
    */

    public ResultSet selectCount()throws SQLException  {

        String name = (this.getClass()).getName();

        StringBuffer mensaje = new StringBuffer();

        long user = 0;

        if (tr.isTraceActive()) {

            mensaje.append(name);

            mensaje.append(" Beginning:");

            mensaje.append(" selectCount");

            tr.trace(COMPONENTE,Q70TraceLevel.DEBUG,mensaje.toString());

        }

        String[] aliasNom={"A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"};

        Connection con=this.getConnection();

        StringBuffer query = new StringBuffer();

        StringBuffer subquery2 = new StringBuffer();

        ResultSet rs = null;

        String tablesdb2 = this.getTableFrom();

        String[] artablesdb2 = q02a.exe.arquitectura.webCommon.utils.Q02aCommonUtils.split(tablesdb2,",");

        String columnsdb2= this.getColumnsSelectTotal();

        StringBuffer text2Buf = new StringBuffer();

        for (int i=0;i<artablesdb2.length ;i++ )

        {

        	String tableReplace = artablesdb2[i];

        	if (tableReplace.indexOf(" ")!=-1)

        	{

        		tableReplace=tableReplace.substring(0,tableReplace.indexOf(" "));

        	}

        	text2Buf.append(tableReplace).append(".");

            StringBuffer aliasNomBuff = new StringBuffer();
            aliasNomBuff.append( aliasNom[i] ).append(".");
            columnsdb2=q02a.exe.arquitectura.webCommon.utils.Q02aCommonUtils.replaceAll(columnsdb2,text2Buf.toString(),aliasNomBuff.toString());
            
        	if (i==0)
        	{
        		tablesdb2 = artablesdb2[i]+ " " + aliasNom[i];
        	}else{
        		tablesdb2 = tablesdb2 + "," + artablesdb2[i] + " " + aliasNom[i];
        	}

        	}

        query.append("SELECT COUNT(");

        if  ((this.getDistinct()!=null) && (!this.getDistinct().equals(""))) {
             query.append("DISTINCT (").append(this.getDistinct()).append(")");
        }else {
              query.append("*");
        }

        query.append(") from " ).append( tablesdb2);

        boolean pkCompletada=false;

        boolean and = false;

        if (Q022CT00_ID_GRUPO_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022CT00_ID_GRUPO=?");
            and = true;
        }

        if (Q022ET00_ID_CUES_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022ET00_ID_CUES=?");
            and = true;
        }

        if (Q022ET00_CLASU_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022ET00_CLASU=?");
            and = true;
        }

        if (Q022ET00_SUPSU_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ES00.Q022ET00_SUPSU=?");

            and = true;

        }

        if (Q022ET00_SUPTE_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ES00.Q022ET00_SUPTE=?");

            and = true;

        }

        if (Q022ET00_VALSU_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ES00.Q022ET00_VALSU=?");

            and = true;

        }

        if (Q022ET00_NVPOG_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ES00.Q022ET00_NVPOG=?");

            and = true;

        }

        if (Q022ET00_NVPOE_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ES00.Q022ET00_NVPOE=?");

            and = true;

        }

        if (Q022ET00_NVTMG_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ES00.Q022ET00_NVTMG=?");

            and = true;

        }

        if (Q022ET00_NVTME_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ES00.Q022ET00_NVTME=?");

            and = true;

        }

        if (Q022ET00_NALOD_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ES00.Q022ET00_NALOD=?");

            and = true;

        }

        if (Q022ET00_NREAL_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ES00.Q022ET00_NREAL=?");

            and = true;

        }

        if (Q022ET00_NVTOT_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ES00.Q022ET00_NVTOT=?");

            and = true;

        }

        if (Q022ET00_FEC_ALTA_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ES00.Q022ET00_FEC_ALTA=?");

            and = true;

        }

        if (Q022ET00_FEC_MOD_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ES00.Q022ET00_FEC_MOD=?");

            and = true;

        }

        if (Q022ET00_FEC_BAJA_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ES00.Q022ET00_FEC_BAJA=?");

            and = true;

        }

        if (Q022ET00_FIRMADO_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ES00.Q022ET00_FIRMADO=?");

            and = true;

        }

        if (Q022ET00_CDEXP_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ES00.Q022ET00_CDEXP=?");

            and = true;

        }

        if (Q022ET00_NVPOT_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ES00.Q022ET00_NVPOT=?");

            and = true;

        }

        if (Q022ET00_NLIBRE_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ES00.Q022ET00_NLIBRE=?");

            and = true;

        }

        if (Q022ET00_OBSSU_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ES00.Q022ET00_OBSSU=?");

            and = true;

        }

        if (Q022ET00_FADQ_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ES00.Q022ET00_FADQ=?");

            and = true;

        }

        if (Q022ET00_ENTI_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ES00.Q022ET00_ENTI=?");

            and = true;

        }

        if (Q022ET00_TVIA_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ES00.Q022ET00_TVIA=?");

            and = true;

        }

        if (Q022ET00_CALLE_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ES00.Q022ET00_CALLE=?");

            and = true;

        }

        if (Q022ET00_POR_CL_POR_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ES00.Q022ET00_POR_CL_POR=?");

            and = true;

        }

        if (Q022ET00_BLOQ_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ES00.Q022ET00_BLOQ=?");

            and = true;

        }

        if (Q022ET00_NUME_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ES00.Q022ET00_NUME=?");

            and = true;

        }

        if (Q022ET00_BIS_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ES00.Q022ET00_BIS=?");

            and = true;

        }

        if (Q022ET00_CDIR_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ES00.Q022ET00_CDIR=?");

            and = true;

        }

        if (Q022ET00_TIPADQ_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022ET00_TIPADQ=?");
            and = true;
        }

        if (Q022ET00_DX_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022ET00_DX=?");
            and = true;
        }

        if (Q022ET00_DY_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022ET00_DY=?");
            and = true;
        }

        if (Q022ET00_DIR_NUEVA_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022ET00_DIR_NUEVA=?");
            and = true;
        }
        
        if (Q022ET00_FUERA_PLAZO_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022ET00_FUERA_PLAZO=?");
            and = true;
        }
        
        if (Q022ET00_USU_ALTA_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022ET00_USU_ALTA=?");
            and = true;
        }
        
        if (Q022ET00_USU_MODIF_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
            }
            subquery2.append("Q022ES00.Q022ET00_USU_MODIF=?");
            and = true;
        }
        
        

        if ((this.getInitialWhere() != null) && (!this.getInitialWhere().equals(""))) {
             query.append( this.getInitialWhere());
             queryLog.append( this.getInitialWhere());
        }

        if ((this.getFixedWhere() != null) && (!this.getFixedWhere().equals(""))) {
             query.append( this.getFixedWhere());
             queryLog.append( this.getFixedWhere());
        }

        if (subquery2 == null || (subquery2 != null && subquery2.toString().equals("") )) {
        		subquery2 = new StringBuffer(" 1=1 ");
		}

        if (subquery2 != null && !subquery2.toString().equals("") ) {
            if ((this.getInitialWhere() == null || this.getInitialWhere().equals("")) && (this.getFixedWhere() == null || this.getFixedWhere().equals("")) )
            {
                query.append(" where ");
            }else{
                query.append(" and ");
            }

            query.append("(");
            query.append(subquery2.toString());
            query.append(") ");

        if ((this.getAditionalWhere() != null) && (!this.getAditionalWhere().equals(""))) {

            query.append( this.getAditionalWhere());

            queryLog.append( this.getAditionalWhere());

        }

        }

            String queryAux=query.toString();

            for (int i=0;i<artablesdb2.length ;i++ )

            {

            	String tableReplace = artablesdb2[i];

            	if (tableReplace.indexOf(" ")!=-1)

            	{

            		tableReplace=tableReplace.substring(0,tableReplace.indexOf(" "));

            	}
                StringBuffer strBAux1 = new StringBuffer();
                    strBAux1.append(tableReplace).append(".");
                StringBuffer strBAux2 = new StringBuffer();
                    strBAux2.append(aliasNom[i]).append(".");    
                //String aux1 = tableReplace+".";
                //String aux2 = aliasNom[i]+".";
                String aux1 = strBAux1.toString();
                String aux2 = strBAux2.toString();
                
            	queryAux=q02a.exe.arquitectura.webCommon.utils.Q02aCommonUtils.replaceAll(queryAux,aux1,aux2);

            }

            query = new StringBuffer(queryAux);

            tr.trace(COMPONENTE,Q70TraceLevel.INFO, "0:" + query.toString());

        PreparedStatement prepStmt1 = con.prepareStatement(query.toString());

        Q02aSpacePreparedStatement prepStmt = new Q02aSpacePreparedStatement(tipos,longitudes,prepStmt1);

        int index=1;

        int pos=1;

            pos=1;

        if (Q022CT00_ID_GRUPO_WHERE != null) {

            pkCompletada=true;

            try{

            prepStmt.setInt(index,Q022CT00_ID_GRUPO_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        else{

            pkCompletada=false;

        }

            pos=2;

        if (Q022ET00_ID_CUES_WHERE != null) {

            pkCompletada=true;

            try{

            prepStmt.setLong(index,Q022ET00_ID_CUES_WHERE.longValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        else{

            pkCompletada=false;

        }

            pos=3;

        if (Q022ET00_CLASU_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setString(index,Q022ET00_CLASU_WHERE,pos);

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=4;

        if (Q022ET00_SUPSU_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setInt(index,Q022ET00_SUPSU_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=5;

        if (Q022ET00_SUPTE_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setInt(index,Q022ET00_SUPTE_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=6;

        if (Q022ET00_VALSU_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setDouble(index,Q022ET00_VALSU_WHERE.doubleValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=7;

        if (Q022ET00_NVPOG_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setInt(index,Q022ET00_NVPOG_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=8;

        if (Q022ET00_NVPOE_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setInt(index,Q022ET00_NVPOE_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=9;

        if (Q022ET00_NVTMG_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setInt(index,Q022ET00_NVTMG_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=10;

        if (Q022ET00_NVTME_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setInt(index,Q022ET00_NVTME_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=11;

        if (Q022ET00_NALOD_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setInt(index,Q022ET00_NALOD_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=12;

        if (Q022ET00_NREAL_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setInt(index,Q022ET00_NREAL_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=13;

        if (Q022ET00_NVTOT_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setInt(index,Q022ET00_NVTOT_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=14;

        if (Q022ET00_FEC_ALTA_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setTimestamp(index,new java.sql.Timestamp(Q022ET00_FEC_ALTA_WHERE.getTime()));

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=15;

        if (Q022ET00_FEC_MOD_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setTimestamp(index,new java.sql.Timestamp(Q022ET00_FEC_MOD_WHERE.getTime()));

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=16;

        if (Q022ET00_FEC_BAJA_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setTimestamp(index,new java.sql.Timestamp(Q022ET00_FEC_BAJA_WHERE.getTime()));

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=17;

        if (Q022ET00_FIRMADO_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setInt(index,Q022ET00_FIRMADO_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=18;

        if (Q022ET00_CDEXP_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setString(index,Q022ET00_CDEXP_WHERE,pos);

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=19;

        if (Q022ET00_NVPOT_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setInt(index,Q022ET00_NVPOT_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=20;

        if (Q022ET00_NLIBRE_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setInt(index,Q022ET00_NLIBRE_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=21;

        if (Q022ET00_OBSSU_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setString(index,Q022ET00_OBSSU_WHERE,pos);

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=22;

        if (Q022ET00_FADQ_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setTimestamp(index,new java.sql.Timestamp(Q022ET00_FADQ_WHERE.getTime()));

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=23;

        if (Q022ET00_ENTI_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setLong(index,Q022ET00_ENTI_WHERE.longValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=24;

        if (Q022ET00_TVIA_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setString(index,Q022ET00_TVIA_WHERE,pos);

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=25;

        if (Q022ET00_CALLE_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setLong(index,Q022ET00_CALLE_WHERE.longValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=26;

        if (Q022ET00_POR_CL_POR_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setLong(index,Q022ET00_POR_CL_POR_WHERE.longValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=27;

        if (Q022ET00_BLOQ_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setString(index,Q022ET00_BLOQ_WHERE,pos);

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=28;

        if (Q022ET00_NUME_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setInt(index,Q022ET00_NUME_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=29;

        if (Q022ET00_BIS_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setString(index,Q022ET00_BIS_WHERE,pos);

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=30;

        if (Q022ET00_CDIR_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setString(index,Q022ET00_CDIR_WHERE,pos);

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=31;

        if (Q022ET00_TIPADQ_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setString(index,Q022ET00_TIPADQ_WHERE,pos);

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=32;

        if (Q022ET00_DX_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setDouble(index,Q022ET00_DX_WHERE.doubleValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

            pos=33;

        if (Q022ET00_DY_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setDouble(index,Q022ET00_DY_WHERE.doubleValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=34;
        if (Q022ET00_DIR_NUEVA_WHERE != null &&  pkCompletada==false) {
            try{
            prepStmt.setString(index,Q022ET00_DIR_NUEVA_WHERE,pos);
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }
        
        pos=35;
        if (Q022ET00_FUERA_PLAZO_WHERE != null &&  pkCompletada==false) {
            try{
            prepStmt.setString(index,Q022ET00_FUERA_PLAZO_WHERE,pos);
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }
        
        pos=36;
        if (Q022ET00_USU_ALTA_WHERE != null &&  pkCompletada==false) {
            try{
            prepStmt.setString(index,Q022ET00_USU_ALTA_WHERE,pos);
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }
        
        pos=37;
        if (Q022ET00_USU_MODIF_WHERE != null &&  pkCompletada==false) {
            try{
            prepStmt.setString(index,Q022ET00_USU_MODIF_WHERE,pos);
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }
        

        addStatement(prepStmt);

        addStatement(prepStmt1);

        rs = prepStmt.executeQuery();

        addResultSet(rs);

        if (tr.isTraceActive()) {
            mensaje = new StringBuffer();
            mensaje.append(name);
            mensaje.append(" Ending:");
            mensaje.append(" selectCount");
            tr.trace(COMPONENTE,Q70TraceLevel.DEBUG,mensaje.toString());
        }
        return rs;
    }



    /** Method selectDistinct() 
    * @return Value of the resultSet.
    */

    public ResultSet selectDistinct()throws SQLException  {

        String name = (this.getClass()).getName();

        StringBuffer mensaje = new StringBuffer();

        long user = 0;

        if (tr.isTraceActive()) {
            mensaje.append(name);
            mensaje.append(" Beginning:");
            mensaje.append(" selectDistinct");
            tr.trace(COMPONENTE,Q70TraceLevel.DEBUG,mensaje.toString());
        }

        Connection con=this.getConnection();

        StringBuffer query = new StringBuffer();

        StringBuffer subquery2 = new StringBuffer();

        ResultSet rs = null;

        query.append("SELECT DISTINCT ");

        if ((this.getDistinct() != null) && (!this.getDistinct().equals(""))){
            query.append(this.getDistinct() ).append( " from  " ).append( this.getTableFrom() );
        }else{
            query.append("Q022CT00_ID_GRUPO, Q022ET00_ID_CUES, Q022ET00_CLASU, Q022ET00_SUPSU, Q022ET00_SUPTE, Q022ET00_VALSU, Q022ET00_NVPOG, Q022ET00_NVPOE, Q022ET00_NVTMG, Q022ET00_NVTME, Q022ET00_NALOD, Q022ET00_NREAL, Q022ET00_NVTOT, Q022ET00_FEC_ALTA, Q022ET00_FEC_MOD, Q022ET00_FEC_BAJA, Q022ET00_FIRMADO, Q022ET00_CDEXP, Q022ET00_NVPOT, Q022ET00_NLIBRE, Q022ET00_OBSSU, Q022ET00_FADQ, Q022ET00_ENTI, Q022ET00_TVIA, Q022ET00_CALLE, Q022ET00_POR_CL_POR, Q022ET00_BLOQ, Q022ET00_NUME, Q022ET00_BIS, Q022ET00_CDIR, Q022ET00_TIPADQ, Q022ET00_DX, Q022ET00_DY, Q022ET00_DIR_NUEVA, Q022ET00_FUERA_PLAZO, Q022ET00_USU_ALTA, Q022ET00_USU_MODIF from " ).append( this.getTableFrom() );
        }
        boolean and = false;

        if (Q022CT00_ID_GRUPO_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
            }
            subquery2.append("Q022CT00_ID_GRUPO=?");
            and = true;
        }

        if (Q022ET00_ID_CUES_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
            }
            subquery2.append("Q022ET00_ID_CUES=?");
            and = true;
        }

        if (Q022ET00_CLASU_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_CLASU=?");

            and = true;

        }

        if (Q022ET00_SUPSU_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_SUPSU=?");

            and = true;

        }

        if (Q022ET00_SUPTE_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_SUPTE=?");

            and = true;

        }

        if (Q022ET00_VALSU_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_VALSU=?");

            and = true;

        }

        if (Q022ET00_NVPOG_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_NVPOG=?");

            and = true;

        }

        if (Q022ET00_NVPOE_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_NVPOE=?");

            and = true;

        }

        if (Q022ET00_NVTMG_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_NVTMG=?");

            and = true;

        }

        if (Q022ET00_NVTME_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_NVTME=?");

            and = true;

        }

        if (Q022ET00_NALOD_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_NALOD=?");

            and = true;

        }

        if (Q022ET00_NREAL_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_NREAL=?");

            and = true;

        }

        if (Q022ET00_NVTOT_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_NVTOT=?");

            and = true;

        }

        if (Q022ET00_FEC_ALTA_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_FEC_ALTA=?");

            and = true;

        }

        if (Q022ET00_FEC_MOD_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_FEC_MOD=?");

            and = true;

        }

        if (Q022ET00_FEC_BAJA_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_FEC_BAJA=?");

            and = true;

        }

        if (Q022ET00_FIRMADO_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_FIRMADO=?");

            and = true;

        }

        if (Q022ET00_CDEXP_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_CDEXP=?");

            and = true;

        }

        if (Q022ET00_NVPOT_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_NVPOT=?");

            and = true;

        }

        if (Q022ET00_NLIBRE_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_NLIBRE=?");

            and = true;

        }

        if (Q022ET00_OBSSU_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_OBSSU=?");

            and = true;

        }

        if (Q022ET00_FADQ_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_FADQ=?");

            and = true;

        }

        if (Q022ET00_ENTI_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_ENTI=?");

            and = true;

        }

        if (Q022ET00_TVIA_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_TVIA=?");

            and = true;

        }

        if (Q022ET00_CALLE_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_CALLE=?");

            and = true;

        }

        if (Q022ET00_POR_CL_POR_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_POR_CL_POR=?");

            and = true;

        }

        if (Q022ET00_BLOQ_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_BLOQ=?");

            and = true;

        }

        if (Q022ET00_NUME_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
            }
            subquery2.append("Q022ET00_NUME=?");
            and = true;
        }

        if (Q022ET00_BIS_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
            }
            subquery2.append("Q022ET00_BIS=?");
            and = true;
        }

        if (Q022ET00_CDIR_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
            }
            subquery2.append("Q022ET00_CDIR=?");
            and = true;
        }

        if (Q022ET00_TIPADQ_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
            }
            subquery2.append("Q022ET00_TIPADQ=?");
            and = true;
        }

        if (Q022ET00_DX_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
            }
            subquery2.append("Q022ET00_DX=?");
            and = true;
        }

        if (Q022ET00_DY_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
            }
            subquery2.append("Q022ET00_DY=?");
            and = true;
        }

        if (Q022ET00_DIR_NUEVA_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_DIR_NUEVA=?");

            and = true;

        }

        if (subquery2 != null&& !subquery2.toString().equals("")) {

            query.append(" where ");

            query.append(subquery2.toString());

        }else{query.append(" where (1=1)");}

        if ((this.getAditionalWhere() != null) && (!this.getAditionalWhere().equals(""))) {

            query.append( this.getAditionalWhere());

            queryLog.append( this.getAditionalWhere());

        }

        if (this.getNumMaxRegistros()>0){

           if (this.getLimitRows()){

                this.setLimitRows(false);

                this.setNumInicio(0);

                this.setNumFinal(this.getNumMaxRegistros());

           }

            if (this.getDistinct()==null || this.getDistinct().equals("")){
                this.setDistinct("Q022CT00_ID_GRUPO, Q022ET00_ID_CUES, Q022ET00_CLASU, Q022ET00_SUPSU, Q022ET00_SUPTE, Q022ET00_VALSU, Q022ET00_NVPOG, Q022ET00_NVPOE, Q022ET00_NVTMG, Q022ET00_NVTME, Q022ET00_NALOD, Q022ET00_NREAL, Q022ET00_NVTOT, Q022ET00_FEC_ALTA, Q022ET00_FEC_MOD, Q022ET00_FEC_BAJA, Q022ET00_FIRMADO, Q022ET00_CDEXP, Q022ET00_NVPOT, Q022ET00_NLIBRE, Q022ET00_OBSSU, Q022ET00_FADQ, Q022ET00_ENTI, Q022ET00_TVIA, Q022ET00_CALLE, Q022ET00_POR_CL_POR, Q022ET00_BLOQ, Q022ET00_NUME, Q022ET00_BIS, Q022ET00_CDIR, Q022ET00_TIPADQ, Q022ET00_DX, Q022ET00_DY, Q022ET00_DIR_NUEVA, Q022ET00_FUERA_PLAZO, Q022ET00_USU_ALTA, Q022ET00_USU_MODIF");
            }

            StringBuffer queryAux = new StringBuffer(query.toString());

            queryAux.insert(0,",rownum num FROM (");

            queryAux.insert(0,this.getDistinct());

            queryAux.insert(0," FROM ( SELECT ");

            queryAux.insert(0,this.getDistinct());

            queryAux.insert(0,"SELECT ");

            queryAux.append(")) WHERE NUM>");

            queryAux.append(this.getNumInicio());

            queryAux.append(" AND NUM<=");

            queryAux.append(this.getNumFinal());

            query = queryAux;

        }

            if (this.getForUpdate()==true){

            	query.append(" FOR UPDATE ");
            }
            tr.trace(COMPONENTE,Q70TraceLevel.INFO, "0:" + query.toString());

        PreparedStatement prepStmt1 = con.prepareStatement(query.toString());

        Q02aSpacePreparedStatement prepStmt = new Q02aSpacePreparedStatement(tipos,longitudes,prepStmt1);

        int index=1;

        int pos=1;

        pos=1;

        if (Q022CT00_ID_GRUPO_WHERE != null) {

            try{

            prepStmt.setInt(index,Q022CT00_ID_GRUPO_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=2;

        if (Q022ET00_ID_CUES_WHERE != null) {

            try{

            prepStmt.setLong(index,Q022ET00_ID_CUES_WHERE.longValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=3;

        if (Q022ET00_CLASU_WHERE != null) {

            try{

            prepStmt.setString(index,Q022ET00_CLASU_WHERE,pos);

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=4;

        if (Q022ET00_SUPSU_WHERE != null) {

            try{

            prepStmt.setInt(index,Q022ET00_SUPSU_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=5;

        if (Q022ET00_SUPTE_WHERE != null) {

            try{

            prepStmt.setInt(index,Q022ET00_SUPTE_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=6;

        if (Q022ET00_VALSU_WHERE != null) {

            try{

            prepStmt.setDouble(index,Q022ET00_VALSU_WHERE.doubleValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=7;

        if (Q022ET00_NVPOG_WHERE != null) {

            try{

            prepStmt.setInt(index,Q022ET00_NVPOG_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=8;

        if (Q022ET00_NVPOE_WHERE != null) {

            try{

            prepStmt.setInt(index,Q022ET00_NVPOE_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=9;

        if (Q022ET00_NVTMG_WHERE != null) {

            try{

            prepStmt.setInt(index,Q022ET00_NVTMG_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=10;

        if (Q022ET00_NVTME_WHERE != null) {

            try{

            prepStmt.setInt(index,Q022ET00_NVTME_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=11;

        if (Q022ET00_NALOD_WHERE != null) {

            try{

            prepStmt.setInt(index,Q022ET00_NALOD_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=12;

        if (Q022ET00_NREAL_WHERE != null) {

            try{

            prepStmt.setInt(index,Q022ET00_NREAL_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=13;

        if (Q022ET00_NVTOT_WHERE != null) {

            try{

            prepStmt.setInt(index,Q022ET00_NVTOT_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=14;

        if (Q022ET00_FEC_ALTA_WHERE != null) {

            try{

            prepStmt.setTimestamp(index,new java.sql.Timestamp(Q022ET00_FEC_ALTA_WHERE.getTime()));

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=15;

        if (Q022ET00_FEC_MOD_WHERE != null) {

            try{

            prepStmt.setTimestamp(index,new java.sql.Timestamp(Q022ET00_FEC_MOD_WHERE.getTime()));

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=16;

        if (Q022ET00_FEC_BAJA_WHERE != null) {

            try{

            prepStmt.setTimestamp(index,new java.sql.Timestamp(Q022ET00_FEC_BAJA_WHERE.getTime()));

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=17;

        if (Q022ET00_FIRMADO_WHERE != null) {

            try{

            prepStmt.setInt(index,Q022ET00_FIRMADO_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=18;

        if (Q022ET00_CDEXP_WHERE != null) {

            try{

            prepStmt.setString(index,Q022ET00_CDEXP_WHERE,pos);

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=19;

        if (Q022ET00_NVPOT_WHERE != null) {

            try{

            prepStmt.setInt(index,Q022ET00_NVPOT_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=20;

        if (Q022ET00_NLIBRE_WHERE != null) {

            try{

            prepStmt.setInt(index,Q022ET00_NLIBRE_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=21;

        if (Q022ET00_OBSSU_WHERE != null) {

            try{

            prepStmt.setString(index,Q022ET00_OBSSU_WHERE,pos);

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=22;

        if (Q022ET00_FADQ_WHERE != null) {

            try{

            prepStmt.setTimestamp(index,new java.sql.Timestamp(Q022ET00_FADQ_WHERE.getTime()));

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=23;

        if (Q022ET00_ENTI_WHERE != null) {

            try{

            prepStmt.setLong(index,Q022ET00_ENTI_WHERE.longValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=24;

        if (Q022ET00_TVIA_WHERE != null) {

            try{

            prepStmt.setString(index,Q022ET00_TVIA_WHERE,pos);

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=25;

        if (Q022ET00_CALLE_WHERE != null) {

            try{

            prepStmt.setLong(index,Q022ET00_CALLE_WHERE.longValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=26;

        if (Q022ET00_POR_CL_POR_WHERE != null) {

            try{

            prepStmt.setLong(index,Q022ET00_POR_CL_POR_WHERE.longValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=27;

        if (Q022ET00_BLOQ_WHERE != null) {

            try{

            prepStmt.setString(index,Q022ET00_BLOQ_WHERE,pos);

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=28;

        if (Q022ET00_NUME_WHERE != null) {

            try{

            prepStmt.setInt(index,Q022ET00_NUME_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=29;

        if (Q022ET00_BIS_WHERE != null) {

            try{

            prepStmt.setString(index,Q022ET00_BIS_WHERE,pos);

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=30;

        if (Q022ET00_CDIR_WHERE != null) {

            try{

            prepStmt.setString(index,Q022ET00_CDIR_WHERE,pos);

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=31;

        if (Q022ET00_TIPADQ_WHERE != null) {

            try{

            prepStmt.setString(index,Q022ET00_TIPADQ_WHERE,pos);

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=32;

        if (Q022ET00_DX_WHERE != null) {

            try{

            prepStmt.setDouble(index,Q022ET00_DX_WHERE.doubleValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=33;

        if (Q022ET00_DY_WHERE != null) {

            try{

            prepStmt.setDouble(index,Q022ET00_DY_WHERE.doubleValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=34;
        if (Q022ET00_DIR_NUEVA_WHERE != null) {
            try{
            prepStmt.setString(index,Q022ET00_DIR_NUEVA_WHERE,pos);
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }
        
        pos=35;
        if (Q022ET00_FUERA_PLAZO_WHERE != null) {
            try{
            prepStmt.setString(index,Q022ET00_FUERA_PLAZO_WHERE,pos);
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }
        
        pos=36;
        if ( Q022ET00_USU_ALTA_WHERE != null) {
            try{
            prepStmt.setString(index,Q022ET00_USU_ALTA_WHERE,pos);
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }
        
        pos=37;
        if ( Q022ET00_USU_MODIF_WHERE != null) {
            try{
            prepStmt.setString(index,Q022ET00_USU_MODIF_WHERE,pos);
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }

        addStatement(prepStmt);
        addStatement(prepStmt1);

        rs = prepStmt.executeQuery();
        addResultSet(rs);

        if (tr.isTraceActive()) {
            mensaje = new StringBuffer();
            mensaje.append(name);
            mensaje.append(" Ending:");
            mensaje.append(" selectDistinct");
            tr.trace(COMPONENTE,Q70TraceLevel.DEBUG,mensaje.toString());
        }
        return rs;
    }



    /** Method selectMax() 
    * @return Value of the resultSet.
    * @throws SQLException SQLException
    */

    public ResultSet selectMax()throws SQLException  {

        String name = (this.getClass()).getName();

        StringBuffer mensaje = new StringBuffer();

        long user = 0;

        if (tr.isTraceActive()) {
            mensaje.append(name);
            mensaje.append(" Beginning:");
            mensaje.append(" selectMax");
            tr.trace(COMPONENTE,Q70TraceLevel.DEBUG,mensaje.toString());
        }

        Connection con=this.getConnection();

        StringBuffer query = new StringBuffer();
        StringBuffer subquery2 = new StringBuffer();

        ResultSet rs = null;

        query.append("SELECT MAX (");

        if (this.getMax() != null){

        query.append(this.getMax() ).append( ") from  " ).append( this.getTableFrom() );

        }else{

            throw new NullPointerException();

        }

        boolean and = false;

        if (Q022CT00_ID_GRUPO_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022CT00_ID_GRUPO=?");

            and = true;

        }

        if (Q022ET00_ID_CUES_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_ID_CUES=?");

            and = true;

        }

        if (Q022ET00_CLASU_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_CLASU=?");

            and = true;

        }

        if (Q022ET00_SUPSU_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_SUPSU=?");

            and = true;

        }

        if (Q022ET00_SUPTE_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_SUPTE=?");

            and = true;

        }

        if (Q022ET00_VALSU_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_VALSU=?");

            and = true;

        }

        if (Q022ET00_NVPOG_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_NVPOG=?");

            and = true;

        }

        if (Q022ET00_NVPOE_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_NVPOE=?");

            and = true;

        }

        if (Q022ET00_NVTMG_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_NVTMG=?");

            and = true;

        }

        if (Q022ET00_NVTME_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_NVTME=?");

            and = true;

        }

        if (Q022ET00_NALOD_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_NALOD=?");

            and = true;

        }

        if (Q022ET00_NREAL_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_NREAL=?");

            and = true;

        }

        if (Q022ET00_NVTOT_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_NVTOT=?");

            and = true;

        }

        if (Q022ET00_FEC_ALTA_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_FEC_ALTA=?");

            and = true;

        }

        if (Q022ET00_FEC_MOD_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_FEC_MOD=?");

            and = true;

        }

        if (Q022ET00_FEC_BAJA_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_FEC_BAJA=?");

            and = true;

        }

        if (Q022ET00_FIRMADO_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_FIRMADO=?");

            and = true;

        }

        if (Q022ET00_CDEXP_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_CDEXP=?");

            and = true;

        }

        if (Q022ET00_NVPOT_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_NVPOT=?");

            and = true;

        }

        if (Q022ET00_NLIBRE_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_NLIBRE=?");

            and = true;

        }

        if (Q022ET00_OBSSU_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_OBSSU=?");

            and = true;

        }

        if (Q022ET00_FADQ_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_FADQ=?");

            and = true;

        }

        if (Q022ET00_ENTI_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_ENTI=?");

            and = true;

        }

        if (Q022ET00_TVIA_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_TVIA=?");

            and = true;

        }

        if (Q022ET00_CALLE_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_CALLE=?");

            and = true;

        }

        if (Q022ET00_POR_CL_POR_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_POR_CL_POR=?");

            and = true;

        }

        if (Q022ET00_BLOQ_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_BLOQ=?");

            and = true;

        }

        if (Q022ET00_NUME_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_NUME=?");

            and = true;

        }

        if (Q022ET00_BIS_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_BIS=?");

            and = true;

        }

        if (Q022ET00_CDIR_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_CDIR=?");

            and = true;

        }

        if (Q022ET00_TIPADQ_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_TIPADQ=?");

            and = true;

        }

        if (Q022ET00_DX_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_DX=?");

            and = true;

        }

        if (Q022ET00_DY_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
            }
            subquery2.append("Q022ET00_DY=?");
            and = true;
        }

        if (Q022ET00_DIR_NUEVA_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
            }
            subquery2.append("Q022ET00_DIR_NUEVA=?");
            and = true;
        }
        
        if (Q022ET00_FUERA_PLAZO_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
            }
            subquery2.append("Q022ET00_FUERA_PLAZO=?");
            and = true;
        }
        
        if (Q022ET00_USU_ALTA_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
            }
            subquery2.append("Q022ET00_USU_ALTA=?");
            and = true;
        }
        
        if (Q022ET00_USU_MODIF_WHERE != null) {
            if (and) {
                subquery2.append(" AND ");
            }
            subquery2.append("Q022ET00_USU_MODIF=?");
            and = true;
        }

        if (subquery2 != null) {
            query.append(" where ");
            query.append(subquery2.toString());
        }

            tr.trace(COMPONENTE,Q70TraceLevel.INFO, "0:" + query.toString());

        PreparedStatement prepStmt1 = con.prepareStatement(query.toString());
        Q02aSpacePreparedStatement prepStmt = new Q02aSpacePreparedStatement(tipos,longitudes,prepStmt1);

        int index=1;
        int pos=1;
        pos=1;

        if (Q022CT00_ID_GRUPO_WHERE != null) {
            try{
            prepStmt.setInt(index,Q022CT00_ID_GRUPO_WHERE.intValue());
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }

        pos=2;

        if (Q022ET00_ID_CUES_WHERE != null) {

            try{

            prepStmt.setLong(index,Q022ET00_ID_CUES_WHERE.longValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=3;

        if (Q022ET00_CLASU_WHERE != null) {

            try{

            prepStmt.setString(index,Q022ET00_CLASU_WHERE,pos);

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=4;

        if (Q022ET00_SUPSU_WHERE != null) {

            try{

            prepStmt.setInt(index,Q022ET00_SUPSU_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=5;

        if (Q022ET00_SUPTE_WHERE != null) {

            try{

            prepStmt.setInt(index,Q022ET00_SUPTE_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=6;

        if (Q022ET00_VALSU_WHERE != null) {

            try{

            prepStmt.setDouble(index,Q022ET00_VALSU_WHERE.doubleValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=7;

        if (Q022ET00_NVPOG_WHERE != null) {

            try{

            prepStmt.setInt(index,Q022ET00_NVPOG_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=8;

        if (Q022ET00_NVPOE_WHERE != null) {

            try{

            prepStmt.setInt(index,Q022ET00_NVPOE_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=9;

        if (Q022ET00_NVTMG_WHERE != null) {

            try{

            prepStmt.setInt(index,Q022ET00_NVTMG_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=10;

        if (Q022ET00_NVTME_WHERE != null) {

            try{

            prepStmt.setInt(index,Q022ET00_NVTME_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=11;

        if (Q022ET00_NALOD_WHERE != null) {

            try{

            prepStmt.setInt(index,Q022ET00_NALOD_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=12;

        if (Q022ET00_NREAL_WHERE != null) {

            try{

            prepStmt.setInt(index,Q022ET00_NREAL_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=13;

        if (Q022ET00_NVTOT_WHERE != null) {

            try{

            prepStmt.setInt(index,Q022ET00_NVTOT_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=14;

        if (Q022ET00_FEC_ALTA_WHERE != null) {

            try{

            prepStmt.setTimestamp(index,new java.sql.Timestamp(Q022ET00_FEC_ALTA_WHERE.getTime()));

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=15;

        if (Q022ET00_FEC_MOD_WHERE != null) {

            try{

            prepStmt.setTimestamp(index,new java.sql.Timestamp(Q022ET00_FEC_MOD_WHERE.getTime()));

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=16;

        if (Q022ET00_FEC_BAJA_WHERE != null) {

            try{

            prepStmt.setTimestamp(index,new java.sql.Timestamp(Q022ET00_FEC_BAJA_WHERE.getTime()));

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=17;

        if (Q022ET00_FIRMADO_WHERE != null) {

            try{

            prepStmt.setInt(index,Q022ET00_FIRMADO_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=18;

        if (Q022ET00_CDEXP_WHERE != null) {

            try{

            prepStmt.setString(index,Q022ET00_CDEXP_WHERE,pos);

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=19;

        if (Q022ET00_NVPOT_WHERE != null) {

            try{

            prepStmt.setInt(index,Q022ET00_NVPOT_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=20;

        if (Q022ET00_NLIBRE_WHERE != null) {

            try{

            prepStmt.setInt(index,Q022ET00_NLIBRE_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=21;

        if (Q022ET00_OBSSU_WHERE != null) {

            try{

            prepStmt.setString(index,Q022ET00_OBSSU_WHERE,pos);

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=22;

        if (Q022ET00_FADQ_WHERE != null) {

            try{

            prepStmt.setTimestamp(index,new java.sql.Timestamp(Q022ET00_FADQ_WHERE.getTime()));

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=23;

        if (Q022ET00_ENTI_WHERE != null) {

            try{

            prepStmt.setLong(index,Q022ET00_ENTI_WHERE.longValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=24;

        if (Q022ET00_TVIA_WHERE != null) {

            try{

            prepStmt.setString(index,Q022ET00_TVIA_WHERE,pos);

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=25;

        if (Q022ET00_CALLE_WHERE != null) {

            try{

            prepStmt.setLong(index,Q022ET00_CALLE_WHERE.longValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=26;

        if (Q022ET00_POR_CL_POR_WHERE != null) {

            try{

            prepStmt.setLong(index,Q022ET00_POR_CL_POR_WHERE.longValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=27;

        if (Q022ET00_BLOQ_WHERE != null) {

            try{

            prepStmt.setString(index,Q022ET00_BLOQ_WHERE,pos);

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=28;

        if (Q022ET00_NUME_WHERE != null) {

            try{

            prepStmt.setInt(index,Q022ET00_NUME_WHERE.intValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=29;

        if (Q022ET00_BIS_WHERE != null) {

            try{

            prepStmt.setString(index,Q022ET00_BIS_WHERE,pos);

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=30;

        if (Q022ET00_CDIR_WHERE != null) {

            try{

            prepStmt.setString(index,Q022ET00_CDIR_WHERE,pos);

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=31;

        if (Q022ET00_TIPADQ_WHERE != null) {

            try{

            prepStmt.setString(index,Q022ET00_TIPADQ_WHERE,pos);

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=32;

        if (Q022ET00_DX_WHERE != null) {

            try{

            prepStmt.setDouble(index,Q022ET00_DX_WHERE.doubleValue());

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=33;

        if (Q022ET00_DY_WHERE != null) {

            try{
            prepStmt.setDouble(index,Q022ET00_DY_WHERE.doubleValue());
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }

        pos=34;
        if (Q022ET00_DIR_NUEVA_WHERE != null) {
            try{
            prepStmt.setString(index,Q022ET00_DIR_NUEVA_WHERE,pos);
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }
        
        pos=35;
        if (Q022ET00_FUERA_PLAZO_WHERE != null) {
            try{
            prepStmt.setString(index,Q022ET00_FUERA_PLAZO_WHERE,pos);
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }
        
        pos=36;
        if (Q022ET00_USU_ALTA_WHERE != null) {
            try{
            prepStmt.setString(index,Q022ET00_USU_ALTA_WHERE,pos);
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }
        
        pos=37;
        if (Q022ET00_USU_MODIF_WHERE != null) {
            try{
            prepStmt.setString(index,Q022ET00_USU_MODIF_WHERE,pos);
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }
                
        
        addStatement(prepStmt);
        addStatement(prepStmt1);

        rs = prepStmt.executeQuery();

        addResultSet(rs);

        if (tr.isTraceActive()) {
            mensaje = new StringBuffer();
            mensaje.append(name);
            mensaje.append(" Ending:");
            mensaje.append(" selectMax");
            tr.trace(COMPONENTE,Q70TraceLevel.DEBUG,mensaje.toString());
        }
        return rs;
    }

    /** Method update() 
     * @throws SQLException SQLException
     * */

    public void update()throws SQLException  {

    Connection con = null;

        String name = (this.getClass()).getName();

        StringBuffer mensaje = new StringBuffer();

        long user = 0;

        if (tr.isTraceActive()) {
            mensaje.append(name);
            mensaje.append(" Beginning:");
            mensaje.append(" update");
            tr.trace(COMPONENTE,Q70TraceLevel.DEBUG,mensaje.toString());
        }

         con=this.getConnection();

        StringBuffer query = new StringBuffer();

        StringBuffer subquery1 = new StringBuffer();
        StringBuffer subquery2 = new StringBuffer();

         queryLog = new StringBuffer();

        query.append("UPDATE Q022ES00 ");
        queryLog.append("UPDATE Q022ES00 SET ");

        boolean and = false;

        if (Q022CT00_ID_GRUPO != null || this.Q022CT00_ID_GRUPO_MODIF==true) {
            if (and) {
            subquery1.append(" ,");
            }
            subquery1.append("Q022CT00_ID_GRUPO=?");
            and = true;
        }

        if (Q022ET00_ID_CUES != null || this.Q022ET00_ID_CUES_MODIF==true) {
            if (and) {
            subquery1.append(" ,");
            }
            subquery1.append("Q022ET00_ID_CUES=?");
            and = true;
        }

        if (Q022ET00_CLASU != null || this.Q022ET00_CLASU_MODIF==true) {
            if (and) {
            subquery1.append(" ,");
            }
            subquery1.append("Q022ET00_CLASU=?");
            and = true;
        }

        if (Q022ET00_SUPSU != null || this.Q022ET00_SUPSU_MODIF==true) {
            if (and) {
            subquery1.append(" ,");
            }
            subquery1.append("Q022ET00_SUPSU=?");
            and = true;
        }

        if (Q022ET00_SUPTE != null || this.Q022ET00_SUPTE_MODIF==true) {
            if (and) {
            subquery1.append(" ,");
            }
            subquery1.append("Q022ET00_SUPTE=?");
            and = true;
        }

        if (Q022ET00_VALSU != null || this.Q022ET00_VALSU_MODIF==true) {
            if (and) {
            subquery1.append(" ,");
            }
            subquery1.append("Q022ET00_VALSU=?");
            and = true;
        }

        if (Q022ET00_NVPOG != null || this.Q022ET00_NVPOG_MODIF==true) {
            if (and) {
            subquery1.append(" ,");
            }
            subquery1.append("Q022ET00_NVPOG=?");
            and = true;
        }

        if (Q022ET00_NVPOE != null || this.Q022ET00_NVPOE_MODIF==true) {
            if (and) {
            subquery1.append(" ,");
            }
            subquery1.append("Q022ET00_NVPOE=?");
            and = true;
        }

        if (Q022ET00_NVTMG != null || this.Q022ET00_NVTMG_MODIF==true) {
            if (and) {
            subquery1.append(" ,");
            }
            subquery1.append("Q022ET00_NVTMG=?");
            and = true;
        }

        if (Q022ET00_NVTME != null || this.Q022ET00_NVTME_MODIF==true) {
            if (and) {
            subquery1.append(" ,");
            }
            subquery1.append("Q022ET00_NVTME=?");
            and = true;
        }

        if (Q022ET00_NALOD != null || this.Q022ET00_NALOD_MODIF==true) {
            if (and) {
            subquery1.append(" ,");
            }
            subquery1.append("Q022ET00_NALOD=?");
            and = true;
        }

        if (Q022ET00_NREAL != null || this.Q022ET00_NREAL_MODIF==true) {
            if (and) {
            subquery1.append(" ,");
            }
            subquery1.append("Q022ET00_NREAL=?");
            and = true;
        }

        if (Q022ET00_NVTOT != null || this.Q022ET00_NVTOT_MODIF==true) {
            if (and) {
            subquery1.append(" ,");
            }
            subquery1.append("Q022ET00_NVTOT=?");
            and = true;
        }

        if (Q02aSysdate.isSysdate(Q022ET00_FEC_ALTA)){
            if (and) {
            subquery1.append(" ,");
            }
            subquery1.append("Q022ET00_FEC_ALTA=sysdate");
            and = true;
            }else {
            if (Q022ET00_FEC_ALTA != null || this.Q022ET00_FEC_ALTA_MODIF==true) {
            if (and) {
            subquery1.append(" ,");
            }
            subquery1.append("Q022ET00_FEC_ALTA=?");
            and = true;
        }
        }

        //FEC_MOD
            if (and) {
                subquery1.append(" ,");
            }
            subquery1.append("Q022ET00_FEC_MOD=sysdate");
            and = true;
        
        //FEC_BAJA
        if (Q02aSysdate.isSysdate(Q022ET00_FEC_BAJA)){
            if (and) {
            subquery1.append(" ,");
            }
            subquery1.append("Q022ET00_FEC_BAJA=sysdate");
            and = true;
        }else {
            if (Q022ET00_FEC_BAJA != null || this.Q022ET00_FEC_BAJA_MODIF==true) {
                if (and) {
                subquery1.append(" ,");
                }
                subquery1.append("Q022ET00_FEC_BAJA=?");
                and = true;
            }
        }

        if (Q022ET00_FIRMADO != null || this.Q022ET00_FIRMADO_MODIF==true) {
            if (and) {
            subquery1.append(" ,");
            }
            subquery1.append("Q022ET00_FIRMADO=?");
            and = true;
        }

        if (Q022ET00_CDEXP != null || this.Q022ET00_CDEXP_MODIF==true) {
            if (and) {
            subquery1.append(" ,");
            }
            subquery1.append("Q022ET00_CDEXP=?");
            and = true;
        }

        if (Q022ET00_NVPOT != null || this.Q022ET00_NVPOT_MODIF==true) {
            if (and) {
            subquery1.append(" ,");
            }
            subquery1.append("Q022ET00_NVPOT=?");
            and = true;
        }

        if (Q022ET00_NLIBRE != null || this.Q022ET00_NLIBRE_MODIF==true) {
            if (and) {
            subquery1.append(" ,");
            }
            subquery1.append("Q022ET00_NLIBRE=?");
            and = true;
        }

        if (Q022ET00_OBSSU != null || this.Q022ET00_OBSSU_MODIF==true) {
            if (and) {
            subquery1.append(" ,");
            }
            subquery1.append("Q022ET00_OBSSU=?");
            and = true;
        }

        if (Q02aSysdate.isSysdate(Q022ET00_FADQ)){
            if (and) {
            subquery1.append(" ,");
            }
            subquery1.append("Q022ET00_FADQ=sysdate");
            and = true;
            }else {
            if (Q022ET00_FADQ != null || this.Q022ET00_FADQ_MODIF==true) {
            if (and) {
            subquery1.append(" ,");
            }
            subquery1.append("Q022ET00_FADQ=?");
            and = true;
        }
        }

        if (Q022ET00_ENTI != null || this.Q022ET00_ENTI_MODIF==true) {
            if (and) {
            subquery1.append(" ,");
            }
            subquery1.append("Q022ET00_ENTI=?");
            and = true;
        }

        if (Q022ET00_TVIA != null || this.Q022ET00_TVIA_MODIF==true) {
            if (and) {
            subquery1.append(" ,");
            }
            subquery1.append("Q022ET00_TVIA=?");
            and = true;
        }

            if (Q022ET00_CALLE != null || this.Q022ET00_CALLE_MODIF==true) {

            if (and) {

            subquery1.append(" ,");

            }

            subquery1.append("Q022ET00_CALLE=?");

            and = true;

        }

            if (Q022ET00_POR_CL_POR != null || this.Q022ET00_POR_CL_POR_MODIF==true) {

            if (and) {

            subquery1.append(" ,");

            }

            subquery1.append("Q022ET00_POR_CL_POR=?");

            and = true;

        }

            if (Q022ET00_BLOQ != null || this.Q022ET00_BLOQ_MODIF==true) {

            if (and) {

            subquery1.append(" ,");

            }

            subquery1.append("Q022ET00_BLOQ=?");

            and = true;

        }

            if (Q022ET00_NUME != null || this.Q022ET00_NUME_MODIF==true) {

            if (and) {

            subquery1.append(" ,");

            }

            subquery1.append("Q022ET00_NUME=?");

            and = true;

        }

            if (Q022ET00_BIS != null || this.Q022ET00_BIS_MODIF==true) {

            if (and) {

            subquery1.append(" ,");

            }

            subquery1.append("Q022ET00_BIS=?");

            and = true;

        }

            if (Q022ET00_CDIR != null || this.Q022ET00_CDIR_MODIF==true) {

            if (and) {

            subquery1.append(" ,");

            }

            subquery1.append("Q022ET00_CDIR=?");

            and = true;

        }

            if (Q022ET00_TIPADQ != null || this.Q022ET00_TIPADQ_MODIF==true) {

            if (and) {

            subquery1.append(" ,");

            }

            subquery1.append("Q022ET00_TIPADQ=?");

            and = true;

        }

            if (Q022ET00_DX != null || this.Q022ET00_DX_MODIF==true) {

            if (and) {

            subquery1.append(" ,");

            }

            subquery1.append("Q022ET00_DX=?");

            and = true;

        }

        if (Q022ET00_DY != null || this.Q022ET00_DY_MODIF==true) {
            if (and) {
            subquery1.append(" ,");
            }
            subquery1.append("Q022ET00_DY=?");
            and = true;
        }

        if (Q022ET00_DIR_NUEVA != null || this.Q022ET00_DIR_NUEVA_MODIF==true) {
            if (and) {
            subquery1.append(" ,");
            }
            subquery1.append("Q022ET00_DIR_NUEVA=?");
            and = true;
        }
        
        if (Q022ET00_FUERA_PLAZO != null || this.Q022ET00_FUERA_PLAZO_MODIF==true) {
            if (and) {
            subquery1.append(" ,");
            }
            subquery1.append("Q022ET00_FUERA_PLAZO=?");
            and = true;
        }
        
        if (Q022ET00_USU_MODIF != null || this.Q022ET00_USU_MODIF_MODIF==true) {
            if (and) {
            subquery1.append(" ,");
            }
            subquery1.append("Q022ET00_USU_MODIF=?");
            and = true;
        }
        ////////////////////////////////////////////////////////////////////
        

        if (subquery1 != null) {
            query.append(" set ");
            query.append(subquery1.toString());
        }

        and = false;

        boolean pkCompletada=false;

        if (Q022CT00_ID_GRUPO_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022CT00_ID_GRUPO=?");

            and = true;

        }

        else{

            pkCompletada=false;

        }

        if (Q022ET00_ID_CUES_WHERE != null) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_ID_CUES=?");

            and = true;

        }

        else{

            pkCompletada=false;

        }

        if (Q022ET00_CLASU_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_CLASU=?");

            and = true;

        }

        if (Q022ET00_SUPSU_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_SUPSU=?");

            and = true;

        }

        if (Q022ET00_SUPTE_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_SUPTE=?");

            and = true;

        }

        if (Q022ET00_VALSU_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_VALSU=?");

            and = true;

        }

        if (Q022ET00_NVPOG_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_NVPOG=?");

            and = true;

        }

        if (Q022ET00_NVPOE_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_NVPOE=?");

            and = true;

        }

        if (Q022ET00_NVTMG_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_NVTMG=?");

            and = true;

        }

        if (Q022ET00_NVTME_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_NVTME=?");

            and = true;

        }

        if (Q022ET00_NALOD_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_NALOD=?");

            and = true;

        }

        if (Q022ET00_NREAL_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_NREAL=?");

            and = true;

        }

        if (Q022ET00_NVTOT_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_NVTOT=?");

            and = true;

        }

        if (Q022ET00_FEC_ALTA_WHERE != null &&  pkCompletada==false) {
            if (and) {
                subquery2.append(" AND ");
            }
            subquery2.append("Q022ET00_FEC_ALTA=?");
            and = true;
        }

        if (Q022ET00_FEC_MOD_WHERE != null &&  pkCompletada==false) {
            if (and) {
                subquery2.append(" AND ");
            }
            subquery2.append("Q022ET00_FEC_MOD=?");
            and = true;
        }

        if (Q022ET00_FEC_BAJA_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_FEC_BAJA=?");

            and = true;

        }

        if (Q022ET00_FIRMADO_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_FIRMADO=?");

            and = true;

        }

        if (Q022ET00_CDEXP_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_CDEXP=?");

            and = true;

        }

        if (Q022ET00_NVPOT_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_NVPOT=?");

            and = true;

        }

        if (Q022ET00_NLIBRE_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_NLIBRE=?");

            and = true;

        }

        if (Q022ET00_OBSSU_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_OBSSU=?");

            and = true;

        }

        if (Q022ET00_FADQ_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_FADQ=?");

            and = true;

        }

        if (Q022ET00_ENTI_WHERE != null &&  pkCompletada==false) {
            if (and) {
                subquery2.append(" AND ");
            }
            subquery2.append("Q022ET00_ENTI=?");
            and = true;
        }

        if (Q022ET00_TVIA_WHERE != null &&  pkCompletada==false) {
            if (and) {
                subquery2.append(" AND ");
            }
            subquery2.append("Q022ET00_TVIA=?");
            and = true;
        }

        if (Q022ET00_CALLE_WHERE != null &&  pkCompletada==false) {
            if (and) {
                subquery2.append(" AND ");
            }
            subquery2.append("Q022ET00_CALLE=?");
            and = true;
        }

        if (Q022ET00_POR_CL_POR_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_POR_CL_POR=?");

            and = true;

        }

        if (Q022ET00_BLOQ_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_BLOQ=?");

            and = true;

        }

        if (Q022ET00_NUME_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_NUME=?");

            and = true;

        }

        if (Q022ET00_BIS_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_BIS=?");

            and = true;

        }

        if (Q022ET00_CDIR_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_CDIR=?");

            and = true;

        }

        if (Q022ET00_TIPADQ_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_TIPADQ=?");

            and = true;

        }

        if (Q022ET00_DX_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_DX=?");

            and = true;

        }

        if (Q022ET00_DY_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_DY=?");

            and = true;

        }

        if (Q022ET00_DIR_NUEVA_WHERE != null &&  pkCompletada==false) {
            if (and) {
                subquery2.append(" AND ");
            }
            subquery2.append("Q022ET00_DIR_NUEVA=?");
            and = true;
        }
        
        if (Q022ET00_FUERA_PLAZO_WHERE != null &&  pkCompletada==false) {
            if (and) {
                subquery2.append(" AND ");
            }
            subquery2.append("Q022ET00_FUERA_PLAZO=?");
            and = true;
        }
        
        if (Q022ET00_USU_MODIF_WHERE != null &&  pkCompletada==false) {
            if (and) {
                subquery2.append(" AND ");
            }
            subquery2.append("Q022ET00_USU_MODIF=?");
            and = true;
        }
        /////////////////////////////////////////////////////////////
        

        if (subquery2 != null) {
            query.append(" where ");
            query.append(subquery2.toString());
            tr.trace(COMPONENTE,Q70TraceLevel.DEBUG,query.toString());
        }

        PreparedStatement prepStmt1 = con.prepareStatement(query.toString());
        Q02aSpacePreparedStatement prepStmt = new Q02aSpacePreparedStatement(tipos,longitudes,prepStmt1);

        int index=1;

        int pos=1;

        pos=1;

        if (Q022CT00_ID_GRUPO != null|| Q022CT00_ID_GRUPO_MODIF == true) {
            try{
                if (Q022CT00_ID_GRUPO != null){
                    prepStmt.setInt(index,Q022CT00_ID_GRUPO.intValue());
                    queryLog.append("Q022CT00_ID_GRUPO" ).append( "=" +Q022CT00_ID_GRUPO.intValue()+ ",");
                }else{
                    prepStmt.setNull(index,java.sql.Types.INTEGER);
                    queryLog.append("Q022CT00_ID_GRUPO" ).append( "=" + null + ",");
                }
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }

        pos=2;

        if (Q022ET00_ID_CUES != null|| Q022ET00_ID_CUES_MODIF == true) {

            try{

        if (Q022ET00_ID_CUES != null){

            prepStmt.setLong(index,Q022ET00_ID_CUES.longValue());

            queryLog.append("Q022ET00_ID_CUES" ).append( "=" +Q022ET00_ID_CUES.longValue()+ ",");

        }else{

            prepStmt.setNull(index,java.sql.Types.INTEGER);

            queryLog.append("Q022ET00_ID_CUES" ).append( "=" + null + ",");

            }}catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=3;

        if (Q022ET00_CLASU != null|| Q022ET00_CLASU_MODIF == true) {

            try{

            prepStmt.setString(index,Q022ET00_CLASU,pos);

            queryLog.append("Q022ET00_CLASU" ).append( "=" ).append(Q022ET00_CLASU).append( ",");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=4;

        if (Q022ET00_SUPSU != null|| Q022ET00_SUPSU_MODIF == true) {

            try{

        if (Q022ET00_SUPSU != null){

            prepStmt.setInt(index,Q022ET00_SUPSU.intValue());

            queryLog.append("Q022ET00_SUPSU" ).append( "=" ).append(Q022ET00_SUPSU.intValue()).append( ",");

        }else{

            prepStmt.setNull(index,java.sql.Types.INTEGER);

            queryLog.append("Q022ET00_SUPSU" ).append( "=" + null + ",");

            }}catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=5;

        if (Q022ET00_SUPTE != null|| Q022ET00_SUPTE_MODIF == true) {

            try{

        if (Q022ET00_SUPTE != null){

            prepStmt.setInt(index,Q022ET00_SUPTE.intValue());

            queryLog.append("Q022ET00_SUPTE" ).append( "=" ).append(Q022ET00_SUPTE.intValue()).append( ",");

        }else{

            prepStmt.setNull(index,java.sql.Types.INTEGER);

            queryLog.append("Q022ET00_SUPTE" ).append( "=" + null + ",");

            }}catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=6;

        if (Q022ET00_VALSU != null|| Q022ET00_VALSU_MODIF == true) {

            try{

        if (Q022ET00_VALSU != null){

            prepStmt.setDouble(index,Q022ET00_VALSU.doubleValue());

            queryLog.append("Q022ET00_VALSU" ).append( "=" ).append(Q022ET00_VALSU.doubleValue()).append( ",");

        }else{

            prepStmt.setNull(index,java.sql.Types.DOUBLE);

            queryLog.append("Q022ET00_VALSU" ).append( "=" + null + ",");

            }}catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=7;

        if (Q022ET00_NVPOG != null|| Q022ET00_NVPOG_MODIF == true) {

            try{

        if (Q022ET00_NVPOG != null){

            prepStmt.setInt(index,Q022ET00_NVPOG.intValue());

            queryLog.append("Q022ET00_NVPOG" ).append( "=" +Q022ET00_NVPOG.intValue()).append( ",");

        }else{

            prepStmt.setNull(index,java.sql.Types.INTEGER);

            queryLog.append("Q022ET00_NVPOG" ).append( "=" + null + ",");

            }}catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=8;

        if (Q022ET00_NVPOE != null|| Q022ET00_NVPOE_MODIF == true) {

            try{

        if (Q022ET00_NVPOE != null){

            prepStmt.setInt(index,Q022ET00_NVPOE.intValue());

            queryLog.append("Q022ET00_NVPOE" ).append( "=" ).append(Q022ET00_NVPOE.intValue()).append( ",");

        }else{

            prepStmt.setNull(index,java.sql.Types.INTEGER);

            queryLog.append("Q022ET00_NVPOE" ).append( "=" + null + ",");

            }}catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=9;

        if (Q022ET00_NVTMG != null|| Q022ET00_NVTMG_MODIF == true) {

            try{

        if (Q022ET00_NVTMG != null){

            prepStmt.setInt(index,Q022ET00_NVTMG.intValue());

            queryLog.append("Q022ET00_NVTMG" ).append( "=" ).append(Q022ET00_NVTMG.intValue()).append( ",");

        }else{

            prepStmt.setNull(index,java.sql.Types.INTEGER);

            queryLog.append("Q022ET00_NVTMG" ).append( "=" + null + ",");

            }}catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=10;

        if (Q022ET00_NVTME != null|| Q022ET00_NVTME_MODIF == true) {

            try{

        if (Q022ET00_NVTME != null){

            prepStmt.setInt(index,Q022ET00_NVTME.intValue());

            queryLog.append("Q022ET00_NVTME" ).append( "=" ).append(Q022ET00_NVTME.intValue()).append( ",");

        }else{

            prepStmt.setNull(index,java.sql.Types.INTEGER);

            queryLog.append("Q022ET00_NVTME" ).append( "=" + null + ",");

            }}catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=11;

        if (Q022ET00_NALOD != null|| Q022ET00_NALOD_MODIF == true) {

            try{

        if (Q022ET00_NALOD != null){

            prepStmt.setInt(index,Q022ET00_NALOD.intValue());

            queryLog.append("Q022ET00_NALOD" ).append( "=" ).append(Q022ET00_NALOD.intValue()).append( ",");

        }else{

            prepStmt.setNull(index,java.sql.Types.INTEGER);

            queryLog.append("Q022ET00_NALOD" ).append( "=" + null + ",");

            }}catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=12;

        if (Q022ET00_NREAL != null|| Q022ET00_NREAL_MODIF == true) {

            try{

        if (Q022ET00_NREAL != null){

            prepStmt.setInt(index,Q022ET00_NREAL.intValue());

            queryLog.append("Q022ET00_NREAL" ).append( "=" ).append(Q022ET00_NREAL.intValue()).append( ",");

        }else{

            prepStmt.setNull(index,java.sql.Types.INTEGER);

            queryLog.append("Q022ET00_NREAL" ).append( "=" + null + ",");

            }}catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=13;

        if (Q022ET00_NVTOT != null|| Q022ET00_NVTOT_MODIF == true) {

            try{

        if (Q022ET00_NVTOT != null){

            prepStmt.setInt(index,Q022ET00_NVTOT.intValue());

            queryLog.append("Q022ET00_NVTOT" ).append( "=" ).append(Q022ET00_NVTOT.intValue()).append( ",");

        }else{

            prepStmt.setNull(index,java.sql.Types.INTEGER);

            queryLog.append("Q022ET00_NVTOT" ).append( "=" + null + ",");

            }}catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=14;
        if (Q022ET00_FEC_ALTA != null|| Q022ET00_FEC_ALTA_MODIF == true) {
            if (!Q02aSysdate.isSysdate(Q022ET00_FEC_ALTA)){
                try{
                    if (Q022ET00_FEC_ALTA != null){
                        queryLog.append(new java.sql.Timestamp(Q022ET00_FEC_ALTA.getTime())+ ",");
                        prepStmt.setTimestamp(index,new java.sql.Timestamp(Q022ET00_FEC_ALTA.getTime()));
                    }else{
                        prepStmt.setNull(index,java.sql.Types.DATE);
                        queryLog.append("Q022ET00_FEC_ALTA" ).append( "=" + null + ",");
                    }
                }catch (java.sql.SQLException e){
                    e.printStackTrace();
                }
                index=index+1;
            }
        }

        pos=15;
        pos=16;
        if (Q022ET00_FEC_BAJA != null|| Q022ET00_FEC_BAJA_MODIF == true) {
            if (!Q02aSysdate.isSysdate(Q022ET00_FEC_BAJA)){
            try{
        if (Q022ET00_FEC_BAJA != null){
            queryLog.append(new java.sql.Timestamp(Q022ET00_FEC_BAJA.getTime())+ ",");
            prepStmt.setTimestamp(index,new java.sql.Timestamp(Q022ET00_FEC_BAJA.getTime()));
        }else{
            prepStmt.setNull(index,java.sql.Types.DATE);
            queryLog.append("Q022ET00_FEC_BAJA" ).append( "=" + null + ",");
            }}catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
            }
        }

        pos=17;
        if (Q022ET00_FIRMADO != null|| Q022ET00_FIRMADO_MODIF == true) {

            try{

        if (Q022ET00_FIRMADO != null){

            prepStmt.setInt(index,Q022ET00_FIRMADO.intValue());

            queryLog.append("Q022ET00_FIRMADO" ).append( "=" +Q022ET00_FIRMADO.intValue()+ ",");

        }else{

            prepStmt.setNull(index,java.sql.Types.INTEGER);

            queryLog.append("Q022ET00_FIRMADO" ).append( "=" + null + ",");

            }}catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=18;

        if (Q022ET00_CDEXP != null|| Q022ET00_CDEXP_MODIF == true) {

            try{

            prepStmt.setString(index,Q022ET00_CDEXP,pos);

            queryLog.append("Q022ET00_CDEXP" ).append( "=" ).append(Q022ET00_CDEXP).append( ",");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=19;

        if (Q022ET00_NVPOT != null|| Q022ET00_NVPOT_MODIF == true) {

            try{

        if (Q022ET00_NVPOT != null){

            prepStmt.setInt(index,Q022ET00_NVPOT.intValue());

            queryLog.append("Q022ET00_NVPOT" ).append( "=" ).append(Q022ET00_NVPOT.intValue()).append( ",");

        }else{

            prepStmt.setNull(index,java.sql.Types.INTEGER);

            queryLog.append("Q022ET00_NVPOT" ).append( "=" + null + ",");

            }}catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=20;

        if (Q022ET00_NLIBRE != null|| Q022ET00_NLIBRE_MODIF == true) {

            try{

        if (Q022ET00_NLIBRE != null){

            prepStmt.setInt(index,Q022ET00_NLIBRE.intValue());

            queryLog.append("Q022ET00_NLIBRE" ).append( "=" ).append(Q022ET00_NLIBRE.intValue()).append( ",");

        }else{

            prepStmt.setNull(index,java.sql.Types.INTEGER);

            queryLog.append("Q022ET00_NLIBRE" ).append( "=" + null + ",");

            }}catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=21;

        if (Q022ET00_OBSSU != null|| Q022ET00_OBSSU_MODIF == true) {

            try{

            prepStmt.setString(index,Q022ET00_OBSSU,pos);

            queryLog.append("Q022ET00_OBSSU" ).append( "=" ).append(Q022ET00_OBSSU).append( ",");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=22;

        if (Q022ET00_FADQ != null|| Q022ET00_FADQ_MODIF == true) {

            if (!Q02aSysdate.isSysdate(Q022ET00_FADQ)){

            try{

        if (Q022ET00_FADQ != null){

            queryLog.append(new java.sql.Timestamp(Q022ET00_FADQ.getTime())+ ",");

            prepStmt.setTimestamp(index,new java.sql.Timestamp(Q022ET00_FADQ.getTime()));

        }else{

            prepStmt.setNull(index,java.sql.Types.DATE);

            queryLog.append("Q022ET00_FADQ" ).append( "=" + null + ",");

            }}catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

            }

        }

        pos=23;

        if (Q022ET00_ENTI != null|| Q022ET00_ENTI_MODIF == true) {

            try{

        if (Q022ET00_ENTI != null){

            prepStmt.setLong(index,Q022ET00_ENTI.longValue());

            queryLog.append("Q022ET00_ENTI" ).append( "=" +Q022ET00_ENTI.longValue()).append( ",");

        }else{

            prepStmt.setNull(index,java.sql.Types.INTEGER);

            queryLog.append("Q022ET00_ENTI" ).append( "=" + null + ",");

            }}catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=24;

        if (Q022ET00_TVIA != null|| Q022ET00_TVIA_MODIF == true) {

            try{

            prepStmt.setString(index,Q022ET00_TVIA,pos);

            queryLog.append("Q022ET00_TVIA" ).append( "=" ).append(Q022ET00_TVIA).append( ",");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=25;

        if (Q022ET00_CALLE != null|| Q022ET00_CALLE_MODIF == true) {

            try{

        if (Q022ET00_CALLE != null){

            prepStmt.setLong(index,Q022ET00_CALLE.longValue());

            queryLog.append("Q022ET00_CALLE" ).append( "=" ).append(Q022ET00_CALLE.longValue()).append( ",");

        }else{

            prepStmt.setNull(index,java.sql.Types.INTEGER);

            queryLog.append("Q022ET00_CALLE" ).append( "=" + null + ",");

            }}catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=26;

        if (Q022ET00_POR_CL_POR != null|| Q022ET00_POR_CL_POR_MODIF == true) {

            try{

        if (Q022ET00_POR_CL_POR != null){

            prepStmt.setLong(index,Q022ET00_POR_CL_POR.longValue());

            queryLog.append("Q022ET00_POR_CL_POR" ).append( "=" ).append(Q022ET00_POR_CL_POR.longValue()).append( ",");

        }else{

            prepStmt.setNull(index,java.sql.Types.INTEGER);

            queryLog.append("Q022ET00_POR_CL_POR" ).append( "=" + null + ",");

            }}catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=27;

        if (Q022ET00_BLOQ != null|| Q022ET00_BLOQ_MODIF == true) {

            try{

            prepStmt.setString(index,Q022ET00_BLOQ,pos);

            queryLog.append("Q022ET00_BLOQ" ).append( "=" ).append(Q022ET00_BLOQ).append( ",");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=28;

        if (Q022ET00_NUME != null|| Q022ET00_NUME_MODIF == true) {

            try{

        if (Q022ET00_NUME != null){

            prepStmt.setInt(index,Q022ET00_NUME.intValue());

            queryLog.append("Q022ET00_NUME" ).append( "=" ).append(Q022ET00_NUME.intValue()).append( ",");

        }else{

            prepStmt.setNull(index,java.sql.Types.INTEGER);

            queryLog.append("Q022ET00_NUME" ).append( "=" + null + ",");

            }}catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=29;

        if (Q022ET00_BIS != null|| Q022ET00_BIS_MODIF == true) {

            try{

            prepStmt.setString(index,Q022ET00_BIS,pos);

            queryLog.append("Q022ET00_BIS" ).append( "=" ).append(Q022ET00_BIS).append( ",");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=30;

        if (Q022ET00_CDIR != null|| Q022ET00_CDIR_MODIF == true) {

            try{

            prepStmt.setString(index,Q022ET00_CDIR,pos);

            queryLog.append("Q022ET00_CDIR" ).append( "=" ).append(Q022ET00_CDIR).append( ",");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=31;

        if (Q022ET00_TIPADQ != null|| Q022ET00_TIPADQ_MODIF == true) {

            try{

            prepStmt.setString(index,Q022ET00_TIPADQ,pos);

            queryLog.append("Q022ET00_TIPADQ" ).append( "=" ).append(Q022ET00_TIPADQ).append( ",");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=32;

        if (Q022ET00_DX != null|| Q022ET00_DX_MODIF == true) {

            try{

        if (Q022ET00_DX != null){

            prepStmt.setDouble(index,Q022ET00_DX.doubleValue());

            queryLog.append("Q022ET00_DX" ).append( "=" ).append(Q022ET00_DX.doubleValue()).append( ",");

        }else{

            prepStmt.setNull(index,java.sql.Types.DOUBLE);

            queryLog.append("Q022ET00_DX" ).append( "=" + null + ",");

            }}catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=33;

        if (Q022ET00_DY != null|| Q022ET00_DY_MODIF == true) {

            try{

        if (Q022ET00_DY != null){

            prepStmt.setDouble(index,Q022ET00_DY.doubleValue());

            queryLog.append("Q022ET00_DY" ).append( "=" ).append(Q022ET00_DY.doubleValue()).append( ",");

        }else{

            prepStmt.setNull(index,java.sql.Types.DOUBLE);

            queryLog.append("Q022ET00_DY" ).append( "=" + null + ",");

            }}catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }
        pos=34;
        if (Q022ET00_DIR_NUEVA != null|| Q022ET00_DIR_NUEVA_MODIF == true) {
            try{
            prepStmt.setString(index,Q022ET00_DIR_NUEVA,pos);
            queryLog.append("Q022ET00_DIR_NUEVA" ).append( "=" ).append(Q022ET00_DIR_NUEVA).append( ",");
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }
        pos=35;
        if (Q022ET00_FUERA_PLAZO != null|| Q022ET00_FUERA_PLAZO_MODIF == true) {
            try{
            prepStmt.setString(index,Q022ET00_FUERA_PLAZO,pos);
            queryLog.append("Q022ET00_FUERA_PLAZO" ).append( "=" ).append(Q022ET00_FUERA_PLAZO).append( ",");
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }
        
        pos=36;
        if (Q022ET00_USU_MODIF != null|| Q022ET00_USU_MODIF_MODIF == true) {
            try{
            prepStmt.setString(index,Q022ET00_USU_MODIF,pos);
            queryLog.append("Q022ET00_USU_MODIF" ).append( "=" ).append(Q022ET00_USU_MODIF).append( ",");
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }
        
        queryLog.deleteCharAt(queryLog.toString().length()-1);

        queryLog.append(" where (");

        //pkCompletada=true;

        pos=1;
        pos=1;
        pos=1;
        if (Q022CT00_ID_GRUPO_WHERE != null) {
            try{
            prepStmt.setInt(index,Q022CT00_ID_GRUPO_WHERE.intValue());
            queryLog.append("Q022CT00_ID_GRUPO" ).append( "=" ).append(Q022CT00_ID_GRUPO_WHERE.intValue()).append( " AND ");
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }else{
            pkCompletada=false;
        }

        pos=2;
        pos=2;
        if (Q022ET00_ID_CUES_WHERE != null) {
            try{
            prepStmt.setLong(index,Q022ET00_ID_CUES_WHERE.longValue());
            queryLog.append("Q022ET00_ID_CUES" ).append( "=" ).append(Q022ET00_ID_CUES_WHERE.longValue()).append( " AND ");
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }else{
            pkCompletada=false;
        }

        pos=3;
        pos=3;
        if (Q022ET00_CLASU_WHERE != null &&  pkCompletada==false) {
            try{
            prepStmt.setString(index,Q022ET00_CLASU_WHERE,pos);
            queryLog.append("Q022ET00_CLASU" ).append( "=" ).append(Q022ET00_CLASU_WHERE).append( " AND ");
            }catch (java.sql.SQLException e){
               e.printStackTrace();
            }
            index=index+1;
        }

        pos=4;
        pos=4;
        if (Q022ET00_SUPSU_WHERE != null &&  pkCompletada==false) {
            try{
            prepStmt.setInt(index,Q022ET00_SUPSU_WHERE.intValue());
            queryLog.append("Q022ET00_SUPSU" ).append( "=" ).append(Q022ET00_SUPSU_WHERE.intValue()).append( " AND ");
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }

        pos=5;

        pos=5;

        if (Q022ET00_SUPTE_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setInt(index,Q022ET00_SUPTE_WHERE.intValue());

            queryLog.append("Q022ET00_SUPTE" ).append( "=" ).append(Q022ET00_SUPTE_WHERE.intValue()).append( " AND ");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=6;

        pos=6;

        if (Q022ET00_VALSU_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setDouble(index,Q022ET00_VALSU_WHERE.doubleValue());

            queryLog.append("Q022ET00_VALSU" ).append( "=" ).append(Q022ET00_VALSU_WHERE.doubleValue()).append( " AND ");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=7;

        pos=7;

        if (Q022ET00_NVPOG_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setInt(index,Q022ET00_NVPOG_WHERE.intValue());

            queryLog.append("Q022ET00_NVPOG" ).append( "=" ).append(Q022ET00_NVPOG_WHERE.intValue()).append( " AND ");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=8;

        pos=8;

        if (Q022ET00_NVPOE_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setInt(index,Q022ET00_NVPOE_WHERE.intValue());

            queryLog.append("Q022ET00_NVPOE" ).append( "=" ).append(Q022ET00_NVPOE_WHERE.intValue()).append( " AND ");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=9;

        pos=9;

        if (Q022ET00_NVTMG_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setInt(index,Q022ET00_NVTMG_WHERE.intValue());

            queryLog.append("Q022ET00_NVTMG" ).append( "=" ).append(Q022ET00_NVTMG_WHERE.intValue()).append( " AND ");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=10;

        pos=10;

        if (Q022ET00_NVTME_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setInt(index,Q022ET00_NVTME_WHERE.intValue());

            queryLog.append("Q022ET00_NVTME" ).append( "=" ).append(Q022ET00_NVTME_WHERE.intValue()).append( " AND ");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=11;

        pos=11;

        if (Q022ET00_NALOD_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setInt(index,Q022ET00_NALOD_WHERE.intValue());

            queryLog.append("Q022ET00_NALOD" ).append( "=" ).append(Q022ET00_NALOD_WHERE.intValue()).append( " AND ");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=12;

        pos=12;

        if (Q022ET00_NREAL_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setInt(index,Q022ET00_NREAL_WHERE.intValue());

            queryLog.append("Q022ET00_NREAL).append(=" ).append(Q022ET00_NREAL_WHERE.intValue()+ " AND ");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=13;

        pos=13;

        if (Q022ET00_NVTOT_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setInt(index,Q022ET00_NVTOT_WHERE.intValue());

            queryLog.append("Q022ET00_NVTOT).append(=" ).append(Q022ET00_NVTOT_WHERE.intValue()).append( " AND ");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=14;
        pos=14;

        if (Q022ET00_FEC_ALTA_WHERE != null &&  pkCompletada==false) {
            try{
        if (Q022ET00_FEC_ALTA_WHERE != null){
            prepStmt.setTimestamp(index,new java.sql.Timestamp(Q022ET00_FEC_ALTA_WHERE.getTime()));
            queryLog.append("Q022ET00_FEC_ALTA"  + "=" + new java.sql.Timestamp(Q022ET00_FEC_ALTA_WHERE.getTime())+ " AND ");
        }else{
            queryLog.append("Q022ET00_FEC_ALTA"  + "=" + null+ " AND ");
            prepStmt.setNull(index,java.sql.Types.DATE);
        }
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }

        pos=15;
        pos=15;
        if (Q022ET00_FEC_MOD_WHERE != null &&  pkCompletada==false) {
            try{
                    if (Q022ET00_FEC_MOD_WHERE != null){
                        prepStmt.setTimestamp(index,new java.sql.Timestamp(Q022ET00_FEC_MOD_WHERE.getTime()));
                        queryLog.append("Q022ET00_FEC_MOD"  + "=" + new java.sql.Timestamp(Q022ET00_FEC_MOD_WHERE.getTime())+ " AND ");
                    }else{
                        queryLog.append("Q022ET00_FEC_MOD"  + "=" + null+ " AND ");
                        prepStmt.setNull(index,java.sql.Types.DATE);
                    }
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }

        pos=16;
        pos=16;
        if (Q022ET00_FEC_BAJA_WHERE != null &&  pkCompletada==false) {
            try{
                    if (Q022ET00_FEC_BAJA_WHERE != null){
                        prepStmt.setTimestamp(index,new java.sql.Timestamp(Q022ET00_FEC_BAJA_WHERE.getTime()));
                        queryLog.append("Q022ET00_FEC_BAJA"  + "=" + new java.sql.Timestamp(Q022ET00_FEC_BAJA_WHERE.getTime())+ " AND ");
                    }else{
                        queryLog.append("Q022ET00_FEC_BAJA"  + "=" + null+ " AND ");
                        prepStmt.setNull(index,java.sql.Types.DATE);
                    }
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }

        pos=17;
        pos=17;
        if (Q022ET00_FIRMADO_WHERE != null &&  pkCompletada==false) {
            try{
            prepStmt.setInt(index,Q022ET00_FIRMADO_WHERE.intValue());
            queryLog.append("Q022ET00_FIRMADO).append(=" ).append(Q022ET00_FIRMADO_WHERE.intValue()).append( " AND ");
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }

        pos=18;

        pos=18;

        if (Q022ET00_CDEXP_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setString(index,Q022ET00_CDEXP_WHERE,pos);

            queryLog.append("Q022ET00_CDEXP" ).append( "=" ).append(Q022ET00_CDEXP_WHERE).append( " AND ");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=19;

        pos=19;

        if (Q022ET00_NVPOT_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setInt(index,Q022ET00_NVPOT_WHERE.intValue());

            queryLog.append("Q022ET00_NVPOT" ).append( "=" ).append(Q022ET00_NVPOT_WHERE.intValue()).append( " AND ");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=20;

        pos=20;

        if (Q022ET00_NLIBRE_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setInt(index,Q022ET00_NLIBRE_WHERE.intValue());

            queryLog.append("Q022ET00_NLIBRE" ).append( "=" ).append(Q022ET00_NLIBRE_WHERE.intValue()).append( " AND ");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=21;

        pos=21;

        if (Q022ET00_OBSSU_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setString(index,Q022ET00_OBSSU_WHERE,pos);

            queryLog.append("Q022ET00_OBSSU" ).append( "=" ).append(Q022ET00_OBSSU_WHERE).append( " AND ");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=22;

        pos=22;

        if (Q022ET00_FADQ_WHERE != null &&  pkCompletada==false) {

            try{

        if (Q022ET00_FADQ_WHERE != null){

            prepStmt.setTimestamp(index,new java.sql.Timestamp(Q022ET00_FADQ_WHERE.getTime()));

            queryLog.append("Q022ET00_FADQ"  + "=" + new java.sql.Timestamp(Q022ET00_FADQ_WHERE.getTime())+ " AND ");

        }else{

            queryLog.append("Q022ET00_FADQ"  + "=" + null+ " AND ");

            prepStmt.setNull(index,java.sql.Types.DATE);

        }

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=23;

        pos=23;

        if (Q022ET00_ENTI_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setLong(index,Q022ET00_ENTI_WHERE.longValue());

            queryLog.append("Q022ET00_ENTI" ).append( "=" ).append(Q022ET00_ENTI_WHERE.longValue()).append( " AND ");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=24;

        pos=24;

        if (Q022ET00_TVIA_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setString(index,Q022ET00_TVIA_WHERE,pos);

            queryLog.append("Q022ET00_TVIA" ).append( "=" ).append(Q022ET00_TVIA_WHERE).append( " AND ");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=25;

        pos=25;

        if (Q022ET00_CALLE_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setLong(index,Q022ET00_CALLE_WHERE.longValue());

            queryLog.append("Q022ET00_CALLE" ).append( "=" ).append(Q022ET00_CALLE_WHERE.longValue()).append( " AND ");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=26;

        pos=26;

        if (Q022ET00_POR_CL_POR_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setLong(index,Q022ET00_POR_CL_POR_WHERE.longValue());

            queryLog.append("Q022ET00_POR_CL_POR" ).append( "=" ).append(Q022ET00_POR_CL_POR_WHERE.longValue()).append( " AND ");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=27;

        pos=27;

        if (Q022ET00_BLOQ_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setString(index,Q022ET00_BLOQ_WHERE,pos);

            queryLog.append("Q022ET00_BLOQ" ).append( "=" ).append(Q022ET00_BLOQ_WHERE).append( " AND ");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=28;

        pos=28;

        if (Q022ET00_NUME_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setInt(index,Q022ET00_NUME_WHERE.intValue());

            queryLog.append("Q022ET00_NUME" ).append( "=" ).append(Q022ET00_NUME_WHERE.intValue()).append( " AND ");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=29;

        pos=29;

        if (Q022ET00_BIS_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setString(index,Q022ET00_BIS_WHERE,pos);

            queryLog.append("Q022ET00_BIS" ).append( "=" ).append(Q022ET00_BIS_WHERE).append( " AND ");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=30;
        pos=30;
        if (Q022ET00_CDIR_WHERE != null &&  pkCompletada==false) {
            try{
            prepStmt.setString(index,Q022ET00_CDIR_WHERE,pos);
            queryLog.append("Q022ET00_CDIR" ).append( "=" ).append(Q022ET00_CDIR_WHERE).append( " AND ");
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }

        pos=31;
        pos=31;
        if (Q022ET00_TIPADQ_WHERE != null &&  pkCompletada==false) {
            try{
            prepStmt.setString(index,Q022ET00_TIPADQ_WHERE,pos);
            queryLog.append("Q022ET00_TIPADQ" ).append( "=" ).append(Q022ET00_TIPADQ_WHERE).append( " AND ");
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }

        pos=32;
        pos=32;
        if (Q022ET00_DX_WHERE != null &&  pkCompletada==false) {
            try{
            prepStmt.setDouble(index,Q022ET00_DX_WHERE.doubleValue());
            queryLog.append("Q022ET00_DX" ).append( "=" ).append(Q022ET00_DX_WHERE.doubleValue()).append( " AND ");
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }

        pos=33;
        pos=33;
        if (Q022ET00_DY_WHERE != null &&  pkCompletada==false) {
            try{
            prepStmt.setDouble(index,Q022ET00_DY_WHERE.doubleValue());
            queryLog.append("Q022ET00_DY" ).append( "=" ).append(Q022ET00_DY_WHERE.doubleValue()).append( " AND ");
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }

        pos=34;
        pos=34;
        if (Q022ET00_DIR_NUEVA_WHERE != null &&  pkCompletada==false) {
            try{
            prepStmt.setString(index,Q022ET00_DIR_NUEVA_WHERE,pos);
            queryLog.append("Q022ET00_DIR_NUEVA" ).append( "=" ).append(Q022ET00_DIR_NUEVA_WHERE).append( " AND ");
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }
        
        pos=35;
        pos=35;
        if (Q022ET00_FUERA_PLAZO_WHERE != null &&  pkCompletada==false) {
            try{
            prepStmt.setString(index,Q022ET00_FUERA_PLAZO_WHERE,pos);
            queryLog.append("Q022ET00_FUERA_PLAZO" ).append( "=" ).append(Q022ET00_FUERA_PLAZO_WHERE).append( " AND ");
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }
        
        pos=36;
        pos=36;
        if (Q022ET00_USU_MODIF_WHERE != null &&  pkCompletada==false) {
            try{
            prepStmt.setString(index,Q022ET00_USU_MODIF_WHERE,pos);
            queryLog.append("Q022ET00_USU_MODIF" ).append( "=" ).append(Q022ET00_USU_MODIF_WHERE).append( " AND ");
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }
        //////////////////////////////////////////////////////

        if (queryLog.toString().endsWith("AND ")){
        	queryLog.delete(queryLog.toString().length()-4,queryLog.toString().length());
        }
        if ((this.getAditionalWhere() != null) && (!this.getAditionalWhere().equals(""))) {
            if (subquery2!=null && !subquery2.toString().equals("")){
                query.append(" where ");
                queryLog.append(" where ");
            }else{
                query.append(" and ");
                queryLog.append(" and ");
            }

            query.append( this.getAditionalWhere());
            queryLog.append( this.getAditionalWhere());

        }

        queryLog.append(")");

            tr.trace(COMPONENTE,Q70TraceLevel.INFO, "0:" + queryLog.toString());
            //System.out.println( "-- // SM " + queryLog.toString() + " // --");
            
        this.regModif=prepStmt.executeUpdate();

        prepStmt.close();

        if (tr.isTraceActive()) {
            mensaje = new StringBuffer();
            mensaje.append(name);
            mensaje.append(" Ending:");
            mensaje.append(" update");
            tr.trace(COMPONENTE,Q70TraceLevel.DEBUG,mensaje.toString());
        }

    }



    /** Method update(where) 
    * @param where New value of property WHERE.
    * @throws SQLException SQLException
     */

    public void update(String  where )throws SQLException  {

    Connection con = null;

        String name = (this.getClass()).getName();

        StringBuffer mensaje = new StringBuffer();

        queryLog = new StringBuffer();

        long user = 0;

        if (tr.isTraceActive()) {
            mensaje.append(name);
            mensaje.append(" Beginning:");
            mensaje.append(" update");
            tr.trace(COMPONENTE,Q70TraceLevel.DEBUG,mensaje.toString());
        }

        con=this.getConnection();

        StringBuffer query = new StringBuffer();
        StringBuffer subquery1 = new StringBuffer();

        query.append("UPDATE Q022ES00 ");

        boolean and = false;

        if (Q022CT00_ID_GRUPO != null || this.Q022CT00_ID_GRUPO_MODIF==true) {
            if (and) {
            subquery1.append(" ,");
            }
            subquery1.append("Q022CT00_ID_GRUPO=?");
            and = true;
        }

        if (Q022ET00_ID_CUES != null || this.Q022ET00_ID_CUES_MODIF==true) {
            if (and) {
            subquery1.append(" ,");
            }
            subquery1.append("Q022ET00_ID_CUES=?");
            and = true;
        }

        if (Q022ET00_CLASU != null || this.Q022ET00_CLASU_MODIF==true) {
            if (and) {
            subquery1.append(" ,");
            }
            subquery1.append("Q022ET00_CLASU=?");
            and = true;
        }

            if (Q022ET00_SUPSU != null || this.Q022ET00_SUPSU_MODIF==true) {

            if (and) {

            subquery1.append(" ,");

            }

            subquery1.append("Q022ET00_SUPSU=?");

            and = true;

        }

            if (Q022ET00_SUPTE != null || this.Q022ET00_SUPTE_MODIF==true) {

            if (and) {

            subquery1.append(" ,");

            }

            subquery1.append("Q022ET00_SUPTE=?");

            and = true;

        }

            if (Q022ET00_VALSU != null || this.Q022ET00_VALSU_MODIF==true) {

            if (and) {

            subquery1.append(" ,");

            }

            subquery1.append("Q022ET00_VALSU=?");

            and = true;

        }

            if (Q022ET00_NVPOG != null || this.Q022ET00_NVPOG_MODIF==true) {

            if (and) {

            subquery1.append(" ,");

            }

            subquery1.append("Q022ET00_NVPOG=?");

            and = true;

        }

            if (Q022ET00_NVPOE != null || this.Q022ET00_NVPOE_MODIF==true) {

            if (and) {

            subquery1.append(" ,");

            }

            subquery1.append("Q022ET00_NVPOE=?");

            and = true;

        }

            if (Q022ET00_NVTMG != null || this.Q022ET00_NVTMG_MODIF==true) {

            if (and) {

            subquery1.append(" ,");

            }

            subquery1.append("Q022ET00_NVTMG=?");

            and = true;

        }

            if (Q022ET00_NVTME != null || this.Q022ET00_NVTME_MODIF==true) {

            if (and) {

            subquery1.append(" ,");

            }

            subquery1.append("Q022ET00_NVTME=?");

            and = true;

        }

            if (Q022ET00_NALOD != null || this.Q022ET00_NALOD_MODIF==true) {

            if (and) {

            subquery1.append(" ,");

            }

            subquery1.append("Q022ET00_NALOD=?");

            and = true;

        }

            if (Q022ET00_NREAL != null || this.Q022ET00_NREAL_MODIF==true) {

            if (and) {

            subquery1.append(" ,");

            }

            subquery1.append("Q022ET00_NREAL=?");

            and = true;

        }

            if (Q022ET00_NVTOT != null || this.Q022ET00_NVTOT_MODIF==true) {

            if (and) {

            subquery1.append(" ,");

            }

            subquery1.append("Q022ET00_NVTOT=?");

            and = true;

        }

            if (Q02aSysdate.isSysdate(Q022ET00_FEC_ALTA)){

            if (and) {

            subquery1.append(" ,");

            }

            subquery1.append("Q022ET00_FEC_ALTA=sysdate");

            and = true;

            }else {

            if (Q022ET00_FEC_ALTA != null || this.Q022ET00_FEC_ALTA_MODIF==true) {

            if (and) {

            subquery1.append(" ,");

            }

            subquery1.append("Q022ET00_FEC_ALTA=?");

            and = true;

        }

        }

            if (Q02aSysdate.isSysdate(Q022ET00_FEC_MOD)){

            if (and) {

            subquery1.append(" ,");

            }

            subquery1.append("Q022ET00_FEC_MOD=sysdate");

            and = true;

            }else {

            if (Q022ET00_FEC_MOD != null || this.Q022ET00_FEC_MOD_MODIF==true) {

            if (and) {

            subquery1.append(" ,");

            }

            subquery1.append("Q022ET00_FEC_MOD=?");

            and = true;

        }

        }

            if (Q02aSysdate.isSysdate(Q022ET00_FEC_BAJA)){

            if (and) {

            subquery1.append(" ,");

            }

            subquery1.append("Q022ET00_FEC_BAJA=sysdate");

            and = true;

            }else {

            if (Q022ET00_FEC_BAJA != null || this.Q022ET00_FEC_BAJA_MODIF==true) {

            if (and) {

            subquery1.append(" ,");

            }

            subquery1.append("Q022ET00_FEC_BAJA=?");

            and = true;

        }

        }

            if (Q022ET00_FIRMADO != null || this.Q022ET00_FIRMADO_MODIF==true) {

            if (and) {

            subquery1.append(" ,");

            }

            subquery1.append("Q022ET00_FIRMADO=?");

            and = true;

        }

            if (Q022ET00_CDEXP != null || this.Q022ET00_CDEXP_MODIF==true) {

            if (and) {

            subquery1.append(" ,");

            }

            subquery1.append("Q022ET00_CDEXP=?");

            and = true;

        }

            if (Q022ET00_NVPOT != null || this.Q022ET00_NVPOT_MODIF==true) {

            if (and) {

            subquery1.append(" ,");

            }

            subquery1.append("Q022ET00_NVPOT=?");

            and = true;

        }

            if (Q022ET00_NLIBRE != null || this.Q022ET00_NLIBRE_MODIF==true) {

            if (and) {

            subquery1.append(" ,");

            }

            subquery1.append("Q022ET00_NLIBRE=?");

            and = true;

        }

            if (Q022ET00_OBSSU != null || this.Q022ET00_OBSSU_MODIF==true) {

            if (and) {

            subquery1.append(" ,");

            }

            subquery1.append("Q022ET00_OBSSU=?");

            and = true;

        }

            if (Q02aSysdate.isSysdate(Q022ET00_FADQ)){

            if (and) {

            subquery1.append(" ,");

            }

            subquery1.append("Q022ET00_FADQ=sysdate");

            and = true;

            }else {

            if (Q022ET00_FADQ != null || this.Q022ET00_FADQ_MODIF==true) {

            if (and) {

            subquery1.append(" ,");

            }

            subquery1.append("Q022ET00_FADQ=?");

            and = true;

        }

        }

            if (Q022ET00_ENTI != null || this.Q022ET00_ENTI_MODIF==true) {

            if (and) {

            subquery1.append(" ,");

            }

            subquery1.append("Q022ET00_ENTI=?");

            and = true;

        }

            if (Q022ET00_TVIA != null || this.Q022ET00_TVIA_MODIF==true) {

            if (and) {

            subquery1.append(" ,");

            }

            subquery1.append("Q022ET00_TVIA=?");

            and = true;

        }

            if (Q022ET00_CALLE != null || this.Q022ET00_CALLE_MODIF==true) {

            if (and) {

            subquery1.append(" ,");

            }

            subquery1.append("Q022ET00_CALLE=?");

            and = true;

        }

            if (Q022ET00_POR_CL_POR != null || this.Q022ET00_POR_CL_POR_MODIF==true) {

            if (and) {

            subquery1.append(" ,");

            }

            subquery1.append("Q022ET00_POR_CL_POR=?");

            and = true;

        }

            if (Q022ET00_BLOQ != null || this.Q022ET00_BLOQ_MODIF==true) {

            if (and) {

            subquery1.append(" ,");

            }

            subquery1.append("Q022ET00_BLOQ=?");

            and = true;

        }

            if (Q022ET00_NUME != null || this.Q022ET00_NUME_MODIF==true) {

            if (and) {

            subquery1.append(" ,");

            }

            subquery1.append("Q022ET00_NUME=?");

            and = true;

        }

            if (Q022ET00_BIS != null || this.Q022ET00_BIS_MODIF==true) {

            if (and) {

            subquery1.append(" ,");

            }

            subquery1.append("Q022ET00_BIS=?");

            and = true;

        }

            if (Q022ET00_CDIR != null || this.Q022ET00_CDIR_MODIF==true) {

            if (and) {

            subquery1.append(" ,");

            }

            subquery1.append("Q022ET00_CDIR=?");

            and = true;

        }

            if (Q022ET00_TIPADQ != null || this.Q022ET00_TIPADQ_MODIF==true) {

            if (and) {

            subquery1.append(" ,");

            }

            subquery1.append("Q022ET00_TIPADQ=?");
            and = true;
        }

        if (Q022ET00_DX != null || this.Q022ET00_DX_MODIF==true) {
            if (and) {
                subquery1.append(" ,");
            }
            subquery1.append("Q022ET00_DX=?");
            and = true;
        }

        if (Q022ET00_DY != null || this.Q022ET00_DY_MODIF==true) {
            if (and) {
                subquery1.append(" ,");
            }
            subquery1.append("Q022ET00_DY=?");
            and = true;
        }

        if (Q022ET00_DIR_NUEVA != null || this.Q022ET00_DIR_NUEVA_MODIF==true) {
            if (and) {
                subquery1.append(" ,");
            }
            subquery1.append("Q022ET00_DIR_NUEVA=?");
            and = true;
        }
        
        if (Q022ET00_FUERA_PLAZO != null || this.Q022ET00_FUERA_PLAZO_MODIF==true) {
            if (and) {
                subquery1.append(" ,");
            }
            subquery1.append("Q022ET00_FUERA_PLAZO=?");
            and = true;
        }

        if (Q022ET00_USU_MODIF != null || this.Q022ET00_USU_MODIF_MODIF==true) {
            if (and) {
                subquery1.append(" ,");
            }
            subquery1.append("Q022ET00_USU_MODIF=?");
            and = true;
        }
        //////////
        
        if (subquery1 != null) {
            query.append(" set ");
            query.append(subquery1.toString());
        }

        if ((where != null) && (!where.equals(""))) {
            query.append("where ");
            query.append(where);
            queryLog=query;
            tr.trace(COMPONENTE,Q70TraceLevel.INFO,query.toString());
        }

        PreparedStatement prepStmt = con.prepareStatement(query.toString());

        int index=1;

        if (Q022CT00_ID_GRUPO != null|| Q022CT00_ID_GRUPO_MODIF == true) {

            try{

        if (Q022CT00_ID_GRUPO != null){

            prepStmt.setInt(index,Q022CT00_ID_GRUPO.intValue());

        }else{

            prepStmt.setNull(index,java.sql.Types.INTEGER);
        }
            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        if (Q022ET00_ID_CUES != null|| Q022ET00_ID_CUES_MODIF == true) {

            try{

        if (Q022ET00_ID_CUES != null){

            prepStmt.setLong(index,Q022ET00_ID_CUES.longValue());

        }else{

            prepStmt.setNull(index,java.sql.Types.INTEGER);
        }
            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        if (Q022ET00_CLASU != null|| Q022ET00_CLASU_MODIF == true) {

            try{

            prepStmt.setString(index,Q022ET00_CLASU);

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        if (Q022ET00_SUPSU != null|| Q022ET00_SUPSU_MODIF == true) {

            try{

        if (Q022ET00_SUPSU != null){

            prepStmt.setInt(index,Q022ET00_SUPSU.intValue());

        }else{

            prepStmt.setNull(index,java.sql.Types.INTEGER);
        }
            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        if (Q022ET00_SUPTE != null|| Q022ET00_SUPTE_MODIF == true) {

            try{

        if (Q022ET00_SUPTE != null){

            prepStmt.setInt(index,Q022ET00_SUPTE.intValue());

        }else{

            prepStmt.setNull(index,java.sql.Types.INTEGER);
        }
            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        if (Q022ET00_VALSU != null|| Q022ET00_VALSU_MODIF == true) {

            try{

        if (Q022ET00_VALSU != null){

            prepStmt.setDouble(index,Q022ET00_VALSU.doubleValue());

        }else{

            prepStmt.setNull(index,java.sql.Types.DOUBLE);
        }
            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        if (Q022ET00_NVPOG != null|| Q022ET00_NVPOG_MODIF == true) {

            try{

        if (Q022ET00_NVPOG != null){

            prepStmt.setInt(index,Q022ET00_NVPOG.intValue());

        }else{

            prepStmt.setNull(index,java.sql.Types.INTEGER);
        }
            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        if (Q022ET00_NVPOE != null|| Q022ET00_NVPOE_MODIF == true) {

            try{

        if (Q022ET00_NVPOE != null){

            prepStmt.setInt(index,Q022ET00_NVPOE.intValue());

        }else{

            prepStmt.setNull(index,java.sql.Types.INTEGER);
        }
            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        if (Q022ET00_NVTMG != null|| Q022ET00_NVTMG_MODIF == true) {

            try{

        if (Q022ET00_NVTMG != null){

            prepStmt.setInt(index,Q022ET00_NVTMG.intValue());

        }else{

            prepStmt.setNull(index,java.sql.Types.INTEGER);
        }
            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        if (Q022ET00_NVTME != null|| Q022ET00_NVTME_MODIF == true) {

            try{

        if (Q022ET00_NVTME != null){

            prepStmt.setInt(index,Q022ET00_NVTME.intValue());

        }else{

            prepStmt.setNull(index,java.sql.Types.INTEGER);
        }
            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        if (Q022ET00_NALOD != null|| Q022ET00_NALOD_MODIF == true) {

            try{

        if (Q022ET00_NALOD != null){

            prepStmt.setInt(index,Q022ET00_NALOD.intValue());

        }else{

            prepStmt.setNull(index,java.sql.Types.INTEGER);
        }
            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        if (Q022ET00_NREAL != null|| Q022ET00_NREAL_MODIF == true) {

            try{

        if (Q022ET00_NREAL != null){

            prepStmt.setInt(index,Q022ET00_NREAL.intValue());

        }else{

            prepStmt.setNull(index,java.sql.Types.INTEGER);
        }
            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        if (Q022ET00_NVTOT != null|| Q022ET00_NVTOT_MODIF == true) {

            try{

        if (Q022ET00_NVTOT != null){

            prepStmt.setInt(index,Q022ET00_NVTOT.intValue());

        }else{

            prepStmt.setNull(index,java.sql.Types.INTEGER);
        }
            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        if (Q022ET00_FEC_ALTA != null|| Q022ET00_FEC_ALTA_MODIF == true) {

            try{

        if (Q022ET00_FEC_ALTA != null){

            prepStmt.setTimestamp(index,new java.sql.Timestamp(Q022ET00_FEC_ALTA.getTime()));

        }else{

            prepStmt.setNull(index,java.sql.Types.DATE);
        }
            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        if (Q022ET00_FEC_MOD != null|| Q022ET00_FEC_MOD_MODIF == true) {

            try{

        if (Q022ET00_FEC_MOD != null){

            prepStmt.setTimestamp(index,new java.sql.Timestamp(Q022ET00_FEC_MOD.getTime()));

        }else{

            prepStmt.setNull(index,java.sql.Types.DATE);
        }
            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        if (Q022ET00_FEC_BAJA != null|| Q022ET00_FEC_BAJA_MODIF == true) {

            try{

        if (Q022ET00_FEC_BAJA != null){

            prepStmt.setTimestamp(index,new java.sql.Timestamp(Q022ET00_FEC_BAJA.getTime()));

        }else{

            prepStmt.setNull(index,java.sql.Types.DATE);
        }
            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        if (Q022ET00_FIRMADO != null|| Q022ET00_FIRMADO_MODIF == true) {

            try{

        if (Q022ET00_FIRMADO != null){

            prepStmt.setInt(index,Q022ET00_FIRMADO.intValue());

        }else{

            prepStmt.setNull(index,java.sql.Types.INTEGER);
        }
            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        if (Q022ET00_CDEXP != null|| Q022ET00_CDEXP_MODIF == true) {

            try{

            prepStmt.setString(index,Q022ET00_CDEXP);

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        if (Q022ET00_NVPOT != null|| Q022ET00_NVPOT_MODIF == true) {

            try{

        if (Q022ET00_NVPOT != null){

            prepStmt.setInt(index,Q022ET00_NVPOT.intValue());

        }else{

            prepStmt.setNull(index,java.sql.Types.INTEGER);
        }
            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        if (Q022ET00_NLIBRE != null|| Q022ET00_NLIBRE_MODIF == true) {

            try{

        if (Q022ET00_NLIBRE != null){

            prepStmt.setInt(index,Q022ET00_NLIBRE.intValue());

        }else{

            prepStmt.setNull(index,java.sql.Types.INTEGER);
        }
            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        if (Q022ET00_OBSSU != null|| Q022ET00_OBSSU_MODIF == true) {

            try{

            prepStmt.setString(index,Q022ET00_OBSSU);

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        if (Q022ET00_FADQ != null|| Q022ET00_FADQ_MODIF == true) {

            try{

        if (Q022ET00_FADQ != null){

            prepStmt.setTimestamp(index,new java.sql.Timestamp(Q022ET00_FADQ.getTime()));

        }else{

            prepStmt.setNull(index,java.sql.Types.DATE);
        }
            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        if (Q022ET00_ENTI != null|| Q022ET00_ENTI_MODIF == true) {

            try{

        if (Q022ET00_ENTI != null){

            prepStmt.setLong(index,Q022ET00_ENTI.longValue());

        }else{

            prepStmt.setNull(index,java.sql.Types.INTEGER);
        }
            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        if (Q022ET00_TVIA != null|| Q022ET00_TVIA_MODIF == true) {

            try{

            prepStmt.setString(index,Q022ET00_TVIA);

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        if (Q022ET00_CALLE != null|| Q022ET00_CALLE_MODIF == true) {

            try{

        if (Q022ET00_CALLE != null){

            prepStmt.setLong(index,Q022ET00_CALLE.longValue());

        }else{

            prepStmt.setNull(index,java.sql.Types.INTEGER);
        }
            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        if (Q022ET00_POR_CL_POR != null|| Q022ET00_POR_CL_POR_MODIF == true) {

            try{

        if (Q022ET00_POR_CL_POR != null){

            prepStmt.setLong(index,Q022ET00_POR_CL_POR.longValue());

        }else{

            prepStmt.setNull(index,java.sql.Types.INTEGER);
        }
            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        if (Q022ET00_BLOQ != null|| Q022ET00_BLOQ_MODIF == true) {

            try{

            prepStmt.setString(index,Q022ET00_BLOQ);

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        if (Q022ET00_NUME != null|| Q022ET00_NUME_MODIF == true) {

            try{

        if (Q022ET00_NUME != null){

            prepStmt.setInt(index,Q022ET00_NUME.intValue());

        }else{

            prepStmt.setNull(index,java.sql.Types.INTEGER);
        }
            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        if (Q022ET00_BIS != null|| Q022ET00_BIS_MODIF == true) {

            try{

            prepStmt.setString(index,Q022ET00_BIS);

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        if (Q022ET00_CDIR != null|| Q022ET00_CDIR_MODIF == true) {

            try{

            prepStmt.setString(index,Q022ET00_CDIR);

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        if (Q022ET00_TIPADQ != null|| Q022ET00_TIPADQ_MODIF == true) {

            try{

            prepStmt.setString(index,Q022ET00_TIPADQ);

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        if (Q022ET00_DX != null|| Q022ET00_DX_MODIF == true) {

            try{

        if (Q022ET00_DX != null){

            prepStmt.setDouble(index,Q022ET00_DX.doubleValue());

        }else{

            prepStmt.setNull(index,java.sql.Types.DOUBLE);
        }
            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        if (Q022ET00_DY != null|| Q022ET00_DY_MODIF == true) {

            try{

        if (Q022ET00_DY != null){

            prepStmt.setDouble(index,Q022ET00_DY.doubleValue());

        }else{

            prepStmt.setNull(index,java.sql.Types.DOUBLE);
        }
            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        if (Q022ET00_DIR_NUEVA != null|| Q022ET00_DIR_NUEVA_MODIF == true) {
            try{
            prepStmt.setString(index,Q022ET00_DIR_NUEVA);
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }
        
        if (Q022ET00_FUERA_PLAZO != null|| Q022ET00_FUERA_PLAZO_MODIF == true) {
            try{
            prepStmt.setString(index,Q022ET00_FUERA_PLAZO);
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }
                
        if (Q022ET00_USU_MODIF != null|| Q022ET00_USU_MODIF_MODIF == true) {
            try{
            prepStmt.setString(index,Q022ET00_USU_MODIF);
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }
        //////////////////////////////////////////////////////
        
        

        if ((this.getAditionalWhere() != null) && (!this.getAditionalWhere().equals(""))) {
            if (where!=null && !where.equals("")){
                query.append(" where ");
                queryLog.append(" where ");
            }else{
                query.append(" and ");
                queryLog.append(" and ");
            }
                query.append( this.getAditionalWhere());
                queryLog.append( this.getAditionalWhere());
        }

        tr.trace(COMPONENTE,Q70TraceLevel.INFO, "0:" + queryLog.toString());

        this.regModif=prepStmt.executeUpdate();

        prepStmt.close();

        if (tr.isTraceActive()) {
            mensaje = new StringBuffer();
            mensaje.append(name);
            mensaje.append(" Ending:");
            mensaje.append(" update");

            tr.trace(COMPONENTE,Q70TraceLevel.DEBUG,mensaje.toString());
        }
    }



    /** Method delete(where) 

    * @param where New value of property WHERE.
    * @throws SQLException SQLException
    */

    public void delete(String where)throws SQLException  {

    Connection con = null;

        String name = (this.getClass()).getName();

        queryLog = new StringBuffer();

        StringBuffer mensaje = new StringBuffer();

        long user = 0;

        if (tr.isTraceActive()) {
            mensaje.append(name);
            mensaje.append(" Beginning:");
            mensaje.append(" delete");
            tr.trace(COMPONENTE,Q70TraceLevel.DEBUG,mensaje.toString());
        }

        con=this.getConnection();

        StringBuffer query = new StringBuffer();

        query.append("DELETE  from Q022ES00 ");

        if ((where != null) && (!where.equals(""))) {
            query.append("where ");
            query.append(where);
            queryLog=query;
            tr.trace(COMPONENTE,Q70TraceLevel.INFO, "0:" + queryLog.toString());
        }

        PreparedStatement prepStmt1 = con.prepareStatement(query.toString());
        this.regModif=prepStmt1.executeUpdate();
        prepStmt1.close();

        if (tr.isTraceActive()) {
            mensaje = new StringBuffer();
            mensaje.append(name);
            mensaje.append(" Ending:");
            mensaje.append(" delete");

            tr.trace(COMPONENTE,Q70TraceLevel.DEBUG,mensaje.toString());
        }

    }



    /** Method delete 
     * @throws SQLException SQLException
    * 
     * */

    public void delete()throws SQLException  {

        Connection con = null;
        String name = (this.getClass()).getName();
        StringBuffer mensaje = new StringBuffer();

        long user = 0;

        if (tr.isTraceActive()) {
            mensaje.append(name);
            mensaje.append(" Beginning:");
            mensaje.append(" delete");
            tr.trace(COMPONENTE,Q70TraceLevel.DEBUG,mensaje.toString());
        }

        con=this.getConnection();

        StringBuffer query = new StringBuffer();
        StringBuffer subquery2 = new StringBuffer();

         queryLog = new StringBuffer();

        query.append("DELETE from Q022ES00 ");

        queryLog.append("DELETE from Q022ES00 ");

        boolean pkCompletada=false;

        boolean and = false;

        if (Q022CT00_ID_GRUPO_WHERE != null) {
            pkCompletada=true;
            if (and) {
                subquery2.append(" AND ");
            }
            subquery2.append("Q022CT00_ID_GRUPO=?");
            and = true;
        }else{
            pkCompletada=false;
        }

        if (Q022ET00_ID_CUES_WHERE != null) {
            pkCompletada=true;
            if (and) {
                subquery2.append(" AND ");
            }
            subquery2.append("Q022ET00_ID_CUES=?");
            and = true;
        }else{
            pkCompletada=false;
        }

        if (Q022ET00_CLASU_WHERE != null &&  pkCompletada==false) {
            if (and) {
                subquery2.append(" AND ");
            }
            subquery2.append("Q022ET00_CLASU=?");
            and = true;
        }

        if (Q022ET00_SUPSU_WHERE != null &&  pkCompletada==false) {
            if (and) {
                subquery2.append(" AND ");
            }
            subquery2.append("Q022ET00_SUPSU=?");
            and = true;
        }

        if (Q022ET00_SUPTE_WHERE != null &&  pkCompletada==false) {
            if (and) {
                subquery2.append(" AND ");
            }
            subquery2.append("Q022ET00_SUPTE=?");
            and = true;
        }

        if (Q022ET00_VALSU_WHERE != null &&  pkCompletada==false) {
            if (and) {
                subquery2.append(" AND ");
            }
            subquery2.append("Q022ET00_VALSU=?");
            and = true;
        }

        if (Q022ET00_NVPOG_WHERE != null &&  pkCompletada==false) {
            if (and) {
                subquery2.append(" AND ");
            }
            subquery2.append("Q022ET00_NVPOG=?");
            and = true;
        }

        if (Q022ET00_NVPOE_WHERE != null &&  pkCompletada==false) {
            if (and) {
                subquery2.append(" AND ");
            }
            subquery2.append("Q022ET00_NVPOE=?");
            and = true;
        }

        if (Q022ET00_NVTMG_WHERE != null &&  pkCompletada==false) {
            if (and) {
                subquery2.append(" AND ");
            }
            subquery2.append("Q022ET00_NVTMG=?");
            and = true;
        }

        if (Q022ET00_NVTME_WHERE != null &&  pkCompletada==false) {
            if (and) {
                subquery2.append(" AND ");
            }
            subquery2.append("Q022ET00_NVTME=?");
            and = true;
        }

        if (Q022ET00_NALOD_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_NALOD=?");

            and = true;

        }

        if (Q022ET00_NREAL_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_NREAL=?");

            and = true;

        }

        if (Q022ET00_NVTOT_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_NVTOT=?");

            and = true;

        }

        if (Q022ET00_FEC_ALTA_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_FEC_ALTA=?");

            and = true;

        }

        if (Q022ET00_FEC_MOD_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_FEC_MOD=?");

            and = true;

        }

        if (Q022ET00_FEC_BAJA_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_FEC_BAJA=?");

            and = true;

        }

        if (Q022ET00_FIRMADO_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_FIRMADO=?");

            and = true;

        }

        if (Q022ET00_CDEXP_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_CDEXP=?");

            and = true;

        }

        if (Q022ET00_NVPOT_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_NVPOT=?");

            and = true;

        }

        if (Q022ET00_NLIBRE_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_NLIBRE=?");

            and = true;

        }

        if (Q022ET00_OBSSU_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_OBSSU=?");

            and = true;

        }

        if (Q022ET00_FADQ_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_FADQ=?");

            and = true;

        }

        if (Q022ET00_ENTI_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_ENTI=?");

            and = true;

        }

        if (Q022ET00_TVIA_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_TVIA=?");

            and = true;

        }

        if (Q022ET00_CALLE_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_CALLE=?");

            and = true;

        }

        if (Q022ET00_POR_CL_POR_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_POR_CL_POR=?");

            and = true;

        }

        if (Q022ET00_BLOQ_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_BLOQ=?");

            and = true;

        }

        if (Q022ET00_NUME_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_NUME=?");

            and = true;

        }

        if (Q022ET00_BIS_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_BIS=?");

            and = true;

        }

        if (Q022ET00_CDIR_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_CDIR=?");

            and = true;

        }

        if (Q022ET00_TIPADQ_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_TIPADQ=?");

            and = true;

        }

        if (Q022ET00_DX_WHERE != null &&  pkCompletada==false) {

            if (and) {

                subquery2.append(" AND ");

            }

            subquery2.append("Q022ET00_DX=?");

            and = true;

        }

        if (Q022ET00_DY_WHERE != null &&  pkCompletada==false) {
            if (and) {
                subquery2.append(" AND ");
            }
            subquery2.append("Q022ET00_DY=?");
            and = true;
        }

        if (Q022ET00_DIR_NUEVA_WHERE != null &&  pkCompletada==false) {
            if (and) {
                subquery2.append(" AND ");
            }
            subquery2.append("Q022ET00_DIR_NUEVA=?");
            and = true;
        }
        
        if (Q022ET00_FUERA_PLAZO_WHERE != null &&  pkCompletada==false) {
            if (and) {
                subquery2.append(" AND ");
            }
            subquery2.append("Q022ET00_FUERA_PLAZO=?");
            and = true;
        }
        
        if (Q022ET00_USU_ALTA_WHERE != null &&  pkCompletada==false) {
            if (and) {
                subquery2.append(" AND ");
            }
            subquery2.append("Q022ET00_USU_ALTA=?");
            and = true;
        }
        
        if (Q022ET00_USU_MODIF_WHERE != null &&  pkCompletada==false) {
            if (and) {
                subquery2.append(" AND ");
            }
            subquery2.append("Q022ET00_USU_MODIF=?");
            and = true;
        }
        
        
        ///////////////////
        

        if (subquery2 != null) {
            query.append("where ");
            queryLog.append("where ");
            query.append(subquery2.toString());
            tr.trace(COMPONENTE,Q70TraceLevel.INFO,query.toString());
        }

        PreparedStatement prepStmt1 = con.prepareStatement(query.toString());

        Q02aSpacePreparedStatement prepStmt = new Q02aSpacePreparedStatement(tipos,longitudes,prepStmt1);

        int index=1;
        int pos=1;

        pos=1;
        if (Q022CT00_ID_GRUPO_WHERE != null) {
            pkCompletada=true;
            try{
            prepStmt.setInt(index,Q022CT00_ID_GRUPO_WHERE.intValue());
            queryLog.append("Q022CT00_ID_GRUPO" ).append( "=" ).append(Q022CT00_ID_GRUPO_WHERE.intValue()).append( " AND ");
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }else{
            pkCompletada=false;
        }

        pos=2;
        if (Q022ET00_ID_CUES_WHERE != null) {
            pkCompletada=true;
            try{
            prepStmt.setLong(index,Q022ET00_ID_CUES_WHERE.longValue());
            queryLog.append("Q022ET00_ID_CUES" ).append( "=" ).append(Q022ET00_ID_CUES_WHERE.longValue()).append(  " AND ");
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }else{
            pkCompletada=false;
        }

        pos=3;
        if (Q022ET00_CLASU_WHERE != null &&  pkCompletada==false) {
            try{
            prepStmt.setString(index,Q022ET00_CLASU_WHERE,pos);
            queryLog.append("Q022ET00_CLASU" ).append( "=" ).append(Q022ET00_CLASU_WHERE).append( " AND ");
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }

        pos=4;
        if (Q022ET00_SUPSU_WHERE != null &&  pkCompletada==false) {
            try{
            prepStmt.setInt(index,Q022ET00_SUPSU_WHERE.intValue());
            queryLog.append("Q022ET00_SUPSU" ).append( "=" ).append(Q022ET00_SUPSU_WHERE.intValue()).append( " AND ");
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }

        pos=5;
        if (Q022ET00_SUPTE_WHERE != null &&  pkCompletada==false) {
            try{
            prepStmt.setInt(index,Q022ET00_SUPTE_WHERE.intValue());
            queryLog.append("Q022ET00_SUPTE").append( "=" ).append(Q022ET00_SUPTE_WHERE.intValue()).append( " AND ");
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }

        pos=6;
        if (Q022ET00_VALSU_WHERE != null &&  pkCompletada==false) {
            try{
            prepStmt.setDouble(index,Q022ET00_VALSU_WHERE.doubleValue());
            queryLog.append("Q022ET00_VALSU").append( "=" ).append(Q022ET00_VALSU_WHERE.doubleValue()).append( " AND ");
            }catch (java.sql.SQLException e){
               e.printStackTrace();
            }
            index=index+1;
        }

        pos=7;
        if (Q022ET00_NVPOG_WHERE != null &&  pkCompletada==false) {
            try{
            prepStmt.setInt(index,Q022ET00_NVPOG_WHERE.intValue());
            queryLog.append("Q022ET00_NVPOG").append( "=" ).append(Q022ET00_NVPOG_WHERE.intValue()).append( " AND ");
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }

        pos=8;
        if (Q022ET00_NVPOE_WHERE != null &&  pkCompletada==false) {
            try{
            prepStmt.setInt(index,Q022ET00_NVPOE_WHERE.intValue());
            queryLog.append("Q022ET00_NVPOE").append( "=" ).append(Q022ET00_NVPOE_WHERE.intValue()).append( " AND ");
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }

        pos=9;
        if (Q022ET00_NVTMG_WHERE != null &&  pkCompletada==false) {
            try{
            prepStmt.setInt(index,Q022ET00_NVTMG_WHERE.intValue());
            queryLog.append("Q022ET00_NVTMG").append( "=" ).append(Q022ET00_NVTMG_WHERE.intValue()).append( " AND ");
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }

        pos=10;
        if (Q022ET00_NVTME_WHERE != null &&  pkCompletada==false) {
            try{
            prepStmt.setInt(index,Q022ET00_NVTME_WHERE.intValue());
            queryLog.append("Q022ET00_NVTME").append( "=" ).append(Q022ET00_NVTME_WHERE.intValue()).append( " AND ");
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }

        pos=11;
        if (Q022ET00_NALOD_WHERE != null &&  pkCompletada==false) {
            try{
            prepStmt.setInt(index,Q022ET00_NALOD_WHERE.intValue());
            queryLog.append("Q022ET00_NALOD").append( "=" ).append(Q022ET00_NALOD_WHERE.intValue()).append( " AND ");
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }

        pos=12;
        if (Q022ET00_NREAL_WHERE != null &&  pkCompletada==false) {
            try{
            prepStmt.setInt(index,Q022ET00_NREAL_WHERE.intValue());
            queryLog.append("Q022ET00_NREAL").append( "=" ).append(Q022ET00_NREAL_WHERE.intValue()).append( " AND ");
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }

        pos=13;
        if (Q022ET00_NVTOT_WHERE != null &&  pkCompletada==false) {
            try{
            prepStmt.setInt(index,Q022ET00_NVTOT_WHERE.intValue());
            queryLog.append("Q022ET00_NVTOT").append( "=" ).append(Q022ET00_NVTOT_WHERE.intValue()).append( " AND ");
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }

        pos=14;
        if (Q022ET00_FEC_ALTA_WHERE != null &&  pkCompletada==false) {
            try{
            prepStmt.setTimestamp(index,new java.sql.Timestamp(Q022ET00_FEC_ALTA_WHERE.getTime()));
            queryLog.append("Q022ET00_FEC_ALTA"  ).append( "=" + new java.sql.Timestamp(Q022ET00_FEC_ALTA_WHERE.getTime())).append( " AND ");
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }

        pos=15;
        if (Q022ET00_FEC_MOD_WHERE != null &&  pkCompletada==false) {
            try{
            prepStmt.setTimestamp(index,new java.sql.Timestamp(Q022ET00_FEC_MOD_WHERE.getTime()));
            queryLog.append("Q022ET00_FEC_MOD"  ).append( "=" + new java.sql.Timestamp(Q022ET00_FEC_MOD_WHERE.getTime())).append( " AND ");
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }

        pos=16;

        if (Q022ET00_FEC_BAJA_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setTimestamp(index,new java.sql.Timestamp(Q022ET00_FEC_BAJA_WHERE.getTime()));

            queryLog.append("Q022ET00_FEC_BAJA"  ).append( "=" + new java.sql.Timestamp(Q022ET00_FEC_BAJA_WHERE.getTime())).append( " AND ");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=17;

        if (Q022ET00_FIRMADO_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setInt(index,Q022ET00_FIRMADO_WHERE.intValue());

            queryLog.append("Q022ET00_FIRMADO").append( "=" ).append(Q022ET00_FIRMADO_WHERE.intValue()).append( " AND ");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=18;

        if (Q022ET00_CDEXP_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setString(index,Q022ET00_CDEXP_WHERE,pos);

            queryLog.append("Q022ET00_CDEXP").append( "=" ).append(Q022ET00_CDEXP_WHERE).append( " AND ");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=19;

        if (Q022ET00_NVPOT_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setInt(index,Q022ET00_NVPOT_WHERE.intValue());

            queryLog.append("Q022ET00_NVPOT").append( "=" ).append(Q022ET00_NVPOT_WHERE.intValue()).append( " AND ");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=20;

        if (Q022ET00_NLIBRE_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setInt(index,Q022ET00_NLIBRE_WHERE.intValue());

            queryLog.append("Q022ET00_NLIBRE").append( "=" ).append(Q022ET00_NLIBRE_WHERE.intValue()).append( " AND ");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=21;

        if (Q022ET00_OBSSU_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setString(index,Q022ET00_OBSSU_WHERE,pos);

            queryLog.append("Q022ET00_OBSSU").append( "=" ).append(Q022ET00_OBSSU_WHERE).append( " AND ");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=22;

        if (Q022ET00_FADQ_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setTimestamp(index,new java.sql.Timestamp(Q022ET00_FADQ_WHERE.getTime()));

            queryLog.append("Q022ET00_FADQ"  ).append( "=" + new java.sql.Timestamp(Q022ET00_FADQ_WHERE.getTime())).append( " AND ");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=23;

        if (Q022ET00_ENTI_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setLong(index,Q022ET00_ENTI_WHERE.longValue());

            queryLog.append("Q022ET00_ENTI").append( "=" ).append(Q022ET00_ENTI_WHERE.longValue()).append(  " AND ");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=24;

        if (Q022ET00_TVIA_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setString(index,Q022ET00_TVIA_WHERE,pos);

            queryLog.append("Q022ET00_TVIA").append( "=" ).append(Q022ET00_TVIA_WHERE).append( " AND ");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=25;

        if (Q022ET00_CALLE_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setLong(index,Q022ET00_CALLE_WHERE.longValue());

            queryLog.append("Q022ET00_CALLE").append( "=" ).append(Q022ET00_CALLE_WHERE.longValue()).append(  " AND ");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=26;

        if (Q022ET00_POR_CL_POR_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setLong(index,Q022ET00_POR_CL_POR_WHERE.longValue());

            queryLog.append("Q022ET00_POR_CL_POR").append( "=" ).append(Q022ET00_POR_CL_POR_WHERE.longValue()).append(  " AND ");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=27;

        if (Q022ET00_BLOQ_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setString(index,Q022ET00_BLOQ_WHERE,pos);

            queryLog.append("Q022ET00_BLOQ").append( "=" ).append(Q022ET00_BLOQ_WHERE).append( " AND ");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=28;

        if (Q022ET00_NUME_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setInt(index,Q022ET00_NUME_WHERE.intValue());

            queryLog.append("Q022ET00_NUME").append( "=" ).append(Q022ET00_NUME_WHERE.intValue()).append( " AND ");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=29;

        if (Q022ET00_BIS_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setString(index,Q022ET00_BIS_WHERE,pos);

            queryLog.append("Q022ET00_BIS").append( "=" ).append(Q022ET00_BIS_WHERE).append( " AND ");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=30;

        if (Q022ET00_CDIR_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setString(index,Q022ET00_CDIR_WHERE,pos);

            queryLog.append("Q022ET00_CDIR").append( "=" ).append(Q022ET00_CDIR_WHERE).append( " AND ");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=31;

        if (Q022ET00_TIPADQ_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setString(index,Q022ET00_TIPADQ_WHERE,pos);

            queryLog.append("Q022ET00_TIPADQ").append( "=" ).append(Q022ET00_TIPADQ_WHERE).append( " AND ");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=32;

        if (Q022ET00_DX_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setDouble(index,Q022ET00_DX_WHERE.doubleValue());

            queryLog.append("Q022ET00_DX").append( "=" ).append(Q022ET00_DX_WHERE.doubleValue()).append( " AND ");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=33;

        if (Q022ET00_DY_WHERE != null &&  pkCompletada==false) {

            try{

            prepStmt.setDouble(index,Q022ET00_DY_WHERE.doubleValue());

            queryLog.append("Q022ET00_DY").append( "=" ).append(Q022ET00_DY_WHERE.doubleValue()).append( " AND ");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

        }

        pos=34;
        if (Q022ET00_DIR_NUEVA_WHERE != null &&  pkCompletada==false) {
            try{
            prepStmt.setString(index,Q022ET00_DIR_NUEVA_WHERE,pos);
            queryLog.append("Q022ET00_DIR_NUEVA").append( "=" ).append(Q022ET00_DIR_NUEVA_WHERE).append( " AND ");
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }
        
        pos=35;
        if (Q022ET00_FUERA_PLAZO_WHERE != null &&  pkCompletada==false) {
            try{
            prepStmt.setString(index,Q022ET00_FUERA_PLAZO_WHERE,pos);
            queryLog.append("Q022ET00_FUERA_PLAZO").append( "=" ).append(Q022ET00_FUERA_PLAZO_WHERE).append( " AND ");
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }
        
        pos=36;
        if (Q022ET00_USU_ALTA_WHERE != null &&  pkCompletada==false) {
            try{
            prepStmt.setString(index,Q022ET00_FUERA_PLAZO_WHERE,pos);
            queryLog.append("Q022ET00_USU_ALTA").append( "=" ).append(Q022ET00_USU_ALTA_WHERE).append( " AND ");
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }
        
        pos=37;
        if (Q022ET00_USU_MODIF_WHERE != null &&  pkCompletada==false) {
            try{
            prepStmt.setString(index,Q022ET00_FUERA_PLAZO_WHERE,pos);
            queryLog.append("Q022ET00_USU_MODIF").append( "=" ).append(Q022ET00_USU_MODIF_WHERE).append( " AND ");
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;
        }
        

        queryLog.delete(queryLog.toString().length()-4,queryLog.toString().length());

        queryLog.append(")");

            tr.trace(COMPONENTE,Q70TraceLevel.INFO, "0:" + queryLog.toString());

        this.regModif=prepStmt.executeUpdate();

        prepStmt.close();

        if (tr.isTraceActive()) {
            mensaje = new StringBuffer();
            mensaje.append(name);
            mensaje.append(" Ending:");
            mensaje.append(" delete");
            tr.trace(COMPONENTE,Q70TraceLevel.DEBUG,mensaje.toString());
        }

    }



    /** Method insert 
     * @throws SQLException SQLException
    * 
     * */

    public void insert()throws SQLException  {

        Connection con = null;
        String name = (this.getClass()).getName();
        StringBuffer mensaje = new StringBuffer();
        long user = 0;

        if (tr.isTraceActive()) {
            mensaje.append(name);
            mensaje.append(" Beginning:");
            mensaje.append(" insert");
            tr.trace(COMPONENTE,Q70TraceLevel.DEBUG,mensaje.toString());
        }

        con=this.getConnection();

        StringBuffer query = new StringBuffer();

        //variable para la sentencia de log
        queryLog = new StringBuffer();

        String commentInsertQ022CT00_ID_GRUPO = null;

        if (Q022CT00_ID_GRUPO == null && commentInsertQ022CT00_ID_GRUPO == null ) {
                NullPointerException e = new NullPointerException();
                String msgError = e.getMessage();
                name = (this.getClass()).getName();
                mensaje = new StringBuffer();
                mensaje.append(name);
                mensaje.append("Q022CT00_ID_GRUPO ");
                mensaje.append(msgError);
                mensaje.append(" Failed:");
                mensaje.append(" insert");
                tr.trace(COMPONENTE,Q70TraceLevel.ERROR,mensaje.toString());
                throw new NullPointerException();
        }

        String commentInsertQ022ET00_ID_CUES = null;

        if (Q022ET00_ID_CUES == null && commentInsertQ022ET00_ID_CUES == null ) {
            NullPointerException e = new NullPointerException();
            String msgError = e.getMessage();
            name = (this.getClass()).getName();
            mensaje = new StringBuffer();
            mensaje.append(name);
            mensaje.append("Q022ET00_ID_CUES ");
            mensaje.append(msgError);
            mensaje.append(" Failed:");
            mensaje.append(" insert");
            tr.trace(COMPONENTE,Q70TraceLevel.ERROR,mensaje.toString());
            throw new NullPointerException();
        }

        String commentInsertQ022ET00_CLASU = null;
        String commentInsertQ022ET00_SUPSU = null;
        String commentInsertQ022ET00_SUPTE = null;
        String commentInsertQ022ET00_VALSU = null;
        String commentInsertQ022ET00_NVPOG = null;
        String commentInsertQ022ET00_NVPOE = null;
        String commentInsertQ022ET00_NVTMG = null;
        String commentInsertQ022ET00_NVTME = null;
        String commentInsertQ022ET00_NALOD = null;
        String commentInsertQ022ET00_NREAL = null;
        String commentInsertQ022ET00_NVTOT = null;
        String commentInsertQ022ET00_FEC_MOD = null;
        String commentInsertQ022ET00_FEC_BAJA = null;
        String commentInsertQ022ET00_FIRMADO = null;
        String commentInsertQ022ET00_CDEXP = null;
        String commentInsertQ022ET00_NVPOT = null;
        String commentInsertQ022ET00_NLIBRE = null;
        String commentInsertQ022ET00_OBSSU = null;
        String commentInsertQ022ET00_FADQ = null;
        String commentInsertQ022ET00_ENTI = null;
        String commentInsertQ022ET00_TVIA = null;
        String commentInsertQ022ET00_CALLE = null;
        String commentInsertQ022ET00_POR_CL_POR = null;
        String commentInsertQ022ET00_BLOQ = null;
        String commentInsertQ022ET00_NUME = null;
        String commentInsertQ022ET00_BIS = null;
        String commentInsertQ022ET00_CDIR = null;
        String commentInsertQ022ET00_TIPADQ = null;
        String commentInsertQ022ET00_DX = null;
        String commentInsertQ022ET00_DY = null;
        String commentInsertQ022ET00_DIR_NUEVA = null;
        String commentInsertQ022ET00_FUERA_PLAZO = null;
        String commentInsertQ022ET00_USU_ALTA = null;
        String commentInsertQ022ET00_USU_MODIF = null;
        

        query.append("INSERT into Q022ES00 (Q022CT00_ID_GRUPO,Q022ET00_ID_CUES,Q022ET00_CLASU,Q022ET00_SUPSU,Q022ET00_SUPTE,Q022ET00_VALSU,Q022ET00_NVPOG,Q022ET00_NVPOE,Q022ET00_NVTMG,Q022ET00_NVTME,Q022ET00_NALOD,Q022ET00_NREAL,Q022ET00_NVTOT,Q022ET00_FEC_ALTA,Q022ET00_FEC_MOD,Q022ET00_FEC_BAJA,Q022ET00_FIRMADO,Q022ET00_CDEXP,Q022ET00_NVPOT,Q022ET00_NLIBRE,Q022ET00_OBSSU,Q022ET00_FADQ,Q022ET00_ENTI,Q022ET00_TVIA,Q022ET00_CALLE,Q022ET00_POR_CL_POR,Q022ET00_BLOQ,Q022ET00_NUME,Q022ET00_BIS,Q022ET00_CDIR,Q022ET00_TIPADQ,Q022ET00_DX,Q022ET00_DY,Q022ET00_DIR_NUEVA,Q022ET00_FUERA_PLAZO, Q022ET00_USU_ALTA ) values (?,?,?,?,?,?,?,?,?,?,?,?,?,sysdate,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        queryLog.append("INSERT into Q022ES00 (Q022CT00_ID_GRUPO,Q022ET00_ID_CUES,Q022ET00_CLASU,Q022ET00_SUPSU,Q022ET00_SUPTE,Q022ET00_VALSU,Q022ET00_NVPOG,Q022ET00_NVPOE,Q022ET00_NVTMG,Q022ET00_NVTME,Q022ET00_NALOD,Q022ET00_NREAL,Q022ET00_NVTOT,Q022ET00_FEC_ALTA,Q022ET00_FEC_MOD,Q022ET00_FEC_BAJA,Q022ET00_FIRMADO,Q022ET00_CDEXP,Q022ET00_NVPOT,Q022ET00_NLIBRE,Q022ET00_OBSSU,Q022ET00_FADQ,Q022ET00_ENTI,Q022ET00_TVIA,Q022ET00_CALLE,Q022ET00_POR_CL_POR,Q022ET00_BLOQ,Q022ET00_NUME,Q022ET00_BIS,Q022ET00_CDIR,Q022ET00_TIPADQ,Q022ET00_DX,Q022ET00_DY,Q022ET00_DIR_NUEVA,Q022ET00_FUERA_PLAZO, Q022ET00_USU_ALTA) values (");

        PreparedStatement prepStmt = con.prepareStatement(query.toString());

        int index=1;
            try{
                if (Q022CT00_ID_GRUPO != null){
                    prepStmt.setInt(index,Q022CT00_ID_GRUPO.intValue());
                    queryLog.append(Q022CT00_ID_GRUPO.intValue()).append( ",");
                }else{
                    prepStmt.setNull(index,java.sql.Types.INTEGER);
                    queryLog.append("null").append( ",");
                }
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }

            index=index+1;
            try{
                if (Q022ET00_ID_CUES != null){
                    prepStmt.setLong(index,Q022ET00_ID_CUES.longValue());
                    queryLog.append(Q022ET00_ID_CUES.longValue()).append( ",");
                }else{
                    prepStmt.setNull(index,java.sql.Types.INTEGER);
                    queryLog.append("null").append( ",");
                }
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }

            index=index+1;
            try{
                prepStmt.setString(index,Q022ET00_CLASU);
                queryLog.append(Q022ET00_CLASU+ ",");
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }

            index=index+1;
            try{

                if (Q022ET00_SUPSU != null){
                    prepStmt.setInt(index,Q022ET00_SUPSU.intValue());
                    queryLog.append(Q022ET00_SUPSU.intValue()).append( ",");
                }else{
                    prepStmt.setNull(index,java.sql.Types.INTEGER);
                    queryLog.append("null").append( ",");
                }
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }

            index=index+1;
            try{
                if (Q022ET00_SUPTE != null){
                    prepStmt.setInt(index,Q022ET00_SUPTE.intValue());
                    queryLog.append(Q022ET00_SUPTE.intValue()).append( ",");
                }else{
                    prepStmt.setNull(index,java.sql.Types.INTEGER);
                    queryLog.append("null").append( ",");
                }
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }

            index=index+1;
            try{
                if (Q022ET00_VALSU != null){
                    prepStmt.setDouble(index,Q022ET00_VALSU.doubleValue());
                    queryLog.append(Q022ET00_VALSU.doubleValue()).append( ",");
                }else{
                    prepStmt.setNull(index,java.sql.Types.DOUBLE);
                    queryLog.append("null").append( ",");
                }
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            
            index=index+1;
            try{
                if (Q022ET00_NVPOG != null){
                    prepStmt.setInt(index,Q022ET00_NVPOG.intValue());
                    queryLog.append(Q022ET00_NVPOG.intValue()).append( ",");
                }else{
                    prepStmt.setNull(index,java.sql.Types.INTEGER);
                    queryLog.append("null").append( ",");
                }
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }

            index=index+1;
            try{
                if (Q022ET00_NVPOE != null){
                    prepStmt.setInt(index,Q022ET00_NVPOE.intValue());
                    queryLog.append(Q022ET00_NVPOE.intValue()).append( ",");
                }else{
                    prepStmt.setNull(index,java.sql.Types.INTEGER);
                    queryLog.append("null").append( ",");
                }
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }

            index=index+1;
            try{
                if (Q022ET00_NVTMG != null){
                    prepStmt.setInt(index,Q022ET00_NVTMG.intValue());
                    queryLog.append(Q022ET00_NVTMG.intValue()).append( ",");
                }else{
                    prepStmt.setNull(index,java.sql.Types.INTEGER);
                    queryLog.append("null").append( ",");
                }
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }

            index=index+1;
            try{
            if (Q022ET00_NVTME != null){
                prepStmt.setInt(index,Q022ET00_NVTME.intValue());
                queryLog.append(Q022ET00_NVTME.intValue()).append( ",");
            }else{
            prepStmt.setNull(index,java.sql.Types.INTEGER);
            queryLog.append("null").append( ",");
            }}catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;

            try{
            if (Q022ET00_NALOD != null){
                prepStmt.setInt(index,Q022ET00_NALOD.intValue());
                queryLog.append(Q022ET00_NALOD.intValue()).append( ",");
            }else{
            prepStmt.setNull(index,java.sql.Types.INTEGER);
            queryLog.append("null").append( ",");
            }}catch (java.sql.SQLException e){
                e.printStackTrace();
            }

            index=index+1;
            try{
        if (Q022ET00_NREAL != null){
            prepStmt.setInt(index,Q022ET00_NREAL.intValue());
            queryLog.append(Q022ET00_NREAL.intValue()).append( ",");
        }else{
            prepStmt.setNull(index,java.sql.Types.INTEGER);
            queryLog.append("null").append( ",");
            }}catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;

        try{
        if (Q022ET00_NVTOT != null){
            prepStmt.setInt(index,Q022ET00_NVTOT.intValue());
            queryLog.append(Q022ET00_NVTOT.intValue()).append( ",");
        }else{
            prepStmt.setNull(index,java.sql.Types.INTEGER);
            queryLog.append("null").append( ",");
            }}catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;

            try{
        if (Q022ET00_FEC_MOD != null){
            queryLog.append(new java.sql.Timestamp(Q022ET00_FEC_MOD.getTime())).append( ",");
            prepStmt.setTimestamp(index,new java.sql.Timestamp(Q022ET00_FEC_MOD.getTime()));
        }else{
            prepStmt.setNull(index,java.sql.Types.DATE);
            queryLog.append("null").append( ",");
            }}catch (java.sql.SQLException e){
                e.printStackTrace();
            }
            index=index+1;

            try{
        if (Q022ET00_FEC_BAJA != null){
            queryLog.append(new java.sql.Timestamp(Q022ET00_FEC_BAJA.getTime())).append( ",");
            prepStmt.setTimestamp(index,new java.sql.Timestamp(Q022ET00_FEC_BAJA.getTime()));
        }else{
            prepStmt.setNull(index,java.sql.Types.DATE);
            queryLog.append("null").append( ",");
            }}catch (java.sql.SQLException e){
                e.printStackTrace();
            }

            index=index+1;

            try{

        if (Q022ET00_FIRMADO != null){

            prepStmt.setInt(index,Q022ET00_FIRMADO.intValue());

            queryLog.append(Q022ET00_FIRMADO.intValue()).append( ",");

        }else{

            prepStmt.setNull(index,java.sql.Types.INTEGER);

            queryLog.append("null").append( ",");

            }}catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

            try{

            prepStmt.setString(index,Q022ET00_CDEXP);

            queryLog.append(Q022ET00_CDEXP).append( ",");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

            try{

        if (Q022ET00_NVPOT != null){

            prepStmt.setInt(index,Q022ET00_NVPOT.intValue());

            queryLog.append(Q022ET00_NVPOT.intValue()).append( ",");

        }else{

            prepStmt.setNull(index,java.sql.Types.INTEGER);

            queryLog.append("null").append( ",");

            }}catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

            try{

        if (Q022ET00_NLIBRE != null){

            prepStmt.setInt(index,Q022ET00_NLIBRE.intValue());

            queryLog.append(Q022ET00_NLIBRE.intValue()).append( ",");

        }else{

            prepStmt.setNull(index,java.sql.Types.INTEGER);

            queryLog.append("null").append( ",");

            }}catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

            try{

            prepStmt.setString(index,Q022ET00_OBSSU);

            queryLog.append(Q022ET00_OBSSU).append( ",");

            }catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

            try{

        if (Q022ET00_FADQ != null){

            queryLog.append(new java.sql.Timestamp(Q022ET00_FADQ.getTime())).append( ",");

            prepStmt.setTimestamp(index,new java.sql.Timestamp(Q022ET00_FADQ.getTime()));

        }else{

            prepStmt.setNull(index,java.sql.Types.DATE);

            queryLog.append("null").append( ",");

            }}catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;

            try{

        if (Q022ET00_ENTI != null){

            prepStmt.setLong(index,Q022ET00_ENTI.longValue());

            queryLog.append(Q022ET00_ENTI.longValue()).append( ",");

        }else{

            prepStmt.setNull(index,java.sql.Types.INTEGER);

            queryLog.append("null").append( ",");

            }}catch (java.sql.SQLException e){

                e.printStackTrace();

            }

            index=index+1;
            try{
                prepStmt.setString(index,Q022ET00_TVIA);
                queryLog.append(Q022ET00_TVIA).append( ",");
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }

            index=index+1;
            try{
                if (Q022ET00_CALLE != null){
                    prepStmt.setLong(index,Q022ET00_CALLE.longValue());
                    queryLog.append(Q022ET00_CALLE.longValue()).append( ",");
                }else{
                prepStmt.setNull(index,java.sql.Types.INTEGER);
                queryLog.append("null").append( ",");
                }
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }

            index=index+1;
            try{
                if (Q022ET00_POR_CL_POR != null){
                    prepStmt.setLong(index,Q022ET00_POR_CL_POR.longValue());
                    queryLog.append(Q022ET00_POR_CL_POR.longValue()).append( ",");
                }else{
                prepStmt.setNull(index,java.sql.Types.INTEGER);
                queryLog.append("null").append( ",");
                }
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }

            index=index+1;
            try{
            prepStmt.setString(index,Q022ET00_BLOQ);
            queryLog.append(Q022ET00_BLOQ+ ",");
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }

            index=index+1;
            try{
                if (Q022ET00_NUME != null){
                    prepStmt.setInt(index,Q022ET00_NUME.intValue());
                    queryLog.append(Q022ET00_NUME.intValue()+ ",");
                }else{
                    prepStmt.setNull(index,java.sql.Types.INTEGER);
                    queryLog.append("null").append( ",");
                }
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }

            index=index+1;
            try{
            prepStmt.setString(index,Q022ET00_BIS);
            queryLog.append(Q022ET00_BIS+ ",");
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }

            index=index+1;
            try{
            prepStmt.setString(index,Q022ET00_CDIR);
            queryLog.append(Q022ET00_CDIR+ ",");
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }

            index=index+1;
            try{
                prepStmt.setString(index,Q022ET00_TIPADQ);
                queryLog.append(Q022ET00_TIPADQ+ ",");
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }

            index=index+1;
            try{
                if (Q022ET00_DX != null){
                    prepStmt.setDouble(index,Q022ET00_DX.doubleValue());
                    queryLog.append(Q022ET00_DX.doubleValue()+ ",");
                }else{
                prepStmt.setNull(index,java.sql.Types.DOUBLE);
                queryLog.append("null").append( ",");
                }
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }

            index=index+1;
            try{
                if (Q022ET00_DY != null){
                    prepStmt.setDouble(index,Q022ET00_DY.doubleValue());
                    queryLog.append(Q022ET00_DY.doubleValue()+ ",");
                }else{
                    prepStmt.setNull(index,java.sql.Types.DOUBLE);
                    queryLog.append("null").append( ",");
                }
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }

            index=index+1;
            try{
                prepStmt.setString(index,Q022ET00_DIR_NUEVA);
                queryLog.append(Q022ET00_DIR_NUEVA+ ",");
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }

            index=index+1;
            try{
                prepStmt.setString(index,Q022ET00_FUERA_PLAZO);
                queryLog.append(Q022ET00_FUERA_PLAZO+ ",");
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }

            index=index+1;            
            try{
                prepStmt.setString(index,Q022ET00_USU_ALTA);
                queryLog.append(Q022ET00_USU_ALTA+ ",");
            }catch (java.sql.SQLException e){
                e.printStackTrace();
            }

            index=index+1;
            
            
        queryLog.deleteCharAt(queryLog.toString().length()-1);

        queryLog.append(")");

            tr.trace(COMPONENTE,Q70TraceLevel.INFO, "0:" + queryLog.toString());
            //System.out.println( "--" +  queryLog.toString() + "--");
        this.regModif=prepStmt.executeUpdate();

        prepStmt.close();

        if (tr.isTraceActive()) {
            mensaje = new StringBuffer();
            mensaje.append(name);
            mensaje.append(" Ending:");
            mensaje.append(" insert");
            tr.trace(COMPONENTE,Q70TraceLevel.DEBUG,mensaje.toString());
        }

    }

    /** Getter for property idConexion.
    * @return Value of property idConexion.
    */

    public String getIdConexion() {

           return idConexion;

    }



    /** Getter for property Conexion.

    * @return Value of property Conexion.

    */

    public Connection getConn() {

           return connection;

    }



    /** Method addColumnSelect(nombreColumna) 
    * @param nombreColumna New value of property columnasSelect.
    * Este mtodo aade una nueva columna a mostrar en el resultado de la select
    * Aadir las columnas usando las constantes de la tabla
    */

    public void addColumnSelect(String nombreColumna) {

        while (nombreColumna.endsWith(" ")) {
            nombreColumna = nombreColumna.substring(0, nombreColumna.length()-1);
          }
        while (nombreColumna.startsWith(" ")) {
            nombreColumna = nombreColumna.substring(1, nombreColumna.length());
          }
        if (nombreColumna.lastIndexOf(" ")!=-1){
            this.alias.add(nombreColumna.substring(nombreColumna.lastIndexOf(" ")+1).trim());
            this.columnasSelect.add(nombreColumna.substring(0,nombreColumna.lastIndexOf(" ")).trim());
        }else{
            this.columnasSelect.add(nombreColumna.trim());
        }
    }

    /** Method clearColumnsSelect() 
    * Este mtodo vacia el ArrayList con los nombres de las columnas sobre los q hacer la select
    */
    public void clearColumnsSelect() {
        this.columnasSelect.clear();
    }

    /** Method setColumnsSelect(listaColumnas) 
    * Este mtodo da valor al ArrayList con los nombres de las columnas sobre los q hacer la select
    * @param listaColumnas listaColumnas
    */
    public void setColumnsSelect(String listaColumnas) {
        this.clearColumnsSelect();
        java.util.StringTokenizer token1 = new java.util.StringTokenizer(listaColumnas,",");
        String columna=token1.nextToken();
        while (columna.endsWith(" ")) {
            columna = columna.substring(0, columna.length()-1);
          }
        while (columna.startsWith(" ")) {
            columna = columna.substring(1, columna.length());
          }
        if (columna.lastIndexOf(" ")!=-1){
            this.alias.add(columna.substring(columna.lastIndexOf(" ")).trim());
            this.columnasSelect.add(columna.substring(0,columna.lastIndexOf(" ")).trim());
        }else{
            this.columnasSelect.add(columna);
        }
        while (token1.hasMoreTokens()){
          columna=token1.nextToken();
        while (columna.endsWith(" ")) {
            columna = columna.substring(0, columna.length()-1);
          }
        while (columna.startsWith(" ")) {
            columna = columna.substring(1, columna.length());
          }
          if (columna.lastIndexOf(" ")!=-1){
            this.alias.add(columna.substring(columna.lastIndexOf(" ")+1).trim());
            this.columnasSelect.add(columna.substring(0,columna.lastIndexOf(" ")).trim());
          }else{
            this.columnasSelect.add(columna.trim());
          }
    }
    }

    /** Method getColumnsSelect() 
    * Este mtodo devuelve un String con los nombres de las columnas sobres las q hacer la
    * select separadas por comas.
    * @return columnasTotal
    */

    public String getColumnsSelect() {

        sbColumnasSelect = new StringBuffer();

        String columnasTotal = "Q022CT00_ID_GRUPO, Q022ET00_ID_CUES, Q022ET00_CLASU, Q022ET00_SUPSU, Q022ET00_SUPTE, Q022ET00_VALSU, Q022ET00_NVPOG, Q022ET00_NVPOE, Q022ET00_NVTMG, Q022ET00_NVTME, Q022ET00_NALOD, Q022ET00_NREAL, Q022ET00_NVTOT, Q022ET00_FEC_ALTA, Q022ET00_FEC_MOD, Q022ET00_FEC_BAJA, Q022ET00_FIRMADO, Q022ET00_CDEXP, Q022ET00_NVPOT, Q022ET00_NLIBRE, Q022ET00_OBSSU, Q022ET00_FADQ, Q022ET00_ENTI, Q022ET00_TVIA, Q022ET00_CALLE, Q022ET00_POR_CL_POR, Q022ET00_BLOQ, Q022ET00_NUME, Q022ET00_BIS, Q022ET00_CDIR, Q022ET00_TIPADQ, Q022ET00_DX, Q022ET00_DY, Q022ET00_DIR_NUEVA, Q022ET00_FUERA_PLAZO, Q022ET00_USU_ALTA, Q022ET00_USU_MODIF";

        if (columnasSelect!=null){
            for(int i=0; i<columnasSelect.size();i++){
                sbColumnasSelect.append( (String)this.columnasSelect.get(i));
                sbColumnasSelect.append(",");
            }
        }

        if (sbColumnasSelect!=null && !sbColumnasSelect.toString().equals("")){
            sbColumnasSelect.setLength(sbColumnasSelect.length()-1);
            return sbColumnasSelect.toString();
        }else{
            return columnasTotal;
        }
    }



    /** Method getColumnsSelectTotal() 
    * Este mtodo devuelve un String con los nombres de las columnas sobres las q hacer la
    * select separadas por comas.
    * @return columnasTotal
    */

    public String getColumnsSelectTotal() {
        sbColumnasSelect = new StringBuffer();
        String columnasTotal = "Q022CT00_ID_GRUPO \"Q022CT00_ID_GRUPO\", Q022ET00_ID_CUES \"Q022ET00_ID_CUES\", Q022ET00_CLASU \"Q022ET00_CLASU\", Q022ET00_SUPSU \"Q022ET00_SUPSU\", Q022ET00_SUPTE \"Q022ET00_SUPTE\", Q022ET00_VALSU \"Q022ET00_VALSU\", Q022ET00_NVPOG \"Q022ET00_NVPOG\", Q022ET00_NVPOE \"Q022ET00_NVPOE\", Q022ET00_NVTMG \"Q022ET00_NVTMG\", Q022ET00_NVTME \"Q022ET00_NVTME\", Q022ET00_NALOD \"Q022ET00_NALOD\", Q022ET00_NREAL \"Q022ET00_NREAL\", Q022ET00_NVTOT \"Q022ET00_NVTOT\", Q022ET00_FEC_ALTA \"Q022ET00_FEC_ALTA\", Q022ET00_FEC_MOD \"Q022ET00_FEC_MOD\", Q022ET00_FEC_BAJA \"Q022ET00_FEC_BAJA\", Q022ET00_FIRMADO \"Q022ET00_FIRMADO\", Q022ET00_CDEXP \"Q022ET00_CDEXP\", Q022ET00_NVPOT \"Q022ET00_NVPOT\", Q022ET00_NLIBRE \"Q022ET00_NLIBRE\", Q022ET00_OBSSU \"Q022ET00_OBSSU\", Q022ET00_FADQ \"Q022ET00_FADQ\", Q022ET00_ENTI \"Q022ET00_ENTI\", Q022ET00_TVIA \"Q022ET00_TVIA\", Q022ET00_CALLE \"Q022ET00_CALLE\", Q022ET00_POR_CL_POR \"Q022ET00_POR_CL_POR\", Q022ET00_BLOQ \"Q022ET00_BLOQ\", Q022ET00_NUME \"Q022ET00_NUME\", Q022ET00_BIS \"Q022ET00_BIS\", Q022ET00_CDIR \"Q022ET00_CDIR\", Q022ET00_TIPADQ \"Q022ET00_TIPADQ\", Q022ET00_DX \"Q022ET00_DX\", Q022ET00_DY \"Q022ET00_DY\", Q022ET00_DIR_NUEVA \"Q022ET00_DIR_NUEVA\", Q022ET00_FUERA_PLAZO \"Q022ET00_FUERA_PLAZO\", Q022ET00_USU_ALTA \"Q022ET00_USU_ALTA\", Q022ET00_USU_MODIF \"Q022ET00_USU_MODIF\"";

        if (columnasSelect!=null){

            for(int i=0; i<columnasSelect.size();i++){
                sbColumnasSelect.append( (String)this.columnasSelect.get(i));
                if (alias.size()>0 && i<alias.size()){
                   sbColumnasSelect.append(" \"" + (String)this.alias.get(i)+ "\"");
                }else{
                   sbColumnasSelect.append(" \"" + (String)this.columnasSelect.get(i)+ "\"");
                }
                sbColumnasSelect.append(",");
            }
        }
        if (sbColumnasSelect!=null && !sbColumnasSelect.toString().equals("")){
            sbColumnasSelect.setLength(sbColumnasSelect.length()-1);
            return sbColumnasSelect.toString();
        }else{
            return columnasTotal;
        }
    }

    /** Method getColumnsSelectComitas() 
    * Este mtodo devuelve un String con los nombres de las columnas sobres las q hacer la
    * select separadas por comas.
    * @return columnasTotal
    */
    public String getColumnsSelectComitas() {
        sbColumnasSelect = new StringBuffer();
        String columnasTotal = " \"Q022CT00_ID_GRUPO\", \"Q022ET00_ID_CUES\", \"Q022ET00_CLASU\", \"Q022ET00_SUPSU\", \"Q022ET00_SUPTE\", \"Q022ET00_VALSU\", \"Q022ET00_NVPOG\", \"Q022ET00_NVPOE\", \"Q022ET00_NVTMG\", \"Q022ET00_NVTME\", \"Q022ET00_NALOD\", \"Q022ET00_NREAL\", \"Q022ET00_NVTOT\", \"Q022ET00_FEC_ALTA\", \"Q022ET00_FEC_MOD\", \"Q022ET00_FEC_BAJA\", \"Q022ET00_FIRMADO\", \"Q022ET00_CDEXP\", \"Q022ET00_NVPOT\", \"Q022ET00_NLIBRE\", \"Q022ET00_OBSSU\", \"Q022ET00_FADQ\", \"Q022ET00_ENTI\", \"Q022ET00_TVIA\", \"Q022ET00_CALLE\", \"Q022ET00_POR_CL_POR\", \"Q022ET00_BLOQ\", \"Q022ET00_NUME\", \"Q022ET00_BIS\", \"Q022ET00_CDIR\", \"Q022ET00_TIPADQ\", \"Q022ET00_DX\", \"Q022ET00_DY\", \"Q022ET00_DIR_NUEVA\", Q022ET00_FUERA_PLAZO \"Q022ET00_FUERA_PLAZO\", Q022ET00_USU_ALTA \"Q022ET00_USU_ALTA\", Q022ET00_USU_MODIF \"Q022ET00_USU_MODIF\"";

        if (alias.size()>0){

            for(int i=0; i<alias.size();i++){
            sbColumnasSelect.append(" \"" + (String)this.alias.get(i)+ "\"");
            sbColumnasSelect.append(",");
            }
        }else if (columnasSelect!=null){
            for(int i=0; i<columnasSelect.size();i++){
            sbColumnasSelect.append(" \"" + (String)this.columnasSelect.get(i)+ "\"");
            sbColumnasSelect.append(",");
            }
        }

        if (sbColumnasSelect!=null && !sbColumnasSelect.toString().equals("")){
            sbColumnasSelect.setLength(sbColumnasSelect.length()-1);
            return sbColumnasSelect.toString();
            }
        else{
            return columnasTotal;
        }

    }

    /** Method setTableFrom(listaTablas) 
    * @param listaTablas New value of property tableFrom.
    * Este mtodo aade la lista de tablas pasadas por parametro a la from .
    * Cada tabla de la lista debe ir separada por comas
    */

    public void setTableFrom(String listaTablas) {

        if (listaTablas!=null){
             this.tableFrom="Q022ES00" + "," + listaTablas;
        }else{
             this.tableFrom="Q022ES00";
        }
    }



    /** Method getTableFrom() 

    * Este mtodo devuelve un String con los nombres de las tablas sobres las q hacer la

    * from separadas por comas.
    * @return tableFrom
    */

    public String getTableFrom() {
        return this.tableFrom;
    }

    /** Method getRegModif() 
    * Este mtodo devuelve un int con el n de registros modifcados.
    * @return regModif
    */

    public int getRegModif() {
        return this.regModif;
    }

    /** Method setUncommittedRead() 
    * Este mtodo es vlido SOLO EN DB2. Permite 'lecturas sucias' si se establece a true
    * @param ur ur
    */

    public void setUncommittedRead(boolean ur) {
        this.uncommittedRead=ur;
    }



    /** Method getUncommittedRead() 
    * Este mtodo es vlido SOLO EN DB2.Devuelve el valor de UncommittedRead
    * @return uncommittedRead
    */

    public boolean getUncommittedRead() {

        return this.uncommittedRead;
    }

    /** Method setForUpdate() 
    * Este mtodo permite aadir la clausula FOR UPDATE si se establece a true
    * @param fu fu
    */

    public void setForUpdate(boolean fu) {
        this.forUpdate=fu;
    }

    /** Method getForUpdate() 
    * Este mtodo devuelve el valor de forUpdate
    * @return forUpdate
    */

    public boolean getForUpdate() {
        return this.forUpdate;
    }

    /** Method setMax(columnName) 
    * @param columnName New value of property max.
    * Este mtodo da valor a la var. max .
    */

    public void setMax(String columnName) {
        if (columnName!=null){
             this.max=columnName;
        }
    }

    /** Method getMax() 
    * Este mtodo devuelve un String con el nombre de la columna sobre la q hacer la
    * clausula max.
    * @return max
    */

    public String getMax() {
        return this.max;
    }

    /** Method setDistinct(columnName) 
    * @param columnName New value of property distinct.
    * Este mtodo da valor a la var. distinct .
    */

    public void setDistinct(String columnName) {
        if (columnName!=null){
             this.distinct=columnName;
        }
    }

    /** Method getDistinct() 
    * Este mtodo devuelve un String con el nombre de la columna sobre la q hacer la
    * clausula distinct.
    * @return distinct
    */
    public String getDistinct() {
        return this.distinct;
    }

    /** Method setGroupBy(listaColumnas) 
    * @param listaColumnas New value of property groupBy.
    * Este mtodo da el valor de la lista de columnas pasadas por parametro a la groupby .
    * Cada columna de la lista debe ir separada por comas
    */

    public void setGroupBy(String listaColumnas) {
             this.groupBy=listaColumnas;
    }

    /** Method getGroupBy() 
    * Este mtodo devuelve un String con los nombres de las columnas sobres las q hacer la
    * groupBy separadas por comas.
    * @return groupBy
    */

    public String getGroupBy() {
        return this.groupBy;
    }

    /** Method setOrderBy(valor) 
    * @param listaColumnas New value of property orderBy.
    * Este mtodo da el valor de la lista de columnas pasadas por parametro a la orderBy .
    * Cada columna de la lista debe ir separada por comas
    */
    public void setOrderBy(String listaColumnas) {
             this.orderBy=listaColumnas;
    }

    /** Method getOrderBy() 
    * Este mtodo devuelve un String con los nombres de las columnas sobres las q hacer la
    * orderBy separadas por comas.
    * @return orderBy
    */

    public String getOrderBy() {
        return this.orderBy;
    }

    /** Method setLimitRows(valor) 
    * @param valor New value of property limitRows.
    * Este mtodo da el valor pasado por parametro a la limitRows .
    */

    public void setLimitRows(boolean valor) {
             this.limitRows=valor;
    }

    /** Method getLimitRows() 
    * Este mtodo devuelve un boolean el valor de limitRows
    * @return limitRows
    */

    public boolean getLimitRows() {
        return this.limitRows;
    }

    /** Method setAditionalWhere(valor) 
    * @param valor New value of property aditionalWhere.
    * Este mtodo da el valor pasado por parametro a la aditionalWhere .
    */

    public void setAditionalWhere(String valor) {
             this.aditionalWhere=valor;
    }

    /** Method getAditionalWhere() 
    * Este mtodo devuelve un String con el valor de la aditionalWhere.
    * @return aditionalWhere
    */

    public String getAditionalWhere() {
        return this.aditionalWhere;
    }

    /** Method setInitialWhere(valor) 
    * @param valor New value of property initialWhere.
    * Este mtodo da el valor pasado por parametro a la initialWhere .
    */

    public void setInitialWhere(String valor) {
             this.initialWhere=valor;
    }

    /** Method getInitialWhere() 
    * Este mtodo devuelve un String con el valor de la initialWhere.
    * @return initialWhere
    */
    public String getInitialWhere() {
        return this.initialWhere;
    }


    /** Method setFixedWhere(valor) 
    * @param valor New value of property fixedWhere.
    * Este mtodo da el valor pasado por parametro a la fixedWhere .
    */

    public void setFixedWhere(String valor) {
             this.fixedWhere=valor;
    }

    /** Method getFixedWhere() 
    * Este mtodo devuelve un String con el valor de la fixedWhere.
    * @return fixedWhere
    */

    public String getFixedWhere() {
        return this.fixedWhere;
    }

    /** Method getConnection() 
    * Este mtodo devuelve un objeto connection.
    * @return connection
    */

    public java.sql.Connection getConnection() {
       	try{
       		if (this.connection==null || this.connection.isClosed()){
           		this.connection = Q70ConectorJDBC.getSingleton().getConnection(Q02A_JNDI_DATASOURCE);
           	}
       	}catch (NamingException nex){
           		nex.printStackTrace();
         }catch (SQLException sqlex){
           		sqlex.printStackTrace();
         }

        return this.connection;

    }

}
