package q02a.exe.seguridad.launcher;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;

import q02a.exe.arquitectura.beans.Q02aBaseBean;
import q02a.exe.arquitectura.dataobjects.Q02aDAOException;
import q02a.exe.arquitectura.webCommon.beans.Q02aProcessLauncherBean;
import q02a.exe.arquitectura.webCommon.utils.gdtp.Q02aGenericDataTransferProtocol;

import q02a.exe.seguridad.beans.Q02aSeguridadBean;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.infraestructura.traza.Q70Traza;

/**
 * 
 * @author GADIMAAR
 *
 */
public class Q02aSeguridadLauncher extends Q02aBaseBean implements Q02aProcessLauncherBean {

	/**

	 * 

	 */

	private static final long serialVersionUID = 1677342344158205416L;

	private static Q70Traza tr = Q70Traza.getSingleton();

	private static final String COMPONENTE = "SEGURDIDAD_LAUNCHER";

	

	private  String user = ""; 

	/**

     *  Constructor vaco

     */



	 /* (non-Javadoc)

     * @see com.bbk.arquitectura.webCommon.beans.ProcessLauncherBean#initProcessLauncherBean(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)

     */
	/**
     * @param request request
     * @param response response
     * 
     * @throws Q02aDAOException Q02aDAOException
	 */
    public void initProcessLauncherBean(HttpServletRequest request, HttpServletResponse response) throws Q02aDAOException {
		init(request,response);
    }

	/* (non-Javadoc)
     * @see com.bbk.arquitectura.webCommon.beans.ProcessLauncherBean#initProcessLauncherBean(javax.servlet.jsp.PageContext)
     */
    /**
     * @param context context
     * 
     * @throws Q02aDAOException Q02aDAOException
     */
    public void initProcessLauncherBean(PageContext context) throws Q02aDAOException {

    	this.request = (HttpServletRequest)context.getRequest();

    	this.response =(HttpServletResponse)context.getResponse(); 	

    }

    /**
     * 
     * @throws Exception Exception
     * @return solicitarPassword
     */
    public Q02aGenericDataTransferProtocol launch() throws Exception {
    	try{	       
	         if (tr.isTraceActive()){
	           	tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":launch: entrando");
	         }
	         String proceso = getParametro("METHOD");
	         if (proceso.equals("solicitarPassword")){
	            	return this.solicitarPassword();	            	
	         }
	         return null;
    	}
    	catch(Exception e){
	           return this.processException(e);
        }
     }
     
     /**
    * Mtodo que llama al Bean de Seguridad que genera la password del usuario despus de comprobar que se cumplen ciertas validaciones
    * @return result
    * @throws Exception Exception
    */

   public Q02aGenericDataTransferProtocol solicitarPassword() throws Exception {
    	
    	if (tr.isTraceActive()){
    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":solicitarPassword: entrando");
    	}
    	Q02aGenericDataTransferProtocol result = new Q02aGenericDataTransferProtocol(); 
    	Q02aSeguridadBean beanSeguridad = new Q02aSeguridadBean();
    	
        try{ 
        	String dniUsuario = ((String)getMapaDatos().get("dniUsuario"));
        	result = beanSeguridad.solicitarPassword(dniUsuario);
 	   }catch(Exception ex){
            result.addProperty("RESULT_1","RESULT","NO_OK");
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCampoRealizaActuacionDeGrupoConMuniAno: " + sw.getBuffer ().toString());
            throw new Q02aDAOException(ex);
       }finally{
    	   if (tr.isTraceActive()){
    		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCampoRealizaActuacionDeGrupoConMuniAno: saliendo");                
           }
    	   return result;
       }
       
   }
  
}