package q02a.exe.seguridad.beans;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Random;

import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import q02a.exe.listados.Q02AUtils;
import q02a.exe.seguridad.dataobjects.Q02aSeguridadDataBaseDAO;
import q02a.exe.seguridad.valueobjects.Q02aUsuario;
import q02a.exe.utils.Q02aMailUtils;
import q02a.exe.arquitectura.beans.Q02aBaseBean;
import q02a.exe.arquitectura.dataobjects.Q02aDAOException;
import q02a.exe.arquitectura.webCommon.utils.gdtp.Q02aGenericDataTransferProtocol;

/**
 * 
 * @author GADIMAAR
 *
 */
public class Q02aSeguridadBean extends Q02aBaseBean{

	private static final long serialVersionUID = 3394757413314128326L;
	protected Q02aSeguridadDataBaseDAO daoSeguridad = null;
	 /** Constructor vacio */
    public Q02aSeguridadBean() {
        super();
    }
    /**
     * Mtodo que llama a un DAO para obtener un usuario a partir de su identificador.
     * @param dniUsuario identificador de usuario.
     * @return Q02aUsuario con los datos del usuario encontrado.
     * @throws Exception    Exception
     */  
    public Q02aUsuario obtenerUsuario (String dniUsuario) throws Exception {   	 
    	boolean error = false;
    	try{
    		if (tr.isTraceActive()){
      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerUsuario: entrando "
      					+ "idUsuario: " + dniUsuario);
      		} 
			abrirConexion();			
			//this.daoSeguridad = new Q02aSeguridadDataBaseDAO(this.getConn());
			//Q02aUsuario usuario = this.daoSeguridad.obtenerUsuario(dniUsuario);
			Q02aUsuario usuario = this.obtenerUsuario(dniUsuario, this.getConn());
			return usuario;
    	}catch(Exception ex){  
	 		error= true;
	        java.io.StringWriter sw = new java.io.StringWriter();
	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	        ex.printStackTrace(pw);
	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerUsuario: " + sw.getBuffer ().toString());
	        throw ex;                     
    	}finally{
 		    try{
 		    	//this.daoSeguridad.freeResourcesNotConnection();
 		    }catch(Exception ex){
			   if (tr.isTraceActive()){
				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerUsuario: error liberando recursos");
	   	   	   }  
 		    }  		  
 		    cerrarConexion(error);	       	
	        if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerUsuario: saliendo.");
	   		}
    	}
    }
    /**
     * Mtodo que llama a un DAO para obtener un usuario a partir de su identificador.
     * @param dniUsuario dniUsuario
     * @param conn conn
     * @return Q02aUsuario con los datos del usuario encontrado.
     * @throws Exception    Exception
     */  
    public Q02aUsuario obtenerUsuario (String dniUsuario, Connection conn) throws Exception {   	 
    	
    	try{
    		if (tr.isTraceActive()){
      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerUsuario: entrando "
      					+ "idUsuario: " + dniUsuario);
      		} 
			//abrirConexion();			
			this.daoSeguridad = new Q02aSeguridadDataBaseDAO(conn);
			Q02aUsuario usuario = this.daoSeguridad.obtenerUsuario(dniUsuario);
            
            // Si tenemos el id del usuario, miramos si es administrador
            if ( usuario.getId() != null && !"".equals(usuario.getId()) ){
            //abrirConexion();            
                this.daoSeguridad = new Q02aSeguridadDataBaseDAO(conn);
                String grupoUsuario = this.daoSeguridad.usuarioGrupo( usuario.getId() );
                //Comprobamos que el grupoUsuario al que pertenece el usuario
                //es el del administrador
                if ( !"".equals(grupoUsuario) ){
                    
                    this.daoSeguridad = new Q02aSeguridadDataBaseDAO(conn);
                    
                    String codADMConst = q02a.exe.utils.Q02aConstantes.getString("codigo.administrador");
                    String codADMBD = this.daoSeguridad.grupoAdministrador(codADMConst);
                    if ( codADMBD != null && !"".equals(codADMBD) 
                           && codADMBD.equals(grupoUsuario) ){
                    	if (tr.isTraceActive()){
                            tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerUsuario: grupoUsuario: " + grupoUsuario);                
                        }
                        usuario.setGrupoAdmin(grupoUsuario);
                    }
                    
                }
            }
            
			return usuario;
    	}catch(Exception ex){  
	 		java.io.StringWriter sw = new java.io.StringWriter();
	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	        ex.printStackTrace(pw);
	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerUsuario: " + sw.getBuffer ().toString());
	        throw ex;                     
    	}finally{
 		    try{
 		    	this.daoSeguridad.freeResourcesNotConnection();
 		    }catch(Exception ex){
			   if (tr.isTraceActive()){
				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerUsuario: error liberando recursos");
	   	   	   }  
 		    }  		  
 		   // cerrarConexion(error);	       	
	        if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerUsuario: saliendo.");
	   		}
    	}
    }
    
    /**
     * Mtodo que llama a un DAO para obtener un usuario a partir de su identificador.
     * @param usuario usuario
     * @return Q02aUsuario con los datos del usuario encontrado.
     * @throws Exception   Exception
     */ 
    public ArrayList obtenerPlazos (Q02aUsuario usuario) throws Exception {   	 
    	boolean error = false;
    	ArrayList listaPlazos = new ArrayList();
    	try{
    		if (tr.isTraceActive()){
      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerUsuario: entrando "
      					+ "idUsuario: " + usuario.getDni() + "-provincia: " + usuario.getDescProvincia() + "-municipio: " + usuario.getDescMunicipio() ) ;
      		} 
			abrirConexion();			
			this.daoSeguridad = new Q02aSeguridadDataBaseDAO(this.getConn());
			listaPlazos = this.daoSeguridad.obtenerPlazos(usuario.getNiProvincia(), usuario.getNiMunicipio());
			return listaPlazos;
    	}catch(Exception ex){  
	 		error= true;
	        java.io.StringWriter sw = new java.io.StringWriter();
	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	        ex.printStackTrace(pw);
	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerUsuario: " + sw.getBuffer ().toString());
	        throw ex;                     
    	}finally{
 		    try{
 		    	this.daoSeguridad.freeResourcesNotConnection();
 		    }catch(Exception ex){
			   if (tr.isTraceActive()){
				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerUsuario: error liberando recursos");
	   	   	   }  
 		    }  		  
 		    cerrarConexion(error);	       	
	        if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerUsuario: saliendo.");
	   		}
    	}
    }
    
    
    /**
     * Mtodo que llama al Bean de Seguridad que genera la password del usuario despus de comprobar que se cumplen ciertas validaciones
     * @param dniUsuario dniUsuario
     * @return result
     * @throws Exception Exception
     */
    public Q02aGenericDataTransferProtocol solicitarPassword(String dniUsuario) throws Exception {
     	
     	if (tr.isTraceActive()){
     		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":solicitarPassword: entrando");
     	}
     	
     	Q02aGenericDataTransferProtocol result = new Q02aGenericDataTransferProtocol(); 
         try{ 
        	 
        	String mailUsuario=null;
         	String resul = this.generarGuardarPassword(dniUsuario);
         	
         	 if (tr.isTraceActive()){
      		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":solicitarPassword: resul" + resul);                
             }
         	if(resul!=null && resul.equals("OK")){

            	if (tr.isTraceActive()){
         		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":solicitarPassword: mailUsuario_antes" + mailUsuario);                
                }
         		mailUsuario=this.enviarPassword(this.obtenerUsuario(dniUsuario));
         		if (tr.isTraceActive()){
         		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":solicitarPassword: mailUsuario_despues" + mailUsuario);                
                }
            }
         	
         	tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":solicitarPassword:resul " + resul);
         	tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":solicitarPassword:mailUsuario " + mailUsuario);
             
            
         	//resul puede ser 
         	//OK: la contrasea se ha generado bien y se ha enviado por correo
         	//NO_OK; ha ocurrido un error en la generacin
         	//USU_NO_OK: el usuario no tiene permitido el acceso
  			result.addGroup("RESULT_1"); 			
  			result.addProperty("RESULT_1","RESULT",resul);
  			result.addProperty("RESULT_1","MAIL_USUARIO",mailUsuario);
  		
        }catch(Exception ex){
             result.addProperty("RESULT_1","RESULT","NO_OK");
             java.io.StringWriter sw = new java.io.StringWriter();
             java.io.PrintWriter pw = new java.io.PrintWriter(sw);
             ex.printStackTrace(pw);
             tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":solicitarPassword: ERROR:  " + sw.getBuffer ().toString());
             throw new Q02aDAOException(ex);
        }finally{
     	   if (tr.isTraceActive()){
     		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":solicitarPassword: saliendo");                
            }
     	   return result;
        }
        
    }
    
    /**
     * Mtodo que llama a un DAO para generar la password del usuario y enviarla por correo
     * @param dniUsuario dni del usuario
     * @return String con el resultado de si ha ido todo ok o no
     * @throws Exception   Exception
     */  
    public String generarGuardarPassword (String dniUsuario) throws Exception {   	 
    	boolean error = false;
    	String resul = null;
    	try{
    		if (tr.isTraceActive()){
      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":solicitarPassword: entrando "
      					+ "idUsuario: " + dniUsuario);
      		} 
			abrirConexion();			
			this.daoSeguridad = new Q02aSeguridadDataBaseDAO(this.getConn());
			if(daoSeguridad.accesoPermitido(dniUsuario)){
				//this.daoSeguridad.generarPassword(dniUsuario);
				//Generamos la password
				String pwd = this.generarPassword(dniUsuario);
				if(pwd!=null){
					//Guardamos la password
					this.daoSeguridad.guardarPassword(dniUsuario, pwd);
					resul = "OK";
				}
				else {resul="NO_OK";}
			}
			else {resul ="USU_NO_OK";}
			
    	}catch(Exception ex){  
	 		error= true;
	 		resul="NO_OK";
	        java.io.StringWriter sw = new java.io.StringWriter();
	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	        ex.printStackTrace(pw);
	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":solicitarPassword: " + sw.getBuffer ().toString());
	        throw ex;                     
    	}finally{
 		    try{
 		    	this.daoSeguridad.freeResourcesNotConnection();
 		    }catch(Exception ex){
			   if (tr.isTraceActive()){
				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":solicitarPassword: error liberando recursos");
	   	   	   }  
 		    }  		  
 		    cerrarConexion(error);	       	
	        if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":solicitarPassword: saliendo.");
	   		}
	        return resul;
    	}
    }
    
    /**
     * Mtodo que genera la password del usuario
     * @param dniUsuario identificador de usuario.
     * @throws Exception Exception
     * @return pwd String con el resultado de si ha ido todo ok o no
     */
    public String generarPassword (String dniUsuario) throws Exception {
    	try{
    		String pwd=null;
    		if (tr.isTraceActive()){
     			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":generarPassword: entrando "+ dniUsuario);     			
     		}
    		Q02aUsuario usuario = this.obtenerUsuario(dniUsuario, this.getConn());
    		//La password ser: primera letra del nombre + cuatro letras del apellido1 + nmero aleatorio de 4 dgitos
    		if(usuario!=null){
    			//Generamos la parte numrica
    			int x;
    			String parteNumerica="";
    			Random rnd = new Random();
    			//Random rnd = new Random(3816L);
    			for(int i=0; i<4;i++){
    				x = (int)(rnd.nextDouble() * 10.0);
    				parteNumerica = parteNumerica + new Integer(x).toString();
    			}
    			//Componemos la contrasea
    			StringBuffer sbPwd = new StringBuffer();
    			sbPwd.append(usuario.getNombre().toLowerCase().substring(0,1));
    			sbPwd.append(usuario.getApellido1().toLowerCase().substring(0,4));
    			sbPwd.append(parteNumerica);
    			pwd = sbPwd.toString();
    		}
    		return pwd;
    	}catch(Exception ex){
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);  
            ex.printStackTrace(pw);
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":generarPassword: " + sw.getBuffer ().toString());
            throw ex;
   	 	}   	
    }
    
    /**
     * Mtodo que enva un mail al usuario con la password.
     * @param usuarioDestino Q02aUsuario objeto con los datos del usuario al cual se va a enviar la contrasea
     * @return String direccin de correo eletrnico al cual se ha enviado la contrasea
     * @throws Exception Exception
     */
    public String enviarPassword(Q02aUsuario usuarioDestino) throws Exception{
    	//Variables que no se van a modificar
    	final String METODO_TRAZA 				= ":contactar:";	
    	final String SEPARADOR 					= ":"; 
		final String CARRIAGE_RETURN 			= "\n"; 
		final String GUION						= " - ";
		
    	try{
    		if (tr.isTraceActive()){
      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + METODO_TRAZA +  ":entrando");
      		}
    		
    		String CUERPO_TEXTO1 	= Q70GestorMensajesi18n.getSingleton().getMessage("q02arecursosCuestionarios","envio.pwd.texto1","es");
    		String CUERPO_TEXTO2				= Q70GestorMensajesi18n.getSingleton().getMessage("q02arecursosCuestionarios","envio.pwd.texto2", "es");
    		
    		//Variable que contiene el mensaje
    		StringBuffer mensaje = new StringBuffer();
    		mensaje.append(CUERPO_TEXTO1).append(" ").append(usuarioDestino.getPass()).append(CARRIAGE_RETURN);      		
      		// Texto  
    		mensaje.append(CUERPO_TEXTO2).append(CARRIAGE_RETURN);
    		if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + "MENSAJE " + mensaje.toString());
	   		}
    		//Se instancia la clase con el constructor vaco
    		Q02aMailUtils mailUtil=new Q02aMailUtils();
    		//Se asocian los parmetros
    		mailUtil.setSubject("");
    		mailUtil.setBody(mensaje.toString());
    		mailUtil.setRemitente(Q70ListenerUtils.getApplicationProperty("REMITENTE"));
    		//ArrayList con los destinatarios
    		ArrayList destinatarios = new ArrayList();
    		destinatarios.add(usuarioDestino.getMail());
    		mailUtil.setListaDestinatarios(destinatarios);
    		if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + "CONTACTO " + destinatarios.get(0).toString());
	   		}
    		mailUtil.setAttachment(null);
    		mailUtil.setIdioma("es");
    		
    		if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":enviarCorreoPassword: antes enviarMail: " );
	   		}
      		//Se enva el correo
    		mailUtil.enviarMail();	
    		
    		if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":enviarCorreoPassword: usuarioDestino.getMail(): " + usuarioDestino.getMail());
	   		}
    		
    		return usuarioDestino.getMail();
    			
    	}catch(Exception ex){
	        java.io.StringWriter sw = new java.io.StringWriter();
	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	        ex.printStackTrace(pw);
	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":enviarCorreoPassword: " + sw.getBuffer ().toString());
	        throw ex;                     
    	}finally{
	        if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":enviarCorreoPassword: saliendo");
	   		}
    	}
    	
    }
    
    /**
     * Mtodo que llama a un DAO para comprobar si un usuario tiene acceso a un proceso.
     * @param niUsuario nmero interno del usuario en bbdd.
     * @param rutaProceso Ruta del proceso a ejecutar.
     * @return nmero interno del proceso en caso de existir, -1 en caso contrario.
     * @throws Exception
     */
    /*public long esProcesoPermitido(String niUsuario, String rutaProceso) throws Exception{
    	boolean error = false;
    	try{
    		if (tr.isTraceActive()){
      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":esProcesoPermitido: entrando "
      					+ "niUsuario: " + niUsuario);
      		}
    		abrirConexion();			
			this.daoSeguridad = new Q02aSeguridadDataBaseDAO(this.getConn());
			return this.daoSeguridad.esProcesoPermitido(niUsuario, rutaProceso);
    	}catch(Exception ex){
	 		error= true;
	        java.io.StringWriter sw = new java.io.StringWriter();
	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	        ex.printStackTrace(pw);
	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":esProcesoPermitido: " + sw.getBuffer ().toString());
	        throw ex;                     
    	}finally{
 		    try{
 		    	this.daoSeguridad.freeResourcesNotConnection();
 		    }catch(Exception ex){
			   if (tr.isTraceActive()){
				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":esProcesoPermitido: error liberando recursos");
	   	   	   }  
 		    }  		  
 		    cerrarConexion(error);	       	
	        if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":esProcesoPermitido: saliendo");
	   		}
    	}
    }*/
    
    /**
     * Mtodo que llama a un DAO para obtener los municipios que ve un usuario
     * @param usuario identificador de usuario.
     * @return Q02aUsuario con los datos del usuario encontrado.
     * @throws Exception   Exception
     */ 
    public ArrayList obtenerMunicipiosUsuario (Q02aUsuario usuario) throws Exception {   	 
    	boolean error = false;
    	ArrayList listaMunicipios = new ArrayList();
    	try{
    		if (tr.isTraceActive()){
      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerMunicipiosUsuario: entrando "
      					+ "idUsuario: " + usuario.getDni() + "-provincia: " + usuario.getDescProvincia() + "-municipio: " + usuario.getDescMunicipio() ) ;
      		} 
			abrirConexion();			
			this.daoSeguridad = new Q02aSeguridadDataBaseDAO(this.getConn());
			listaMunicipios = this.daoSeguridad.obtenerMunicipiosUsuario(usuario.getId() );
			return listaMunicipios;
    	}catch(Exception ex){  
	 		error= true;
	        java.io.StringWriter sw = new java.io.StringWriter();
	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	        ex.printStackTrace(pw);
	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerMunicipiosUsuario: " + sw.getBuffer ().toString());
	        throw ex;                     
    	}finally{
 		    try{
 		    	this.daoSeguridad.freeResourcesNotConnection();
 		    }catch(Exception ex){
			   if (tr.isTraceActive()){
				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerMunicipiosUsuario: error liberando recursos");
	   	   	   }  
 		    }  		  
 		    cerrarConexion(error);	       	
	        if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerMunicipiosUsuario: saliendo.");
	   		}
    	}
    }
    
    
   
}