package q02a.exe.reports.dataobjects;

import java.io.ByteArrayOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;

import q02a.exe.arquitectura.dataobjects.Q02aDataBaseDAO;
import q02a.exe.reports.valueobjects.Q02aColumnas;
import q02a.exe.reports.valueobjects.Q02aParametrizacion;
import q02a.exe.tablasBD.jdbc.oracle.Q02aTablaBDQ022OS00;
import q02a.exe.utils.Q02aFormatData;
import q02a.exe.utils.informes.excel.Q02aDocumentoExcel;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

/** 
 * Q02aInformesDataBaseDAO es un DAO que accede a BD para
 * recuperar los datos referentes a la generacin de Informes.
 * @author GADIMAAR
 */
 
public class Q02aInformesDataBaseDAO extends Q02aDataBaseDAO {
	private static final long serialVersionUID = 1657861712223046524L;
	private Q02aDocumentoExcel documentoExcel = null;
	
    /**
     * 
     *
     */
	public Q02aInformesDataBaseDAO() {
        super();                
    }
	
    /**
     * 
     * @param conn conn
     */
    public Q02aInformesDataBaseDAO(Connection conn) {
    	super(conn);     
    }
    
    /**
     * Mtodo que 
     * @param niParametrizacion nmero interno de la parametrizacin del Informe.
     * @return Q02aParametrizacion
     * @throws Exception Exception
     */
    public Q02aParametrizacion obtenerParametrizacion(String niParametrizacion) throws Exception{
    	Q02aTablaBDQ022OS00 tablaBDInforme 	= null;
    	Q02aParametrizacion voParam 		= null;
    	ResultSet rs 						= null;
    	
    	try{
	    	if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerParametrizacion: entrando");
	   		}
	    	tablaBDInforme = new Q02aTablaBDQ022OS00(this.getConnection());
	    		    	
	    	tablaBDInforme.addColumnSelect(Q02aTablaBDQ022OS00.NOMCOLUMN_Q022OT00_TITULO);	    		    	
	    	tablaBDInforme.addColumnSelect(Q02aTablaBDQ022OS00.NOMCOLUMN_Q022OT00_TABLE);	    	
	    	tablaBDInforme.addColumnSelect(Q02aTablaBDQ022OS00.NOMCOLUMN_Q022OT00_FIXED_WHERE);
	    	tablaBDInforme.addColumnSelect(Q02aTablaBDQ022OS00.NOMCOLUMN_Q022OT00_PLANTILLA);
	    	tablaBDInforme.addColumnSelect(Q02aTablaBDQ022OS00.NOMCOLUMN_Q022OT00_ORDER);
	    		    	
	    	tablaBDInforme.setQ022OT00_COD_WHERE(niParametrizacion);
	    	
	    	rs = tablaBDInforme.select();	    		    		  
	    	while (rs.next()){
	    		voParam = new Q02aParametrizacion();	    		
	    		voParam.setTitulo		( rs.getString(Q02aTablaBDQ022OS00.NOMCOLUMN_Q022OT00_TITULO) );	    		
	    		voParam.setTabla		( rs.getString(Q02aTablaBDQ022OS00.NOMCOLUMN_Q022OT00_TABLE) );
	    		voParam.setFixedWhere	( rs.getString(Q02aTablaBDQ022OS00.NOMCOLUMN_Q022OT00_FIXED_WHERE) );
	    		voParam.setPlantilla	( rs.getString(Q02aTablaBDQ022OS00.NOMCOLUMN_Q022OT00_PLANTILLA) );
	    		voParam.setOrder		( rs.getString(Q02aTablaBDQ022OS00.NOMCOLUMN_Q022OT00_ORDER) );
      		}
			
	    	return voParam;
     	}catch(Exception ex){   	   
     		java.io.StringWriter sw = new java.io.StringWriter();
     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
     		ex.printStackTrace(pw);
     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerParametrizacion: " + sw.getBuffer ().toString());
     		throw ex;
     	}finally{
     		try{
     			tablaBDInforme.freeResourcesNotConnection();	
     		}catch(Exception ex){
     			if (tr.isTraceActive()){
     				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerParametrizacion: error liberando recursos");
 		   	   	}  
 			}  		
 			if (tr.isTraceActive()){
 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerParametrizacion: saliendo");                
            }       	
     	}     	
    }    
    
    
    /**
     * Mtodo que accede a BD para recuperar los nombres de las columnas y las descripciones
     * de una tabla
     * @param nombreTabla nombre de la tabla.
     * @return Q02aColumnas
     * @throws Exception Exception
     */    
    public Q02aColumnas obtenerColumnasTabla(String nombreTabla) throws Exception{
    	Q02aColumnas columnas = null;    	
    	try{
	    	if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerColumnasTabla: entrando");
	   		}
			//Definicion de variables para acceso a BD
	    	Connection  con 			= this.getConnection();
	        StringBuffer query 			= new StringBuffer();
	        ResultSet rs 				= null;		        
	        
	        //Preparacion de la sentencia de acceso. Recupera los nombres de las columnas y sus comentarios
	        //Comprobar si nombreTabla es un sinonimo o es el nombre de la tabla
	        String sSQL = "select synonym_name,table_name from user_synonyms"
				+ " where synonym_name='" + nombreTabla + "'";
			PreparedStatement prepStmt = con.prepareStatement(sSQL);
			rs = prepStmt.executeQuery();			
			if (rs.next()) {
				//Si es un sinonimo, recuperar el nombre de la tabla
				if (rs.getString(2) != null){
					nombreTabla = (rs.getString(2));
                }
			}
			rs.close();
			prepStmt.close();
			
			//Acceder a BD a recuperar los valores
			query.append("SELECT com.column_name, comments FROM user_col_comments com, user_tab_columns col")
			.append(" WHERE com.table_name = col.table_name")
			.append(" AND com.column_name = col.column_name")
			.append(" AND com.table_name = '")
			.append(nombreTabla + "'")
			.append(" ORDER BY col.table_name,col.column_id");
	        	        	       
	        
	        //Acceso a BD
	        prepStmt = con.prepareStatement(query.toString());	        
	        rs = prepStmt.executeQuery();
	        
	        //Tratamiento del resultado
	        columnas = new Q02aColumnas();	        
	    	while (rs.next()){
	    		columnas.getNombre().add( rs.getString("COLUMN_NAME") );
	    		columnas.getDescripcion().add( rs.getString("COMMENTS") );
	    	}	        
			rs.close();
			prepStmt.close();
	    	return columnas;
     	}catch(Exception ex){   	   
     		java.io.StringWriter sw = new java.io.StringWriter();
     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
     		ex.printStackTrace(pw);
     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerColumnasTabla: " + sw.getBuffer ().toString());
     		throw ex;
     	}finally{
     		try{
     			//tablaBDInforme.freeResourcesNotConnection();	
     		}catch(Exception ex){
     			if (tr.isTraceActive()){
     				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerColumnasTabla: error liberando recursos");
 		   	   	}  
 			}  		
 			if (tr.isTraceActive()){
 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerColumnasTabla: saliendo");                
            }       	
     	}     	
    }   
    
    
	/**
	 * Metodo que accede a BD para obtener los datos de un Informe
     * 
	 * @param parametrizacion - datos de parametrizacion del informe
	 * @param columnas - columnas
     * 
	 * @return ByteArrayOutputStream
	 * @throws Exception Exception
	 */
	public ByteArrayOutputStream obtenerDatosInforme(Q02aParametrizacion parametrizacion, Q02aColumnas columnas) throws Exception {
		//Definicion de variables para acceso a BD    	
    	Connection  con 			 = this.getConnection();
        StringBuffer query 			 = new StringBuffer();    	  
        PreparedStatement prepStmt   = null;
        ResultSet rs 				 = null;
        ArrayList cabecera			 = new ArrayList();
        ArrayList nomColumnas		 = new ArrayList();
        
    	try{
	    	if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerDatosInforme: entrando");
	   		}	    	
				        
	        //Separar las columnas que se van a recuperar y montar la query 
	        //(las que en su descripcion tengan un apartado entre las etiquetas #INF#)
	        query.append("SELECT ");
	        	        
	        for (int i=0; i<columnas.getNombre().size(); i++ ){
	        	if ( !Q02aFormatData.esVacio( (String) columnas.getDescripcion().get(i)) ){
	        		if (columnas.getDescripcion().get(i).toString().indexOf("#INF#") >= 0 ){
	        			//Si el comentario tiene el tag #INF#, se entra para aadirlo a las cabeceras
		        		if ( columnas.getDescripcion().get(i).toString().indexOf("#LANG#") >= 0 ){
		        			//Si tiene el tag #LANG#, se compara con el idioma actual de la sesion
		        			String[] strLangArray = columnas.getDescripcion().get(i).toString().split("#LANG#");
		        			if (strLangArray[1].toUpperCase().equals( this.getIdioma().toUpperCase() )){
		        				//si es igual, se aade a las cabeceras
		        				String[] strArray = columnas.getDescripcion().get(i).toString().split("#INF#");
				        		cabecera.add(strArray[1]);
				        		query.append( columnas.getNombre().get(i) + ", ");
				        		//Aadir los nombres de las columnas que para recuperarlas mas adelante		        		
				        		nomColumnas.add(columnas.getNombre().get(i));
		        			}
		        		}else{
		        			//Si no tiene el tag #LANG#, se aade directamente
		        			String[] strArray = columnas.getDescripcion().get(i).toString().split("#INF#");
			        		cabecera.add(strArray[1]);
			        		query.append( columnas.getNombre().get(i) + ", ");
			        		//Aadir los nombres de las columnas que para recuperarlas mas adelante		        		
			        		nomColumnas.add(columnas.getNombre().get(i));
		        		}	        			
		        	}
	        	} 
	        }	      	 
	        
	        //Quitar la ultima coma
	        query.deleteCharAt(query.lastIndexOf(","));
	        
	        //Aadir la tabla
	        query.append(" FROM " + parametrizacion.getTabla());
	        
	        //Aadir la Fixed Where
	        query.append(" WHERE (1=1) ");
	        if (!Q02aFormatData.esVacio(parametrizacion.getFixedWhere())){
	        	String fixWhere = parametrizacion.getFixedWhere();
	        		        	
	        	if (fixWhere.indexOf("#LANG#ID#LANG#") > 0 ){
	        		//Si la FixedWhere contiene Idioma
		        	StringBuffer result = new StringBuffer();	        	
		            //startIdx y idxOld delimitan varias partes de la cadena de entrada
		            int startIdx = 0;
		            int idxOld = 0;
		            while ((idxOld = fixWhere.indexOf("#LANG#ID#LANG#", startIdx)) >= 0) {
	                  //Coger la parte de la Where anterior al Idioma
		              result.append( fixWhere.substring(startIdx, idxOld) );
		              //Cambiar #LANG#ID#LANG# por el Idioma de la sesion
		              result.append( this.getIdioma() );

		              //Resetear startIdx en la siguiente posicion a la encontrada,
		              //para ver si hay mas ocurrencias de la subcadena
		              startIdx = idxOld + "#LANG#ID#LANG#".length();
		            }
		            //the final chunk will go to the end of aInput
		            result.append( fixWhere.substring(startIdx) );
		            fixWhere = result.toString();
	        	}
	        	
	        	query.append(" AND " + parametrizacion.getFixedWhere());	        		        		            	            	        
	        }
	        
	        //La Additional Where
	        if (!Q02aFormatData.esVacio(parametrizacion.getAddWhere())){
	        	query.append(" AND " + parametrizacion.getAddWhere());
	        }
	        
	        //Y el orden
	        if (!Q02aFormatData.esVacio(parametrizacion.getOrder())){
	        	query.append(" ORDER BY " + parametrizacion.getOrder());
	        }	        
	        
	        //Ejecutar la query
	        prepStmt = con.prepareStatement(query.toString());
	        rs = prepStmt.executeQuery();
	    	
	        //Generacion del documento EXCEL
			//Leer los datos de configuracion para saber en que fila y columna comenzar a escribir el informe 
			documentoExcel 		= new Q02aDocumentoExcel( parametrizacion.getPlantilla(), "config" );
			int filaTitulo 		= new Integer( documentoExcel.obtenerValorCelda(1,1) ).intValue();
			int colTitulo 		= new Integer( documentoExcel.obtenerValorCelda(1,2) ).intValue();
			int filaCabecera 	= new Integer( documentoExcel.obtenerValorCelda(2,1) ).intValue();
			int colCabecera 	= new Integer( documentoExcel.obtenerValorCelda(2,2) ).intValue();
			int filaDatos 		= new Integer( documentoExcel.obtenerValorCelda(3,1) ).intValue();
			int colDatos 		= new Integer( documentoExcel.obtenerValorCelda(3,2) ).intValue();												
			
			//Rellenar el documento Excel
			//Acceder a la hoja a rellenar
			documentoExcel.obtenerHoja("Listado");
			//Rellenar y formatear el titulo
			String titulo = parametrizacion.getTitulo();		

			for (int h=0;h<cabecera.size();h++){
				documentoExcel.bordearTodo(filaTitulo, colTitulo + h);
			}			
			documentoExcel.mergeCeldasTitulo(filaTitulo, colTitulo, filaTitulo, colTitulo + cabecera.size() - 1);			
			documentoExcel.escribirCelda( filaTitulo, colTitulo, titulo.toUpperCase());
			
			//Rellenar las celdas con los datos. Recorrer el ResultSet con los datos			
			String columna = "";
			int contador = 0;
			while (rs.next()){				
				for (int k=0; k<cabecera.size(); k++){
					columna = (String)nomColumnas.get(k);				
					documentoExcel.escribirCelda( filaDatos + contador, colDatos + k, rs.getString( columna.trim() ));
					documentoExcel.bordearSuave( filaDatos + contador, colDatos + k );
				}			
				contador++;
			}
			
			//Rellenar las celdas con los titulos de cabecera
			String titCabecera = "";
			String descCabecera = "";			
			if ( cabecera != null){
				for ( int j=0; j < cabecera.size() ; j++ ){                                                      
					descCabecera = (String)cabecera.get(j);
					documentoExcel.setAnchoCelda(colCabecera + j, 6900);                                        
                    if (j == cabecera.size()-1 ){
                    	documentoExcel.bordearMenosIzquierda(filaCabecera, colCabecera + j);
                    }else if (j == 0 ){
                    	documentoExcel.bordearMenosDerecha(filaCabecera, colCabecera + j);
                    }else{
                    	documentoExcel.bordearArribaAbajo(filaCabecera, colCabecera + j);
                    }
                            			                    
        			//coger el valor de 'titCabecera' del ficheo de idioma para meterlo en el Excel. 
        			//Si ese valor es "" se pone el valor original de 'titCabecera'
                                        
        			if (!Q02aFormatData.esVacio( Q70GestorMensajesi18n.getSingleton().getMessage("Q02arecursosInformes",descCabecera, this.getIdioma()) )){
        				titCabecera =Q70GestorMensajesi18n.getSingleton().getMessage("Q02arecursosInformes",descCabecera, this.getIdioma());						
        			}else{
        				titCabecera = descCabecera; 
        			}	
        			
        			documentoExcel.escribirCelda( filaCabecera, colCabecera + j, titCabecera);
        			
                }
			}
			
			return documentoExcel.parsearDocumento();							        
     	}catch(Exception ex){   	   
     		java.io.StringWriter sw = new java.io.StringWriter();
     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
     		ex.printStackTrace(pw);
     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerDatosInforme: " + sw.getBuffer ().toString());
     		throw ex;
     	}finally{
     		try{
     			prepStmt.close();
     			rs.close();    	
     		}catch(Exception ex){
     			if (tr.isTraceActive()){
     				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerDatosInforme: error liberando recursos");
 		   	   	}  
 			}  		
 			if (tr.isTraceActive()){
 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerDatosInforme: saliendo");                
            }       	
     	}     	
    }       

}