package q02a.exe.plazos.dataobjects;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;

import q02a.exe.arquitectura.dataobjects.Q02aDataBaseDAO;
import q02a.exe.plazos.valueobjects.Q02aPlazos;
import q02a.exe.tablasBD.jdbc.oracle.Q02aTablaBDQ022AS00;
import q02a.exe.tablasBD.jdbc.oracle.Q02aTablaBDQ022AS01V01;
import q02a.exe.utils.Q02aConstantes;
import q02a.exe.utils.Q02aFormatData;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.infraestructura.traza.Q70Traza;

/**
 * 
 * @author GADIMAAR
 *
 */
public class Q02aPlazosDataBaseDAO extends Q02aDataBaseDAO{

	private static final long serialVersionUID = -8520551641771839103L;
	private static Q70Traza tr = Q70Traza.getSingleton();
	private static final String COMPONENTE = "DAO_ACCESO_DATOS";
	private static final String RECURSOS_PLAZOS = "q02arecursosCuestionarios";

	/**
     * 
     *
	 */
	public Q02aPlazosDataBaseDAO() {
        super();                
    }

	/**
     * 
     * @param conn conn
	 */
    public Q02aPlazosDataBaseDAO(Connection conn) {

    	super(conn);     

    }


    /**
     * 
     * @param rs rs
     * @return listaPlazos
     * @throws Exception Exception
     */
    private ArrayList rellenaVOsPlazosVista( ResultSet rs ) throws Exception{

     	Q02aPlazos plazos;

     	ArrayList listaPlazos = new ArrayList();

     	try{

     		if (tr.isTraceActive()){

 		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaVOsPlazos: entrando");                

 		    } 

     		while (rs.next()){	 

 	        	//se cargan en el objeto cuestionario los datos recuperados

     			plazos = new Q02aPlazos();

     			tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":rellenarVOsPlazos: Hay Datos");            

     			plazos = this.rellenarVO(plazos, rs); 

     			listaPlazos.add(plazos);

   			}  	  

     		return listaPlazos;

     	}catch(Exception ex){    	 	   

  	       java.io.StringWriter sw = new java.io.StringWriter();

  	       java.io.PrintWriter pw = new java.io.PrintWriter(sw);

  	       ex.printStackTrace(pw);

  	       tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenaVOsPlazos: " + sw.getBuffer ().toString());

  	       throw ex;

  		}finally{			 	

  			if (tr.isTraceActive()){

  		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaVOsPlazos: saliendo");                

  		    }    				

  		}

     }//fin rellenarVOsPlazosVista(rs) 

    
    /**
     * 
     * @param plazos plazos
     * @param rs rs
     * @return plazos
     * @throws Exception Exception
     */
    private Q02aPlazos rellenarVO(Q02aPlazos plazos, ResultSet rs) throws Exception{

    	try {

    		if (tr.isTraceActive()){

 		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenarVO: entrando");                

 		    } 

			plazos.setFechaAlta(Q02aFormatData.formatearFecha( Q02aFormatData.checkStringNull( rs.getString( Q02aTablaBDQ022AS01V01.NOMCOLUMN_Q022AT00_FEC_ALTA)), Q02aConstantes.FORMATO_FECHA_FORMAT_DATA, this.getIdioma()));

			plazos.setAnyo(rs.getString(Q02aTablaBDQ022AS01V01.COLUMN_Q022AT00_ANO));

	    	plazos.setFechaModificacion(Q02aFormatData.formatearFecha( Q02aFormatData.checkStringNull( rs.getString( Q02aTablaBDQ022AS01V01.NOMCOLUMN_Q022AT00_FEC_MOD)), Q02aConstantes.FORMATO_FECHA_FORMAT_DATA, this.getIdioma()));

	    	plazos.setMunicipio(rs.getString(Q02aTablaBDQ022AS01V01.NOMCOLUMN_MUN_MUNI));

	    	plazos.setNomMunicipio(rs.getString(Q02aTablaBDQ022AS01V01.COLUMN_MUNICIPIO_DS_O));

	    	plazos.setNomProvincia(rs.getString(Q02aTablaBDQ022AS01V01.COLUMN_PROVINCIA_DS_O));

	    	plazos.setNiPlazo(rs.getString(Q02aTablaBDQ022AS01V01.NOMCOLUMN_Q022AT00_NIPLAZO));

	    	plazos.setPlazo(rs.getString(Q02aTablaBDQ022AS01V01.NOMCOLUMN_Q022AT00_PLAZO));

	    	plazos.setProvincia(rs.getString(Q02aTablaBDQ022AS01V01.COLUMN_MUN_PROV));

	    	plazos.setTipoCuestionario(rs.getString(Q02aTablaBDQ022AS01V01.NOMCOLUMN_Q022NT00_CODIGO));

	    	plazos.setDescCuestionarioEs(rs.getString(Q02aTablaBDQ022AS01V01.NOMCOLUMN_Q022NT00_DESC_ES));

	    	plazos.setDescCuestionarioEu(rs.getString(Q02aTablaBDQ022AS01V01.NOMCOLUMN_Q022NT00_DESC_EU));

	    	return plazos;

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

	  	       java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	  	       ex.printStackTrace(pw);

	  	       tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenarVO: " + sw.getBuffer ().toString());

	  	       throw ex;

		}

    	

    }

     
    /**
     * 
     * @param tablaPlazos tablaPlazos
     * @return niPlazo
     * @throws Exception Exception
     */
     private int dameSeqNiPlazos(Q02aTablaBDQ022AS00 tablaPlazos) throws Exception 

     {

    	int niPlazo=1;

     	ResultSet rs = null;

       	PreparedStatement prepStmt =null;	

     	try{

	    	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dameSeqNiPlazos: entrando");

	    	}

    		StringBuffer query = new StringBuffer(" SELECT Q022AQ00.NEXTVAL FROM DUAL ");

         	prepStmt = this.getConnection().prepareStatement(query.toString());         	

         	rs = prepStmt.executeQuery();

         	tablaPlazos.addResultSet(rs);

         	tablaPlazos.addStatement(prepStmt);        	

         	if (rs.next()){

         		niPlazo = rs.getInt(1);

         		

         	}	         	

         	return niPlazo;

        }

	        catch(Exception ex)

     	        {   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":dameSeqNiPlazo: " + sw.getBuffer ().toString());

     		throw ex;

     	      }

     }//dameSegNiPlazos

     
     /**
      * 
      * @param plazo plazo
      * @param tablaPlazos tablaPlazos
      * @param esAlta esAlta
      * @throws Exception Exception
      */
     public void rellenaDatosPlazos(Q02aPlazos plazo,Q02aTablaBDQ022AS00 tablaPlazos, boolean esAlta) throws Exception {

       	//se definen objetos necesarios.

       	try{

   	    	if (tr.isTraceActive())

   	    	{

   	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaDatosPlazos: entrando");

   	    	}         	         

        	//se aaden los datos

   	    	tablaPlazos.setQ022AT00_ANO(Q02aFormatData.checkIntegerNull(plazo.getAnyo()));

   	    	tablaPlazos.setQ022AT00_NIPLAZO(Q02aFormatData.checkIntegerNull(plazo.getNiPlazo()));

   	    	tablaPlazos.setQ022AT00_PLAZO(Q02aFormatData.checkIntegerNull(plazo.getPlazo()));

   	    	tablaPlazos.setQ022NT00_CODIGO(Q02aFormatData.checkStringNull(plazo.getTipoCuestionario()));

   	    	tablaPlazos.setMUN_MUNI(Q02aFormatData.checkStringNull(plazo.getMunicipio()));

   	    	tablaPlazos.setMUN_PROV(Q02aFormatData.checkStringNull(plazo.getProvincia()));

   	    	if (esAlta){

   	    		tablaPlazos.setQ022AT00_FEC_ALTA(new java.util.Date(System.currentTimeMillis()));

   	    	}

   	    	else {

   	    		tablaPlazos.setQ022AT00_FEC_MOD(new java.util.Date(System.currentTimeMillis()));

   	    	}

       	}catch(Exception ex){   	   

       		java.io.StringWriter sw = new java.io.StringWriter();

       		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

       		ex.printStackTrace(pw);

       		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenaDatosPlazos: " + sw.getBuffer ().toString());

       		throw ex;

       	}finally{    		

   			if (tr.isTraceActive()){

   				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaDatosPlazos: saliendo = " + tablaPlazos.getQ022AT00_NIPLAZO());                

              }       	

       	}	

     }//rellenaDatosPlazos 

       
     /**
      * 
      * @return listaPlazos
      * @throws Exception Exception
      */
    public ArrayList getPlazos() throws Exception {		

 		//se instancian los objetos necesarios para realizar la consulta.			

 		Q02aTablaBDQ022AS01V01 vistaPlazos=null;

 		ResultSet rs = null;

 		ArrayList listaPlazos = new ArrayList();

 		

 		try{

 	    	if (tr.isTraceActive()){

 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getPlazos: entrando");

 			}

 	    	

 	    	//se instancia la clase del tablas bd a llamar pasandole la conexion	    	

 	    	vistaPlazos = new Q02aTablaBDQ022AS01V01(this.getConnection());

 	    	vistaPlazos.setOrderBy(Q02aTablaBDQ022AS01V01.NOMCOLUMN_Q022AT00_NIPLAZO + " DESC");

 	    	//se realiza la select

 	    	rs = vistaPlazos.select();

 	    	//aadimos el cursos para luego poder liberarlo ( en el freeResources)

 	    	vistaPlazos.addResultSet(rs); 

 	    	//se trata el resultado obtenido aadiendolo a la lista de salida

 	    	listaPlazos = this.rellenaVOsPlazosVista(rs);

    	

 	    	return listaPlazos;    	

 		}catch(Exception ex){ 	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getPlazos: " + sw.getBuffer ().toString());

     		throw ex;

 		}finally{

 		 	try{

 		 		//liberamos los recursos OJO! LOS QUE SE HAN AADIDO CON addResultSet

 		 		vistaPlazos.freeResourcesNotConnection();	

 			 }catch(Exception ex)

 			 {

 			    if (tr.isTraceActive())

 			    {

 				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getPlazos: error liberando recursos.");

 	   	   	    }  

 			 }  		 			

 			 if (tr.isTraceActive()){

 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getPlazos: saliendo.");                

 	         }   

 		}	

 	}//fin getPlazos

    

    /**
     * Mtodo que dado el nmero interno del plazo 
     * recupera de la BBDD los datos de dicho plazo
     * @param niPlazo niPlazo
     * @return plazoBD
     * @throws Exception Exception
     */

    public Q02aPlazos obtenerPlazo(String niPlazo)throws Exception {

  	  if (tr.isTraceActive()){

 		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerPlazo , ** dao niPlazo= "+  niPlazo + "  ** entrando");            

      }

  	  

  	  //se crean los objetos necesarios para realizar la select.

  	  Q02aTablaBDQ022AS01V01 Q02aTablaBDQ022AS01V01obj = null;

  	  Q02aPlazos plazoBD = null;

  	  ResultSet rs = null;   	  

        try{ 

          if (niPlazo!=null){           

        	  Q02aTablaBDQ022AS01V01obj = new Q02aTablaBDQ022AS01V01(this.getConnection());

          	

          	//se pone el filtro

        	  Q02aTablaBDQ022AS01V01obj.setQ022AT00_NIPLAZO_WHERE(new Integer(niPlazo));

        

          	rs = Q02aTablaBDQ022AS01V01obj.select();

          	Q02aTablaBDQ022AS01V01obj.addResultSet(rs);

          	plazoBD = new Q02aPlazos();

          	if (rs.next()){

          		plazoBD = this.rellenarVO(plazoBD,rs);

          	}

          }  

          return plazoBD;

          }catch(Exception ex){           	   

                 java.io.StringWriter sw = new java.io.StringWriter();

                 java.io.PrintWriter pw = new java.io.PrintWriter(sw);

                 ex.printStackTrace(pw);

                 tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerPlazo: " + sw.getBuffer ().toString());

                 throw ex;

          }finally{

       	   try{

       		Q02aTablaBDQ022AS01V01obj.freeResourcesNotConnection();	

  				}catch(Exception ex){

  	   			if (tr.isTraceActive()){

  	   				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerPlazo: error liberando recursos");

  	   		   	   }  

  				}  	

           	  if (tr.isTraceActive()){

           		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerPlazo: saliendo");                

                }            	 

          }	  

    }//fin obtenerPlazo

     

     /**

      * Funcin que inserta los datos del plazo pasado como parmetro en la BBDD

      * @param plazo - Datos del plazo a insertar 

      * @throws Exception Exception

      */

     public void insertarPlazos(Q02aPlazos plazo) throws Exception {

    	int niPlazo = 0; 

    	Q02aTablaBDQ022AS00 tablaPlazos=null;

       	try{

	    	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarPlazos: entrando");

	    	}

    		//se crea el objeto de tablasBD

	    	tablaPlazos = new Q02aTablaBDQ022AS00(this.getConnection());

      		//primero recuperamos el nmero interno que le corresponde

    	   	niPlazo = dameSeqNiPlazos(tablaPlazos);

         	plazo.setNiPlazo(Integer.toString(niPlazo));      	

      		//se aaden los datos a insertar

         	this.rellenaDatosPlazos(plazo, tablaPlazos,true);         	         

      		//se realiza la insert

      		tablaPlazos.insert();

     	}

     	catch(Exception ex)

     	{   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarPlazos: " + sw.getBuffer ().toString());

     		throw ex;

     	}

     	finally

     	{

     		try

     		{

     			tablaPlazos.freeResourcesNotConnection();	

     		}

     		catch(Exception ex)

     		{

     			if (tr.isTraceActive())

     			{

     				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarPlazos: error liberando recursos");

 		   	   }  

 		}  		

		if (tr.isTraceActive())

		{

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarPlazos: saliendo");                

    		}       	

     	}

     } //insertarPlazos    

      

     /**

      * Funcin que borra el plazo pasado como parmetro de la BBDD

      * @param niPlazo - nmero interno del plazo a borrar

      * @throws Exception Exception

      */

     public void borrarPlazos(String niPlazo) throws Exception {

      	if (tr.isTraceActive()){

      		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarPlazos: entrando");

      	}

      	Q02aTablaBDQ022AS00 Q02aTablaBDQ022AS00obj = null;

        try{       	

        	//se crean los objetos necesarios

         	Q02aTablaBDQ022AS00obj = new Q02aTablaBDQ022AS00(this.getConnection());   

         	

        	// segmento tecnico

            Q02aTablaBDQ022AS00obj.setUser(this.getUser());

         	

         	//se pone el filtro para la delete

         	Q02aTablaBDQ022AS00obj.setQ022AT00_NIPLAZO_WHERE(Integer.parseInt(niPlazo));         	

         	

         	//se lanza el delete

          	Q02aTablaBDQ022AS00obj.delete();         	

         }

         catch(Exception ex)

         {

              java.io.StringWriter sw = new java.io.StringWriter();

              java.io.PrintWriter pw = new java.io.PrintWriter(sw);

              ex.printStackTrace(pw);

              tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarPlazos: " + sw.getBuffer ().toString());

              throw ex;

         } 

         finally {

         	try{

         		Q02aTablaBDQ022AS00obj.freeResourcesNotConnection();	

         	}

         	catch(Exception ex) {

         		if (tr.isTraceActive()) {

         			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarPlazos: error liberando recursos");

         		}  

         	}  		

         	if (tr.isTraceActive()) {

         		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarPlazos: saliendo");                

            }     	   

         }

     }//fin borrarPlazos

     

     /**

      * Funcin que modifica los datos del plazo pasado como parmetro en la BBDD

      * @param plazo - Datos del plazo a modificar

      * @throws Exception Exception

      */

     public void modificarPlazos(Q02aPlazos plazo) throws Exception {



      	if (tr.isTraceActive()){

  		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarPlazos: entrando");

      	}

      	//Se instancian los objetos necesarios.

      	Q02aTablaBDQ022AS00 Q02aTablaBDQ022AS00obj = null;    

         	 try

         	 {     

         	 	//se crea el objeto de tablasBD

        		Q02aTablaBDQ022AS00obj = new Q02aTablaBDQ022AS00(this.getConnection());

        		

        		//segmento tecnico

             	//Q02aTablaBDQ022AS00obj.setUser(this.getUser());

        		  		

        		rellenaDatosPlazos(plazo,Q02aTablaBDQ022AS00obj,false);

        		Q02aTablaBDQ022AS00obj.setQ022AT00_NIPLAZO_WHERE(Integer.parseInt(plazo.getNiPlazo()));

       		       		

        		//se realiza la update

        		Q02aTablaBDQ022AS00obj.update();

         	 }

         	 catch(Exception ex) {

         		java.io.StringWriter sw = new java.io.StringWriter();

         		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

         		ex.printStackTrace(pw);

         		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarPlazos: " + sw.getBuffer ().toString());

              throw ex;

         	 }

         	 finally {     

         		 try {

         			 Q02aTablaBDQ022AS00obj.freeResourcesNotConnection();	

         		 }

         		 catch(Exception ex) {

         			 if (tr.isTraceActive()) {

         				 tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarPlazos: error liberando recursos");

         			 }  

         		 }  		  

         		 if (tr.isTraceActive()) {

         			 	tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarPlazos: saliendo");                

                 }             

         	 }     

     } // fin modificarPlazos

}

