package q02a.exe.plazos.beans;

import java.util.ArrayList;

import q02a.exe.arquitectura.beans.Q02aBaseBean;
import q02a.exe.plazos.dataobjects.Q02aPlazosDataBaseDAO;
import q02a.exe.plazos.valueobjects.Q02aPlazos;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

/**
 * 
 * @author GADIMAAR
 *
 */   
public class Q02aPlazosBean extends Q02aBaseBean{

	private static final long serialVersionUID = 5474311672836163390L;

	protected Q02aPlazosDataBaseDAO daoPlazos = null;

	final static String	LISTA_PLAZOS = "listaPlazos";

	

	/** Constructor vacio */

    public Q02aPlazosBean() {

        super();

    }



    /**
     * Funcin que recupera los plazos
     * @return listaPlazos  -  Listado de plazos obtenidos
     * @throws Exception Exception
     */

	public ArrayList getPlazos() throws Exception 
	{
		 if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getPlazos: entrando.");
	   		}  	  
		ArrayList listaPlazos = new ArrayList();
		boolean error = false;
		
		try{
			//se abre la conexin
			abrirConexion();
			//se instancia el dao pasandole la conexin			
			daoPlazos = new Q02aPlazosDataBaseDAO(this.getConn());
			
			//Segmento tecnico 
  			//daoPlazos.setUser(this.getAutenticador().getUser());
  			//daoPlazos.setIdioma(this.getAutenticador().getIdioma());
			
			listaPlazos = daoPlazos.getPlazos();
            return listaPlazos;              
	  } catch(Exception ex){
 		  error= true;
          java.io.StringWriter sw = new java.io.StringWriter();
          java.io.PrintWriter pw = new java.io.PrintWriter(sw);
          ex.printStackTrace(pw);
          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getPlazos: " + sw.getBuffer ().toString());
          throw ex;                     
 	  }finally{
 		 try{
 			daoPlazos.freeResourcesNotConnection();
		   }catch(Exception ex){
			   if (tr.isTraceActive()){
				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getPlazos: error liberando recursos");
	   	   	   }  
		   }  		 
 		  	//se cierra la conexin  
 		  	cerrarConexion(error);	       	
	        if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getPlazos: saliendo.");
	   		}
 	  	}
 	  } //fin getPlazos 
	
	
	/**
     * Mtodo que dado el nmero interno del plazo 
     * recupera de la BBDD los datos de dicho cuestionario.
     * @param niPlazo niPlazo
     * @throws Exception Exception
     * @return Plazo
     */

	public Q02aPlazos obtenerPlazo(String niPlazo)throws Exception{  	 

	    	boolean error = false;

	    	Q02aPlazos plazo = null;

	  	  	try  	  {

	  	  		if (tr.isTraceActive()){

	  	  			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerPlazo, ** niPlazo bean=" + niPlazo + " *** entrando");                

	  	  		}

	  	  		

	  	  		//se abre la conexin

	  	  		abrirConexion();

	  	  		

	  	  		//se instancia el dao pasandole la conexin			

	  	  		daoPlazos = new Q02aPlazosDataBaseDAO(this.getConn());

	  	  		

	  	  		//Segmento tecnico 

	  			//daoPlazos.setUser(this.getAutenticador().getUser());

	  			//daoPlazos.setIdioma(this.getAutenticador().getIdioma());

	  			

	  	  		//se llama al mtodo del dao que recupera el plazo

	  	  		plazo = daoPlazos.obtenerPlazo(niPlazo);

	  	  		

	  	  		//se devuelve el cuestionario recuperado

	  	  		return plazo;

	  	  }catch(Exception ex){

	  		  	error= true;

	  		  	java.io.StringWriter sw = new java.io.StringWriter();

	          	java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	          	ex.printStackTrace(pw);

	          	tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerPlazo: " + sw.getBuffer ().toString());

	          	throw ex;                     

	 	  }finally{

	 		  	try{

	 		  		daoPlazos.freeResourcesNotConnection();

	 		  	}catch(Exception ex){

				   if (tr.isTraceActive()){

					   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerPlazo: error liberando recursos");

		   	   	   }  

	 		  	}  		 

	 		  	//se cierra la conexin  

	 		  	cerrarConexion(error);	       	

		        if (tr.isTraceActive()){

		   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerPlazo: saliendo.");

		   		}

	 	  }

	    }//fin obtenerPlazo

	

	/**

     * Funcin que inserta los datos del plazo pasado como parmetro en la BBDD

     * @param plazo - Datos del plazo a insertar

     * @throws Exception Exception

     */

      public void insertarPlazos(Q02aPlazos plazo) throws Exception {   	 

    	boolean error = false;

    	try{

    		if (tr.isTraceActive()){

      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarPlazos: entrando");

      		}

	  		//se abre la conexin

			abrirConexion();

			

			//se instancia el dao pasandole la conexin			

			daoPlazos = new Q02aPlazosDataBaseDAO(this.getConn());

			

			//se pasan los parmetros de usuario e idioma

			//daoPlazos.setUser(this.autenticador.getUser());

			//daoPlazos.setIdioma(this.autenticador.getIdioma());

			

			//se llama la metodo del DAO que realiza la insert

			daoPlazos.insertarPlazos(plazo);

    	}catch(Exception ex){

	 		error= true;

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarPlazos: " + sw.getBuffer ().toString());

	        throw ex;                     

 	  }finally{

 		    try{

 		    	daoPlazos.freeResourcesNotConnection();

 		    }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarPlazos: error liberando recursos");

	   	   	   }  

 		    }  		 

 		  	//se cierra la conexin  

 		    cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarPlazos: saliendo.");

	   		}

 	  }

    }//fin insertarPlazos

      

      /**

       * Funcin que borra el plazo pasado como parmetro de la BBDD 

       * @param niPlazo - nmero interno del plazo a borrar

       * @throws Exception Exception

       */

    public void borrarPlazos(String niPlazo) throws Exception { 

    		if (tr.isTraceActive()){

  			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarPlazos: entrando");

    		}

    		boolean error = false;

    		try{

    			//se abre la conexin

    			abrirConexion();

   			

    			//se instancia el dao pasandole la conexin			

    			daoPlazos = new Q02aPlazosDataBaseDAO(this.getConn());

  			

    			//Segmento tecnico 

    			//daoPlazos.setUser(this.getAutenticador().getUser());

    			//daoPlazos.setIdioma(this.getAutenticador().getIdioma()); 



				daoPlazos.borrarPlazos(niPlazo);   		 	  

    		}catch(Exception ex){

    			error= true;

    			java.io.StringWriter sw = new java.io.StringWriter();

    			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

    			ex.printStackTrace(pw);

    			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarPlazos: " + sw.getBuffer ().toString());

    			throw ex;           

  	  

    		}finally{

    			try{

    				daoPlazos.freeResourcesNotConnection();

    			}catch(Exception ex){

    				if (tr.isTraceActive()){

    					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarPlazos: error liberando recursos");

  	   	   	   		}  

    			}  		 

   		  		//se cierra la conexin  

   		  		cerrarConexion(error);	       	

   		  		if (tr.isTraceActive()){

   		  			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarPlazos: saliendo.");

   		  		}

    		}

    }//fin borrarPlazos

    

    /**
     * Funcin que modifica los datos del cuestionario pasado como parmetro en la BBDD
     * @param plazo plazo
     * @throws Exception Exception
     */

    public void modificarPlazos(Q02aPlazos plazo) throws Exception {

   	 if (tr.isTraceActive()){

  			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarPlazos: entrando");

  		}

   	 boolean error = false;

   	try{

   		//se abre la conexin

   		abrirConexion();

   		//se instancia el dao pasandole la conexin			

   		daoPlazos = new Q02aPlazosDataBaseDAO(this.getConn());

		

   		//Segmento tecnico 

		//daoPlazos.setUser(this.getAutenticador().getUser());

   		//daoPlazos.setIdioma(this.getAutenticador().getIdioma()); 



   		//se llamaa la metodo del DAO que realiza la update

   		daoPlazos.modificarPlazos(plazo);

   		    	

   	}catch(Exception ex){

		 error= true;

         java.io.StringWriter sw = new java.io.StringWriter();

         java.io.PrintWriter pw = new java.io.PrintWriter(sw);

         ex.printStackTrace(pw);

         tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarPlazos: " + sw.getBuffer ().toString());

         throw ex;                     

	  }finally{

		 try{

			daoPlazos.freeResourcesNotConnection();

		   }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarPlazos: error liberando recursos");

	   	   	   }  

		   }  		 

		  	//se cierra la conexin  

		  	cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarPlazos: saliendo.");

	   		}

	  }

   }//modificarPlazos

}