package q02a.exe.listados;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;

import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;

import org.apache.fop.apps.Driver;

import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesException;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;

/**
 * 
 * @author GADIMAAR
 *
 */
public class Q02AUtils {
       
    
    /**
     * 
     * @param xml xml
     * @param pdf pdf
     * @param inStream inStream
     * @throws Exception  Exception
     */
    public static void convertXML2PDF(StringReader xml, File pdf, InputStream inStream) throws Exception
    {
        try{
            //System.out.println(" ----- inicio_convert_xml ----- ");
            
            //Setup output
            OutputStream out = new java.io.FileOutputStream(pdf);
            try {
                //Construct driver
                Driver driver = new Driver();
                //Setup Renderer (output format)        
                driver.setRenderer(Driver.RENDER_PDF);
                //Setup output
                driver.setOutputStream(out);
                
                //Setup XSLT
                TransformerFactory factory = TransformerFactory.newInstance();
                Transformer transformer = factory.newTransformer(new StreamSource(inStream));
                //Setup input for XSLT transformation
                Source src = new StreamSource(xml);
                //Resulting SAX events (the generated FO) must be piped through to FOP
                Result res = new SAXResult(driver.getContentHandler());
                
                //Start XSLT transformation and FOP processing
                transformer.transform(src, res);
                //System.out.println("----- final_convert_xml ----- ");
            }
            finally
            {
                try { out.close(); } catch (IOException ioe) {}
            }
        }
        catch(Exception e)
        {
            //System.out.println("Excepcion al crear el pdf:" + e.toString() );
            throw e;
        }
    }
    
    //Devolver del fichero de recursos
    /**
     * @return resultado
     * @param ambito ambito
     * @param key key
     * @param idioma idioma
     * @throws Q70GestorMensajesException Q70GestorMensajesException
     * @throws IllegalArgumentException IllegalArgumentException
     */
    public static String getI18nProperty(String ambito, String key, String idioma) 
    throws Q70GestorMensajesException, IllegalArgumentException {
       String resultado="";
        try{            
            if (ambito == null || key == null || idioma == null) {
                throw new IllegalArgumentException("Se ha producido un error al buscar la propiedad de ambito:" + ambito
                        + ", key:" + key + ", idioma:" + idioma);
            }
            Q70GestorMensajesi18n mensajes = Q70GestorMensajesi18n.getSingleton();
            
            resultado=mensajes.getMessage(ambito, key, idioma);
        }
        catch(Exception e)
        {            
            e.printStackTrace();
        }
        
        return resultado;
    }
    
    public static String getI18nPropertyParams(String ambito, String key, String idioma,Object[] params) 
    throws Q70GestorMensajesException, IllegalArgumentException {
       String resultado="";
        try{            
            if (ambito == null || key == null || idioma == null) {
                throw new IllegalArgumentException("Se ha producido un error al buscar la propiedad de ambito:" + ambito
                        + ", key:" + key + ", idioma:" + idioma);
            }
            Q70GestorMensajesi18n mensajes = Q70GestorMensajesi18n.getSingleton();
            
            resultado=mensajes.getMessage(ambito, key, idioma,params);
        }
        catch(Exception e)
        {            
            e.printStackTrace();
        }
        
        return resultado;
    }    
}