package q02a.exe.cuestionariosVTMAnu.launcher;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;

import q02a.exe.arquitectura.beans.Q02aBaseBean;
import q02a.exe.arquitectura.dataobjects.Q02aDAOException;
import q02a.exe.arquitectura.webCommon.beans.Q02aProcessLauncherBean;
import q02a.exe.arquitectura.webCommon.utils.gdtp.Q02aGenericDataTransferProtocol;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.infraestructura.traza.Q70Traza;


import q02a.exe.cuestionariosVTMAnu.beans.Q02aCuestionariosVTMAnuBean;

/**
 * 
 * @author GADIMAAR
 *
 */
public class Q02aCuestionariosVTMAnuLauncher extends Q02aBaseBean implements Q02aProcessLauncherBean {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1677342344158205416L;
	/** Objeto tablaBD usado para buscar en base de datos */
	//protected TablaBDWWHISPLA tablaHISPLA=null;

	private static Q70Traza tr = Q70Traza.getSingleton();
	private static final String COMPONENTE = "DAO_CUESTIONARIOS_AYUN_MEN_ACCESO_DATOS";
	
	private  String user = ""; 
	/**
     *  Constructor vaco
     */

	 /* (non-Javadoc)
     * @see com.bbk.arquitectura.webCommon.beans.ProcessLauncherBean#initProcessLauncherBean(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
     */
    /**
     * @param request request
     * @param response response
     * @throws Q02aDAOException Q02aDAOException
     * 
     */
    public void initProcessLauncherBean(HttpServletRequest request, HttpServletResponse response) throws Q02aDAOException {
		init(request,response);

    }

	/* (non-Javadoc)
     * @see com.bbk.arquitectura.webCommon.beans.ProcessLauncherBean#initProcessLauncherBean(javax.servlet.jsp.PageContext)
     */
    /**
     * @param context context
     * @throws Q02aDAOException Q02aDAOException
     */
    public void initProcessLauncherBean(PageContext context) throws Q02aDAOException {
    	this.request = (HttpServletRequest)context.getRequest();
    	this.response =(HttpServletResponse)context.getResponse(); 	
    }

    /**
     * @throws Exception Exception
     * @return excp
     */
	 public Q02aGenericDataTransferProtocol launch() throws Exception {
    	try{	       
	            if (tr.isTraceActive())
	            {
			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":launch: entrando");
	             }
	            String proceso = getParametro("METHOD");
	            if (proceso.equals("getAnosSinActuacionesParaMuni"))
	            {
	            	return this.getAnosSinActuacionesParaMuni();	            	
	            }
	            else if (proceso.equals("obtenerCampoRealizaActuacionDeGrupoConMuniAno"))
	            {
	            	return this.obtenerCampoRealizaActuacionDeGrupoConMuniAno();
	            }
	            else if (proceso.equals("guardarFirmaCuestionariosVTMAnu"))
	            {
	            	return this.guardarFirmaCuestionariosVTMAnu();
	            }
	            return null;
    	}
    	catch(Exception e)
    	{
	           return this.processException(e);
        	}
     }
     
     /**
    * Mtodo que llama al Bean de CuestionariosVTMAnu que obtiene el campo Realiza Actuaciones para el grupo del municipio, ao y mes seleccionados
    * @return result
    * @throws Exception Exception
    */
   public Q02aGenericDataTransferProtocol obtenerCampoRealizaActuacionDeGrupoConMuniAno() throws Exception {
    	
    	if (tr.isTraceActive())
    	{
		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCampoRealizaActuacionDeGrupoConMuniAno: entrando");
	}
    	
    	Q02aGenericDataTransferProtocol result = new Q02aGenericDataTransferProtocol(); 
    	Q02aCuestionariosVTMAnuBean beanCuestionariosVTMAnu = new Q02aCuestionariosVTMAnuBean();
    	
        try{ 
        
        	String codProv = ((String)getMapaDatos().get("codProv"));
        	String codMuni = ((String)getMapaDatos().get("codMuni"));
        	String ano = ((String)getMapaDatos().get("ano"));
        	
			String ActuacionesAno = beanCuestionariosVTMAnu.obtenerCampoRealizaActuacionDeGrupoConMuniAno(codProv,codMuni,ano);         	 
 			 
 			result.addGroup("RESULT_1"); 			
 			
 			result.addProperty("RESULT_1","RESULT","OK");
 			result.addProperty("RESULT_1","REALIZA_ACTUACION", ActuacionesAno);
						
        	return result;
        
       }catch(Exception ex){
            result.addProperty("RESULT_1","RESULT","NOOK");
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCampoRealizaActuacionDeGrupoConMuniAno: " + sw.getBuffer ().toString());
            throw new Q02aDAOException(ex);
       }finally{
    	   
    	   if (tr.isTraceActive()){
    		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCampoRealizaActuacionDeGrupoConMuniAno: saliendo");                
           }
           
       }
       
   }
     
    

  
   /**
    * Mtodo que llama al Bean de CuestionariosVTMAnu que obtiene los  aos que no se han introducido cuestionarios para el municipio seleccionados
    * @return result
    * @throws Exception Exception
    */
   public Q02aGenericDataTransferProtocol getAnosSinActuacionesParaMuni() throws Exception {
    	
    	if (tr.isTraceActive())
    	{
		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getAnosSinActuacionesParaMuni: entrando");
	}
    	
    	Q02aGenericDataTransferProtocol result = new Q02aGenericDataTransferProtocol(); 
    	Q02aCuestionariosVTMAnuBean beanCuestionariosVTMAnu = new Q02aCuestionariosVTMAnuBean();
    	
        try{ 
        
        	String codProv = ((String)getMapaDatos().get("codProv"));
        	String codMuni = ((String)getMapaDatos().get("codMuni"));
        	String ano = ((String)getMapaDatos().get("ano"));
        	String idioma = ((String)getMapaDatos().get("idioma"));
        	
        	String msgAnos = beanCuestionariosVTMAnu.obtenerAnosSinActuacionesParaMuni(codProv,codMuni,ano,idioma);         	 
 			 
 	result.addGroup("RESULT_1"); 			
 			
 	result.addProperty("RESULT_1","RESULT","OK");
 	result.addProperty("RESULT_1","MSG_ANOS", msgAnos);
						
        	return result;
        
       }catch(Exception ex){
            result.addProperty("RESULT_1","RESULT","NOOK");
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getAnosSinActuacionesParaMuni: " + sw.getBuffer ().toString());
            throw new Q02aDAOException(ex);
       }finally{
    	   
    	   if (tr.isTraceActive()){
    		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getAnosSinActuacionesParaMuni: saliendo");                
           }
           
       }
       
   }
   /**
    * Mtodo que llama al Bean de CuestionariosVTMAnu para guardar la firma del grupo de cuestionarios
    * @return result
    * @throws Exception Exception
    */
   public Q02aGenericDataTransferProtocol guardarFirmaCuestionariosVTMAnu() throws Exception 
   {
    	
    	if (tr.isTraceActive())
    	{
		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":guardarFirmaCuestionariosVTMAnu: entrando");
	}
    	
    	Q02aGenericDataTransferProtocol result = new Q02aGenericDataTransferProtocol(); 
    	Q02aCuestionariosVTMAnuBean beanCuestionariosVTMAnu = new Q02aCuestionariosVTMAnuBean();
    	
        try{ 
        
        	String niGrupoCuesVTMAnu = ((String)getMapaDatos().get("niGrupoCuesVTMAnu"));
        	String xmlFirmaGrupoCuesVTMAnu = ((String)getMapaDatos().get("xmlFirmaGrupoCuesVTMAnu"));
        	
        	beanCuestionariosVTMAnu.guardarFirmaGrupoCuestionariosVTMAnu(niGrupoCuesVTMAnu,xmlFirmaGrupoCuesVTMAnu);         	 
 			 
 		result.addGroup("RESULT_1"); 				
 		result.addProperty("RESULT_1","RESULT","OK");
						
        	return result;
        
       }catch(Exception ex){
            result.addProperty("RESULT_1","RESULT","NOOK");
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":guardarFirmaCuestionariosVTMAnu: " + sw.getBuffer ().toString());
            throw new Q02aDAOException(ex);
       }finally{
    	   
    	   if (tr.isTraceActive()){
    		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":guardarFirmaCuestionariosVTMAnu: saliendo");                
           }
       }
   }   
  
}