package q02a.exe.cuestionariosVTMAnu.beans;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;

import javax.ejb.EJBException;
import javax.naming.NamingException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import q02a.exe.arquitectura.beans.Q02aBaseBean;
import q02a.exe.arquitectura.dataobjects.Q02aDAOException;
import q02a.exe.arquitectura.utils.xml.Q02aXMLBuilder;
import q02a.exe.comun.Q02aUsuarioInformanteDataBaseDAO;
import q02a.exe.comun.dataobjects.Q02aNoraDataBaseDAO;
import q02a.exe.comun.dataobjects.Q02aTablasDataBaseDAO;
import q02a.exe.contactos.dataobjects.Q02aContactosDataBaseDAO;
import q02a.exe.contactos.valueobjects.Q02aContactos;
import q02a.exe.cuestionariosVTMAnu.dataobjects.Q02aCuestionariosVTMAnuDataBaseDAO;
import q02a.exe.cuestionariosVTMAnu.valueobjects.Q02aCuestionarioVTMAnu;
import q02a.exe.cuestionariosVTMAnu.valueobjects.Q02aCuestionarioVTMAnuFiltro;
import q02a.exe.cuestionariosVTMAnu.valueobjects.Q02aCuestionarioVTMFiltro;
import q02a.exe.informantes.dataobjects.Q02aInformantesDataBaseDAO;
import q02a.exe.informantes.valueobjects.Q02aInformante;
import q02a.exe.solicitudesNora.dataobjects.Q02aSolicitudesNoraDataBaseDAO;
import q02a.exe.solicitudesNora.valueobjects.Q02aSolicitudNora;
import q02a.exe.tablasBD.jdbc.oracle.Q02aTablaBDQ022DS01V02;
import q02a.exe.utils.Q02aConstantes;
import q02a.exe.utils.Q02aFormatData;
import es.ejie.frmk.conectores.conectorJDBC.Q70ConectorJDBC;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import q02a.exe.comun.valueobjects.Q02aPortal;

import java.text.SimpleDateFormat;
import java.util.Date;



   /**
    * 
    * @author GADIMAAR
    *
    */
public class Q02aCuestionariosVTMAnuBean extends Q02aBaseBean{

	private static final long serialVersionUID = 5474311672836163390L;
	protected Q02aCuestionariosVTMAnuDataBaseDAO daoCuestionariosVTMAnu = null;
	protected Q02aTablasDataBaseDAO daoTablas = null;
	protected Q02aSolicitudesNoraDataBaseDAO daoSolicitudesNora = null;
	protected Q02aNoraDataBaseDAO daoNora = null;
	
    
    /** Obtenemos el nombre del DataSource de nuestra aplicación */
    private String Q02A_JNDI_DATASOURCE = Q70ListenerUtils.getApplicationProperty(this.getClass().getName(),null,"Q02A_JNDI_DATASOURCE");

    
    /** Constructor vacio */
    public Q02aCuestionariosVTMAnuBean() {
        super();
    }

    /**
     * 
     * @param cuestionariosVTMFiltro cuestionariosVTMFiltro
     * @return listaCuestionariosVTM
     * @throws Exception Exception
     */
	public ArrayList getCuestionariosVTM(Q02aCuestionarioVTMFiltro cuestionariosVTMFiltro) throws Exception 
	{
		 if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getCuestionariosVTM: entrando.");
	   		}  	  
		String idGrupo = null;	
		//int numReg = 0;		
		String noRegRecuperados = "NoHayCuestionariosVTM";
		ArrayList listaCuestionariosVTM = new ArrayList();
		boolean error = false;
		
		try{
			//se abre la conexion
			abrirConexion();
			//se instancia el dao pasandole la conexion			
			daoCuestionariosVTMAnu = new Q02aCuestionariosVTMAnuDataBaseDAO(this.getConn());
			
			idGrupo = daoCuestionariosVTMAnu.obtenerIdGrupoCuestionariosVTM(cuestionariosVTMFiltro);
			//numReg = daoCuestionariosVTMAnu.getCountCuestionariosVTM(cuestionariosVTMFiltro.getNiGrupoCuesVTMAnu());
		    		
			// Si el numero de registros a devueltos es menor que el maximo permitido
            // y se ha devuelto registros
            //if(numReg > 0){
			if(idGrupo!=null && !idGrupo.equals("")){
          	  listaCuestionariosVTM = daoCuestionariosVTMAnu.getSelectCuestionariosVTM(idGrupo);
            }
            return listaCuestionariosVTM;              
	  } catch(Exception ex){
 		  error= true;
          java.io.StringWriter sw = new java.io.StringWriter();
          java.io.PrintWriter pw = new java.io.PrintWriter(sw);
          ex.printStackTrace(pw);
          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getCuestionariosVTM: " + sw.getBuffer ().toString());
          throw ex;                     
 	  }finally{
 		 try{
 			daoCuestionariosVTMAnu.freeResourcesNotConnection();
		   }catch(Exception ex){
			   if (tr.isTraceActive()){
				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getCuestionariosVTM: error liberando recursos");
	   	   	   }  
		   }  		 
 		  	//se cierra la conexión  
 		  	cerrarConexion(error);	       	
	        if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getCuestionariosVTM: saliendo.");
	   		}
 	  	}
 	  } //fin getCuestionariosVTM 
	public ArrayList getEstadisticas(HashMap mapaFiltroPortadaCuestionarioVTM) throws Exception 
	{
		 if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getEstadisticas: entrando.");
	   		}  	  
		
		ArrayList listaEstadisticas = new ArrayList();
		boolean error = false;
		
		try{
			//se abre la conexion
			abrirConexion();
			//se instancia el dao pasandole la conexion			
			daoCuestionariosVTMAnu = new Q02aCuestionariosVTMAnuDataBaseDAO(this.getConn());
			
			listaEstadisticas = daoCuestionariosVTMAnu.obtenerEstadisticas(mapaFiltroPortadaCuestionarioVTM);
			
            
            return listaEstadisticas;              
	  } catch(Exception ex){
 		  error= true;
          java.io.StringWriter sw = new java.io.StringWriter();
          java.io.PrintWriter pw = new java.io.PrintWriter(sw);
          ex.printStackTrace(pw);
          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getCuestionariosVTM: " + sw.getBuffer ().toString());
          throw ex;                     
 	  }finally{
 		 try{
 			daoCuestionariosVTMAnu.freeResourcesNotConnection();
		   }catch(Exception ex){
			   if (tr.isTraceActive()){
				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getCuestionariosVTM: error liberando recursos");
	   	   	   }  
		   }  		 
 		  	//se cierra la conexión  
 		  	cerrarConexion(error);	       	
	        if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getCuestionariosVTM: saliendo.");
	   		}
 	  	}
 	  } //fin getCuestionariosVTM 
    
    /**
     * 
     * @param niGrupoCuesVTM niGrupoCuesVTM
     * @return listaCuestionariosVTM
     * @throws Exception Exception
     */
    public ArrayList getExpedientesVTM(Q02aCuestionarioVTMFiltro cuestionariosVTMFiltro) 
    throws Exception {
        if (tr.isTraceActive()){
            tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getSelectExpedientesCuestVTM: entrando.");
        }
        
        ArrayList listaCuestionariosVTM = new ArrayList();
        ////////////////////////--  SQL -- ///////////////////////////////////
        Date hoy = new Date();
        SimpleDateFormat formato = new SimpleDateFormat("dd/MM/yy");
        String fechaHoy = formato.format(hoy);

        Calendar hoy2 = Calendar.getInstance();
        hoy2.add(Calendar.YEAR, -1);
        
        String anoyPasado2 = (formato.format(hoy2.getTime())).substring(5, 8);
        
        StringBuffer hoyAnyoPasadoBuf = new StringBuffer();
            hoyAnyoPasadoBuf.append( fechaHoy.substring(0, 5) ).append( anoyPasado2 );
            
        final StringBuffer sql = new StringBuffer();
                    //sql.append("Select * from Q022DS01V02 ");
                      sql.append("Select ").append( 
                          "q022bt00.Q022BT00_ANO, q022bt00.Q022BT00_MES, Q022DS01V02.Q022DT00_CODIGO_LICEN, " +
                          "Q022DS01V02.Q022DT00_IDEN_LICEN, Q022DS01V02.Q022DT00_RS_PROMO, Q022DS01V02.Q022DT00_NORA_T17_LOCALIZACION" +  
                          " from Q022DS01V02, Q022BT00 ");
                      
        final StringBuffer where = new StringBuffer();
                    where.append(" WHERE Q022DS01V02.fca02t00_codprovinc =").append( cuestionariosVTMFiltro.getCodProv() ).append(
                          " and Q022DS01V02.fca02t00_codmunicip=").append( cuestionariosVTMFiltro.getCodMuni() ).append(
                          " and Q022DS01V02.Q022BT00_ID_GRUPO = q022bt00.Q022BT00_ID_GRUPO").append(        
                        //" and q022dt00_fec_ent between ").append( "'09/07/11'" ).append(" and ").append( "'09/07/12'");
                          " and q022dt00_fec_ent between to_date('").append( hoyAnyoPasadoBuf.toString() ).append("','dd/MM/yy') and to_date('").append( fechaHoy ).append("','dd/MM/yy')");
        
        final StringBuffer order = new StringBuffer();
                    order.append(" order by q022bt00.Q022BT00_ANO, q022bt00.Q022BT00_MES, Q022DS01V02.Q022DT00_CODIGO_LICEN ");
        /*Select q022bt00.Q022BT00_ANO, q022bt00.Q022BT00_MES, Q022DS01V02.Q022DT00_CODIGO_LICEN, 
          Q022DS01V02.Q022DT00_IDEN_LICEN, Q022DS01V02.Q022DT00_RS_PROMO, Q022DS01V02.Q022DT00_NORA_T17_LOCALIZACION 
                    from Q022DS01V02,q022bt00
                    WHERE Q022DS01V02.fca02t00_codprovinc =01 and Q022DS01V02.Q022BT00_ID_GRUPO=q022bt00.Q022BT00_ID_GRUPO
                     and Q022DS01V02.fca02t00_codmunicip=001 and q022dt00_fec_ent between to_date ('16/11/2011', 'dd/MM/yyyy') and to_date('16/11/2012','dd/MM/yyyy')
                     order by q022bt00.Q022BT00_ANO, q022bt00.Q022BT00_MES, Q022DS01V02.Q022DT00_CODIGO_LICEN
                     */
        ////////// FIN SQL ////////////////////////////////////////
        sql.append(where).append(order);
        
        /*
        if (tr.isTraceActive()){
            tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getSelectExpedientesCuestVTM: SQL=  " + sql.toString() );
        }
        */
        
        try{
            final Connection connection = Q70ConectorJDBC.getSingleton().getConnection(Q02_JNDI_DATASOURCE);
        
            try{
                    PreparedStatement ps = connection.prepareStatement(sql.toString()); 
                        try {
                            ps.execute();
                            ResultSet rs = ps.getResultSet();
                            
                                try {
                                        while (rs.next()){   
                                                //se cargan en el objeto cuestionario los datos recuperados
                                                Q02aCuestionarioVTMAnu cuestionarioVTMAnuBD = new Q02aCuestionarioVTMAnu();
                                                
                                                //cuestionarioVTMAnuBD.setNiGrupoCuesVTMAnu(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022BT00_ID_GRUPO));
                                                //cuestionarioVTMAnuBD.setNiCuesVTMAnu(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_ID_CUES));
                                                if ( rs.getString( Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_CODIGO_LICEN ) != null){
                                                    cuestionarioVTMAnuBD.setCodigoLicencia(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_CODIGO_LICEN));
                                                }else{
                                                    cuestionarioVTMAnuBD.setCodigoLicencia("");
                                                }
                                                if ( rs.getString( Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_IDEN_LICEN ) != null){
                                                    cuestionarioVTMAnuBD.setIdenLicen(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_IDEN_LICEN));          
                                                }else{
                                                    cuestionarioVTMAnuBD.setIdenLicen("");
                                                }
                                                if ( rs.getString( Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_RS_PROMO ) != null){
                                                    cuestionarioVTMAnuBD.setRsPromo(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_RS_PROMO));
                                                }else{
                                                    cuestionarioVTMAnuBD.setRsPromo("");
                                                }
                                                if ( rs.getString( Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_RS_PROMO ) != null){
                                                    cuestionarioVTMAnuBD.setLocalizacionObra(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_RS_PROMO));
                                                }else{
                                                    cuestionarioVTMAnuBD.setLocalizacionObra("");
                                                }
                                                cuestionarioVTMAnuBD.setAnyo( rs.getString("Q022BT00_ANO") );
                                                cuestionarioVTMAnuBD.setMes( rs.getString("Q022BT00_MES") );
                                                
                                                listaCuestionariosVTM.add(cuestionarioVTMAnuBD);
                                        } 
                                } finally {
                                    try { rs.close(); } catch (SQLException e) { }
                                }
                            
                        } finally {
                            try { ps.close(); } catch (SQLException e) { }
                        }
            }finally {
                try { connection.close(); } catch (SQLException sqle) {}
            }
            return listaCuestionariosVTM;  
        }catch (SQLException e) {
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getExpedientesVTM: saliendo.");
            }
            throw new EJBException("getExpedientesVTM",e);
        } catch (NamingException e) {
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getExpedientesVTM: saliendo.");
            }
            throw new EJBException("getExpedientesVTM",e);
        }
    }
    
    
    /**
     * 
     * @param cuestionariosVTMFiltro cuestionariosVTMFiltro
     * @return listaCuestionariosVTM
     * @throws Exception Exception
     */
    public void getResetearCuestionariosVTM(Q02aCuestionarioVTMFiltro cuestionariosVTMFiltro) 
    throws Exception {
        if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getResetearCuestionariosVTM: entrando.");
        }     
        String idGrupo = null;  
        String miConcedidoLicen = "";
        ArrayList listaCuestionariosVTM = new ArrayList();
        boolean error = false;
        
        try{
            String miNiGrupoCuesVTM = cuestionariosVTMFiltro.getNiGrupoCuesVTMAnu();
//          se abre la conexión
            abrirConexion();
            
            if ( miNiGrupoCuesVTM == null || "".equals(miNiGrupoCuesVTM) ){
                //se instancia el dao pasandole la conexión         
                daoCuestionariosVTMAnu = new Q02aCuestionariosVTMAnuDataBaseDAO(this.getConn());
                miNiGrupoCuesVTM = daoCuestionariosVTMAnu.obtenerMiGrupoCuestionariosVTM(cuestionariosVTMFiltro);
            }
            
            if ( miNiGrupoCuesVTM != null && !"".equals(miNiGrupoCuesVTM) ){
                //Si concedidoLicencia = 0 --> Es No y solo grabado en Q022BS00
                //Si concedicoLicencia = 1 --> Es Si y grabado en las dos tablas
                
                String territorio = ""; String municipio = ""; String anyoReferencia = ""; String mesReferencia = "";
                if (cuestionariosVTMFiltro.getCodProv() != null){ territorio = cuestionariosVTMFiltro.getCodProv(); }
                if (cuestionariosVTMFiltro.getCodMuni() != null){ municipio = cuestionariosVTMFiltro.getCodMuni(); }
                if (cuestionariosVTMFiltro.getCodMuni() != null){ anyoReferencia = cuestionariosVTMFiltro.getAno(); }
                if (cuestionariosVTMFiltro.getCodMuni() != null){ mesReferencia = cuestionariosVTMFiltro.getMes(); }
                
                
                miConcedidoLicen = daoCuestionariosVTMAnu.getConcedidoGrupoCuesVTM(territorio, municipio, anyoReferencia, mesReferencia);
                if ( "1".equals(miConcedidoLicen) ) {
                    daoCuestionariosVTMAnu.resetear2VTM(miNiGrupoCuesVTM);   //Q022DS00
                }
                    daoCuestionariosVTMAnu.resetear1VTM(miNiGrupoCuesVTM);   //Q022BS00
                
            }
            
      } catch(Exception ex){
          error= true;
          java.io.StringWriter sw = new java.io.StringWriter();
          java.io.PrintWriter pw = new java.io.PrintWriter(sw);
          ex.printStackTrace(pw);
          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getResetearCuestionariosVTM: " + sw.getBuffer ().toString());
          throw ex;                     
      }finally{
         try{
            daoCuestionariosVTMAnu.freeResourcesNotConnection();
           }catch(Exception ex){
               if (tr.isTraceActive()){
                   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getResetearCuestionariosVTM: error liberando recursos");
               }  
           }         
            //se cierra la conexión  
            cerrarConexion(error);          
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getResetearCuestionariosVTM: saliendo.");
            }
        }
      } //fin getResetearCuestionariosVTM 
    
    /**
     * 
     * @param territorio territorio
     * @param municipio municipio
     * @param anyoReferencia anyoReferencia
     * @param mesReferencia mesReferencia
     * @return concedidoLicenInicial
     * @throws Exception Exception
     */
    /*
    public String getConcedidoGrupoCuesSM(String territorio, String  municipio, String  anyoReferencia, String  mesReferencia) throws Exception 
    {
       String concedidoLicenInicial="";
       ResultSet rs = null;
       PreparedStatement prepStmt =null;   
       StringBuffer query = null;
       try{

           if (tr.isTraceActive()){
               tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getConcedidoGrupoCuesSM: entrando");
           }

           query = new StringBuffer("SELECT Q022CT00_REALIZA_ACTUACION FROM Q022CS00 WHERE");
           query.append(" Q022CT00_ANO=").append(anyoReferencia);
           query.append(" AND MUN_PROV='").append(territorio).append("'");
           query.append(" AND MUN_MUNI='").append(municipio).append("'");     

           if(!Q02aFormatData.esNull(mesReferencia).equals("")){ //Si se llama desde la portada SM 2008, l mes no vendrá informado
               query.append(" AND Q22CT00_MES=").append(mesReferencia);
           }
           prepStmt = this.getConnection().prepareStatement(query.toString());
           
           rs = prepStmt.executeQuery(); 
           if (rs.next()) {
               concedidoLicenInicial = rs.getString(1);
           }
           if (tr.isTraceActive()) {
               tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getConcedidoGrupoCuesSM: saliendo");
           }
           return concedidoLicenInicial;
          } catch (Exception ex) {        
               java.io.StringWriter sw = new java.io.StringWriter();
               java.io.PrintWriter pw = new java.io.PrintWriter(sw);
               ex.printStackTrace(pw);
               tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getConcedidoGrupoCuesSM: " + sw.getBuffer ().toString());
               throw ex;
           } finally { 
              try {
                  if (rs != null) {
                      rs.close();
                  }
                  if (prepStmt != null) {
                      prepStmt.close();
                  }
             }catch(Exception ex){
                 java.io.StringWriter sw = new java.io.StringWriter();
                 java.io.PrintWriter pw = new java.io.PrintWriter(sw);
                 ex.printStackTrace(pw);
                 tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getConcedidoGrupoCuesSM: " + sw.getBuffer ().toString());
                 throw new Q02aDAOException(ex);
             }
           }
    }*/
    
    /**
     * 
     * @param cuestionariosVTMFiltro cuestionariosVTMFiltro
     * @return listaCuestionariosVTM
     * @throws Exception Exception
     */
    public ArrayList getCuestionariosSinGrabarVTM(Q02aCuestionarioVTMFiltro cuestionariosVTMFiltro) throws Exception {
   //     public ArrayList getCuestionariosSinGrabarVTM(Q02aCuestionarioVTMFiltro cuestionariosVTMFiltro) throws Exception {
                 if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getCuestionariosVTM: entrando.");
         }    
         
         ////////////////////////--  SQL -- ///////////////////////////////////
         final StringBuffer sql = new StringBuffer();
                 sql.append("Select * from Q022BT00 ");
         final StringBuffer where = new StringBuffer();
                 where.append(" where fca02t00_codprovinc =").append( cuestionariosVTMFiltro.getCodProv() ).append(
                         " and fca02t00_codmunicip = ").append( cuestionariosVTMFiltro.getCodMuni());
                         //" and q022bt00_CONCEDIDO_LICEN=1");
                                 
         final StringBuffer order = new StringBuffer();
                 order.append(" order by q022bt00_Ano, q022bt00_mes");

         // Saco el mes y el año para saber la select que hay que hacer
         int mes = 0; int anyo = 2010;
         
         if (cuestionariosVTMFiltro.getMes() != null) {    
             mes = Integer.parseInt(cuestionariosVTMFiltro.getMes().toString());
         }
         if (cuestionariosVTMFiltro.getAno() != null) {
              anyo = Integer.parseInt(cuestionariosVTMFiltro.getAno().toString());
         }
         if (mes == 1) { //Si es enero hay que sacar octubre,noviembre y diciembre del anyo anterior
             anyo = anyo-1; 
             where.append(" and q022bt00_Ano =").append(anyo).append(
             " and q022bt00_mes IN (10, 11, 12) ");
         } else {
             where.append(" and q022bt00_Ano =").append(anyo).append(
             " and q022bt00_mes < ").append(mes);
         }
         ////////// FIN SQL ////////////////////////////////////////
         sql.append(where).append(order);
         
         
        ArrayList listaCuestionariosVTM = new ArrayList();
        boolean error = false;
        
        try{
            final Connection connection = Q70ConectorJDBC.getSingleton().getConnection(Q02_JNDI_DATASOURCE);
            try{
                    PreparedStatement ps = connection.prepareStatement(sql.toString()); 
                        try {
                            int i = 0;
                            ps.execute();
                            ResultSet rs = ps.getResultSet();
                            HashMap mesesHashMap;
                            
                                try {
                                        while (rs.next()){
                                            mesesHashMap = this.obtenerHashMap();
                                            mesesHashMap.put("mes", new Long ( rs.getLong("Q022BT00_MES") ).toString() );
                                            mesesHashMap.put("ano", new Long ( rs.getLong("Q022BT00_ANO") ).toString() );
                                            listaCuestionariosVTM.add(mesesHashMap);
                                            i++;
                                        }
                                } finally {
                                    try { rs.close(); } catch (SQLException e) { }
                                }
                            
                        } finally {
                            try { ps.close(); } catch (SQLException e) { }
                        }
            }finally {
                try { connection.close(); } catch (SQLException sqle) {}
            }
            
            
            return listaCuestionariosVTM;              
      
      }catch (SQLException e) {
          if (tr.isTraceActive()){
              tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getCuestionariosSinGrabarVTM: saliendo.");
          }
          throw new EJBException("getCuestionariosSinGrabarVTM",e);
      } catch (NamingException e) {
          if (tr.isTraceActive()){
              tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getCuestionariosSinGrabarVTM: saliendo.");
          }
          throw new EJBException("getCuestionariosSinGrabarVTM",e);
      }
      
      } //fin getCuestionariosVTM 
    
    /**
     * 
     * @param cuestionariosVTMFiltro cuestionariosVTMFiltro
     * @return listaCuestionariosVTM
     * @throws Exception Exception
     */
    public String getIDCuestionarioMayorVTM(Q02aCuestionarioVTMAnuFiltro cuestionariosVTMFiltro) 
        throws Exception {
        
        if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getIDCuestionarioMayorVTM: entrando.");
        }    
         
        ////////////////////////--  SQL -- ///////////////////////////////////
         final StringBuffer sql = new StringBuffer();
                 sql.append("Select max(q022dt00_id_cues) from Q022dT00 ");
         final StringBuffer where = new StringBuffer();
                 where.append(" where q022bt00_id_grupo =").append( cuestionariosVTMFiltro.getNiGrupoCuesVTMAnu() );
                         //" and q022bt00_CONCEDIDO_LICEN=1");
         sql.append(where);
        ////////// FIN SQL ////////////////////////////////////////
         
        String idCuestMax = "";
        
        try{
            final Connection connection = Q70ConectorJDBC.getSingleton().getConnection(Q02_JNDI_DATASOURCE);
            try{
                    PreparedStatement ps = connection.prepareStatement(sql.toString()); 
                        try {
                            ps.execute();
                            ResultSet rs = ps.getResultSet();                            
                                try {
                                        if (rs.next()){
                                            idCuestMax = rs.getString(1);
                                        }
                                } finally {
                                    try { rs.close(); } catch (SQLException e) { }
                                }
                            
                        } finally {
                            try { ps.close(); } catch (SQLException e) { }
                        }
            }finally {
                try { connection.close(); } catch (SQLException sqle) {}
            }
            return idCuestMax;              
      
      }catch (SQLException e) {
          if (tr.isTraceActive()){
              tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getIDCuestionarioMayorVTM: saliendo.");
          }
          throw new EJBException("getIDCuestionarioMayorVTM",e);
      } catch (NamingException e) {
          if (tr.isTraceActive()){
              tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getIDCuestionarioMayorVTM: saliendo.");
          }
          throw new EJBException("getIDCuestionarioMayorVTM",e);
      }
      
    } //fin getIDCuestionarioMayorVTM 
    
    
    /**
     * Funcion que inserta los datos del cuestionario de Ayuntamientos Mensual pasada como parámetro en la BBDD
     * 
     * @param cuesVTMAnu - Datos del cuestionario a insertar
     * 
     * @throws Exception Exception
     * @return niCuestionarioVTMAnu
     */
    public String insertarCuestionarioVTMAnu(Q02aCuestionarioVTMAnu cuesVTMAnu) throws Exception {   	 
    	//se crean objetos necesarios.
    	String niCuestionarioVTMAnu = "";
    	String tipovia="";
    	boolean error = false;
    	try{
    		if (tr.isTraceActive()){
      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarCuestionarioVTMAnu: entrando");
      		}    		
	  		//se abre la conexión
			abrirConexion();
			//se instancia el dao pasandole la conexión			
			daoCuestionariosVTMAnu = new Q02aCuestionariosVTMAnuDataBaseDAO(this.getConn());
			daoSolicitudesNora = new Q02aSolicitudesNoraDataBaseDAO(this.getConn());
            
			//se pasan los parámetros de usuario e idioma
			daoCuestionariosVTMAnu.setUser(this.autenticador.getUser());
			daoCuestionariosVTMAnu.setIdioma(this.autenticador.getIdioma());
            
			daoNora = new Q02aNoraDataBaseDAO(this.getConn());
	  		//Q02aCoordenadas c = daoNora.obtenerCoordenadas(cuesVTMAnu.getCalle(),cuesVTMAnu.getBloq(),cuesVTMAnu.getNume());
			if (!cuesVTMAnu.getPorClPor().equals(null) && !cuesVTMAnu.getPorClPor().equals("") ){
			  Q02aPortal c = daoNora.obtenerDatosPortal(cuesVTMAnu.getPorClPor());
	  		  cuesVTMAnu.setCoordenadaX(c.getCoordenadaX());
	  		  cuesVTMAnu.setCoordenadaY(c.getCoordenadaY());
	  		  cuesVTMAnu.setBis(c.getBis());
	  		  cuesVTMAnu.setBloq(c.getBloq());
	  		  cuesVTMAnu.setNume(c.getNume());
	  		}	  		
	  		if (cuesVTMAnu.getCalle()!=null && !cuesVTMAnu.getCalle().equals("") ){	  		
	  			cuesVTMAnu.setTvia( daoNora.obtenerTViaCalle(cuesVTMAnu.getCalle()));
            }
	  		
	  		//Q02aCoordenadas cPro = daoNora.obtenerCoordenadas(cuesVTMAnu.getCallePro(),cuesVTMAnu.getBloqPro(),cuesVTMAnu.getNumePro());
	  		if (!cuesVTMAnu.getPorClPorPro().equals(null) && !cuesVTMAnu.getPorClPorPro().equals("") ){
	  			Q02aPortal cPro = daoNora.obtenerDatosPortal(cuesVTMAnu.getPorClPorPro());
	  			cuesVTMAnu.setCoordenadaXPro(cPro.getCoordenadaX());
	  			cuesVTMAnu.setCoordenadaYPro(cPro.getCoordenadaY());
	  			cuesVTMAnu.setBisPro(cPro.getBis());
	  			cuesVTMAnu.setBloqPro(cPro.getBloq());
	  			cuesVTMAnu.setNumePro(cPro.getNume());
	  		}
	  		if (cuesVTMAnu.getCallePro() !=null && !cuesVTMAnu.getCallePro().equals("") ){	  		
	  			cuesVTMAnu.setTviaPro( daoNora.obtenerTViaCalle(cuesVTMAnu.getCallePro()));
            }
	  			  		
			//se llama la metodo del DAO que realiza la insert
	  		//InSERTAR el CUESTIONARIO
			niCuestionarioVTMAnu = daoCuestionariosVTMAnu.insertarCuestionarioVTMAnu(cuesVTMAnu);
            
            
			//insertamos la solicitud de alta en NORA si es el caso
			if(!Q02aFormatData.esVacio(cuesVTMAnu.getDirNueva())){
				Q02aSolicitudNora solicitudNora = this.rellenarSolicitudNora(cuesVTMAnu);
				daoSolicitudesNora.insertarSolicitudNora(solicitudNora);
			}
			return niCuestionarioVTMAnu;
    	}catch(Exception ex){
	 		error= true;
	        java.io.StringWriter sw = new java.io.StringWriter();
	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	        ex.printStackTrace(pw);
	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarCuestionarioVTMAnu: " + sw.getBuffer ().toString());
	        throw ex;                     
 	  }finally{
 		    try{
 		    	daoCuestionariosVTMAnu.freeResourcesNotConnection();
 		    	daoSolicitudesNora.freeResourcesNotConnection();
 		    }catch(Exception ex){
			   if (tr.isTraceActive()){
				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarCuestionarioVTMAnu: error liberando recursos");
	   	   	   }  
 		    }  		 
 		  	//se cierra la conexión  
 		    cerrarConexion(error);	       	
	        if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarCuestionarioVTMAnu: saliendo.");
	   		}
 	  }
    }//fin insertarCuestionarioVTMAnu
    
    /**
     * Función que borra el cuestionario pasado como parámetro de la BBDD
     * 
     * @param niCuestionarioVTMAnu - número interno del cuestionario a borrar
     * @param niGrupoCuestionarioVTMAnu niGrupoCuestionarioVTMAnu
     * 
     * @throws Exception Exception
     */
  public void borrarCuestionarioVTMAnu(String niCuestionarioVTMAnu,String niGrupoCuestionarioVTMAnu) throws Exception { 
	  	int numeroRegistros = 0;
  		if (tr.isTraceActive()){
			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarCuestionarioVTMAnu: entrando");
		}
  		boolean error = false;
  		try{
  			//se abre la conexión
 			abrirConexion();
 			
 			//se instancia el dao pasandole la conexión			
 			daoCuestionariosVTMAnu = new Q02aCuestionariosVTMAnuDataBaseDAO(this.getConn());
 			daoSolicitudesNora = new Q02aSolicitudesNoraDataBaseDAO(this.getConn());
 			//Segmento tecnico 
 			daoCuestionariosVTMAnu.setUser(this.getAutenticador().getUser());
 			daoCuestionariosVTMAnu.setIdioma(this.getAutenticador().getIdioma()); 

 			//Antes de borrar el cuestionario, eliminamos la solicitud de alta provisional de NORA si la tuviera
 			daoSolicitudesNora.borrarSolicitudNora(Q02aConstantes.getString("tipo.obra.mayor"), niGrupoCuestionarioVTMAnu, niCuestionarioVTMAnu);
 			
 			//se comprueba el numero de cuestionarios que tiene el grupo de cuestionarios
 			numeroRegistros = daoCuestionariosVTMAnu.getNumCuestionariosVTM(niGrupoCuestionarioVTMAnu);
 			if (numeroRegistros==1){
 					daoCuestionariosVTMAnu.borrarCuestionarioVTMAnu(niCuestionarioVTMAnu,niGrupoCuestionarioVTMAnu);
 					daoCuestionariosVTMAnu.borrarGrupoCuestionarioVTMAnu(niGrupoCuestionarioVTMAnu);
 			}
 			else {
 					daoCuestionariosVTMAnu.borrarCuestionarioVTMAnu(niCuestionarioVTMAnu,niGrupoCuestionarioVTMAnu);
 			}
 		 	  
  		}catch(Exception ex){
  			error= true;
  			java.io.StringWriter sw = new java.io.StringWriter();
  			java.io.PrintWriter pw = new java.io.PrintWriter(sw);
  			ex.printStackTrace(pw);
  			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarCuestionarioSMAnu: " + sw.getBuffer ().toString());

  			throw ex;           
	  
  		}finally{
  			try{
  				daoCuestionariosVTMAnu.freeResourcesNotConnection();
  				daoSolicitudesNora.freeResourcesNotConnection();
  			}catch(Exception ex){
			   if (tr.isTraceActive()){
				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarCuestionarioVTMAnu: error liberando recursos");
	   	   	   }  
  			}  		 
 		  	//se cierra la conexión  
 		  	cerrarConexion(error);	       	
	        if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarCuestionarioVTMAnu: saliendo.");
	   		}
 	  }
  }//fin borrarCuestionarioVTMAnu
  
    /**
     * Función que modifica los datos del cuestionario pasado como parámetro en la BBDD
     * 
     * @param cuestionarioVTMAnu - Datos del cuestionario a modificar
     * 
     * @throws Exception Exception
     */
    public void modificarCuestionarioVTMAnu(Q02aCuestionarioVTMAnu cuestionarioVTMAnu) throws Exception {
   	 if (tr.isTraceActive()){
  			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarCuestionarioVTMAnu: entrando");
  		}
   	 boolean error = false;
   	try{
   		//se abre la conexión
   		abrirConexion();
   		//se instancia el dao pasandole la conexión			
   		daoCuestionariosVTMAnu = new Q02aCuestionariosVTMAnuDataBaseDAO(this.getConn());
   		daoSolicitudesNora = new Q02aSolicitudesNoraDataBaseDAO(this.getConn());
		// Segmento tecnico 
		daoCuestionariosVTMAnu.setUser(this.getAutenticador().getUser());
		daoCuestionariosVTMAnu.setIdioma(this.getAutenticador().getIdioma()); 

		daoNora = new Q02aNoraDataBaseDAO(this.getConn());
  		/*Q02aCoordenadas c = daoNora.obtenerCoordenadas(cuestionarioVTMAnu.getCalle(),cuestionarioVTMAnu.getBloq(),cuestionarioVTMAnu.getNume());
  		cuestionarioVTMAnu.setCoordenadaX(c.getCoordenadaX());
  		cuestionarioVTMAnu.setCoordenadaY(c.getCoordenadaY());
  		Q02aCoordenadas cPro = daoNora.obtenerCoordenadas(cuestionarioVTMAnu.getCallePro(),cuestionarioVTMAnu.getBloqPro(),cuestionarioVTMAnu.getNumePro());
  		cuestionarioVTMAnu.setCoordenadaXPro(cPro.getCoordenadaX());
  		cuestionarioVTMAnu.setCoordenadaYPro(cPro.getCoordenadaY());*/
  		
//  	Q02aCoordenadas c = daoNora.obtenerCoordenadas(cuesVTMAnu.getCalle(),cuesVTMAnu.getBloq(),cuesVTMAnu.getNume());
		if (!cuestionarioVTMAnu.getPorClPor().equals(null) && !cuestionarioVTMAnu.getPorClPor().equals("") ){
		  Q02aPortal c = daoNora.obtenerDatosPortal(cuestionarioVTMAnu.getPorClPor());
		  cuestionarioVTMAnu.setCoordenadaX(c.getCoordenadaX());
		  cuestionarioVTMAnu.setCoordenadaY(c.getCoordenadaY());
		  cuestionarioVTMAnu.setBis(c.getBis());
		  cuestionarioVTMAnu.setBloq(c.getBloq());
		  cuestionarioVTMAnu.setNume(c.getNume());
  		}	  		
  		if (cuestionarioVTMAnu.getCalle()!=null && !cuestionarioVTMAnu.getCalle().equals("") ){	  		
  			cuestionarioVTMAnu.setTvia( daoNora.obtenerTViaCalle(cuestionarioVTMAnu.getCalle()));
        }
  		
  		//Q02aCoordenadas cPro = daoNora.obtenerCoordenadas(cuesVTMAnu.getCallePro(),cuesVTMAnu.getBloqPro(),cuesVTMAnu.getNumePro());
  		if (!cuestionarioVTMAnu.getPorClPorPro().equals(null) && !cuestionarioVTMAnu.getPorClPorPro().equals("") ){
  			Q02aPortal cPro = daoNora.obtenerDatosPortal(cuestionarioVTMAnu.getPorClPorPro());
  			cuestionarioVTMAnu.setCoordenadaXPro(cPro.getCoordenadaX());
  			cuestionarioVTMAnu.setCoordenadaYPro(cPro.getCoordenadaY());
  			cuestionarioVTMAnu.setBisPro(cPro.getBis());
  			cuestionarioVTMAnu.setBloqPro(cPro.getBloq());
  			cuestionarioVTMAnu.setNumePro(cPro.getNume());
  		}
  		if (cuestionarioVTMAnu.getCallePro() !=null && !cuestionarioVTMAnu.getCallePro().equals("") ){	  		
 			cuestionarioVTMAnu.setTviaPro( daoNora.obtenerTViaCalle(cuestionarioVTMAnu.getCallePro()));
        }
  		
  		
   		//se llama al metodo del DAO que realiza la update
   		daoCuestionariosVTMAnu.modificarCuestionarioVTMAnu(cuestionarioVTMAnu);
   		
   		//Puede que se haya modificado la dirección nueva de la localizacion de obra
   		//que antes no la tuviera y ahora sí o se haya eliminado
   		Q02aSolicitudNora solicitudNora = this.rellenarSolicitudNora(cuestionarioVTMAnu);
   		daoSolicitudesNora.modificarSolicitudNora(solicitudNora);
   		
   	}catch(Exception ex){
		  error= true;
         java.io.StringWriter sw = new java.io.StringWriter();
         java.io.PrintWriter pw = new java.io.PrintWriter(sw);
         ex.printStackTrace(pw);
         tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarCuestionarioVTMAnu: " + sw.getBuffer ().toString());
         throw ex;                     
	  }finally{
		 try{
			daoCuestionariosVTMAnu.freeResourcesNotConnection();
			daoSolicitudesNora.freeResourcesNotConnection();
		   }catch(Exception ex){
			   if (tr.isTraceActive()){
				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarCuestionarioVTMAnu: error liberando recursos");
	   	   	   }  
		   }  		 
		  	//se cierra la conexión  
		  	cerrarConexion(error);	       	
	        if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarCuestionarioVTMAnu: saliendo.");
	   		}
	  }
   }


    /**
     * Método que dado el número interno del cuestionario recuperar de la BBDD
     * los datos de dicho cuestionario.
     * @param niCuestionarioVTMAnu niCuestionarioVTMAnu
     * @param niGrupoCuestionarioVTMAnu niGrupoCuestionarioVTMAnu
     * 
     * @throws Exception Exception
     * @return cuestionarioVTMAnu
     */
	public Q02aCuestionarioVTMAnu obtenerCuestionarioVTMAnu(String niCuestionarioVTMAnu,String niGrupoCuestionarioVTMAnu)throws Exception{  	 
	    	boolean error = false;
	    	Q02aCuestionarioVTMAnu cuestionarioVTMAnu = null;
	  	  	try  	  {
	  	  		if (tr.isTraceActive()){
	  	  			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioVTMAnu, ** niCuestionarioVTMAnu bean=" + niCuestionarioVTMAnu + ", niGrupoCuestionarioVTMAnu =" + niGrupoCuestionarioVTMAnu+ " *** entrando");                
	  	  		}
	  	  		//se abre la conexión
	  	  		abrirConexion();
	  	  		//se instancia el dao pasandole la conexión			
	  	  		daoCuestionariosVTMAnu = new Q02aCuestionariosVTMAnuDataBaseDAO(this.getConn());
	  	  		//Segmento tecnico 
	  			//daoCuestionariosVTMAnu.setUser(this.getAutenticador().getUser());
	  			//daoCuestionariosVTMAnu.setIdioma(this.getAutenticador().getIdioma()); 
	  	  		//se llama al método del dao recupera el cuestionario
	  	  		cuestionarioVTMAnu = daoCuestionariosVTMAnu.obtenerCuestionarioVTMAnu(niCuestionarioVTMAnu,niGrupoCuestionarioVTMAnu);
	  	  		//se devuelve el cuestionario recuperado
	  	  		return cuestionarioVTMAnu;
	  	  }catch(Exception ex){
	  		  	error= true;
	  		  	java.io.StringWriter sw = new java.io.StringWriter();
	          	java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	          	ex.printStackTrace(pw);
	          	tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCuestionarioVTMAnu: " + sw.getBuffer ().toString());
	          	throw ex;                     
	 	  }finally{
	 		  	try{
	 		  		daoCuestionariosVTMAnu.freeResourcesNotConnection();
	 		  	}catch(Exception ex){
				   if (tr.isTraceActive()){
					   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCuestionarioVTMAnu: error liberando recursos");
		   	   	   }  
	 		  	}  		 
	 		  	//se cierra la conexión  
	 		  	cerrarConexion(error);	       	
		        if (tr.isTraceActive()){
		   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioVTMAnu: saliendo.");
		   		}
	 	  }
	    }//fin obtenerCuestionarioVTMAnu
	    
	    
	    
     /**
     * Función que inserta/modifica los datos del grupo de cuestionarios de Ayuntamientos Mensual a partir de los Datos Contenidos en el filtro
     * 
     * @param cuesVTMAnuFiltro cuesVTMAnuFiltro
     * @return niGrupoCuesVTMAnu
     * @throws Exception cuestionarioVTMAnu
     */
    public String altaModifGrupoCuestionariosVTMAnu(Q02aCuestionarioVTMAnuFiltro cuesVTMAnuFiltro) throws Exception {   	 
    	//se crean objetos necesarios.
    	//Q02aCuestionarioVTMAnuFiltro grupoCuestionarioVTMAnuConNi = null;
    	String niGrupoCuesVTMAnu = null;
    	boolean error = false;
    	try{
    		if (tr.isTraceActive()){
      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":altaModifGrupoCuestionariosVTMAnu: entrando");
      		}
	  		//se abre la conexión
			abrirConexion();
			//se instancia el dao pasandole la conexión			
			daoCuestionariosVTMAnu = new Q02aCuestionariosVTMAnuDataBaseDAO(this.getConn());
//			se pasan los parámetros de usuario e idioma
			//daoCuestionariosVTMAnu.setUser(this.autenticador.getUser());
			//daoCuestionariosVTMAnu.setIdioma(this.autenticador.getIdioma());
			//se llamaa la metodo del DAO que realiza la insert
			niGrupoCuesVTMAnu = daoCuestionariosVTMAnu.altaModifGrupoCuestionariosVTMAnu(cuesVTMAnuFiltro);
			return niGrupoCuesVTMAnu;
			
    	}catch(Exception ex){
	 		error= true;
	        java.io.StringWriter sw = new java.io.StringWriter();
	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	        ex.printStackTrace(pw);
	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":altaModifGrupoCuestionariosVTMAnu: " + sw.getBuffer ().toString());
	        throw ex;                     
 	  }finally{
 		    try{
 		    	daoCuestionariosVTMAnu.freeResourcesNotConnection();
 		    }catch(Exception ex){
			   if (tr.isTraceActive()){
				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":altaModifGrupoCuestionariosVTMAnu: error liberando recursos");
	   	   	   }  
 		    }  		 

 		  	//se cierra la conexión  
 		    cerrarConexion(error);	       	

	        if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarCuestionarioVTMAnu: saliendo.");
	   		}
 	  }
    }//fin altaModifGrupoCuestionariosVTMAnu
    

     /**
     * Función que obtiene los  meses para el municipio y ano seleccionados, en los que no se han introducido cuestionarios
     * 
     * @param codProv  codProv
     * @param codMuni codMuni
     * @param ano ano
     * @param idioma idioma
     * 
     * @throws Exception Exception
     * @return msgAnos
     */
    public String obtenerAnosSinActuacionesParaMuni(String codProv, String codMuni, String ano, String idioma) 
    throws Exception {   	 

	boolean error = false;
    	String msgAnos = null;
    	
    	try{
    		if (tr.isTraceActive()){
      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosSinActuacionesParaMuni: entrando");
      		}
	  		//se abre la conexión
			abrirConexion();
			//se instancia el dao pasandole la conexión			
			daoCuestionariosVTMAnu = new Q02aCuestionariosVTMAnuDataBaseDAO(this.getConn());
//			se pasan los parámetros de usuario e idioma
			//daoCuestionariosVTMAnu.setUser(this.autenticador.getUser());
			//daoCuestionariosVTMAnu.setIdioma(this.autenticador.getIdioma());
			//se llamaa la metodo del DAO que realiza la insert
			msgAnos =daoCuestionariosVTMAnu.obtenerAnosSinActuacionesParaMuni(codProv,codMuni,ano,idioma);
			return msgAnos;
			
    	}catch(Exception ex){
	 		error= true;
	        		java.io.StringWriter sw = new java.io.StringWriter();
	        		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	        		ex.printStackTrace(pw);
	        		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerAnosSinActuacionesParaMuni: " + sw.getBuffer ().toString());
	        		throw ex;                     
 	  }finally{
 		    try{
 		    	daoCuestionariosVTMAnu.freeResourcesNotConnection();
 		    }catch(Exception ex){
			   if (tr.isTraceActive()){
				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerAnosSinActuacionesParaMuni: error liberando recursos");
	   	   	   }  
 		    }  		 
 		    //se cierra la conexión  
 		    cerrarConexion(error);	       	
	        	   if (tr.isTraceActive())
        	   {
   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosSinActuacionesParaMuni: saliendo.");
   	  }
	  }

    }//fin obtenerMeseSinCuesVTMAnuParaMuniYAno

    /**
     * Función que obtiene el campo Realiza Actuación  para el municipio y año seleccionados
     * 
     * @param codProv codProv
     * @param codMuni codMuni
     * @param ano ano
     * 
     * @return obtenerCamporRealizaActuacionDeGrupoConMuniAno
     * @throws Exception Exception
     */

    public String obtenerCampoRealizaActuacionDeGrupoConMuniAno(String codProv,String codMuni,String ano) throws Exception {   	 
	boolean error = false;
    	
    	try{
    		if (tr.isTraceActive())
    		{
      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCampoRealizaActuacionDeGrupoConMuniAno: entrando");
      		}
	  		//se abre la conexión
			abrirConexion();
			//se instancia el dao pasandole la conexión			
			daoCuestionariosVTMAnu = new Q02aCuestionariosVTMAnuDataBaseDAO(this.getConn());
//			se pasan los parámetros de usuario e idioma
			//daoCuestionariosVTMAnu.setUser(this.autenticador.getUser());
			//daoCuestionariosVTMAnu.setIdioma(this.autenticador.getIdioma());
			//se llamaa la metodo del DAO que realiza la insert
			return daoCuestionariosVTMAnu.obtenerCamporRealizaActuacionDeGrupoConMuniAno(codProv,codMuni,ano);
			
		}catch(Exception ex){

	 		error= true;

	        		java.io.StringWriter sw = new java.io.StringWriter();

	        		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        		ex.printStackTrace(pw);

	        		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCampoRealizaActuacionDeGrupoConMuniAno: " + sw.getBuffer ().toString());

	        		throw ex;                     

 	  }finally{

 		    try{

 		    	daoCuestionariosVTMAnu.freeResourcesNotConnection();

 		    }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCampoRealizaActuacionDeGrupoConMuniAno: error liberando recursos");

	   	   	   }  

 		    }  		 

 		    //se cierra la conexión  

 		    cerrarConexion(error);	       	

	        	   if (tr.isTraceActive())

	        	   {

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCampoRealizaActuacionDeGrupoConMuniAno.");

	   	  }

 	  }

    }//fin obtenerCampoRealizaActuacionDeGrupoConMuniAno

    

   /**Metodo que se encarga de devolver un XML con los datos principales de los cuestionarios a firmar que no estén ya firmados.
	* @param arrCuestionariosVTMAnuFirma arrCuestionariosVTMAnuFirma
	* @throws Exception Exception
    * @return docCuestionariosVTMAnuFirmar
    */

    public Document obtenerXmlFirmaCuestionariosVTMAnu(ArrayList arrCuestionariosVTMAnuFirma ) throws Exception{
        //Definicion de constantes
        final String TRACE_METODO = nombreClaseSinPackage +":obtenerXmlFirmaCuestionariosVTMAnu:";

        //Variable que indica si se ha producido un error
        boolean error = false;
        
        Document docCuestionariosVTMAnuFirmar = null;
        Q02aCuestionarioVTMAnu cuestionarioVTMAnuBD = null;
        
        if (tr.isTraceActive()) 
        {
            	tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO + ": entrando");
            	tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO +": ArrayList ="+ (arrCuestionariosVTMAnuFirma==null?"Es nulo":Integer.toString(arrCuestionariosVTMAnuFirma.size())));
        }
        try {
        	if(arrCuestionariosVTMAnuFirma !=null)
        	{
        		
        		Q02aXMLBuilder xml = new Q02aXMLBuilder();
            		Element document = xml.createTag("DOCUMENT");
        		for(int i =0;i<arrCuestionariosVTMAnuFirma.size();i++)
        		{
        			cuestionarioVTMAnuBD = (Q02aCuestionarioVTMAnu)arrCuestionariosVTMAnuFirma.get(i);
        			//MODIFICACION -> Se firman todos otra vez
        			//Sólo se van a firmar los que no estén ya firmados

        			//tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO + ": Fec. Firma del elemento  "+ i + "=" +cuestionarioVTMAnuBD.getFecFirma() );

        			//if(Q02aFormatData.esVacio(cuestionarioVTMAnuBD.getFecFirma()))
        			//{
	        			//tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO + ": Se genera XML del elemento "+ i);
	        			Element cuestionario = xml.createTag("CUESTIONARIO");
	                    			xml.addChild(document, cuestionario);
	                    			/*xml.addChild(cuestionario, xml.createTag("IDEN_LICEN",cuestionarioVTMAnuBD.getIdenLicen() , true));
	                    			xml.addChild(cuestionario, xml.createTag("LOCAL_OBRA",cuestionarioVTMAnuBD.getLocalObra(), true));
	                    			xml.addChild(cuestionario, xml.createTag("RS_PROMO", cuestionarioVTMAnuBD.getRsPromo(), true));*/
	                    		//}
        		}

        		xml.setRootTag(document);

        		docCuestionariosVTMAnuFirmar= xml.getDocument();

        	}
        	//Se devuelve el document
        	return docCuestionariosVTMAnuFirmar;
        }
        catch (Exception ex) 
        {
	            error = true;
	            java.io.StringWriter sw = new java.io.StringWriter();
	            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	            ex.printStackTrace(pw);
	            tr.trace(COMPONENTE, Q70TraceLevel.ERROR,
	                TRACE_METODO + ": " + sw.getBuffer().toString());
	            throw ex;
        } 
    }
    
    /**
     * Función que inserta la firma del grupo de cuestionarios de Ayuntamientos Mensual pasada como parámetro
     * 
     * @param niGrupoCuesVTMAnu - Ni del grupo de cuestionarios
     * @param xmlFirmaGrupoCuestionariosVTMAnu - Firma del grupo de cuestionarios
     * 
     * @throws Exception
     */

    public void guardarFirmaGrupoCuestionariosVTMAnu(String niGrupoCuesVTMAnu,String xmlFirmaGrupoCuestionariosVTMAnu) throws Exception {   	 

    	boolean error = false;

    	try{

    		if (tr.isTraceActive()){

      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":guardarFirmaGrupoCuestionariosVTMAnu: entrando");

      		}

  		//se abre la conexión

		abrirConexion();

		//se instancia el dao pasandole la conexión			

		daoCuestionariosVTMAnu = new Q02aCuestionariosVTMAnuDataBaseDAO(this.getConn());

//		se pasan los parámetros de usuario e idioma

		//daoCuestionariosVTMAnu.setUser(this.autenticador.getUser());

		//daoCuestionariosVTMAnu.setIdioma(this.autenticador.getIdioma());

		//se llamaa la metodo del DAO que realiza las modificaciones en la base de datos

		daoCuestionariosVTMAnu.guardarFirmaGrupoCuestionariosVTMAnu(niGrupoCuesVTMAnu,xmlFirmaGrupoCuestionariosVTMAnu);

    	}catch(Exception ex){

	 	 error= true;

		 java.io.StringWriter sw = new java.io.StringWriter();

		 java.io.PrintWriter pw = new java.io.PrintWriter(sw);

		 ex.printStackTrace(pw);

		 tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":guardarFirmaGrupoCuestionariosVTMAnu: " + sw.getBuffer ().toString());

		  throw ex;                     

 	  }finally{

 		    try{

 		    	daoCuestionariosVTMAnu.freeResourcesNotConnection();

 		    }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":guardarFirmaGrupoCuestionariosVTMAnu: error liberando recursos");

	   	   	   }  

 		    }  		 

 		  	

 		  //se cierra la conexión  

 		 cerrarConexion(error);	       	

	        	if (tr.isTraceActive())

	        	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":guardarFirmaGrupoCuestionariosVTMAnu: saliendo.");

	   	}

 	  }

    }//fin guardarFirmaGrupoCuestionariosVTMAnu  

    /**
     * 
     * @param niGrupoCuestionarioVTMAnu niGrupoCuestionarioVTMAnu
     * @throws Exception Exception
     */
    public void borrarTodosCuestionarioVTMAnu(String niGrupoCuestionarioVTMAnu) throws Exception {

    	if (tr.isTraceActive()){
			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarTodosCuestionarioVTMAnu: entrando");
		}
    	 boolean error = false;
    	 try{

    		 //se abre la conexión
   			abrirConexion();
   			//se instancia el dao pasandole la conexión			
   			daoCuestionariosVTMAnu = new Q02aCuestionariosVTMAnuDataBaseDAO(this.getConn());
			// Segmento tecnico 

   			 daoCuestionariosVTMAnu.borrarTodosCuestionarioVTMAnu(niGrupoCuestionarioVTMAnu);
   			daoCuestionariosVTMAnu.modificarDatosFirmaGrupoCuestionarioVTMMen(niGrupoCuestionarioVTMAnu);

    	 }catch(Exception ex){
		  error= true;
          java.io.StringWriter sw = new java.io.StringWriter();
          java.io.PrintWriter pw = new java.io.PrintWriter(sw);
          ex.printStackTrace(pw);
          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarTodosCuestionarioVTMAnu: " + sw.getBuffer ().toString());
          throw ex;                     
 	  }finally{
 		 try{
 			daoCuestionariosVTMAnu.freeResourcesNotConnection();
		   }catch(Exception ex){
			   if (tr.isTraceActive()){
				  tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarTodosCuestionarioVTMAnu: error liberando recursos");
	   	   	   }  
		   }  		 
 		  	//se cierra la conexión  
 		  	cerrarConexion(error);	       	

	        if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarCuestionarioVTMAnu: saliendo.");
	   		}
 	  }
     }//fin borrarTodosCuestionarioVTMAnu
    
    /**
     * Función que recupera el número de cuestionarios de OM 
     * 
     * @param territorio territorio
     * @param municipio municipio
     * @param anyoReferencia anyoReferencia
     * @param mesReferencia mesReferencia
     * 
     * @return numCuestionariosOM
     * @throws Exception Exception
     */

      public int getNumCuestionariosPortada(String territorio, String municipio, String anyoReferencia,String mesReferencia) throws Exception {   	 
    	//se crean objetos necesarios.
    	int numCuestionariosOM=0;	        	         
    	boolean error = false;
    	
    	try{
    		if (tr.isTraceActive()){
      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumCuestionariosPortada: entrando");
      		}
	  		//se abre la conexión
			abrirConexion();
			//se instancia el dao pasandole la conexión			
			daoCuestionariosVTMAnu = new Q02aCuestionariosVTMAnuDataBaseDAO(this.getConn());

			numCuestionariosOM = daoCuestionariosVTMAnu.getNumCuestionariosOM(territorio, municipio, anyoReferencia, mesReferencia);
			    			   			
			return numCuestionariosOM;
    	}catch(Exception ex){
	 		error= true;
	        java.io.StringWriter sw = new java.io.StringWriter();
	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	        ex.printStackTrace(pw);
	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumCuestionariosPortada: " + sw.getBuffer ().toString());
	        throw ex;                     
 	  }finally{
 		    try{
 		    	daoCuestionariosVTMAnu.freeResourcesNotConnection();
 		    }catch(Exception ex){
			   if (tr.isTraceActive()){
				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumCuestionariosPortada: error liberando recursos");
	   	   	   }  
 		    }  		 
 		  	//se cierra la conexión  
 		    cerrarConexion(error);	       	
	        if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumCuestionariosPortada: saliendo.");
	   		}
 	  }
    }//fin getNumCuestionariosPortada 
      
      /**
       * Función que recupera las observacionesVTMA
       * 
       * @param territorio territorio
       * @param municipio municipio
       * @param anyoReferencia anyoReferencia
       * @param mesReferencia mesReferencia
       * 
       * @return observacionesVTM
       * @throws Exception Exception
       */

        public String getObservacionesPortadaVTM(String territorio, String municipio, String anyoReferencia,String mesReferencia) throws Exception {        
        
        String observacionesVTM = "";                        
        boolean error = false;
        
        try{
            if (tr.isTraceActive()){
                    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getObservacionesPortada: entrando");
                }
            //se abre la conexión
            abrirConexion();
            //se instancia el dao pasandole la conexión         
            daoCuestionariosVTMAnu = new Q02aCuestionariosVTMAnuDataBaseDAO(this.getConn());

            observacionesVTM = daoCuestionariosVTMAnu.getObservacionesCuesVTM(territorio, municipio, anyoReferencia, mesReferencia);
                                        
            return observacionesVTM;
        }catch(Exception ex){
            error= true;
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumCuestionariosPortada: " + sw.getBuffer ().toString());
            throw ex;                     
      }finally{
            try{
                daoCuestionariosVTMAnu.freeResourcesNotConnection();
            }catch(Exception ex){
               if (tr.isTraceActive()){
                   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumCuestionariosPortada: error liberando recursos");
               }  
            }        
            //se cierra la conexión  
            cerrarConexion(error);          
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumCuestionariosPortada: saliendo.");
            }
      }
      }//fin getObservacionesPortada  
      
/**
 * 
 * @param territorio territorio
 * @param municipio municipio
 * @param anyoReferencia anyoReferencia
 * @param mesReferencia mesReferencia
 * @return concedidoLicenInicial
 * @throws Exception Exception
 */
      public String getConcedidoGrupoCuesVTM(String territorio, String municipio, String anyoReferencia,String mesReferencia) throws Exception {   	 

          //se crean objetos necesarios.
        	String concedidoLicenInicial = "";	        	         
        	boolean error = false;
        	
        	try{
        		 
        		if (tr.isTraceActive()) {
          			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumCuestionariosPortada: entrando");
          		}

                //se abre la conexión
    			abrirConexion();
    			//se instancia el dao pasandole la conexión			
    			daoCuestionariosVTMAnu = new Q02aCuestionariosVTMAnuDataBaseDAO(this.getConn());
    			
    			concedidoLicenInicial = daoCuestionariosVTMAnu.getConcedidoGrupoCuesVTM(territorio, municipio, anyoReferencia, mesReferencia);
    			    			   			
    			return concedidoLicenInicial;
        	} catch (Exception ex) {
    	 		error = true;
    	        java.io.StringWriter sw = new java.io.StringWriter();
    	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);
    	        ex.printStackTrace(pw);
    	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumCuestionariosPortada: " + sw.getBuffer ().toString());
    	        throw ex;                     
     	  }finally{
     		    try{
     		    	daoCuestionariosVTMAnu.freeResourcesNotConnection();
     		    } catch (Exception ex) {
    			   if (tr.isTraceActive()){
    				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumCuestionariosPortada: error liberando recursos");
    	   	   	   }  
     		    }  		 
     		  	//se cierra la conexión  
     		    cerrarConexion(error);	       	
    	        if (tr.isTraceActive()){
    	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumCuestionariosPortada: saliendo.");
    	   		}
     	  }
        } 

      /**
      * Función que modifica el campo Q022BT00_CONCEDIDO_LICEN 
       * 
       * @param niGrupoCuesVTM  - el ni del grupo a modificar
       * @param valorRealizaActu valorRealizaActu
       * @param mes - mes del grupo de cuestionarios
       * @param obs - mes del grupo de cuestionarios  
       * 
       * @throws Exception Exception
       */
        public void modificarGrupoCuestionariosVTM(String niGrupoCuesVTM, String valorRealizaActu, String mes, String obs) throws Exception {   	 
        	boolean error = false;
        	try{
      		if (tr.isTraceActive()){
        			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarGrupoCuestionariosVTM: entrando");
        		}
  	  		//se abre la conexión
  			abrirConexion();
  			//se instancia el dao pasandole la conexión			
  			daoCuestionariosVTMAnu = new Q02aCuestionariosVTMAnuDataBaseDAO(this.getConn());

  			daoCuestionariosVTMAnu.modificarGrupoCuestionariosVTM(niGrupoCuesVTM, valorRealizaActu, mes, obs);
  	  	}catch(Exception ex){
  	 		error= true;
  	        java.io.StringWriter sw = new java.io.StringWriter();
  	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);
  	        ex.printStackTrace(pw);
  	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarGrupoCuestionariosVTM: " + sw.getBuffer ().toString());
  	        throw ex;                     
   	  }finally{
   		    try{
   		    	daoCuestionariosVTMAnu.freeResourcesNotConnection();
   		    }catch(Exception ex){
  			   if (tr.isTraceActive()){
  				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarGrupoCuestionariosVTM: error liberando recursos");
  	   	   	   }  
   		    }  		 
   		  	//se cierra la conexión  
   		    cerrarConexion(error);	       	
  	        if (tr.isTraceActive()){
  	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarGrupoCuestionariosVTM: saliendo.");
  	   		}
   	  }
      }//fin modificarConcedidoLicenCuestionarioSM
        
        /**
         * 
         * @param territorio territorio
         * @param municipio municipio
         * @param anyoReferencia anyoReferencia
         * @param mesReferencia mesReferencia
         * @return niGrupoCuesVTMAnu
         * @throws Exception Exception
         */
        public String getNiGrupoCuesVTM(String territorio, String municipio, String anyoReferencia, String mesReferencia) throws Exception
        {
        	String niGrupoCuesVTMAnu = "";
        	boolean error = false;
            {          	              	
          	try{
          		 
          		if (tr.isTraceActive()){
            			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNiGrupoCuesVTM: entrando");
            		}
      	  		//se abre la conexión
      			abrirConexion();
      			//se instancia el dao pasandole la conexión			
      			daoCuestionariosVTMAnu = new Q02aCuestionariosVTMAnuDataBaseDAO(this.getConn());
      			
      			niGrupoCuesVTMAnu = daoCuestionariosVTMAnu.getNiGrupoCuesVTM(territorio, municipio, anyoReferencia, mesReferencia);
      			    			   			
      			return niGrupoCuesVTMAnu;
          	}catch(Exception ex){
      	 		error= true;
      	        java.io.StringWriter sw = new java.io.StringWriter();
      	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);
      	        ex.printStackTrace(pw);
      	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNiGrupoCuesVTM: " + sw.getBuffer ().toString());
      	        throw ex;                     
       	    }finally{
       		    try{
       		    	daoCuestionariosVTMAnu.freeResourcesNotConnection();
       		    }catch(Exception ex){
      			   if (tr.isTraceActive()){
      				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNiGrupoCuesVTM: error liberando recursos");
      	   	   	   }  
       		    }  		 
       		  	//se cierra la conexión  
       		    cerrarConexion(error);	       	
      	        if (tr.isTraceActive()){
      	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNiGrupoCuesVTM: saliendo.");
      	   		}
       	    }  	
            }
        }//fin getNiGRupoCuesSM
       
        /**
         * 
         * @param anyo anyo
         * @throws Exception Exception
         */
        public void insertarContactoVTM(String anyo) throws Exception{

        	if (tr.isTraceActive()){

    			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarContactoVTM: entrando");

    		}

        	 boolean error = false;

        	 try{

        		 //se abre la conexión

       			abrirConexion();

       			

       			//se obtiene el dni del usuario	

       			Q02aUsuarioInformanteDataBaseDAO daoUsuarioInformante = new Q02aUsuarioInformanteDataBaseDAO(this.getConn());

       			daoUsuarioInformante.setUser(this.getAutenticador().getUser());

       			String niUsuario = daoUsuarioInformante.getUser();

       			String niInformante = daoUsuarioInformante.obtenerNiInformante(niUsuario);

       			   			

       			if (niInformante!=""){

       				//obtener los datos del informante

       				Q02aInformantesDataBaseDAO daoInformante = new Q02aInformantesDataBaseDAO(this.getConn());

       				Q02aInformante informante = new Q02aInformante();

       				informante = daoInformante.getInformante(niInformante);

       				

       				//insertar el contacto

       				Q02aContactos contacto = new Q02aContactos();

       				Q02aContactosDataBaseDAO daoContactos = new Q02aContactosDataBaseDAO(this.getConn());

       				contacto.setCodProvincia(informante.getDescProvincia());

       				contacto.setCodMunicipio(informante.getDescMunicipio());

       				contacto.setIdInformante(informante.getIdInformante());

       				contacto.setIdOficina(informante.getIdOficina());

       				String codigoOnline =Q70ListenerUtils.getApplicationProperty("COD_TIPO_CONTACTO_ONLINE");

       				String codigoTabla = Q70ListenerUtils.getApplicationProperty("COD_TABLA_TIPO_CONTACTO");

       				//se instancia el dao pasandole la conexión			

       				daoTablas = new Q02aTablasDataBaseDAO(this.getConn());

       				String niOnline = daoTablas.getNiCuestionarioOnline(codigoOnline, codigoTabla);

       				contacto.setTipoContacto(niOnline);//Cuestionario On-line

       				contacto.setFechaProxContacto("");

       				contacto.setObservaciones("Informante "+informante.getNombre()+ " " + informante.getApellido1() + " " + informante.getApellido2() 

       						+" ha grabado el cuestionario de Estadística de Licencia de Obra Mayor" );

       				int idContacto = daoContactos.insertarContactoCuestionario(contacto);

       				if (tr.isTraceActive()){

       		   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarContactoVTM: contacto dado de alta --> idInformante=" 

       		   					+ niInformante + " niUsuario= " + niUsuario + "idContacto= " + idContacto);

       		   		}

       			}

       			else {

       				if (tr.isTraceActive()){

       		   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarContactoVTM: contacto NO dado de alta --> idInformante " +

       		   					"no existe para el niUsuario= " + niUsuario);

       		   		}

       			}

       		 	

        	 }catch(Exception ex){

    		  error= true;

              java.io.StringWriter sw = new java.io.StringWriter();

              java.io.PrintWriter pw = new java.io.PrintWriter(sw);

              ex.printStackTrace(pw);

              tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarContactoVAPM: " + sw.getBuffer ().toString());

              throw ex;                     

     	  }finally{

     		  	//se cierra la conexión  

     		  	cerrarConexion(error);	       	

    	        if (tr.isTraceActive()){

    	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarContactoVAPM: saliendo.");

    	   		}

     	  }

      	}//fin insertarContactoVTM

        
/**
 * 
 * @param cuesVTMAnu cuesVTMAnu
 * @return solicitud
 * @throws Exception Exception
 */
        public Q02aSolicitudNora rellenarSolicitudNora(Q02aCuestionarioVTMAnu cuesVTMAnu)throws Exception{

        	Q02aSolicitudNora solicitud=null;

        	try{

        		if (tr.isTraceActive()){

        			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenarSolicitudNora: entrando");

        		}

        		solicitud = new Q02aSolicitudNora();

        		solicitud.setCodigo(Q02aConstantes.getString("tipo.obra.mayor"));

        		solicitud.setNiGrupoCuestionario(cuesVTMAnu.getNiGrupoCuesVTMAnu());

        		solicitud.setNiCuestionario(cuesVTMAnu.getNiCuesVTMAnu());

        		solicitud.setDireccion(cuesVTMAnu.getDirNueva());

        		solicitud.setEstadoSolicitud(Q02aConstantes.getString("estado.sol.nora.pdte"));

    		}catch(Exception ex){   	   

         		java.io.StringWriter sw = new java.io.StringWriter();

         		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

         		ex.printStackTrace(pw);

         		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenarSolicitudNora: " + sw.getBuffer ().toString());

         		throw ex;

         	}finally{    		

     			if (tr.isTraceActive()){

     				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenarSolicitudNora: saliendo");                

                }  

     			return solicitud;

         	}	

         }

        /**
         * Método que dado la clave de Licencia para una prov y municipo comprueba si existe en BBDD          
         * @param claveLicen claveLicen
         * @param codMuni codMuni
         * @param codProv codProv
         * 
         * @return resul
         * @throws Exception Exception
         */
    	public String obtenerClavelicencia(String claveLicen, String codMuni, String codProv) throws Exception{  	 

    	    	boolean error = false;

    	    	Q02aCuestionarioVTMAnu cuestionarioVTMAnu = null;

    	    	String resul="";

    	  	  	try  	  {

    	  	  		if (tr.isTraceActive()){

    	  	  			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerClavelicencia, ** clave licencia bean=" + claveLicen + ", muni =" + codMuni+ " *** entrando");                

    	  	  		}

    	  	  		//se abre la conexión

    	  	  		abrirConexion();

    	  	  		//se instancia el dao pasandole la conexión			

    	  	  		daoCuestionariosVTMAnu = new Q02aCuestionariosVTMAnuDataBaseDAO(this.getConn());    	  	  		

    	  	  		//se llama al método del dao recupera el cuestionario

    	  	  		resul = daoCuestionariosVTMAnu.obtenerClavelicencia(claveLicen,codMuni, codProv);

    	  	  		//se devuelve el cuestionario recuperado

    	  	  		return resul;

    	  	  }catch(Exception ex){

    	  		  	error= true;

    	  		  	java.io.StringWriter sw = new java.io.StringWriter();

    	          	java.io.PrintWriter pw = new java.io.PrintWriter(sw);

    	          	ex.printStackTrace(pw);

    	          	tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerClavelicencia: " + sw.getBuffer ().toString());

    	          	throw ex;                     

    	 	  }finally{

    	 		  	try{

    	 		  		daoCuestionariosVTMAnu.freeResourcesNotConnection();

    	 		  	}catch(Exception ex){

    				   if (tr.isTraceActive()){

    					   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerClavelicencia: error liberando recursos");

    		   	   	   }  

    	 		  	}  		 

    	 		  	//se cierra la conexión  

    	 		  	cerrarConexion(error);	       	

    		        if (tr.isTraceActive()){

    		   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerClavelicencia: saliendo.");

    		   		}

    	 	  }

    	    }//fin obtenerClavelicencia

        /**
         * 
         * @param portal portal
         * @return idEntidad
         * @throws Exception Exception
         */
    	public String getEntidad(String portal) throws Exception

        {

        	String idEntidad = "";

        	boolean error = false;

            {          	              	

          	try{

          		 

          		if (tr.isTraceActive()){

            			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getEntidad: entrando");

            		}

      	  		//se abre la conexión

      			abrirConexion();

      			//se instancia el dao pasandole la conexión			

      			daoCuestionariosVTMAnu = new Q02aCuestionariosVTMAnuDataBaseDAO(this.getConn());

      			

      			idEntidad = daoCuestionariosVTMAnu.getEntidad(portal);

      			    			   			

      			return idEntidad;

          	}catch(Exception ex){

      	 		error= true;

      	        java.io.StringWriter sw = new java.io.StringWriter();

      	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

      	        ex.printStackTrace(pw);

      	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getEntidad: " + sw.getBuffer ().toString());

      	        throw ex;                     

       	    }finally{

       		    try{

       		    	daoCuestionariosVTMAnu.freeResourcesNotConnection();

       		    }catch(Exception ex){

      			   if (tr.isTraceActive()){

      				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getEntidad: error liberando recursos");

      	   	   	   }  

       		    }  		 

       		  	//se cierra la conexión  

       		    cerrarConexion(error);	       	

      	        if (tr.isTraceActive()){

      	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getEntidad: saliendo.");

      	   		}

       	    }  	

            }

        }//fin getEntidad

        
        /** Método que obtiene el hashmap.
         * @return hashMap HashMap
         */
        private HashMap obtenerHashMap() {
            return new HashMap();
        }
         

}