package q02a.exe.comun;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;

import org.apache.commons.beanutils.BasicDynaBean;

import q02a.exe.arquitectura.beans.Q02aBaseBean;
import q02a.exe.arquitectura.dataobjects.Q02aDAOException;
import q02a.exe.arquitectura.webCommon.beans.Q02aProcessLauncherBean;
import q02a.exe.arquitectura.webCommon.utils.gdtp.Q02aGenericDataTransferProtocol;
import q02a.exe.cuestionariosSMAnu.beans.Q02aCuestionariosSMBean;
import q02a.exe.cuestionariosSMAnu.valueobjects.Q02aCuestionarioSMFiltro;
import q02a.exe.cuestionariosVTMAnu.beans.Q02aCuestionariosVTMAnuBean;
import q02a.exe.cuestionariosVTMAnu.valueobjects.Q02aCuestionarioVTMFiltro;
import q02a.exe.cuestionarioVAPM.beans.Q02aCuestionarioVAPMBean;
import q02a.exe.cuestionarioVAPM.valueobjects.Q02aCuestionarioVAPM;
import q02a.exe.cuestionarioVAPM.valueobjects.Q02aCuestionarioVAPMFiltro;

import q02a.exe.utils.Q02aFormatData;
import q02a.exe.utils.Q02aNILocator;
import q02a.exe.utils.Q02aCODLocator;

import es.ejie.frmk.conectores.conectorJDBC.Q70ConectorJDBC;
import es.ejie.frmk.infraestructura.tablas.Q70GestorTablasCodigos;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.infraestructura.traza.Q70Traza;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;

/**
 * 
 * @author GADIMAAR
 *
 */
public class Q02aCoddataLauncher extends Q02aBaseBean implements Q02aProcessLauncherBean {
	
	private static final long serialVersionUID = 1L;

	/** Objeto tablaBD usado para buscar en base de datos */

	//protected TablaBDWWHISPLA tablaHISPLA=null;

	private String S99B_JNDI_DATASOURCE = Q70ListenerUtils.getApplicationProperty("CoddataLauncher",null,"S99_JNDI_DATASOURCE");

	private static Q70Traza tr = Q70Traza.getSingleton();

	private static final String COMPONENTE = "DAO_CODDATA_ACCESO_DATOS";

	/**

     *  Constructor vaco

     */



	 /* (non-Javadoc)

     * @see com.bbk.arquitectura.webCommon.beans.ProcessLauncherBean#initProcessLauncherBean(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)

     */

    /**
     * @param request request
     * @param response response
     * 
     * @throws Q02aDAOException Q02aDAOException
     */
    public void initProcessLauncherBean(HttpServletRequest request, HttpServletResponse response) throws Q02aDAOException {

		init(request,response);



    }

	/* (non-Javadoc)
     * @see com.bbk.arquitectura.webCommon.beans.ProcessLauncherBean#initProcessLauncherBean(javax.servlet.jsp.PageContext)
     */
    /**
     * @param context context
     * @throws Q02aDAOException Q02aDAOException
     */
    public void initProcessLauncherBean(PageContext context) throws Q02aDAOException {

    	this.request 	= (HttpServletRequest)context.getRequest();

    	this.response 	=(HttpServletResponse)context.getResponse();

    }


    /**
     * @throws Exception Exception
     * @return get
     */
	 public Q02aGenericDataTransferProtocol launch() throws Exception {

    	try{	       

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":launch: entrando");

			}

            String proceso = getParametro("METHOD");



            if ( proceso.equals("getComboData")){

	            return this.getComboData();

	        } else if (proceso.equals("getComboDataJS")){

	        	return this.getComboDataJS();

	        } else if (proceso.equals("getListaVariasColumnas")){

	        	return this.getListaVariasColumnas();

	        } else if (proceso.equals("getNI")){

	        	return this.getNI();

	        }else if (proceso.equals("getCOD")){

	        	return this.getCOD();

	        }

	        else if (proceso.equals("getNumCuestionariosPortada")){

	        	return this.getNumCuestionariosPortada();

	        }else if (proceso.equals("getNumCuestionariosPortadaSM")){

	        	return this.getNumCuestionariosPortadaSM();

	        }else if (proceso.equals("getEntidad")){

	        	return this.getEntidad();

	        }

            return null;

    	}catch(Exception e){

			return this.processException(e);

        }

     }

       

    /**
	 * Se invoca para obtener los valores de un combo de manera asncrona desde una etiqueta
	 * @throws  Exception Exception
	 * @return Q02aGenericDataTransferProtocol
	 */

    public Q02aGenericDataTransferProtocol getComboData() throws Exception {

    	//Se declaran las variables que no se van a modificar

    	final String TRACE_NAME	= ":getComboData:";

    	final String RESULT_1 	= "RESULT_1";

    	//Conexin a base de datos

    	java.sql.Connection conn = null;

    	

    	if (tr.isTraceActive()){

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_NAME + " entrando");

		}

    	//Resultado que se devolver

    	Q02aGenericDataTransferProtocol result = new Q02aGenericDataTransferProtocol(); 

    	//Objetos necesarios para lanzar la query

    	java.sql.PreparedStatement 	prepStmt = null;

        java.sql.ResultSet 			rs 		 = null;

        //Se almacena la query

        StringBuffer 				querySelect = new StringBuffer("");

        StringBuffer 				queryFrom 	= new StringBuffer("");

        StringBuffer 				queryWhere	= new StringBuffer("");

        StringBuffer 				query		= new StringBuffer("");

        try{ 

        	 //Se obtiene la conexin a la base de datos

        	 conn = Q70ConectorJDBC.getSingleton().getConnection(S99B_JNDI_DATASOURCE);

			 //Se obtiene el nombre de la tabla, el nombre de la columna que contiene los valores

        	 //de los cdigos y el nombre de las columnas que contienen las descripciones que se 

        	 //quieren visualizar

 			 String tableNameSelect 	= (String)getMapaDatos().get("TABLE");

 			 String codColumNameSelect	= (String)getMapaDatos().get("COD_COLUM_NAME_SELECT");

 			 String descColumNameSelect = (String)getMapaDatos().get("DESC_COLUM_NAME_SELECT");

 			 //Se obtiene el elemento separador si lo hubiera

 			 String elementoSeparador   = (String)getMapaDatos().get("SEPARADOR");

 			 //Se obtiene el nombre de la columna por la que se quiere hacer la where y su valor

 			 String codColumNameWhere	= (String)getMapaDatos().get("COD_COLUM_NAME_WHERE");

 			 String valueColumWhere  	= (String)getMapaDatos().get("VALUE_COLUM_NAME_WHERE");

 			 Boolean numericColumWhere	= new Boolean((String)getMapaDatos().get("NUMERIC_COLUM_WHERE"));

 			 String valueOptionalWhere  = (String)getMapaDatos().get("VALUE_OPTIONAL_WHERE");

 			 //Se obtiene el order by

 			 String columNameOrderBy	= (String)getMapaDatos().get("COLUM_ORDER_BY");

 			 //Se obtiene el orden del order by

 			 String ordenNameOrderBy	= (String)getMapaDatos().get("ORDEN_ORDER_BY");

 			 

 			 //Se elabora la parte SELECT

        	 querySelect.append("SELECT ").append(codColumNameSelect).append(",");

        	 //Se comprueba si se ha introducido varias columnas de descripcin a recuperar

        	 if(descColumNameSelect.indexOf(",")>0){

        		 //Se obtienen las dems columnas

        		 String[] columnas = descColumNameSelect.split(",");

        		 //Se recorren y se pegan

        		 for(int i=0;i<columnas.length;i++){

        			 querySelect.append(columnas[i]);

        			 //Si no es el ltimo, se pega la coma

        			 if(i!=(columnas.length-1)){

        				 querySelect.append(", ");

        			 }

        		 }

        	 } else {

        		 querySelect.append(descColumNameSelect);

        	 }

        	 //Se elabora la parte FROM

        	 queryFrom.append(" FROM ").append(tableNameSelect);

        	 //Se elabora la parte WHERE

			 queryWhere.append(" WHERE ").append(codColumNameWhere).append(" = ");			 	

			 //Si es numrico se busca de este manera

			 if(numericColumWhere.booleanValue()){

				 queryWhere.append(valueColumWhere);

			 } else {

				 queryWhere.append("'").append(valueColumWhere).append("'");

			 }

			 //Si existen clasulas opcionales WHERE se aaden

			 if(!Q02aFormatData.esVacio(valueOptionalWhere)){

				 queryWhere.append(" AND ").append(valueOptionalWhere);

			 }

			 //Si existe el order by se le pega

			 if(!Q02aFormatData.esVacio(columNameOrderBy)){

				 queryWhere.append(" ORDER BY ").append(columNameOrderBy);

			 }

			 //Se indica si el orden es ascendente y descendente

			 if(!Q02aFormatData.esVacio(columNameOrderBy) && !Q02aFormatData.esVacio(ordenNameOrderBy)){

				 queryWhere.append(" ").append(ordenNameOrderBy);

			 }

			 

			 //Se genera la select completa

			 query = query.append(querySelect.toString()).append(queryFrom.toString()).append(queryWhere.toString());

			  			 

			 //Se realiza un prepareStatement para lanzar la query

        	 prepStmt 	= conn.prepareStatement(query.toString());

        	 rs 		= prepStmt.executeQuery(); 

			 

        	 //Se aade un grupo al result

			 result.addGroup(RESULT_1);

			 result.addProperty(RESULT_1,"RESULT","OK");

			 

			 int i = 0;		

        	 while (rs.next()){	

        		 result.addProperty(RESULT_1,"CODIGO_"+i,rs.getString(codColumNameSelect));

        		 if(descColumNameSelect.indexOf(",")>0){

            		 //Se obtienen las dems columnas

            		 String[] 	columnas 		 = descColumNameSelect.split(",");

            		 //Variable para obtener la descripcin total

            		 String 	descripcionTotal = "";

            		 //Se comprueba si no existe elemento separador

            		 if(Q02aFormatData.esVacio(elementoSeparador)){

            			 elementoSeparador = " ";

            		 }

            		 //Se recorren las columnas para obtener la descripcin

            		 for(int j=0;j<columnas.length;j++){

            			 descripcionTotal += rs.getString(columnas[j]);

            			 //Si no es el ltimo, se pega el separador

            			 if(j!=(columnas.length-1)){

            				 descripcionTotal += elementoSeparador;

            			 }

            		 }

            		 result.addProperty(RESULT_1,"DESCRIPCION_"+i,descripcionTotal);

        		 } else {

            		 result.addProperty(RESULT_1,"DESCRIPCION_"+i,rs.getString(descColumNameSelect));

        		 }

        		 i++;

        	 }			

			 result.addProperty(RESULT_1,"NUMREGISTROS",String.valueOf(i));

        	 return result;      

        	 

       }catch(Exception ex){

    	    result.addProperty("RESULT_1","RESULT","NOOK");

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + TRACE_NAME + sw.getBuffer ().toString());

            throw new Q02aDAOException(ex);

       }finally{

    	   try{

    		   rs.close();

    		   prepStmt.close();

    		   conn.close();

    	   }catch(Exception ex){}

    	   if (tr.isTraceActive()){

    		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_NAME + " saliendo");                

           }          

       }

    }

       

       /**
   	 	* Se invoca para obtener los valores de un combo de manera asncrona desde una
   	 	* funcin JavaScript
   	 	* @throws Exception Exception
   	 	* @return Q02aGenericDataTransferProtocol
   	 	*/

       public Q02aGenericDataTransferProtocol getComboDataJS() throws Exception {
       		//Se declaran las variables que no se van a modificar
       		final String TRACE_NAME	= ":getComboDataJS:";
       		final String RESULT_1 	= "RESULT_1";
       		final String TRUE	 	= "true";
       		
        	if (tr.isTraceActive()){
    			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_NAME + " entrando");
    		}
        	//Variables necesarias
        	Vector v = new Vector();
        	//Resultado que se devolver
        	Q02aGenericDataTransferProtocol result = new Q02aGenericDataTransferProtocol();         
        	try{
   			 	//Se obtiene el nombre de la tabla, el nombre de la columna que contiene los valores
           	 	//de los cdigos y el nombre de las columnas que contienen las descripciones que se 
           	 	//quieren visualizar
    			 String tableNameSelect 	= (String)getMapaDatos().get("TABLE");
    			 String codColumNameSelect	= (String)getMapaDatos().get("COD_COLUM_NAME_SELECT");
    			 String descColumNameSelect = (String)getMapaDatos().get("DESC_COLUM_NAME_SELECT");
    			 String optionalWhere  		= (String)getMapaDatos().get("OPTIONAL_WHERE");
    			 String idioma 		 		= (String)getMapaDatos().get("IDIOMA");
    			 String distinct 		 	= (String)getMapaDatos().get("DISTINCT");
    			 String columOrder 		 	= (String)getMapaDatos().get("COLUM_ORDER");
    			 String sentidoOrder 		= (String)getMapaDatos().get("SENTIDO_ORDER");
    			 //Se asignan al vector las columnas recuperadas
    			 v.add(descColumNameSelect);
    			 v.add(codColumNameSelect);
    			 //Se comprueba si se ha introducido una optionalWhere
    			 if(Q02aFormatData.esVacio(optionalWhere)){
    				 optionalWhere = null;
    			 }
    			 if(!Q02aFormatData.esVacio(columOrder)){
    				 optionalWhere = ((optionalWhere== null)?" 1=1 ":optionalWhere) +" ORDER BY "+ columOrder +" "+sentidoOrder ;
    			 }
    			 
            	 //Se aade un grupo al result
    			 result.addGroup(RESULT_1);
    			 result.addProperty(RESULT_1,"RESULT","OK");
            	 //Se obtiene el ArrayList con los datos
    			 ArrayList lista = Q70GestorTablasCodigos.getSingleton().selectRecordsFromTable(tableNameSelect,optionalWhere,idioma,v);
    			 //Si se ha seleccionado la opcin distinct, entramos para modificar la lista obtenida de la base de datos
    			 if (TRUE.equals(distinct)){
			          //Se redefine la lista con los resultados
			          lista = this.obtenerListaDistinct(lista,codColumNameSelect);			           
 	             }
    			 //Se recorren los objetos devueltos
    			 for (int i=0; i < lista.size();i++){
    				 String codigo 	= null;
    				 //se trata el cdigo teniendo en cueta que puede ser de diversos tipos de datos
    			 if ((((BasicDynaBean) lista.get(i)).get(codColumNameSelect)) instanceof String) {    				
    				codigo 		= (((BasicDynaBean)lista.get(i)).get(codColumNameSelect)).toString();
					}else if((((BasicDynaBean) lista.get(i)).get(codColumNameSelect)) instanceof BigDecimal)
					{	
    				 codigo 		= ((BigDecimal)((BasicDynaBean)lista.get(i)).get(codColumNameSelect)).toString();
					}else
					{
						codigo 		= ((Integer)((BasicDynaBean)lista.get(i)).get(codColumNameSelect)).toString();
					}
    			 
    			 	String descripcion = null;
    			 	//Se trata la desc teniendo en cueta que puede ser de diversos tipos de datos
    			 	if(((BasicDynaBean)lista.get(i)).get(descColumNameSelect)instanceof String )
    			 	{	
    				descripcion 	= (String)((BasicDynaBean)lista.get(i)).get(descColumNameSelect);
    			 	}
    			 	else if(((BasicDynaBean)lista.get(i)).get(descColumNameSelect)instanceof BigDecimal)

    			 	{

    			 		descripcion = ((BigDecimal)((BasicDynaBean)lista.get(i)).get(descColumNameSelect)).toString();

    			 	}else

    			 	{

    			 		descripcion = ((Integer)((BasicDynaBean)lista.get(i)).get(descColumNameSelect)).toString();

    			 	}

    				result.addProperty(RESULT_1,"CODIGO_"+i,codigo);

    				result.addProperty(RESULT_1,"DESCRIPCION_"+i,descripcion);

    			 }

    			 //Se indica el nmero de registros generados

    			 result.addProperty(RESULT_1,"NUMREGISTROS",String.valueOf(lista.size()));

    			 //Se devuelve el resultado

    			 return result;   	

            }catch(Exception ex){

            	result.addProperty("RESULT_1","RESULT","NOOK");

                java.io.StringWriter sw = new java.io.StringWriter();

                java.io.PrintWriter pw = new java.io.PrintWriter(sw);

                ex.printStackTrace(pw);

                tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + TRACE_NAME + sw.getBuffer ().toString());

                throw new Q02aDAOException(ex);

           }

       }


      /**
	 	* Funcin que devuelve aquellos roles que no tienen ninguna restriccin. De este modo y, comparando con los roles del usuario del sistema,
	 	* podemos conocer a qu objetos (seccion, temas, etc...) tiene acceso.
	 	* 
	 	* @param tableRoles 		- Tabla que contiene los roles del sistema
	 	* @param codColumTableRoles - Columna del nmero interno del rol
	 	* @param tableRolesObjeto   - Tabla que relaciona el rol con el objeto concreto e.j. relacin rol-seccin, rol-tema etc...
	 	* 
	 	* @return ArrayList
        * @throws Exception Exception
	 	*/
      private ArrayList obtenerRolesSinRestricciones(String tableRoles,String codColumTableRoles,String tableRolesObjeto) throws Exception
      {
      		//Se declaran las variables que no se van a modificar
      		final String TRACE_NAME	= ":obtenerRolesSinRestricciones:";
      		//Se instancia el ArrayList

      		ArrayList array = new ArrayList();

      		//Conexin a base de datos

      		java.sql.Connection 		conn 	 = null;

        	//Objetos necesarios para lanzar la query

        	java.sql.PreparedStatement 	prepStmt = null;

            java.sql.ResultSet 			rs 		 = null;

            //Se almacena la query

            StringBuffer 				query	 = new StringBuffer("");

            try{

       	 		//Se obtiene la conexin a la base de datos

       	 		conn = Q70ConectorJDBC.getSingleton().getConnection(S99B_JNDI_DATASOURCE);

       	 		//Se construye la query

       	 		query.append("SELECT ").append(codColumTableRoles).append(" FROM ").append(tableRoles);

       	 		query.append(" WHERE ").append(codColumTableRoles).append(" NOT IN (SELECT distinct(");

       	 		query.append(codColumTableRoles).append(") FROM ").append(tableRolesObjeto).append(")");

   				//Se realiza un prepareStatement para lanzar la query

       	 		prepStmt 	= conn.prepareStatement(query.toString());

       	 		rs 			= prepStmt.executeQuery(); 

       	 		//Mientras existan registros

	       	 	while (rs.next()){

	       	 		array.add(rs.getString(codColumTableRoles));

	       	 	}

	       	 	//Se devuelve el array con los roles

	       	 	return array;

            } catch(Exception ex){

                java.io.StringWriter sw = new java.io.StringWriter();

                java.io.PrintWriter pw = new java.io.PrintWriter(sw);

                ex.printStackTrace(pw);

                tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + TRACE_NAME + sw.getBuffer ().toString());

                throw new Q02aDAOException(ex);

           }finally{

        	   try{

        		   rs.close();

        		   prepStmt.close();

        		   conn.close();

        	   }catch(Exception ex){}

        	   if (tr.isTraceActive()){

        		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_NAME + " saliendo");                

               }          

           }

      }

      

      /**
	 	* Devuelve un ArrayList con los objetos que no tienen repetido el cdigo
	 	* 
	 	* @param lista 				- Lista con los resultados de la query
	 	* @param codColumNameSelect	- Nombre de la columna
	 	* 
	 	* @return ArrayList
	 	*/

      private ArrayList obtenerListaDistinct(ArrayList lista, String codColumNameSelect)

      {

    	  // Variable donde se guardarn los cdigos y de este modo conocer los que ya han salido

          ArrayList codigos 		= new ArrayList();

          //Variable donde se guardarn los componentes de la lista

          ArrayList resultados 	= new ArrayList();

          //Se recorre cada uno de los elementos de la lista

          for (int i=0; i < lista.size();i++){

        	//Cdigo

        	String codigo ="";

          	//Se obtiene el cdigo del elemento

        	Object codColumNameSelectDynaBean = ((BasicDynaBean)lista.get(i)).get(codColumNameSelect);

          	//En funcin del tipo de datos que se recoge se realiza el parse

        	if(codColumNameSelectDynaBean instanceof Integer){

          		codigo = ((Integer)((BasicDynaBean)lista.get(i)).get(codColumNameSelect)).toString();

          	} else if(codColumNameSelectDynaBean instanceof Long){

          		codigo = ((Long)((BasicDynaBean)lista.get(i)).get(codColumNameSelect)).toString();

          	} else if(codColumNameSelectDynaBean instanceof BigDecimal){

          		codigo = ((BigDecimal)((BasicDynaBean)lista.get(i)).get(codColumNameSelect)).toString();

          	} else if(codColumNameSelectDynaBean instanceof String){

          		codigo = ((BasicDynaBean)lista.get(i)).get(codColumNameSelect).toString();

          	}

          	//Si el arrayList de cdigos no tiene el cdigo obtenido quiere decir que es la primera vez que aparece

          	if (!codigos.contains(codigo)){

          		//Se aade a la lista de resultados el objeto

          		resultados.add(lista.get(i));

          		//Se aade a la lista de cdigos el cdigo para que no se vuelva a repetir

          		codigos.add(codigo);

          	}

          }

         //Se redefine la lista con los resultados

         lista = resultados;

         //Se devuelve el arrayList

         return lista;

      }

      

      /**
	    * Mtodo que obtiene un nmero variable de columnas 
	    * @return result
	    * @throws Exception Exception
	    */

	   public Q02aGenericDataTransferProtocol getListaVariasColumnas() throws Exception {

//		 Se declaran las variables que no se van a modificar

     		//final String TRACE_NAME	= "getListaVariasColumnas:";

     		final String RESULT_1 	= "RESULT_1";

     		//final String TRUE	 	= "true";

	    	if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getListaVariasColumnas: entrando");

			}

//	    	Variables necesarias

       	Vector v = new Vector();

       	//Resultado que se devolver

       	Q02aGenericDataTransferProtocol result = new Q02aGenericDataTransferProtocol();         

       	try{

  			 	//Se obtiene el nombre de la tabla, el nombre de la columna que contiene los valores

          	 	//de los cdigos y el nombre de las columnas que contienen las descripciones que se 

          	 	//quieren visualizar

   			 String tableNameSelect 		= (String)getMapaDatos().get("TABLE");

  			 String columnasNameSelect		= (String)getMapaDatos().get("LISTA_COLUM_NAME_SELECT");

  			 String optionalWhere  			= (String)getMapaDatos().get("OPTIONAL_WHERE");

   			 String idioma 		 		= (String)getMapaDatos().get("IDIOMA");

   			 

   			if(Q02aFormatData.esVacio(optionalWhere)){

  				 optionalWhere = null;

  			 } 

   			

   			 //Se asignan al vector las columnas recuperadas

   			 String [] arrColumnas = columnasNameSelect.split("#");

   			 for(int i=0;i<arrColumnas.length;i++){

   				 v.add(arrColumnas[i]);

   			 }

           	 //Se aade un grupo al result

   			 result.addGroup(RESULT_1);

   			 result.addProperty(RESULT_1,"RESULT","OK");

   			 //Se crea la where

           	 //Se obtiene el ArrayList con los datos

   			 ArrayList lista = Q70GestorTablasCodigos.getSingleton().selectRecordsFromTable(tableNameSelect,optionalWhere,idioma,v);

 

   			 String listaColumnas= "";

   			 //Se recorren los objetos devueltos

   			 for (int i=0; i < lista.size();i++){

   				 //Se aaden las columnas de los objetos seleccionados

   				 listaColumnas += ((listaColumnas.equals(""))?"":"#");

   				 for (int j=0;j<arrColumnas.length;j++)

   				 {

   					 listaColumnas += ((listaColumnas.equals(""))?"":",");

	   				 String columna 	= null;

	   				 //se trata el cdigo teniendo en cueta que puede ser de diversos tipos de datos

	   				 if ((((BasicDynaBean) lista.get(i)).get(arrColumnas[j])) instanceof Integer) {    				

		   				columna 		= ((Integer)((BasicDynaBean)lista.get(i)).get(arrColumnas[j])).toString();

							}else if((((BasicDynaBean) lista.get(i)).get(arrColumnas[j])) instanceof BigDecimal)

							{	

								columna 		= ((BigDecimal)((BasicDynaBean)lista.get(i)).get(arrColumnas[j])).toString();

							}else if((((BasicDynaBean) lista.get(i)).get(arrColumnas[j])) instanceof Date)

							{	

								columna 		= Q02aFormatData.formatearFecha(((BasicDynaBean)lista.get(i)).get(arrColumnas[j]).toString(),"1",null);

							}else

							{

								columna 		= (((BasicDynaBean)lista.get(i)).get(arrColumnas[j])).toString();

							}

	   				listaColumnas +=columna; 

	   			 }

   			 }

   			 result.addProperty(RESULT_1,"RESULTADO",listaColumnas);

   			 //Se devuelve el resultado

   			 return result;   	

	       }catch(Exception ex){

	    	    result.addProperty("RESULT_1","RESULT","NOOK");

	            java.io.StringWriter sw = new java.io.StringWriter();

	            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	            ex.printStackTrace(pw);

	            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getListaVariasColumnas: " + sw.getBuffer ().toString());

	            throw new Q02aDAOException(ex);

	       }finally{

	    	   

	    	   if (tr.isTraceActive()){

	    		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getListaVariasColumnas: saliendo");                

	           }

	           

	       }

	       

	   }

	   

	   /**
	    * Mtodo que devuelve el ni de un objeto de tabla de tablas a partir de la tabla y el cdigo
	    * @return result
	    * @throws Exception Exception
	    */

	   public Q02aGenericDataTransferProtocol getNI() throws Exception {
	    	if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNI: entrando");
			}
	    	Q02aGenericDataTransferProtocol result = new Q02aGenericDataTransferProtocol(); 
	  
	        try{ 
	            String idTabla = (String)getMapaDatos().get("idTabla");
	            String clave = (String)getMapaDatos().get("clave");
	        	
	        	String niObjeto = Q02aNILocator.getNI(idTabla,clave);

	        	result.addGroup("RESULT_1"); 			
	 			result.addProperty("RESULT_1","RESULT","OK");
	 			result.addProperty("RESULT_1","niObjeto", niObjeto);
	           
	 			return result;
	        
	       }catch(Exception ex){

	    	    result.addProperty("RESULT_1","RESULT","NOOK");

	            java.io.StringWriter sw = new java.io.StringWriter();

	            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	            ex.printStackTrace(pw);

	            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNI: " + sw.getBuffer ().toString());

	            throw new Q02aDAOException(ex);

	       }finally{ 

	    	   if (tr.isTraceActive()){

	    		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNI: saliendo");                

	           }    

	       } 

	    }

	   

	   /**
	    * Mtodo que devuelve el cdigo de un objeto de tabla de tablas a partir de la tabla y el ni
	    * @return result
	    * @throws Exception Exception
	    */
	   public Q02aGenericDataTransferProtocol getCOD() throws Exception {

	    	if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getCod: entrando");
			}
	    	Q02aGenericDataTransferProtocol result = new Q02aGenericDataTransferProtocol(); 
	  
	        try{ 

	            String niObjeto = (String)getMapaDatos().get("niObjeto");

	        	String codObjeto = Q02aCODLocator.getCOD(niObjeto);
	        	
	        	result.addGroup("RESULT_1"); 			
	 			
	 			result.addProperty("RESULT_1","RESULT","OK");
	 			result.addProperty("RESULT_1","codObjeto", codObjeto);
	           
	 			return result;
	        
	       }catch(Exception ex){

	    	    result.addProperty("RESULT_1","RESULT","NOOK");

	            java.io.StringWriter sw = new java.io.StringWriter();

	            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	            ex.printStackTrace(pw);

	            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getCod: " + sw.getBuffer ().toString());

	            throw new Q02aDAOException(ex);

	       }finally{ 

	    	   if (tr.isTraceActive()){

	    		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getCod: saliendo");                

	           }    

	       } 

	    }

	   

	   /**
	    * Mtodo que devuelve el nmero de cuestionarios realizados de Suelo Municipal 
	    * @return result
	    * @throws Exception Exception
	    */

	   public Q02aGenericDataTransferProtocol getNumCuestionariosPortada() throws Exception {
	    	
		   Q02aGenericDataTransferProtocol result = null; 
		   Q02aCuestionariosSMBean beanCuestionarioSMAnu = null;
		   Q02aCuestionariosVTMAnuBean beanCuestionariosVTMAnu = null;
		   Q02aCuestionarioVAPMBean beanCuestionarioVAPM = null;
           Q02aCuestionarioVAPMFiltro miCuesVAPMFiltro = new Q02aCuestionarioVAPMFiltro();
		   
		   int numCuestionariosSM = 0;
	       int numCuestionariosOM = 0;
	       int numCuestionariosVA = 0;
	       
	       String prevSueloInicial = "";
	       String concedidoLicenInicial = "";
	       String concedidoLicenVAPM = "";
           
           String niGrupoCuesSMAnu = "";
           String niGrupoCuesVTMAnu = "";
           String niCuesVAPM = "";
           
		   if (tr.isTraceActive()) {
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumCuestionariosPortada: entrando");
		   }
		   try {
               
                String mesReferencia = ""; mesReferencia = (String)getMapaDatos().get("mesReferencia");
	            String anyoReferencia = ""; anyoReferencia = (String)getMapaDatos().get("anyoReferencia");
	            String territorio = ""; territorio = (String)getMapaDatos().get("territorio");
	            String municipio = ""; municipio = (String)getMapaDatos().get("municipio");
                String idiomaPagina = (String)getMapaDatos().get("idiomaPagina");
                if ( "".equals(idiomaPagina) || idiomaPagina == null){
                    idiomaPagina = "es";
                }
	        	
                if ( !"".equals(anyoReferencia) ){ miCuesVAPMFiltro.setAno( anyoReferencia ); }
                if ( !"".equals(territorio) ){ miCuesVAPMFiltro.setCodProv( territorio ); }
                if ( !"".equals(municipio) ){ miCuesVAPMFiltro.setCodMuni( municipio ); }
                
	            beanCuestionarioSMAnu = new Q02aCuestionariosSMBean();
	            beanCuestionariosVTMAnu = new Q02aCuestionariosVTMAnuBean();
	            beanCuestionarioVAPM = new Q02aCuestionarioVAPMBean();
	            result = new Q02aGenericDataTransferProtocol();
                
	            numCuestionariosSM = beanCuestionarioSMAnu.getNumCuestionariosPortada(territorio, municipio, anyoReferencia, mesReferencia);
	            numCuestionariosOM = beanCuestionariosVTMAnu.getNumCuestionariosPortada(territorio, municipio, anyoReferencia, mesReferencia);
	            numCuestionariosVA = beanCuestionarioVAPM.getNumCuestionariosPortada(territorio, municipio, anyoReferencia, mesReferencia);
	            
	            prevSueloInicial = beanCuestionarioSMAnu.getPrevisionGrupoCuesSM(territorio, municipio, anyoReferencia, mesReferencia);
	            concedidoLicenInicial = beanCuestionariosVTMAnu.getConcedidoGrupoCuesVTM(territorio, municipio, anyoReferencia, mesReferencia);
	            concedidoLicenVAPM = beanCuestionarioVAPM.getConcedidoLicenGrupoCuesVAPM(territorio, municipio, anyoReferencia, mesReferencia);
	            
	            niGrupoCuesSMAnu = beanCuestionarioSMAnu.getNiGrupoCuesSM(territorio, municipio, anyoReferencia, mesReferencia);
	            niGrupoCuesVTMAnu = beanCuestionariosVTMAnu.getNiGrupoCuesVTM(territorio, municipio, anyoReferencia, mesReferencia);
                
                
	            //Se obtiene la conexin a la base de datos
       	 		conn = Q70ConectorJDBC.getSingleton().getConnection(Q02_JNDI_DATASOURCE);
       	 		
	       	 	result.addGroup("RESULT_1"); 			
	 			result.addProperty("RESULT_1", "RESULT", "OK");
	 			result.addProperty("RESULT_1", "numCuestionariosSM", Integer.toString(numCuestionariosSM));
	 			result.addProperty("RESULT_1", "numCuestionariosOM", Integer.toString(numCuestionariosOM));
	 			result.addProperty("RESULT_1", "numCuestionariosVA", Integer.toString(numCuestionariosVA));
	           	result.addProperty("RESULT_1", "prevSueloInicial", prevSueloInicial);
	           	result.addProperty("RESULT_1", "concedidoLicenInicial", concedidoLicenInicial);
	           	result.addProperty("RESULT_1", "concedidoLicenVAPM", concedidoLicenVAPM);
	        	result.addProperty("RESULT_1", "niGrupoCuesSMAnu", niGrupoCuesSMAnu);
	        	result.addProperty("RESULT_1", "niGrupoCuesVTMAnu", niGrupoCuesVTMAnu);
                
       	 		
                // MOSTRAR OBSERVACIONES SI -> han puesto que NO = concedidoLicenInicial = 0 
                //VTM
                String ObserVTMAnu = "";
                if ( "0".equals(concedidoLicenInicial) 
                        && mesReferencia != null && !"".equals(mesReferencia) ) { //Traerlas observaciones
                    ObserVTMAnu = beanCuestionariosVTMAnu.getObservacionesPortadaVTM(territorio, municipio, anyoReferencia, mesReferencia);
                    if ("noExistReg".equals(ObserVTMAnu)) {
                        result.addProperty("RESULT_1", "concedidoLicenInicial", "");   //No existe
                        result.addProperty("RESULT_1", "ObserVTMAnu", "");
                    }else{
                        result.addProperty("RESULT_1", "ObserVTMAnu", ObserVTMAnu);
                        result.addProperty("RESULT_1", "concedidoLicenInicial", concedidoLicenInicial);  
                    }
                }else if (numCuestionariosOM == 0 && "".equals(concedidoLicenInicial)){
                    result.addProperty("RESULT_1", "concedidoLicenInicial", "");   //No existe
                    result.addProperty("RESULT_1", "ObserVTMAnu", "");
                }else if ( "1".equals(concedidoLicenInicial)){
                    result.addProperty("RESULT_1", "ObserVTMAnu", "");
                }
                
                //SM
                String ObserSM = "";
                if ( ("0".equals(prevSueloInicial) || "".equals(prevSueloInicial))
                        && mesReferencia != null && !"".equals(mesReferencia) ) { //Traerlas observaciones
                    ObserSM = beanCuestionarioSMAnu.getObservacionesPortadaSM(territorio, municipio, anyoReferencia, mesReferencia);
                    if ("noExistRegSM".equals(ObserSM)) {
                        result.addProperty("RESULT_1", "prevSueloInicial", "");   //No existe
                        result.addProperty("RESULT_1", "ObserSM", "");
                    }else{
                        result.addProperty("RESULT_1", "ObserSM", ObserSM);
                        result.addProperty("RESULT_1", "prevSueloInicial", prevSueloInicial);  
                    }
                }else if (numCuestionariosSM == 0 && "".equals(prevSueloInicial)){
                    result.addProperty("RESULT_1", "prevSueloInicial", "");   //No existe
                    result.addProperty("RESULT_1", "ObserSM", "");
                }else if ( "1".equals(prevSueloInicial)){
                    result.addProperty("RESULT_1", "ObserSM", "");
                }
                
                //VAPM
                String ObserVAPM = "";
                Q02aCuestionarioVAPM miQ02aCuestionarioVAPM = new Q02aCuestionarioVAPM();
                
                if ( "0".equals(concedidoLicenVAPM) && mesReferencia != null
                        && "1".equals(mesReferencia) ) { //Traerlas observaciones
                    
                    miQ02aCuestionarioVAPM = beanCuestionarioVAPM.getObservacionesPortadaVA(territorio, municipio, anyoReferencia, mesReferencia);
                    niCuesVAPM = beanCuestionarioVAPM.obtenerNiCuesVAPM(miCuesVAPMFiltro);
                    
                    if ( "1".equals(mesReferencia) ){
                        result.addProperty("RESULT_1", "niCuesVAPM", niCuesVAPM);
                    }else{
                        result.addProperty("RESULT_1", "niCuesVAPM", "");
                    }
                    
                    if ( "noExistRegVAPM".equals( miQ02aCuestionarioVAPM.getObsal()) ) {
                        result.addProperty("RESULT_1", "concedidoLicenVAPM", "");   //No existe
                        result.addProperty("RESULT_1", "observacionesVA", "");
                    }else{
                        result.addProperty("RESULT_1", "observacionesVA", miQ02aCuestionarioVAPM.getObsal());
                        result.addProperty("RESULT_1", "concedidoLicenVAPM", concedidoLicenVAPM);  
                    }
                }else if (numCuestionariosVA == 0 && "".equals(concedidoLicenVAPM)){
                    result.addProperty("RESULT_1", "concedidoLicenVAPM", "");   //No existe
                    result.addProperty("RESULT_1", "observacionesVA", "");
                    result.addProperty("RESULT_1", "niCuesVAPM", "");
                }else if ( "1".equals(concedidoLicenVAPM)){
                    result.addProperty("RESULT_1", "concedidoLicenVAPM", "");
                    result.addProperty("RESULT_1", "niCuesVAPM", "");
                }
                
                // ------- Cuest Sin Grabar--------
                String sinGrabarVTMAnu = "";
                String sinGrabarSM = "";
                String sinGrabarVAPM = "";
                
                Q02aCuestionarioVTMFiltro cuestionariosVTMFiltro = new Q02aCuestionarioVTMFiltro();
                Q02aCuestionarioSMFiltro cuestionariosSMFiltro = new Q02aCuestionarioSMFiltro();
                Q02aCuestionarioVAPMFiltro cuestionariosVAPMFiltro = new Q02aCuestionarioVAPMFiltro();
                
                if ( !"".equals(anyoReferencia) ){
                        cuestionariosVTMFiltro.setAno(anyoReferencia);
                        cuestionariosSMFiltro.setAno(anyoReferencia);
                        cuestionariosVAPMFiltro.setAno(anyoReferencia);}
                if ( !"".equals(mesReferencia) ){
                        cuestionariosVTMFiltro.setMes(mesReferencia);
                        cuestionariosSMFiltro.setMes(mesReferencia);}
                if ( !"".equals(territorio) ){
                        cuestionariosVTMFiltro.setCodMuni(municipio);
                        cuestionariosSMFiltro.setCodMuni(municipio);
                        cuestionariosVAPMFiltro.setCodMuni(municipio);}
                if ( !"".equals(municipio) ){
                        cuestionariosVTMFiltro.setCodProv(territorio);
                        cuestionariosSMFiltro.setCodProv(territorio);
                        cuestionariosVAPMFiltro.setCodProv(territorio);}
                 
                //VTM
                ArrayList listaCuestionariosVTM = new ArrayList();
                Q02aCuestionariosVTMAnuBean beanCuestionarioVTMAnu= new Q02aCuestionariosVTMAnuBean();
                
                listaCuestionariosVTM = beanCuestionarioVTMAnu.getCuestionariosSinGrabarVTM(cuestionariosVTMFiltro);
                if ( listaCuestionariosVTM != null ){
//                  Tengo la lista de los cuestionarios que tengo.
                    //Ahora ponemos los que no tenemos
                    HashMap mesesHashMap;
                    
                    String sinGrabarVTM = "";
                    if ( listaCuestionariosVTM != null && !"".equals(mesReferencia) ){
                        ArrayList arrayGrabada = new ArrayList ();
                        arrayGrabada = listaCuestionariosVTM;
                        if ( "1".equals(mesReferencia) ) {//mes enero
                            boolean guardar = false;
                            String miMes ;
                            for(int i=10; i <= 12; i++) {
                                for(int j=0; j < arrayGrabada.size(); j++) {
                                    mesesHashMap = (HashMap)arrayGrabada.get(j);
                                    miMes =  (mesesHashMap.get("mes").toString());
                                    if( (miMes.equals(Integer.toString(i))) ) {
                                        guardar = true;
                                        break;
                                    }
                                }
                                if (!guardar){
                                    sinGrabarVTM = sinGrabarVTM + escribeMes( Integer.toString(i), idiomaPagina) + " ";
                                }
                                guardar = false;
                            }
                        }else{//mes 
                            boolean guardar = false;
                            String miMes ;
                            for(int i=1; i <= Integer.parseInt(mesReferencia)-1; i++) {
                                for(int j=0; j < arrayGrabada.size(); j++) {
                                    mesesHashMap = (HashMap)arrayGrabada.get(j);
                                     miMes =  (mesesHashMap.get("mes").toString());
                                    if( (miMes.equals(Integer.toString(i))) ) {
                                        guardar = true;
                                        break;
                                    }
                                }
                                if (!guardar){
                                    sinGrabarVTM = sinGrabarVTM + escribeMes( Integer.toString(i), idiomaPagina) + " ";
                                }
                                guardar = false;
                            }
                        }
                        //contexto.set("listaCuestionariosSinGrabarVTMA", arraySinGrabar);
                    }
                    
                    result.addProperty("RESULT_1", "listaSinGrabarOM", sinGrabarVTM);
                }
                //SM
                ArrayList listaCuestionariosSM= new ArrayList(); 
                Q02aCuestionariosSMBean beanCuestionarioSM = new Q02aCuestionariosSMBean();
                
                listaCuestionariosSM = beanCuestionarioSM.getCuestionariosSinGrabarSM(cuestionariosSMFiltro);
                if ( listaCuestionariosSM != null ){
//                  Tengo la lista de los cuestionarios que tengo.
                    //Ahora ponemos los que no tenemos
                    HashMap mesesHashMap;
                    
                    sinGrabarSM = "";
                    if ( listaCuestionariosSM != null && !"".equals(mesReferencia) ){
                        ArrayList arrayGrabada = new ArrayList ();
                        arrayGrabada = listaCuestionariosSM;
                        if ( "1".equals(mesReferencia) ) {//mes enero
                            boolean guardar = false;
                            String miMes ;
                            for(int i=10; i <= 12; i++) {
                                for(int j=0; j < arrayGrabada.size(); j++) {
                                    mesesHashMap = (HashMap)arrayGrabada.get(j);
                                    miMes =  (mesesHashMap.get("mes").toString());
                                    if( (miMes.equals(Integer.toString(i))) ) {
                                        guardar = true;
                                        break;
                                    }
                                }
                                if (!guardar){
                                    sinGrabarSM = sinGrabarSM + escribeMes( Integer.toString(i), idiomaPagina) + " ";
                                }
                                guardar = false;
                            }
                        }else{//mes 
                            boolean guardar = false;
                            String miMes ;
                            for(int i=1; i <= Integer.parseInt(mesReferencia)-1; i++) {
                                for(int j=0; j < arrayGrabada.size(); j++) {
                                    mesesHashMap = (HashMap)arrayGrabada.get(j);
                                     miMes =  (mesesHashMap.get("mes").toString());
                                    if( (miMes.equals(Integer.toString(i))) ) {
                                        guardar = true;
                                        break;
                                    }
                                }
                                if (!guardar){
                                    sinGrabarSM = sinGrabarSM + escribeMes( Integer.toString(i), idiomaPagina) + " ";
                                }
                                guardar = false;
                            }
                           
                        }
                    }
                    result.addProperty("RESULT_1", "listaSinGrabarSM", sinGrabarSM);
                }
                
                //VAPM
                ArrayList listaCuestionariosVAPM= new ArrayList(); 
                Q02aCuestionarioVAPMBean beanCuestionarioVAPM2= new Q02aCuestionarioVAPMBean();
                
                listaCuestionariosVAPM = beanCuestionarioVAPM2.getCuestionariosSinGrabarVAPM(cuestionariosVAPMFiltro);
                
//              Tengo la lista de los cuestionarios que tengo.
                //Ahora ponemos los que no tenemos
                if ( listaCuestionariosVAPM != null && !"".equals(mesReferencia) ){
                    if ( !"1".equals(mesReferencia) ) {//mes enero
                        ArrayList arrayGrabada = new ArrayList ();
                        arrayGrabada = null;
                        arrayGrabada = listaCuestionariosVAPM;
                        sinGrabarVAPM =  "";
                        if (arrayGrabada.isEmpty() ||  arrayGrabada == null){
                            sinGrabarVAPM = escribeMes( "1", idiomaPagina );
                        }
                        
                    }
                    result.addProperty("RESULT_1", "listaSinGrabarVAPM", sinGrabarVAPM) ;
                }
                //---------------
                
       	 		if (tr.isTraceActive()) {
       	 			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumCuestionariosPortada: saliendo");                
       	 		} 
       	 		return result;

	       } catch (Exception ex) {
	    	    result.addProperty("RESULT_1", "RESULT", "NOOK");
	            java.io.StringWriter sw = new java.io.StringWriter();
	            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	            ex.printStackTrace(pw);
	            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumCuestionariosPortada: " + sw.getBuffer ().toString());
	            throw new Q02aDAOException(ex);
	       }
       } 
  

	   /**
	    * Mtodo que devuelve el nmero de cuestionarios realizados de Suelo Municipal 
	    * @return result
	    * @throws Exception Exception
	    */
	   public Q02aGenericDataTransferProtocol getNumCuestionariosPortadaSM() throws Exception {
	    	
		   Q02aGenericDataTransferProtocol result = null; 
		   Q02aCuestionariosSMBean beanCuestionarioSMAnu= null;
		   
		   int numCuestionariosSM=0;
	       
	       String prevSueloInicial="";
	       String niGrupoCuesSMAnu = "";
           if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumCuestionariosPortadaSM: entrando");
		   }
		   try{ 
	        	String mesReferencia = (String)getMapaDatos().get("mesReferencia");
	            String anyoReferencia = (String)getMapaDatos().get("anyoReferencia");
	            String territorio = (String)getMapaDatos().get("territorio");
	            String municipio = (String)getMapaDatos().get("municipio");
	        	
	            beanCuestionarioSMAnu= new Q02aCuestionariosSMBean();
	            result = new Q02aGenericDataTransferProtocol();
	            
	            numCuestionariosSM = beanCuestionarioSMAnu.getNumCuestionariosPortada(territorio, municipio, anyoReferencia, mesReferencia);
	            prevSueloInicial = beanCuestionarioSMAnu.getPrevisionGrupoCuesSM(territorio, municipio, anyoReferencia, mesReferencia);
	            niGrupoCuesSMAnu = beanCuestionarioSMAnu.getNiGrupoCuesSM(territorio, municipio, anyoReferencia, mesReferencia);
	            //Se obtiene la conexin a la base de datos
       	 		conn = Q70ConectorJDBC.getSingleton().getConnection(Q02_JNDI_DATASOURCE);
       	 		
	       	 	result.addGroup("RESULT_1"); 			
	 			result.addProperty("RESULT_1","RESULT","OK");
	 			result.addProperty("RESULT_1","numCuestionariosSM", Integer.toString(numCuestionariosSM));
	 		   	result.addProperty("RESULT_1","prevSueloInicial", prevSueloInicial);
	        	result.addProperty("RESULT_1","niGrupoCuesSMAnu", niGrupoCuesSMAnu);
	        	
       	 		if (tr.isTraceActive()){
       	 			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumCuestionariosPortadaSM: saliendo");                
       	 		} 
       	 		return result;
	       }catch(Exception ex){
	    	    result.addProperty("RESULT_1","RESULT","NOOK");
	            java.io.StringWriter sw = new java.io.StringWriter();
	            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	            ex.printStackTrace(pw);
	            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumCuestionariosPortadaSM: " + sw.getBuffer ().toString());
	            throw new Q02aDAOException(ex);
	       }
       } 

   
	   /**
	    * Mtodo que devuelve el nmero de Entidad segn prov/muni/portal
	    * @return result
	    * @throws Exception Exception
	    */

	   public Q02aGenericDataTransferProtocol getEntidad() throws Exception {
	    	
		   Q02aGenericDataTransferProtocol result = null; 
		   //Q02aCuestionariosSMBean beanCuestionarioSMAnu= null;
		   Q02aCuestionariosVTMAnuBean beanCuestionariosVTMAnu = null;

		   String idEntidad = "";

           if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getEntidad: entrando");
		   }
		   try{ 
	        	String portal = (String)getMapaDatos().get("portal");
	            /*String anyoReferencia = (String)getMapaDatos().get("anyoReferencia");
	            String territorio = (String)getMapaDatos().get("territorio");
	            String municipio = (String)getMapaDatos().get("municipio");*/

	        	beanCuestionariosVTMAnu= new Q02aCuestionariosVTMAnuBean();
	            result = new Q02aGenericDataTransferProtocol();

	            idEntidad = beanCuestionariosVTMAnu.getEntidad(portal);

	            //Se obtiene la conexin a la base de datos
       	 		conn = Q70ConectorJDBC.getSingleton().getConnection(Q02_JNDI_DATASOURCE);

	       	 	result.addGroup("RESULT_1"); 			
	 			result.addProperty("RESULT_1","RESULT","OK");

	 			//result.addProperty("RESULT_1","numCuestionariosSM", Integer.toString(numCuestionariosSM));
	 		   	//result.addProperty("RESULT_1","prevSueloInicial", prevSueloInicial);

	        	result.addProperty("RESULT_1","idEntidad", idEntidad);
	        	
       	 		if (tr.isTraceActive()){
       	 			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getEntidad: saliendo");                
       	 		} 

       	 		return result;

	       }catch(Exception ex){
	    	    result.addProperty("RESULT_1","RESULT","NOOK");
	            java.io.StringWriter sw = new java.io.StringWriter();
	            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	            ex.printStackTrace(pw);
	            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getEntidad: " + sw.getBuffer ().toString());
	            throw new Q02aDAOException(ex);
	       }
       } 

       /** Mtodo que obtiene el hashmap.
        * @return hashMap HashMap
        */
       private HashMap obtenerHashMap() {
           return new HashMap();
       }
       
       /**
        * devuelve el nombre del mes
        * 
        * @param mes mes
        * @return mesTexto
        */
       private String escribeMes (String mes, String idiomaPagina){      
           String mesTexto = "Enero";
           String miIdioma = idiomaPagina;
           if ( "eu".equals(miIdioma) ){
               if ( "1".equals(mes) ){ mesTexto = "Urtarrila"; }
               if ( "2".equals(mes) ){ mesTexto = "Otsaila"; }
               if ( "3".equals(mes) ){ mesTexto = "Martxoa"; }
               if ( "4".equals(mes) ){ mesTexto = "Apirila"; }
               if ( "5".equals(mes) ){ mesTexto = "Maiatza"; }
               if ( "6".equals(mes) ){ mesTexto = "Ekaina"; }
               if ( "7".equals(mes) ){ mesTexto = "Uztaila"; }
               if ( "8".equals(mes) ){ mesTexto = "Abuztua"; }
               if ( "9".equals(mes) ){ mesTexto = "Iraila"; }
               if ( "10".equals(mes) ){ mesTexto = "Urria"; }
               if ( "11".equals(mes) ){ mesTexto = "Azaroa"; }
               if ( "12".equals(mes) ){ mesTexto = "Abendua"; }
           }else{
               if ( "1".equals(mes) ){ mesTexto = "Enero"; }
               if ( "2".equals(mes) ){ mesTexto = "Febrero"; }
               if ( "3".equals(mes) ){ mesTexto = "Marzo"; }
               if ( "4".equals(mes) ){ mesTexto = "Abril"; }
               if ( "5".equals(mes) ){ mesTexto = "Mayo"; }
               if ( "6".equals(mes) ){ mesTexto = "Junio"; }
               if ( "7".equals(mes) ){ mesTexto = "Julio"; }
               if ( "8".equals(mes) ){ mesTexto = "Agosto"; }
               if ( "9".equals(mes) ){ mesTexto = "Septiembre"; }
               if ( "10".equals(mes) ){ mesTexto = "Octubre"; }
               if ( "11".equals(mes) ){ mesTexto = "Noviembre"; }
               if ( "12".equals(mes) ){ mesTexto = "Diciembre"; }
           }
           return mesTexto;
       }
}
