package q02a.exe.arquitectura.valueobjects;

/*
 * Copyright 2001 by IENET, Inc.
 *
 * Private and Confidential
 * Code contained in this document is the property of IENET.
 * It is for the exclusive use of designated employees
 * and not for distribution without prior written
 * authorization.
 */


/**
 * Un ValueObject genrico.
 *
 * Los ValueObject son objetos que se utilizan para el intercambio de informacin
 * entre servlets y EJBs y entre aplicaciones Java y EJBs.
 *
 * @author  Antonio.Vieiro $Author: Miren.diez $
 * @version Alpha 2001-05 $Revision: 1 $ $Version$ $Date: 13/11/07 12:42 $
 */
public class Q02aValueObject implements java.io.Serializable {
    
	private static final long serialVersionUID = 1L;
	
	/*Atributo de clave primaria compuesta:
     * cada clave primaria est separada
     * por el caracter especial de #
     */
	protected String columnaPK;
	
    /** Convierte el objeto en una representacin visual.
     * Este metodo suele ser extremadamente lento, ya que usa Reflection
     * para examinar todos los campos.
     * @return cadena con todos los campos y valor del objeto
     */
    public String toString() {
		//return this.toXMLAsString(false);
		
        // Este StringBuffer almacenar el resultado
        StringBuffer sb = new StringBuffer();
        sb.append( "Contenido del ValueObject de tipo: ")
        .append( this.getClass().getName() )
        .append("\n");
        
        // Obtenemos los mtodos del objeto
        java.lang.reflect.Method [] metodosGet = this.getClass().getMethods();// getDeclaredMethods();
        
        // Los ordenamos por nombre.
        java.util.Arrays.sort( metodosGet, new Q02aValueObjectUtils() );
        
        
        for ( int i=0; metodosGet!= null && i<metodosGet.length; i++ ) {
            if ( metodosGet[i].getName().startsWith("get")
            &&
            ( metodosGet[i].getParameterTypes() == null
            || metodosGet[i].getParameterTypes().length == 0 ) ) {
                sb.append( metodosGet[i].getReturnType().getName() )
                .append( Q02aValueObjectUtils.buildString( 20-metodosGet[i].getReturnType().getName().length() ) )
                .append(" ")
                .append( Q02aValueObjectUtils.buildString( 35-metodosGet[i].getName().length() ) )
                .append( metodosGet[i].getName() )
                .append(" =[");
                
                try {
                    Object value = metodosGet[i].invoke( this, null );
                    sb.append( value ).append("]");
                }
                catch( Exception e ) {
                    sb.append( e.getMessage() );
                }
                sb.append("\n");
            }
        }
        sb.append( "Fin del contenido del ValueObject de tipo: ")
        .append( this.getClass().getName() )
        .append("\n");
        return sb.toString();
		
    }
    
    /**
     * Devuelve un String con la representacin del objeto en formato XML
     * @return String con la representacin del objeto en formato XML. null si hay
     * cualquier error
     */
    public String toXMLAsString(){
		return toXMLAsString(true);
        
    }

	/**
     * Devuelve un String con la representacin del objeto en formato XML
     * @return String con la representacin del objeto en formato XML. null si hay
     * cualquier error
     */
    public String toXMLAsString(boolean incluirCabecera){
        try{
            return q02a.exe.arquitectura.utils.xml.Q02aXMLSerializer.toXMLAsString(this,incluirCabecera);
        }catch(Exception ex){
            ex.printStackTrace();
            return null;
        }
        
    }
    
    /**
     * Devuelve un InputStream con la representacin del objeto en formato XML
     * @return InputStream con la representacin del objeto en formato XML
     */
    public java.io.InputStream toXMLAsInputStream(){
        java.io.ByteArrayOutputStream baos = new java.io.ByteArrayOutputStream();
        java.io.PrintStream ps = new java.io.PrintStream(baos);
        ps.print(toXMLAsString());
        
        return new java.io.ByteArrayInputStream(baos.toByteArray());
    }
    
    /**
     * Carga las propiedades del objeto con los valores obtenidos de un String con formato XML
     * @param xml String con formato XML que contiene informacin sobre las propiedades del objeto
     */
    public void loadFromXML(String xml) throws Exception{
        try{
            q02a.exe.arquitectura.utils.xml.Q02aXMLSerializer.loadFromXML(this,xml);
        }catch(Exception ex){
            throw ex;
        }
    }
    
    /**
     * Carga las propiedades del objeto con los valores obtenidos de un InputStream con formato XML
     * @param xml InputStream con formato XML que contiene informacin sobre las propiedades del objeto
     */
    public void loadFromXML(java.io.InputStream xmlis) throws Exception{
        throw new Exception("Funcin no implementada");
    }
    
    /** Getter for property xmlFormatter.
     * @return Value of property xmlFormatter.
     */
    public Class getXmlFormatter() {
        return q02a.exe.arquitectura.utils.xml.Q02aDefaultXMLFormatter.class;
    }
    
    /**
     * Recupera el atributo de clave primaria compuesta
     * @author julen.maneros
     * @return String columnaPK
     */
    public String getColumnaPK(){
    	return columnaPK;
    }
    
    /**
     * Establece el atributo de clave primaria compuesta
     * @param cPK la clave primaria para este VO
     * @author julen.maneros
     */
    public void setColumnaPK(String cPK){
    	columnaPK = cPK;
    }
    
    /**
     * Recupera el atributo de clave primaria compuesta. Se utiliza para los casos en los que un registro
     * tiene 1 o varios listados asociados.
     * @author julen.maneros
     * @return String columnaPK
     */
    public String getColumnaPKMaster(){
    	return columnaPK;
    }
    
    /**
     * Establece el atributo de clave primaria compuesta. Se utiliza para los casos en los que un registro
     * tiene 1 o varios listados asociados.
     * @param cPK la clave primaria para este VO
     * @author julen.maneros
     */
    public void setColumnaPKMaster(String cPK){
    	columnaPK = cPK;
    }
    
   
    
    /** @link dependency */
    /*#ValueObjectUtils lnkValueObjectUtils;*/

}

