/*
 * XSLHelper.java
 *
 * Created on 22 de mayo de 2003, 10:35
 */

package q02a.exe.arquitectura.utils.xml;


import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;


/**
 * Clase encargada de almacenar los objetos Transformer asociados a los ficheros .xsl ubicados en el directorio
 * cuyo nombre se obtiene del valor de la propiedad xsl.base.dir del grupo ARQ_PATHS.
 * <br>
 * Tambin proporciona mtodos para procesar esos xsl con xml.
 * @author  sergio.navarro
 */
public abstract class Q02aXSLFileManager {
    /**
     * TransformerFactory para ir cargando los transformers.
     */
    protected static javax.xml.transform.TransformerFactory tf = javax.xml.transform.TransformerFactory.newInstance();
    
    /**
     * Mapa con todos los transformer cargados. La clave ser el nombre del fichero xsl (test.xsl)
     */
    protected static java.util.HashMap transformers = new java.util.HashMap();
    
    /**
     * Procesa un xml con un Transformer y devuelve el resultado
     * @param transformer Transformer a procesar 
     * @param xml Objeto Document con el que procesar el Transformer
     * @param parameters Parmetros a pasar al procesador. Puede ser null
     * @return Resultado de procesar el xml y el xsl
     * @throws javax.xml.transform.TransformerException Si se produce algn error.
     */
    public static String processXSL(Transformer transformer,org.w3c.dom.Document xml,Object[][] parameters) throws javax.xml.transform.TransformerException{
        java.io.StringWriter buffer = new java.io.StringWriter();
        
        synchronized(transformer){
	        if(parameters!=null){
	            for(int i=0;i< parameters.length;i++){
	                transformer.setParameter((String)parameters[i][0] , parameters[i][1]);
	            }
	        }
        
	        try{
	            transformer.transform( new DOMSource( xml ) , new StreamResult( buffer ) );
	        }finally{
	            transformer.clearParameters();
	        }
        }
        
        return buffer.getBuffer().toString();
        
    }
    
    /**
     * 
     * @param transformer transformer
     * @param xml xml
     * @param parameters parameters
     * @return processx
     * @throws javax.xml.transform.TransformerException javax.xml.transform.TransformerException
     * @throws UnsupportedEncodingException UnsupportedEncodingException
     */
    public static String processXSL(Transformer transformer,String xml,Object[][] parameters) throws javax.xml.transform.TransformerException, UnsupportedEncodingException{
        return processXSL(transformer,new StreamSource(new ByteArrayInputStream(xml.getBytes("ISO-8859-1"))),parameters);
    }
    /**
     * 
     * @param transformer transformer
     * @param src src
     * @param parameters parameters
     * @return buffer
     * @throws javax.xml.transform.TransformerException javax.xml.transform.TransformerException
     */
    public static String processXSL(Transformer transformer,Source src,Object[][] parameters) throws javax.xml.transform.TransformerException{
        java.io.StringWriter buffer = new java.io.StringWriter();
        
        synchronized(transformer){
            if(parameters!=null){
                for(int i=0;i< parameters.length;i++){
                    transformer.setParameter((String)parameters[i][0] , parameters[i][1]);
                }
            }
        
            try{
                transformer.transform( src , new StreamResult( buffer ) );
            }finally{
                transformer.clearParameters();
            }
        }
        
        return buffer.getBuffer().toString();
        
    }
   
    
    /**
     * Carga un Transformer a partir de un objeto File
     * @param f Objeto file que apuntar a un fichero xsl
     * @return Objeto Transformer
     * @throws TransformerException Si se produce algn error
     */
    public static Transformer loadTransformer(File f) throws TransformerException{
        return tf.newTransformer(new StreamSource( f ));
    }
    
    /**
     * Carga un Transformer a partir de un fichero
     * @param fileName Nombre del fichero xsl
     * @return Objeto Transformer
     * @throws TransformerException Si se produce algn error
     */
    public static Transformer loadTransformer(String fileName) throws TransformerException{
        return tf.newTransformer(new StreamSource( fileName )) ;
    }
    
    /**
     * Carga un Transformer a partir de un fichero
     * @param reader Objeto reader de donde leer el xsl
     * @return Objeto Transformer
     * @throws TransformerException Si se produce algn error
     */
    public static Transformer loadTransformer(Reader reader) throws TransformerException{
        return tf.newTransformer(new StreamSource( reader )) ;
    }
    
    /**
     * Carga un Transformer a partir de un fichero
     * @param is reader Objeto inputStream de donde leer el xsl
     * @return Objeto Transformer
     * @throws TransformerException Si se produce algn error
     */
    public static Transformer loadTransformer(InputStream is) throws TransformerException{
        return tf.newTransformer(new StreamSource( is )) ;
    }

}