/*
 * IPUtils.java
 *
 * Created on 30 de enero de 2002, 10:40
 */

package q02a.exe.arquitectura.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

/**
 *
 * @author  sergio.navarro
 * @version
 */
public abstract class Q02aUtils {
    
    /**
     * Almacena el mapa de traduccin de numrico a alfanumrico. Tambin acta de semforo
     */
    protected static java.util.HashMap idiomaInt2Str = new java.util.HashMap();
    /**
     * Almacena el mada de traduccin de alfanumrico a numrico.
     */
    protected static java.util.HashMap idiomaStr2Int = new java.util.HashMap();
    public static final String DEFAULT_SEPARATORS = ";,";
    protected static boolean caseSensitive = false;

   
    
    
    
    /**
     * Este mtodo devuelve true si la ip pertenece a un rango de ips vlidas
     * @param ip : ip a consultar si pertenece a rangoIPs.
     * @param rangoIPs ipsPermitidas : cadena de ips validas separadas por coma.
     * Returns true si la ip pertenece a rangoIPs, donde rangoIPs puede contener ips que especifiquen
     *      un rango de ips validas del modo: 192.168.197.64-99, lo que significa que las ips desde 192.169.197.64 hasta la
     *      ip 192.168.197.99 son ips validas
     * @return boo
     */
    
    public static final boolean checkIPRange(String ip, String rangoIPs){
        //Si no hay rango, devolvemos true
        if(rangoIPs == null) {return true;}
        
        //Obtenemos los tres primeros nmeros de la ip a chequear
        String prefijo = ip.substring(0,ip.lastIndexOf("."));
        
        java.util.StringTokenizer st = new java.util.StringTokenizer(rangoIPs,",");
        String token = null;
        
        while(st.hasMoreTokens()){
            token = st.nextToken();
            
            int pos = token.indexOf("-");
            if(pos >= 0){//Si es un rango
                //Si Los tres primeros nmeros la ip a chequear coinciden con los del rango...
                if (token.startsWith(prefijo)){
                    String rango = token.substring(token.lastIndexOf(".")+1);
                    pos = rango.indexOf("-");
                    
                    int inferior = Integer.parseInt(rango.substring(0,pos));
                    int superior = Integer.parseInt(rango.substring(pos+1));
                    int valorAChequear = Integer.parseInt(ip.substring(ip.lastIndexOf(".")+1));
                    
                    //Si el ltimo nmero de la ip a chequear est dentro del rango.... true
                    return  ( (valorAChequear>=inferior) && (valorAChequear<=superior) );
                }
            }else{//si no es un rango
            	pos = token.indexOf("*");
            	 if(pos >= 0){//Si es un rango
                    //Si Los tres primeros nmeros la ip a chequear coinciden 
                    if (token.startsWith(prefijo)){
                    	return true;
                    }
            	 }
                if(token.equals(ip)) {return true;}
            }
        }
        
        return false;
        
        
    }//checkUser
    
    /**
     * Devuelve el idioma en formato string, a partir de un String que contiene la representacin numrica del
     * idioma.
     * @param idioma Representacin numrica del idioma
     * @return Representacin alfanumrica del idioma
     */
    public static String getIdiomaAsString(String idioma){
        return getIdiomaAsString(Integer.parseInt(idioma));
    }
    
    /**
     * Devuelve el idioma en formato string, a partir  la representacin numrica del idioma.
     * @param idioma Representacin numrica del idioma
     * @return Representacin alfanumrica del idioma
     */
    public static String getIdiomaAsString(int idioma){
        
        Object aux = Integer.toString(idioma);
        
        synchronized(idiomaInt2Str){
            aux = idiomaInt2Str.get(aux);
        }
        
        
        return (String)aux;
    }
    
    /**
     * Devuelve el idioma en formato numrico, a partir de un String que contiene la representacin alfanumrica del
     * idioma. Si estamos en modo NO caseSensitive, el cdigo alfanumrico se buscar en maysculas...
     * @param idioma Representacin alfanumrica del idioma
     * @return Representacin numrica del idioma
     */
    
    public static int getIdiomaAsInteger(String idioma){
        Object aux = Q02aUtils.caseSensitive ? idioma : idioma.toUpperCase();
        
        synchronized(idiomaInt2Str){
            aux = idiomaStr2Int.get(aux);
        }
        
        return Integer.parseInt( (String)aux );
        
    }
    /**
     * 
     * @param s s
     * @return s
     */
    public static String rtrim(String s) {
     if (s!=null) {   
      while (s.endsWith(" ")) {
        s = s.substring(0, s.length()-1);
      }
     }
      return s;
    }
    
    
    /**
     * Aade espacios por la derecha al String s hasta que tenga el tamao len
     * @param s String al que aadir los espacios
     * @param len Tamao final del String
     * @return String resultante
     */
    public static String addSpaces(String s,int len) {
        if (s!=null) {
          while (s.length()<len) {
            s = s + " ";
          }
        }
      return s;
    }
    
    /** Parsea un string de tipo A=B;C=D;E=F , devolviendo un array de tipo:
     * { {"A","B"} , {"C","D"} , {"E","F"}}
     * <p>
     * El string a parsear representa una serie de propiedades, separadas por , ;  :
     * @param property String con las propiedades con el formato: A=B[SEPARADOR]C=D[SEPARADOR]E=F
     * @return Array de Strings de dos dimensiones con las propiedades parseadas
     */    
    public static String[][] parseOneLinePropertyString(String property){
        return parseOneLinePropertyString(property,null);
    }
    
    
    /** Parsea un string de tipo A=B;C=D;E=F , devolviendo un array de tipo:
     * { {"A","B"} , {"C","D"} , {"E","F"}}
     * <p>
     * El string a parsear representa una serie de propiedades, separadas por una serie
     * de separadores
     * @param property String con las propiedades con el formato: A=B[SEPARADOR]C=D[SEPARADOR]E=F
     * @param separators String con los separadores. Por defecto es ";.:"
     * @return Array de Strings de dos dimensiones con las propiedades parseadas
     */    
    public static String[][] parseOneLinePropertyString(String property,String separators){
    	
    	if (property==null || property.equals("")){
    		return new String[][]{};
        }
        StringTokenizer st = new StringTokenizer(property, (separators==null ? DEFAULT_SEPARATORS : separators) );
        String token = null;
        String[][] res = new String[st.countTokens()][2];        
        int pos = 0;
        int index = 0;
        
        while(st.hasMoreTokens()){
            token = st.nextToken().trim();
            pos = token.indexOf("=");
            
            if(pos+1==token.length()){//Si no hay nada a la derecha del igual....
                res[index][0]=token;
                res[index][1]="";
            }else{
                res[index][0]=token.substring(0,pos);
                res[index][1]=token.substring(pos+1);
            }
            
            index++;

        }        
        return res;
    }
    /**
     * 
     * @param property property
     * @return property
     */
    public static java.util.Map parseOneLinePropertyStringToMap(String property){
        return parseOneLinePropertyStringToMap(property,DEFAULT_SEPARATORS);
    }
    
    /**
     * 
     * @param property property
     * @param separators separators
     * @return property
     */
    public static java.util.Map parseOneLinePropertyStringToMap(String property,String separators){
    	if (property==null || property.equals("")){
    		return new HashMap();
        }
        String[][] data = parseOneLinePropertyString(property,separators);
        java.util.HashMap map = new java.util.HashMap();
        
        for(int i=0;i<data.length;i++){
            map.put(data[i][0],data[i][1]);
        }
        
        return map;
    }
    /**
     * Devuelve un String con el contenido de un map en el formato clave=valor;clave=valor
     * @param map Mapa a parsear
     * @param separator Separador de propiedades a utilizar.
     * @return String con los datos del mapa
     */
    public static final String mapToOneLinePropertyString(Map map,String separator){
        Object[] keys = map.keySet().toArray();
        
        StringBuffer res = new StringBuffer();
        
        for (int i = 0; i < keys.length; i++) {
            if(i>0) {res.append(separator);}
            res.append(keys[i].toString()).append("=").append(map.get(keys[i]));
        }
        
        return res.toString();
    }
    
    /**
     * Separa el string s en strings segn el separador separator, y los devuelve en un array.
     * @param s String a procesar
     * @param separator Separador
     * @return Array de Strings procesados. Null si el separador es null o ""
     */
    public static final String[] split(String s , String separator){
        if(separator==null || separator.length()==0) {return null;}
        
        int pos = 0;
        int pos2 = 0;
        int max = s.length();
        int seplen = separator.length();
        
        ArrayList res = new ArrayList();
        
        while(pos2<=max){
            if(pos2==max){
                res.add("");
                break;
            }
            
            pos = s.indexOf(separator,pos2);
            if(pos>=0){
                res.add(s.substring(pos2,pos));
                pos2 = pos+seplen;
            }else{
                res.add(s.substring(pos2));
                break;
            }
        }
        
        return (String[])res.toArray(new String[res.size()]);
    }
    
}
