set time on;

set echo on;

set feedback 1;

spool /aplic/q02a/scripts/000_Q022EV02_75352.lst;

SELECT TO_CHAR(SYSDATE,'DD-MM-YYYY:HH24:MI:SS') || 'INI 000_Q022EV02_75352' from dual;
 
WHENEVER SQLERROR EXIT SQL.SQLCODE;

CREATE OR REPLACE VIEW q02a.q022ev02
(
    q022ct00_id_grupo
  , mun_prov
  , mun_muni
  , q022ct00_ano
  , q22ct00_mes
  , q022et00_id_cues
  , q022et00_clasu
  , q022et00_supsu
  , q022et00_supte
  , q022et00_valsu
  , q022et00_nvpog
  , q022et00_nvpoe
  , q022et00_nvtmg
  , q022et00_nvtme
  , q022et00_nalod
  , q022et00_nreal
  , q022et00_nvtot
  , q022et00_fec_alta
  , q022et00_fec_mod
  , q022et00_fec_baja
  , q022et00_firmado
  , q022et00_cdexp
  , q022et00_nvpot
  , q022et00_nlibre
  , q022et00_obssu
  , q022et00_fadq
  , q022et00_enti
  , q022et00_tvia
  , q022et00_calle
  , q022et00_por_cl_por
  , q022et00_bloq
  , q022et00_nume
  , q022et00_bis
  , q022et00_cdir
  , q022et00_tipadq
  , q022et00_nora_t17_localizacion
  , q022et00_dir_nueva
  , q022et00_fuera_plazo 
  , q022et00_usu_alta
  , q022et00_usu_modif 
)
AS
select
  Q022CS00.Q022CT00_ID_GRUPO   ,
   MUN_PROV,
  MUN_MUNI,
  Q022CT00_ANO,
  Q22CT00_MES        ,
  Q022ET00_ID_CUES    ,
  Q022ET00_CLASU      ,
  Q022ET00_SUPSU      ,
  Q022ET00_SUPTE      ,
  Q022ET00_VALSU      ,
  Q022ET00_NVPOG      ,
  Q022ET00_NVPOE      ,
  Q022ET00_NVTMG      ,
  Q022ET00_NVTME      ,
  Q022ET00_NALOD      ,
  Q022ET00_NREAL      ,
  Q022ET00_NVTOT      ,
  Q022ET00_FEC_ALTA   ,
  Q022ET00_FEC_MOD    ,
  Q022ET00_FEC_BAJA   ,
  Q022ET00_FIRMADO    ,
  Q022ET00_CDEXP      ,
  Q022ET00_NVPOT      ,
  Q022ET00_NLIBRE     ,
  Q022ET00_OBSSU      ,
  Q022ET00_FADQ       ,
  Q022ET00_ENTI       ,
  Q022ET00_TVIA       ,
  Q022ET00_CALLE      ,
  Q022ET00_POR_CL_POR ,
  Q022ET00_BLOQ       ,
  Q022ET00_NUME       ,
  Q022ET00_BIS        ,
  Q022ET00_CDIR       ,
  Q022ET00_TIPADQ ,
  CASE WHEN ( TRIM(Q022ET00_CALLE) = 0 OR TRIM(Q022ET00_CALLE) = '' OR TRIM(Q022ET00_CALLE) IS NULL) THEN NORA_T17_LOCALIDAD.DS_O
       ELSE NORA_T17_LOCALIDAD.DS_O  || DECODE(NORA_T17_LOCALIDAD.DS_O,'','',', ')  || NORA_T17_CALLE.DS_O || ' ' ||  DECODE ( Q022ET00_BLOQ, '0' , '',  Q022ET00_BLOQ)  || ' '  || DECODE ( Q022ET00_NUME, '0' , '',  Q022ET00_NUME) || ' '||  DECODE( Q022ET00_BIS, '0','',Q022ET00_BIS)
  END DIRECCION,
  Q022ET00_DIR_NUEVA,
  Q022ET00_FUERA_PLAZO, 
  Q022ET00_USU_ALTA, 
  Q022ET00_USU_MODIF
from Q022CS00 ,Q022ES00, NORA_T17_LOCALIDAD,NORA_T17_CALLE
where
Q022CS00.Q022CT00_ID_GRUPO=Q022ES00.Q022CT00_ID_GRUPO and
Q022ES00.Q022ET00_ENTI=NORA_T17_LOCALIDAD.ID(+)   and
Q022ES00.Q022ET00_CALLE=NORA_T17_CALLE.ID(+);

commit;
SELECT TO_CHAR(SYSDATE,'DD-MM-YYYY:HH24:MI:SS')  ||  'FIN 000_Q022EV02_75352' from dual;

spool off;
set echo off;

exit;