/**

 * Clase que encapsula el protocolo utilizado para enviar/recibir datos del servidor. 

 * Bsicamente, se pueden establacer propiedades, agrupadas en grupos.

 * @constructor

 */

function ARQ_GDTP(){

    /** Mapa con clave=nombre de grupo y valor=Mapa con las propiedades correspondientes a ese grupo*/

    this.groupsProperties = new Array();

    /** Mapa con clave=nombre de grupo y valor=List con los nombres de las propiedades correspondientes a ese grupo*/

    this.groupsKeyList = new Array();

    /** List con los nombres de los grupos.*/

    this.groups = new Array();

}



/******************/

/*** PROPIEDADES***/

/******************/

ARQ_GDTP.prototype.groupsProperties = null;

ARQ_GDTP.prototype.groupsKeyList = null;

ARQ_GDTP.prototype.groups = null;



/*******************************/

/*** DEFINICION DE FUNCIONES ***/

/*******************************/

ARQ_GDTP.prototype.addProperty=ARQ_GDTP_addProperty;

ARQ_GDTP.prototype.addGroup=ARQ_GDTP_addGroup;

ARQ_GDTP.prototype.getProperty=ARQ_GDTP_getProperty;

ARQ_GDTP.prototype.serialize=ARQ_GDTP_serialize;

ARQ_GDTP.prototype.parse=ARQ_GDTP_parse;

ARQ_GDTP.prototype.getGroupProperties=ARQ_GDTP_getGroupProperties;

ARQ_GDTP.prototype.getGDH=ARQ_GDTP_getGDH;

ARQ_GDTP.prototype.copyData = ARQ_GDTP_copyData;

ARQ_GDTP.prototype.containsGroup=function(group){return (this.groupsKeyList[group]!=undefined);};

ARQ_GDTP.prototype.merge = PRV_GDTP_merge;

ARQ_GDTP.prototype.toGDH = ARQ_GDTP_getGDH;

ARQ_GDTP.prototype.PRV_freeResources=function(){

	freeArray(this.groupsProperties);

	this.groupsProperties=null;



	freeArray(this.groupsKeyList);

	this.groupsKeyList=null;



	freeArray(this.groups,true);

}



/***********************************/

/*** IMPLEMENTACION DE FUNCIONES ***/

/***********************************/

/**

 * Escapa un String

 * @param s <i>String</i> String a escapar

 * @return <i>String</i> String escapado

 */

ARQ_GDTP.escape=function(s){

	return escape(s).replace(/[+]/gi,"%2B");

}



/**

 * Desescapa un String

 * @param s <i>String</i> String a desescapar

 * @return <i>String</i> String desescapado

 */

ARQ_GDTP.unescape=function(s){

	return unescape(s.replace(/%2B/gi,"+"));

}



/**

 * Funcin de uso interno que devuelve un String con un carcter, cuyo cdigo ascii se pasa como parmetro

 * @param chr <i>String</i> String con el cdigo ascii, por ejemplo: "\x02"

 * @private

 */

function ARQ_getControlChar(chr){

	var str = "a";

	var reg = new RegExp("[a]","gi");



	str = str.replace("a",chr);



	return str;

}



/** Separador de propiedades de un grupo*/

var ARQ_GDTP_PROPERTY_SEPARATOR = ARQ_getControlChar("\x02");// Antes era "&";

/** Separador de grupos.*/

var ARQ_GDTP_PROPERTY_GROUPS_SEPARATOR=ARQ_getControlChar("\x03");//Antes era "?";

/** Separador de clave/valor */

var ARQ_GDTP_PROPERTY_VALUE_SEPARATOR = ARQ_getControlChar("\x04");//Antes era "=";



/**

 * Devuelve un objeto de tipo GenericDatandler con todos los datos 

 * @param separator <i>String</i> (Opcional) Separador para el GenericDataHandler

 * @return <i>ARQ_GDH</i> Objeto de tipo GenericDatandler con todos los datos 

 */

function ARQ_GDTP_getGDH(separator,sGroup){

	var gdh = new GenericDataHandler();



	var group = null;

	var keys = null;

	var data = null;

	var key = null;

	

	for(var i=0;i<this.groups.length;i++){

		group = this.groups[i];

		keys = this.groupsKeyList[group];

		data = this.groupsProperties[group];

		

		for(var j=0;j<keys.length;j++){

			key = keys[j];

			( sGroup?gdh.setData(data[key],sGroup+separator+key,separator):gdh.setData(data[key],key,separator) )

		}

	}

	

	return gdh;

}



/**

 * Devuelve un array con las propiedades asociadas a un grupo

 * @param group <i>String</i> Grupo

 * @return <i>Array</i> Array con las propiedades asociadas al grupo group

 */

function ARQ_GDTP_getGroupProperties(group){

	try{

		return this.groupsProperties[group];

	}catch(e){

		return undefined;

	}

}



/**

 * Aade un grupo a la lista de grupos

 * @param group <i>String</i> Nuevo grupo a aadir

 */

function ARQ_GDTP_addGroup(group){

	if(this.groupsKeyList[group]==undefined){

		this.groups.push(group);

		this.groupsKeyList[group]=new Array();

		this.groupsProperties[group]=new Array();

	}

}



/**

 * Aade una propiedad a un grupo

 * @param group <i>String</i> Grupo

 * @param key <i>String</i> Nombre de la propiedad

 * @param value <i>String</i> Valor de la propiedad

 */

function ARQ_GDTP_addProperty(group,key,value){

	//this.addGroup(group);



	this.groupsKeyList[group].push(key);

	this.groupsProperties[group][key]=value;

}



/**

 * Devuelve el valor asociado a una propiedad dentro de un grupo

 * @param group <i>String</i> Grupo

 * @param key <i>String</i> Nombre de la propiedad

 * @return <i>String</i> Valor de la propiedad dentro de grupo

 */

function ARQ_GDTP_getProperty(group,key){

	try{

		return this.groupsProperties[group][key];

	}catch(e){

		return undefined;

	}

}



/**

 * Serializa los datos del objeto con el siguiente formato:

 * GDTP_DATA_id=escape([GS][GRUPO]([PS][PROP][PVS][VAL])*)*

 * @return <i>String</i> datos del objeto serializado

 */ 

function ARQ_GDTP_serialize(id,bWithoutSerialize){

	if(id==undefined) id="1";

	var res = new String();

        

	var group = null;

	var keys = null;

	var data = null;

	var key = null;

	

	for(var i=0;i<this.groups.length;i++){

		group = this.groups[i];

		keys = this.groupsKeyList[group];

		data = this.groupsProperties[group];

		

		res = res + ARQ_GDTP_PROPERTY_GROUPS_SEPARATOR;

		res = res + group;

		

		for(var j=0;j<keys.length;j++){

			res = res + ARQ_GDTP_PROPERTY_SEPARATOR;

			

			key = keys[j];

			res = res + key+ ARQ_GDTP_PROPERTY_VALUE_SEPARATOR + data[key];

		}

	}

	

	//return "GDTP_DATA_"+id+"=" + ARQ_GDTP.escape(res);

	return "GDTP_DATA_"+id+"=" + ( !bWithoutSerialize?ARQ_GDTP.escape(res):res );

}





/**

 * Copia los datos de otro gdtp a este. Se utiliza cuando tenemos un objeto gdtp de otra ventana ya cerrada, ya que

 * no podemos utilizar sus mtodos.

 * @param gdtp <i>ARQ_GDTP</i> Gdtp de donde obtener los datos

 */

function ARQ_GDTP_copyData(gdtp){

    this.groupsProperties = gdtp.groupsProperties;

    this.groupsKeyList = gdtp.groupsKeyList;

    this.groups = gdtp.groups;

}



/**

 * Parsea un String con datos en el formato GDTP_DATA=escape([GS][GRUPO]([PS][PROP][PVS][VAL])*)* y rellena

 * el objeto

 * @param s <i>String</i> String a parsear

 */

function ARQ_GDTP_parse(s){



	var pos = s.indexOf("GDTP_DATA=");

	if(pos>=0){

		s = ARQ_GDTP.unescape(s.substring(pos+10));

	}



	var groupArray = s.split(ARQ_GDTP_PROPERTY_GROUPS_SEPARATOR);

	var propertyArray = null;

	var group = null;

	var key = null;

	var value = null;

	var pair=null;

	var aux = null;



	var l=null;

	var m=null;





	for(var i=0;i<groupArray.length;i++){

		aux = groupArray[i];

		if(aux.length==0) continue;



		propertyArray=aux.split(ARQ_GDTP_PROPERTY_SEPARATOR);

		group = propertyArray[0];

		this.addGroup(group);



		l = this.groupsKeyList[group];//Lista de keys del grupo

		m = this.groupsProperties[group];//Datos del grupo



		for(var j=1;j<propertyArray.length;j++){

			pair = propertyArray[j].split(ARQ_GDTP_PROPERTY_VALUE_SEPARATOR);

			//this.addProperty(group,unescape(pair[0]),unescape(pair[1]));

			key = pair[0];

			value = pair[1];



			this.groupsKeyList[group].push(key);

			this.groupsProperties[group][key]=value;

		}



	}





}

/**

 * Funcin que une dos GDTP en uno nico

 * @param gdtp <i>GDTP</i> gdtp a copiar en el que le llama

 */

function PRV_GDTP_merge(gdtp){

	var group = null;

	var keys = null;

	var data = null;

	var key = null;

	for (var i=0; i<gdtp.groups.length; i++){

		group = gdtp.groups[i];

		keys = gdtp.groupsKeyList[group];

		data = gdtp.groupsProperties[group];

		for(var j=0;j<keys.length;j++){

			key = keys[j];

			if (!this.containsGroup(group)){

				this.addGroup(group);

			}

			this.addProperty(group,key,data[key]);

		}

	}

}

