/**

* FrmkIframe.js

*

* Descripcion: pinta un Iframe para hacer submit sin refresco de pantalla

*/



function FrmkIframe(ifrName)

{

	this.name = ifrName;

	this.htmlCode = '<iframe id="'+this.name+'" name="'+this.name+'" src="" style="width:300;height:300;marginWidth:0;marginHeight:0;position:absolute;frameBorder:0;visibility:hidden;"></iframe>';	

	this.obj = this.createObj();	

}





/** Inicializa la clase. Aade un nuevo objeto 'iframe' al documento */

FrmkIframe.prototype.createObj = function()

{

  	document.write( this.htmlCode );

  	

  	var container = null;

  	if (is.NS) {

  		container = document.layers[this.name];

  	} else if(is.IE) {

      	 container = window.frames(this.name); 		 

    } else { //is.MOZ

		 container = document.getElementById(this.name);	 

 	}    	  	

	return container;

}



/**	Aade y Submita un nuevo formulario interior al iframe */

FrmkIframe.prototype.doSubmit = function(formUrl)

{

	var nF = new FrmkForm(formUrl);

	this.appendHtml(nF.htmlCode);

	

	var f = this.getIframeForm(nF.name);

	f.submit();

}





/** Aade un objeto al iframe */

FrmkIframe.prototype.appendHtml = function(htmlCode)

{

	var docu=null;

	if (is.NS4) {

		docu=eval("window.document.layers['"+this.name+"'].document");

	} else if (is.IE4 || is.IE5) {

		docu=eval("window.document.all('"+this.name+"').document");

	} else if (is.NS6) {

		docu=this.obj.contentDocument;

	} else if (is.MOZ) {

		docu=document.getElementById(this.name).contentDocument;

	} else {

		docu=this.obj.document;

	}

	docu.open();

	docu.write(htmlCode);

	docu.close();

}





/** Devuelve el formulario incluido en el iframe */

FrmkIframe.prototype.getIframeForm = function(formName)

{

	var fObj = null;

	if (is.NS4){

		fObj = document.layers(this.name).document.forms(formName);

	}else if (is.IE4 || is.IE5){

		fObj = document.all(this.name).document.forms(formName);

	}else if (is.NS6){

		fObj = this.obj.contentDocument.getElementById(formName);

	} else if (is.MOZ) {

		fObj =document.getElementById(this.name).contentDocument.forms[formName];

	} else {  //is.IE6

		fObj = this.obj.document.getElementById(formName);

	}

	return fObj;

}





/** Realiza una llama a la url en modo get */

FrmkIframe.prototype.doRedirect = function(url)

{

	if (is.NS4)	{

		document.layers(this.name).src = url;

	} else if (is.IE4 || is.IE5) { 

		window.frames(this.name).document.location.replace(url);		

	} else if (is.NS6) {

		this.obj.contentDocument.location.replace(url);

	} else {  //is.IE6

		this.obj.document.location.replace(url);

	}

}