package q02b.usuarios.operacionesinternas;



import java.util.ArrayList;

import java.util.HashMap;



import q02b.exe.comun.valueobjects.Q02bCodigoValor;

import q02b.exe.operacioninterna.Q02bOperacionInterna;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;

import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaConfigBean;

import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;

import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;



public class Q02bOITratarListasConsultaUsuario extends Q02bOperacionInterna {

	

	private static Q70Traza tr = Q70Traza.getSingleton();

	protected static final String COMPONENTE = "OPERACION_INTERNA";

	

	protected void preProcessMappingEntrada(Q70ContextoEJIE contexto,Q70OperacionInternaConfigBean configuracion,

			Q70OperacionInternaErrors errores)

			throws Exception {

		

		try{

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":preProcessMappingEntrada: entrando");

			}

			contexto.set("listaGruposSeleccionados",new String[0]);

			contexto.set("listaGruposAsignados",new Q02bCodigoValor[0]);

			contexto.set("listaGrupos",new Q02bCodigoValor[0]);

			contexto.set("listaMunicipiosSeleccionados",new String[0]);

			contexto.set("listaMunicipiosAsignados",new Q02bCodigoValor[0]);

						

			

			

		}catch(Exception ex){

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":preProcessMappingEntrada: " + sw.getBuffer ().toString());

	        throw ex;

		}finally {

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":preProcessMappingEntrada: saliendo.");

			}

		}

	}

	

	protected void postProcessMappingSalida(Q70ContextoEJIE contexto, Q70OperacionInternaErrors errores)

		throws Exception {

		try{

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":postProcessMappingSalida: entrando");

			}

			Q02bCodigoValor[] listaGruposAsignados = new Q02bCodigoValor[0];

			Q02bCodigoValor[] listaGrupos = new Q02bCodigoValor[0];

			Q02bCodigoValor[] listaMunicipiosAsignados = new Q02bCodigoValor[0];

			Q02bCodigoValor[] listaMunicipios = new Q02bCodigoValor[0];

			

			HashMap mapaUsuario = (HashMap)contexto.get("usuario");

			

			ArrayList listaGruposSeleccionados = (ArrayList)mapaUsuario.get("listaGruposSeleccionados");

			ArrayList listaGruposNoSeleccionados = (ArrayList)mapaUsuario.get("listaGrupos");

						

			if (null!=listaGruposSeleccionados && listaGruposSeleccionados.size()>0){

				listaGruposAsignados = (Q02bCodigoValor[])listaGruposSeleccionados.toArray(new Q02bCodigoValor[listaGruposSeleccionados.size()]);

			}

			if (null!=listaGruposNoSeleccionados && listaGruposNoSeleccionados.size()>0){

				listaGrupos = (Q02bCodigoValor[])listaGruposNoSeleccionados.toArray(new Q02bCodigoValor[listaGruposNoSeleccionados.size()]);

			}

			

			contexto.set("listaGruposAsignados",listaGruposAsignados);

			contexto.set("listaGrupos",listaGrupos);

			

			ArrayList listaMunicipiosSeleccionados = (ArrayList)mapaUsuario.get("listaMunicipiosSeleccionados");

			ArrayList listaMunicipiosNoSeleccionados = (ArrayList)mapaUsuario.get("listaMunicipios");

						

			if (null!=listaMunicipiosSeleccionados && listaMunicipiosSeleccionados.size()>0){

				listaMunicipiosAsignados = (Q02bCodigoValor[])listaMunicipiosSeleccionados.toArray(new Q02bCodigoValor[listaMunicipiosSeleccionados.size()]);

			}

			if (null!=listaMunicipiosNoSeleccionados && listaMunicipiosNoSeleccionados.size()>0){

				listaMunicipios = (Q02bCodigoValor[])listaMunicipiosNoSeleccionados.toArray(new Q02bCodigoValor[listaMunicipiosNoSeleccionados.size()]);

			}

			contexto.set("listaMunicipiosAsignados",listaMunicipiosAsignados);

			contexto.set("listaMunicipiosNoAsignados",listaMunicipios);

			

		}catch(Exception ex){

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":postProcessMappingSalida: " + sw.getBuffer ().toString());

	        throw ex;

		}finally {

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":postProcessMappingSalida: saliendo.");

			}

		}

	}

}