package q02b.roles.operacionesinternas;



import java.util.ArrayList;

import java.util.HashMap;



import q02b.exe.comun.valueobjects.Q02bCodigoValor;

import q02b.exe.operacioninterna.Q02bOperacionInterna;



import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;

import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaConfigBean;

import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;

import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;



public class Q02bOITratarListasConsultaRol extends Q02bOperacionInterna {

	

	private static Q70Traza tr = Q70Traza.getSingleton();

	protected static final String COMPONENTE = "OPERACION_INTERNA";

	

	protected void preProcessMappingEntrada(Q70ContextoEJIE contexto,Q70OperacionInternaConfigBean configuracion,

			Q70OperacionInternaErrors errores)

			throws Exception {

		

		try{

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":preProcessMappingEntrada: entrando");

			}

			contexto.set("listaGruposSeleccionados",new String[0]);

			contexto.set("listaGruposAsignados",new Q02bCodigoValor[0]);

			contexto.set("listaGrupos",new String[0]);

			contexto.set("listaProcesosSeleccionados", new String[0]);

			contexto.set("listaProcesosAsignados",new Q02bCodigoValor[0]);

			contexto.set("listaProcesos",new String[0]);

			

		}catch(Exception ex){

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":preProcessMappingEntrada: " + sw.getBuffer ().toString());

	        throw ex;

		}finally {

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":preProcessMappingEntrada: saliendo.");

			}

		}

	}

	

	protected void postProcessMappingSalida(Q70ContextoEJIE contexto, Q70OperacionInternaErrors errores)

		throws Exception {

		try{

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":postProcessMappingSalida: entrando");

			}

			Q02bCodigoValor[] listaGruposAsignados = new Q02bCodigoValor[0];

			Q02bCodigoValor[] listaGruposNoAsignados = new Q02bCodigoValor[0];

			Q02bCodigoValor[] listaProcesosAsignados = new Q02bCodigoValor[0];

			

			HashMap mapaRol = (HashMap)contexto.get("rol");

			

			ArrayList listaGruposSeleccionados = (ArrayList)mapaRol.get("listaGruposSeleccionados");

			ArrayList listaGruposNoSeleccionados = (ArrayList)mapaRol.get("listaGrupos");

			ArrayList listaProcesosSeleccionados = (ArrayList)mapaRol.get("listaProcesosSeleccionados");

			

			if (null!=listaGruposSeleccionados && listaGruposSeleccionados.size()>0){

				listaGruposAsignados = (Q02bCodigoValor[])listaGruposSeleccionados.toArray(new Q02bCodigoValor[listaGruposSeleccionados.size()]);

			}

			if (null!=listaGruposNoSeleccionados && listaGruposNoSeleccionados.size()>0){

				listaGruposNoAsignados = (Q02bCodigoValor[])listaGruposNoSeleccionados.toArray(new Q02bCodigoValor[listaGruposNoSeleccionados.size()]);

			}

			if (null!=listaProcesosSeleccionados && listaProcesosSeleccionados.size()>0){

				listaProcesosAsignados = (Q02bCodigoValor[])listaProcesosSeleccionados.toArray(new Q02bCodigoValor[listaProcesosSeleccionados.size()]);

			}

			

			contexto.set("listaGruposAsignados",listaGruposAsignados);

			contexto.set("listaGruposNoAsignados",listaGruposNoAsignados);

			contexto.set("listaProcesosAsignados",listaProcesosAsignados);

			

			

		}catch(Exception ex){

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":postProcessMappingSalida: " + sw.getBuffer ().toString());

	        throw ex;

		}finally {

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":postProcessMappingSalida: saliendo.");

			}

		}

	}

}