package q02b.procesos.operacionesinternas;





import java.util.ArrayList;

import java.util.HashMap;



import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;

import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaConfigBean;

import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;

import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

import q02b.exe.operacioninterna.Q02bOperacionInterna;

import q02b.exe.utils.Q02bConstantes;





public class Q02bOITratarListasModificacionProceso extends Q02bOperacionInterna {

	

	private static Q70Traza tr = Q70Traza.getSingleton();

	protected static final String COMPONENTE = "OPERACION_INTERNA";

	

	

	protected void preProcessMappingEntrada(Q70ContextoEJIE contexto,Q70OperacionInternaConfigBean configuracion,

			Q70OperacionInternaErrors errores)

			throws Exception {

		

		try{

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":preProcessMappingEntrada: entrando");

			}

			HashMap mapaProceso = (HashMap)contexto.get("proceso");			

			

			String[] rolesSeleccionados= (String[])contexto.get("listaRolesSeleccionados");

			ArrayList listaRolesSeleccionados = new ArrayList();

			for(int i=0; i<rolesSeleccionados.length; i++){

				String[] codigoValor =((String) rolesSeleccionados[i]).split(Q02bConstantes.SEPARADOR_PK);

				listaRolesSeleccionados.add(codigoValor[0]);

			}

		

			mapaProceso.put("listaRolesSeleccionados",listaRolesSeleccionados);

		

			contexto.set("proceso",mapaProceso);

			

		}catch(Exception ex){

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":preProcessMappingEntrada: " + sw.getBuffer ().toString());

	        throw ex;

		}finally {

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":preProcessMappingEntrada: saliendo.");

			}

		}

	}

}