package q02b.oficinasMunicipales.router;








//Import de Geremua


import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.infraestructura.traza.Q70Traza;
import es.ejie.frmk.presentacion.operacion.Q70DefaultRouterClass;


import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;





// import de Struts


import org.apache.struts.action.ActionErrors;


import org.apache.struts.action.ActionForward;


import org.apache.struts.action.ActionMapping;





// import del mantenimiento


import q02b.exe.oficinasMunicipales.valueobjects.Q02bOficinasMunicipales;





import q02b.exe.utils.Q02bVoUtils;





// Import de Java


import java.util.ArrayList;


import java.util.HashMap;








public class Q02bRouterFiltrarOficinasMunicipales extends Q70DefaultRouterClass {


    //Declaraci?n de los mappings


    final static String MAPPING_CONSULTA = "irConsultaOficinaMunicipal";


    final static String MAPPING_LISTA = "irListaOficinasMunicipales";


    final static String MAPPING_ERROR = "error";





    //Declaraci?n de las variables que no se modificar?n


    final static String VARIABLE_LISTA = "listaOficinasMunicipales";


    final static String VARIABLE_HASHMAP = "oficinaMunicipal";


    final static String VARIABLE_PK = "columnaPK";


    
    private static Q70Traza tr = Q70Traza.getSingleton();
    private static final String COMPONENTE = "ROUTER OFICINAS MUNICIPALES";
    
    

    /**


     * @see es.ejie.frmk.presentacion.operacion.paso.ActionPasoOP#processForward(es.ejie.frmk.presentacion.sesiondatos.ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)


    */


    public ActionForward processForward(Q70ContextoEJIE contexto,


        ActionErrors errores, ActionMapping mapping) throws Exception {


        //Variable del mapping de salida


        ActionForward salida = new ActionForward();





        //Value Object del objeto lista


        Q02bOficinasMunicipales vo = new Q02bOficinasMunicipales();





        //Mapa con los valores del VO


        HashMap mapa = new HashMap();





        //Variable donde se almacena el listado recuperado del contexto


        ArrayList lista = (ArrayList) contexto.get(VARIABLE_LISTA);


        if (tr.isTraceActive()){
			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":ROUTER con lista = "+lista.toString());
		}


        //Si la lista se ha recibido correctamente y tiene datos se entra


        if ((lista != null) && (lista.size() > 0) && errores.isEmpty()) {


            //Si s?lo tiene un elemento se dirige a la consulta


            if (lista.size() == 1) {


                //obtener los datos del mantenimiento


                vo = (Q02bOficinasMunicipales) lista.get(0);
                
                if (tr.isTraceActive()){
        			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":estoy con vo.getIdMunicipio() = "+vo.getIdMunicipio()+" o vo.getDenomMunicipio()"+vo.getDenomMunicipio());
        		}


                mapa = Q02bVoUtils.getHashMap(vo);


                contexto.set(VARIABLE_HASHMAP, mapa);


                contexto.set(VARIABLE_PK, vo.getColumnaPK());


                salida = mapping.findForward(MAPPING_CONSULTA);


            } else {


                salida = mapping.findForward(MAPPING_LISTA);


            }


        } else {


            //caso de demasiados resultados: lista no nula, pero de tam 0 y sin error. 


            salida = mapping.findForward(MAPPING_ERROR);


        }





        return salida;


    }


}


