package q02b.informes.action;



import javax.servlet.ServletOutputStream;

import javax.servlet.http.HttpServletRequest;

import javax.servlet.http.HttpServletResponse;



import org.apache.struts.action.ActionErrors;

import org.apache.struts.action.ActionForm;

import org.apache.struts.action.ActionForward;

import org.apache.struts.action.ActionMapping;



import q02b.exe.comun.Q02bAutenticador;

import q02b.exe.reports.beans.Q02bInformesBean;



import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;

import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;

import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;





public class Q02bActionDescargarInformes extends Q70ActionPasoOP {	

	

	private static Q70Traza tr = Q70Traza.getSingleton();

    private static final String PROCESS_OP			= ":processOP:";

	private static final String PROCESS_FORWARD		= ":processForward:";

	private static final String COMPONENTE			= "OPERACION_PRESENTACION";	

	//Listas del contexto

	final static String LISTA_INFORMES				= "listaInformes";

	

	//Variables a utilizar

	final static String	ADITIONAL					= "aditional";

	final static String	COD_INFORME					= "codInforme";

	final static String	PREFIJO						= "prefijo";

	

	//Declaracion de mappings

	final static String MAPPING   					= "irListadoInformes";

	

	/**

	 * @see es.ejie.frmk.presentacion.operacion.paso.Q70ActionOI#processOI(es.ejie.frmk.presentacion.sesiondatos.ContextoEJIE, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)

	 */

	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores,ActionMapping mapping,ActionForm form,

			HttpServletRequest request,HttpServletResponse response) throws Exception {	

		try{

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + PROCESS_OP + " entrando");

			}	

				Q02bInformesBean infBean = new Q02bInformesBean();

				Q02bAutenticador aut = new Q02bAutenticador();

			   

			    aut.setIdioma((String)contexto.get("idioma"));

			    aut.setUser((String)contexto.get("user"));

			    infBean.setAutenticador(aut);  

			  

			    String codInf 	= (String)contexto.get(COD_INFORME);

			    String addWhere = (String)contexto.get(ADITIONAL);

				

			    response.setContentType("text/plain");

			    response.setHeader("Content-Disposition", "attachment; filename=descargacuestionario.txt" );

				

				ServletOutputStream outStream = response.getOutputStream();

				

				String texto= infBean.generarInformeTexto(codInf,addWhere);

				//String texto = miByteArray.toString("ISO-8859-1");

				outStream.println(texto);

				

		}catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + PROCESS_OP + sw.getBuffer ().toString());

			}

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

					tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + PROCESS_OP + " saliendo");

			 }

		 }	

	}



	/**

	 * @see es.ejie.frmk.presentacion.operacion.paso.Q70ActionOI#processForward(es.ejie.frmk.presentacion.sesiondatos.ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)

	 */

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		try{

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + PROCESS_FORWARD + " entrando");

			}							

			return mapping.findForward(MAPPING);

		}catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + PROCESS_FORWARD + sw.getBuffer ().toString());

			}

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

					tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + PROCESS_FORWARD + " saliendo");

			 }

		 }

	}

}