package q02b.buscadores.action;



import javax.servlet.http.HttpServletRequest;

import javax.servlet.http.HttpServletResponse;



import org.apache.struts.action.ActionErrors;

import org.apache.struts.action.ActionForm;

import org.apache.struts.action.ActionForward;

import org.apache.struts.action.ActionMapping;



import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;

import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaError;

import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;

import es.ejie.frmk.negocio.adaptadorinvocacion.Q70AdaptadorInvocacion;



import es.ejie.frmk.presentacion.operacion.paso.Q70ActionOI;

import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;



import java.util.ArrayList;

import java.util.HashMap;

 

import q02b.exe.comun.Q02bAutenticador;

import q02b.exe.utils.Q02bFormatData;



/**

 * @version 1.0

 * Fecha: 23-nov-06

 */

public class Q02bActionListaComboBuscadorGeneral extends Q70ActionOI {

	//Traza del servidor

	private static Q70Traza tr = Q70Traza.getSingleton();

	//Componente en el cual nos encontramos

	final static String COMPONENTE 						= "ACTION OI";

	final static String MAPPING   						= "ok";

	//EJB a utilizar

	final static String EJB_COMUN						= "q02b.q02bComunSesionEJB";

	//Mtodo a utilizar en el EJB

	final static String EJB_METODO_OBTENER_COMBO		= "obtenerComboBuscadorGeneral";

	final static String OI_ERROR						= "OI_ERROR";

	final static String ERROR_OBTENER_LISTA				= "error.oi.obtenerListaBuscadorGeneral";

	//Variables a utilizar

	final static String VARIABLE_USER					= "user";

	final static String VARIABLE_ROLES					= "roles";

	final static String VARIABLE_IDIOMA					= "idioma";

	final static String VARIABLE_MAPA_RESTRICCIONES		= "mapaRestricciones";

	final static String LISTA		 					= "listaBuscadorGeneral";

	final static String LISTA_COMBO 					= "listaBuscadorGeneralCombo";

	final static String LISTA_TABLA 					= "listaBuscadorGeneralTabla";

	final static String FILTRO_BUSCADOR_GENERAL			= "filtroBuscadorForm";



	/**

	 * @see es.ejie.frmk.presentacion.operacion.paso.ActionPasoOP#processOP(es.ejie.frmk.presentacion.sesiondatos.ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)

	 */

	protected Q70OperacionInternaErrors processOI(Q70ContextoEJIE contexto, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		//Mtodo para la traza

		final String TRACE_METODO_OI = "processOI";

		

		if (tr.isTraceActive()){

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO_OI + " :entrando");

		}

		

		//Se almacenan los errores

		Q70OperacionInternaErrors errores = new Q70OperacionInternaErrors();

		

		try{

			//Recogida de atributos del contexto de OP

			ArrayList 		lista 	= (ArrayList)contexto.get(LISTA);

			//se recupera de la request los posibles errores

			ActionErrors erroresRequest = new ActionErrors();

			erroresRequest = (ActionErrors) request.getAttribute("org.apache.struts.action.ERROR");

			if(erroresRequest != null)

			{

				lista = new ArrayList(); 

				contexto.set(LISTA, lista);	

				contexto.set(LISTA_TABLA, new ArrayList());

			}

		

			//Se recorre el arrayList

			for(int i=0;i<lista.size();i++){

				//Se obtiene la sublista

				ArrayList subLista = (ArrayList)lista.get(i);

				//Si la sublista tiene datos y el primer objeto es de tipo S99bBuscadorGeneral se lo asigno a la lista correspondiente del  contexto

				if(subLista.size()>0 && subLista.get(0).getClass().equals(new q02b.exe.comun.valueobjects.Q02bBuscadorGeneral().getClass())){

					contexto.set(LISTA_TABLA, subLista);

				} else if(subLista.size()==0){

					contexto.set(LISTA_TABLA, new ArrayList());

				}

				

			}

			//Se obtiene el filtro del buscador general

			HashMap filtro=(HashMap)contexto.get(FILTRO_BUSCADOR_GENERAL);

			//Slo se cargar el la lista del combo en el caso de que exista

			//valor para alguna de las variables del combo

			if(!Q02bFormatData.esVacio((String)filtro.get("tableNiCombo"))){

				//Se instancia el Autenticador con los parmetros del contexto 

				Q02bAutenticador autenticador=new Q02bAutenticador();

				autenticador.setUser((String)contexto.get(VARIABLE_USER));

				autenticador.setRoles((ArrayList)contexto.get(VARIABLE_ROLES));

				autenticador.setIdioma((String)contexto.get(VARIABLE_IDIOMA));

				autenticador.setMapaRestricciones((HashMap)contexto.get(VARIABLE_MAPA_RESTRICCIONES));

		        //Tipos de parmetros para el EJB

				Class[] paramType 		= {HashMap.class,autenticador.getClass()};

				//Se indica en un array los objetos con los datos para enviar al EJB

				Object[] o 				= {filtro,autenticador};

				//Se obtiene el ArrayList con el listado

				ArrayList listaCombo	= (ArrayList)Q70AdaptadorInvocacion.invokeFunction(EJB_COMUN,EJB_METODO_OBTENER_COMBO,o,paramType);

				//Se asocia el ArrayList a una variable del contexto

				contexto.set(LISTA_COMBO,listaCombo);

			}

		}catch(Exception ex){

		    //Se aade un error genrico

			errores.add(OI_ERROR, new Q70OperacionInternaError(ERROR_OBTENER_LISTA));

			java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            tr.trace(COMPONENTE, Q70TraceLevel.ERROR,

            		TRACE_METODO_OI + ": " + sw.getBuffer().toString());

		}finally{

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO_OI + " :saliendo");

			}

		}	

		//Se devuelven los errores que se hayan producido

		return errores;

	}



	/**

	 * @see es.ejie.frmk.presentacion.operacion.paso.Q70ActionOI#processForward(es.ejie.frmk.presentacion.sesiondatos.ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)

	 */

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		final String TRACE_METODO_FW				= ":processForward:";

		if (tr.isTraceActive()){

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO_FW + " entrando");

		}

		return mapping.findForward(MAPPING);

	}

}

