package q02b.agentes.action;



import javax.servlet.http.HttpServletRequest;

import javax.servlet.http.HttpServletResponse;



import org.apache.struts.action.ActionErrors;

import org.apache.struts.action.ActionForm;

import org.apache.struts.action.ActionForward;

import org.apache.struts.action.ActionMapping;



import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;

import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;



import es.ejie.frmk.presentacion.operacion.paso.Q70ActionOI;



import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;



import es.ejie.frmk.negocio.adaptadorinvocacion.Q70AdaptadorInvocacion;



import q02b.exe.comun.Q02bAutenticador;



import java.util.ArrayList;

import java.util.HashMap;



public class Q02bActionObtenerAgenteOfi extends Q70ActionOI {

	private static Q70Traza tr = Q70Traza.getSingleton();

	private static final String COMPONENTE = "ACTION_OI";

	

	//EJB a utilizar	

	final static String EJB_AGENTES				= "q02b.q02bAgentesSesionEJB";

	

	//Mtodo a utilizar en el EJB			

	final static String EJB_METODO_LISTA_AGENTE_OFI			= "obtenerListaAgenteOfi";

	final static String EJB_METODO_CONSULTAR_AGENTE				= "obtenerAgente";	

	

	

	final static String	LISTA_AGENTE_OFI 				= "listaOficinas";

	

	final static String VAR_AGENTE							= "agente";

	

	//Declaracion de mappings

	final static String MAPPING   							= "ok";

	

	

	

//	Variables a utilizar

	final static String VARIABLE_USER						= "user";

	final static String VARIABLE_IDIOMA						= "idioma";

	final static String VARIABLE_COLUMNAPK_AGENTE		= "idAgente";

	

	/**

	 * @see es.ejie.frmk.presentacion.operacion.paso.Q70ActionOI#processOI(es.ejie.frmk.presentacion.sesiondatos.ContextoEJIE, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)

	 */

	protected Q70OperacionInternaErrors processOI(Q70ContextoEJIE contexto, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		

		//Se instancia el Autenticador con los parmetros del contexto   

		Q02bAutenticador autenticador=new Q02bAutenticador();

		

		

		try{

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":processOI: entrando");

			}

			autenticador.setUser((String)contexto.get(VARIABLE_USER));

			autenticador.setIdioma((String)contexto.get(VARIABLE_IDIOMA));

					

			//Tipos de parmetros para el EJB

			Class[] paramType 	= {Class.forName("java.lang.String"),autenticador.getClass()};

			//Class[] paramType 	= {Class.forName("java.lang.String")};

			//Se indica en un array los objetos con los datos para enviar al EJB

			Object[] o 	= {((String)contexto.get(VARIABLE_COLUMNAPK_AGENTE)),autenticador};

			//Object[] o 	= {((String)contexto.get(VARIABLE_COLUMNAPK_AGENTE))};

			

            // SE OBTIENEN LOS DATOS DE LA VARIABLE DE ACTIVIDAD

			try{

				HashMap agente = this.consultarAgente(o,paramType);

				contexto.set(VAR_AGENTE, agente);

			}catch(Exception ex){

				contexto.set(VAR_AGENTE,null);

			}			

			

	        //INICIO: CARGA DE LISTADOS 						

			try{

				//Se pone en el contexto el listado recuperado del EJB

				contexto.set(LISTA_AGENTE_OFI,this.obtenerListaAgenteOfi(o,paramType));

			}catch(Exception ex){

				contexto.set(LISTA_AGENTE_OFI,null);

			}

			

	

			//Se devuelve null para indicar que no han existido errores

			return null;

		

		}catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":processOI " + sw.getBuffer ().toString());

			}

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

					tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":processOI: saliendo");

			 }

		 }	

	}



	/**

	 * @see es.ejie.frmk.presentacion.operacion.paso.Q70ActionOI#processForward(es.ejie.frmk.presentacion.sesiondatos.ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)

	 */

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		try{

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":processForward: entrando");

			}

			return mapping.findForward(MAPPING);

		}catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":processForward " + sw.getBuffer ().toString());

			}

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":processForward: saliendo");

			 }

		 }	

	}

	

	/**

	 * Mtodo que hace la llamada al EJB correspondiente para obtener los datos de la variable de actividad

	 * @param o Array de Object con los parmetros a pasar al EJB

	 * @param paramType Array de Class con los tipos de objetos que se pasan al EJB

	 * @return

	 * @throws Exception

	 */

	private HashMap consultarAgente(Object[] o,Class[] paramType) throws Exception{

		try{

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":consultarAgente: entrando");

			}

            //Se invoca la funcin del Framework que te permite obtener los datos para la consulta del foco

			//return (HashMap)Q70AdaptadorInvocacion.invokeFunction(EJB_AGENTES,EJB_METODO_CONSULTAR_AGENTE,o,paramType);

			return (HashMap)Q70AdaptadorInvocacion.invokeFunction(EJB_AGENTES,EJB_METODO_CONSULTAR_AGENTE,o,paramType);

		}catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":consultarAgente " + sw.getBuffer ().toString());

			}

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":consultarAgente: saliendo");

			 }

		 }	

	}

	

	

	

	/**

	 * Mtodo que hace la llamada al EJB correspondiente para recuperar la lista de oficinas relacionadas al agente

	 * @param o Array de Object con los parmetros a pasar al EJB

	 * @param paramType Array de Class con los tipos de objetos que se pasan al EJB

	 * @return

	 * @throws Exception

	 */

	private ArrayList obtenerListaAgenteOfi(Object[] o,Class[] paramType) throws Exception{

		try{

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerListaAgenteOfi: entrando");

			}

            //Se invoca la funcin del Framework que te permite obtener el ArrayList de oficinas asociadas a el agente

			return (ArrayList)Q70AdaptadorInvocacion.invokeFunction(EJB_AGENTES,EJB_METODO_LISTA_AGENTE_OFI,o,paramType);

		}catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerListaAgenteOfi " + sw.getBuffer ().toString());

			}

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerListaAgenteOfi: saliendo");

			 }

		 }	

	}

	

	

}