package q02bSolicitudesNoraSesionEJB;



import java.rmi.RemoteException;

import java.util.ArrayList;

import java.util.HashMap;



import javax.ejb.CreateException;

import javax.ejb.EJBException;

import javax.ejb.SessionBean;



import q02b.exe.comun.Q02bAplicException;

import q02b.exe.comun.Q02bAutenticador;

import q02b.exe.solicitudesNora.beans.Q02bSolicitudesNoraBean;

import q02b.exe.solicitudesNora.valueobjects.Q02bSolicitudNora;

import q02b.exe.utils.Q02bVoUtils;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;

 

/**

 * XDoclet-based session bean.  The class must be declared

 * public according to the EJB specification.

 *

 * To generate the EJB related files to this EJB:

 *		- Add Standard EJB module to XDoclet project properties

 *		- Customize XDoclet configuration for your appserver

 *		- Run XDoclet

 *

 * Below are the xdoclet-related tags needed for this EJB.

 * 

 * @ejb.bean name="Q02bSolicitudesNoraSesionBean"

 *           display-name="Name for Q02bSolicitudesNoraSesion"

 *           description="Description for Q02bSolicitudesNoraSesion"

 *           jndi-name="ejb/Q02bSolicitudesNoraSesion"

 *           type="Stateless"

 *           view-type="remote"

 */

  



public class Q02bSolicitudesNoraSesionBean implements SessionBean {



	

	private static final long serialVersionUID = 4131248384461301469L;

	private static Q70Traza tr = Q70Traza.getSingleton();

	private static final String COMPONENTE = "EJB_SESION_DATOS";

	protected Q02bSolicitudesNoraBean beanSolicitudes= null;

	

	/** The session context */

	private javax.ejb.SessionContext mySessionCtx;



	 

	

	public Q02bSolicitudesNoraSesionBean() {

		super();

		// TODO Auto-generated constructor stub

	}

	/**

	 * Set the associated session context. The container calls this method 

	 * after the instance creation.

	 * 

	 * The enterprise bean instance should store the reference to the context 

	 * object in an instance variable.

	 * 

	 * This method is called with no transaction context. 

	 * 

	 * @throws EJBException Thrown if method fails due to system-level error.

	 */

	/**

	 * getSessionContext

	 */

	public javax.ejb.SessionContext getSessionContext() {

		return mySessionCtx;

	}

	/**

	 * setSessionContext

	 */

	public void setSessionContext(javax.ejb.SessionContext ctx) {

		mySessionCtx = ctx;

	}



	public void ejbRemove() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	public void ejbActivate() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	public void ejbPassivate() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	/**

	 * An ejbCreate method as required by the EJB specification.

	 * 

	 * The container calls the instance?s <code>ejbCreate</code> method whose

	 * signature matches the signature of the <code>create</code> method invoked

	 * by the client. The input parameters sent from the client are passed to

	 * the <code>ejbCreate</code> method. Each session bean class must have at

	 * least one <code>ejbCreate</code> method. The number and signatures

	 * of a session bean?s <code>create</code> methods are specific to each 

	 * session bean class.

	 * 

	 * @throws CreateException Thrown if method fails due to system-level error.

	 * 

	 * @ejb.create-method

	 * 

	 */

	public void ejbCreate() throws CreateException {

		// TODO Add ejbCreate method implementation

	}  

	// -------------------------------------------------------------------------------------------------

	// ------------------------------------- SOLICITUDES NORA  -----------------------------------------

	// -------------------------------------------------------------------------------------------------

	

	/**

	 * Obtener la lista de solicitudes de alta en Nora

	 * @param autenticador - Q02bAutenticador Autenticador

	 * @return Devuelve la lista de solicitudes

	 * @throws Exception

	 */

	public ArrayList obtenerSolicitudesNora(HashMap mapaFiltroSolicitudesNora, Q02bAutenticador autenticador) throws Exception 

	{		

		ArrayList listaSolicitudes= new ArrayList(); 

		try{

			if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerSolicitudesNora: entrando.");

	   		}		

			beanSolicitudes= new Q02bSolicitudesNoraBean();

			beanSolicitudes.setAutenticador(autenticador);

			listaSolicitudes = beanSolicitudes.getSolicitudesNora(mapaFiltroSolicitudesNora);

			return listaSolicitudes;

		} catch(Q02bAplicException ex1){	 		  

	          java.io.StringWriter sw = new java.io.StringWriter();

	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	          ex1.printStackTrace(pw);

	          tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerSolicitudesNora: " + sw.getBuffer ().toString());

	          throw ex1;       	

		}catch(Exception ex){	 	

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerSolicitudesNora: " + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally{    	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerSolicitudesNora: saliendo.");

	   		}

	 	}

	}//fin obtenerSolicitudesNora

	

	

	public HashMap obtenerSolicitudNoraModificacion(String idSolicitudNora, Q02bAutenticador autenticador) throws Exception {

		//Definicin de variables que no se van a modificar

		final String TRACE_METODO 	= ":obtenerSolicitudNoraModificacion:";

		//Definicin de objetos

		HashMap hashSolicitud =null;

		Q02bSolicitudNora solicitudVO = null;

		try{

			if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " entrando " + idSolicitudNora);

	   		}

			//Se instancia el bean de negocio

			beanSolicitudes= new Q02bSolicitudesNoraBean();

			solicitudVO = new Q02bSolicitudNora();

			//Se pasa el autenticador

			beanSolicitudes.setAutenticador(autenticador);

			//Se obtiene la lista de solicitudes

			solicitudVO = beanSolicitudes.obtenerSolicitudNoraModificacion(idSolicitudNora);

			//Se obtiene el objeto a partir del hashmap

			hashSolicitud = (HashMap)Q02bVoUtils.getHashMap(solicitudVO);

			//Se devuelve la lista

			return hashSolicitud;

		}catch(Exception ex){	 	

			java.io.StringWriter 	sw = new java.io.StringWriter();

			java.io.PrintWriter 	pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + TRACE_METODO + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally{    	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " saliendo.");

	   		}

	 	}

	}//fin obtenerSolicitudNoraModificacion

	

	/**

	 * Mtodo que llama a un Bean para obtener los datos de una solicitud.

	 * @param idSolicitudNora nmero interno de la solicitud en la BBDD.

	 * @param autenticador Objeto con el id. y perfil de usuario e idioma. 

	 * @return HashMap con los datos de la solicitud.

	 * @throws Exception

	 */

	public HashMap obtenerSolicitudNoraConsulta(String idSolicitudNora, Q02bAutenticador autenticador) throws Exception {

		//Definicin de variables que no se van a modificar

		final String TRACE_METODO 	= ":obtenerSolicitudNoraConsulta:";

		//Definicin de objetos

		Q02bSolicitudNora solicitud = new Q02bSolicitudNora();

		HashMap solicitudHashMap = new HashMap(); 

		try{

			if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " entrando " + idSolicitudNora);

	   		}

			//Se instancia el bean de negocio

			beanSolicitudes = new Q02bSolicitudesNoraBean();

			//Se pasa el autenticador

			beanSolicitudes.setAutenticador(autenticador);

			//Se obtiene la lista con los grupos

			solicitud = beanSolicitudes.obtenerSolicitudNoraConsulta(idSolicitudNora);

			//Se obtiene el objeto a partir del hashmap

			solicitudHashMap = (HashMap)Q02bVoUtils.getHashMap(solicitud);

			//Se devuelve la lista

			return solicitudHashMap;

		}catch(Exception ex){	 	

			java.io.StringWriter 	sw = new java.io.StringWriter();

			java.io.PrintWriter 	pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + TRACE_METODO + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally{    	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " saliendo.");

	   		}

	 	}

	}// fin obtenerSolicitudNoraConsulta

	

	/**

	 * Modifica una solicitud de alta en NORA de la bbdd

	 * @param mapaSolicitud - HashMap con los datos de la solicitud

	 * @param autenticador - Q02bAutenticador Autenticador

	 * @throws Exception

	 */

	public void modificarSolicitudNora(HashMap mapaSolicitudNora, Q02bAutenticador autenticador) throws Exception 

	{		

		Q02bSolicitudNora solicitudVO=null;

		try{

			if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarSolicitudNora: entrando.");

	   		}		

			solicitudVO = (Q02bSolicitudNora) Q02bVoUtils.getValueObject(mapaSolicitudNora,"q02b.exe.solicitudesNora.valueobjects.Q02bSolicitudNora");

			

			beanSolicitudes= new Q02bSolicitudesNoraBean();

			beanSolicitudes.setAutenticador(autenticador);

			

			beanSolicitudes.modificarSolicitudNora(solicitudVO);

		} catch(Q02bAplicException ex1){	 		  

	          java.io.StringWriter sw = new java.io.StringWriter();

	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	          ex1.printStackTrace(pw);

	          tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarSolicitudNora: " + sw.getBuffer ().toString());

	          throw ex1;       	

		}catch(Exception ex){	 	

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarSolicitudNora: " + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally{    	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarSolicitudNora: saliendo.");

	   		}

	 	}

	}//fin modificarSolicitudNora

	



	// --------------------------------------------------------------------------

	// ---------- FIN SOLICITUDES NORA -----------

	// ---------------------------------------------------------------------------



} // fin clase

