package q02bProcesosSesionEJB;



import java.rmi.RemoteException;

import java.util.ArrayList;

import java.util.HashMap;



import javax.ejb.CreateException;

import javax.ejb.EJBException;

import javax.ejb.SessionBean;



import q02b.exe.comun.Q02bAplicException;

import q02b.exe.comun.Q02bAutenticador;

import q02b.exe.procesos.beans.Q02bProcesosBean;

import q02b.exe.procesos.valueobjects.Q02bProcesos;

import q02b.exe.utils.Q02bVoUtils;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;

 

/**

 * XDoclet-based session bean.  The class must be declared

 * public according to the EJB specification.

 *

 * To generate the EJB related files to this EJB:

 *		- Add Standard EJB module to XDoclet project properties

 *		- Customize XDoclet configuration for your appserver

 *		- Run XDoclet

 *

 * Below are the xdoclet-related tags needed for this EJB.

 * 

 * @ejb.bean name="Q02bProcesosSesion"

 *           display-name="Name for Q02bProcesosSesion"

 *           description="Description for Q02bProcesosSesion"

 *           jndi-name="ejb/Q02bProcesosSesion"

 *           type="Stateless"

 *           view-type="remote"

 */

  



public class Q02bProcesosSesionBean implements SessionBean {



	

	private static final long serialVersionUID = 4131248384461301469L;

	private static Q70Traza tr = Q70Traza.getSingleton();

	private static final String COMPONENTE = "EJB_SESION_DATOS";

	protected Q02bProcesosBean beanProcesos= null;

	

	/** The session context */

	private javax.ejb.SessionContext mySessionCtx;



	 

	

	public Q02bProcesosSesionBean() {

		super();

		// TODO Auto-generated constructor stub

	}

	/**

	 * Set the associated session context. The container calls this method 

	 * after the instance creation.

	 * 

	 * The enterprise bean instance should store the reference to the context 

	 * object in an instance variable.

	 * 

	 * This method is called with no transaction context. 

	 * 

	 * @throws EJBException Thrown if method fails due to system-level error.

	 */

	/**

	 * getSessionContext

	 */

	public javax.ejb.SessionContext getSessionContext() {

		return mySessionCtx;

	}

	/**

	 * setSessionContext

	 */

	public void setSessionContext(javax.ejb.SessionContext ctx) {

		mySessionCtx = ctx;

	}



	public void ejbRemove() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	public void ejbActivate() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	public void ejbPassivate() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	/**

	 * An ejbCreate method as required by the EJB specification.

	 * 

	 * The container calls the instance?s <code>ejbCreate</code> method whose

	 * signature matches the signature of the <code>create</code> method invoked

	 * by the client. The input parameters sent from the client are passed to

	 * the <code>ejbCreate</code> method. Each session bean class must have at

	 * least one <code>ejbCreate</code> method. The number and signatures

	 * of a session bean?s <code>create</code> methods are specific to each 

	 * session bean class.

	 * 

	 * @throws CreateException Thrown if method fails due to system-level error.

	 * 

	 * @ejb.create-method

	 * 

	 */

	public void ejbCreate() throws CreateException {

		// TODO Add ejbCreate method implementation

	}  

	// ------------------------------------------

	// ---------- PROCESOS  ----------

	// ------------------------------------------



	/**

	 * Obtener la lista de procesos

	 * @return Devuelve la lista de procesos

	 * @throws Exception

	 */

	public ArrayList obtenerProcesos(java.util.HashMap mapaFiltroProceso, Q02bAutenticador autenticador) throws Exception 

	{		

		//Definicin de variables			 		

		Q02bProcesos proceso = new Q02bProcesos();

		ArrayList listaProcesos = new ArrayList(); 

		try

		{

			if (tr.isTraceActive())

			{

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerProcesos: entrando.");

	   			tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaFiltroProcesos : " + mapaFiltroProceso);

	   		}			

			beanProcesos = new Q02bProcesosBean();

			beanProcesos.setAutenticador(autenticador);

			proceso = (Q02bProcesos) Q02bVoUtils.getValueObject(mapaFiltroProceso,"q02b.exe.procesos.valueobjects.Q02bProcesos");

			listaProcesos = beanProcesos.obtenerProcesos(proceso);

			return listaProcesos;

			

		}catch(Exception ex)

		{	 	

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerProcesos: " + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally {    	

	        if (tr.isTraceActive()) {

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerProcesos: saliendo.");

	   		}

	 	}

	}//fin obtenerProcesos

	

	/**

     * Mtodo que dado un proceso lo inserta en la BBDD 

     * insertara en la BBDD los datos de dicho proceso

     * @param mapaProceso

     */ 

	public void insertarProcesos(HashMap mapaProceso, Q02bAutenticador autenticador) throws Exception 

	{

		Q02bProcesos proceso = new Q02bProcesos();

		try {

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarProcesos: entrando");

				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaProceso : " + mapaProceso.toString());

			}

			

			//se pasa el hashmap de entrada a un objeto de tipo Q02bProcesos	

			proceso = (Q02bProcesos) Q02bVoUtils.getValueObject(mapaProceso,"q02b.exe.procesos.valueobjects.Q02bProcesos");

			

			//se instancia el bean de negocio

			beanProcesos= new Q02bProcesosBean();

	  		//se pasa el autenticador

			beanProcesos.setAutenticador(autenticador);

	  		

	  		//se llama al mtodo del bean necesario

	  		beanProcesos.insertarProcesos(proceso);		

	     }catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw); 

            if (tr.isTraceActive()){  

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarProcesos: " + sw.getBuffer ().toString());

			}

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

					tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarProcesos: saliendo");

			}			

		}

	} // fin insertarProcesos

	

	/**

     * Mtodo que dado el nmero interno del proceso

     * recuperara de la BBDD los datos de dicho proceso

     * @param idProceso

     * @return proceso

     */ 

	/*public HashMap obtenerProceso(String idProceso, Q02bAutenticador autenticador) throws Exception 

	{		

		//Definicin de variables

		HashMap proceso =  new HashMap(); 

		Q02bProcesos procesoVO = new Q02bProcesos();

		try{

			if (tr.isTraceActive()) {

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerProceso ejb-> ** idProceso=:" + idProceso);	   			

	   		}			

			beanProcesos= new Q02bProcesosBean();

			

			//se pasa el autenticador

	  		beanProcesos.setAutenticador(autenticador);

	  		

	  		//se llama al mtodo del bean necesario			

	  		procesoVO = beanProcesos.obtenerProceso(idProceso);

	  		

	  		//se pasa el resultado a un hashMap

	  		proceso = (HashMap)Q02bVoUtils.getHashMap(procesoVO);

			return proceso;

		} catch(Q02bAplicException ex1){	 		  

	          java.io.StringWriter sw = new java.io.StringWriter();

	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	          ex1.printStackTrace(pw);

	          tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerProceso: " + sw.getBuffer ().toString());

	          throw ex1;       	

		}catch(Exception ex){	 	

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerProceso: " + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally{    	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerProceso: saliendo.");

	   		}

	 	}

	}//fin obtenerProceso */

	

	public HashMap obtenerProcesoModificacion(String idProceso, Q02bAutenticador autenticador) throws Exception {

		//Definicin de variables que no se van a modificar

		final String TRACE_METODO 	= ":obtenerProcesoModificacion:";

		//Definicin de objetos

		Q02bProcesos	proceso	= new Q02bProcesos();

		HashMap procesoHashMap		= new HashMap(); 

		try{

			if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " entrando " + idProceso);

	   		}

			//Se instancia el bean de negocio

			beanProcesos = new Q02bProcesosBean();

			//Se pasa el autenticador

			beanProcesos.setAutenticador(autenticador);

			//Se obtiene la lista con los resultados

			proceso = beanProcesos.obtenerProcesoModificacion(idProceso);

			//Se obtiene el objeto a partir del hashmap

			procesoHashMap = (HashMap)Q02bVoUtils.getHashMap(proceso);

			//Se devuelve la lista

			return procesoHashMap;

		}catch(Exception ex){	 	

			java.io.StringWriter 	sw = new java.io.StringWriter();

			java.io.PrintWriter 	pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + TRACE_METODO + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally{    	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " saliendo.");

	   		}

	 	}

	}//fin obtenerProcesoModificacion

	

	/**

	 * Mtodo que llama a un Bean para obtener los datos de un proceso para su consulta.

	 * @param niProceso nmero interno del proceso en la bbdd.

	 * @param autenticador Objeto con el id. y perfil de usuario e idioma. 

	 * @return HashMap con los datos del proceso.

	 * @throws Exception

	 */

	public HashMap obtenerProcesoConsulta(String idProceso, Q02bAutenticador autenticador) throws Exception {

		//Definicin de variables que no se van a modificar

		final String TRACE_METODO 	= ":obtenerProcesoConsulta:";

		//Definicin de objetos

		Q02bProcesos proceso = new Q02bProcesos();

		HashMap procesoHashMap = new HashMap(); 

		try{

			if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " entrando " + idProceso);

	   		}

			//Se instancia el bean de negocio

			beanProcesos = new Q02bProcesosBean();

			//Se pasa el autenticador

			beanProcesos.setAutenticador(autenticador);

			//Se obtiene la lista con los resultados

			proceso = beanProcesos.obtenerProcesoConsulta(idProceso);

			//Se obtiene el objeto a partir del hashmap

			procesoHashMap = (HashMap)Q02bVoUtils.getHashMap(proceso);

			//Se devuelve la lista

			return procesoHashMap;

		}catch(Exception ex){	 	

			java.io.StringWriter 	sw = new java.io.StringWriter();

			java.io.PrintWriter 	pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + TRACE_METODO + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally{    	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " saliendo.");

	   		}

	 	}

	}// fin obtenerProcesoConsulta

	

	/**

	 * Borrar de bbdd un proceso

	 * @param idProceso - Nmero interno del proceso a borrar

	 */

	public void borrarProcesos(String idProceso, Q02bAutenticador autenticador) throws Exception

	{

		try {

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarProcesos: entrando con ayuntamiento: " + idProceso);

			}

			beanProcesos= new Q02bProcesosBean();

			//se pasa el autenticador

	  		beanProcesos.setAutenticador(autenticador);

	  		//se llama al mtodo del bean necesario

			beanProcesos.borrarProcesos(idProceso);			

	     }catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarProcesos: " + sw.getBuffer ().toString());

			}

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarProcesos: saliendo");

			 }	

		 }			  

	} // fin borrarProcesos

	

	/**

	 * Modificar en bbdd un proceso con los datos pasados como parmetro en la HashMap

	 */

	public void modificarProcesos(HashMap mapaProceso, Q02bAutenticador autenticador) throws Exception

	{

		Q02bProcesos proceso = null;	  	

		try {

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarProcesos: entrando");

				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaProceso : " + mapaProceso.toString());

			}			

			//se pasa el hashmap de entrada a un objeto de tipo Q02bProcesos

			proceso = (Q02bProcesos) Q02bVoUtils.getValueObject(mapaProceso,"q02b.exe.procesos.valueobjects.Q02bProcesos");

			

			beanProcesos= new Q02bProcesosBean();

			//se pasa el autenticador

	  		beanProcesos.setAutenticador(autenticador);

			//se llama al metodo del bean para modificar el Procesos

			beanProcesos.modificarProcesos(proceso);			

		}catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarProcesos: " + sw.getBuffer ().toString());

			}

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarProcesos: saliendo");

			 }

		 }		

	} // fin modificarProcesos

      

	// ---------------------------------------------

	// ---------- FIN PROCESOS -----------

	// ---------------------------------------------



} // fin clase

