package q02bOficinasMunicipalesSesionEJB;



import java.rmi.RemoteException;

import java.util.ArrayList;

import java.util.HashMap;



import javax.ejb.CreateException;

import javax.ejb.EJBException;

import javax.ejb.SessionBean;



import q02b.exe.comun.Q02bAplicException;

import q02b.exe.comun.Q02bAutenticador;



import q02b.exe.oficinasMunicipales.beans.Q02bOficinasMunicipalesBean;

import q02b.exe.oficinasMunicipales.valueobjects.Q02bOficinasMunicipales;

import q02b.exe.plazos.beans.Q02bPlazosBean;

import q02b.exe.plazos.valueobjects.Q02bPlazos;

import q02b.exe.utils.Q02bFormatData;

import q02b.exe.utils.Q02bVoUtils;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;

import org.w3c.dom.Document;

 

/**

 * XDoclet-based session bean.  The class must be declared

 * public according to the EJB specification.

 *

 * To generate the EJB related files to this EJB:

 *		- Add Standard EJB module to XDoclet project properties

 *		- Customize XDoclet configuration for your appserver

 *		- Run XDoclet

 *

 * Below are the xdoclet-related tags needed for this EJB.

 * 

 * @ejb.bean name="Q02bCuestionariosSMAnuSesion"

 *           display-name="Name for Q02bCuestionariosSMAnuSesion"

 *           description="Description for Q02bCuestionariosSMAnuSesion"

 *           jndi-name="ejb/Q02bCuestionariosSMAnuSesion"

 *           type="Stateless"

 *           view-type="remote"

 */

  



public class Q02bOficinasMunicipalesSesionBean implements SessionBean {



	

	private static final long serialVersionUID = 4131248384461301469L;

	private static Q70Traza tr = Q70Traza.getSingleton();

	private static final String COMPONENTE = "EJB_SESION_DATOS";

	

	//Se indica el bean de negocio que se va a utilizar

    protected Q02bOficinasMunicipalesBean bean = null;

	

	private static final String Aitziber = "Aitziber";

	

	/** The session context */

	private javax.ejb.SessionContext mySessionCtx;



	

	

	public Q02bOficinasMunicipalesSesionBean() {

		super();

		// TODO Auto-generated constructor stub

	}

	/**

	 * Set the associated session context. The container calls this method 

	 * after the instance creation.

	 * 

	 * The enterprise bean instance should store the reference to the context 

	 * object in an instance variable.

	 * 

	 * This method is called with no transaction context. 

	 * 

	 * @throws EJBException Thrown if method fails due to system-level error.

	 */

	/**

	 * getSessionContext

	 */

	public javax.ejb.SessionContext getSessionContext() {

		return mySessionCtx;

	}

	/**

	 * setSessionContext

	 */

	public void setSessionContext(javax.ejb.SessionContext ctx) {

		mySessionCtx = ctx;

	}



	public void ejbRemove() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	public void ejbActivate() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	public void ejbPassivate() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	/**

	 * An ejbCreate method as required by the EJB specification.

	 * 

	 * The container calls the instance?s <code>ejbCreate</code> method whose

	 * signature matches the signature of the <code>create</code> method invoked

	 * by the client. The input parameters sent from the client are passed to

	 * the <code>ejbCreate</code> method. Each session bean class must have at

	 * least one <code>ejbCreate</code> method. The number and signatures

	 * of a session bean?s <code>create</code> methods are specific to each 

	 * session bean class.

	 * 

	 * @throws CreateException Thrown if method fails due to system-level error.

	 * 

	 * @ejb.create-method

	 * 

	 */

	public void ejbCreate() throws CreateException {

		// TODO Add ejbCreate method implementation

	}  

	// -------------------------------------------------------------------------------------------------

	// ---------- CUESTIONARIOS VAPM  ----------

	// -------------------------------------------------------------------------------------------------



	

	 // -------------------- INI - OBTENER LISTA -------------------

    /**

     * Metodo del EJB para obtener un ArrayList de objetos

     * en funcion de los parametros del filtro

     * @param filtro - Q02bOficinasMunicipalesFiltro

     * @return  - ArrayList de objetos - Q02bOficinasMunicipalesLista

     * @throws Exception

     * @see Q02bOficinasMunicipalesFiltro

     * @see Q02bOficinasMunicipalesBean

     * @generated

     */

    public ArrayList obtenerListaOficinasMunicipales(HashMap filtroMapa, Q02bAutenticador autenticador) throws Exception {

        //Definici?n de constantes

        final String TRACE_METODO = "Q02bOficinasMunicipalesSesionBean:obtenerListaOficinasMunicipales";

        final String RUTA_CLASE = "q02b.exe.oficinasMunicipales.valueobjects.Q02bOficinasMunicipales";

        Q02bOficinasMunicipales filtroVO = new Q02bOficinasMunicipales();

        ArrayList lista = new ArrayList();



        if (tr.isTraceActive()) {

            tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO +

                ": entrando");

            tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,

                TRACE_METODO + ": filtroMapa: " + filtroMapa.toString());

        }



        try {

            //Se instancia el bean de negocio

            bean = new Q02bOficinasMunicipalesBean();

            //Se pasa el autenticador

            bean.setAutenticador(autenticador);

            //Se obtiene el objeto a partir del hashmap

            filtroVO = (Q02bOficinasMunicipales) Q02bVoUtils.getValueObject(filtroMapa,RUTA_CLASE);

            //Se obtiene la lista con los resultados

            lista = bean.obtenerListaOficinasMunicipales(filtroVO);



            //Se devuelve la lista

            return lista;

        } catch (Exception ex) {

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            tr.trace(COMPONENTE, Q70TraceLevel.ERROR,

                TRACE_METODO + sw.getBuffer().toString());

            throw ex;

        } finally {

            if (tr.isTraceActive()) {

                tr.trace(COMPONENTE, Q70TraceLevel.INFO,

                    RUTA_CLASE + " saliendo.");

            }

        }

    }



    // -------------------- FIN - OBTENER LISTA -------------------

    

    /**

     * Mtodo que dado una oficinaMunicipal la inserta en la BBDD 

     * insertara la BBDD los datos de dicha oficina Municipal

     * @param mapaOficinasMunicipales

     */ 

	public void insertarOficinasMunicipales(HashMap mapaOficinasMunicipales, Q02bAutenticador autenticador) throws Exception 

	{

		Q02bOficinasMunicipales oficinaMunicipal = null;

		try {

			

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarOficinasMunicipales: entrando");

				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaOficinasMunicipales : " + mapaOficinasMunicipales.toString());

			}

			//se pasa el hashmap de entrada a un objeto de tipo Q02bOficinasMunicipales	

			oficinaMunicipal = (Q02bOficinasMunicipales) Q02bVoUtils.getValueObject(mapaOficinasMunicipales,"q02b.exe.oficinasMunicipales.valueobjects.Q02bOficinasMunicipales");

			

			//se instancia el bean de negocio

	  		bean= new Q02bOficinasMunicipalesBean();

	  		//se pasa el autenticador

	  		bean.setAutenticador(autenticador);

	  		

	  		//se llama al mtodo del bean necesario

	  		bean.insertarOficinasMunicipales(oficinaMunicipal);		

	     }catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw); 

            if (tr.isTraceActive()){  

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarOficinasMunicipales: " + sw.getBuffer ().toString());

			}

            

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

					tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarOficinasMunicipales: saliendo");

			}			

		}

	} // fin insertarPlazos

	

	/**

     * Mtodo que dado el nmero interno de la oficina municipal 

     * recuperara de la BBDD los datos de dicho cuestionario

     * @param idOfi

     * @return oficinaMunicipal

     */ 

	public HashMap obtenerOficinaMunicipal(String idOfi, Q02bAutenticador autenticador) throws Exception 

	{		

		//Definicin de variables

		HashMap oficinaMunicipal =  new HashMap(); 

		Q02bOficinasMunicipales oficinaMunicipalVO = new Q02bOficinasMunicipales();

		try{

			if (tr.isTraceActive())

			{

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerOficinaMunicipal ejb-> ** idOfi=:" + idOfi);	   			

	   		}			

			bean = new Q02bOficinasMunicipalesBean();

			

			//se pasa el autenticador

	  		bean.setAutenticador(autenticador);

	  		

	  		//se llama al mtodo del bean necesario			

	  		oficinaMunicipalVO = bean.obtenerOficinaMunicipal(idOfi);

	  		

	  		//se pasa el resultado a un hashMap

	  		oficinaMunicipal = (HashMap)Q02bVoUtils.getHashMap(oficinaMunicipalVO);

			return oficinaMunicipal;

		} catch(Q02bAplicException ex1){	 		  

	          java.io.StringWriter sw = new java.io.StringWriter();

	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	          ex1.printStackTrace(pw);

	          tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerOficinaMunicipal: " + sw.getBuffer ().toString());

	          throw ex1;       	

		}catch(Exception ex){	 	

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerOficinaMunicipal: " + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally{    	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerOficinaMunicipal: saliendo.");

	   		}

	 	}

	}//fin obtenerOficinaMunicipal

	

	/**

	 * Modificar en bbdd una oficinaMunicipal con los datos pasados como parmetro en la HashMap

	 */

	public void modificarOficinasMunicipales(HashMap mapaOficinaMunicipal, Q02bAutenticador autenticador) throws Exception

	{

		Q02bOficinasMunicipales oficinaMunicipal = null;	  	

		try {

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarOficinasMunicipales: entrando");

				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaOficinaMunicipal : " + mapaOficinaMunicipal.toString());

			}			

			//se pasa el hashmap de entrada a un objeto de tipo Q02bPlazos

			oficinaMunicipal = (Q02bOficinasMunicipales) Q02bVoUtils.getValueObject(mapaOficinaMunicipal,"q02b.exe.oficinasMunicipales.valueobjects.Q02bOficinasMunicipales");

			

			bean= new Q02bOficinasMunicipalesBean();

			//se pasa el autenticador

	  		bean.setAutenticador(autenticador);

			//se llama al metodo del bean para modificar el contacto

			bean.modificarOficinasMunicipales(oficinaMunicipal);			

		}catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarOficinasMunicipales: " + sw.getBuffer ().toString());

			}

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarOficinasMunicipales: saliendo");

			 }

		 }		

	} // fin modificarOficinasMunicipales



	/**

	 * Borrar de bbdd una oficinaMunicipal

	 * @param idOfi - Nmero interno del plazo a borrar

	 */

	public void borrarOficinaMunicipal(String idOfi, Q02bAutenticador autenticador) throws Exception

	{

		try {

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarOficinaMunicipal: entrando con oficinaMunicipal: " + idOfi);

			}

			bean= new Q02bOficinasMunicipalesBean();

			//se pasa el autenticador

			bean.setAutenticador(autenticador);

	  		//se llama al mtodo del bean necesario

			bean.borrarOficinaMunicipal(idOfi);			

	     }catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarOficinaMunicipal: " + sw.getBuffer ().toString());

			}

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarOficinaMunicipal: saliendo");

			 }	

		 }			  

	} // fin borrarOficinaMunicipal

	

	

} // fin clase

