package q02bInformantesSesionEJB;



import java.rmi.RemoteException;

import java.util.ArrayList;

import java.util.HashMap;

import java.util.Vector;



import javax.ejb.CreateException;

import javax.ejb.EJBException;

import javax.ejb.SessionBean;



import q02b.exe.comun.Q02bAplicException;

import q02b.exe.comun.Q02bAutenticador;

import q02b.exe.informantes.beans.Q02bInformantesBean;

import q02b.exe.informantes.valueobjects.Q02bInformante;

import q02b.exe.informantes.beans.Q02bInformantesBean;

import q02b.exe.utils.Q02bVoUtils;

import q02b.exe.utils.Q02bFormatData;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;





import org.w3c.dom.Document;

 

/**

 * XDoclet-based session bean.  The class must be declared

 * public according to the EJB specification.

 *

 * To generate the EJB related files to this EJB:

 *		- Add Standard EJB module to XDoclet project properties

 *		- Customize XDoclet configuration for your appserver

 *		- Run XDoclet

 *

 * Below are the xdoclet-related tags needed for this EJB.

 * 

 * @ejb.bean name="Q02bInformantesSesion"

 *           display-name="Name for Q02bInformantesSesion"

 *           description="Description for Q02bInformantesSesion"

 *           jndi-name="ejb/Q02bInformantesSesion"

 *           type="Stateless"

 *           view-type="remote"

 */

  



public class Q02bInformantesSesionBean implements SessionBean {



	

	private static final long serialVersionUID = 4131248384461301469L;

	private static Q70Traza tr = Q70Traza.getSingleton();

	private static final String COMPONENTE = "EJB_SESION_DATOS";

	protected Q02bInformantesBean beanInformantes= null;

	

	/** The session context */

	private javax.ejb.SessionContext mySessionCtx;



	 

	

	public Q02bInformantesSesionBean() {

		super();

		// TODO Auto-generated constructor stub

	}

	/**

	 * Set the associated session context. The container calls this method 

	 * after the instance creation.

	 * 

	 * The enterprise bean instance should store the reference to the context 

	 * object in an instance variable.

	 * 

	 * This method is called with no transaction context. 

	 * 

	 * @throws EJBException Thrown if method fails due to system-level error.

	 */

	/**

	 * getSessionContext

	 */

	public javax.ejb.SessionContext getSessionContext() {

		return mySessionCtx;

	}

	/**

	 * setSessionContext

	 */

	public void setSessionContext(javax.ejb.SessionContext ctx) {

		mySessionCtx = ctx;

	}



	public void ejbRemove() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	public void ejbActivate() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	public void ejbPassivate() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	/**

	 * An ejbCreate method as required by the EJB specification.

	 * 

	 * The container calls the instance?s <code>ejbCreate</code> method whose

	 * signature matches the signature of the <code>create</code> method invoked

	 * by the client. The input parameters sent from the client are passed to

	 * the <code>ejbCreate</code> method. Each session bean class must have at

	 * least one <code>ejbCreate</code> method. The number and signatures

	 * of a session bean?s <code>create</code> methods are specific to each 

	 * session bean class.

	 * 

	 * @throws CreateException Thrown if method fails due to system-level error.

	 * 

	 * @ejb.create-method

	 * 

	 */

	public void ejbCreate() throws CreateException {

		// TODO Add ejbCreate method implementation

	}  

	// -------------------------------------------------------------------------------------------------

	// ------------------------------------- INFORMANTES  -------------------------------------------------

	// -------------------------------------------------------------------------------------------------

	

	/**

	 * Obtener la lista de informantes

	 * @param autenticador - Q02bAutenticador Autenticador

	 * @return Devuelve la lista de informantes

	 * @throws Exception

	 */

	public ArrayList obtenerInformantes(HashMap mapaFiltroInformantes, Q02bAutenticador autenticador) throws Exception 

	{		

		ArrayList listaInformantes= new ArrayList(); 

		try{

			if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerInformantes: entrando.");

	   		}		

			beanInformantes= new Q02bInformantesBean();

			beanInformantes.setAutenticador(autenticador);

			listaInformantes = beanInformantes.getInformantes(mapaFiltroInformantes);

			return listaInformantes;

		} catch(Q02bAplicException ex1){	 		  

	          java.io.StringWriter sw = new java.io.StringWriter();

	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	          ex1.printStackTrace(pw);

	          tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerInformantes: " + sw.getBuffer ().toString());

	          throw ex1;       	

		}catch(Exception ex){	 	

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerInformantes: " + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally{    	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerInformantes: saliendo.");

	   		}

	 	}

	}//fin obtenerInformantes

	

	

	/**

	 * Mtodo que obtiene los datos del informante seleccionado en el listado

	 * @param idInformante - String nmero interno del informante

	 * @param autenticador - Q02bAutenticador Autenticador

	 * @return hashInformante - HashMap hashMap con los datos del informante obtenido

	 * @throws Exception

	 */

	public HashMap obtenerInformante(String idInformante, Q02bAutenticador autenticador) throws Exception 

	{		

		HashMap hashInformante =null;

		Q02bInformante informanteVO = null;

		

		try{

			if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerInformante: entrando.");

	   		}		

			informanteVO = new Q02bInformante();

			

			beanInformantes= new Q02bInformantesBean();

			beanInformantes.setAutenticador(autenticador);

			informanteVO = beanInformantes.getInformante(idInformante);

			//se pasa el resultado a un hashMap

			hashInformante = (HashMap)Q02bVoUtils.getHashMap(informanteVO);

	  		

			return hashInformante;

		} catch(Q02bAplicException ex1){	 		  

	          java.io.StringWriter sw = new java.io.StringWriter();

	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	          ex1.printStackTrace(pw);

	          tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerInformante: " + sw.getBuffer ().toString());

	          throw ex1;       	

		}catch(Exception ex){	 	

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerInformante: " + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally{    	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerInformante: saliendo.");

	   		}

	 	}

	}//fin obtenerInformante

	

	

	/**

	 * Inserta un informante en la bbdd

	 * @param mapaInformante - HashMap con los datos del informante

	 * @param autenticador - Q02bAutenticador Autenticador

	 * @return Devuelve el nmero interno del informante inertado

	 * @throws Exception

	 */

	public String insertarInformante(HashMap mapaInformante, Q02bAutenticador autenticador) throws Exception 

	{		

		String idInformante=null; 

		Q02bInformante informanteVO=null;

		try{

			if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarInformante: entrando.");

	   		}		

			informanteVO = (Q02bInformante) Q02bVoUtils.getValueObject(mapaInformante,"q02b.exe.informantes.valueobjects.Q02bInformante");

			

			beanInformantes= new Q02bInformantesBean();

			beanInformantes.setAutenticador(autenticador);

			

			idInformante = beanInformantes.insertarInformante(informanteVO);

			return idInformante;

		} catch(Q02bAplicException ex1){	 		  

	          java.io.StringWriter sw = new java.io.StringWriter();

	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	          ex1.printStackTrace(pw);

	          tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarInformante: " + sw.getBuffer ().toString());

	          throw ex1;       	

		}catch(Exception ex){	 	

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarInformante: " + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally{    	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarInformante: saliendo.");

	   		}

	 	}

	}//fin insertarInformante

	

	

	/**

	 * Modifica un informante de la bbdd

	 * @param mapaInformante - HashMap con los datos del informante

	 * @param autenticador - Q02bAutenticador Autenticador

	 * @throws Exception

	 */

	public void modificarInformante(HashMap mapaInformante, Q02bAutenticador autenticador) throws Exception 

	{		

		Q02bInformante informanteVO=null;

		try{

			if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarInformante: entrando.");

	   		}		

			informanteVO = (Q02bInformante) Q02bVoUtils.getValueObject(mapaInformante,"q02b.exe.informantes.valueobjects.Q02bInformante");

			

			beanInformantes= new Q02bInformantesBean();

			beanInformantes.setAutenticador(autenticador);

			

			beanInformantes.modificarInformante(informanteVO);

		} catch(Q02bAplicException ex1){	 		  

	          java.io.StringWriter sw = new java.io.StringWriter();

	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	          ex1.printStackTrace(pw);

	          tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarInformante: " + sw.getBuffer ().toString());

	          throw ex1;       	

		}catch(Exception ex){	 	

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarInformante: " + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally{    	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarInformante: saliendo.");

	   		}

	 	}

	}//fin modificarInformante

	

	

	/**

	 * Borra un informante de la bbdd

	 * @param idInformante - String nmero interno del informante

	 * @param autenticador - Q02bAutenticador Autenticador

	 * @throws Exception

	 */

	public void borrarInformante(String idInformante, Q02bAutenticador autenticador) throws Exception 

	{		

		try{

			if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarInformante: entrando.");

	   		}		

			

			beanInformantes= new Q02bInformantesBean();

			beanInformantes.setAutenticador(autenticador);

			

			beanInformantes.borrarInformante(idInformante);

		} catch(Q02bAplicException ex1){	 		  

	          java.io.StringWriter sw = new java.io.StringWriter();

	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	          ex1.printStackTrace(pw);

	          tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarInformante: " + sw.getBuffer ().toString());

	          throw ex1;       	

		}catch(Exception ex){	 	

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarInformante: " + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally{    	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarInformante: saliendo.");

	   		}

	 	}

	}//fin borrarInformante

	

	



	// --------------------------------------------------------------------------

	// ---------- FIN INFORMANTES -----------

	// ---------------------------------------------------------------------------



} // fin clase

