package q02bCuestionariosSMAnuSesionEJB;



import java.rmi.RemoteException;

import java.util.ArrayList;

import java.util.HashMap;

import java.util.Vector;



import javax.ejb.CreateException;

import javax.ejb.EJBException;

import javax.ejb.SessionBean;



import q02b.exe.comun.Q02bAplicException;

import q02b.exe.comun.Q02bAutenticador;

import q02b.exe.cuestionariosSMAnu.beans.Q02bCuestionariosSMBean;

import q02b.exe.cuestionariosSMAnu.valueobjects.Q02bCuestionarioSM;

import q02b.exe.cuestionariosSMAnu.valueobjects.Q02bCuestionarioSMFiltro;

import q02b.exe.utils.Q02bVoUtils;

import q02b.exe.utils.Q02bFormatData;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;





import org.w3c.dom.Document;

 

/**

 * XDoclet-based session bean.  The class must be declared

 * public according to the EJB specification.

 *

 * To generate the EJB related files to this EJB:

 *		- Add Standard EJB module to XDoclet project properties

 *		- Customize XDoclet configuration for your appserver

 *		- Run XDoclet

 *

 * Below are the xdoclet-related tags needed for this EJB.

 * 

 * @ejb.bean name="Q02bCuestionariosSMAnuSesion"

 *           display-name="Name for Q02bCuestionariosSMAnuSesion"

 *           description="Description for Q02bCuestionariosSMAnuSesion"

 *           jndi-name="ejb/Q02bCuestionariosSMAnuSesion"

 *           type="Stateless"

 *           view-type="remote"

 */

  



public class Q02bCuestionariosSMAnuSesionBean implements SessionBean {



	

	private static final long serialVersionUID = 4131248384461301469L;

	private static Q70Traza tr = Q70Traza.getSingleton();

	private static final String COMPONENTE = "EJB_SESION_DATOS";

	protected Q02bCuestionariosSMBean beanCuestionarioSMAnu= null;

	

	/** The session context */

	private javax.ejb.SessionContext mySessionCtx;



	 

	

	public Q02bCuestionariosSMAnuSesionBean() {

		super();

		// TODO Auto-generated constructor stub

	}

	/**

	 * Set the associated session context. The container calls this method 

	 * after the instance creation.

	 * 

	 * The enterprise bean instance should store the reference to the context 

	 * object in an instance variable.

	 * 

	 * This method is called with no transaction context. 

	 * 

	 * @throws EJBException Thrown if method fails due to system-level error.

	 */

	/**

	 * getSessionContext

	 */

	public javax.ejb.SessionContext getSessionContext() {

		return mySessionCtx;

	}

	/**

	 * setSessionContext

	 */

	public void setSessionContext(javax.ejb.SessionContext ctx) {

		mySessionCtx = ctx;

	}



	public void ejbRemove() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	public void ejbActivate() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	public void ejbPassivate() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	/**

	 * An ejbCreate method as required by the EJB specification.

	 * 

	 * The container calls the instance?s <code>ejbCreate</code> method whose

	 * signature matches the signature of the <code>create</code> method invoked

	 * by the client. The input parameters sent from the client are passed to

	 * the <code>ejbCreate</code> method. Each session bean class must have at

	 * least one <code>ejbCreate</code> method. The number and signatures

	 * of a session bean?s <code>create</code> methods are specific to each 

	 * session bean class.

	 * 

	 * @throws CreateException Thrown if method fails due to system-level error.

	 * 

	 * @ejb.create-method

	 * 

	 */

	public void ejbCreate() throws CreateException {

		// TODO Add ejbCreate method implementation

	}  

	// -------------------------------------------------------------------------------------------------

	// ---------- CUESTIONARIOS SUELO MUNICIPAL  ----------

	// -------------------------------------------------------------------------------------------------



	/**

	 * Insertar en bbdd un  nuevo cuestionario con los datos pasados como parmetro en la HashMap

	 */

	public String insertarCuestionarioSM(HashMap mapaCuestionarioSM, HashMap mapaFiltroPortadaCuestionarioSM) throws Exception 

	{

		String niGrupoCuesSM = null;

		try {

			if (tr.isTraceActive()){     

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarCuestionarioSMAnu: entrando");

				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaCuestionarioSMAnu : " + mapaCuestionarioSM.toString());

			}

			//se instancia el bean de negocio

	  		beanCuestionarioSMAnu= new Q02bCuestionariosSMBean();

	  		//Llamamos al mtodo del bean

	  		niGrupoCuesSM=beanCuestionarioSMAnu.insertarCuestionarioSM(mapaCuestionarioSM, mapaFiltroPortadaCuestionarioSM);

	  		//Devolvemos el id del grupo

	  		return niGrupoCuesSM;			

	     }catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw); 

            if (tr.isTraceActive()){  

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarCuestionarioSMAnu: " + sw.getBuffer ().toString());

			}

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

					tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarCuestionarioSMAnu: saliendo");

			}			

		}

	} // fin insertarCuestionarioSM

	/**

	 * Borrar de bbdd un cuestionario

	 * 

	 * @param niCuestionarioSMAnu - Nmero interno del cuestionario a borrar

	 *

	 */

	public void borrarCuestionarioSMAnu(String niCuestionarioSMAnu,String niGrupoCuestionarioSMAnu) throws Exception

	{

		try {

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarCuestionarioSMAnu: entrando con cuestionario: " + niCuestionarioSMAnu);

			}

			beanCuestionarioSMAnu= new Q02bCuestionariosSMBean();

			//se pasa el autenticador

	  		//beanCuestionarioSMAnu.setAutenticador(autenticador);

	  		//se llama al mtodo del bean necesario

			beanCuestionarioSMAnu.borrarCuestionarioSMAnu(niCuestionarioSMAnu,niGrupoCuestionarioSMAnu);			

	     }catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarCuestionarioSMAnu: " + sw.getBuffer ().toString());

			}

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarCuestionarioSMAnu: saliendo");

			 }	

		 }			 

		 

	} // fin borrarCuestionarioSMAnu

	/**

	 * Modificar en bbdd un cuestionario con los datos pasados como parmetro en la HashMap

	 */

	public void modificarCuestionarioSMAnu(HashMap mapaCuestionarioSMAnu) throws Exception

	{

		Q02bCuestionarioSM cuestionarioSMAnu = null;	  	

		try {

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarCuestionarioSMAnu: entrando");

				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaCuestionarioSMAnu : " + mapaCuestionarioSMAnu.toString());

			}			

			//se pasa el hashmap de entrada a un objeto de tipo Q02bCuestionarioSMAnu

			cuestionarioSMAnu = (Q02bCuestionarioSM) Q02bVoUtils.getValueObject(mapaCuestionarioSMAnu,"q02b.exe.cuestionariosSMAnu.valueobjects.Q02bCuestionarioSM");

			

			beanCuestionarioSMAnu= new Q02bCuestionariosSMBean();

			//se pasa el autenticador

	  		//beanCuestionarioSMAnu.setAutenticador(autenticador);

			//se llama al metodo del bean para modificar el contacto

			beanCuestionarioSMAnu.modificarCuestionarioSMAnu(cuestionarioSMAnu);			

		}catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarCuestionarioSMAnu: " + sw.getBuffer ().toString());

			}

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarCuestionarioSMAnu: saliendo");

			 }

		 }		

	} // fin modificarCuestionarioSMAnu



	

	/**

	/**

     * Mtodo que dado el nmero interno del cuestionario recuperara de la BBDD

     * los datos de dicho cuestionario

     * @param niCuestionarioSMAnu

     * @return cuestionarioSMAnu

     */

	 

	public HashMap obtenerCuestionarioSMAnu(String niCuestionarioSMAnu,String niGrupoCuestionarioSMAnu ) throws Exception 

	{		

		//Definicin de variables

		HashMap cuestionarioSMAnu =  new HashMap(); 

		Q02bCuestionarioSM cuestionarioSMAnuVO = new Q02bCuestionarioSM();

		try{

			if (tr.isTraceActive())

			{

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioSMAnu ejb-> ** niCuestionarioSMAnu=:" + niCuestionarioSMAnu + "  , niGrupoCuestionarioSMAnu = " + niGrupoCuestionarioSMAnu+ " ** entrando.");	   			

	   		}			

			beanCuestionarioSMAnu= new Q02bCuestionariosSMBean();

			//se pasa el autenticador

	  		//beanCuestionarioSMAnu.setAutenticador(autenticador);

	  		//se llama al mtodo del bean necesario			

	  		cuestionarioSMAnuVO = beanCuestionarioSMAnu.obtenerCuestionarioSMAnu(niCuestionarioSMAnu,niGrupoCuestionarioSMAnu);

	  		//se pasa el resultado a un hashMap

	  		cuestionarioSMAnu = (HashMap)Q02bVoUtils.getHashMap(cuestionarioSMAnuVO);

			return cuestionarioSMAnu;

		} catch(Q02bAplicException ex1){	 		  

	          java.io.StringWriter sw = new java.io.StringWriter();

	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	          ex1.printStackTrace(pw);

	          tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioSMAnu: " + sw.getBuffer ().toString());

	          throw ex1;       	

		}catch(Exception ex){	 	

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCuestionarioSMAnu: " + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally{    	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioSMAnu: saliendo.");

	   		}

	 	}

	}//fin obtenerCuestionarioSMAnu

	

	/**

	 * Obtener la lista de cuestionarios

	 * 

	 * 

	 * @return Devuelve la lista de cuestionarios



	 * 

	 * @throws Exception

	 */

	public ArrayList obtenerCuestionariosSM(HashMap mapaFiltroPortadaCuestionarioSM) throws Exception 

	{		

		ArrayList listaCuestionariosSM= new ArrayList(); 

		try{

			if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionariosSM: entrando.");

	   		}		

			beanCuestionarioSMAnu= new Q02bCuestionariosSMBean();

			listaCuestionariosSM = beanCuestionarioSMAnu.getCuestionariosSM(mapaFiltroPortadaCuestionarioSM);

			return listaCuestionariosSM;

		} catch(Q02bAplicException ex1){	 		  

	          java.io.StringWriter sw = new java.io.StringWriter();

	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	          ex1.printStackTrace(pw);

	          tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionariosSM: " + sw.getBuffer ().toString());

	          throw ex1;       	

		}catch(Exception ex){	 	

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCuestionariosSM: " + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally{    	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionariosSM: saliendo.");

	   		}

	 	}

	}//fin obtenerEntidades*/

	

	/**

	 * Insertar/Modifica en bbdd un  nuevo grupo de cuestionarios con los datos pasados como parmetro en la HashMap de filtro

	 */

	public String altaModifGrupoCuestionariosSMAnu(HashMap mapaCuestionarioSMAnuFiltro) throws Exception 

	{

		String niGrupoCuesSMAnu=null;	

		try {

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":altaModifGrupoCuestionariosSMAnu: entrando");

			}

			//se instancia el bean de negocio

	  		beanCuestionarioSMAnu= new Q02bCuestionariosSMBean();

	  		//Llamamos al mtodo del bean

	  		niGrupoCuesSMAnu=beanCuestionarioSMAnu.altaModifGrupoCuestionariosSMAnu(mapaCuestionarioSMAnuFiltro);

	  		

	  		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":altaModifGrupoCuestionariosSMAnu: niGrupoCuestionarioSMAnu="+ niGrupoCuesSMAnu);

			return niGrupoCuesSMAnu;			

	     }catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw); 

            if (tr.isTraceActive()){  

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":altaModifGrupoCuestionariosSMAnu: " + sw.getBuffer ().toString());

			}

            

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

					tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":altaModifGrupoCuestionariosSMAnu: saliendo");

			}			

		}

	} // fin altaModifGrupoCuestionariosSMAnu

	

	

	/**

	     * Metodo que se encarga de devolver un XML con los datos principales de los cuestionarios a firmar que no estn ya firmados.

	     * @param ArrayList ArrayList arrCuestionariosSMAnuFirma

	     * @throws Exception

	     */

	    public Document obtenerXmlFirmaCuestionariosSMAnu(ArrayList arrCuestionariosSMAnuFirma ) throws Exception{

	        final String TRACE_METODO = "Q02bCuestionariosSMAnuSesionBean:obtenerXmlFirmaCuestionariosSMAnu";

	        

	        //Variable que se va a devolver

	        Document document = null;

	        

	        if (tr.isTraceActive())

	        {

	            	tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO +": entrando");

	        }

	        

	        try{

		            //Se instancia el bean de negocio

		            beanCuestionarioSMAnu= new Q02bCuestionariosSMBean();

		            //Se obtiene la lista con los resultados

		            

		            tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO +": ArrayList ="+ (arrCuestionariosSMAnuFirma==null?"Es nulo":Integer.toString(arrCuestionariosSMAnuFirma.size())));

		            //document=beanCuestionarioSMAnu.obtenerXmlFirmaCuestionariosSMAnu(arrCuestionariosSMAnuFirma);

		            //Se devuelve el objeto

		            return document;

	        }catch (Exception ex) 

	        {

		            java.io.StringWriter sw = new java.io.StringWriter();

		            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

		            ex.printStackTrace(pw);

		            tr.trace(COMPONENTE, Q70TraceLevel.ERROR,

		            TRACE_METODO + sw.getBuffer().toString());

	            throw ex;

	        } finally {

	            if (tr.isTraceActive()) {

	                tr.trace(COMPONENTE, Q70TraceLevel.INFO,

	                		TRACE_METODO + " saliendo.");

	            }

	        }

	    }

	    

	   public void guardarFirmaGrupoCuestionariosSMAnu(String niGrupoCuesSMAnu,String xmlFirmaGrupoCuestionariosSMAnu ) throws Exception

	    {  	

		try {

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":guardarFirmaGrupoCuestionariosSMAnu: entrando");

			}			

			

			beanCuestionarioSMAnu= new Q02bCuestionariosSMBean();

			//se pasa el autenticador

	  		//beanCuestionarioSMAnu.setAutenticador(autenticador);

			//se llama al metodo del bean para modificar el contacto

			beanCuestionarioSMAnu.guardarFirmaGrupoCuestionariosSMAnu(niGrupoCuesSMAnu,xmlFirmaGrupoCuestionariosSMAnu);

		}

		catch(Exception ex)

		{

            			java.io.StringWriter sw = new java.io.StringWriter();

            			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            			ex.printStackTrace(pw);

            			if (tr.isTraceActive())

            			{

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":guardarFirmaGrupoCuestionariosSMAnu: " + sw.getBuffer ().toString());

			}

            			throw ex;

		 }finally

		 {

			 if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":guardarFirmaGrupoCuestionariosSMAnu: saliendo");

			 }

		 }		

	} // fin guardarFirmaGrupoCuestionariosSMAnu



	

	// --------------------------------------------------------------------------

	// ---------- FIN CUESTIONARIOS SM ANU -----------

	// ---------------------------------------------------------------------------



} // fin clase

