package q02bCuestionarioVAPMSesionEJB;



import java.rmi.RemoteException;

import java.util.ArrayList;

import java.util.HashMap;



import javax.ejb.CreateException;

import javax.ejb.EJBException;

import javax.ejb.SessionBean;



import q02b.exe.comun.Q02bAplicException;

import q02b.exe.comun.Q02bAutenticador;

import q02b.exe.cuestionarioVAPM.beans.Q02bCuestionarioVAPMBean;

import q02b.exe.cuestionarioVAPM.valueobjects.Q02bCuestionarioVAPM;

import q02b.exe.cuestionarioVAPM.valueobjects.Q02bCuestionarioVAPMFiltro;

import q02b.exe.cuestionariosSMAnu.beans.Q02bCuestionariosSMBean;

import q02b.exe.cuestionariosSMAnu.valueobjects.Q02bCuestionarioSM;

import q02b.exe.cuestionariosVTMAnu.beans.Q02bCuestionariosVTMAnuBean;

import q02b.exe.cuestionariosVTMAnu.valueobjects.Q02bCuestionarioVTMAnu;

import q02b.exe.cuestionariosVTMAnu.valueobjects.Q02bCuestionarioVTMAnuFiltro;

import q02b.exe.utils.Q02bFormatData;

import q02b.exe.utils.Q02bVoUtils;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;

import org.w3c.dom.Document;

 

/**

 * XDoclet-based session bean.  The class must be declared

 * public according to the EJB specification.

 *

 * To generate the EJB related files to this EJB:

 *		- Add Standard EJB module to XDoclet project properties

 *		- Customize XDoclet configuration for your appserver

 *		- Run XDoclet

 *

 * Below are the xdoclet-related tags needed for this EJB.

 * 

 * @ejb.bean name="Q02bCuestionariosSMAnuSesion"

 *           display-name="Name for Q02bCuestionariosSMAnuSesion"

 *           description="Description for Q02bCuestionariosSMAnuSesion"

 *           jndi-name="ejb/Q02bCuestionariosSMAnuSesion"

 *           type="Stateless"

 *           view-type="remote"

 */

  



public class Q02bCuestionarioVAPMSesionBean implements SessionBean {



	

	private static final long serialVersionUID = 4131248384461301469L;

	private static Q70Traza tr = Q70Traza.getSingleton();

	private static final String COMPONENTE = "EJB_SESION_DATOS";

	protected Q02bCuestionarioVAPMBean beanCuestionarioVAPM= null;

	private static final String Aitziber = "Aitziber";

	

	/** The session context */

	private javax.ejb.SessionContext mySessionCtx;



	 

	

	public Q02bCuestionarioVAPMSesionBean() {

		super();

		// TODO Auto-generated constructor stub

	}

	/**

	 * Set the associated session context. The container calls this method 

	 * after the instance creation.

	 * 

	 * The enterprise bean instance should store the reference to the context 

	 * object in an instance variable.

	 * 

	 * This method is called with no transaction context. 

	 * 

	 * @throws EJBException Thrown if method fails due to system-level error.

	 */

	/**

	 * getSessionContext

	 */

	public javax.ejb.SessionContext getSessionContext() {

		return mySessionCtx;

	}

	/**

	 * setSessionContext

	 */

	public void setSessionContext(javax.ejb.SessionContext ctx) {

		mySessionCtx = ctx;

	}



	public void ejbRemove() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	public void ejbActivate() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	public void ejbPassivate() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	/**

	 * An ejbCreate method as required by the EJB specification.

	 * 

	 * The container calls the instance?s <code>ejbCreate</code> method whose

	 * signature matches the signature of the <code>create</code> method invoked

	 * by the client. The input parameters sent from the client are passed to

	 * the <code>ejbCreate</code> method. Each session bean class must have at

	 * least one <code>ejbCreate</code> method. The number and signatures

	 * of a session bean?s <code>create</code> methods are specific to each 

	 * session bean class.

	 * 

	 * @throws CreateException Thrown if method fails due to system-level error.

	 * 

	 * @ejb.create-method

	 * 

	 */

	public void ejbCreate() throws CreateException {

		// TODO Add ejbCreate method implementation

	}  

	// -------------------------------------------------------------------------------------------------

	// ---------- CUESTIONARIOS VAPM  ----------

	// -------------------------------------------------------------------------------------------------



	

	/**

	 * Obtener la lista de cuestionarios

	 * 

	 * 

	 * @return Devuelve la lista de cuestionarios



	 * 

	 * @throws Exception

	 */

	public HashMap obtenerCuestionarioVAPM(String niCuesVAPM, HashMap mapaFiltroCuesVAPM, Q02bAutenticador autenticador) throws Exception 

	{		

		//Definicin de variables			 

		

		Q02bCuestionarioVAPM cuestionarioVAPM= new Q02bCuestionarioVAPM();

		Q02bCuestionarioVAPMFiltro cuestionarioFiltroVAPM = null;

		HashMap mapaCuestionarioVAPM = new HashMap();

		

		try{

			if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioVAPM: entrando.");

	   			

	   		}

			cuestionarioFiltroVAPM = (Q02bCuestionarioVAPMFiltro) Q02bVoUtils.getValueObject(mapaFiltroCuesVAPM,"q02b.exe.cuestionarioVAPM.valueobjects.Q02bCuestionarioVAPMFiltro");

			beanCuestionarioVAPM= new Q02bCuestionarioVAPMBean();

			beanCuestionarioVAPM.setAutenticador(autenticador);

			cuestionarioVAPM = beanCuestionarioVAPM.altaModifCuestionarioVAPM(niCuesVAPM,cuestionarioFiltroVAPM);			

			mapaCuestionarioVAPM = (HashMap)Q02bVoUtils.getHashMap(cuestionarioVAPM);

			return mapaCuestionarioVAPM;

		} catch(Q02bAplicException ex1){	 		  

	          java.io.StringWriter sw = new java.io.StringWriter();

	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	          ex1.printStackTrace(pw);

	          tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioVAPM: " + sw.getBuffer ().toString());

	          throw ex1;       	

		}catch(Exception ex){	 	

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCuestionarioVAPM: " + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally{    	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioVAPM: saliendo.");

	   		}

	 	}

	}//fin obtenerCuestionario*/

	

	/**

	 * Modificar en bbdd un cuestionario con los datos pasados como parmetro en la HashMap

	 */

	public String guardarCuestionarioVAPM(HashMap mapaFiltroPortadaCuestionarioVAPM, HashMap mapaCuestionarioVAPM, Q02bAutenticador autenticador) throws Exception

	{

		String niCuestionarioVAPM = "";

		Q02bCuestionarioVAPM cuestionarioVAPM = null;

		Q02bCuestionarioVAPMFiltro cuestionarioVAPMFiltroPortada = null;		

		try {

			

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":guardarCuestionarioVAPM: entrando");

				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaCuestionarioVAPM : " + mapaCuestionarioVAPM.toString());

			}

			//se pasa el hashmap de entrada a un objeto de tipo Q02bCuestionarioVTMAnu	

			

			cuestionarioVAPM = (Q02bCuestionarioVAPM) Q02bVoUtils.getValueObject(mapaCuestionarioVAPM,"q02b.exe.cuestionarioVAPM.valueobjects.Q02bCuestionarioVAPM");

			

			//se instancia el bean de negocio

	  		beanCuestionarioVAPM= new Q02bCuestionarioVAPMBean();

	  		//se pasa el autenticador

	  		beanCuestionarioVAPM.setAutenticador(autenticador);

	  		

	  		//En caso de que vengamos de la portada, el campo niGrupoVTMAnu del mapa no va a tener ningn valor

	  		//Puede que est en el contexto (en caso de que estemos haciendo altas para los mismo parmetros de portada)

	  		//o  no, en cuyo caso lo tendremos que obtener

	  		cuestionarioVAPMFiltroPortada = (Q02bCuestionarioVAPMFiltro) Q02bVoUtils.getValueObject(mapaFiltroPortadaCuestionarioVAPM,"q02b.exe.cuestionarioVAPM.valueobjects.Q02bCuestionarioVAPMFiltro");

	  		String ano = cuestionarioVAPMFiltroPortada.getAno();

			String codMunicip = cuestionarioVAPMFiltroPortada.getCodMuni();

			String concedeLicen = cuestionarioVAPMFiltroPortada.getConcedidoLicen();

			String codProv = cuestionarioVAPMFiltroPortada.getCodProv();

	  		if(Q02bFormatData.esNullSinCero(cuestionarioVAPM.getNiCuesVAPM()).equals("")){ 	  			

	  			niCuestionarioVAPM = beanCuestionarioVAPM.altaModifGrupoCuestionariosVAPM(cuestionarioVAPMFiltroPortada);

	  			cuestionarioVAPM.setNiCuesVAPM(niCuestionarioVAPM);

	  		}

	  		else

	  		{

	  			niCuestionarioVAPM = cuestionarioVAPM.getNiCuesVAPM();

	  		}

	  			//se llama al mtodo del bean necesario

	  		beanCuestionarioVAPM.modificarCuestionarioVAPM(cuestionarioVAPM,ano,codMunicip,concedeLicen,codProv,niCuestionarioVAPM);

	  		

			return niCuestionarioVAPM;			

	     }catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw); 

            if (tr.isTraceActive()){  

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarCuestionarioVTMAnu: " + sw.getBuffer ().toString());

			}

            

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

					tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarCuestionarioVTMAnu: saliendo");

			}			

		}

	} // fin modificarCuestionarioVAPM

	

	/**

	 * Obtener la lista de cuestionarios

	 * 

	 * 

	 * @return Devuelve la lista de cuestionarios



	 * 

	 * @throws Exception

	 */

	public String obtenerNiCuesVAPM(HashMap mapaFiltroCuestionarioVAPM, Q02bAutenticador autenticador) throws Exception 

	{		

		//Definicin de variables			 

		

		String niCuesVAPM = null;

		Q02bCuestionarioVAPMFiltro cuestionarioVAPMFiltro = null;

		

		

		try{

			if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerNiCuesVAPM: entrando.");

	   			//tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaFiltroEntidad : " + mapaFiltroEntidad.toString());

	   		}			

			beanCuestionarioVAPM= new Q02bCuestionarioVAPMBean();

			//se pasa el autenticador

	  		beanCuestionarioVAPM.setAutenticador(autenticador);

			cuestionarioVAPMFiltro = (Q02bCuestionarioVAPMFiltro) Q02bVoUtils.getValueObject(mapaFiltroCuestionarioVAPM,"q02b.exe.cuestionarioVAPM.valueobjects.Q02bCuestionarioVAPMFiltro");

			

			String ano = cuestionarioVAPMFiltro.getAno();

			String concedeLicen = cuestionarioVAPMFiltro.getConcedidoLicen();			

			String codMunicipio = cuestionarioVAPMFiltro.getCodMuni();

			String municipio = cuestionarioVAPMFiltro.getMunicipio();

			String codProv = cuestionarioVAPMFiltro.getCodProv();

			niCuesVAPM = beanCuestionarioVAPM.obtenerNiCuesVAPM(cuestionarioVAPMFiltro);

			return niCuesVAPM;

		} catch(Q02bAplicException ex1){	 		  

	          java.io.StringWriter sw = new java.io.StringWriter();

	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	          ex1.printStackTrace(pw);

	          tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerNiCuesVAPM: " + sw.getBuffer ().toString());

	          throw ex1;       	

		}catch(Exception ex){	 	

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerNiCuesVAPM: " + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally{    	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerNiCuesVAPM: saliendo.");

	   		}

	 	}

	}//fin obtenerNiCuesVAPM*/

	

	/**

	 * Insertar/Modifica en bbdd un  nuevo grupo de cuestionarios con los datos pasados como parmetro en la HashMap de filtro

	 */

	public String altaModifGrupoCuestionariosVAPM(HashMap mapaFiltroCuestionarioVAPM, Q02bAutenticador autenticador) throws Exception 

	{

		Q02bCuestionarioVAPMFiltro cuestionarioVAPMFiltro = null;

		String niCuesVAPM=null;	  		

		try {

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":altaModifGrupoCuestionariosVAPM: entrando");

			}

			//se pasa el hashmap de entrada a un objeto de tipo Q02bCuestionarioVTMAnu	  		

			cuestionarioVAPMFiltro = (Q02bCuestionarioVAPMFiltro) Q02bVoUtils.getValueObject(mapaFiltroCuestionarioVAPM,"q02b.exe.cuestionarioVAPM.valueobjects.Q02bCuestionarioVAPMFiltro");

			//se instancia el bean de negocio

			beanCuestionarioVAPM= new Q02bCuestionarioVAPMBean();

	  		//se pasa el autenticador

	  		beanCuestionarioVAPM.setAutenticador(autenticador);

	  		//se llama al mtodo del bean necesario

			niCuesVAPM=beanCuestionarioVAPM.altaModifGrupoCuestionariosVAPM(cuestionarioVAPMFiltro);

	  		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":altaModifGrupoCuestionariosVAPM: niGrupoCuestionarioVTMAnu="+ niCuesVAPM);

			return niCuesVAPM;			

	     }catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw); 

            if (tr.isTraceActive()){  

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":altaModifGrupoCuestionariosVAPM: " + sw.getBuffer ().toString());

			}

            

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

					tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":altaModifGrupoCuestionariosVAPM: saliendo");

			}			

		}

	} // fin altaModifGrupoCuestionariosVTMAnu



	/**

	 * Obtener la lista de cuestionarios

	 * 

	 * 

	 * @return Devuelve la lista de cuestionarios



	 * 

	 * @throws Exception

	 */

	public ArrayList obtenerCuestionariosVAPM(HashMap mapaFiltroPortadaCuestionarioVAPM, Q02bAutenticador autenticador) throws Exception 

	{		

		ArrayList listaCuestionariosVAPM= new ArrayList(); 

		try{

			if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionariosVAPM: entrando.");

	   		}		

			beanCuestionarioVAPM= new Q02bCuestionarioVAPMBean();

			beanCuestionarioVAPM.setAutenticador(autenticador);

			listaCuestionariosVAPM = beanCuestionarioVAPM.getCuestionariosVAPM(mapaFiltroPortadaCuestionarioVAPM);

			return listaCuestionariosVAPM;

		} catch(Q02bAplicException ex1){	 		  

	          java.io.StringWriter sw = new java.io.StringWriter();

	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	          ex1.printStackTrace(pw);

	          tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionariosVAPM: " + sw.getBuffer ().toString());

	          throw ex1;       	

		}catch(Exception ex){	 	

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCuestionariosVAPM: " + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally{    	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionariosVAPM: saliendo.");

	   		}

	 	}

	}//fin obtenerCuestionariosVAPM*/

	

	/**

	 * Modificar en bbdd un cuestionario con los datos pasados como parmetro en la HashMap

	 */

	public void modificarCuestionarioVAPM(String niCuesVAPM, HashMap mapaCuestionarioVAPM, Q02bAutenticador autenticador) throws Exception

	{

		Q02bCuestionarioVAPM cuestionarioVAPM = null;	  	

		try {

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarCuestionarioVAPM: entrando");

				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaCuestionarioSMAnu : " + mapaCuestionarioVAPM.toString());

			}			

			//se pasa el hashmap de entrada a un objeto de tipo Q02bCuestionarioVAPM

			cuestionarioVAPM = (Q02bCuestionarioVAPM) Q02bVoUtils.getValueObject(mapaCuestionarioVAPM,"q02b.exe.cuestionarioVAPM.valueobjects.Q02bCuestionarioVAPM");

			

			beanCuestionarioVAPM= new Q02bCuestionarioVAPMBean();

			//se pasa el autenticador

	  		beanCuestionarioVAPM.setAutenticador(autenticador);

			//se llama al metodo del bean para modificar el contacto

			beanCuestionarioVAPM.modificarCuestionarioVAPM(niCuesVAPM, cuestionarioVAPM);			

		}catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarCuestionarioVAPM: " + sw.getBuffer ().toString());

			}

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarCuestionarioVAPM: saliendo");

			 }

		 }		

	} // fin modificarCuestionarioVAPM

	

	/**

     * Mtodo que dado el nmero interno del cuestionario recuperara de la BBDD

     * los datos de dicho cuestionario

     * @param niCuestionarioVAPM

     * @return cuestionarioVAPM

     */

	 

	public HashMap obtenerCuestionarioSeleccionadoVAPM(String niCuestionarioVAPM, Q02bAutenticador autenticador) throws Exception 

	{		

		//Definicin de variables

		HashMap cuestionarioVAPM =  new HashMap(); 

		Q02bCuestionarioVAPM cuestionarioVAPMVO = new Q02bCuestionarioVAPM();

		try{

			if (tr.isTraceActive())

			{

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioVAPM ejb-> ** niCuestionarioVTMAnu=:" + niCuestionarioVAPM );	   			

	   		}			

			beanCuestionarioVAPM= new Q02bCuestionarioVAPMBean();

			//se pasa el autenticador

	  		beanCuestionarioVAPM.setAutenticador(autenticador);

	  		//se llama al mtodo del bean necesario			

	  		cuestionarioVAPMVO = beanCuestionarioVAPM.obtenerCuestionarioSeleccionadoVAPM(niCuestionarioVAPM);

	  		//se pasa el resultado a un hashMap

	  		cuestionarioVAPM = (HashMap)Q02bVoUtils.getHashMap(cuestionarioVAPMVO);

			return cuestionarioVAPM;

		} catch(Q02bAplicException ex1){	 		  

	          java.io.StringWriter sw = new java.io.StringWriter();

	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	          ex1.printStackTrace(pw);

	          tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioVAPM: " + sw.getBuffer ().toString());

	          throw ex1;       	

		}catch(Exception ex){	 	

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCuestionarioVAPM: " + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally{    	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioVAPM: saliendo.");

	   		}

	 	}

	}//fin obtenerCuestionarioVAPM

	

	/**

	 * Borrar de bbdd un cuestionario

	 * 

	 * @param niCuestionarioVAPM - Nmero interno del cuestionario a borrar

	 *

	 */

	public void borrarCuestionarioVAPM(String niCuestionarioVAPM, Q02bAutenticador autenticador) throws Exception

	{

		try {

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarCuestionarioVAPM: entrando con cuestionario: " + niCuestionarioVAPM);

			}

			beanCuestionarioVAPM= new Q02bCuestionarioVAPMBean();

			//se pasa el autenticador

	  		beanCuestionarioVAPM.setAutenticador(autenticador);

	  		//se llama al mtodo del bean necesario

			beanCuestionarioVAPM.borrarCuestionarioVAPM(niCuestionarioVAPM);			

	     }catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarCuestionarioVAPM: " + sw.getBuffer ().toString());

			}

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarCuestionarioVAPM: saliendo");

			 }	

		 }			 

		 

	} // fin borrarCuestionarioVAPM

	

	

	

} // fin clase

