 // Fecha: 22-09-00; Autores: Josu Orbe & Leire Uriarte 



package q02b.exe.utils.informes.excel;



import org.apache.poi.hssf.usermodel.*;

import org.apache.poi.hssf.util.HSSFColor;

import org.apache.poi.hssf.util.Region;



import q02b.exe.utils.Q02bConstantes;

import es.ejie.frmk.listeners.base.Q70ListenerUtils;





/**

 *  Clase con funciones para formateo y adecuacin de los datos

*/

public class Q02bDocumentoExcel {



    HSSFWorkbook documento 					= null;

    HSSFSheet hoja 							= null;    

    HSSFCell celdaActual 					= null;

    //HSSFCellStyle estiloDocumento 		= null;

    HSSFCellStyle bordearTodo		 		= null;    

    HSSFCellStyle bordearMenosIzquierda 	= null;

    HSSFCellStyle bordearMenosDerecha 		= null;

    HSSFCellStyle bordearArribaAbajo 		= null;

    HSSFCellStyle bordearSuave		 		= null;

    HSSFFont titulo							= null;

    HSSFFont cabecera						= null;

    HSSFFont dato							= null;

    

     /** 

     *  Constructor para un documento vacio ( sin hojas)

     *  @param clavePlantilla cadena con la clave que hay que import a buscar a configuracin para obtener el path 

     * al documento excel (*.xsl) que sirve de plantilla para pintar encima de ella.

     * @exception DAOException cuando se produce un error en la creacin de la clase.

     */

    public Q02bDocumentoExcel( String clavePlantilla ) throws Exception{

    	//  /datos/Q02b/file/excel/ListadoPrueba.xls

        String rutaPlantilla =  Q70ListenerUtils.getApplicationProperty("Q02B_RUTA_FICHERO_EXCEL") + Q02bConstantes.getString(clavePlantilla);       

        this.documento = new HSSFWorkbook( new java.io.FileInputStream( rutaPlantilla ));

        //Crear estilos

        //this.estiloDocumento = documento.createCellStyle();

        

    	//Estilos de celdas

    	bordearTodo = documento.createCellStyle();

    	bordearTodo.setBorderBottom(HSSFCellStyle.BORDER_THICK);    	

    	bordearTodo.setBorderLeft(HSSFCellStyle.BORDER_THICK);     	

    	bordearTodo.setBorderRight(HSSFCellStyle.BORDER_THICK);    	

    	bordearTodo.setBorderTop(HSSFCellStyle.BORDER_THICK);

    	bordearTodo.setBottomBorderColor(HSSFColor.BLACK.index);

    	bordearTodo.setLeftBorderColor(HSSFColor.BLACK.index);

    	bordearTodo.setRightBorderColor(HSSFColor.BLACK.index);

    	bordearTodo.setTopBorderColor(HSSFColor.BLACK.index);    	    	       	

    	

    	bordearMenosIzquierda = documento.createCellStyle();

    	bordearMenosIzquierda.setBorderBottom(HSSFCellStyle.BORDER_THICK);

    	bordearMenosIzquierda.setBottomBorderColor(HSSFColor.BLACK.index);

    	bordearMenosIzquierda.setBorderLeft(HSSFCellStyle.BORDER_NONE);    	

    	bordearMenosIzquierda.setBorderRight(HSSFCellStyle.BORDER_THICK);

    	bordearMenosIzquierda.setRightBorderColor(HSSFColor.BLACK.index);

    	bordearMenosIzquierda.setBorderTop(HSSFCellStyle.BORDER_THICK);

    	bordearMenosIzquierda.setTopBorderColor(HSSFColor.BLACK.index);

    	

    	bordearMenosDerecha = documento.createCellStyle();

    	bordearMenosDerecha.setBorderBottom(HSSFCellStyle.BORDER_THICK);

    	bordearMenosDerecha.setBottomBorderColor(HSSFColor.BLACK.index);

    	bordearMenosDerecha.setBorderLeft(HSSFCellStyle.BORDER_THICK); 

    	bordearMenosDerecha.setLeftBorderColor(HSSFColor.BLACK.index);    	

    	bordearMenosDerecha.setBorderRight(HSSFCellStyle.BORDER_NONE);;

    	bordearMenosDerecha.setBorderTop(HSSFCellStyle.BORDER_THICK);

    	bordearMenosDerecha.setTopBorderColor(HSSFColor.BLACK.index);

    	

    	bordearArribaAbajo = documento.createCellStyle();

    	bordearArribaAbajo.setBorderBottom(HSSFCellStyle.BORDER_THICK);

    	bordearArribaAbajo.setBottomBorderColor(HSSFColor.BLACK.index);

    	bordearArribaAbajo.setBorderLeft(HSSFCellStyle.BORDER_NONE);    	

    	bordearArribaAbajo.setBorderRight(HSSFCellStyle.BORDER_NONE);;

    	bordearArribaAbajo.setBorderTop(HSSFCellStyle.BORDER_THICK);

    	bordearArribaAbajo.setTopBorderColor(HSSFColor.BLACK.index);

    	

    	bordearSuave = documento.createCellStyle();

    	bordearSuave.setBorderBottom(HSSFCellStyle.BORDER_THIN);    	

    	bordearSuave.setBorderLeft(HSSFCellStyle.BORDER_THIN);     	

    	bordearSuave.setBorderRight(HSSFCellStyle.BORDER_THIN);    	

    	bordearSuave.setBorderTop(HSSFCellStyle.BORDER_THIN);

    	bordearSuave.setBottomBorderColor(HSSFColor.BLACK.index);

    	bordearSuave.setLeftBorderColor(HSSFColor.BLACK.index);

    	bordearSuave.setRightBorderColor(HSSFColor.BLACK.index);

    	bordearSuave.setTopBorderColor(HSSFColor.BLACK.index);

    	

    }

    

    

      /**

     *  Constructor para un documento con una hoja.

     *  @param clavePlantilla cadena con la clave que hay que import a buscar a configuracin para obtener el path 

     *  @param nombreHoja cadena con el nombre de la hoja del documento.

     * @exception DAOException cuando se produce un error en la creacin de la clase.

     */

    public Q02bDocumentoExcel( String clavePlantilla, String nombreHoja ) throws Exception{

    	// /datos/Q02b/file/excel/ListadoPrueba.xls

    	//String plantilla = Q02bConstantes.getString(clavePlantilla);

    	String rutaPlantilla =  Q70ListenerUtils.getApplicationProperty("Q02B_RUTA_FICHERO_EXCEL") + Q02bConstantes.getString(clavePlantilla);

        this.documento = new HSSFWorkbook( new java.io.FileInputStream( rutaPlantilla ));

        this.obtenerHoja(nombreHoja); 

        

        //Crear estilos

        //this.estiloDocumento = documento.createCellStyle();

        

       	//Estilos

    	bordearTodo = documento.createCellStyle();

    	bordearTodo.setBorderBottom(HSSFCellStyle.BORDER_MEDIUM);/*    	

    	bordearTodo.setBorderLeft(HSSFCellStyle.BORDER_THICK);     	

    	bordearTodo.setBorderRight(HSSFCellStyle.BORDER_THICK);    	

    	bordearTodo.setBorderTop(HSSFCellStyle.BORDER_THICK);*/

    	bordearTodo.setBottomBorderColor(HSSFColor.BLUE.index);

/*    	bordearTodo.setLeftBorderColor(HSSFColor.BLACK.index);

    	bordearTodo.setRightBorderColor(HSSFColor.BLACK.index);

    	bordearTodo.setTopBorderColor(HSSFColor.BLACK.index);    	

    	bordearTodo.setFillBackgroundColor(HSSFColor.LIGHT_GREEN.index);

    	bordearTodo.setFillForegroundColor(HSSFColor.LIGHT_GREEN.index);

    	bordearTodo.setFillPattern((short)1);*/

    	bordearTodo.setAlignment(HSSFCellStyle.ALIGN_CENTER);

    	

    	bordearMenosIzquierda = documento.createCellStyle();

    	bordearMenosIzquierda.setBorderBottom(HSSFCellStyle.BORDER_THIN);

    	bordearMenosIzquierda.setBottomBorderColor(HSSFColor.BLUE.index);

    	/*bordearMenosIzquierda.setBorderLeft(HSSFCellStyle.BORDER_NONE);    	

    	bordearMenosIzquierda.setBorderRight(HSSFCellStyle.BORDER_THICK);

    	bordearMenosIzquierda.setRightBorderColor(HSSFColor.BLACK.index);

    	bordearMenosIzquierda.setBorderTop(HSSFCellStyle.BORDER_THICK);

    	bordearMenosIzquierda.setTopBorderColor(HSSFColor.BLACK.index);

    	*/bordearMenosIzquierda.setAlignment(HSSFCellStyle.ALIGN_CENTER);

    	    	    	    	

    	bordearMenosDerecha = documento.createCellStyle();

    	bordearMenosDerecha.setBorderBottom(HSSFCellStyle.BORDER_THIN);

    	bordearMenosDerecha.setBottomBorderColor(HSSFColor.BLUE.index);

    	/*bordearMenosDerecha.setBorderLeft(HSSFCellStyle.BORDER_THICK); 

    	bordearMenosDerecha.setLeftBorderColor(HSSFColor.BLACK.index);    	

    	bordearMenosDerecha.setBorderRight(HSSFCellStyle.BORDER_NONE);;

    	bordearMenosDerecha.setBorderTop(HSSFCellStyle.BORDER_THICK);

    	*/bordearMenosDerecha.setTopBorderColor(HSSFColor.BLACK.index);

    	bordearMenosDerecha.setAlignment(HSSFCellStyle.ALIGN_CENTER);

    	

    	bordearArribaAbajo = documento.createCellStyle();

    	bordearArribaAbajo.setBorderBottom(HSSFCellStyle.BORDER_THIN);

    	bordearArribaAbajo.setBottomBorderColor(HSSFColor.BLUE.index);

    	/*bordearArribaAbajo.setBorderLeft(HSSFCellStyle.BORDER_NONE);    	

    	bordearArribaAbajo.setBorderRight(HSSFCellStyle.BORDER_NONE);;

    	bordearArribaAbajo.setBorderTop(HSSFCellStyle.BORDER_THICK);

    	bordearArribaAbajo.setTopBorderColor(HSSFColor.BLACK.index);      

    	*/bordearArribaAbajo.setAlignment(HSSFCellStyle.ALIGN_CENTER);

    	

    	bordearSuave = documento.createCellStyle();

    	bordearSuave.setBorderBottom(HSSFCellStyle.BORDER_THIN);    	

    	bordearSuave.setBorderLeft(HSSFCellStyle.BORDER_THIN);     	

    	bordearSuave.setBorderRight(HSSFCellStyle.BORDER_THIN);    	

    	bordearSuave.setBorderTop(HSSFCellStyle.BORDER_THIN);

    	bordearSuave.setBottomBorderColor(HSSFColor.GREY_25_PERCENT.index);

    	bordearSuave.setLeftBorderColor(HSSFColor.GREY_25_PERCENT.index);

    	bordearSuave.setRightBorderColor(HSSFColor.GREY_25_PERCENT.index);

    	bordearSuave.setTopBorderColor(HSSFColor.GREY_25_PERCENT.index);    

    	

    	//Fuentes

    	titulo = documento.createFont();

    	titulo.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);

    	titulo.setColor(HSSFColor.BLUE.index);

    	titulo.setFontHeightInPoints((short)16);    	  

    	

    	cabecera = documento.createFont();

    	cabecera.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);

    	cabecera.setColor(HSSFColor.BLUE.index);

    	cabecera.setFontHeightInPoints((short)12);



    	dato = documento.createFont();

    	dato.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);

    	dato.setColor(HSSFColor.BLUE.index);

    	dato.setFontHeightInPoints((short)12);

    }

    

    

     /**

     *  Mtodo que devuelve el objeto HSSFWorkbook que modeliza el documento Excel para poder trabajar directamente con l.

     * @return HSSFWorkbook que modeliza el documento Excel.

     */

    public HSSFWorkbook obtenerDocumento(){

        return this.documento;

    }

    

    

      /**

     *  Mtodo que crea una hoja en el documento.

     *  @param nombreHoja cadena con el nombre de la hoja que se desea crear en el documento.

     * @exception DAOException cuando se produce un error en la creacin de la clase.

     */

    public void obtenerHoja( String nombreHoja) throws Exception{

        //CREAMOS LA HOJA

        hoja = this.documento.getSheet(nombreHoja);

        if ( hoja == null){

            hoja = this.documento.createSheet(nombreHoja);

        }        

    }

   

        

      /**

     *  Mtodo que borra una hoja en el documento.

     *  @param nombreHoja cadena con el nombre de la hoja que se desea borrar en el documento.

     * @exception DAOException cuando se produce un error en la creacin de la clase.

     */

    public void borrarHoja( String nombreHoja) throws Exception{        

        int index  = this.documento.getSheetIndex(nombreHoja);

        this.documento.removeSheetAt(index);        

        

    }

    

    

    /**

     *  Mtodo que obtiene un valor en una celda concreta del documento.

     *  @param numeroFila nmero de la fila de la posicind de la celda.

      *@param numeroColumna nmero de la columna de la posicind de la celda.

      *@return  valor que se obtiene de la celda.

     * @exception DAOException cuando se produce un error en la creacin de la clase.

     */

    public String obtenerValorCelda(int numeroFila, int numeroColumna) throws Exception{

        //definimos las varibles

        HSSFRow fila = null;

        HSSFCell celda = null;

        //obtenerHoja(nombreHoja);

        //HSSFCellStyle cellStyleListado = this.documento.createCellStyle();

         //FILA X

        fila = this.hoja.getRow( (short)numeroFila);

        if ( fila == null ){

            fila = this.hoja.createRow((short)numeroFila );

        }

        //CELDA 0  --> VALOR DE COMPRA

        celda = fila.getCell( (short)numeroColumna );

        if ( celda == null ){

            celda = fila.createCell( (short)numeroColumna );

        }  

        

        int tipoCelda = celda.getCellType();

        String valorCelda = "";

        if(tipoCelda == 0){

            Double valorCeldaEntero = new Double(celda.getNumericCellValue());

            Integer val = new Integer(valorCeldaEntero.intValue());

            valorCelda = new String(val.toString());

            

        }else{

            valorCelda = celda.getStringCellValue();

        }

        

                                    

        return valorCelda;

    }

    

    

     /**

     *  Mtodo que escribe un valor en una celda concreta del documento.

     *  @param numeroFila nmero de la fila de la posicind de la celda.

      *@param numeroColumna nmero de la columna de la posicind de la celda.

      *@param valor  valor que se desea escribir en la celda.

     * @exception DAOException cuando se produce un error en la creacin de la clase.

     */

    public void escribirCelda( int numeroFila, int numeroColumna, String valor) throws Exception{

        //definimos las varibles

        HSSFRow fila = null;

        HSSFCell celda = null;

        //HSSFCellStyle cellStyleListado = this.documento.createCellStyle();

        

         //FILA X

        fila = this.hoja.getRow( (short)numeroFila);

        if ( fila == null ){

            fila = this.hoja.createRow((short)numeroFila );

        }

        //CELDA 0  --> VALOR DE COMPRA

        celda = fila.getCell( (short)numeroColumna );

        if ( celda == null ){

            celda = fila.createCell( (short)numeroColumna );

        }        

        this.celdaActual = celda;

        celda.setCellValue( valor );



    }

    

    

    public void escribirCelda( int numeroFila, int numeroColumna, double valor) throws Exception{

        //definimos las varibles

        HSSFRow fila = null;

        HSSFCell celda = null;



        //HSSFCellStyle cellStyleListado = this.documento.createCellStyle();



         //FILA X

        fila = this.hoja.getRow( (short)numeroFila);

        if ( fila == null ){

            fila = this.hoja.createRow((short)numeroFila );

        }

        //CELDA 0  --> VALOR DE COMPRA

        celda = fila.getCell( (short)numeroColumna );

        if ( celda == null ){

            celda = fila.createCell( (short)numeroColumna );

        }

        this.celdaActual = celda;

        celda.setCellValue( valor );



        }



    

     /**

     *  Mtodo que devuelve el contenido binario del documento tratado para poder devolverlo a la jsp

     *  y pintarlo en la salida.

      *@return java.io.ByteArrayOutputStream churro binario que representa el documento con toda su informacin

       @exception DAOException cuando se produce un error en la creacin de la clase.

     */

    public java.io.ByteArrayOutputStream parsearDocumento() throws Exception{

        java.io.ByteArrayOutputStream out = new java.io.ByteArrayOutputStream();

        this.documento.write(out);

        return out;

    }



    

     /**

     *  Mtodo que alinealas celdas de un documento a la derecha.

     *  @param numeroFila nmero de la fila de la posicind de la celda.

     *  @param numeroColumna nmero de la columna de la posicind de la celda.

     *  @return  alineacin de la celda.

     * @exception DAOException cuando se produce un error en la creacin de la clase.

     */

    public void ponerAlineacionCeldasDerecha(int numeroFila, int numeroColumna) throws Exception{

        //definimos las varibles

        

        HSSFRow fila = null;

        HSSFCell celda = null;

        HSSFCellStyle estilo = null;

         //FILA X

        fila = this.hoja.getRow( (short)numeroFila);

        if ( fila == null ){

            fila = this.hoja.createRow((short)numeroFila );

        }



        //CELDA 0  --> VALOR DE COMPRA

        celda = fila.getCell( (short)numeroColumna );

        if ( celda == null ){

            celda = fila.createCell( (short)numeroColumna );

        }  



        estilo = celda.getCellStyle();

        estilo.setAlignment(HSSFCellStyle.ALIGN_RIGHT);

        estilo.setDataFormat((short)4);        

        celda.setCellStyle(estilo);       

        

    }

    

    

      /**

     *  Mtodo que alinealas celdas de un documento a la derecha.

     *  @param numeroFila nmero de la fila de la posicind de la celda.

     *  @param numeroColumna nmero de la columna de la posicind de la celda. 

     *  @return  alineacin de la celda.

     * @exception DAOException cuando se produce un error en la creacin de la clase.

     */

    public void ponerAlineacionCeldasDerechaPta(int numeroFila, int numeroColumna) throws Exception{

        //definimos las varibles

        

        HSSFRow fila = null;

        HSSFCell celda = null;

        HSSFCellStyle estilo = null;

         //FILA X

        fila = this.hoja.getRow( (short)numeroFila);

        if ( fila == null ){

            fila = this.hoja.createRow((short)numeroFila );

        }



        //CELDA 0  --> VALOR DE COMPRA

        celda = fila.getCell( (short)numeroColumna );

        if ( celda == null ){

            celda = fila.createCell( (short)numeroColumna );

        }  



        estilo = celda.getCellStyle();

        estilo.setAlignment(HSSFCellStyle.ALIGN_RIGHT);

        estilo.setDataFormat((short)3);        

        celda.setCellStyle(estilo);      



    }



    

     /**

     *  Mtodo que alinealas celdas de un documento a la izquiera.

     *  @param numeroFila nmero de la fila de la posicind de la celda.

     *  @param numeroColumna nmero de la columna de la posicind de la celda.

     *  @return  alineacin de la celda.

     * @exception DAOException cuando se produce un error en la creacin de la clase.

     */

    public void ponerAlineacionCeldasIzquierda(int numeroFila, int numeroColumna) throws Exception{

        //definimos las varibles

        HSSFRow fila = null;

        HSSFCell celda = null;

        HSSFCellStyle estilo = null;

        

         //FILA X

        fila = this.hoja.getRow( (short)numeroFila);

        if ( fila == null ){

            fila = this.hoja.createRow((short)numeroFila );

        }

        //CELDA 0  --> VALOR DE COMPRA

        celda = fila.getCell( (short)numeroColumna );

        if ( celda == null ){

            celda = fila.createCell( (short)numeroColumna );

        }  

        

        estilo = celda.getCellStyle();

        estilo.setAlignment(HSSFCellStyle.ALIGN_LEFT);

        celda.setCellStyle(estilo);

        

    }



    

     /**

     *  Mtodo que alinealas celdas de un documento al centro.

     *  @param numeroFila nmero de la fila de la posicind de la celda.

     *  @param numeroColumna nmero de la columna de la posicind de la celda.

     *  @return  alineacin de la celda.

     * @exception DAOException cuando se produce un error en la creacin de la clase.

     */

    public void ponerAlineacionCeldasCentro(int numeroFila, int numeroColumna) throws Exception{

        //definimos las varibles

        HSSFRow fila = null;

        HSSFCell celda = null;

        HSSFCellStyle estilo = null;

        

         //FILA X

        fila = this.hoja.getRow( (short)numeroFila);

        if ( fila == null ){

            fila = this.hoja.createRow((short)numeroFila );

        }

        //CELDA 0  --> VALOR DE COMPRA

        celda = fila.getCell( (short)numeroColumna );

        if ( celda == null ){

            celda = fila.createCell( (short)numeroColumna );

        }  

        

        estilo = celda.getCellStyle();

        estilo.setAlignment(HSSFCellStyle.ALIGN_CENTER);

        celda.setCellStyle(estilo);

        

    }



  

    /**

     *  Mtodo que bordea toda la celda menos el lado izquierdo.

     *  @param numeroFila nmero de la fila de la posicin de la celda.

     *  @param numeroColumna nmero de la columna de la posicin de la celda.

     * @exception Exception

     */

    public void bordearMenosIzquierda(int numeroFila, int numeroColumna) throws Exception{

        //definimos las varibles

        HSSFRow fila = null;

        HSSFCell celda = null;

        

        //Fila

        fila = this.hoja.getRow( (short)numeroFila);

        if ( fila == null ){

            fila = this.hoja.createRow((short)numeroFila );

        }

        //Columna

        celda = fila.getCell( (short)numeroColumna );

        if ( celda == null ){

            celda = fila.createCell( (short)numeroColumna );

        }  

        

        bordearMenosIzquierda.setFont(cabecera);

        celda.setCellStyle(this.bordearMenosIzquierda);    

    }

    

    

    /**

     *  Mtodo que bordea toda la celda menos el lado Derecho.

     *  @param numeroFila nmero de la fila de la posicin de la celda.

     *  @param numeroColumna nmero de la columna de la posicin de la celda.

     * @exception Exception

     */

    public void bordearMenosDerecha(int numeroFila, int numeroColumna) throws Exception{

        //definimos las varibles

        HSSFRow fila = null;

        HSSFCell celda = null;

        

        //Fila

        fila = this.hoja.getRow( (short)numeroFila);

        if ( fila == null ){

            fila = this.hoja.createRow((short)numeroFila );

        }

        //Columna

        celda = fila.getCell( (short)numeroColumna );

        if ( celda == null ){

            celda = fila.createCell( (short)numeroColumna );

        }  

        

        bordearMenosDerecha.setFont(cabecera);

        celda.setCellStyle(this.bordearMenosDerecha);    

    }    

    

    

    /**

     *  Mtodo que bordea la celda por arriba y por debajo.

     *  @param numeroFila nmero de la fila de la posicin de la celda.

     *  @param numeroColumna nmero de la columna de la posicin de la celda.

     * @exception Exception

     */

    public void bordearArribaAbajo(int numeroFila, int numeroColumna) throws Exception{

        //definimos las varibles

        HSSFRow fila = null;

        HSSFCell celda = null;

        

        //Fila

        fila = this.hoja.getRow( (short)numeroFila);

        if ( fila == null ){

            fila = this.hoja.createRow((short)numeroFila );

        }

        //Columna

        celda = fila.getCell( (short)numeroColumna );

        if ( celda == null ){

            celda = fila.createCell( (short)numeroColumna );

        }  

        

        bordearArribaAbajo.setFont(cabecera);

        celda.setCellStyle(this.bordearArribaAbajo);    

    }        



    

    /**

     *  Mtodo que bordea la celda por arriba y por debajo.

     *  @param numeroFila nmero de la fila de la posicin de la celda.

     *  @param numeroColumna nmero de la columna de la posicin de la celda.

     * @exception Exception

     */

    public void bordearTodo(int numeroFila, int numeroColumna) throws Exception{

        //definimos las varibles

        HSSFRow fila = null;

        HSSFCell celda = null;

        

        //Fila

        fila = this.hoja.getRow( (short)numeroFila);

        if ( fila == null ){

            fila = this.hoja.createRow((short)numeroFila );

        }

        //Columna

        celda = fila.getCell( (short)numeroColumna );

        if ( celda == null ){

            celda = fila.createCell( (short)numeroColumna );

        }  

        

        bordearTodo.setFont(titulo);

        celda.setCellStyle(this.bordearTodo);    

    }

    

    

    /**

     *  Mtodo que bordea la celda.

     *  @param numeroFila nmero de la fila de la posicin de la celda.

     *  @param numeroColumna nmero de la columna de la posicin de la celda.

     * @exception Exception

     */

    public void bordearSuave(int numeroFila, int numeroColumna) throws Exception{

        //definimos las varibles

        HSSFRow fila = null;

        HSSFCell celda = null;

        

        //Fila

        fila = this.hoja.getRow( (short)numeroFila);

        if ( fila == null ){

            fila = this.hoja.createRow((short)numeroFila );

        }

        //Columna

        celda = fila.getCell( (short)numeroColumna );

        if ( celda == null ){

            celda = fila.createCell( (short)numeroColumna );

        }  

        

        celda.setCellStyle(this.bordearSuave);    

    }

    

    

    /**

     *  Mtodo que realiza un Merge de las celdas seleccionadas.

     *  @param numeroFila nmero de la fila de la posicin de la celda.

     *  @param numeroColumna nmero de la columna de la posicin de la celda.

     * @exception Exception

     */

    public void mergeCeldasTitulo(int filaDesde, int columnaDesde, int filaHasta, int columnaHasta) throws Exception{        

        hoja.addMergedRegion(new Region(filaDesde,(short)columnaDesde,filaHasta,(short)columnaHasta));        

    }

    

    

    /**

     *  Mtodo que cambia el ancho de la celda seleccionada.

     *  @param numeroFila nmero de la fila de la posicin de la celda.

     *  @param numeroColumna nmero de la columna de la posicin de la celda.

     * @exception Exception

     */    

    public void setAnchoCelda(int numeroColumna, int ancho){

    	this.hoja.setColumnWidth((short)numeroColumna, (short)ancho);

    }

    

            

    /**

     *  Mtodo que cambia el estilo del texto de la celda seleccionada.

     *  @param numeroFila nmero de la fila de la posicin de la celda.

     *  @param numeroColumna nmero de la columna de la posicin de la celda.

     * @exception Exception

     */    

    public void setEstiloTexto(int numFila, int numColumna, int tamaoTexto, String nombreFuente, boolean italica){

        //Definir las varibles

        HSSFRow fila = null;

        HSSFCell celda = null;

        

        //Fila

        fila = this.hoja.getRow( (short)numFila);

        if ( fila == null ){

            fila = this.hoja.createRow((short)numFila );

        }

        //Columna

        celda = fila.getCell( (short)numColumna );

        if ( celda == null ){

            celda = fila.createCell( (short)numColumna );

        }  

        

        //Definir el estilo

    	HSSFFont font = this.documento.createFont();

        font.setFontHeightInPoints((short)tamaoTexto);

        font.setFontName(nombreFuente);

        font.setItalic(italica);

        

        //Meter las fuentes en un estilo

        HSSFCellStyle style = this.documento.createCellStyle();

        style.setFont(font);

        

        //Aplicar el estilo a la celda

        celda.setCellStyle(style);

    }

    

    

    /**

     *  Mtodo que cambia el tamao del texto de la celda seleccionada.

     *  @param numeroFila nmero de la fila de la posicin de la celda.

     *  @param numeroColumna nmero de la columna de la posicin de la celda.

     * @exception Exception

     */    

    public void setTamaoTexto(int numeroColumna, int ancho){

    	this.hoja.setColumnWidth((short)numeroColumna, (short)ancho);

    }

    

}