package q02b.exe.utils;



import javax.servlet.ServletOutputStream;

import javax.servlet.http.HttpServletResponse;



import java.io.InputStream;



//import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;



public class Q02bFileUtils {

	

	//private static Q70Traza tr = Q70Traza.getSingleton();

	//private static final String COMPONENTE = "Q02bFileUtils";

	final static int 	MAX_AGE_IN_SECONDS 			= 6;

	

	/**

	 * Mtodo que visualiza un fichero determinado a travs del response

	 * 

	 * @param HttpServletResponse 	response

	 * @param InputStream 			ficheroInputStream

	 * @param String 				nombreFicheroExtension

	 * @param int 					tamanoFichero

	 * 

	 */

	public static void responseFile(HttpServletResponse response, InputStream ficheroInputStream, String nombreFicheroExtension, int tamanoFichero) throws Exception

	{

		//Variables que no se van a modificar

		final String APPLICATION 	= "application/";

		final String CONTENT	 	= "Content-disposition";

		final String ATTACHMENT  	= "attachment; filename=";

		final String CACHE_CONTROL	= "Cache-Control";

		final String MAX_AGE		= "max-age=";

		

		try

		{

			//Se obtiene la extensin del fichero

			String extensionFichero	= nombreFicheroExtension.substring(nombreFicheroExtension.indexOf("."),nombreFicheroExtension.length());

			//Se indica el tamao del fichero

			response.setContentLength(tamanoFichero);

			//El content-type depender de la extensin del fichero

			String contentType = APPLICATION+extensionFichero;

	        response.setContentType(contentType);

	        response.setHeader(CONTENT,ATTACHMENT+nombreFicheroExtension);

	        //Indicamos cada cuanto queremos cachear

	        response.setHeader(CACHE_CONTROL,MAX_AGE+MAX_AGE_IN_SECONDS);

	        ServletOutputStream outStream = response.getOutputStream();

	        //El buffer ser del tamaa del fichero

	        byte[] buffer      = new byte[tamanoFichero];

	        int n              = 0;

	        //Leemos del buffer

	        while ( ( n = ficheroInputStream.read(buffer)) != -1)

	        {

	        	outStream.write(buffer, 0, n);

	        }

	        ficheroInputStream.close();

	        outStream.flush();

		} 

		catch (Exception ex)

		{

			java.io.StringWriter 	sw = new java.io.StringWriter();

			java.io.PrintWriter 	pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			throw ex;

		}

		

	}

	

	

		

}

