package q02b.exe.utils;



import java.lang.reflect.Method;

import java.util.StringTokenizer;



import q02b.exe.arquitectura.valueobjects.Q02bValueObject;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;



public class Q02bCompararObjetos {



	/**

	 * Mtodo que recibirar dos objetos y comprobara si ciertos campos han sido modificados.

	 * 

	 * @param objNuevo

	 * @param objViejo

	 * @param camposObjeto

	 * @param tr

	 * @param COMPONENTE

	 * 

     * @return true si se ha producido alguna modificacin, false si son iguales.

     * 

	 * @throws Exception

	 */

	public boolean compararObjetos(Q02bValueObject objNuevo,

    								Q02bValueObject objViejo, 

    								String camposObjeto, 

    								Q70Traza tr,

    								String COMPONENTE) throws Exception

    {

  	  boolean modificado = false;    	 

  	  if (tr.isTraceActive()){

   		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":compararObjetos: entrando");                

  	  }

  	  //se comprueba que la entidad recibida contenga datos

  	  try{

  		if (objNuevo!=null && objViejo!=null){    		

			//se comprobara que ciertos campos clave han sido modificados

			  try{

				  

				  StringTokenizer str = new StringTokenizer(Q02bConstantes.getString(camposObjeto),";");

				  

				  while (str.hasMoreTokens()){

					  String prop = str.nextToken();

					  Method m = objNuevo.getClass().getDeclaredMethod("get" + prop, null);

					  Object a = (String)m.invoke(objNuevo, null);

					  Object b = (String)m.invoke(objViejo, null);

					  

					  if ( Q02bFormatData.esNull((String)a).equals((String)b)){

						  modificado = false;

						  

					  }else{

						  modificado = true;

						  if (tr.isTraceActive()){

								tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":compararObjetos: hay que grabar en el historico: " + prop);                

						  }

						  break;    					  

					  }    				      				  

				  }

			  }catch(Exception ex){}

			 }

  	  	  return modificado;

  	  }catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":compararObjetos: " + sw.getBuffer ().toString());

            throw ex;

  	  }finally{

     	

      	   if (tr.isTraceActive()){

      		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":compararObjetos: saliendo");                

             }            	 

  	  }	

  	  

    }//fin compararObjetos

	

} // fin clase