package q02b.exe.usuarios.dataobjects;



import java.sql.Connection;

import java.sql.PreparedStatement;

import java.sql.ResultSet;

import java.util.ArrayList;



import q02b.exe.arquitectura.dataobjects.Q02bDataBaseDAO;

import q02b.exe.comun.valueobjects.Q02bCodigoValor;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ021HS01V01;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ021JS00;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ021MS00;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022FS00;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022FS01V01;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ021MS01V01;

//import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022KS00;

import q02b.exe.usuarios.valueobjects.Q02bFiltroUsuarios;

import q02b.exe.usuarios.valueobjects.Q02bUsuario;

import q02b.exe.utils.Q02bConstantes;

import q02b.exe.utils.Q02bFormatData;

import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;



public class Q02bUsuariosDataBaseDAO extends Q02bDataBaseDAO{



	private static final long serialVersionUID = -8520551641771839103L;

	private static Q70Traza tr = Q70Traza.getSingleton();

	private static final String COMPONENTE = "DAO_ACCESO_DATOS";

	

	public Q02bUsuariosDataBaseDAO() {

        super();                

    }



    

    public Q02bUsuariosDataBaseDAO(Connection conn) {

    	super(conn);     

    }

    

    

	    

	    /**

	     * Mtodo que devuelve el nmero de registros de la BBDD de la tabla de Usuarios

	     * @return devuelve nmero de registros de la BBDD de la tabla de Usuarios

	     * @throws Exception

	     */

	    public int getCountUsuarios(Q02bFiltroUsuarios filtroUsuariosVO) throws Exception {    	    

	     	//se crean las objetos necesarios.

	     	int numReg = 0;

	     	ResultSet rs = null;       

	     	Q02bTablaBDQ022FS01V01 vistaQ022FV01 = null;	

	     	

	         try{

	         	if (tr.isTraceActive()){

	     			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getCountUsuarios: entrando");

	     		}

	         	//se instancia la clase del tablas bd a llamar pasandole la conexion        	

	         	vistaQ022FV01 = new Q02bTablaBDQ022FS01V01(this.getConnection());

	         	//Rellenamos la where de la select

	         	this.rellenaFiltroUsuarios(filtroUsuariosVO, vistaQ022FV01);

	         	//se realiza la count

	         	rs = vistaQ022FV01.selectCount();       	

	         	vistaQ022FV01.addResultSet(rs);

	         	if (rs.next()){          		 

	         	 	 numReg =  rs.getInt(1);

	         	}

	         	return numReg;

	         }catch(Exception ex){

	             java.io.StringWriter sw = new java.io.StringWriter();

	             java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	             ex.printStackTrace(pw);

	             tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getCountUsuarios: " + sw.getBuffer ().toString());

	             throw ex;

	        }finally{

	     	   try{

	     		  vistaQ022FV01.freeResourcesNotConnection();	

	     	   }catch(Exception ex){

	 			   if (tr.isTraceActive()){

	 				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getCountUsuarios: error liberando recursos");

	 	   	   	   }  

	 		   }  		

	     	   if (tr.isTraceActive()){

	     		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getCountUsuarios: saliendo");                

	            }           

	        }      

	     }//fin getCountUsuarios()

    

	    /**

	     * Mtodo que devuelve un arraylist de objetos usuario resultado de la consulta a bbdd

	     * @return listaUsuarios - ArrayList arraylist de objetos usuario

	     * @throws Exception

	     */

       public ArrayList getUsuarios(Q02bFiltroUsuarios filtroUsuariosVO) throws Exception {		

	 		//se instancian los objetos necesarios para realizar la consulta.			

	    	Q02bTablaBDQ022FS01V01 vistaQ022FS01V01=null;

	 		ResultSet rs = null;

	 		ArrayList listaUsuarios = new ArrayList();

	 		//Q02bUsuario usuarioVO;

	 		

	 		try{

	 	    	if (tr.isTraceActive()){

	 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getUsuarios: entrando");

	 			}

	 	    	//se instancia la clase del tablas bd a llamar pasandole la conexion	    	

	 	    	vistaQ022FS01V01 = new Q02bTablaBDQ022FS01V01(this.getConnection());

	 	    	

	 	    	//Rellenamos la where de la select

	         	this.rellenaFiltroUsuarios(filtroUsuariosVO, vistaQ022FS01V01);

	         	

	 	    	//se realiza la select

	 	    	rs = vistaQ022FS01V01.select();

	 	    	//aadimos el cursor para luego poder liberarlo (en el freeResources)

	 	    	vistaQ022FS01V01.addResultSet(rs); 

	 	    	//se trata el resultado obtenido aadiendolo a la lista de salida

	 	    	listaUsuarios = this.rellenaVOsUsuarios(rs);

	 	    	

	 	    	return listaUsuarios;    	

	 		}catch(Exception ex){ 	   

	     		java.io.StringWriter sw = new java.io.StringWriter();

	     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	     		ex.printStackTrace(pw);

	     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getUsuarios: " + sw.getBuffer ().toString());

	     		throw ex;

	 		}finally{

	 		 	try{

	 		 		//liberamos los recursos OJO! LOS QUE SE HAN AADIDO CON addResultSet

	 		 		vistaQ022FS01V01.freeResourcesNotConnection();	

	 			 }catch(Exception ex){

	 			    if (tr.isTraceActive()){

	 				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getUsuarios: error liberando recursos.");

	 	   	   	    }  

	 			 }  		 			

	 			 if (tr.isTraceActive()){

	 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getUsuarios: saliendo.");                

	 	         }   

	 		}	

	 	}

       

       

       /**

	     * Mtodo que devuelve un objeto usuario resultado de la consulta a bbdd

	     * @param  idUsuario - String nmero interno del usuario

	     * @return usuarioVO - Q02bUsuario Valueobject de usuario con los datos del usuario obtenido

	     * @throws Exception

	     */

       	public Q02bUsuario getUsuario(String idUsuario) throws Exception {		

	 		//se instancian los objetos necesarios para realizar la consulta.			

	    	Q02bTablaBDQ022FS01V01 vistaQ022FS01V01=null;

	 		ResultSet rs = null;

	 		Q02bUsuario usuarioVO=null;

	 		

	 		try{

	 	    	if (tr.isTraceActive()){

	 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getUsuarios: entrando");

	 			}

	 	    	//se instancia la clase del tablas bd a llamar pasandole la conexion

	 	    	//se realiza la select

	 	    	vistaQ022FS01V01 = new Q02bTablaBDQ022FS01V01(this.getConnection());

	 	    	vistaQ022FS01V01.setQ022FT00_IDUSUARIO_WHERE(Integer.parseInt( idUsuario));

	 	    	rs = vistaQ022FS01V01.select();

	 	    	//aadimos el cursos para luego poder liberarlo ( en el freeResources)

	 	    	vistaQ022FS01V01.addResultSet(rs); 

	 	    	//se trata el resultado obtenido 

	 	    	usuarioVO= new Q02bUsuario();

	 	    	if(rs.next()){

	 	    		this.rellenarVOUsuario(usuarioVO, rs);
                }
	 	    	

	 	    	return usuarioVO;    	

	 		}catch(Exception ex){ 	   

	     		java.io.StringWriter sw = new java.io.StringWriter();

	     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	     		ex.printStackTrace(pw);

	     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getUsuarios: " + sw.getBuffer ().toString());

	     		throw ex;

	 		}finally{

	 		 	try{

	 		 		//liberamos los recursos OJO! LOS QUE SE HAN AADIDO CON addResultSet

	 		 		vistaQ022FS01V01.freeResourcesNotConnection();	

	 			 }catch(Exception ex){

	 			    if (tr.isTraceActive()){

	 				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getUsuarios: error liberando recursos.");

	 	   	   	    }  

	 			 }  		 			

	 			 if (tr.isTraceActive()){

	 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getUsuarios: saliendo.");                

	 	         }   

	 		}	

	 	}

    

       	

       	

       	

       	/**

	      * Mtodo que rellena el tablasBD con los datos del filtro de objeto que contiene

	      * los criterios de bsqueda introducidos por el usuario

	      * 

	      * @param filtroUsuariosVO

	      * @param tablaBD

	      * 

	      * @throws Exception

	      */

	    public void rellenaFiltroUsuarios(Q02bFiltroUsuarios filtroUsuariosVO, Q02bTablaBDQ022FS01V01 vistaQ022FV01)throws Exception

	    {

	     //Definicin de variables que no se van a modificar

	     final String TRACE_METODO = ":rellenaFiltroUsuarios:";

	     StringBuffer additionalWhere=null;

	    	try{

	    		if (tr.isTraceActive()){

			        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " entrando");                

	    		} 

	    		if(filtroUsuariosVO!=null){

		    		

	    			additionalWhere = new StringBuffer();

	    			

		    		if(!Q02bFormatData.esNull(filtroUsuariosVO.getNombre()).equals("")){

		    			additionalWhere.append(" AND TRANSLATE(UPPER(Q022FT00_NOMBRE),'','AEIOUAEIOU') like '%' || ");

		    			additionalWhere.append("TRANSLATE(UPPER('").append(filtroUsuariosVO.getNombre()).append("'),'','AEIOUAEIOU') || '%'");

		    		}

		    		if(!Q02bFormatData.esNull(filtroUsuariosVO.getApellido1()).equals("")){

		    			additionalWhere.append(" AND TRANSLATE(UPPER(Q022FT00_APELLIDO1),'','AEIOUAEIOU') like '%' || ");

		    			additionalWhere.append("TRANSLATE(UPPER('").append(filtroUsuariosVO.getApellido1()).append("'),'','AEIOUAEIOU') || '%'");

		    		}

		    		if(!Q02bFormatData.esNull(filtroUsuariosVO.getApellido2()).equals("")){

		    			additionalWhere.append(" AND TRANSLATE(UPPER(Q022FT00_APELLIDO2),'','AEIOUAEIOU') like '%' || ");

		    			additionalWhere.append("TRANSLATE(UPPER('").append(filtroUsuariosVO.getApellido2()).append("'),'','AEIOUAEIOU') || '%'");

		    		}

		    		if(!Q02bFormatData.esNull(filtroUsuariosVO.getDni()).equals("")){

		    			additionalWhere.append(" AND UPPER(Q022FT00_NIF) like ");

		    			additionalWhere.append("UPPER('").append(filtroUsuariosVO.getDni()).append("') || '%'");

		    		}

		    		

		    		if(!Q02bFormatData.esNull(filtroUsuariosVO.getNombreUsuario()).equals("")){

		    			additionalWhere.append(" AND TRANSLATE(UPPER(Q022FT00_NOMBRE),'','AEIOUAEIOU') like '%' || ");

		    			additionalWhere.append("TRANSLATE(UPPER('").append(filtroUsuariosVO.getNombreUsuario()).append("'),'','AEIOUAEIOU') || '%'");

		    		}

		    		

		    		if(!Q02bFormatData.esNull(filtroUsuariosVO.getNifUsuario()).equals("")){

		    			additionalWhere.append(" AND UPPER(Q022FT00_NIF) like ");

		    			additionalWhere.append("UPPER('").append(filtroUsuariosVO.getNifUsuario()).append("') || '%'");

		    		}

	    	

			    	if(!Q02bFormatData.esNull(filtroUsuariosVO.getCodProv()).equals("")){

			    		if(filtroUsuariosVO.getCodProv().equals("-1")){

			    			additionalWhere.append(" AND MUN_PROV IS NULL");
                        }
			    		else{ vistaQ022FV01.setMUN_PROV_WHERE(filtroUsuariosVO.getCodProv());}

			    	}

		    		if(!Q02bFormatData.esNull(filtroUsuariosVO.getCodMuni()).equals("")){

		    			if(filtroUsuariosVO.getCodMuni().equals("-1")){

		    				additionalWhere.append(" AND MUN_MUNI IS NULL");
                        }
		    			else{ vistaQ022FV01.setMUN_MUNI_WHERE(filtroUsuariosVO.getCodMuni());}

		    		}

		    		

		    		if(additionalWhere!=null && !additionalWhere.toString().equals("")){

		    			vistaQ022FV01.setAditionalWhere(additionalWhere.toString());
                    }
		    	}

	    		vistaQ022FV01.setOrderBy(" Q022FT00_APELLIDO1 ASC");

	       	}	    	

	    	catch(Exception ex){    	 	   

		       java.io.StringWriter sw = new java.io.StringWriter();

		       java.io.PrintWriter 	pw = new java.io.PrintWriter(sw);

		       ex.printStackTrace(pw);

		       tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() 		+ TRACE_METODO + sw.getBuffer ().toString());

		       throw ex;

		}finally

		{			 	

			if (tr.isTraceActive())

			{

			        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() 	+ TRACE_METODO + " saliendo");                

			 }    				

		}

	    }//fin rellenaFiltroUsuarios()

	    

	    

	    

	    

	    /**

	     * Mtodo que devuelve un arraylist de objetos usuario resultado de la consulta a bbdd

	     * @param rs - ResultSet Resultado de la consulta a bbdd

	     * @return listaUsuarios - ArrayList arraylist de objetos usuario

	     * @throws Exception

	     */

	    private ArrayList rellenaVOsUsuarios (ResultSet rs) throws Exception{

	     	Q02bUsuario usuarioVO;

	     	ArrayList listaUsuarios = new ArrayList();

	     	try{

	     		if (tr.isTraceActive()){

	 		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaVOsUsuarios: entrando");                

	 		    } 

	     		while (rs.next()){	 

	 	        	//se cargan en el objeto usuario los datos recuperados

	     			usuarioVO = new Q02bUsuario();

	     			rellenarVOUsuario(usuarioVO,rs);

	     			listaUsuarios.add(usuarioVO);

	   			}  	  

	     		return listaUsuarios;

	     	}catch(Exception ex){    	 	   

	  	       java.io.StringWriter sw = new java.io.StringWriter();

	  	       java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	  	       ex.printStackTrace(pw);

	  	       tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenaVOsUsuarios: " + sw.getBuffer ().toString());

	  	       throw ex;

	  		}finally{			 	

	  			if (tr.isTraceActive()){

	  		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaVOsUsuarios: saliendo");                

	  		    }    				

	  		}

	     } 

    

	    /**

	     * Mtodo que informa un valueobject de usuario con los datos de usuario obtenidos de la tabla de usuarios

	     * @param usuarioVO - Q02bUsuario valueobject de usuario que se va a informar

	     * @param rs - ResultSet Resultado de la consulta a bbdd

	     * @throws Exception

	     */

        private void rellenarVOUsuario (Q02bUsuario usuarioVO, ResultSet rs) throws Exception

	    {

	    	String sTodos="";

	     	try{

			   	tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":rellenarVOUsuario: Hay Datos");            

			   	

			   	sTodos=Q70GestorMensajesi18n.getSingleton().getMessage("q02brecursosCuestionarios","comun.todos",this.getIdioma());

			   	

			   	usuarioVO.setIdUsuario(rs.getString(Q02bTablaBDQ022FS01V01.NOMCOLUMN_Q022FT00_IDUSUARIO));

			   	usuarioVO.setNombre(rs.getString(Q02bTablaBDQ022FS01V01.NOMCOLUMN_Q022FT00_NOMBRE));

			   	usuarioVO.setApellido1(rs.getString(Q02bTablaBDQ022FS01V01.NOMCOLUMN_Q022FT00_APELLIDO1));

			   	usuarioVO.setApellido2(rs.getString(Q02bTablaBDQ022FS01V01.NOMCOLUMN_Q022FT00_APELLIDO2));

			   	usuarioVO.setNif(rs.getString(Q02bTablaBDQ022FS01V01.NOMCOLUMN_Q022FT00_NIF));

			   	usuarioVO.setPassword(rs.getString(Q02bTablaBDQ022FS01V01.NOMCOLUMN_Q022FT00_PASSWORD));

			   	usuarioVO.setMail(rs.getString(Q02bTablaBDQ022FS01V01.NOMCOLUMN_Q022FT00_EMAIL));

			   	usuarioVO.setCodProvincia(rs.getString(Q02bTablaBDQ022FS01V01.NOMCOLUMN_MUN_PROV));

			   	if(Q02bFormatData.esNull(rs.getString(Q02bTablaBDQ022FS01V01.NOMCOLUMN_DESC_PROV)).equals("")){

			   		usuarioVO.setDescProvincia(sTodos);
                }
			   	else{ usuarioVO.setDescProvincia(rs.getString(Q02bTablaBDQ022FS01V01.NOMCOLUMN_DESC_PROV));}

			   	usuarioVO.setCodMunicipio(rs.getString(Q02bTablaBDQ022FS01V01.NOMCOLUMN_MUN_MUNI));

			   	if(Q02bFormatData.esNull(rs.getString(Q02bTablaBDQ022FS01V01.NOMCOLUMN_DESC_MUNI)).equals("")){

			   		usuarioVO.setDescMunicipio(sTodos);
                }
			   	else{ usuarioVO.setDescMunicipio(rs.getString(Q02bTablaBDQ022FS01V01.NOMCOLUMN_DESC_MUNI));}

			   	if(!Q02bFormatData.esNull(rs.getString(Q02bTablaBDQ022FS01V01.NOMCOLUMN_Q022FT00_FECHA_ACTIVACION)).equals("")){

			   		usuarioVO.setFechaActivacion(new  java.text.SimpleDateFormat("dd/MM/yyyy").format(rs.getDate(Q02bTablaBDQ022FS01V01.NOMCOLUMN_Q022FT00_FECHA_ACTIVACION)));
                }
			   	if(!Q02bFormatData.esNull(rs.getString(Q02bTablaBDQ022FS01V01.NOMCOLUMN_Q022FT00_FECHA_DESACTIVACION)).equals("")){

			   		usuarioVO.setFechaDesactivacion(new  java.text.SimpleDateFormat("dd/MM/yyyy").format(rs.getDate(Q02bTablaBDQ022FS01V01.NOMCOLUMN_Q022FT00_FECHA_DESACTIVACION)));
                }
			   	usuarioVO.setCodPerfil(rs.getString(Q02bTablaBDQ022FS01V01.NOMCOLUMN_Q022FT00_IDUSUARIO));

	     	}

			catch (Exception e) {

			    if (tr.isTraceActive()){

			   	   	tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenarVOUsuario: error "+ e.getMessage());

				}  

		    }  	

	    }

    

	    /**

	     * Mtodo que inserta un usuario en la bbdd

	     * @param usuarioVO - Q02bUsuario valueobject de usuario con los datos del usuario

	     * @return idUsuario - String Nmero interno del usuario

	     * @throws Exception

	     */

    	public String insertarUsuario(Q02bUsuario usuarioVO) throws Exception {		

	 		

	    	Q02bTablaBDQ022FS00 tablaQ022FT00=null;

	    	int idUsuario = 0;

	 		try{

	 			//StringBuffer data = new StringBuffer();

	 			

	 	    	if (tr.isTraceActive()){

	 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarUsuario: entrando");

	 			}

	 	    	//se instancia la clase del tablas bd a llamar pasandole la conexion	    	

	 	    	tablaQ022FT00 = new Q02bTablaBDQ022FS00(this.getConnection());

	 	    

	 	    	idUsuario = dameSeqIdUsuario(tablaQ022FT00);

	 	    	

	 	    	//Al campo CODPERFIL le vamos a poner un 1 a pion porque en la bbdd no admite nulos; 

	 	    	//aunque en la tabla hay un defaultValue, como en caso de no asignar nada al tablasBD le intenta meter un NULL,

	 	    	//casca

	 	    	tablaQ022FT00.setQ021AT00_CODPERFIL("1");

	 	    	

	 	    	tablaQ022FT00.setQ022FT00_NOMBRE(usuarioVO.getNombre());

	 	    	tablaQ022FT00.setQ022FT00_APELLIDO1(usuarioVO.getApellido1());

	 	    	tablaQ022FT00.setQ022FT00_APELLIDO2(usuarioVO.getApellido2());

	 	    	tablaQ022FT00.setQ022FT00_NIF(usuarioVO.getNif());

	 	    	tablaQ022FT00.setQ022FT00_EMAIL(usuarioVO.getMail());

	 	    	tablaQ022FT00.setMUN_PROV(usuarioVO.getCodProvincia());

	 	    	tablaQ022FT00.setMUN_MUNI(usuarioVO.getCodMunicipio());

	 	    	if(!Q02bFormatData.esNull(usuarioVO.getFechaActivacion()).equals("")){

	 	    		tablaQ022FT00.setQ022FT00_FECHA_ACTIVACION(new java.text.SimpleDateFormat("dd/MM/yyyy").parse(usuarioVO.getFechaActivacion()));
                }
	 	       	if(!Q02bFormatData.esNull(usuarioVO.getFechaDesactivacion()).equals("")){

	 	    		tablaQ022FT00.setQ022FT00_FECHA_DESACTIVACION(new java.text.SimpleDateFormat("dd/MM/yyyy").parse(usuarioVO.getFechaDesactivacion()));
                }
	 	       tablaQ022FT00.setQ022FT00_IDUSUARIO(idUsuario);

	 	       tablaQ022FT00.insert();

	 	       return Integer.toString(idUsuario);    	

	 		}catch(Exception ex){ 	   

	     		java.io.StringWriter sw = new java.io.StringWriter();

	     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	     		ex.printStackTrace(pw);

	     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarUsuario: " + sw.getBuffer ().toString());

	     		throw ex;

	 		}finally{

	 		 	try{

	 		 		//liberamos los recursos OJO! LOS QUE SE HAN AADIDO CON addResultSet

	 		 		tablaQ022FT00.freeResourcesNotConnection();	

	 			 }catch(Exception ex){

	 			    if (tr.isTraceActive()){

	 				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarUsuario: error liberando recursos.");

	 	   	   	    }  

	 			 }  		 			

	 			 if (tr.isTraceActive()){

	 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarUsuario: saliendo.");                

	 	         }   

	 		}	

	 	}

	

    	/**

	     * Mtodo que modifica en la bbd el usuario seleccionado en pantalla

	     * @param usuarioVO - Q02bUsuario valueobject de usuario con los datos del usuario

	     * @throws Exception

	     */

        public void modificarUsuario(Q02bUsuario usuarioVO) throws Exception {		

	 		

	    	Q02bTablaBDQ022FS00 tablaQ022FT00=null;

	    	//int idUsuario = 0;

	 		try{

	 			if (tr.isTraceActive()){

	 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarUsuario: entrando");

	 			}

	 	    	//se instancia la clase del tablas bd a llamar pasandole la conexion	    	

	 	    	tablaQ022FT00 = new Q02bTablaBDQ022FS00(this.getConnection());

	 	    

	 	    	tablaQ022FT00.setQ022FT00_NOMBRE(usuarioVO.getNombre());

	 	    	tablaQ022FT00.setQ022FT00_APELLIDO1(usuarioVO.getApellido1());

	 	    	tablaQ022FT00.setQ022FT00_APELLIDO2(usuarioVO.getApellido2());

	 	    	tablaQ022FT00.setQ022FT00_NIF(usuarioVO.getNif());

	 	    	tablaQ022FT00.setQ022FT00_EMAIL(usuarioVO.getMail());

	 	    	tablaQ022FT00.setMUN_PROV(usuarioVO.getCodProvincia());

	 	    	tablaQ022FT00.setMUN_MUNI(usuarioVO.getCodMunicipio());

	 	    	if(!Q02bFormatData.esNull(usuarioVO.getFechaActivacion()).equals("")){

	 	    		tablaQ022FT00.setQ022FT00_FECHA_ACTIVACION(new java.text.SimpleDateFormat("dd/MM/yyyy").parse(usuarioVO.getFechaActivacion()));
                }
	 	       	if(!Q02bFormatData.esNull(usuarioVO.getFechaDesactivacion()).equals("")){

	 	    		tablaQ022FT00.setQ022FT00_FECHA_DESACTIVACION(new java.text.SimpleDateFormat("dd/MM/yyyy").parse(usuarioVO.getFechaDesactivacion()));
                }
	 	       tablaQ022FT00.setQ022FT00_IDUSUARIO_WHERE(Integer.parseInt(usuarioVO.getIdUsuario()));

	 	       tablaQ022FT00.update();

	 	    

	 	  }catch(Exception ex){ 	   

	     		java.io.StringWriter sw = new java.io.StringWriter();

	     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	     		ex.printStackTrace(pw);

	     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarUsuario: " + sw.getBuffer ().toString());

	     		throw ex;

	 		}finally{

	 		 	try{

	 		 		//liberamos los recursos OJO! LOS QUE SE HAN AADIDO CON addResultSet

	 		 		tablaQ022FT00.freeResourcesNotConnection();	

	 			 }catch(Exception ex){

	 			    if (tr.isTraceActive()){

	 				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarUsuario: error liberando recursos.");

	 	   	   	    }  

	 			 }  		 			

	 			 if (tr.isTraceActive()){

	 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarUsuario: saliendo.");                

	 	         }   

	 		}	

	 	}

    

	    /**

	     * Mtodo que borra de la bbd el usuario seleccionado en pantalla

	     * @param idUsuario - String Nmero interno del usuario

	     * @throws Exception

	     */

	    public void borrarUsuario(String idUsuario) throws Exception {		

			

	    	Q02bTablaBDQ022FS00 tablaQ022FT00=null;

			try{

				

		    	if (tr.isTraceActive()){

					tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarUsuario: entrando");

				}

		    	//se instancia la clase del tablas bd a llamar pasandole la conexion	    	

		    	tablaQ022FT00 = new Q02bTablaBDQ022FS00(this.getConnection());

		    

		       tablaQ022FT00.setQ022FT00_IDUSUARIO_WHERE(Integer.parseInt(idUsuario));

		       tablaQ022FT00.delete();

		    

		    }catch(Exception ex){ 	   

	 		java.io.StringWriter sw = new java.io.StringWriter();

	 		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	 		ex.printStackTrace(pw);

	 		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarUsuario: " + sw.getBuffer ().toString());

	 		throw ex;

			}finally{

			 	try{

			 		//liberamos los recursos OJO! LOS QUE SE HAN AADIDO CON addResultSet

			 		tablaQ022FT00.freeResourcesNotConnection();	

				 }catch(Exception ex){

				    if (tr.isTraceActive()){

					   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarUsuario: error liberando recursos.");

		   	   	    }  

				 }  		 			

				 if (tr.isTraceActive()){

					tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarUsuario: saliendo.");                

		         }   

			}	

		}

	    

	    /**

	     * Mtodo que devuelve el siguiente nmero interno disponible (el mximo + 1) del usuario

	     * @param tablaQ022FT00 - Q02bTablaBDQ022FS00 tabla (de usuarios) de la que se obtiene el nmero interno

	     * @return idUsuario - int Nmero interno del usuario 

	     * @throws Exception

	     */

	    private int dameSeqIdUsuario(Q02bTablaBDQ022FS00 tablaQ022FT00) throws Exception {

	   	 

	    	int idUsuario=0;

	    	ResultSet rs = null;

	      	PreparedStatement prepStmt =null;	

	    	try{

		    	if (tr.isTraceActive()){

		   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dameSeqIdUsuario: entrando");

		    	}

	    		StringBuffer query = new StringBuffer(" SELECT Q022FQ00.NEXTVAL FROM DUAL ");

	         	prepStmt = this.getConnection().prepareStatement(query.toString());         	

	         	rs = prepStmt.executeQuery();

	         	tablaQ022FT00.addResultSet(rs);

	         	tablaQ022FT00.addStatement(prepStmt);        	

	         	if (rs.next()){

	         		idUsuario = rs.getInt(1);

	         	}	         	

	         	return idUsuario;

		     }catch(Exception ex){   	   

	    		java.io.StringWriter sw = new java.io.StringWriter();

	    		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	    		ex.printStackTrace(pw);

	    		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":dameSeqIdUsuario: " + sw.getBuffer ().toString());

	    		throw ex;

	    	 }

	    }

	    

	    /**

	      * Mtodo que devuelve una lista con los grupos asignados a un usuario.

	      * @param idUsuario nmero interno del usuario.

	      * @return ArrayList con la lista de grupos encontrados

	      * @throws Exception

	      */

	     public ArrayList obtenerGruposSeleccionados(String idUsuario) throws Exception{

	     	Q02bTablaBDQ021JS00 tablaBDUsuariosGrupos = null;

	     	Q02bTablaBDQ021HS01V01 tablaBDGrupos = null;

	     	ResultSet rs = null;

	     	ResultSet rs2 = null;

	     	ArrayList listaGruposSeleccionados = new ArrayList();

	     	

	     	try{

	 	    	if (tr.isTraceActive()){

	 	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerGruposSeleccionados: entrando");

	 	   		}

	 	    	tablaBDUsuariosGrupos = new Q02bTablaBDQ021JS00(this.getConnection());

	 	    		    	

	 	    	tablaBDUsuariosGrupos.setDistinct(Q02bTablaBDQ021JS00.NOMCOLUMN_Q021HT00_NI);



	 	    	tablaBDUsuariosGrupos.setQ022FT00_NI_WHERE(new Integer(idUsuario));

	 	    	

	 	    	rs = tablaBDUsuariosGrupos.selectDistinct();

	 	    	

	       		while (rs.next()){

	       			tablaBDGrupos = new Q02bTablaBDQ021HS01V01(this.getConnection());	

	       			tablaBDGrupos.setQ021HT00_NI_WHERE(new Long(rs.getString(Q02bTablaBDQ021JS00.NOMCOLUMN_Q021HT00_NI)));

	 				rs2 = tablaBDGrupos.select();

	 				tablaBDGrupos.addResultSet(rs2);

	 				if (rs2.next()) {

	 					Q02bCodigoValor grupo = new Q02bCodigoValor (rs2.getString(Q02bTablaBDQ021HS01V01.NOMCOLUMN_Q021HT00_NI),

	 	      					rs2.getString(Q02bTablaBDQ021HS01V01.NOMCOLUMN_Q021HT00_DESC));

	 					listaGruposSeleccionados.add(grupo);

	 				}

	       		}       		

	       		return listaGruposSeleccionados;

	      	}catch(Exception ex){   	   

	      		java.io.StringWriter sw = new java.io.StringWriter();

	      		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	      		ex.printStackTrace(pw);

	      		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerGruposSeleccionados: " + sw.getBuffer ().toString());

	      		throw ex;

	      	}finally{

	      		try{

	      			tablaBDUsuariosGrupos.freeResourcesNotConnection();	

	      		}catch(Exception ex){

	      			if (tr.isTraceActive()){

	      				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerGruposSeleccionados: error liberando recursos");

	  		   	   	}  

	  			}  		

	  			if (tr.isTraceActive()){

	  				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerGruposSeleccionados: saliendo");                

	             }       	

	      	}	

	     }    

	     

	     /**

	      * Mtodo que devuelve una lista con los grupos no asignados a un usuario.

	      * @param idUsuario nmero interno del usuario.

	      * @return ArrayList con la lista de grupos encontrados

	      * @throws Exception

	      */

	     public ArrayList obtenerGruposNoSeleccionados(String idUsuario) throws Exception{

	    	 Q02bTablaBDQ021JS00 tablaBDUsuariosGrupos = null;

	     	Q02bTablaBDQ021HS01V01 tablaBDGrupos = null;

	     	ResultSet rs = null;

	     	ResultSet rs2 = null;

	     	ArrayList listaGruposNoSeleccionados = new ArrayList();

	     	

	     	try{

	 	    	if (tr.isTraceActive()){

	 	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerGruposNoSeleccionados: entrando");

	 	   		}

	 	    	tablaBDUsuariosGrupos = new Q02bTablaBDQ021JS00(this.getConnection());

	 	    	tablaBDGrupos = new Q02bTablaBDQ021HS01V01(this.getConnection());	

	 	    	

	 	    	tablaBDGrupos.setDistinct(Q02bTablaBDQ021HS01V01.NOMCOLUMN_Q021HT00_NI);

	 	    	

	 	    	StringBuffer where = new StringBuffer();

	 	    	

	 	    	where.append(Q02bTablaBDQ021HS01V01.NOMCOLUMN_Q021HT00_NI).append(" NOT IN (SELECT ").

	 	    	append(Q02bTablaBDQ021JS00.NOMCOLUMN_Q021HT00_NI).append(" FROM ").

	 	    	append(tablaBDUsuariosGrupos.getTableFrom()).append(" WHERE ").

	 	    	append(Q02bTablaBDQ021JS00.NOMCOLUMN_Q022FT00_NI).append("=").append(idUsuario).append(")");

	 	    	

	 	    	rs = tablaBDGrupos.selectDistinct(where.toString());

	 	    	

	       		while (rs.next()){	

	       			tablaBDGrupos.setQ021HT00_NI_WHERE(new Long(rs.getString(Q02bTablaBDQ021HS01V01.NOMCOLUMN_Q021HT00_NI)));

	 				rs2 = tablaBDGrupos.select();

	 				tablaBDGrupos.addResultSet(rs2);

	 				if (rs2.next()) {

	 					Q02bCodigoValor usuario = new Q02bCodigoValor (rs2.getString(Q02bTablaBDQ021HS01V01.NOMCOLUMN_Q021HT00_NI),

	 	      					rs2.getString(Q02bTablaBDQ021HS01V01.NOMCOLUMN_Q021HT00_DESC));

	 					listaGruposNoSeleccionados.add(usuario);

	 				}

	       		}

	       		return listaGruposNoSeleccionados;

	      	}catch(Exception ex){   	   

	      		java.io.StringWriter sw = new java.io.StringWriter();

	      		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	      		ex.printStackTrace(pw);

	      		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerGruposNoSeleccionados: " + sw.getBuffer ().toString());

	      		throw ex;

	      	}finally{

	      		try{

	      			tablaBDUsuariosGrupos.freeResourcesNotConnection();	

	      		}catch(Exception ex){

	      			if (tr.isTraceActive()){

	      				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerGruposNoSeleccionados: error liberando recursos");

	  		   	   	}  

	  			}  		

	  			if (tr.isTraceActive()){

	  				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerGruposNoSeleccionados: saliendo");                

	             }       	

	      	}	

	     }

	     

	     /**

	      * Mtodo que llama a un DAO para insertar los grupos para un usuario determinado

	      * @param idUsuario nmero interno del usuario en bbdd.

	      * @param listaGrupos ArrayList con los nmeros internos de cada grupo.

	      * @throws Exception

	      */

	     public void insertarGruposUsuario(String idUsuario, ArrayList listaGrupos) throws Exception {

	     	Q02bTablaBDQ021JS00 tablaGruposUsuarios = null;

	     	try{

	     		if (tr.isTraceActive()){

	       			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarGruposUsuario: entrando");

	       		}    		

	     		tablaGruposUsuarios = new Q02bTablaBDQ021JS00(this.getConnection());

	     		//tablaProcesosRoles.setUSER(new Long(this.getUser()));     		

	 			for (int i=0;i<listaGrupos.size();i++){

	 				tablaGruposUsuarios.setQ022FT00_NI(new Integer(idUsuario));

	 		    	tablaGruposUsuarios.setQ021HT00_NI(new Long((String) listaGrupos.get(i)));

	 	      		

	 	      		//se realiza la insert

	 		    	tablaGruposUsuarios.insert();

	 			}

	     	}catch(Exception ex){

	 	        java.io.StringWriter sw = new java.io.StringWriter();

	 	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	 	        ex.printStackTrace(pw);

	 	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarGruposUsuario: " + sw.getBuffer ().toString());

	 	        throw ex;                     

	     	}finally{

	  		    try{

	  		    	tablaGruposUsuarios.freeResourcesNotConnection();

	  		    }catch(Exception ex){

	 			   if (tr.isTraceActive()){

	 				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarGruposUsuario: error liberando recursos");

	 	   	   	   }  

	  		    }  		  	       	

	 	        if (tr.isTraceActive()){

	 	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarGruposUsuario: saliendo.");

	 	   		}

	     	}

	     } 

	     

	     /**

	      * Mtodo que borra los grupos asignados a un usuario determinado.

	      * @param idUsuario

	      * @throws Exception

	      */

	     public void borrarGruposUsuario(String idUsuario) throws Exception{

	     	Q02bTablaBDQ021JS00 tablaBDUsuariosGrupos = null;

	     	try{

	 	    	if (tr.isTraceActive()){

	 	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarGruposUsuario: entrando");

	 	   		}

	 	    	tablaBDUsuariosGrupos = new Q02bTablaBDQ021JS00(this.getConnection());



	 	    	tablaBDUsuariosGrupos.setQ022FT00_NI_WHERE(new Integer(idUsuario));

	       		

	       		//se realiza la delete

	 	    	tablaBDUsuariosGrupos.delete();

	       			      		

	      	}catch(Exception ex){   	   

	      		java.io.StringWriter sw = new java.io.StringWriter();

	      		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	      		ex.printStackTrace(pw);

	      		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarGruposUsuario: " + sw.getBuffer ().toString());

	      		throw ex;

	      	}finally{

	      		try{

	      			tablaBDUsuariosGrupos.freeResourcesNotConnection();	

	      		}catch(Exception ex){

	      			if (tr.isTraceActive()){

	      				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarGruposUsuario: error liberando recursos");

	  		   	   	}  

	  			}  		

	  			if (tr.isTraceActive()){

	  				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarGruposUsuario: saliendo");                

	             }       	

	      	}	

	     }//fin borrarGruposUsuario

	     

	     public void insertarUsuarioGrupo(String idGrupo, String idUsuario) throws Exception{

	      	Q02bTablaBDQ021JS00 tablaBDUsuariosGrupos = null;

	      	try{

	  	    	if (tr.isTraceActive()){

	  	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarUsuarioGrupo: entrando");

	  	   		}

	  	    	tablaBDUsuariosGrupos = new Q02bTablaBDQ021JS00(this.getConnection());



	           	//se aaden los datos a insertar

	  	    	tablaBDUsuariosGrupos.setQ022FT00_NI(new Integer(idUsuario));

	  	    	tablaBDUsuariosGrupos.setQ021HT00_NI(new Long(idGrupo));

	        		

	        		//se realiza la insert

	  	    	tablaBDUsuariosGrupos.insert();

	        			      		

	       	}catch(Exception ex){   	   

	       		java.io.StringWriter sw = new java.io.StringWriter();

	       		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	       		ex.printStackTrace(pw);

	       		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarUsuarioGrupo: " + sw.getBuffer ().toString());

	       		throw ex;

	       	}finally{

	       		try{

	       			tablaBDUsuariosGrupos.freeResourcesNotConnection();	

	       		}catch(Exception ex){

	       			if (tr.isTraceActive()){

	       				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarUsuarioGrupo: error liberando recursos");

	   		   	   	}  

	   			}  		

	   			if (tr.isTraceActive()){

	   				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarUsuarioGrupo: saliendo");                

	              }       	

	       	}	

	      }//fin insertarUsuarioGrupo

	     

	     

	     /**

	      * Mtodo que llama a un DAO para insertar los municipios para un usuario determinado

	      * Los municipios sern de una sola provincia

	      * @param codProvincia nmero interno de la provincia en bbdd.

	      * @param idUsuario nmero interno del usuario en bbdd.

	      * @param listaMunicipios ArrayList con los nmeros internos de cada municipio.

	      * @throws Exception

	      */

	     public void insertarMunicipiosUsuario(String codProvincia,String idUsuario, ArrayList listaMunicipios) throws Exception {

	     	Q02bTablaBDQ021MS00 tablaMunicipiosUsuarios = null;

	    	int idMuniUsu = 0;

	     	try{

	     		if (tr.isTraceActive()){

	       			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarMunicipiosUsuario: entrando");

	       		}    		

	     		tablaMunicipiosUsuarios = new Q02bTablaBDQ021MS00(this.getConnection());

	     		    		

	 			for (int i=0;i<listaMunicipios.size();i++){

//	 			 primero recuperamos el nmero interno que le corresponde

	 				idMuniUsu = dameSeqNiUsuMuni(tablaMunicipiosUsuarios);

	 				tablaMunicipiosUsuarios.setQ021MT00_ID(idMuniUsu);

	 				tablaMunicipiosUsuarios.setQ022FT00_IDUSUARIO(new Integer(idUsuario));

	 				tablaMunicipiosUsuarios.setFCA02T00_CODMUNICIP((String) listaMunicipios.get(i));

	 				tablaMunicipiosUsuarios.setFCA02T00_CODPROVINC(codProvincia);	 	      		

	 	      		//se realiza la insert

	 				tablaMunicipiosUsuarios.insert();

	 			}

	     	}catch(Exception ex){

	 	        java.io.StringWriter sw = new java.io.StringWriter();

	 	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	 	        ex.printStackTrace(pw);

	 	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarMunicipiosUsuario: " + sw.getBuffer ().toString());

	 	        throw ex;                     

	     	}finally{

	  		    try{

	  		    	tablaMunicipiosUsuarios.freeResourcesNotConnection();

	  		    }catch(Exception ex){

	 			   if (tr.isTraceActive()){

	 				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarMunicipiosUsuario: error liberando recursos");

	 	   	   	   }  

	  		    }  		  	       	

	 	        if (tr.isTraceActive()){

	 	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarMunicipiosUsuario: saliendo.");

	 	   		}

	     	}

	     } 

	    

	     private int dameSeqNiUsuMuni(Q02bTablaBDQ021MS00 tablaUsuMuni) throws Exception {

	 		int idUsuMuni = 1;

	 		ResultSet rs = null;

	 		PreparedStatement prepStmt = null;

	 		try {

	 			if (tr.isTraceActive()) {

	 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ ":dameSeqNiUsuMuni: entrando");

	 			}

	 			StringBuffer query = new StringBuffer(" SELECT Q021MQ00.NEXTVAL FROM DUAL ");

	 			prepStmt = this.getConnection().prepareStatement(query.toString());

	 			rs = prepStmt.executeQuery();

	 			tablaUsuMuni.addResultSet(rs);

	 			tablaUsuMuni.addStatement(prepStmt);

	 			if (rs.next()) {

	 				idUsuMuni = rs.getInt(1);

	 			}

	 			return idUsuMuni;

	 		} catch (Exception ex) {

	 			java.io.StringWriter sw = new java.io.StringWriter();

	 			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	 			ex.printStackTrace(pw);

	 			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":dameSeqNiUsuMuni: " + sw.getBuffer().toString());

	 			throw ex;

	 		}

	 	}// dameSeqNiUsuMuni

	     

	     

	     /**

	      * Mtodo que borra los municipios asignados a un usuario determinado.

	      * @param idUsuario

	      * @throws Exception

	      */

	     public void borrarMunicipiosUsuario(String idUsuario) throws Exception{

	     	Q02bTablaBDQ021MS00 tablaBDUsuariosMunicipios = null;

	     	try{

	 	    	if (tr.isTraceActive()){

	 	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarMunicipiosUsuario: entrando");

	 	   		}

	 	    	tablaBDUsuariosMunicipios = new Q02bTablaBDQ021MS00(this.getConnection());



	 	    	tablaBDUsuariosMunicipios.setQ022FT00_IDUSUARIO_WHERE(new Integer(idUsuario));

	       		

	       		//se realiza la delete

	 	    	tablaBDUsuariosMunicipios.delete();

	       			      		

	      	}catch(Exception ex){   	   

	      		java.io.StringWriter sw = new java.io.StringWriter();

	      		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	      		ex.printStackTrace(pw);

	      		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarMunicipiosUsuario: " + sw.getBuffer ().toString());

	      		throw ex;

	      	}finally{

	      		try{

	      			tablaBDUsuariosMunicipios.freeResourcesNotConnection();	

	      		}catch(Exception ex){

	      			if (tr.isTraceActive()){

	      				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarMunicipiosUsuario: error liberando recursos");

	  		   	   	}  

	  			}  		

	  			if (tr.isTraceActive()){

	  				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarMunicipiosUsuario: saliendo");                

	             }       	

	      	}	

	     }//fin tablaBDUsuariosMunicipios 

	     

	     /**

	      * Mtodo que devuelve una lista con los grupos asignados a un usuario.

	      * @param idUsuario nmero interno del usuario.

	      * @return ArrayList con la lista de municipios encontrados

	      * @throws Exception

	      */

	     public ArrayList obtenerMunicipiosSeleccionados(String idUsuario) throws Exception{

	     	//Q02bTablaBDQ021JS00 tablaBDUsuariosGrupos = null;

	     	Q02bTablaBDQ021MS01V01 tablaBDMunicipios = null;

	     	ResultSet rs = null;

	     	//ResultSet rs2 = null;

	     	ArrayList listaMunicipiosSeleccionados = new ArrayList();

	     	

	     	try{

	 	    	if (tr.isTraceActive()){

	 	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerMunicipiosSeleccionados: entrando");

	 	   		}

	 	    	

	 	    	tablaBDMunicipios=new Q02bTablaBDQ021MS01V01(this.getConnection());

	 	    	tablaBDMunicipios.setQ022FT00_IDUSUARIO_WHERE(new Integer(idUsuario));

	 	    	rs=tablaBDMunicipios.select();

	 	    	while (rs.next()){

	       				Q02bCodigoValor municipio = new Q02bCodigoValor (rs.getString(Q02bTablaBDQ021MS01V01.NOMCOLUMN_ID),

	 	      					rs.getString(Q02bTablaBDQ021MS01V01.NOMCOLUMN_DS_O));

	       				listaMunicipiosSeleccionados.add(municipio);	 				

	 	    	}	 	    		

	       		return listaMunicipiosSeleccionados;

	      	}catch(Exception ex){   	   

	      		java.io.StringWriter sw = new java.io.StringWriter();

	      		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	      		ex.printStackTrace(pw);

	      		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerMunicipiosSeleccionados: " + sw.getBuffer ().toString());

	      		throw ex;

	      	}finally{

	      		try{

	      			tablaBDMunicipios.freeResourcesNotConnection();	

	      		}catch(Exception ex){

	      			if (tr.isTraceActive()){

	      				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerMunicipiosSeleccionados: error liberando recursos");

	  		   	   	}  

	  			}  		

	  			if (tr.isTraceActive()){

	  				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerMunicipiosSeleccionados: saliendo");                

	             }       	

	      	}	

	     }   

	     

	     

	     /**

	      * Mtodo que devuelve una lista con los municipios no asignados a un usuario.

	      * @param idUsuario nmero interno del usuario.

	      * @return ArrayList con la lista de grupos encontrados

	      * @throws Exception

	      */

	     public ArrayList obtenerMunicipiosNoSeleccionados(String idUsuario) throws Exception{

	    	

	    	//Q02bTablaBDQ021MS00 tablaBDUsuariosMunicipios = null;

	    	Q02bTablaBDQ022FS00 tablaUsuarios=null;

	     	ArrayList listaMunicipiosNoSeleccionados = new ArrayList();

	     	

	     	ResultSet rs = null;

	       	PreparedStatement prepStmt =null;	

	       	String codProvincia="";

	     	try{

	 	    	if (tr.isTraceActive()){

	 	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerMunicipiosNoSeleccionados: entrando");

	 	   		}

	 	    	

	 	    	//Recupero la provincia del usuario

	 	    	/*tablaBDUsuariosMunicipios=new Q02bTablaBDQ021MS00(this.getConnection());

	 	    	tablaBDUsuariosMunicipios.setQ022FT00_IDUSUARIO_WHERE(new Integer(idUsuario));

	 	    	rs=tablaBDUsuariosMunicipios.select();*/

	 	    	

//	 	    	Recupero la provincia del usuario

	 	    	tablaUsuarios=new Q02bTablaBDQ022FS00(this.getConnection());

	 	    	tablaUsuarios.setQ022FT00_IDUSUARIO_WHERE(new Integer(idUsuario));

	 	    	rs=tablaUsuarios.select();	 	    	

	 	    	if(rs.next()){

	 	    		    //codProvincia=rs.getString(Q02bTablaBDQ021MS00.NOMCOLUMN_FCA02T00_CODPROVINC);

	 	    		    codProvincia=rs.getString(Q02bTablaBDQ022FS00.NOMCOLUMN_MUN_PROV);

			 	    	//SELECT * FROM NORA_T17_MUNICIPIO WHERE PROVINCIA_ID=48 AND ID NOT IN

			 	    	//(SELECT FCA02T00_CODMUNICIP FROM Q021MT00 WHERE Q022FT00_IDUSUARIO=59)

	 	    		    

	 	    		    //Si no tiene provincia asociada, es que ve todas las provincias y todos los municipios

	 	    		    if (codProvincia!= null&& !codProvincia.equals(""))

	 	    		    {

					 	    	StringBuffer where = new StringBuffer();

					 	    	where.append("SELECT ID, DS_O, PROVINCIA_ID, COMARCA_ID FROM NORA_T17_MUNICIPIO WHERE PROVINCIA_ID=").append(codProvincia)

					 	    	.append(" AND ID NOT IN(SELECT FCA02T00_CODMUNICIP FROM Q021MT00 WHERE Q022FT00_IDUSUARIO=")

					 	    	.append(idUsuario).append(") order by ds_o");

					 	    		 

					 	    	//Aadimos la opcion de TODOS

		//			 	    	si entre los municipios a metido TODOS			

								String codtodos  =Q02bConstantes.getString("municipios.todos");						

								String sTodos=Q70GestorMensajesi18n.getSingleton().getMessage("q02brecursosCuestionarios","comun.todos",this.getIdioma());

					 	    	Q02bCodigoValor usuarioT = new Q02bCodigoValor (codtodos,

					 	    			sTodos.toUpperCase());

				         		listaMunicipiosNoSeleccionados.add(usuarioT);

					 	    	

					 	    	//StringBuffer query = new StringBuffer(" SELECT * FROM  ");

					         	prepStmt = this.getConnection().prepareStatement(where.toString());         	

					         	rs = prepStmt.executeQuery();

					         	while(rs.next())

					         	{

					         		Q02bCodigoValor usuario = new Q02bCodigoValor (rs.getString("ID"),

				 	      					rs.getString("DS_O"));

					         		listaMunicipiosNoSeleccionados.add(usuario);

					         	

					         	}

	 	    		    }

			         	

			         	

	 	    	}

	       		return listaMunicipiosNoSeleccionados;

	      	}catch(Exception ex){   	   

	      		java.io.StringWriter sw = new java.io.StringWriter();

	      		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	      		ex.printStackTrace(pw);

	      		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerMunicipiosNoSeleccionados: " + sw.getBuffer ().toString());

	      		throw ex;

	      	}finally{

	      		try{

	      			tablaUsuarios.freeResourcesNotConnection();

	      			//tablaBDUsuariosMunicipios.freeResourcesNotConnection();	

	      		}catch(Exception ex){

	      			if (tr.isTraceActive()){

	      				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerMunicipiosNoSeleccionados: error liberando recursos");

	  		   	   	}  

	  			}  	

	  			if (tr.isTraceActive()){

	  				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerMunicipiosNoSeleccionados: saliendo");                

	             }       	

	      	}	

	     }

	     

	     

}

