package q02b.exe.seguridad.dataobjects;



import java.sql.Connection;

import java.sql.ResultSet;

import java.util.ArrayList;

import java.util.Date;



import q02b.exe.arquitectura.dataobjects.Q02bDataBaseDAO;

import q02b.exe.plazos.valueobjects.Q02bPlazos;

import q02b.exe.seguridad.valueobjects.Q02bUsuario;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022AS00;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022FS00;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022FS01V01;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ021FS01V02;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022FS01V02;

import q02b.exe.utils.Q02bFormatData;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

public class Q02bSeguridadDataBaseDAO extends Q02bDataBaseDAO{

	

	private static final long serialVersionUID = -8520551641771839103L;



	public Q02bSeguridadDataBaseDAO() {

        super();                

    }



    

    public Q02bSeguridadDataBaseDAO(Connection conn) {

    	super(conn);     

    }

    

    /**

     * Mtodo que rellena un objeto Q02bUsuario a partir de una fila obtenida de bbdd.

     * @param rs ResultSet con la tupla.

     * @return

     * @throws Exception

     */

    public Q02bUsuario rellenaVOUsuario(ResultSet rs) throws Exception {

    	Q02bUsuario usuario = new Q02bUsuario();

    	  

    	try{

    		

    		if (tr.isTraceActive()){

		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaVOUsuario: entrando");                

		    } 

    		

    		usuario.setId(rs.getString(Q02bTablaBDQ022FS01V01.NOMCOLUMN_Q022FT00_IDUSUARIO));

    		usuario.setPass(rs.getString(Q02bTablaBDQ022FS01V01.NOMCOLUMN_Q022FT00_PASSWORD));

    		usuario.setNombre(rs.getString(Q02bTablaBDQ022FS01V01.NOMCOLUMN_Q022FT00_NOMBRE));

    		usuario.setApellido1(rs.getString(Q02bTablaBDQ022FS01V01.NOMCOLUMN_Q022FT00_APELLIDO1));

    		usuario.setApellido2(rs.getString(Q02bTablaBDQ022FS01V01.NOMCOLUMN_Q022FT00_APELLIDO2));

    		usuario.setDni(rs.getString(Q02bTablaBDQ022FS01V01.NOMCOLUMN_Q022FT00_NIF));

    		usuario.setNiPerfil(rs.getString(Q02bTablaBDQ022FS01V01.NOMCOLUMN_Q021AT00_CODPERFIL));

    		usuario.setNiProvincia(rs.getString(Q02bTablaBDQ022FS01V01.NOMCOLUMN_MUN_PROV));

    		usuario.setDescProvincia(rs.getString(Q02bTablaBDQ022FS01V01.NOMCOLUMN_DESC_PROV ));

    		usuario.setNiMunicipio(rs.getString(Q02bTablaBDQ022FS01V01.NOMCOLUMN_MUN_MUNI));

    		usuario.setDescMunicipio(rs.getString(Q02bTablaBDQ022FS01V01.COLUMN_DESC_MUNI));

    		usuario.setFechaActivacion(rs.getString(Q02bTablaBDQ022FS01V01.NOMCOLUMN_Q022FT00_FECHA_ACTIVACION));

    		usuario.setFechaDesactivacion(rs.getString(Q02bTablaBDQ022FS01V01.NOMCOLUMN_Q022FT00_FECHA_DESACTIVACION));

    		

    		

    		return usuario;

    	}catch(Exception ex){    	 	   

  	       java.io.StringWriter sw = new java.io.StringWriter();

  	       java.io.PrintWriter pw = new java.io.PrintWriter(sw);

  	       ex.printStackTrace(pw);

  	       tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenaVOUsuario: " + sw.getBuffer ().toString());

  	       throw ex;

  		}finally{			 	

  			if (tr.isTraceActive()){

  		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaVOUsuario: saliendo");                

  		    }    				

  		}

    }

    

    /**

     * Mtodo que obtiene los datos de un usuario a partir de su id.

     * @param idUsuario identificador de usuario.

     * @return Q02bUsuario con los datos del usuario.

     * @throws Exception

     */

    public Q02bUsuario obtenerUsuario (String dniUsuario) throws Exception {

    	Q02bTablaBDQ022FS01V01 tablaBDUsuarios = null;

    	ResultSet rs = null;

    	   

    	try{

    		if (tr.isTraceActive()){

     			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerUsuario: entrando "+ dniUsuario);     			

     		}

    		

    		tablaBDUsuarios = new Q02bTablaBDQ022FS01V01(this.getConnection());

    		

    		tablaBDUsuarios.setQ022FT00_NIF_WHERE(dniUsuario);

    		tablaBDUsuarios.setAditionalWhere (" and " +  Q02bTablaBDQ022FS00.NOMCOLUMN_Q022FT00_FECHA_ACTIVACION + " <= SYSDATE AND ( " + Q02bTablaBDQ022FS00.NOMCOLUMN_Q022FT00_FECHA_DESACTIVACION + " IS NULL OR " + Q02bTablaBDQ022FS00.NOMCOLUMN_Q022FT00_FECHA_DESACTIVACION + " >= SYSDATE )  ");

    		if (tr.isTraceActive()){

     			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerUsuario: WHERE "+ tablaBDUsuarios.getAditionalWhere());     			

     		}

    		rs = tablaBDUsuarios.select();     		

              

    		tablaBDUsuarios.addResultSet(rs);

    		if (rs.next()){

    			return this.rellenaVOUsuario(rs);

    		}else{ 

    			return null;

    		}

    		

    	}catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);  

            ex.printStackTrace(pw);

            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerUsuario: " + sw.getBuffer ().toString());

            throw ex;

   	 	}finally{

   	 		try{

   	 			tablaBDUsuarios.freeResourcesNotConnection();	

   	 		}catch(Exception ex){

   	 			if (tr.isTraceActive()){

   	 				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerUsuario: error liberando recursos");

   	 			}  

   	 		}  		

   	 		if (tr.isTraceActive()){

   	 			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerUsuario: saliendo");                

   	 		}           

   	 	}      	

    }

    

    

    /**

     * Mtodo que obtiene los datos de un usuario a partir de su id.

     * @param idUsuario identificador de usuario.

     * @return Q02bUsuario con los datos del usuario.

     * @throws Exception

     */

    public ArrayList obtenerPlazos(int anyo, String niProvincia ,String niMunicipio) throws Exception {

    	Q02bTablaBDQ022AS00 tablaBDPlazos = null;

    	ArrayList listaPlazos = new ArrayList();    	

    	ResultSet rs = null;    	   

    	try{

    		if (tr.isTraceActive()){

     			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerPlazos: entrando "+ niProvincia);     			

     		}

    		

    		tablaBDPlazos = new Q02bTablaBDQ022AS00(this.getConnection());

    		if ( anyo != 0){

    			tablaBDPlazos.setQ022AT00_ANO_WHERE(anyo);

    		}else{

    			Date fechaHoy = new Date();

    			tablaBDPlazos.setQ022AT00_ANO_WHERE(fechaHoy.getYear());

    		}

    		if (!Q02bFormatData.esNull(niProvincia).equals("")){

    			tablaBDPlazos.setMUN_PROV_WHERE(niProvincia);

    		}

    		if (!Q02bFormatData.esNull(niMunicipio).equals("")){

    			tablaBDPlazos.setMUN_MUNI_WHERE(niMunicipio);

    		}

    		rs = tablaBDPlazos.select();     		              

    		tablaBDPlazos.addResultSet(rs);    		  	

    		while (rs.next()){

    			Q02bPlazos plazo = new Q02bPlazos();

        		plazo.setProvincia(niProvincia);

        		plazo.setMunicipio(niMunicipio);  

        		plazo.setPlazo(rs.getString(Q02bTablaBDQ022AS00.NOMCOLUMN_Q022AT00_PLAZO));

        		plazo.setTipoCuestionario(rs.getString(Q02bTablaBDQ022AS00.NOMCOLUMN_Q022NT00_CODIGO));

        		listaPlazos.add(plazo);

        		

    		}

    		return listaPlazos;

    	}catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);  

            ex.printStackTrace(pw);

            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerUsuario: " + sw.getBuffer ().toString());

            throw ex;

   	 	}finally{

   	 		try{

   	 			tablaBDPlazos.freeResourcesNotConnection();	

   	 		}catch(Exception ex){

   	 			if (tr.isTraceActive()){

   	 				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerUsuario: error liberando recursos");

   	 			}  

   	 		}  		

   	 		if (tr.isTraceActive()){

   	 			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerUsuario: saliendo");                

   	 		}           

   	 	}      	

    }

    

   

    /**

     * Mtodo que obtiene el estado de un modulo a partir de un proceso (agentesJSP->agentes)

     * @param nombreProcMnto identificador del proceso (agentes)

     * @return String estado del modulo (activo/inactivo)

     * @throws Exception

     */

    public String obtenerEstadoModulo(String nombreProcMnto) throws Exception {

    

    	Q02bTablaBDQ021FS01V02 vistaModulo=null;

    	ResultSet rs = null;

    	   

    	try{

    		if (tr.isTraceActive()){

     			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerEstadoModulo: entrando "+ nombreProcMnto);     			

     		}

    		

    		vistaModulo=new Q02bTablaBDQ021FS01V02(this.getConnection());

    		vistaModulo.setQ021FT00_COD_WHERE(nombreProcMnto);

    		rs=vistaModulo.select();

    		vistaModulo.addResultSet(rs);

    		if (rs.next()){

    			return rs.getString(Q02bTablaBDQ021FS01V02.COLUMN_Q021ET00_IND_INACTIVO);

    		}else{ 

    			return null;

    		}

    	}catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);  

            ex.printStackTrace(pw);

            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerEstadoModulo: " + sw.getBuffer ().toString());

            throw ex;

   	 	}finally{

   	 		try{

   	 			vistaModulo.freeResourcesNotConnection();   	 			

   	 		}catch(Exception ex){

   	 			if (tr.isTraceActive()){

   	 				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerEstadoModulo: error liberando recursos");

   	 			}  

   	 		}  		

   	 		if (tr.isTraceActive()){

   	 			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerEstadoModulo: saliendo");                

   	 		}           

   	 	}      	

    }

    

    /**

     * Mtodo que comprueba el acceso de un usuario a un proceso

     * @param nombreProcMnto identificador del proceso (agentes)

     * @param idUsuario, identificativo del usuario

     * @return boolean true si tiene acceso, false en caso contrario

     * @throws Exception

     */

    public boolean esProcesoPermitido(String niUsuario,String nombreProcMnto) throws Exception {

    	//

    	Q02bTablaBDQ022FS01V02 vistaUsuProc=null;

    	ResultSet rs = null;

    	   

    	try{

    		if (tr.isTraceActive()){

     			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":esProcesoPermitido: entrando "+ nombreProcMnto);     			

     		}

    		

    		vistaUsuProc=new Q02bTablaBDQ022FS01V02(this.getConnection());

    		vistaUsuProc.setQ022FT00_IDUSUARIO_WHERE(Integer.parseInt(niUsuario));

    		vistaUsuProc.setQ021FT00_COD_WHERE(nombreProcMnto);

    		rs=vistaUsuProc.select();

    		vistaUsuProc.addResultSet(rs);

    		if (rs.next()){

    			return true;//rs.getString(Q02bTablaBDQ021FS01V02.COLUMN_Q021ET00_IND_INACTIVO);

    		}else{ 

    			return false;

    		}

    	}catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);  

            ex.printStackTrace(pw);

            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":esProcesoPermitido: " + sw.getBuffer ().toString());

            throw ex;

   	 	}finally{

   	 		try{

   	 		vistaUsuProc.freeResourcesNotConnection();   	 			

   	 		}catch(Exception ex){

   	 			if (tr.isTraceActive()){

   	 				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":esProcesoPermitido: error liberando recursos");

   	 			}  

   	 		}  		

   	 		if (tr.isTraceActive()){

   	 			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":esProcesoPermitido: saliendo");                

   	 		}           

   	 	}      	

    }

    



    

}